/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.viewer.AminoPolymer;
import org.jmol.viewer.Helix;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.ProteinStructure;
import org.jmol.viewer.Rockets;
import org.jmol.viewer.Sheet;

class RocketsRenderer
extends MpsRenderer {
    Point3i s0 = new Point3i();
    Point3i s1 = new Point3i();
    Point3i s2 = new Point3i();
    Point3i s3 = new Point3i();
    int diameterBeg;
    int diameterMid;
    int diameterEnd;
    Rockets cartoon;
    int monomerCount;
    Monomer[] monomers;
    Point3i[] screens;
    boolean[] isSpecials;
    Point3f[] cordMidPoints;
    final Point3i screenA = new Point3i();
    Point3i screenB = new Point3i();
    Point3i screenC = new Point3i();
    boolean tPending;
    ProteinStructure proteinstructurePending;
    int startIndexPending;
    int endIndexPending;
    short madPending;
    short colixPending;
    int[] shadesPending;
    final Point3f pointTipOffset = new Point3f();
    final Point3f pointArrow2 = new Point3f();
    final Vector3f vectorNormal = new Vector3f();
    final Vector3f scaledWidthVector = new Vector3f();
    final Vector3f scaledHeightVector = new Vector3f();
    static final byte[] arrowHeadFaces = new byte[]{0, 1, 3, 2, 0, 4, 5, 2, 1, 4, 5, 3};
    final Vector3f lengthVector = new Vector3f();
    final Point3f pointCorner = new Point3f();
    static final byte[] boxFaces = new byte[]{0, 1, 3, 2, 0, 2, 6, 4, 0, 4, 5, 1, 7, 5, 4, 6, 7, 6, 2, 3, 7, 3, 1, 5};
    final Point3f[] corners = new Point3f[8];
    final Point3f[] screenCorners = new Point3f[8];

    RocketsRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.screenCorners[i] = new Point3f();
            this.corners[i] = new Point3f();
        }
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer) {
        Rockets.Cchain cchain = (Rockets.Cchain)mpspolymer;
        this.render1Chain(cchain.polymer, cchain.mads, cchain.colixes);
    }

    void render1Chain(Polymer polymer, short[] mads, short[] colixes) {
        if (!(polymer instanceof AminoPolymer)) {
            return;
        }
        this.initializeChain((AminoPolymer)polymer);
        this.clearPending();
        for (int i = 0; i < this.monomerCount; ++i) {
            if (mads[i] == 0) continue;
            short colix = colixes[i];
            Monomer monomer = this.monomers[i];
            if (colix == 0) {
                colix = monomer.getLeadAtom().colixAtom;
            }
            if (monomer.isHelixOrSheet()) {
                this.renderSpecialSegment(monomer, colix, mads[i]);
                continue;
            }
            this.renderRopeSegment(colix, mads, i, this.monomerCount, this.monomers, this.screens, this.isSpecials);
        }
        this.renderPending();
        this.viewer.freeTempScreens(this.screens);
        this.viewer.freeTempPoints(this.cordMidPoints);
        this.viewer.freeTempBooleans(this.isSpecials);
    }

    void initializeChain(AminoPolymer aminopolymer) {
        this.monomers = aminopolymer.monomers;
        this.monomerCount = aminopolymer.monomerCount;
        this.isSpecials = this.calcIsSpecials(this.monomerCount, this.monomers);
        this.cordMidPoints = this.calcRopeMidPoints(aminopolymer);
        this.screens = this.getScreens();
    }

    Point3f[] calcRopeMidPoints(AminoPolymer aminopolymer) {
        Point3f point;
        int midPointCount = this.monomerCount + 1;
        Point3f[] cordMidPoints = this.viewer.allocTempPoints(midPointCount);
        ProteinStructure proteinstructurePrev = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            point = cordMidPoints[i];
            Monomer residue = this.monomers[i];
            if (this.isSpecials[i]) {
                ProteinStructure proteinstructure = residue.getProteinStructure();
                point.set(i - 1 != proteinstructure.getMonomerIndex() ? proteinstructure.getAxisStartPoint() : proteinstructure.getAxisEndPoint());
                proteinstructurePrev = proteinstructure;
                continue;
            }
            if (proteinstructurePrev != null) {
                point.set(proteinstructurePrev.getAxisEndPoint());
            } else {
                aminopolymer.getLeadMidPoint(i, point);
            }
            proteinstructurePrev = null;
        }
        point = cordMidPoints[this.monomerCount];
        if (proteinstructurePrev != null) {
            point.set(proteinstructurePrev.getAxisEndPoint());
        } else {
            aminopolymer.getLeadMidPoint(this.monomerCount, point);
        }
        return cordMidPoints;
    }

    Point3i[] getScreens() {
        int count = this.monomerCount + 1;
        Point3i[] screens = this.viewer.allocTempScreens(count);
        int i = count;
        while (--i >= 0) {
            this.viewer.transformPoint(this.cordMidPoints[i], screens[i]);
        }
        return screens;
    }

    void renderSpecialSegment(Monomer monomer, short colix, short mad) {
        ProteinStructure proteinstructure = monomer.getProteinStructure();
        if (this.tPending) {
            if (proteinstructure == this.proteinstructurePending && mad == this.madPending && colix == this.colixPending && proteinstructure.getIndex(monomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPending();
        }
        this.proteinstructurePending = proteinstructure;
        this.startIndexPending = this.endIndexPending = proteinstructure.getIndex(monomer);
        this.colixPending = colix;
        this.madPending = mad;
        this.tPending = true;
    }

    void clearPending() {
        this.tPending = false;
    }

    void renderPending() {
        if (this.tPending) {
            boolean tEnd;
            Point3f[] segments = this.proteinstructurePending.getSegments();
            boolean bl = tEnd = this.endIndexPending == this.proteinstructurePending.getMonomerCount() - 1;
            if (this.proteinstructurePending instanceof Helix) {
                this.renderPendingHelix(segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], tEnd);
            } else if (this.proteinstructurePending instanceof Sheet) {
                this.renderPendingSheet(segments[this.startIndexPending], segments[this.endIndexPending], segments[this.endIndexPending + 1], tEnd);
            } else {
                System.out.println("?Que? neither helix nor sheet");
            }
            this.tPending = false;
        }
    }

    void renderPendingHelix(Point3f pointStart, Point3f pointBeforeEnd, Point3f pointEnd, boolean tEnd) {
        this.viewer.transformPoint(pointStart, this.screenA);
        this.viewer.transformPoint(pointEnd, this.screenB);
        if (tEnd) {
            this.viewer.transformPoint(pointBeforeEnd, this.screenC);
            short capDiameter = this.viewer.scaleToScreen(this.screenC.z, this.madPending + (this.madPending >> 2));
            this.g3d.fillCone(this.colixPending, (byte)2, capDiameter, this.screenC, this.screenB);
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            Point3i t = this.screenB;
            this.screenB = this.screenC;
            this.screenC = t;
        }
        int zMid = (this.screenA.z + this.screenB.z) / 2;
        short diameter = this.viewer.scaleToScreen(zMid, this.madPending);
        this.g3d.fillCylinder(this.colixPending, (byte)2, diameter, this.screenA, this.screenB);
    }

    void renderPendingSheet(Point3f pointStart, Point3f pointBeforeEnd, Point3f pointEnd, boolean tEnd) {
        this.shadesPending = this.g3d.getShades(this.colixPending);
        if (tEnd) {
            this.drawArrowHeadBox(pointBeforeEnd, pointEnd);
            this.drawBox(pointStart, pointBeforeEnd);
        } else {
            this.drawBox(pointStart, pointEnd);
        }
    }

    void drawArrowHeadBox(Point3f base, Point3f tip) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float scale = (float)this.madPending / 1000.0f;
        this.scaledWidthVector.set(sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(scale * 1.25f);
        this.scaledHeightVector.set(sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(scale / 3.0f);
        this.pointCorner.add(this.scaledWidthVector, this.scaledHeightVector);
        this.pointCorner.scaleAdd(-0.5f, base);
        this.pointTipOffset.set(this.scaledHeightVector);
        this.pointTipOffset.scaleAdd(-0.5f, tip);
        this.buildArrowHeadBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.pointTipOffset);
        this.calcSurfaceArgb(0, 1, 4);
        this.g3d.fillTriangle(this.colixPending, this.screenCorners[0], this.screenCorners[1], this.screenCorners[4]);
        this.g3d.fillTriangle(this.colixPending, this.screenCorners[2], this.screenCorners[3], this.screenCorners[5]);
        for (int i = 0; i < 12; i += 4) {
            byte i0 = arrowHeadFaces[i];
            byte i1 = arrowHeadFaces[i + 1];
            byte i2 = arrowHeadFaces[i + 2];
            byte i3 = arrowHeadFaces[i + 3];
            this.calcSurfaceArgb(i0, i1, i3);
            this.g3d.fillQuadrilateral(this.colixPending, this.screenCorners[i0], this.screenCorners[i1], this.screenCorners[i2], this.screenCorners[i3]);
        }
    }

    void drawBox(Point3f pointA, Point3f pointB) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float scale = (float)this.madPending / 1000.0f;
        this.scaledWidthVector.set(sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(scale);
        this.scaledHeightVector.set(sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(scale / 4.0f);
        this.pointCorner.add(this.scaledWidthVector, this.scaledHeightVector);
        this.pointCorner.scaleAdd(-0.5f, pointA);
        this.lengthVector.sub(pointB, pointA);
        this.buildBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.lengthVector);
        for (int i = 0; i < 6; ++i) {
            byte i0 = boxFaces[i * 4];
            byte i1 = boxFaces[i * 4 + 1];
            byte i2 = boxFaces[i * 4 + 2];
            byte i3 = boxFaces[i * 4 + 3];
            this.calcSurfaceArgb(i0, i1, i3);
            this.g3d.fillQuadrilateral(this.colixPending, this.screenCorners[i0], this.screenCorners[i1], this.screenCorners[i2], this.screenCorners[i3]);
        }
    }

    int calcSurfaceArgb(int iA, int iB, int iC) {
        return this.shadesPending[this.viewer.calcSurfaceIntensity(this.corners[iA], this.corners[iB], this.corners[iC])];
    }

    void buildBox(Point3f pointCorner, Vector3f scaledWidthVector, Vector3f scaledHeightVector, Vector3f lengthVector) {
        int i = 8;
        while (--i >= 0) {
            Point3f corner = this.corners[i];
            corner.set(pointCorner);
            if ((i & 1) != 0) {
                corner.add(scaledWidthVector);
            }
            if ((i & 2) != 0) {
                corner.add(scaledHeightVector);
            }
            if ((i & 4) != 0) {
                corner.add(lengthVector);
            }
            this.viewer.transformPoint(corner, this.screenCorners[i]);
        }
    }

    void buildArrowHeadBox(Point3f pointCorner, Vector3f scaledWidthVector, Vector3f scaledHeightVector, Point3f pointTip) {
        int i = 4;
        while (--i >= 0) {
            Point3f corner = this.corners[i];
            corner.set(pointCorner);
            if ((i & 1) != 0) {
                corner.add(scaledWidthVector);
            }
            if ((i & 2) != 0) {
                corner.add(scaledHeightVector);
            }
            this.viewer.transformPoint(corner, this.screenCorners[i]);
        }
        this.corners[4].set(pointTip);
        this.viewer.transformPoint(pointTip, this.screenCorners[4]);
        this.corners[5].add(pointTip, scaledHeightVector);
        this.viewer.transformPoint(this.corners[5], this.screenCorners[5]);
    }
}

