# The LearningOnline Network
# checks for a cokkie to authenticate a user
#
# $Id: checkauthen.pm,v 1.11 2007/04/11 21:36:58 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::checkauthen;

use strict;
use Apache::Constants qw(:common);
use Apache::lonnet;

sub handler {
    my ($r) = @_;

    if (&Apache::lonnet::is_domainimage($r->uri)) {
        return OK;
    }

    if ($r->auth_type() ne 'LONCAPA') {
	return DECLINED;
    }
    my $fail = FORBIDDEN; 
    if ($r->dir_config('lonOtherAuthen') eq 'yes') {
	if (defined($r->dir_config('lonOtherAuthenType'))) {
            $r->auth_type($r->dir_config('lonOtherAuthenType'));
        }
	#&Apache::lonnet::logthis("other authen");
	$fail = DECLINED;
    }

    if ($env{'user.name'} eq 'public' 
	&& $env{'user.domain'} eq 'public') {
	if ($env{'request.publicaccess'} ) {
	    return OK;
	} else {
	    return $fail;
	}
    }

    my %cookies=CGI::Cookie->parse($r->header_in('Cookie'));
    my $lonid=$cookies{'lonID'};
    my $handle;
    if ($lonid) {
      	$handle=&LONCAPA::clean_handle($lonid->value);
        $handle = $r->dir_config('lonIDsDir')."/$handle.id";
    } else {
        $handle = $env{'user.environment'};
    }

    if (($handle ne '') && (-e $handle)) {
        return OK;
    }

    return $fail;
}

1;
