# The LearningOnline Network with CAPA
# Interface routines to MAXIMA CAS
#
# $Id: lonmaxima.pm,v 1.13 2007/04/19 17:40:43 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
 
package Apache::lonmaxima;
 
use strict;
use IO::Socket;
use Apache::lonnet;
use Apache::response();
use LONCAPA;

sub connect {
   return IO::Socket::UNIX->new(Peer    => $Apache::lonnet::perlvar{'lonSockDir'}.'/maximasock',
				Type    => SOCK_STREAM,
				Timeout => 10);
}

sub disconnect {
    my ($socket)=@_;
    if ($socket) { close($socket); }
}

sub maximareply {
    my ($socket,$cmd)=@_;
    if ($socket) {
	print $socket &escape($cmd)."\n";
        my $reply=<$socket>;
        chomp($reply);
        if ($reply=~/^Incorrect/) { $reply='Error: '.$reply; }
        return &unescape($reply);
    } else {
        return 'Error: no connection.';
    }
}

sub blacklisted {
    my ($cmd)=@_;
    foreach my $forbidden ('save','load','plot','lisp','includ','compil','file','batch','stringout','translat','stout','stin','block','system') {
	if ($cmd=~/$forbidden/s) { return 1; }
    } 
    return 0;
}

sub runscript {
    my ($socket,$fullscript)=@_;
    if (&blacklisted($fullscript)) { return 'Error: blacklisted'; }
    my $reply;
    $fullscript=~s/[\n\r\l]//gs;
    foreach my $line (split(/\;/s,$fullscript)) {
	if ($line=~/\w/) { $reply=&maximareply($socket,$line.";\n"); }
	if ($reply=~/^Error\:/) { return $reply; }
    }
    $reply=~s/\W//gs;
    return $reply;
}

sub maxima_cas_formula_fix {
   my ($expression)=@_;
   return &Apache::response::implicit_multiplication($expression);
}

sub maxima_run {
    my ($script,$submission,$argument) = @_;
    my $socket=&connect();
    my @submissionarray=split(/\s*\,\s*/,$submission);
    for (my $i=0;$i<=$#submissionarray;$i++) {
        my $n=$i+1;
        my $fixedsubmission=&maxima_cas_formula_fix($submissionarray[$i]);
        $script=~s/RESPONSE\[$n\]/$fixedsubmission/gs;
    }
    my @argumentarray=@{$argument};
    for (my $i=0;$i<=$#argumentarray;$i++) {
        my $n=$i+1;
        my $fixedargument=&maxima_cas_formula_fix($argumentarray[$i]);
        $script=~s/LONCAPALIST\[$n\]/$fixedargument/gs;
    }
    my $reply=&runscript($socket,$script);
    &disconnect($socket);
    if ($reply=~/^\s*true\s*$/i) { return 'EXACT_ANS'; }
    if ($reply=~/^\s*false\s*$/i) { return 'INCORRECT'; } 
    return 'BAD_FORMULA';
}

sub maxima_eval {
    my ($script) = @_;
    my $socket=&connect();
    my $reply=&runscript($socket,$script);
    &disconnect($socket);
    return $reply;
}


sub compareterms {
    my ($socket,$terma,$termb)=@_;
    my $difference=$terma.'-'.$termb;
    if (&blacklisted($difference)) { return 'Error: blacklisted'; }
    my $reply=&maximareply($socket,'trigsimp(trigreduce('.$difference.'));');
    if ($reply=~/^\s*0\s*$/) { return 'true'; }
    if ($reply=~/^Error\:/) { return $reply; }
    return 'false';
}

sub maxima_check {
    my ($response,$answer,$reterror) = @_;
    my $socket=&connect();
    my $reply=&compareterms($socket,$response,$answer);
    &disconnect($socket);
    if ($reply eq 'true') { return 1; }
    return 7;
}
 
1;
__END__;
