# The LearningOnline Network
# Documents
#
# $Id: londocs.pm,v 1.273 2007/05/22 00:38:25 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::londocs;

use strict;
use Apache::Constants qw(:common :http);
use Apache::imsexport;
use Apache::lonnet;
use Apache::loncommon;
use LONCAPA::map();
use Apache::lonratedt();
use Apache::lonxml;
use Apache::lonclonecourse;
use Apache::lonnavmaps;
use HTML::Entities;
use GDBM_File;
use Apache::lonlocal;
use Cwd;
use LONCAPA qw(:DEFAULT :match);

my $iconpath;

my %hash;

my $hashtied;
my %alreadyseen=();

my $hadchanges;

# Available help topics

my %help=();

# Mapread read maps into LONCAPA::map:: global arrays 
# @order and @resources, determines status
# sets @order - pointer to resources in right order
# sets @resources - array with the resources with correct idx
#

sub mapread {
    my ($coursenum,$coursedom,$map)=@_;
    return
      &LONCAPA::map::mapread('/uploaded/'.$coursedom.'/'.$coursenum.'/'.
			     $map);
}

sub storemap {
    my ($coursenum,$coursedom,$map)=@_;
    my ($outtext,$errtext)=
      &LONCAPA::map::storemap('/uploaded/'.$coursedom.'/'.$coursenum.'/'.
			      $map,1);
    if ($errtext) { return ($errtext,2); }
    
    $hadchanges=1;
    return ($errtext,0);
}

# ----------------------------------------- Return hash with valid author names

sub authorhosts {
    my %outhash=();
    my $home=0;
    my $other=0;
    foreach (keys %env) {
	if ($_=~/^user\.role\.(au|ca)\.(.+)$/) {
	    my $role=$1;
	    my $realm=$2;
	    my ($start,$end)=split(/\./,$env{$_});
	    if (($start) && ($start>time)) { next; }
	    if (($end) && (time>$end)) { next; }
	    my $ca; my $cd;
	    if ($1 eq 'au') {
		$ca=$env{'user.name'};
		$cd=$env{'user.domain'};
	    } else {
		($cd,$ca)=($realm=~/^\/($match_domain)\/($match_username)$/);
	    }
	    my $allowed=0;
	    my $myhome=&Apache::lonnet::homeserver($ca,$cd);
	    my @ids=&Apache::lonnet::current_machine_ids();
	    foreach my $id (@ids) { if ($id eq $myhome) { $allowed=1; } }
	    if ($allowed) {
		$home++;
		$outhash{'home_'.$ca.'@'.$cd}=1;
	    } else {
		$outhash{'otherhome_'.$ca.'@'.$cd}=$myhome;
		$other++;
	    }
	}
    }
    return ($home,$other,%outhash);
}
# ------------------------------------------------------ Generate "dump" button

sub dumpbutton {
    my ($home,$other,%outhash)=&authorhosts();
    my $type = &Apache::loncommon::course_type();
    if ($home+$other==0) { return ''; }
    my $output='</td><td bgcolor="#DDDDCC">';
    if ($home) {
	return '</td><td bgcolor="#DDDDCC">'.
	    '<input type="submit" name="dumpcourse" value="'.
	    &mt('Dump '.$type.' DOCS to Construction Space').'" />'.
	    &Apache::loncommon::help_open_topic('Docs_Dump_Course_Docs');
    } else {
	return'</td><td bgcolor="#DDDDCC">'.
     &mt('Dump '.$type.
	 ' DOCS to Construction Space: available on other servers');
    }
}

sub clean {
    my ($title)=@_;
    $title=~s/[^\w\/\!\$\%\^\*\-\_\=\+\;\:\,\\\|\`\~]+/\_/gs;
    return $title;	
}
# -------------------------------------------------------- Actually dump course

sub dumpcourse {
    my ($r) = @_;
    my $type = &Apache::loncommon::course_type();
    $r->print(&Apache::loncommon::start_page('Dump '.$type.' DOCS to Construction Space').
	      '<form name="dumpdoc" method="post">');
    $r->print(&Apache::lonhtmlcommon::breadcrumbs('Dump '.$type.' DOCS to Construction Space'));
    my ($home,$other,%outhash)=&authorhosts();
    unless ($home) { return ''; }
    my $origcrsid=$env{'request.course.id'};
    my %origcrsdata=&Apache::lonnet::coursedescription($origcrsid);
    if (($env{'form.authorspace'}) && ($env{'form.authorfolder'}=~/\w/)) {
# Do the dumping
	unless ($outhash{'home_'.$env{'form.authorspace'}}) { return ''; }
	my ($ca,$cd)=split(/\@/,$env{'form.authorspace'});
	$r->print('<h3>'.&mt('Copying Files').'</h3>');
	my $title=$env{'form.authorfolder'};
	$title=&clean($title);
	my %replacehash=();
	foreach (keys %env) {
	    if ($_=~/^form\.namefor\_(.+)/) {
		$replacehash{$1}=$env{$_};
	    }
	}
	my $crs='/uploaded/'.$env{'request.course.id'}.'/';
	$crs=~s/\_/\//g;
	foreach (keys %replacehash) {
	    my $newfilename=$title.'/'.$replacehash{$_};
	    $newfilename=~s/\.(\w+)$//;
	    my $ext=$1;
	    $newfilename=&clean($newfilename);
	    $newfilename.='.'.$ext;
	    my @dirs=split(/\//,$newfilename);
	    my $path='/home/'.$ca.'/public_html';
	    my $makepath=$path;
	    my $fail=0;
	    for (my $i=0;$i<$#dirs;$i++) {
		$makepath.='/'.$dirs[$i];
		unless (-e $makepath) { 
		    unless(mkdir($makepath,0777)) { $fail=1; } 
		}
	    }
	    $r->print('<br /><tt>'.$_.'</tt> => <tt>'.$newfilename.'</tt>: ');
	    if (my $fh=Apache::File->new('>'.$path.'/'.$newfilename)) {
		if ($_=~/\.(sequence|page|html|htm|xml|xhtml)$/) {
		    print $fh &Apache::lonclonecourse::rewritefile(
         &Apache::lonclonecourse::readfile($env{'request.course.id'},$_),
				     (%replacehash,$crs => '')
								    );
		} else {
		    print $fh
         &Apache::lonclonecourse::readfile($env{'request.course.id'},$_);
		       }
		$fh->close();
	    } else {
		$fail=1;
	    }
	    if ($fail) {
		$r->print('<font color="red">fail</font>');
	    } else {
		$r->print('<font color="green">ok</font>');
	    }
	}
    } else {
# Input form
	unless ($home==1) {
	    $r->print(
		      '<h3>'.&mt('Select the Construction Space').'</h3><select name="authorspace">');
	}
	foreach (sort keys %outhash) {
	    if ($_=~/^home_(.+)$/) {
		if ($home==1) {
		    $r->print(
		  '<input type="hidden" name="authorspace" value="'.$1.'" />');
		} else {
		    $r->print('<option value="'.$1.'">'.$1.' - '.
			      &Apache::loncommon::plainname(split(/\@/,$1)).'</option>');
		}
	    }
	}
	unless ($home==1) {
	    $r->print('</select>');
	}
	my $title=$origcrsdata{'description'};
	$title=~s/[\/\s]+/\_/gs;
	$title=&clean($title);
	$r->print('<h3>'.&mt('Folder in Construction Space').'</h3><input type="text" size="50" name="authorfolder" value="'.$title.'" /><br />');
	&tiehash();
	$r->print('<h3>'.&mt('Filenames in Construction Space').'</h3><table border="2"><tr><th>'.&mt('Internal Filename').'</th><th>'.&mt('Title').'</th><th>'.&mt('Save as ...').'</th></tr>');
	foreach (&Apache::lonclonecourse::crsdirlist($origcrsid,'userfiles')) {
	    $r->print('<tr><td>'.$_.'</td>');
	    my ($ext)=($_=~/\.(\w+)$/);
	    my $title=$hash{'title_'.$hash{
		'ids_/uploaded/'.$origcrsdata{'domain'}.'/'.$origcrsdata{'num'}.'/'.$_}};
	    $r->print('<td>'.($title?$title:'&nbsp;').'</td>');
	    if (!$title) {
		$title=$_;
	    } else {
		$title=~s|/|_|g;
	    }
	    $title=~s/\.(\w+)$//;
	    $title=&clean($title);
	    $title.='.'.$ext;
	    $r->print("\n<td><input type='text' size='60' name='namefor_".$_."' value='".$title."' /></td></tr>\n");
	}
	$r->print("</table>\n");
	&untiehash();
	$r->print(
  '<p><input type="submit" name="dumpcourse" value="'.&mt('Dump [_1] DOCS',$type).'" /></p></form>');
    }
}

# ------------------------------------------------------ Generate "export" button

sub exportbutton {
    my $type = &Apache::loncommon::course_type();
    return '</td><td bgcolor="#DDDDCC">'.
            '<input type="submit" name="exportcourse" value="'.
            &mt('Export '.$type.' to IMS').'" />'.
    &Apache::loncommon::help_open_topic('Docs_Export_Course_Docs');
}

sub exportcourse {
    my $r=shift;
    my $type = &Apache::loncommon::course_type();
    my %discussiontime = &Apache::lonnet::dump('discussiontimes',
                                               $env{'course.'.$env{'request.course.id'}.'.domain'}, $env{'course.'.$env{'request.course.id'}.'.num'});
    my $numdisc = keys %discussiontime;
    my $navmap = Apache::lonnavmaps::navmap->new();
    my $it=$navmap->getIterator(undef,undef,undef,1,undef,undef);
    my $curRes;
    my $outcome;

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['finishexport']);
    if ($env{'form.finishexport'}) {
        &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['archive','discussion']);

        my @exportitems = &Apache::loncommon::get_env_multiple('form.archive');
        my @discussions = &Apache::loncommon::get_env_multiple('form.discussion');
        if (@exportitems == 0 && @discussions == 0) {
            $outcome = '<br />As you did not select any content items or discussions for export, an IMS package has not been created.  Please <a href="javascript:history.go(-1)">go back</a> to select either content items or discussions for export';
        } else {
            my $now = time;
            my %symbs;
            my $manifestok = 0;
            my $imsresources;
            my $tempexport;
            my $copyresult;
            my $ims_manifest = &create_ims_store($now,\$manifestok,\$outcome,\$tempexport);
            if ($manifestok) {
                &build_package($now,$navmap,\@exportitems,\@discussions,\$outcome,$tempexport,\$copyresult,$ims_manifest);
                close($ims_manifest);

#Create zip file in prtspool
                my $imszipfile = '/prtspool/'.
                $env{'user.name'}.'_'.$env{'user.domain'}.'_'.
                   time.'_'.rand(1000000000).'.zip';
                my $cwd = &Cwd::getcwd();
                my $imszip = '/home/httpd/'.$imszipfile;
                chdir $tempexport;
                open(OUTPUT, "zip -r $imszip *  2> /dev/null |");
                close(OUTPUT);
                chdir $cwd;
                $outcome .= &mt('Download the zip file from <a href="[_1]">IMS '.lc($type).' archive</a><br />',$imszipfile,);
                if ($copyresult) {
                    $outcome .= 'The following errors occurred during export - '.$copyresult;
                }
            } else {
                $outcome = '<br />Unfortunately you will not be able to retrieve an IMS archive of this posts at this time, because there was a problem creating a manifest file.<br />';
            }
        }
        $r->print(&Apache::loncommon::start_page('Export '.lc($type).' to IMS content package'));
	$r->print(&Apache::lonhtmlcommon::breadcrumbs('Export '.lc($type).' to IMS content package'));
        $r->print($outcome);
        $r->print(&Apache::loncommon::end_page());
    } else {
        my $display;
        $display = '<form name="exportdoc" method="post">'."\n";
        $display .= &mt('Choose which items you wish to export from your '.$type.'.<br /><br />');
        $display .= '<table border="0" cellspacing="0" cellpadding="3">'.
                    '<tr><td><fieldset><legend>&nbsp;<b>Content items</b></legend>'.
                    '<input type="button" value="check all" '.
                    'onclick="javascript:checkAll(document.exportdoc.archive)" />'.
                    '&nbsp;&nbsp;<input type="button" value="uncheck all"'.
                    ' onclick="javascript:uncheckAll(document.exportdoc.archive)" /></fieldset></td>'.
                    '<td>&nbsp;</td><td>&nbsp;</td>'.
                    '<td align="right"><fieldset><legend>&nbsp;<b>Discussion posts'.
                    '</b></legend><input type="button" value="check all"'.
                    ' onclick="javascript:checkAll(document.exportdoc.discussion)" />'.
                    '&nbsp;&nbsp;<input type="button" value="uncheck all"'.
                    ' onclick="javascript:uncheckAll(document.exportdoc.discussion)" /></fieldset></td>'.
                    '</tr></table>';
        my $curRes;
        my $depth = 0;
        my $count = 0;
        my $boards = 0;
        my $startcount = 5;
        my %parent = ();
        my %children = ();
        my $lastcontainer = $startcount;
        my @bgcolors = ('#F6F6F6','#FFFFFF');
        $display .= '<table cellspacing="0"><tr>'.
            '<td><b>Export content item?<br /></b></td><td>&nbsp;</td><td align="right">'."\n";
        if ($numdisc > 0) {
            $display.='<b>Export&nbsp;discussion posts?</b>'."\n";
        }
        $display.='&nbsp;</td></tr>';
        while ($curRes = $it->next()) {
            if (ref($curRes)) {
                $count ++;
            }
            if ($curRes == $it->BEGIN_MAP()) {
                $depth++;
                $parent{$depth} = $lastcontainer;
            }
            if ($curRes == $it->END_MAP()) {
                $depth--;
                $lastcontainer = $parent{$depth};
            }
            if (ref($curRes)) {
                my $symb = $curRes->symb();
                my $ressymb = $symb;
                if ($ressymb =~ m|adm/($match_domain)/($match_username)/(\d+)/bulletinboard$|) {
                    unless ($ressymb =~ m|adm/wrapper/adm|) {
                        $ressymb = 'bulletin___'.$3.'___adm/wrapper/adm/'.$1.'/'.$2.'/'.$3.'/bulletinboard';
                    }
                }
                my $color = $count%2;
                $display .='<tr bgcolor='.$bgcolors[$color].'><td>'."\n".
                    '<input type="checkbox" name="archive" value="'.$count.'" ';
                if (($curRes->is_sequence()) || ($curRes->is_page())) {
                    my $checkitem = $count + $boards + $startcount;
                    $display .= 'onClick="javascript:propagateCheck('."'$checkitem'".')"';
                }
                $display .= ' />'."\n";
                for (my $i=0; $i<$depth; $i++) {
                    $display .= '<img src="/adm/lonIcons/whitespace1.gif" width="25" height="1" alt="" border="0" /><img src="/adm/lonIcons/whitespace1.gif" width="25" height="1" alt="" border="0" />'."\n";
                }
                if ($curRes->is_sequence()) {
                    $display .= '<img src="/adm/lonIcons/navmap.folder.open.gif">&nbsp;'."\n";
                    $lastcontainer = $count + $startcount + $boards;
                } elsif ($curRes->is_page()) {
                    $display .= '<img src="/adm/lonIcons/navmap.page.open.gif">&nbsp;'."\n";
                    $lastcontainer = $count + $startcount + $boards;
                }
                my $currelem = $count+$boards+$startcount;
                $children{$parent{$depth}} .= $currelem.':';
                $display .= '&nbsp;'.$curRes->title().'</td>';
                if ($discussiontime{$ressymb} > 0) {
                    $boards ++;
                    $currelem = $count+$boards+$startcount;
                    $display .= '<td>&nbsp;</td><td align="right"><input type="checkbox" name="discussion" value="'.$count.'" />&nbsp;</td>'."\n";
                } else {
                    $display .= '<td colspan="2">&nbsp;</td>'."\n";
                }
            }
        }
        my $scripttag = qq|
<script>

function checkAll(field) {
    if (field.length > 0) {
        for (i = 0; i < field.length; i++) {
            field[i].checked = true ;
        }
    } else {
        field.checked = true
    }
}
                                                                                
function uncheckAll(field) {
    if (field.length > 0) {
        for (i = 0; i < field.length; i++) {
            field[i].checked = false ;
        }
    } else {
        field.checked = false ;
    }
}

function propagateCheck(item) {
    if (document.exportdoc.elements[item].checked == true) {
        containerCheck(item)
    }
} 

function containerCheck(item) {
    document.exportdoc.elements[item].checked = true
    var numitems = $count + $boards + $startcount
    var parents = new Array(numitems)
    for (var i=$startcount; i<numitems; i++) {
        parents[i] = new Array
    }
        |;

        foreach my $container (sort { $a <=> $b } keys %children) {
            my @contents = split/:/,$children{$container};
            for (my $i=0; $i<@contents; $i ++) {
                $scripttag .= '    parents['.$container.']['.$i.'] = '.$contents[$i]."\n";
            }
        }

        $scripttag .= qq|
    if (parents[item].length > 0) {
        for (var j=0; j<parents[item].length; j++) {
            containerCheck(parents[item][j])
        }
     }   
}

</script>
        |;
	$r->print(&Apache::loncommon::start_page('Export '.lc($type).' to IMS content package',
						 $scripttag));
	$r->print(&Apache::lonhtmlcommon::breadcrumbs('Export '.lc($type).' to IMS content package'));
	$r->print($display.'</table>'.
                  '<p><input type="hidden" name="finishexport" value="1">'.
                  '<input type="submit" name="exportcourse" value="'.
                  &mt('Export '.$type.' DOCS').'" /></p></form>'.
		  &Apache::loncommon::end_page());
    }
}

sub create_ims_store {
    my ($now,$manifestok,$outcome,$tempexport) = @_;
    $$tempexport = $Apache::lonnet::perlvar{'lonDaemons'}.'/tmp/ims_exports';
    my $ims_manifest;
    if (!-e $$tempexport) {
        mkdir($$tempexport,0700);
    }
    $$tempexport .= '/'.$now;
    if (!-e $$tempexport) {
        mkdir($$tempexport,0700);
    }
    $$tempexport .= '/'.$env{'user.domain'}.'_'.$env{'user.name'};
    if (!-e $$tempexport) {
        mkdir($$tempexport,0700);
    }
    if (!-e "$$tempexport/resources") {
        mkdir("$$tempexport/resources",0700);
    }
# open manifest file
    my $manifest = '/imsmanifest.xml';
    my $manifestfilename = $$tempexport.$manifest;
    if ($ims_manifest = Apache::File->new('>'.$manifestfilename)) {
        $$manifestok=1;
        print $ims_manifest
'<?xml version="1.0" encoding="UTF-8"?>'."\n".
'<manifest xmlns="http://www.imsglobal.org/xsd/imscp_v1p1"'.
' xmlns:imsmd="http://www.imsglobal.org/xsd/imsmd_v1p2"'.
' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'.
' identifier="MANIFEST-'.$env{'request.course.id'}.'-'.$now.'"'.
'  xsi:schemaLocation="http://www.imsglobal.org/xsd/imscp_v1p1imscp_v1p1.xsd'.
'  http://www.imsglobal.org/xsd/imsmd_v1p2 imsmd_v1p2p2.xsd">'."\n".
'  <metadata>
    <schema></schema>
    <imsmd:lom>
      <imsmd:general>
        <imsmd:identifier>'.$env{'request.course.id'}.'</imsmd:identifier>
        <imsmd:title>
          <imsmd:langstring xml:lang="en">'.$env{'course.'.$env{'request.course.id'}.'.description'}.'</imsmd:langstring>
        </imsmd:title>
      </imsmd:general>
    </imsmd:lom>
  </metadata>'."\n".
'  <organizations default="ORG-'.$env{'request.course.id'}.'-'.$now.'">'."\n".
'    <organization identifier="ORG-'.$env{'request.course.id'}.'-'.$now.'"'.
' structure="hierarchical">'."\n".
'      <title>'.$env{'course.'.$env{'request.course.id'}.'.description'}.'</title>'
    } else {
        $$outcome .= 'An error occurred opening the IMS manifest file.<br />'
;
    }
    return $ims_manifest;
}

sub build_package {
    my ($now,$navmap,$exportitems,$discussions,$outcome,$tempexport,$copyresult,$ims_manifest) = @_;
# first iterator to look for dependencies
    my $it = $navmap->getIterator(undef,undef,undef,1,undef,undef);
    my $curRes;
    my $count = 0;
    my $depth = 0;
    my $lastcontainer = 0;
    my %parent = ();
    my @dependencies = ();
    my $cnum = $env{'course.'.$env{'request.course.id'}.'.num'};
    my $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    while ($curRes = $it->next()) {
        if (ref($curRes)) {
            $count ++;
        }
        if ($curRes == $it->BEGIN_MAP()) {
            $depth++;
            $parent{$depth} = $lastcontainer;
        }
        if ($curRes == $it->END_MAP()) {
            $depth--;
            $lastcontainer = $parent{$depth};
        }
        if (ref($curRes)) {
            if ($curRes->is_sequence() || $curRes->is_page()) {
                $lastcontainer = $count;
            }
            if (grep/^$count$/,@$exportitems) {
                &get_dependencies($exportitems,\%parent,$depth,\@dependencies);
            }
        }
    }
# second iterator to build manifest and store resources
    $it = $navmap->getIterator(undef,undef,undef,1,undef,undef);
    $depth = 0;
    my $prevdepth;
    $count = 0;
    my $imsresources;
    my $pkgdepth;
    while ($curRes = $it->next()) {
        if ($curRes == $it->BEGIN_MAP()) {
            $prevdepth = $depth;
            $depth++;
        }
        if ($curRes == $it->END_MAP()) {
            $prevdepth = $depth;
            $depth--;
        }

        if (ref($curRes)) {
            $count ++;
            if ((grep/^$count$/,@$exportitems) || (grep/^$count$/,@dependencies)) {
                my $symb = $curRes->symb();
                my $isvisible = 'true';
                my $resourceref;
                if ($curRes->randomout()) {
                    $isvisible = 'false';
                }
                unless ($curRes->is_sequence()) {
                    $resourceref = 'identifierref="RES-'.$env{'request.course.id'}.'-'.$count.'"';
                }
                my $step = $prevdepth - $depth;
                if (($step >= 0) && ($count > 1)) {
                    while ($step >= 0) {
                        print $ims_manifest "\n".'  </item>'."\n";
                        $step --;
                    }
                }
                $prevdepth = $depth;

                my $itementry =
              '<item identifier="ITEM-'.$env{'request.course.id'}.'-'.$count.
              '" isvisible="'.$isvisible.'" '.$resourceref.'>'.
              '<title>'.$curRes->title().'</title>';
                print $ims_manifest "\n".$itementry;

                unless ($curRes->is_sequence()) {
                    my $content_file;
                    my @hrefs = ();
                    &process_content($count,$curRes,$cdom,$cnum,$symb,\$content_file,\@hrefs,$copyresult,$tempexport);
                    if ($content_file) {
                        $imsresources .= "\n".
                     '   <resource identifier="RES-'.$env{'request.course.id'}.'-'.$count.
                     '" type="webcontent" href="'.$content_file.'">'."\n".
                     '       <file href="'.$content_file.'" />'."\n";
                        foreach (@hrefs) {
                            $imsresources .=
                     '        <file href="'.$_.'" />'."\n";
                        }
                        if (grep/^$count$/,@$discussions) {
                            my $ressymb = $symb;
                            my $mode;
                            if ($ressymb =~ m|adm/($match_domain)/($match_username)/(\d+)/bulletinboard$|) {
                                unless ($ressymb =~ m|adm/wrapper/adm|) {
                                    $ressymb = 'bulletin___'.$3.'___adm/wrapper/adm/'.$1.'/'.$2.'/'.$3.'/bulletinboard';
                                }
                                $mode = 'board';
                            }
                            my %extras = (
                                          caller => 'imsexport',
                                          tempexport => $tempexport.'/resources',
                                          count => $count
                                         );
                            my $discresult = &Apache::lonfeedback::list_discussion($mode,undef,$ressymb,\%extras);
                        }
                        $imsresources .= '    </resource>'."\n";
                    }
                }
                $pkgdepth = $depth;
            }
        }
    }
    while ($pkgdepth > 0) {
        print $ims_manifest "    </item>\n";
        $pkgdepth --;
    }
    my $resource_text = qq|
    </organization>
  </organizations>
  <resources>
    $imsresources
  </resources>
</manifest>
    |;
    print $ims_manifest $resource_text;
}

sub get_dependencies {
    my ($exportitems,$parent,$depth,$dependencies) = @_;
    if ($depth > 1) {
        if ((!grep/^$$parent{$depth}$/,@$exportitems) && (!grep/^$$parent{$depth}$/,@$dependencies)) {
            push @$dependencies, $$parent{$depth};
            if ($depth > 2) {
                &get_dependencies($exportitems,$parent,$depth-1,$dependencies);
            }
        }
    }
}

sub process_content {
    my ($count,$curRes,$cdom,$cnum,$symb,$content_file,$href,$copyresult,$tempexport) = @_;
    my $content_type;
    my $message;
    my @uploads = ();
    if ($curRes->is_sequence()) {
        $content_type = 'sequence';
    } elsif ($curRes->is_page()) {
        $content_type = 'page'; # need to handle individual items in pages.
    } elsif ($symb =~ m-public/$cdom/$cnum/syllabus$-) {
        $content_type = 'syllabus';
        my $contents = &Apache::imsexport::templatedpage($content_type);
        if ($contents) {
            $$content_file = &store_template($contents,$tempexport,$count,$content_type);
        }
    } elsif ($symb =~ m-\.sequence___\d+___ext-) {
        $content_type = 'external';
        my $title = $curRes->title;
        my $contents =  &Apache::imsexport::external($symb,$title);
        if ($contents) {
            $$content_file = &store_template($contents,$tempexport,$count,$content_type);
        }
    } elsif ($symb =~ m-adm/navmaps$-) {
        $content_type =  'navmap';
    } elsif ($symb =~ m-adm/[^/]+/[^/]+/(\d+)/smppg$-) {
        $content_type = 'simplepage';
        my $contents = &Apache::imsexport::templatedpage($content_type,$1,$count,\@uploads);
        if ($contents) {
            $$content_file = &store_template($contents,$tempexport,$count,$content_type);
        }
    } elsif ($symb =~ m-lib/templates/simpleproblem\.problem$-) {
        $content_type = 'simpleproblem';
        my $contents =  &Apache::imsexport::simpleproblem($symb);
        if ($contents) {
            $$content_file = &store_template($contents,$tempexport,$count,$content_type);
        }
    } elsif ($symb =~ m-lib/templates/examupload\.problem$-) {
        $content_type = 'examupload';
    } elsif ($symb =~ m-adm/($match_domain)/($match_username)/(\d+)/bulletinboard$-) {
        $content_type = 'bulletinboard';
        my $contents =  &Apache::imsexport::templatedpage($content_type,$3,$count,\@uploads,$1,$2);
        if ($contents) {
            $$content_file = &store_template($contents,$tempexport,$count,$content_type);
        }
    } elsif ($symb =~ m-adm/([^/]+)/([^/]+)/aboutme$-) {
        $content_type = 'aboutme';
        my $contents =  &Apache::imsexport::templatedpage($content_type,undef,$count,\@uploads,$1,$2);
        if ($contents) {
            $$content_file = &store_template($contents,$tempexport,$count,$content_type);
        }
    } elsif ($symb =~ m-\.(sequence|page)___\d+___uploaded/$cdom/$cnum/-) {
        $$content_file = &replicate_content($cdom,$cnum,$tempexport,$symb,$count,\$message,$href,'uploaded');
    } elsif ($symb =~ m-\.(sequence|page)___\d+___([^/]+)/([^/]+)-) {
        my $canedit = 0;
        if ($2 eq $env{'user.domain'} && $3 eq $env{'user.name'})  {
            $canedit= 1;
        }
# only include problem code where current user is author
        if ($canedit) {
            $$content_file = &replicate_content($cdom,$cnum,$tempexport,$symb,$count,\$message,$href,'resource');
        } else {
            $$content_file = &replicate_content($cdom,$cnum,$tempexport,$symb,$count,\$message,$href,'noedit');
        }
    } elsif ($symb =~ m-uploaded/$cdom/$cnum-) {
        $$content_file = &replicate_content($cdom,$cnum,$tempexport,$symb,$count,\$message,$href,'uploaded');
    }
    if (@uploads > 0) {
        foreach my $item (@uploads) {
            my $uploadmsg = '';
            &replicate_content($cdom,$cnum,$tempexport,$item,$count,\$uploadmsg,$href,'templateupload');
            if ($uploadmsg) {
                $$copyresult .= $uploadmsg."\n";
            }
        }
    }
    if ($message) {
        $$copyresult .= $message."\n";
    }
}

sub replicate_content {
    my ($cdom,$cnum,$tempexport,$symb,$count,$message,$href,$caller) = @_;
    my ($map,$ind,$url);
    if ($caller eq 'templateupload') {
        $url = $symb;
        $url =~ s#//#/#g;
    } else { 
        ($map,$ind,$url)=&Apache::lonnet::decode_symb($symb);
    }
    my $content;
    my $filename;
    my $repstatus;
    my $content_name;
    if ($url =~ m-/([^/]+)$-) {
        $filename = $1;
        if (!-e $tempexport.'/resources') {
            mkdir($tempexport.'/resources',0700);
        }
        if (!-e $tempexport.'/resources/'.$count) {
            mkdir($tempexport.'/resources/'.$count,0700);
        }
        my $destination = $tempexport.'/resources/'.$count.'/'.$filename;
        my $copiedfile;
        if ($copiedfile = Apache::File->new('>'.$destination)) {
            my $content;
            if ($caller eq 'resource') {
                my $respath =  $Apache::lonnet::perlvar{'lonDocRoot'}.'/res';
                my $filepath = &Apache::lonnet::filelocation($respath,$url);
                $content = &Apache::lonnet::getfile($filepath);
                if ($content eq -1) {
                    $$message = 'Could not copy file '.$filename;
                } else {
                    &extract_media($url,$cdom,$cnum,\$content,$count,$tempexport,$href,$message,'resource');
                    $repstatus = 'ok';
                }
            } elsif ($caller eq 'uploaded' || $caller eq 'templateupload') {
                my $rtncode;
                $repstatus = &Apache::lonnet::getuploaded('GET',$url,$cdom,$cnum,\$content,$rtncode);
                if ($repstatus eq 'ok') {
                    if ($url =~ /\.html?$/i) {
                        &extract_media($url,$cdom,$cnum,\$content,$count,$tempexport,$href,$message,'uploaded');
                    }
                } else {
                    $$message = 'Could not render '.$url.' server message - '.$rtncode."<br />\n";
                }
            } elsif ($caller eq 'noedit') {
# Need to render the resource without the LON-CAPA Internal header and the Post discussion footer, and then set $content equal to this. 
                $repstatus = 'ok';
                $content = 'Not the owner of this resource'; 
            }
            if ($repstatus eq 'ok') {
                print $copiedfile $content;
            }
            close($copiedfile);
        } else {
            $$message = 'Could not open destination file for '.$filename."<br />\n";
        }
    } else {
        $$message = 'Could not determine name of file for '.$symb."<br />\n";
    }
    if ($repstatus eq 'ok') {
        $content_name = 'resources/'.$count.'/'.$filename;
    }
    return $content_name;
}

sub extract_media {
    my ($url,$cdom,$cnum,$content,$count,$tempexport,$href,$message,$caller) = @_;
    my ($dirpath,$container);
    my %allfiles = ();
    my %codebase = ();
    if ($url =~ m-(.*/)([^/]+)$-) {
        $dirpath = $1;
        $container = $2;
    } else {
        $dirpath = $url;
        $container = '';
    }
    &Apache::lonnet::extract_embedded_items(undef,undef,\%allfiles,\%codebase,$content);
    foreach my $embed_file (keys(%allfiles)) {
        my $filename;
        if ($embed_file =~ m#([^/]+)$#) {
            $filename = $1;
        } else {
            $filename = $embed_file;
        }
        my $newname = 'res/'.$filename;
        my ($rtncode,$embed_content,$repstatus);
        my $embed_url;
        if ($embed_file =~ m-^/-) {
            $embed_url = $embed_file;           # points to absolute path
        } else {
            if ($embed_file =~ m-https?://-) {
                next;                           # points to url
            } else {
                $embed_url = $dirpath.$embed_file;  # points to relative path
            }
        }
        if ($caller eq 'resource') {
            my $respath =  $Apache::lonnet::perlvar{'lonDocRoot'}.'/res';  
            my $embed_path = &Apache::lonnet::filelocation($respath,$embed_url); 
            $embed_content = &Apache::lonnet::getfile($embed_path);
            unless ($embed_content eq -1) {
                $repstatus = 'ok';
            }
        } elsif ($caller eq 'uploaded') {
            
            $repstatus = &Apache::lonnet::getuploaded('GET',$embed_url,$cdom,$cnum,\$embed_content,$rtncode);
        }
        if ($repstatus eq 'ok') {
            my $destination = $tempexport.'/resources/'.$count.'/res';
            if (!-e "$destination") {
                mkdir($destination,0755);
            }
            $destination .= '/'.$filename;
            my $copiedfile;
            if ($copiedfile = Apache::File->new('>'.$destination)) {
                print $copiedfile $embed_content;
                push @{$href}, 'resources/'.$count.'/res/'.$filename;
                my $attrib_regexp = '';
                if (@{$allfiles{$embed_file}} > 1) {
                    $attrib_regexp = join('|',@{$allfiles{$embed_file}});
                } else {
                    $attrib_regexp = $allfiles{$embed_file}[0];
                }
                $$content =~ s#($attrib_regexp\s*=\s*['"]?)\Q$embed_file\E(['"]?)#$1$newname$2#gi;
                if ($caller eq 'resource' && $container =~ /\.(problem|library)$/) {
                    $$content =~ s#\Q$embed_file\E#$newname#gi;
                }
            }
        } else {
            $$message .= 'replication of embedded file - '.$embed_file.' in '.$url.' failed, reason -'.$rtncode."<br />\n";
        }
    }
    return;
}

sub store_template {
    my ($contents,$tempexport,$count,$content_type) = @_;
    if ($contents) {
        if ($tempexport) {
            if (!-e $tempexport.'/resources') {
                mkdir($tempexport.'/resources',0700);
            }
            if (!-e $tempexport.'/resources/'.$count) {
                mkdir($tempexport.'/resources/'.$count,0700);
            }
            my $destination = $tempexport.'/resources/'.$count.'/'.$content_type.'.xml';
            my $storetemplate;
            if ($storetemplate = Apache::File->new('>'.$destination)) {
                print $storetemplate $contents;
                close($storetemplate);
            }
            if ($content_type eq 'external') {
                return 'resources/'.$count.'/'.$content_type.'.html';
            } else {
                return 'resources/'.$count.'/'.$content_type.'.xml';
            }
        }
    }
}

# Imports the given (name, url) resources into the course
# coursenum, coursedom, and folder must precede the list
sub group_import {
    my $coursenum = shift;
    my $coursedom = shift;
    my $folder = shift;
    my $container = shift;
    my $caller = shift;
    while (@_) {
	my $name = shift;
	my $url = shift;
        if (($url =~ m{^/uploaded/\Q$coursedom\E/\Q$coursenum\E/(default_\d+\.)(page|sequence)$}) && ($caller eq 'londocs')) {
            my $errtext = '';
            my $fatal = 0;
            my $newmapstr = '<map>'."\n".
                            '<resource id="1" src="" type="start"></resource>'."\n".
                            '<link from="1" to="2" index="1"></link>'."\n".
                            '<resource id="2" src="" type="finish"></resource>'."\n".
                            '</map>';
            $env{'form.output'}=$newmapstr;
            my $result=&Apache::lonnet::finishuserfileupload($coursenum,$coursedom,
                                                'output',$1.$2);
            if ($result != m|^/uploaded/|) {
                $errtext.='Map not saved: A network error occured when trying to save the new map. ';
                $fatal = 2;
            }
            if ($fatal) {
                return ($errtext,$fatal);
            }
        }
	if ($url) {
	    my $idx = &LONCAPA::map::getresidx($url);
	    $LONCAPA::map::order[$#LONCAPA::map::order+1]=$idx;
	    my $ext = 'false';
	    if ($url=~m{^http://} || $url=~m{^https://}) { $ext = 'true'; }
	    $url  = &LONCAPA::map::qtunescape($url);
	    $name = &LONCAPA::map::qtunescape($name);
	    $LONCAPA::map::resources[$idx] = 
		join ':', ($name, $url, $ext, 'normal', 'res');
	}
    }
    return &storemap($coursenum, $coursedom, $folder.'.'.$container);
}

sub breadcrumbs {
    my ($where)=@_;
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    my (@folders);
    if ($env{'form.pagepath'}) {
        @folders = split('&',$env{'form.pagepath'});
    } else {
        @folders=split('&',$env{'form.folderpath'});
    }
    my $folderpath;
    my $cpinfo='';
    my $plain='';
    if ($env{'form.markedcopy_url'}) {
       $cpinfo='&markedcopy_url='.
               &escape($env{'form.markedcopy_url'}).
               '&markedcopy_title='.
               &escape($env{'form.markedcopy_title'});
    }
    my $randompick=-1;
    my $isencrypted=0;
    my $ishidden=0;
    while (@folders) {
	my $folder=shift(@folders);
	my $foldername=shift(@folders);
	if ($folderpath) {$folderpath.='&';}
	$folderpath.=$folder.'&'.$foldername;
	my $url='/adm/coursedocs?folderpath='.
	    &escape($folderpath);
            my $name=&unescape($foldername);
# randompick number, hidden, encrypted is appended with ":"s to the foldername	
            $name=~s/\:(\d*)\:(\w*)\:(\w*)$//;
            if ($1 ne '') { 
               $randompick=$1;
            } else {
               $randompick=-1;
            }
            if ($2) { $ishidden=1; }
            if ($3) { $isencrypted=1; }
	    &Apache::lonhtmlcommon::add_breadcrumb(
		      {'href'=>$url.$cpinfo,
		       'title'=>$name,
		       'text'=>'<font size="+1">'.
			   $name.'</font>',
		       'no_mt'=>1,
		       });
	$plain.=$name.' &gt; ';
    }
    $plain=~s/\&gt\;\s*$//;
    return (&Apache::lonhtmlcommon::breadcrumbs(undef,undef,0,'nohelp',
					       'LC_docs_path'),$randompick,$ishidden,$isencrypted,$plain);
}

sub log_docs {
    return &Apache::lonnet::instructor_log('docslog',@_);
}

{
    my @oldresources=();
    my @oldorder=();
    my $parmidx;
    my %parmaction=();
    my %parmvalue=();
    my $changedflag;

    sub snapshotbefore {
        @oldresources=@LONCAPA::map::resources;
        @oldorder=@LONCAPA::map::order;
        $parmidx=undef;
        %parmaction=();
        %parmvalue=();
        $changedflag=0;
    }

    sub remember_parms {
        my ($idx,$parameter,$action,$value)=@_;
        $parmidx=$idx;
        $parmaction{$parameter}=$action;
        $parmvalue{$parameter}=$value;
        $changedflag=1;
    }

    sub log_differences {
        my ($plain)=@_;
        my %storehash=('folder' => $plain,
                       'currentfolder' => $env{'form.folder'});
        if ($parmidx) {
           $storehash{'parameter_res'}=$oldresources[$parmidx];
           foreach my $parm (keys %parmaction) {
              $storehash{'parameter_action_'.$parm}=$parmaction{$parm};
              $storehash{'parameter_value_'.$parm}=$parmvalue{$parm};
           }
        }
        my $maxidx=$#oldresources;
        if ($#LONCAPA::map::resources>$#oldresources) {
           $maxidx=$#LONCAPA::map::resources;
        }
        for (my $idx=0; $idx<=$maxidx; $idx++) {
           if ($LONCAPA::map::resources[$idx] ne $oldresources[$idx]) {
              $storehash{'before_resources_'.$idx}=$oldresources[$idx];
              $storehash{'after_resources_'.$idx}=$LONCAPA::map::resources[$idx];
              $changedflag=1;
           }
           if ($LONCAPA::map::order[$idx] ne $oldorder[$idx]) {
              $storehash{'before_order_res_'.$idx}=$oldresources[$oldorder[$idx]];
              $storehash{'after_order_res_'.$idx}=$LONCAPA::map::resources[$LONCAPA::map::order[$idx]];
              $changedflag=1;
           }
        }
	$storehash{'maxidx'}=$maxidx;
        if ($changedflag) { &log_docs(\%storehash); }
    }
}


#
# Docs Change Log
#
sub docs_change_log {
    my ($r)=@_;
    my $folder=$env{'form.folder'};
    $r->print(&Apache::loncommon::start_page('Course Document Change Log'));
    $r->print(&Apache::lonhtmlcommon::breadcrumbs('Course Document Change Log'));
    my %docslog=&Apache::lonnet::dump('nohist_docslog',
                                      $env{'course.'.$env{'request.course.id'}.'.domain'},
                                      $env{'course.'.$env{'request.course.id'}.'.num'});

    if ((keys(%docslog))[0]=~/^error\:/) { undef(%docslog); }

    $r->print('<form action="/adm/coursedocs" method="post" name="docslog">'.
              '<input type="hidden" name="docslog" value="1" />');

    my %saveable_parameters = ('show' => 'scalar',);
    &Apache::loncommon::store_course_settings('docs_log',
                                              \%saveable_parameters);
    &Apache::loncommon::restore_course_settings('docs_log',
                                                \%saveable_parameters);
    if (!$env{'form.show'}) { $env{'form.show'}=10; }
    my %lt=('hiddenresource' => 'Resources hidden',
	    'encrypturl'     => 'URL hidden',
	    'randompick'     => 'Randomly pick',
	    'set'            => 'set to',
	    'del'            => 'deleted');
    $r->print(&Apache::loncommon::display_filter().
              '<input type="hidden" name="folder" value="'.$folder.'" />'.
              '<input type="submit" value="'.&mt('Display').'" /></form>');
    $r->print(&Apache::loncommon::start_data_table().&Apache::loncommon::start_data_table_header_row().
              '<th>'.&mt('Time').'</th><th>'.&mt('User').'</th><th>'.&mt('Folder').'</th><th>'.&mt('Before').'</th><th>'.
              &mt('After').'</th>'.
              &Apache::loncommon::end_data_table_header_row());
    my $shown=0;
    foreach my $id (sort { $docslog{$b}{'exe_time'}<=>$docslog{$a}{'exe_time'} } (keys(%docslog))) {
	if ($env{'form.displayfilter'} eq 'currentfolder') {
	    if ($docslog{$id}{'logentry'}{'currentfolder'} ne $folder) { next; }
	}
        my @changes=keys(%{$docslog{$id}{'logentry'}});
        if ($env{'form.displayfilter'} eq 'containing') {
	    my $wholeentry=$docslog{$id}{'exe_uname'}.':'.$docslog{$id}{'exe_udom'}.':'.
		&Apache::loncommon::plainname($docslog{$id}{'exe_uname'},$docslog{$id}{'exe_udom'});
	    foreach my $key (@changes) {
		$wholeentry.=':'.$docslog{$id}{'logentry'}{$key};
	    }
	    if ($wholeentry!~/\Q$env{'form.containingphrase'}\E/i) { next; }         
	}
        my $count = 0;
        my $time =
            &Apache::lonlocal::locallocaltime($docslog{$id}{'exe_time'});
        my $plainname =
            &Apache::loncommon::plainname($docslog{$id}{'exe_uname'},
                                          $docslog{$id}{'exe_udom'});
        my $about_me_link =
            &Apache::loncommon::aboutmewrapper($plainname,
                                               $docslog{$id}{'exe_uname'},
                                               $docslog{$id}{'exe_udom'});
        my $send_msg_link='';
        if ((($docslog{$id}{'exe_uname'} ne $env{'user.name'})
             || ($docslog{$id}{'exe_udom'} ne $env{'user.domain'}))) {
            $send_msg_link ='<br />'.
                &Apache::loncommon::messagewrapper(&mt('Send message'),
                                                   $docslog{$id}{'exe_uname'},
                                                   $docslog{$id}{'exe_udom'});
        }
        $r->print(&Apache::loncommon::start_data_table_row());
        $r->print('<td>'.$time.'</td>
                       <td>'.$about_me_link.
                  '<br /><tt>'.$docslog{$id}{'exe_uname'}.
                                  ':'.$docslog{$id}{'exe_udom'}.'</tt>'.
                  $send_msg_link.'</td><td>'.
                  $docslog{$id}{'logentry'}{'folder'}.'</td><td>');
# Before
	for (my $idx=0;$idx<=$docslog{$id}{'logentry'}{'maxidx'};$idx++) {
	    my $oldname=(split(/\:/,$docslog{$id}{'logentry'}{'before_resources_'.$idx}))[0];
	    my $newname=(split(/\:/,$docslog{$id}{'logentry'}{'after_resources_'.$idx}))[0];
	    if ($oldname ne $newname) {
		$r->print(&LONCAPA::map::qtescape($oldname));
	    }
	}
	$r->print('<ul>');
	for (my $idx=0;$idx<=$docslog{$id}{'logentry'}{'maxidx'};$idx++) {
            if ($docslog{$id}{'logentry'}{'before_order_res_'.$idx}) {
		$r->print('<li>'.&LONCAPA::map::qtescape((split(/\:/,$docslog{$id}{'logentry'}{'before_order_res_'.$idx}))[0]).'</li>');
	    }
	}
	$r->print('</ul>');
# After
        $r->print('</td><td>');

	for (my $idx=0;$idx<=$docslog{$id}{'logentry'}{'maxidx'};$idx++) {
	    my $oldname=(split(/\:/,$docslog{$id}{'logentry'}{'before_resources_'.$idx}))[0];
	    my $newname=(split(/\:/,$docslog{$id}{'logentry'}{'after_resources_'.$idx}))[0];
	    if ($oldname ne $newname) {
		$r->print(&LONCAPA::map::qtescape($newname));
	    }
	}        
	$r->print('<ul>');
	for (my $idx=0;$idx<=$docslog{$id}{'logentry'}{'maxidx'};$idx++) {
            if ($docslog{$id}{'logentry'}{'after_order_res_'.$idx}) {
		$r->print('<li>'.&LONCAPA::map::qtescape((split(/\:/,$docslog{$id}{'logentry'}{'after_order_res_'.$idx}))[0]).'</li>');
	    }
	}
	$r->print('</ul>');
	if ($docslog{$id}{'logentry'}{'parameter_res'}) {
	    $r->print(&LONCAPA::map::qtescape((split(/\:/,$docslog{$id}{'logentry'}{'parameter_res'}))[0]).':<ul>');
	    foreach my $parameter ('randompick','hiddenresource','encrypturl') {
		if ($docslog{$id}{'logentry'}{'parameter_action_'.$parameter}) {
		    $r->print('<li>'.
			      &mt($lt{$parameter}.' '.$lt{$docslog{$id}{'logentry'}{'parameter_action_'.$parameter}}.' [_1]',
				  $docslog{$id}{'logentry'}{'parameter_value_'.$parameter})
			      .'</li>');
		}
	    }
	    $r->print('</ul>');
	}
# End
        $r->print('</td>'.&Apache::loncommon::end_data_table_row());
        $shown++;
        if (!($env{'form.show'} eq &mt('all')
              || $shown<=$env{'form.show'})) { last; }
    }
    $r->print(&Apache::loncommon::end_data_table());
    $r->print(&Apache::loncommon::end_page());
}

sub editor {
    my ($r,$coursenum,$coursedom,$folder,$allowed,$upload_output)=@_;
    my $errtext='';
    my $fatal=0;
    my $container='sequence';
    if ($env{'form.pagepath'}) {
        $container='page';
    }
    ($errtext,$fatal)=
              &mapread($coursenum,$coursedom,$folder.'.'.$container);
    if ($#LONCAPA::map::order<1) {
	my $idx=&LONCAPA::map::getresidx();
	if ($idx<=0) { $idx=1; }
       	$LONCAPA::map::order[0]=$idx;
        $LONCAPA::map::resources[$idx]='';
    }
    if (defined($env{'form.markcopy'})) {
# Mark for copying
	my ($title,$url)=split(':',$LONCAPA::map::resources[$LONCAPA::map::order[$env{'form.markcopy'}]]);
	$env{'form.markedcopy_title'}=$title;
	$env{'form.markedcopy_url'}=$url;
    }
    my ($breadcrumbtrail,$randompick,$ishidden,$isencrypted,$plain)=&breadcrumbs($folder);
    $r->print($breadcrumbtrail);
    if ($fatal) {
	   $r->print('<p><font color="red">'.$errtext.'</font></p>');
    } else {
# ------------------------------------------------------------ Process commands

# ---------------- if they are for this folder and user allowed to make changes
	if (($allowed) && ($env{'form.folder'} eq $folder)) {
# set parameters and change order
            &snapshotbefore();
	    if ($env{'form.changeparms'}) {
		my $idx=$env{'form.setparms'};
# set parameters
		if ($env{'form.changeparms'} eq 'randompick') {
		    if ($env{'form.randpick_'.$idx}) {
			&LONCAPA::map::storeparameter($idx,'parameter_randompick',$env{'form.randpick_'.$idx},'int_pos');
			&remember_parms($idx,'randompick','set',$env{'form.randpick_'.$idx});
		    } else {
			&LONCAPA::map::delparameter($idx,'parameter_randompick');
			&remember_parms($idx,'randompick','del');
		    }
		}
		if ($env{'form.changeparms'} eq 'hiddenresource') {
		    if ($env{'form.hidprs_'.$idx}) {
			&LONCAPA::map::storeparameter($idx,'parameter_hiddenresource','yes','string_yesno');
			&remember_parms($idx,'hiddenresource','set',$env{'form.hidprs_'.$idx});
		    } else {
			&LONCAPA::map::delparameter($idx,'parameter_hiddenresource');
			&remember_parms($idx,'hiddenresource','del');
		    }
		}
		if ($env{'form.changeparms'} eq 'encrypturl') {
		    if ($env{'form.encprs_'.$idx}) {
			&LONCAPA::map::storeparameter($idx,'parameter_encrypturl','yes','string_yesno');
			&remember_parms($idx,'encrypturl','set',$env{'form.encprs_'.$idx});
		    } else {
			&LONCAPA::map::delparameter($idx,'parameter_encrypturl');
			&remember_parms($idx,'encrypturl','del');
		    }
		}
# store the changed version
		($errtext,$fatal)=&storemap($coursenum,$coursedom,$folder.'.'.$container);
		if ($fatal) {
		    $r->print('<p><font color="red">'.$errtext.'</font></p>');
		    return;
		}
	    }

	    if ($env{'form.newpos'}) {
# change order
		my $newpos=$env{'form.newpos'}-1;
		my $currentpos=$env{'form.currentpos'}-1;
		my $i;
		my @neworder=();
		if ($newpos>$currentpos) {
# moving stuff up
		    for ($i=0;$i<$currentpos;$i++) {
			$neworder[$i]=$LONCAPA::map::order[$i];
		    }
		    for ($i=$currentpos;$i<$newpos;$i++) {
			$neworder[$i]=$LONCAPA::map::order[$i+1];
		    }
		    $neworder[$newpos]=$LONCAPA::map::order[$currentpos];
		    for ($i=$newpos+1;$i<=$#LONCAPA::map::order;$i++) {
			$neworder[$i]=$LONCAPA::map::order[$i];
		    }
		} else {
# moving stuff down
		    for ($i=0;$i<$newpos;$i++) {
			$neworder[$i]=$LONCAPA::map::order[$i];
		    }
		    $neworder[$newpos]=$LONCAPA::map::order[$currentpos];
		    for ($i=$newpos+1;$i<$currentpos+1;$i++) {
			$neworder[$i]=$LONCAPA::map::order[$i-1];
		    }
		    for ($i=$currentpos+1;$i<=$#LONCAPA::map::order;$i++) {
			$neworder[$i]=$LONCAPA::map::order[$i];
		    }
		}
		@LONCAPA::map::order=@neworder;
# store the changed version
		($errtext,$fatal)=&storemap($coursenum,$coursedom,$folder.'.'.$container);
		if ($fatal) {
		    $r->print('<p><font color="red">'.$errtext.'</font></p>');
		    return;
		}
	    }
		
	    if ($env{'form.pastemarked'}) {
# paste resource to end of list
                my $url=$env{'form.markedcopy_url'};
		my $title=$env{'form.markedcopy_title'};
# Maps need to be copied first
		if (($url=~/\.(page|sequence)$/) || ($url=~/^\/uploaded\//)) {
		    $title=&mt('Copy of').' '.$title;
                    my $newid=$$.time;
		    $url=~/^(.+)\.(\w+)$/;
		    my $newurl=$1.$newid.'.'.$2;
		    my $storefn=$newurl;
                    $storefn=~s{^/\w+/$match_domain/$match_username/}{};
		    &Apache::lonclonecourse::writefile
			($env{'request.course.id'},$storefn,
			 &Apache::lonnet::getfile($url));
		    $url=$newurl;
		}
		$title = &LONCAPA::map::qtunescape($title);
		my $ext='false';
		if ($url=~/^http\:\/\//) { $ext='true'; }
		$url   = &LONCAPA::map::qtunescape($url);
# Now insert the URL at the bottom
                my $newidx=&LONCAPA::map::getresidx($url);
		$LONCAPA::map::resources[$newidx]=
		    $title.':'.$url.':'.$ext.':normal:res';
		$LONCAPA::map::order[1+$#LONCAPA::map::order]=$newidx;
# Store the result
		($errtext,$fatal)=&storemap($coursenum,$coursedom,$folder.'.'.$container);
		if ($fatal) {
		    $r->print('<p><font color="red">'.$errtext.'</font></p>');
		    return;
		}

	    }
            $r->print($upload_output);
	    if ($env{'form.cmd'}) {
                my ($cmd,$idx)=split(/\_/,$env{'form.cmd'});
                if ($cmd eq 'del') {
		    my (undef,$url)=split(':',$LONCAPA::map::resources[$LONCAPA::map::order[$idx]]);
		    if (($url=~m|/+uploaded/\Q$coursedom\E/\Q$coursenum\E/|) &&
			($url!~/\.(page|sequence|problem|exam|quiz|assess|survey|form|library|task)$/)) {
			&Apache::lonnet::removeuploadedurl($url);
		    } else {
			&LONCAPA::map::makezombie($LONCAPA::map::order[$idx]);
		    }
		    for (my $i=$idx;$i<$#LONCAPA::map::order;$i++) {
                        $LONCAPA::map::order[$i] = $LONCAPA::map::order[$i+1];
                    }
                    $#LONCAPA::map::order--;
                } elsif ($cmd eq 'cut') {
		    my (undef,$url)=split(':',$LONCAPA::map::resources[$LONCAPA::map::order[$idx]]);
		    &LONCAPA::map::makezombie($LONCAPA::map::order[$idx]);
		    for (my $i=$idx;$i<$#LONCAPA::map::order;$i++) {
                        $LONCAPA::map::order[$i] = $LONCAPA::map::order[$i+1];
                    }
                    $#LONCAPA::map::order--;
                } elsif ($cmd eq 'up') {
		  if (($idx) && (defined($LONCAPA::map::order[$idx-1]))) {
                    my $i=$LONCAPA::map::order[$idx-1];
                    $LONCAPA::map::order[$idx-1] = $LONCAPA::map::order[$idx];
                    $LONCAPA::map::order[$idx] = $i;
		   }
                } elsif ($cmd eq 'down') {
		   if (defined($LONCAPA::map::order[$idx+1])) {
                    my $i=$LONCAPA::map::order[$idx+1];
                    $LONCAPA::map::order[$idx+1] = $LONCAPA::map::order[$idx];
                    $LONCAPA::map::order[$idx] = $i;
		   }
                } elsif ($cmd eq 'rename') {
                    my $ratstr = $LONCAPA::map::resources[$LONCAPA::map::order[$idx]];
                    my ($rtitle,@rrest)=split(/\:/,
                       $LONCAPA::map::resources[$LONCAPA::map::order[$idx]]);
                    my $comment=$env{'form.title'};
                    $comment = &LONCAPA::map::qtunescape($comment);
		    if ($comment=~/\S/) {
			$LONCAPA::map::resources[$LONCAPA::map::order[$idx]]=
			    $comment.':'.join(':',@rrest);
		    }
# Devalidate title cache
                    my $renamed_url=&LONCAPA::map::qtescape($rrest[0]);
		    &Apache::lonnet::devalidate_title_cache($renamed_url);
                }
# Store the changed version
		($errtext,$fatal)=&storemap($coursenum,$coursedom,
					    $folder.'.'.$container);
		if ($fatal) {
		    $r->print('<p><font color="red">'.$errtext.'</font></p>');
		    return;
		}
            }
# Group import/search
	    if ($env{'form.importdetail'}) {
		my @imports;
#		&Apache::lonnet::logthis("imp detail ".$env{'form.importdetail'});
		foreach (split(/\&/,$env{'form.importdetail'})) {
		    if (defined($_)) {
			my ($name,$url)=split(/\=/,$_);
			$name=&unescape($name);
			$url=&unescape($url);
			push @imports, $name, $url;
		    }
		}
# Store the changed version
		($errtext,$fatal)=&group_import($coursenum, $coursedom, $folder,
					       $container,'londocs',@imports);
		if ($fatal) {
		    $r->print('<p><font color="red">'.$errtext.'</font></p>');
		    return;
		}
            }
# Loading a complete map
	   if ($env{'form.loadmap'}) {
               if ($env{'form.importmap'}=~/\w/) {
	          foreach (&Apache::lonsequence::attemptread(&Apache::lonnet::filelocation('',$env{'form.importmap'}))) {
		      my ($title,$url,$ext,$type)=split(/\:/,$_);
                      my $idx=&LONCAPA::map::getresidx($url);
                      $LONCAPA::map::resources[$idx]=$_;
                      $LONCAPA::map::order[$#LONCAPA::map::order+1]=$idx;
	          }
# Store the changed version
  	          ($errtext,$fatal)=&storemap($coursenum,$coursedom,
					   $folder.'.'.$container);
	          if ($fatal) {
		      $r->print('<p><font color="red">'.$errtext.'</font></p>');
		      return;
	          }
               } else {
                   $r->print('<p><font color="red">'.&mt('No map selected.').'</font></p>');
               }
           }
           &log_differences($plain);
       }
# ---------------------------------------------------------------- End commands
# ---------------------------------------------------------------- Print screen
        my $idx=0;
	my $shown=0;
        if (($ishidden) || ($isencrypted) || ($randompick>=0)) {
           $r->print('<p>'.&mt('Parameters').':<ul>'.
                     ($randompick>=0?'<li>'.&mt('randomly pick [_1] resources',$randompick).'</li>':'').
                     ($ishidden?'<li>'.&mt('contents hidden').'</li>':'').
                     ($isencrypted?'<li>'.&mt('URLs hidden').'</li>':'').
                     '</ul></p>');
        }                                                                                                     
        if ($randompick>=0) {
           $r->print('<p>'.&mt('Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.').'</p>');
        }
        $r->print('<table>');
        foreach (@LONCAPA::map::order) {
           my ($name,$url)=split(/\:/,$LONCAPA::map::resources[$_]);
	   $name=&LONCAPA::map::qtescape($name);
	   $url=&LONCAPA::map::qtescape($url);
           unless ($name) {  $name=(split(/\//,$url))[-1]; }
           unless ($name) { $idx++; next; }
           $r->print(&entryline($idx,$name,$url,$folder,$allowed,$_,$coursenum));
           $idx++;
	   $shown++;
        }
	unless ($shown) {
	    $r->print('<tr><td>'.&mt('Currently no documents.').'</td></tr>');
	}
        $r->print("\n</table>\n");
	if ($env{'form.markedcopy_url'}) {
	    $r->print(<<ENDPASTE);
<p><form name="pasteform" action="/adm/coursedocs" method="post">
<input type="hidden" name="markedcopy_url" value="$env{'form.markedcopy_url'}" />
<input type="hidden" name="markedcopy_title" value="$env{'form.markedcopy_title'}" />
ENDPASTE
            $r->print(
	   '<input type="submit" name="pastemarked" value="'.&mt('Paste').
		      '" /> '.&Apache::loncommon::filedescription(
		(split(/\./,$env{'form.markedcopy_url'}))[-1]).': '.
		      $env{'form.markedcopy_title'});
            if ($container eq 'page') {
		$r->print(<<PAGEINFO);
<input type="hidden" name="pagepath" value="$env{'form.pagepath'}" />
<input type="hidden" name="pagesymb" value="$env{'form.pagesymb'}" />
PAGEINFO
            } else {
		$r->print(<<FOLDERINFO);
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
FOLDERINFO
	    }
	    $r->print('</form></p>');
	}
    }
}

sub process_file_upload {
    my ($upload_output,$coursenum,$coursedom,$allfiles,$codebase,$uploadcmd) = @_;
# upload a file, if present
    my $parseaction;
   if ($env{'form.parserflag'}) {
        $parseaction = 'parse';
    }
    my $phase_status;
    my $folder=$env{'form.folder'};
    if ($folder eq '') {
        $folder='default';
    }
    if ( ($folder=~/^$uploadcmd/) || ($uploadcmd eq 'default') ) {
        my $errtext='';
        my $fatal=0;
        my $container='sequence';
        if ($env{'form.pagepath'}) {
            $container='page';
        }
        ($errtext,$fatal)=
              &mapread($coursenum,$coursedom,$folder.'.'.$container);
        if ($#LONCAPA::map::order<1) {
            $LONCAPA::map::order[0]=1;
            $LONCAPA::map::resources[1]='';
        }
        if ($fatal) {
            return 'failed';
        }
        my $destination = 'docs/';
        if ($folder =~ /^supplemental/) {
            $destination = 'supplemental/';
        }
        if (($folder eq 'default') || ($folder eq 'supplemental')) {
            $destination .= 'default/';
        } elsif ($folder =~ /^(default|supplemental)_(\d+)$/) {
            $destination .=  $2.'/';
        }
# this is for a course, not a user, so set coursedoc flag
# probably the only place in the system where this should be "1"
        my $newidx=&LONCAPA::map::getresidx();
        $destination .= $newidx;
        my $url=&Apache::lonnet::userfileupload('uploaddoc',1,$destination,
						$parseaction,$allfiles,
						$codebase);
        my $ext='false';
        if ($url=~/^http\:\/\//) { $ext='true'; }
	$url     = &LONCAPA::map::qtunescape($url);
        my $comment=$env{'form.comment'};
	$comment = &LONCAPA::map::qtunescape($comment);
        if ($folder=~/^supplemental/) {
              $comment=time.'___&&&___'.$env{'user.name'}.'___&&&___'.
                  $env{'user.domain'}.'___&&&___'.$comment;
        }

        $LONCAPA::map::resources[$newidx]=
	    $comment.':'.$url.':'.$ext.':normal:res';
        $LONCAPA::map::order[$#LONCAPA::map::order+1]= $newidx;
        ($errtext,$fatal)=&storemap($coursenum,$coursedom,
				    $folder.'.'.$container);
        if ($fatal) {
            $$upload_output .= '<p><font color="red">'.$errtext.'</font></p>';
            return 'failed';
        } else {
            if ($parseaction eq 'parse') {
                my $total_embedded = keys(%{$allfiles});
                if ($total_embedded > 0) {
                    my $num = 0;
		    my $state = '
   <input type="hidden" name="folderpath" value="'.$env{'form.folderpath'}.'" />
   <input type="hidden" name="cmd" value="upload_embedded" />
   <input type="hidden" name="newidx" value="'.$newidx.'" />
   <input type="hidden" name="primaryurl" value="'.&escape($url).'" />
   <input type="hidden" name="phasetwo" value="'.$total_embedded.'" />';
		    $phase_status = 'phasetwo';

                    $$upload_output .= 
			'This file contains embedded multimedia objects, which need to be uploaded to LON-CAPA.<br />'.
			&ask_for_embedded_content('/adm/coursedocs',
						  $state,$allfiles,$codebase);
                } else {
                    $$upload_output .= 'No embedded items identified<br />';
                }
            }
        }
    }
    return $phase_status;
}

sub ask_for_embedded_content {
    my ($actionurl,$state,$allfiles,$codebase,$args)=@_;
    my $upload_output = '
   <form name="upload_embedded" action="'.$actionurl.'"
                  method="post" enctype="multipart/form-data">';
    $upload_output .= $state;
    $upload_output .= '<b>Upload embedded files</b>:<br />'.
	&Apache::loncommon::start_data_table();

    my $num = 0;
    foreach my $embed_file (keys(%{$allfiles})) {
	$upload_output .= &Apache::loncommon::start_data_table_row().
	    '<td>'.$embed_file.'</td><td>';
	if ($args->{'error_on_invalid_names'}
	    && $embed_file ne &Apache::lonnet::clean_filename($embed_file,{'keep_path' => 1,})) {
	    
	    $upload_output.='<span class="LC_warning">'.&mt("Invalid characters").'</span>';
	} else {
	    $upload_output .='
           <input name="embedded_item_'.$num.'" type="file" value="bob" />
           <input name="embedded_orig_'.$num.'" type="hidden" value="'.&escape($embed_file).'" />';
	    my $attrib = join(':',@{$$allfiles{$embed_file}});
	    $upload_output .=
		"\n\t\t".
		'<input name="embedded_attrib_'.$num.'" type="hidden" value="'.
		$attrib.'" />';
	    if (exists($$codebase{$embed_file})) {
		$upload_output .= 
		    "\n\t\t".
		    '<input name="codebase_'.$num.'" type="hidden" value="'.
		    &escape($$codebase{$embed_file}).'" />';
	    }
	}
	$upload_output .= '</td>'.&Apache::loncommon::end_data_table_row();
	$num++;
    }
    $upload_output .= &Apache::loncommon::end_data_table().'<br />
   <input type ="hidden" name="number_embedded_items" value="'.$num.'" />
   <input type ="submit" value="Complete upload" />
   </form>';
    return $upload_output;
}

sub process_secondary_uploads {
    my ($upload_output,$coursedom,$coursenum,$formname,$num,$newidx) = @_;
    my $folder=$env{'form.folder'};
    my $destination = 'docs/';
    if ($folder =~ /^supplemental/) {
        $destination = 'supplemental/';
    }
    if (($folder eq 'default') || ($folder eq 'supplemental')) {
        $destination .= 'default/';
    } elsif ($folder =~ /^(default|supplemental)_(\d+)$/) {
        $destination .=  $2.'/';
    }
    $destination .= $newidx;
    my ($url,$filename);
    $url=&Apache::lonnet::userfileupload($formname.$num,1,$destination);
    ($filename) = ($url =~ m{^/uploaded/\Q$coursedom\E/\Q$coursenum\E/\Q$destination\E/(.+)$});
    return $filename;
}

# --------------------------------------------------------------- An entry line

sub entryline {
    my ($index,$title,$url,$folder,$allowed,$residx,$coursenum)=@_;
    $title=&HTML::Entities::encode($title,'"<>&\'');
    my $renametitle=$title;
    my $foldertitle=$title;
    my $pagetitle=$title;
    my $orderidx=$LONCAPA::map::order[$index];
    if ($title=~ /^(\d+)___&amp;&amp;&amp;___($match_username)___&amp;&amp;&amp;___($match_domain)___&amp;&amp;&amp;___(.*)$/	) { 
	$foldertitle=&Apache::lontexconvert::msgtexconverted($4);
	$renametitle=$4;
	$title='<i>'.&Apache::lonlocal::locallocaltime($1).'</i> '.
	    &Apache::loncommon::plainname($2,$3).': <br />'.
	    $foldertitle;
    }
    $renametitle=~s/\\/\\\\/g;
    $renametitle=~s/\&quot\;/\\\"/g;
    my $line='<tr>';
# Edit commands
    my $container;
    my $folderpath;
    if ($env{'form.folderpath'}) {
        $container = 'sequence';
	$folderpath=&escape($env{'form.folderpath'});
	# $htmlfoldername=&HTML::Entities::encode($env{'form.foldername'},'<>&"');
    }
    my ($pagepath,$pagesymb);
    if ($env{'form.pagepath'}) {
        $container = 'page';
        $pagepath=&escape($env{'form.pagepath'});
        $pagesymb=&escape($env{'form.pagesymb'});
    }
    my $cpinfo='';
    if ($env{'form.markedcopy_url'}) {
       $cpinfo='&markedcopy_url='.
               &escape($env{'form.markedcopy_url'}).
               '&markedcopy_title='.
               &escape($env{'form.markedcopy_title'});
    }
    if ($allowed) {
	my $incindex=$index+1;
	my $selectbox='';
	if (($folder!~/^supplemental/) &&
	    ($#LONCAPA::map::order>0) && 
	    ((split(/\:/,
	     $LONCAPA::map::resources[$LONCAPA::map::order[0]]))[1] 
	     ne '') && 
	    ((split(/\:/,
	     $LONCAPA::map::resources[$LONCAPA::map::order[1]]))[1] 
	     ne '')) {
	    $selectbox=
		'<input type="hidden" name="currentpos" value="'.$incindex.'" />'.
		'<select name="newpos" onChange="this.form.submit()">';
	    for (my $i=1;$i<=$#LONCAPA::map::order+1;$i++) {
		if ($i==$incindex) {
		    $selectbox.='<option value="" selected="1">('.$i.')</option>';
		} else {
		    $selectbox.='<option value="'.$i.'">'.$i.'</option>';
		}
	    }
	    $selectbox.='</select>';
	}
	my %lt=&Apache::lonlocal::texthash(
                'up' => 'Move Up',
		'dw' => 'Move Down',
		'rm' => 'Remove',
                'ct' => 'Cut',
		'rn' => 'Rename',
		'cp' => 'Copy');
	my $nocopy=0;
        my $nocut=0;
        if ($url=~/\.(page|sequence)$/) {
	    foreach (&Apache::lonsequence::attemptread(&Apache::lonnet::filelocation('',$url))) {
		my ($title,$url,$ext,$type)=split(/\:/,$_);
		if (($url=~/\.(page|sequence)/) && ($type ne 'zombie')) {
		    $nocopy=1;
		    last;
		}
	    }
	}
        if ($url=~/^\/res\/lib\/templates\//) { 
           $nocopy=1; 
           $nocut=1;
        }
        my $copylink='&nbsp;';
        my $cutlink='&nbsp;';
        if ($env{'form.pagepath'}) {
           if (!$nocopy) {
               $copylink=(<<ENDCOPY);
<a href='javascript:markcopy("$pagepath","$index","$renametitle","page","$pagesymb");'>
<font size="-2" color="#000099">$lt{'cp'}</font></a></td>
ENDCOPY
           }
           if (!$nocut) {
               $cutlink=(<<ENDCUT);
<a href='javascript:cutres("$pagepath","$index","$renametitle","page","$pagesymb");'>
<font size="-2" color="#550044">$lt{'ct'}</font></a>
ENDCUT
            }
            $line.=(<<END);
<form name="entry_$index" action="/adm/coursedocs" method="post">
<input type="hidden" name="pagepath" value="$env{'form.pagepath'}" />
<input type="hidden" name="pagesymb" value="$env{'form.pagesymb'}" />
<input type="hidden" name="markedcopy_url" value="$env{'form.markedcopy_url'}" />
<input type="hidden" name="markedcopy_title" value="$env{'form.markedcopy_title'}" />
<input type="hidden" name="setparms" value="$orderidx" />
<input type="hidden" name="changeparms" value="0" />
<td><table border='0' cellspacing='2' cellpadding='0'>
<tr><td bgcolor="#DDDDDD">
<a href='/adm/coursedocs?cmd=up_$index&pagepath=$pagepath&pagesymb=$pagesymb$cpinfo'>
<img src="${iconpath}move_up.gif" alt='$lt{'up'}' border='0' /></a></td></tr>
<tr><td bgcolor="#DDDDDD">
<a href='/adm/coursedocs?cmd=down_$index&pagepath=$pagepath&pagesymb=$pagesymb$cpinfo'>
<img src="${iconpath}move_down.gif" alt='$lt{'dw'}' border='0' /></a></td></tr>
</table></td>
<td>$selectbox
</td><td bgcolor="#DDDDDD">
<a href='javascript:removeres("$pagepath","$index","$renametitle","page","$pagesymb");'>
<font size="-2" color="#990000">$lt{'rm'}</font></a>
$cutlink
<a href='javascript:changename("$pagepath","$index","$renametitle","page","$pagesymb");'>
<font size="-2" color="#009900">$lt{'rn'}</font></a>
$copylink
END
        } else {
           if (!$nocopy) {
               $copylink=(<<ENDCOPY);
<a href='javascript:markcopy("$folderpath","$index","$renametitle","sequence");'>
<font size="-2" color="#000099">$lt{'cp'}</font></a></td>
ENDCOPY
            }
            if (!$nocut) {
               $cutlink=(<<ENDCUT);
<a href='javascript:cutres("$folderpath","$index","$renametitle","sequence");'>
<font size="-2" color="#550044">$lt{'ct'}</font></a>
ENDCUT
            }
            $line.=(<<END); 
<form name="entry_$index" action="/adm/coursedocs" method="post">
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
<input type="hidden" name="markedcopy_url" value="$env{'form.markedcopy_url'}" />
<input type="hidden" name="markedcopy_title" value="$env{'form.markedcopy_title'}" />
<input type="hidden" name="setparms" value="$orderidx" />
<input type="hidden" name="changeparms" value="0" />
<td><table border='0' cellspacing='2' cellpadding='0'>
<tr><td bgcolor="#DDDDDD">
<a href='/adm/coursedocs?cmd=up_$index&folderpath=$folderpath$cpinfo'>
<img src="${iconpath}move_up.gif" alt='$lt{'up'}' border='0' /></a></td></tr>
<tr><td bgcolor="#DDDDDD">
<a href='/adm/coursedocs?cmd=down_$index&folderpath=$folderpath$cpinfo'>
<img src="${iconpath}move_down.gif" alt='$lt{'dw'}' border='0' /></a></td></tr>
</table></td>
<td>$selectbox
</td><td bgcolor="#DDDDDD">
<a href='javascript:removeres("$folderpath","$index","$renametitle","sequence");'>
<font size="-2" color="#990000">$lt{'rm'}</font></a>
$cutlink
<a href='javascript:changename("$folderpath","$index","$renametitle","sequence");'>
<font size="-2" color="#009900">$lt{'rn'}</font></a>
$copylink
END
        }
    }
# Figure out what kind of a resource this is
    my ($extension)=($url=~/\.(\w+)$/);
    my $uploaded=($url=~/^\/*uploaded\//);
    my $icon=&Apache::loncommon::icon($url);
    my $isfolder=0;
    my $ispage=0;
    my $folderarg;
    my $pagearg;
    my $pagefile;
    if ($uploaded) {
	if ($extension eq 'sequence') {
	    $icon=$iconpath.'/folder_closed.gif';
	    $url=~/\Q$coursenum\E\/([\/\w]+)\.sequence$/;
	    $url='/adm/coursedocs?';
	    $folderarg=$1;
	    $isfolder=1;
        } elsif ($extension eq 'page') {
            $icon=$iconpath.'/page.gif';
            $url=~/\Q$coursenum\E\/([\/\w]+)\.page$/;
            $pagearg=$1;
            $url='/adm/coursedocs?';
            $ispage=1;
	} else {
	    &Apache::lonnet::allowuploaded('/adm/coursedoc',$url);
	}
    }
    $url=~s-^http(\&colon\;|:)//-/adm/wrapper/ext/-;
    if ((!$isfolder) && ($residx) && ($folder!~/supplemental/) && (!$ispage)) {
	my $symb=&Apache::lonnet::symbclean(
          &Apache::lonnet::declutter('uploaded/'.
           $env{'course.'.$env{'request.course.id'}.'.domain'}.'/'.
           $env{'course.'.$env{'request.course.id'}.'.num'}.'/'.$folder.
           '.sequence').
           '___'.$residx.'___'.
	   &Apache::lonnet::declutter($url));
	(undef,undef,$url)=&Apache::lonnet::decode_symb($symb);
	$url=&Apache::lonnet::clutter($url);
	if ($url=~/^\/*uploaded\//) {
	    $url=~/\.(\w+)$/;
	    my $embstyle=&Apache::loncommon::fileembstyle($1);
	    if (($embstyle eq 'img') || ($embstyle eq 'emb')) {
		$url='/adm/wrapper'.$url;
	    } elsif ($embstyle eq 'ssi') {
		#do nothing with these
	    } elsif ($url!~/\.(sequence|page)$/) {
		$url='/adm/coursedocs/showdoc'.$url;
	    }
	} elsif ($url=~m|^/ext/|) { 
	    $url='/adm/wrapper'.$url;
	}
        if (&Apache::lonnet::symbverify($symb,$url)) {
	    $url.=(($url=~/\?/)?'&':'?').'symb='.&escape($symb);
        } else {
            $url='';
        }
	if ($container eq 'page') {
	    my $symb=$env{'form.pagesymb'};
	    	    
	    $url=&Apache::lonnet::clutter((&Apache::lonnet::decode_symb($symb))[2]);
	    $url.=(($url=~/\?/)?'&':'?').'symb='.&escape($symb);
	}
    }
    my $parameterset='&nbsp;';
    if ($isfolder || $extension eq 'sequence') {
	my $foldername=&escape($foldertitle);
	my $folderpath=$env{'form.folderpath'};
	if ($folderpath) { $folderpath.='&' };
# Append randompick number, hidden, and encrypted with ":" to foldername, 
# so it gets transferred between levels
	$folderpath.=$folderarg.'&'.$foldername.':'.(&LONCAPA::map::getparameter($orderidx,
                                              'parameter_randompick'))[0]
                                               .':'.((&LONCAPA::map::getparameter($orderidx,
                                              'parameter_hiddenresource'))[0]=~/^yes$/i)
                                               .':'.((&LONCAPA::map::getparameter($orderidx,
                                              'parameter_encrypturl'))[0]=~/^yes$/i);
	$url.='folderpath='.&escape($folderpath).$cpinfo;
	$parameterset='<label>'.&mt('Randomly Pick: ').
	    '<input type="text" size="4" onChange="this.form.changeparms.value='."'randompick'".';this.form.submit()" name="randpick_'.$orderidx.'" value="'.
	    (&LONCAPA::map::getparameter($orderidx,
                                              'parameter_randompick'))[0].
                                              '" />'.
'<font size="-2"><a href="javascript:void(0)">'.&mt('Save').'</a></font></label>';
       
    }
    if ($ispage) {
        my $pagename=&escape($pagetitle);
        my $pagepath;
        my $folderpath=$env{'form.folderpath'};
        if ($folderpath) { $pagepath = $folderpath.'&' };
        $pagepath.=$pagearg.'&'.$pagename;
	my $symb=$env{'form.pagesymb'};
	if (!$symb) {
	    my $path='uploaded/'.
		$env{'course.'.$env{'request.course.id'}.'.domain'}.'/'.
		$env{'course.'.$env{'request.course.id'}.'.num'}.'/';
	    $symb=&Apache::lonnet::encode_symb($path.$folder.'.sequence',
					       $residx,
					       $path.$pagearg.'.page');
	}
	$url.='pagepath='.&escape($pagepath).
	    '&pagesymb='.&escape($symb).$cpinfo;
    }
    $line.='<td bgcolor="#FFFFBB"><a href="'.$url.'"><img src="'.$icon.
	'" border="0"></a></td>'.
        "<td bgcolor='#FFFFBB'>".($url?"<a href=\"$url\">":'').$title.
        ($url?'</a>':' <font size="-2">'.&mt('(re-initialize course to access)').'</font>')."</td>";
    if (($allowed) && ($folder!~/^supplemental/)) {
 	my %lt=&Apache::lonlocal::texthash(
 			      'hd' => 'Hidden',
 			      'ec' => 'URL hidden');
	my $enctext=
	    ((&LONCAPA::map::getparameter($orderidx,'parameter_encrypturl'))[0]=~/^yes$/i?' checked="1"':'');
	my $hidtext=
	    ((&LONCAPA::map::getparameter($orderidx,'parameter_hiddenresource'))[0]=~/^yes$/i?' checked="1"':'');
	$line.=(<<ENDPARMS);
<td bgcolor="#BBBBFF"><font size='-2'>
<nobr><label><input type="checkbox" name="hidprs_$orderidx" onClick="this.form.changeparms.value='hiddenresource';this.form.submit()" $hidtext /> $lt{'hd'}</label></nobr></td>
<td bgcolor="#BBBBFF"><font size='-2'>
<nobr><label><input type="checkbox" name="encprs_$orderidx" onClick="this.form.changeparms.value='encrypturl';this.form.submit()" $enctext /> $lt{'ec'}</label></nobr></td>
<td bgcolor="#BBBBFF"><font size="-2">$parameterset</font></td>
ENDPARMS
    }
    $line.="</form></tr>";
    return $line;
}

# ---------------------------------------------------------------- tie the hash

sub tiehash {
    my ($mode)=@_;
    $hashtied=0;
    if ($env{'request.course.fn'}) {
	if ($mode eq 'write') {
	    if (tie(%hash,'GDBM_File',$env{'request.course.fn'}.".db",
		    &GDBM_WRCREAT(),0640)) {
                $hashtied=2;
	    }
	} else {
	    if (tie(%hash,'GDBM_File',$env{'request.course.fn'}.".db",
		    &GDBM_READER(),0640)) {
                $hashtied=1;
	    }
	}
    }    
}

sub untiehash {
    if ($hashtied) { untie %hash; }
    $hashtied=0;
    return OK;
}

# --------------------------------------------------------------- check on this

sub checkonthis {
    my ($r,$url,$level,$title)=@_;
    $url=&unescape($url);
    $alreadyseen{$url}=1;
    $r->rflush();
    if (($url) && ($url!~/^\/uploaded\//) && ($url!~/\*$/)) {
       $r->print("\n<br />");
       for (my $i=0;$i<=$level*5;$i++) {
           $r->print('&nbsp;');
       }
       $r->print('<a href="'.$url.'" target="cat">'.
		 ($title?$title:$url).'</a> ');
       if ($url=~/^\/res\//) {
	  my $result=&Apache::lonnet::repcopy(
                              &Apache::lonnet::filelocation('',$url));
          if ($result eq 'ok') {
             $r->print('<font color="green">'.&mt('ok').'</font>');
             $r->rflush();
             &Apache::lonnet::countacc($url);
             $url=~/\.(\w+)$/;
             if (&Apache::loncommon::fileembstyle($1) eq 'ssi') {
		 $r->print('<br />');
                 $r->rflush();
                 for (my $i=0;$i<=$level*5;$i++) {
                     $r->print('&nbsp;');
                 }
                 $r->print('- '.&mt('Rendering').': ');
		 my ($errorcount,$warningcount)=split(/:/,
	       &Apache::lonnet::ssi_body($url,
			       ('grade_target'=>'web',
				'return_only_error_and_warning_counts' => 1)));
                 if (($errorcount) ||
                     ($warningcount)) {
		     if ($errorcount) {
                        $r->print('<img src="/adm/lonMisc/bomb.gif" /><font color="red"><b>'.
			  $errorcount.' '.
				  &mt('error(s)').'</b></font> ');
                     }
		     if ($warningcount) {
                        $r->print('<font color="blue">'.
			  $warningcount.' '.
				  &mt('warning(s)').'</font>');
                     }
                 } else {
                     $r->print('<font color="green">'.&mt('ok').'</font>');
                 }
                 $r->rflush();
             }
	     my $dependencies=
                &Apache::lonnet::metadata($url,'dependencies');
             foreach (split(/\,/,$dependencies)) {
		 if (($_=~/^\/res\//) && (!$alreadyseen{$_})) {
                    &checkonthis($r,$_,$level+1);
                 }
             }
          } elsif ($result eq 'unavailable') {
             $r->print('<font color="red"><b>'.&mt('connection down').'</b></font>');
          } elsif ($result eq 'not_found') {
	      unless ($url=~/\$/) {
		  $r->print('<font color="red"><b>'.&mt('not found').'</b></font>');
	      } else {
		  $r->print('<font color="yellow"><b>'.&mt('unable to verify variable URL').'</b></font>');
	      }
          } else {
             $r->print('<font color="red"><b>'.&mt('access denied').'</b></font>');
          }
      }
   }
}


#
# ----------------------------------------------------------------- List Symbs
# 
sub list_symbs {
    my ($r) = @_;

    $r->print(&Apache::loncommon::start_page('Symb List'));
    $r->print(&Apache::lonhtmlcommon::breadcrumbs('Symb List'));
    my $navmap = Apache::lonnavmaps::navmap->new();
    $r->print("<pre>\n");
    foreach my $res ($navmap->retrieveResources()) {
	$r->print($res->compTitle()."\t".$res->symb()."\n");
    }
    $r->print("\n</pre>\n");
    $r->print('<a href="/adm/coursedocs">'.&mt('Return to DOCS').'</a>');
}


#
# -------------------------------------------------------------- Verify Content
# 
sub verifycontent {
    my ($r) = @_;
    my $type = &Apache::loncommon::course_type();
   my $loaderror=&Apache::lonnet::overloaderror($r);
   if ($loaderror) { return $loaderror; }
   $r->print(&Apache::loncommon::start_page('Verify '.$type.' Documents'));
   $r->print(&Apache::lonhtmlcommon::breadcrumbs('Verify '.$type.' Documents'));
   $hashtied=0;
   undef %alreadyseen;
   %alreadyseen=();
   &tiehash();
   foreach (keys %hash) {
       if ($hash{$_}=~/\.(page|sequence)$/) {
	   if (($_=~/^src_/) && ($alreadyseen{&unescape($hash{$_})})) {
	       $r->print('<hr /><font color="red">'.
			 &mt('The following sequence or page is included more than once in your '.$type.': ').
			 &unescape($hash{$_}).'</font><br />'.
			 &mt('Note that grading records for problems included in this sequence or folder will overlap.<hr />'));
	   }
       }
       if (($_=~/^src\_(.+)$/) && (!$alreadyseen{&unescape($hash{$_})})) {
           &checkonthis($r,$hash{$_},0,$hash{'title_'.$1});
       }
   }
   &untiehash();
   $r->print('<h1>'.&mt('Done').'.</h1>'.'<a href="/adm/coursedocs">'.
	     &mt('Return to DOCS').'</a>');
}


# -------------------------------------------------------------- Check Versions

sub devalidateversioncache {
    my $src=shift;
    &Apache::lonnet::devalidate_cache_new('courseresversion',$env{'request.course.id'}.'_'.
					  &Apache::lonnet::clutter($src));
}

sub checkversions {
    my ($r) = @_;
    my $type = &Apache::loncommon::course_type();
    $r->print(&Apache::loncommon::start_page("Check $type Document Versions"));
    $r->print(&Apache::lonhtmlcommon::breadcrumbs("Check $type Document Versions"));
    my $header='';
    my $startsel='';
    my $monthsel='';
    my $weeksel='';
    my $daysel='';
    my $allsel='';
    my %changes=();
    my $starttime=0;
    my $haschanged=0;
    my %setversions=&Apache::lonnet::dump('resourceversions',
			  $env{'course.'.$env{'request.course.id'}.'.domain'},
			  $env{'course.'.$env{'request.course.id'}.'.num'});

    $hashtied=0;
    &tiehash();
    my %newsetversions=();
    if ($env{'form.setmostrecent'}) {
	$haschanged=1;
	foreach (keys %hash) {
	    if ($_=~/^ids\_(\/res\/.+)$/) {
		$newsetversions{$1}='mostrecent';
                &devalidateversioncache($1);
	    }
	}
    } elsif ($env{'form.setcurrent'}) {
	$haschanged=1;
	foreach (keys %hash) {
	    if ($_=~/^ids\_(\/res\/.+)$/) {
		my $getvers=&Apache::lonnet::getversion($1);
		if ($getvers>0) {
		    $newsetversions{$1}=$getvers;
		    &devalidateversioncache($1);
		}
	    }
	}
    } elsif ($env{'form.setversions'}) {
	$haschanged=1;
	foreach (keys %env) {
	    if ($_=~/^form\.set_version_(.+)$/) {
		my $src=$1;
		if (($env{$_}) && ($env{$_} ne $setversions{$src})) {
		    $newsetversions{$src}=$env{$_};
		    &devalidateversioncache($src);
		}
	    }
	}
    }
    if ($haschanged) {
        if (&Apache::lonnet::put('resourceversions',\%newsetversions,
			  $env{'course.'.$env{'request.course.id'}.'.domain'},
			  $env{'course.'.$env{'request.course.id'}.'.num'}) eq 'ok') {		
	    $r->print('<h1>'.&mt('Your Version Settings have been Saved').'</h1>');
	} else {
	    $r->print('<h1><font color="red">'.&mt('An Error Occured while Attempting to Save your Version Settings').'</font></h1>');
	}
	&mark_hash_old();
    }
    &changewarning($r,'');
    if ($env{'form.timerange'} eq 'all') {
# show all documents
	$header=&mt('All Documents in '.$type);
	$allsel=1;
	foreach (keys %hash) {
	    if ($_=~/^ids\_(\/res\/.+)$/) {
		my $src=$1;
		$changes{$src}=1;
	    }
	}
    } else {
# show documents which changed
	%changes=&Apache::lonnet::dump
	 ('versionupdate',$env{'course.'.$env{'request.course.id'}.'.domain'},
                     $env{'course.'.$env{'request.course.id'}.'.num'});
	my $firstkey=(keys %changes)[0];
	unless ($firstkey=~/^error\:/) {
	    unless ($env{'form.timerange'}) {
		$env{'form.timerange'}=604800;
	    }
	    my $seltext=&mt('during the last').' '.$env{'form.timerange'}.' '
		.&mt('seconds');
	    if ($env{'form.timerange'}==-1) {
		$seltext='since start of course';
		$startsel='selected';
		$env{'form.timerange'}=time;
	    }
	    $starttime=time-$env{'form.timerange'};
	    if ($env{'form.timerange'}==2592000) {
		$seltext=&mt('during the last month').' ('.&Apache::lonlocal::locallocaltime($starttime).')';
		$monthsel='selected';
	    } elsif ($env{'form.timerange'}==604800) {
		$seltext=&mt('during the last week').' ('.&Apache::lonlocal::locallocaltime($starttime).')';
		$weeksel='selected';
	    } elsif ($env{'form.timerange'}==86400) {
		$seltext=&mt('since yesterday').' ('.&Apache::lonlocal::locallocaltime($starttime).')';
		$daysel='selected';
	    }
	    $header=&mt('Content changed').' '.$seltext;
	} else {
	    $header=&mt('No content modifications yet.');
	}
    }
    %setversions=&Apache::lonnet::dump('resourceversions',
			  $env{'course.'.$env{'request.course.id'}.'.domain'},
			  $env{'course.'.$env{'request.course.id'}.'.num'});
    my %lt=&Apache::lonlocal::texthash
	      ('st' => 'Version changes since start of '.$type,
	       'lm' => 'Version changes since last Month',
	       'lw' => 'Version changes since last Week',
	       'sy' => 'Version changes since Yesterday',
               'al' => 'All Resources (possibly large output)',
	       'sd' => 'Display',
	       'fi' => 'File',
	       'md' => 'Modification Date',
               'mr' => 'Most recently published Version',
	       've' => 'Version used in '.$type,
               'vu' => 'Set Version to be used in '.$type,
'sv' => 'Set Versions to be used in '.$type.' according to Selections below',
'sm' => 'Keep all Resources up-to-date with most recent Versions (default)',
'sc' => 'Set all Resource Versions to current Version (Fix Versions)',
	       'di' => 'Differences');
    $r->print(<<ENDHEADERS);
<form action="/adm/coursedocs" method="post">
<input type="hidden" name="versions" value="1" />
<input type="submit" name="setmostrecent" value="$lt{'sm'}" />
<input type="submit" name="setcurrent" value="$lt{'sc'}" /><hr />
<select name="timerange">
<option value='all' $allsel>$lt{'al'}</option>
<option value="-1" $startsel>$lt{'st'}</option>
<option value="2592000" $monthsel>$lt{'lm'}</option>
<option value="604800" $weeksel>$lt{'lw'}</option>
<option value="86400" $daysel>$lt{'sy'}</option>
</select>
<input type="submit" name="display" value="$lt{'sd'}" />
<h3>$header</h3>
<input type="submit" name="setversions" value="$lt{'sv'}" />
<table border="0">
ENDHEADERS
    foreach (sort keys %changes) {
	if ($changes{$_}>$starttime) {
	    my ($root,$extension)=($_=~/^(.*)\.(\w+)$/);
	    my $currentversion=&Apache::lonnet::getversion($_);
	    if ($currentversion<0) {
		$currentversion=&mt('Could not be determined.');
	    }
	    my $linkurl=&Apache::lonnet::clutter($_);
	    $r->print(
		      '<tr><td colspan="5"><br /><br /><font size="+1"><b>'.
		      &Apache::lonnet::gettitle($linkurl).
                      '</b></font></td></tr>'.
                      '<tr><td>&nbsp;&nbsp;&nbsp;</td>'.
                      '<td colspan="4">'.
                      '<a href="'.$linkurl.'" target="cat">'.$linkurl.
		      '</a></td></tr>'.
                      '<tr><td></td>'.
                      '<td title="'.$lt{'md'}.'">'.
		      &Apache::lonlocal::locallocaltime(
                           &Apache::lonnet::metadata($root.'.'.$extension,
                                                     'lastrevisiondate')
                                                        ).
                      '</td>'.
                      '<td title="'.$lt{'mr'}.'"><nobr>Most Recent: '.
                      '<font size="+1">'.$currentversion.'</font>'.
                      '</nobr></td>'.
                      '<td title="'.$lt{'ve'}.'"><nobr>In '.$type.': '.
                      '<font size="+1">');
# Used in course
	    my $usedversion=$hash{'version_'.$linkurl};
	    if (($usedversion) && ($usedversion ne 'mostrecent')) {
		$r->print($usedversion);
	    } else {
		$r->print($currentversion);
	    }
	    $r->print('</font></nobr></td><td title="'.$lt{'vu'}.'">'.
                      '<nobr>Use: ');
# Set version
	    $r->print(&Apache::loncommon::select_form($setversions{$linkurl},
						      'set_version_'.$linkurl,
						      ('select_form_order' =>
						       ['',1..$currentversion,'mostrecent'],
						       '' => '',
						       'mostrecent' => 'most recent',
						       map {$_,$_} (1..$currentversion))));
	    $r->print('</nobr></td></tr><tr><td></td>');
	    my $lastold=1;
	    for (my $prevvers=1;$prevvers<$currentversion;$prevvers++) {
		my $url=$root.'.'.$prevvers.'.'.$extension;
		if (&Apache::lonnet::metadata($url,'lastrevisiondate')<
		    $starttime) {
		    $lastold=$prevvers;
		}
	    }
            # 
            # Code to figure out how many version entries should go in
            # each of the four columns
            my $entries_per_col = 0;
            my $num_entries = ($currentversion-$lastold);
            if ($num_entries % 4 == 0) {
                $entries_per_col = $num_entries/4;
            } else {
                $entries_per_col = $num_entries/4 + 1;
            }
            my $entries_count = 0;
            $r->print('<td valign="top"><font size="-2">'); 
            my $cols_output = 1;
            for (my $prevvers=$lastold;$prevvers<$currentversion;$prevvers++) {
		my $url=$root.'.'.$prevvers.'.'.$extension;
		$r->print('<nobr><a href="'.&Apache::lonnet::clutter($url).
			  '">'.&mt('Version').' '.$prevvers.'</a> ('.
			  &Apache::lonlocal::locallocaltime(
                                &Apache::lonnet::metadata($url,
                                                          'lastrevisiondate')
                                                            ).
			  ')');
		if (&Apache::loncommon::fileembstyle($extension) eq 'ssi') {
                    $r->print(' <a href="/adm/diff?filename='.
			      &Apache::lonnet::clutter($root.'.'.$extension).
			      '&versionone='.$prevvers.
			      '">'.&mt('Diffs').'</a>');
		}
		$r->print('</nobr><br />');
                if (++$entries_count % $entries_per_col == 0) {
                    $r->print('</font></td>');
                    if ($cols_output != 4) {
                        $r->print('<td valign="top"><font size="-2">');
                        $cols_output++;
                    }
                }
	    }
            while($cols_output++ < 4) {
                $r->print('</font></td><td><font>')
            }
	    $r->print('</font></td></tr>'."\n");
	}
    }
    $r->print('</table></form>');
    $r->print('<h1>'.&mt('Done').'.</h1>');

    &untiehash();
}

sub mark_hash_old {
    my $retie_hash=0;
    if ($hashtied) {
	$retie_hash=1;
	&untiehash();
    }
    &tiehash('write');
    $hash{'old'}=1;
    &untiehash();
    if ($retie_hash) { &tiehash(); }
}

sub is_hash_old {
    my $untie_hash=0;
    if (!$hashtied) {
	$untie_hash=1;
	&tiehash();
    }
    my $return=$hash{'old'};
    if ($untie_hash) { &untiehash(); }
    return $return;
}

sub changewarning {
    my ($r,$postexec,$message,$url)=@_;
    if (!&is_hash_old()) { return; }
    my $pathvar='folderpath';
    my $path=&escape($env{'form.folderpath'});
    if (!defined($url)) {
	if (defined($env{'form.pagepath'})) {
	    $pathvar='pagepath';
	    $path=&escape($env{'form.pagepath'});
	    $path.='&amp;pagesymb='.&escape($env{'form.pagesymb'});
	}
	$url='/adm/coursedocs?'.$pathvar.'='.$path;
    }
    my $course_type = &Apache::loncommon::course_type();
    if (!defined($message)) {
	$message='Changes will become active for your current session after [_1], or the next time you log in.';
    }
    $r->print("\n\n".
'<script>function reinit(tf) { tf.submit();'.$postexec.' }</script>'."\n". 
'<form name="reinitform" method="post" action="/adm/roles" target="loncapaclient">'.
'<input type="hidden" name="orgurl" value="'.$url.
'" /><input type="hidden" name="selectrole" value="1" /><h3><font color="red">'.
&mt($message,' <input type="hidden" name="'.
    $env{'request.role'}.'" value="1" /><input type="button" value="'.
    &mt('re-initializing '.$course_type).'" onClick="reinit(this.form)" />').
$help{'Caching'}.'</font></h3></form>'."\n\n");
}

# =========================================== Breadcrumbs for special functions

sub init_breadcrumbs {
    my ($form,$text)=@_;
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    &Apache::lonhtmlcommon::add_breadcrumb({href=>"/adm/coursedocs",
					    text=>&Apache::loncommon::course_type()." Documents",
					    faq=>273,
					    bug=>'Instructor Interface',
                                            help => 'Docs_Adding_Course_Doc'});
    &Apache::lonhtmlcommon::add_breadcrumb({href=>"/adm/coursedocs?".$form.'=1',
					    text=>$text,
					    faq=>273,
					    bug=>'Instructor Interface'});
}

# ================================================================ Main Handler
sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
    my $type = &Apache::loncommon::course_type();

# --------------------------------------------- Initialize help topics for this
    foreach ('Adding_Course_Doc','Main_Course_Documents',
	     'Adding_External_Resource','Navigate_Content',
	     'Adding_Folders','Docs_Overview', 'Load_Map',
	     'Supplemental','Score_Upload_Form','Adding_Pages',
	     'Importing_LON-CAPA_Resource','Uploading_From_Harddrive',
	     'Check_Resource_Versions','Verify_Content') {
	$help{$_}=&Apache::loncommon::help_open_topic('Docs_'.$_);
    }
    # Composite help files
    $help{'Syllabus'} = &Apache::loncommon::help_open_topic(
		    'Docs_About_Syllabus,Docs_Editing_Templated_Pages');
    $help{'Simple Page'} = &Apache::loncommon::help_open_topic(
		    'Docs_About_Simple_Page,Docs_Editing_Templated_Pages');
    $help{'Simple Problem'} = &Apache::loncommon::help_open_topic(
		    'Option_Response_Simple');
    $help{'Bulletin Board'} = &Apache::loncommon::help_open_topic(
		    'Docs_About_Bulletin_Board,Docs_Editing_Templated_Pages');
    $help{'My Personal Info'} = &Apache::loncommon::help_open_topic(
		  'Docs_About_My_Personal_Info,Docs_Editing_Templated_Pages');
    $help{'Group Files'} = &Apache::loncommon::help_open_topic('Docs_About_Group_Files');
    $help{'Caching'} = &Apache::loncommon::help_open_topic('Caching');

# does this user have privileges to modify docs
    my $allowed=&Apache::lonnet::allowed('mdc',$env{'request.course.id'});
  if ($allowed && $env{'form.verify'}) {
      &init_breadcrumbs('verify','Verify Content');
      &verifycontent($r);
  } elsif ($allowed && $env{'form.listsymbs'}) {
      &init_breadcrumbs('listsymbs','List Symbs');
      &list_symbs($r);
  } elsif ($allowed && $env{'form.docslog'}) {
      &init_breadcrumbs('docslog','Show Log');
      &docs_change_log($r);
  } elsif ($allowed && $env{'form.versions'}) {
      &init_breadcrumbs('versions','Check/Set Resource Versions');
      &checkversions($r);
  } elsif ($allowed && $env{'form.dumpcourse'}) {
      &init_breadcrumbs('dumpcourse','Dump '.&Apache::loncommon::course_type().' DOCS to Construction Space');
      &dumpcourse($r);
  } elsif ($allowed && $env{'form.exportcourse'}) {
      &init_breadcrumbs('exportcourse','Export '.&Apache::loncommon::course_type().' to IMS');
      &exportcourse($r);
  } else {
# is this a standard course?

    my $standard=($env{'request.course.uri'}=~/^\/uploaded\//);
    my $forcestandard = 0;
    my $forcesupplement;
    my $script='';
    my $showdoc=0;
    my $containertag;
    my $uploadtag;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
					    ['folderpath','pagepath',
					     'pagesymb','markedcopy_url',
					     'markedcopy_title']);
    if ($env{'form.folderpath'}) {
	my (@folderpath)=split('&',$env{'form.folderpath'});
	$env{'form.foldername'}=&unescape(pop(@folderpath));
	$env{'form.folder'}=pop(@folderpath);
    }
    if ($env{'form.pagepath'}) {
        my (@pagepath)=split('&',$env{'form.pagepath'});
        $env{'form.pagename'}=&unescape(pop(@pagepath));
        $env{'form.folder'}=pop(@pagepath);
        $containertag = '<input type="hidden" name="pagepath" value="" />'.
	    '<input type="hidden" name="pagesymb" value="" />';
        $uploadtag = '<input type="hidden" name="pagepath" value="'.$env{'form.pagepath'}.'" />'.
	    '<input type="hidden" name="pagesymb" value="'.$env{'form.pagesymb'}.'" />';
    }
    if ($r->uri=~/^\/adm\/coursedocs\/showdoc\/(.*)$/) {
       $showdoc='/'.$1;
    }
    unless ($showdoc) { # got called from remote
       if (($env{'form.folder'}=~/^(?:group|default)_/) || 
          ($env{'form.folder'} =~ m:^\d+/(pages|sequences)/:)) {
           $forcestandard = 1;
       } 
       $forcesupplement=($env{'form.folder'}=~/^supplemental_/);

       if ($allowed) { 
         &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['cmd']);
         $script=&Apache::lonratedt::editscript('simple'); 
       }
    } else { # got called in sequence from course
       $allowed=0;
    }

# get course data
    my $coursenum=$env{'course.'.$env{'request.course.id'}.'.num'};
    my $coursedom=$env{'course.'.$env{'request.course.id'}.'.domain'};

# get personal data 
    my $uname=$env{'user.name'};
    my $udom=$env{'user.domain'};
    my $plainname=&escape(&Apache::loncommon::plainname($uname,$udom));

# graphics settings

    $iconpath = &Apache::loncommon::lonhttpdurl($r->dir_config('lonIconsURL') . "/");

    if ($allowed) {
	$script .= &editing_js($udom,$uname);
    }
# -------------------------------------------------------------------- Body tag
    $script = '<script type="text/javascript">'."\n".$script."\n".'</script>';
    $r->print(&Apache::loncommon::start_page("$type Documents", $script,
					     {'force_register' => $showdoc,}).
	      &Apache::loncommon::help_open_menu('','',273,'RAT'));
  
  my %allfiles = ();
  my %codebase = ();
  my ($upload_result,$upload_output);
  if ($allowed) {
      if (($env{'form.uploaddoc.filename'}) &&
	  ($env{'form.cmd'}=~/^upload_(\w+)/)) {
# Process file upload - phase one - upload and parse primary file.  
          $upload_result = &process_file_upload(\$upload_output,$coursenum,
						$coursedom,\%allfiles,
						\%codebase,$1);
          if ($upload_result eq 'phasetwo') {
              $r->print($upload_output);
          }
      } elsif ($env{'form.phasetwo'}) {
          my %newname = ();
          my %origname = ();
          my %attribs = ();
          my $updateflag = 0;
          my $residx = $env{'form.newidx'};
          my $primary_url = &unescape($env{'form.primaryurl'});
# Process file upload - phase two - gather secondary files.
          for (my $i=0; $i<$env{'form.phasetwo'}; $i++) {
              if ($env{'form.embedded_item_'.$i.'.filename'}) {
                  my $javacodebase;
                  $newname{$i} = &process_secondary_uploads(\$upload_output,$coursedom,$coursenum,'embedded_item_',$i,$residx);
                  $origname{$i} = &unescape($env{'form.embedded_orig_'.$i});
                  if (exists($env{'form.embedded_codebase_'.$i})) {
                      $javacodebase =  &unescape($env{'form.embedded_codebase_'.$i});  
                      $origname{$i} =~ s#^\Q$javacodebase\E/##; 
                  }
                  my @attributes = ();
                  if ($env{'form.embedded_attrib_'.$i} =~ /:/) {
                      @attributes = split/:/,$env{'form.embedded_attrib_'.$i};
                  } else {
                      @attributes = ($env{'form.embedded_attrib_'.$i});
                  }
                  foreach (@attributes) {
                      push(@{$attribs{$i}},&unescape($_));
                  }
                  if ($javacodebase) {
                      $codebase{$i} = $javacodebase;
                      $codebase{$i} =~ s#/$##;
                      $updateflag = 1;
                  }
              }
              unless ($newname{$i} eq $origname{$i}) {
                  $updateflag = 1;
              }
          }
# Process file upload - phase three - modify primary file
          if ($updateflag) {
              my ($content,$rtncode);
              my $updateflag = 0;
              my $getstatus = &Apache::lonnet::getuploaded('GET',$primary_url,$coursedom,$coursenum,\$content,\$rtncode);
              if ($getstatus eq 'ok') {
                  foreach my $item (keys %newname) {
                      if ($newname{$item} ne $origname{$item}) {
                          my $attrib_regexp = '';
                          if (@{$attribs{$item}} > 1) {
                              $attrib_regexp = join('|',@{$attribs{$item}});
                          } else {
                              $attrib_regexp = $attribs{$item}[0];
                          }
                          if ($content =~ m#($attrib_regexp\s*=\s*['"]?)\Q$origname{$item}\E(['"]?)#) {
                          } 
                          $content =~ s#($attrib_regexp\s*=\s*['"]?)\Q$origname{$item}\E(['"]?)#$1$newname{$item}$2#gi; 
                      }
                      if (exists($codebase{$item})) {
                          $content =~ s/(codebase\s*=\s*["']?)\Q$codebase{$item}\E(["']?)/$1.$2/i; #' stupid emacs
                      }
                  }
# Save edited file.
                  my $saveresult;
                  my $docuname=$env{'course.'.$env{'request.course.id'}.'.num'};
                  my $docudom=$env{'course.'.$env{'request.course.id'}.'.domain'};
                  my $url = &Apache::lonnet::store_edited_file($primary_url,$content,$docudom,$docuname,\$saveresult);
              } else {
                  &Apache::lonnet::logthis('retrieval of uploaded file - '.$primary_url.' - for editing, failed: '.$getstatus); 
              }
          }
      }
  }

  unless ($showdoc ||  $upload_result eq 'phasetwo') {
# -----------------------------------------------------------------------------
       my %lt=&Apache::lonlocal::texthash(
                'uplm' => 'Upload a new main '.lc($type).' document',
                'upls' => 'Upload a new supplemental '.lc($type).' document',
                'impp' => 'Import a document',
                'pubd' => 'Published documents',
		'copm' => 'All documents out of a published map into this folder',
                'spec' => 'Special documents',
                'upld' => 'Upload Document',
                'srch' => 'Search',
                'impo' => 'Import',
		'book' => 'Import Bookmarks',
                'selm' => 'Select Map',
                'load' => 'Load Map',
                'reco' => 'Recover Deleted Resources',
                'newf' => 'New Folder',
                'newp' => 'New Composite Page',
                'extr' => 'External Resource',
                'syll' => 'Syllabus',
                'navc' => 'Navigate Contents',
                'sipa' => 'Simple Page',
                'sipr' => 'Simple Problem',
                'drbx' => 'Drop Box',
                'scuf' => 'Score Upload Form',
                'bull' => 'Bulletin Board',
                'mypi' => 'My Personal Info',
                'grpo' => 'Group Files',
		'abou' => 'About User',
                'imsf' => 'Import IMS package',
                'file' =>  'File',
                'title' => 'Title',
                'comment' => 'Comment',
                'parse' => 'If HTML file, upload embedded images/multimedia files'
					  );
# -----------------------------------------------------------------------------
    if ($allowed) {
       my $dumpbut=&dumpbutton();
       my $exportbut=&exportbutton();
       my %lt=&Apache::lonlocal::texthash(
					 'vc' => 'Verify Content',
					 'cv' => 'Check/Set Resource Versions',
					 'ls' => 'List Symbs',
                                         'sl' => 'Show Log'
					  );

       my $folderpath=$env{'form.folderpath'};
       if (!$folderpath) {
	   if ($env{'form.folder'} eq '' ||
	       $env{'form.folder'} eq 'supplemental') {
	       $folderpath='default&'.
		   &escape(&mt('Main '.$type.' Documents'));
	   }
       }
       unless ($env{'form.pagepath'}) {
           $containertag = '<input type="hidden" name="folderpath" value="" />';
           $uploadtag = '<input type="hidden" name="folderpath" value="'.$folderpath.'" />';
       }

       $r->print(<<ENDCOURSEVERIFY);
<form name="renameform" method="post" action="/adm/coursedocs">
<input type="hidden" name="title" />
<input type="hidden" name="cmd" />
<input type="hidden" name="markcopy" />
$containertag
</form>
<form name="simpleedit" method="post" action="/adm/coursedocs">
<input type="hidden" name="importdetail" value="" />
$uploadtag
</form>
<form action="/adm/coursedocs" method="post" name="courseverify">
<table bgcolor="#AAAAAA" width="100%" cellspacing="4" cellpadding="4">
<tr><td bgcolor="#DDDDCC">
<input type="submit" name="verify" value="$lt{'vc'}" />$help{'Verify_Content'}
</td><td bgcolor="#DDDDCC">
    <input type="submit" name="versions" value="$lt{'cv'}" />$help{'Check_Resource_Versions'}
$dumpbut
$exportbut
</td><td bgcolor="#DDDDCC">
    <input type="submit" name="listsymbs" value="$lt{'ls'}" />
</td><td bgcolor="#DDDDCC">
    <input type="hidden" name="folder" value="$env{'form.folder'}" />
    <input type="submit" name="docslog" value="$lt{'sl'}" />
</td></tr></table>
</form>
ENDCOURSEVERIFY
       $r->print(&Apache::loncommon::help_open_topic('Docs_Adding_Course_Doc',
		     &mt('Editing the Table of Contents for your '.$type)));
    }
# --------------------------------------------------------- Standard documents
    $r->print('<table border=2 cellspacing=4 cellpadding=4>');
    if (($standard) && ($allowed) && (!$forcesupplement)) {
	$r->print('<tr><td bgcolor="#BBBBBB">');
#  '<h2>'.&mt('Main Course Documents').
#  ($allowed?' '.$help{'Main_Course_Documents'}:'').'</h2>');
       my $folder=$env{'form.folder'};
       if ($folder eq '' || $folder eq 'supplemental') {
           $folder='default';
	   $env{'form.folderpath'}='default&'.&escape(&mt('Main '.$type.' Documents'));
       }
       my $postexec='';
       if ($folder eq 'default') {
	   $r->print('<script>this.window.name="loncapaclient";</script>');
       } else {
           #$postexec='self.close();';
       }
       $hadchanges=0;
       &editor($r,$coursenum,$coursedom,$folder,$allowed,$upload_output);
       if ($hadchanges) {
	   &mark_hash_old()
       }
       &changewarning($r,$postexec);
       my $folderseq='/uploaded/'.$coursedom.'/'.$coursenum.'/default_'.time.
                     '.sequence';
       my $pageseq = '/uploaded/'.$coursedom.'/'.$coursenum.'/default_'.time.
                     '.page';
	my $container='sequence';
	if ($env{'form.pagepath'}) {
	    $container='page';
	}
	my $readfile='/uploaded/'.$coursedom.'/'.$coursenum.'/'.$folder.'.'.$container;
       $r->print(<<ENDFORM);
<table cellspacing=4 cellpadding=4><tr>
<th bgcolor="#DDDDDD">$lt{'uplm'}</th>
<th bgcolor="#DDDDDD">$lt{'impp'}</th>
<th bgcolor="#DDDDDD">$lt{'spec'}</th>
</tr>
<tr><td bgcolor="#DDDDDD">
$lt{'file'}:<br />
<form name="uploaddocument" action="/adm/coursedocs" method="post" enctype="multipart/form-data">
<input type="file" name="uploaddoc" size="40">
<br />
$lt{'title'}:<br />
<input type="text" size="50" name="comment">
$uploadtag
<input type="hidden" name="cmd" value="upload_default">
<br />
<nobr>
<label>$lt{'parse'}?
<input type="checkbox" name="parserflag" />
</label>
</nobr>
<br />
<br />
<nobr>
<input type="submit" value="$lt{'upld'}">
 $help{'Uploading_From_Harddrive'}
</nobr>
</form>
</td>
<td bgcolor="#DDDDDD">
<form action="/adm/coursedocs" method="post" name="simpleeditdefault">
$lt{'pubd'}<br />
$uploadtag
<input type=button onClick="javascript:groupsearch()" value="$lt{'srch'}" />
<br />
<nobr>
<input type=button onClick="javascript:groupimport();" value="$lt{'impo'}" />
$help{'Importing_LON-CAPA_Resource'}
</nobr>
<br />
<input type=button onClick="javascript:groupopen(0,1,1);" value="$lt{'book'}" />
<p>
<hr />
$lt{'copm'}<br />
<input type="text" size="40" name="importmap"><br />
<nobr><input type=button 
onClick="javascript:openbrowser('simpleeditdefault','importmap','sequence,page','')"
value="$lt{'selm'}"> <input type="submit" name="loadmap" value="$lt{'load'}">
$help{'Load_Map'}</nobr>
</p>
</form>
<hr />
<form action="/adm/groupsort" method="post" name="recover">
<input type="button" name="recovermap" onClick="javascript:groupopen('$readfile',1,0)" value="$lt{'reco'}" />
</form>
ENDFORM
       unless ($env{'form.pagepath'}) {
	   $r->print(<<ENDFORM);
<hr />
<form action="/adm/coursedocs" method="post" name="newext">
$uploadtag
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newext" type="button" onClick="javascript:makenewext('newext');"
value="$lt{'extr'}" /> $help{'Adding_External_Resource'}
</nobr>
</form>
<br /><form action="/adm/imsimportdocs" method="post" name="ims">
<input type="hidden" name="folder" value="$folder" />
<input name="imsimport" type="button" value="$lt{'imsf'}" onClick="javascript:makeims();" />
</nobr>
</form>
ENDFORM
       }
       $r->print('</td><td bgcolor="#DDDDDD">');
       unless ($env{'form.pagepath'}) {
           $r->print(<<ENDFORM);
<br /><form action="/adm/coursedocs" method="post" name="newfolder">
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newfolder" type="button"
onClick="javascript:makenewfolder(this.form,'$folderseq');"
value="$lt{'newf'}" />$help{'Adding_Folders'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newpage">
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newpage" type="button"
onClick="javascript:makenewpage(this.form,'$pageseq');"
value="$lt{'newp'}" />$help{'Adding_Pages'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newsyl">
$uploadtag
<input type="hidden" name="importdetail" 
value="Syllabus=/public/$coursedom/$coursenum/syllabus" />
<nobr>
<input name="newsyl" type="submit" value="$lt{'syll'}" /> 
 $help{'Syllabus'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newnav">
$uploadtag
<input type="hidden" name="importdetail" 
value="Navigate Content=/adm/navmaps" />
<nobr>
<input name="newnav" type="submit" value="$lt{'navc'}" />
$help{'Navigate_Content'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newsmppg">
$uploadtag
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newsmppg" type="button" value="$lt{'sipa'}"
onClick="javascript:makesmppage();" /> $help{'Simple Page'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newsmpproblem">
$uploadtag
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newsmpproblem" type="button" value="$lt{'sipr'}"
onClick="javascript:makesmpproblem();" />$help{'Simple Problem'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newdropbox">
$uploadtag      
<input type="hidden" name="importdetail" value="" />
<nobr>          
<input name="newdropbox" type="button" value="$lt{'drbx'}"
onClick="javascript:makedropbox();" />
</nobr>         
</form> 
<br /><form action="/adm/coursedocs" method="post" name="newexamupload">
$uploadtag
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newexamupload" type="button" value="$lt{'scuf'}"
onClick="javascript:makeexamupload();" />
$help{'Score_Upload_Form'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newbul">
$uploadtag
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newbulletin" type="button" value="$lt{'bull'}"
onClick="javascript:makebulboard();" />
$help{'Bulletin Board'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newaboutme">
$uploadtag
<input type="hidden" name="importdetail" 
value="$plainname=/adm/$udom/$uname/aboutme" />
<nobr>
<input name="newaboutme" type="submit" value="$lt{'mypi'}" />
$help{'My Personal Info'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newaboutsomeone">
$uploadtag
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newaboutsomeone" type="button" value="$lt{'abou'}" 
onClick="javascript:makeabout();" />
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newgroupfiles">
$uploadtag
<input type="hidden" name="importdetail"
value="Group Files=/adm/$coursedom/$coursenum/aboutme" />
<nobr>
<input name="newgroupfiles" type="submit" value="$lt{'grpo'}" />
$help{'Group Files'}
</nobr>
</form>
ENDFORM
       }
       if ($env{'form.pagepath'}) {
           $r->print(<<ENDBLOCK);
<form action="/adm/coursedocs" method="post" name="newsmpproblem">
$uploadtag
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newsmpproblem" type="button" value="$lt{'sipr'}"
onClick="javascript:makesmpproblem();" />$help{'Simple Problem'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="newexamupload">
$uploadtag
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newexamupload" type="button" value="$lt{'scuf'}"
onClick="javascript:makeexamupload();" />
$help{'Score_Upload_Form'}
</nobr>
</form>
ENDBLOCK
       }
       $r->print('</td></tr>'."\n".
'</table>');
       $r->print('</td></tr>');
    }
# ----------------------------------------------------- Supplemental documents
    if (!$forcestandard) {
       $r->print('<tr><td bgcolor="#BBBBBB">');
# '<h2>'.&mt('Supplemental Course Documents').
#  ($allowed?' '.$help{'Supplemental'}:'').'</h2>');
       my $folder=$env{'form.folder'};
       unless ($folder=~/^supplemental/) {
	   $folder='supplemental';
       }
       if ($folder =~ /^supplemental$/ &&
	   $env{'form.folderpath'} =~ /^default\&/) {
	   $env{'form.folderpath'}='supplemental&'.
	       &escape(&mt('Supplemental '.$type.' Documents'));
       }
       &editor($r,$coursenum,$coursedom,$folder,$allowed);
       if ($allowed) {
       my $folderseq=
                  '/uploaded/'.$coursedom.'/'.$coursenum.'/supplemental_'.time.
                     '.sequence';

          $r->print(<<ENDSUPFORM);
<table cellspacing=4 cellpadding=4><tr>
<th bgcolor="#DDDDDD">$lt{'upls'}</th>
<th bgcolor="#DDDDDD">$lt{'spec'}</th>
</tr>
<tr><td bgcolor="#DDDDDD">
<form action="/adm/coursedocs" method="post" enctype="multipart/form-data">
<input type="file" name="uploaddoc" size="40">
<br />
<br />
<nobr>
<label>$lt{'parse'}?
<input type="checkbox" name="parserflag" />
</label>
</nobr>
<br /><br />
$lt{'comment'}:<br />
<textarea cols=50 rows=4 name='comment'>
</textarea>
<br />
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
<input type="hidden" name="cmd" value="upload_supplemental">
<nobr>
<input type="submit" value="$lt{'upld'}">
 $help{'Uploading_From_Harddrive'}
</nobr>
</form>
</td>
<td bgcolor="#DDDDDD">
<form action="/adm/coursedocs" method="post" name="supnewfolder">
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newfolder" type="button"
onClick="javascript:makenewfolder(this.form,'$folderseq');"
value="$lt{'newf'}" /> $help{'Adding_Folders'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="supnewext">
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
<input type="hidden" name="importdetail" value="" />
<nobr>
<input name="newext" type="button" 
onClick="javascript:makenewext('supnewext');"
value="$lt{'extr'}" /> $help{'Adding_External_Resource'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="supnewsyl">
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
<input type="hidden" name="importdetail" 
value="Syllabus=/public/$coursedom/$coursenum/syllabus" />
<nobr>
<input name="newsyl" type="submit" value="$lt{'syll'}" />
$help{'Syllabus'}
</nobr>
</form>
<br /><form action="/adm/coursedocs" method="post" name="subnewaboutme">
<input type="hidden" name="folderpath" value="$env{'form.folderpath'}" />
<input type="hidden" name="importdetail" 
value="$plainname=/adm/$udom/$uname/aboutme" />
<nobr>
<input name="newaboutme" type="submit" value="$lt{'mypi'}" />
$help{'My Personal Info'}
</nobr>
</form>
</td></tr>
</table></td></tr>
ENDSUPFORM
       }
    }
    if ($allowed) {
	$r->print('<form method="POST" name="extimport" action="/adm/coursedocs"><input type="hidden" name="title" /><input type="hidden" name="url" /><input type="hidden" name="useform" /></form>');
    }
    $r->print('</table>');
  } else {
      unless ($upload_result eq 'phasetwo') {
# -------------------------------------------------------- This is showdoc mode
          $r->print("<h1>".&mt('Uploaded Document').' - '.
		&Apache::lonnet::gettitle($r->uri).'</h1><p>'.
&mt('It is recommended that you use an up-to-date virus scanner before handling this file.')."</p><p><table>".
          &entryline(0,&mt("Click to download or use your browser's Save Link function"),$showdoc).'</table></p>');
      }
  }
 }
 $r->print(&Apache::loncommon::end_page());
 return OK;
} 


sub editing_js {
    my ($udom,$uname) = @_;
    my $now = time();

    return <<ENDNEWSCRIPT;
function makenewfolder(targetform,folderseq) {
    var foldername=prompt('Name of New Folder','New Folder');
    if (foldername) {
       targetform.importdetail.value=escape(foldername)+"="+folderseq;
        targetform.submit();
    }
}

function makenewpage(targetform,folderseq) {
    var pagename=prompt('Name of New Page','New Page');
    if (pagename) {
        targetform.importdetail.value=escape(pagename)+"="+folderseq;
        targetform.submit();
    }
}

function makenewext(targetname) {
    this.document.forms.extimport.useform.value=targetname;
    window.open('/adm/rat/extpickframe.html');
}

function makeexamupload() {
   var title=prompt('Listed Title for the Uploaded Score');
   if (title) { 
    this.document.forms.newexamupload.importdetail.value=
	escape(title)+'=/res/lib/templates/examupload.problem';
    this.document.forms.newexamupload.submit();
   }
}

function makesmppage() {
   var title=prompt('Listed Title for the Page');
   if (title) { 
    this.document.forms.newsmppg.importdetail.value=
	escape(title)+'=/adm/$udom/$uname/$now/smppg';
    this.document.forms.newsmppg.submit();
   }
}

function makesmpproblem() {
   var title=prompt('Listed Title for the Problem');
   if (title) { 
    this.document.forms.newsmpproblem.importdetail.value=
	escape(title)+'=/res/lib/templates/simpleproblem.problem';
    this.document.forms.newsmpproblem.submit();
   }
}

function makedropbox() {
   var title=prompt('Listed Title for the Drop Box');
   if (title) { 
    this.document.forms.newdropbox.importdetail.value=
        escape(title)+'=/res/lib/templates/DropBox.problem';
    this.document.forms.newdropbox.submit();
   }
}

function makebulboard() {
   var title=prompt('Listed Title for the Bulletin Board');
   if (title) {
    this.document.forms.newbul.importdetail.value=
	escape(title)+'=/adm/$udom/$uname/$now/bulletinboard';
    this.document.forms.newbul.submit();
   }
}

function makeabout() {
   var user=prompt("Enter user:domain for User's 'About Me' Page");
   if (user) {
       var comp=new Array();
       comp=user.split(':');
       if ((typeof(comp[0])!=undefined) && (typeof(comp[1])!=undefined)) {
	   if ((comp[0]) && (comp[1])) {
	       this.document.forms.newaboutsomeone.importdetail.value=
		   'About '+escape(user)+'=/adm/'+comp[1]+'/'+comp[0]+'/aboutme';
	       this.document.forms.newaboutsomeone.submit();
	   } else {
               alert("Not a valid user:domain");
           }
       } else {
           alert("Please enter both user and domain in the format user:domain"); 
       }
   }
}

function makeims() {
    var caller = document.forms.ims.folder.value;
    var newlocation = "/adm/imsimportdocs?folder="+caller+"&phase=one";
    newWindow = window.open("","IMSimport","HEIGHT=700,WIDTH=750,scrollbars=yes");
    newWindow.location.href = newlocation;
}


function finishpick() {
    var title=this.document.forms.extimport.title.value;
    var url=this.document.forms.extimport.url.value;
    var form=this.document.forms.extimport.useform.value;
    eval
     ('this.document.forms.'+form+'.importdetail.value="'+title+'='+url+
    '";this.document.forms.'+form+'.submit();');
}

function changename(folderpath,index,oldtitle,container,pagesymb) {
    var title=prompt('New Title',oldtitle);
    if (title) {
	this.document.forms.renameform.title.value=title;
	this.document.forms.renameform.cmd.value='rename_'+index;
        if (container == 'sequence') {
	    this.document.forms.renameform.folderpath.value=folderpath;
        }
        if (container == 'page') {
            this.document.forms.renameform.pagepath.value=folderpath;
            this.document.forms.renameform.pagesymb.value=pagesymb;
        }
        this.document.forms.renameform.submit();
    }
}

function removeres(folderpath,index,oldtitle,container,pagesymb) {
    if (confirm('WARNING: Removing a resource makes associated grades and scores inaccessible!\\nRemove "'+oldtitle+'"?')) {
	this.document.forms.renameform.cmd.value='del_'+index;
        if (container == 'sequence') {
            this.document.forms.renameform.folderpath.value=folderpath;
        }
        if (container == 'page') {
            this.document.forms.renameform.pagepath.value=folderpath;
            this.document.forms.renameform.pagesymb.value=pagesymb;
        }
        this.document.forms.renameform.submit();
    }
}

function cutres(folderpath,index,oldtitle,container,pagesymb) {
    if (confirm('WARNING: Cutting a resource makes associated grades and scores inaccessible!\\nGrades remain inaccessible if resource is pasted into another folder.\\nCut "'+oldtitle+'"?')) {
	this.document.forms.renameform.cmd.value='cut_'+index;
	this.document.forms.renameform.markcopy.value=index;
        if (container == 'sequence') {
            this.document.forms.renameform.folderpath.value=folderpath;
        }
        if (container == 'page') {
            this.document.forms.renameform.pagepath.value=folderpath;
            this.document.forms.renameform.pagesymb.value=pagesymb;
        }
        this.document.forms.renameform.submit();
    }
}

function markcopy(folderpath,index,oldtitle,container,pagesymb) {
    this.document.forms.renameform.markcopy.value=index;
    if (container == 'sequence') {
	this.document.forms.renameform.folderpath.value=folderpath;
    }
    if (container == 'page') {
	this.document.forms.renameform.pagepath.value=folderpath;
	this.document.forms.renameform.pagesymb.value=pagesymb;
    }
    this.document.forms.renameform.submit();
}

ENDNEWSCRIPT
}
1;
__END__
