# The LearningOnline Network
# Syllabus
#
# $Id: lonsyllabus.pm,v 1.59 2007/05/02 01:33:49 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonsyllabus;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lontexconvert;
use Apache::lonfeedback;
use Apache::lonannounce;
use Apache::lonlocal;
use Apache::lonhtmlcommon;
use Apache::lonspeller();
use HTML::Entities();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    my $target=$env{'form.grade_target'};
# --------------------------------------------------- Get course info from URL
    my (undef,undef,$cdom,$cnum)=split(/\//,$r->uri);
# ------------------------------------------------------------ Get query string
    &Apache::loncommon::get_unprocessed_cgi
                        ($ENV{'QUERY_STRING'},['forcestudent','register','forceedit','wrapperdisplay']);
# ----------------------------------------------------- Is this even a course?
    my $homeserver=&Apache::lonnet::homeserver($cnum,$cdom);
    if ($homeserver eq 'no_host') {
        &Apache::loncommon::content_type($r,'text/html');
        $r->send_http_header;
      	&Apache::loncommon::simple_error_page($r,'No syllabus available',
					      'No syllabus available');
        return OK;
    }
# ------------------------------------- There is such a course, get environment
    my %courseenv=&Apache::lonnet::dump('environment',$cdom,$cnum);

# ------------------------------------------------------------ Print the screen

    my $rss_link =
	&Apache::lonrss::rss_link('http://'.$ENV{'HTTP_HOST'}.'/public/'.$cdom.'/'.$cnum.'/Course_Announcements.rss');

    if ($target eq 'tex') {
	$r->print(&Apache::lonprintout::print_latex_header($env{'form.latex_type'}));
    } 
# -------------------------------------------------- Let's see who handles this
    my $externalsyllabus=$courseenv{'externalsyllabus'};

    if ($externalsyllabus=~/\w/) {
	
       if ($env{'form.wrapperdisplay'} eq 'menu') {
	   $r->print(&Apache::lonwrapper::simple_menu());
       } else {	    
	   $r->print(&Apache::lonwrapper::wrapper("/public/$cdom/$cnum/syllabus?wrapperdisplay=menu",
						   $externalsyllabus));
       }
       return OK;
     } 

# ------------------------------ The buck stops here: internal syllabus display
# --------------------------------------------------------- The syllabus fields
    my %syllabusfields=&Apache::lonlocal::texthash(
       'aaa_instructorinfo' => 'Instructor Information',
       'bbb_description'    => 'Course Description',
       'ccc_prereq'         => 'Prerequisites',
       'cdc_classhours'     => 'Class Hours',
       'ddd_officehours'    => 'Office Hours',
       'eee_helproom'       => 'Helproom Hours',
       'efe_projectinfo'    => 'Project Information',
       'fff_examinfo'       => 'Exam Information',
       'fgf_deadlines'      => 'Deadlines',
       'ggg_grading'        => 'Grading Information',
       'hhh_readings'       => 'Readings',
       'iii_coursepack'     => 'Coursepack',
       'jjj_weblinks'       => 'Web Links',
       'kkk_textbook'       => 'Textbook',
       'lll_includeurl'     => 'URLs To Include in Syllabus');
# --------------------------------------------------------------- Force Student
    my $forcestudent='';
    if ($env{'form.forcestudent'}) { $forcestudent='student'; };
    my $forceedit='';
    if ($env{'form.forceedit'}) { $forceedit='edit'; }
       
# ----------------------------------------------------------------- Make header 
    if ($target ne 'tex') {
	my $start_page = 
	    &Apache::loncommon::start_page("Syllabus", $rss_link,
					   {'function'       => $forcestudent,
					    'domain'         => $cdom,
					    'force_register' =>
						$env{'form.register'},});

	$r->print($start_page.'<h1>'.$courseenv{'description'}.'</h1><h3>'.
		  &Apache::lonnet::domain($cdom,'description').'</h3>');
    } else {
	$r->print('\noindent{\large\textbf{'.$courseenv{'description'}.'}}\\\\\\\\\textbf{'.
		  &Apache::lonnet::domain($cdom,'description').'}\\\\');
    }
# -------------------------------------------------------------- Announcements?
    my $day = &Apache::lonannounce::showday(time,2,
			 &Apache::lonannounce::readcalendar($cdom.'_'.$cnum));
    if ($target ne 'tex') {
	$r->print($day. &Apache::lonrss::advertisefeeds($cnum,$cdom,$forceedit));
    } else {
	$r->print(&Apache::lonxml::xmlparse($r,'tex',$day));
    }

# -------------------------------------------------------- Get course personnel
    my %coursepersonnel=&Apache::lonnet::get_course_adv_roles($cdom.'/'.$cnum);
    if ($target ne 'tex') {
	$r->print('<table border="2">');
    } else {
	$r->print('\begin{tabular}{|p{0.45\textwidth}|p{0.45\textwidth}|}\hline');
    }
    foreach my $element (sort keys %coursepersonnel) {
	if ($target ne 'tex') {
	    $r->print('<tr><td>'.$element.'</td><td>');
	} else {
	    $r->print(' '.&Apache::lonxml::xmlparse($r,'tex',$element).' & '); 
	}
        foreach (split(/\,/,$coursepersonnel{$element})) {
	    my ($puname,$pudom)=split(/\:/,$_);
	    if ($target ne 'tex') {
		$r->print(' '.&Apache::loncommon::aboutmewrapper(
                              &Apache::loncommon::plainname($puname,
                              $pudom),$puname,$pudom));
	    } else {
		$r->print(' '.&Apache::loncommon::plainname($puname,
                              $pudom).' ');
	    }
	}
	if ($target ne 'tex') {
	    $r->print('</td></tr>');
	} else {
	    $r->print('\\\\ \hline');
	}
    }
    if ($target ne 'tex') {
	$r->print('</table>');
    } else {
	$r->print('\end{tabular}\\\\');
    }
# ---------------------------------------------------------- Load syllabus info
    my %syllabus=&Apache::lonnet::dump('syllabus',$cdom,$cnum);
    my $allowed=0;
    my $privileged=0;

# This handler might be called anonymously ...
# ----------------------------------------------------- Only if not public call
    if ($env{'user.environment'}) {
# does this user have privileges to post, etc?
       if ($env{'request.course.id'}
	   && $cdom eq $env{'course.'.$env{'request.course.id'}.'.domain'}
	   && $cnum eq $env{'course.'.$env{'request.course.id'}.'.num'}) {
          $allowed=&Apache::lonnet::allowed('mdc',$env{'request.course.id'});
	  $privileged=$allowed;
	  if (($syllabus{'uploaded.lastmodified'}) && (!$forceedit)) {
	      $forcestudent='student';
	  }
          if ($forcestudent or $target eq 'tex') { $allowed=0; }
       }
       if ($allowed) {
          $r->print('<p>'.
&Apache::loncommon::help_open_topic('Uploaded_Templates_TextBoxes','Help with filling in text boxes').'</p><p>'.&mt('This syllabus can be publicly viewed at')
		    .' <tt>http://'.
		    &Apache::lonnet::hostname($homeserver).$r->uri.'</tt>'.
               &Apache::loncommon::help_open_topic('Syllabus_ExtLink').'</p>'.
          '<p>'.&mt('You can specify an external URL as Syllabus in the [_1].','<a href="/adm/parmset?action=crsenv">'.&mt('Course Parameters').'</a>').'</p>'.
	  '<p><a href="'.$r->uri.'?forcestudent=1"><font size="+1">'.
&mt('Show Public View').'</font></a>'.
          &Apache::loncommon::help_open_topic('Uploaded_Templates_PublicView').
          '</p>');
      } elsif ($privileged) {
	  if ($target ne 'tex') {
	      $r->print('<p><a href="'.$r->uri.'?forceedit=1"><font size="+1">'.
			&mt('Edit').'</font></a>'); 
	  }
      }
       if (($allowed) && ($env{'form.storesyl'})) {
	   foreach my $syl_field (keys(%syllabusfields)) {
               my $field=$env{'form.'.$syl_field};
	       chomp($field);
               $field=~s/\s+$//s;
	       $field=~s/^\s+//s;
	       $field=~s/\<br\s*\/*\>$//s;
	       $field=&Apache::lonfeedback::clear_out_html($field,1);
	       $syllabus{$syl_field}=$field;
               if ($syl_field eq 'lll_includeurl') { # clean up included URLs
                  my $field='';
	          foreach my $value (split(/\n/,$syllabus{$syl_field})) {
		      my $url=$value;
# get rid of leading and trailing spaces
                      $url=~s/^\s+//;
                      $url=~s/\s+$//;
                      if ($url=~m|^http://([^/]+)/(.+)$|) {
			  my $host = $1;
                          my $remainder=$2;
# remove the hostname from internal URLs
			  my $hostname = &Apache::lonnet::hostname($host);
			  my %all_hostnames = &Apache::lonnet::all_hostnames();
		          foreach my $possible_host (keys(%all_hostnames)) {
                              if ($possible_host =~ /\Q$hostname\E/i) {
			         $url=$remainder;
			      }
		          }
		      }
# norm internal URLs
                      unless ($url=~/^http\:/) {
		          $url=&Apache::lonnet::clutter($url);
                      }
# re-assemble field
                      if ($url) {
		          $field.=$url."\n";
                      }
		  }
                  $syllabus{$syl_field}=$field;
	      }
           }
           $syllabus{'uploaded.domain'}=$env{'user.domain'};
           $syllabus{'uploaded.name'}=$env{'user.name'};
           $syllabus{'uploaded.lastmodified'}=time;
           &Apache::lonnet::put('syllabus',\%syllabus,$cdom,$cnum);
       }
    }
# ---------------------------------------------------------------- Get syllabus
    if (($syllabus{'uploaded.lastmodified'}) || ($allowed)) {
       my $lastmod=$syllabus{'uploaded.lastmodified'};
       $lastmod=($lastmod?&Apache::lonlocal::locallocaltime($lastmod):&mt('never'));
       my $who = &Apache::loncommon::aboutmewrapper(
                    &Apache::loncommon::plainname($syllabus{'uploaded.name'},
                     $syllabus{'uploaded.domain'}),$syllabus{'uploaded.name'},
                     $syllabus{'uploaded.domain'});
       if ($target ne 'tex') {
	   $r->print('<table><tr><td>'.&mt('Last updated').':</td><td>'.
		     $lastmod.'</td><td>'.&mt('by').' '.$who.
		     '</td></tr></table><p>');
       } else {
	   $r->print('\\\\ '.&mt('Last updated').': '.$lastmod.' '.&mt('by').'\\\\ '.
		     &Apache::loncommon::plainname($syllabus{'uploaded.name'},
                     $syllabus{'uploaded.domain'}).'\\\\');
       }
       if ($allowed) {
	   $r->print('<form method="post">'.
		     '<input type="hidden" name="forceedit" value="edit" />');
       }
       my @htmlids=();
       foreach my $field (sort(keys(%syllabusfields))) {
	   if (($syllabus{$field}=~/\w/) || ($allowed)) {
	       my $message=$syllabus{$field};
	       if ($field eq 'lll_includeurl') { # this is the "included" field
		   my $urls=$message;
		   $message='';
		   foreach my $filelink (split(/\n/,$urls)) {
		       my $output='';
# embed style?
		       my ($curfext)=($filelink=~/\.([^\.]+)$/);
		       my $embstyle=&Apache::loncommon::fileembstyle($curfext);
		       if (($embstyle eq 'ssi') || ($curfext=~/\/$/)) {
# make ssi call and remove everything but the body contents
			   $output=&Apache::lonnet::ssi_body($filelink);
		       } elsif ($embstyle eq 'img') {
# embed as an image
			   $output='<img src="'.$filelink.'" />';
		       }
		       if ($target ne 'tex') {
			   $message.='<p>'.$output.'</p>';
		       } else {
			   $message.=' '.&Apache::lonxml::xmlparse($r,'tex','<p>'.$output.'</p>').' ';
		       }      
		   }
		   if ($allowed) {
		       $r->print('<h3>'.$syllabusfields{$field}.
				 &Apache::loncommon::help_open_topic('Syllabus_URLs').'</h3>'.
				 '<p><a href="'.$r->uri.'?forcestudent=1"><font size="+1">'.&mt('Show Public View').'</font></a>'.
				 &Apache::loncommon::help_open_topic('Uploaded_Templates_PublicView').'</p>');
		   } else {
		       $r->print($message);
		   } 
	       } else {
		   &Apache::lonfeedback::newline_to_br(\$message);
		   $message =~s|(https*://[^\s]+)|<a href="$1"><tt>$1</tt></a>|g;
		   if ($allowed) {
		       $message=&Apache::lonspeller::markeduptext($message);
		   }
		   $message=&Apache::lontexconvert::msgtexconverted($message);
		   if ($target ne 'tex') {
		       $r->print('<h3>'.$syllabusfields{$field}.'</h3><blockquote>'.
				 $message.'</blockquote>');
		   } else {
		       $r->print('\\\\\textbf{'.$syllabusfields{$field}.'}\\\\'.
				 &Apache::lonxml::xmlparse($r,'tex',$message).'\\\\');
		   }
		   push(@htmlids,$field);
	       }
	       if ($allowed) {
		   $r->print('<br /><textarea cols="80" rows="12" name="'.$field.'" id="'.$field.'">'.
			     &HTML::Entities::encode($syllabus{$field},'"&<>').
			     '</textarea> <input type="submit" name="storesyl" value="Save" />');
	       }
	   }
       }
       if ($allowed) {
	   $r->print('</form>'.
		     &Apache::lonhtmlcommon::htmlareaselectactive(@htmlids));
       }
       if ($target ne 'tex') {$r->print('</p>');} else {$r->print('\\\\');}
    } else {
	if ($target ne 'tex') {$r->print('<p>');} else {$r->print('\par ');} 
	$r->print('No syllabus information provided.');
	if ($target ne 'tex') {$r->print('</p>');}
    }
    if ($target ne 'tex') {
	$r->print(&Apache::loncommon::end_page());
    } else {
	$r->print('\end{document}');
    }
    return OK;
} 

1;
__END__
