# The LearningOnline Network with CAPA
# French Localization Lexicon
#
# $Id: fr.pm,v 1.7 2006/08/18 18:54:22 riegler Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::fr;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,
          
'char_encoding'=> 'ISO-8859-1',
'language_code'=> 'fr',
'date_locale'  => 
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds hs',
'date_months'  => 'Jan,Fev,Mar,Avr,Mai,Juin,Juil,Aou,Sept,Oct,Nov,Dec',
'date_days'    => 'Dim,Lun,Mar,Mer,Jeu,Ven,Sam',
'date_am' => 'matin',
'date_pm' => 'soir',
'textual_remote_display' => 'on',
'htmlarea_lang' => 'fr',

   'Domain'
=> 'Domaine',

   'Server'
=> 'Serveur',

   'Load'
=> 'Charge du Serveur',

   'User Load'
=> 'Charge utilisateurs',

   'Help'
=> 'Aide',

   'Log in'
=> 'Ouverture de session',

   'Username'
=> "Nom d'utilisateur",

   'Password'
=> 'Mot de passe',

   'choose'
=> 'choisir',

   'enter'
=> 'entrer',

   'view'
=> 'Visualiser',

   'calendar'
=> 'calendrier',

   'prefer-'
=> 'prfer-',

   'ences'
=> 'ences',

   'role'
=> 'rle',

   'course'
=> 'cours',

   'Course'
=> 'Cours',

   'Section/Group'
=> 'Section/Groupe',

   'today'
=> 'Aujourd hui',

   'last week'
=> 'semaine dernire',

   'last month'
=> 'mois dernier',

   'last three months'
=> 'trois derniers mois',

   'last six months'
=> 'six dernier mois',

   'last year'
=> 'an dernier',

   'Submit'
=> 'Soumettre',

   'Rename'
=> 'Renommer',

   'Save'
=> 'Enregistrer',

   'Done'
=> 'Tche accomplie',

   'Select User'
=> 'Choisir Utilisateur',

   'Select Course'
=> 'Choisir Cours',

   'Changes will become active for your current session after'
=> 'Les changements prendront effet plus trad pour votre session actuelle',

   're-initializing course'
=> 'rinitialisation du cours',

   ', or the next time you log in.'
=> ', ou  la prochaine ouverture de session.',

   'Uploaded Document'
=> 'Document tlcharg vers serveur',

   'No content modifications yet.'
=> 'Contenu pas modifi encore.',

   'Part is not open to be viewed. It'
=> "Objet n'est pas ouvert pour tre visualiser. Il",

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Des problmes de rseaux ne permettent pas de determiner si la ressource est accessible. Veuillez essayer plus tard SVP',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Note: l application des changements  tous les utilisateurs peut prendre jusqu  10 minutes.',

   'Language'
=> 'Langage',

   'Notes'
=> 'Notes',

   'Abstract'
=> 'Rsum',

   'Create a user or modify the roles and privileges of a user'
=> 'crer un utilisateur ou modifier les rles et privilges d un utilisateur',

   'View course assessment statistics'
=> 'Analyse statistiques des rsultats des devoirs',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Dfinir date-limite et autres parametres des devoirs ainsi que modifier l environement du cours',

   'New Folder'
=> 'Nouveau Dossier',

   'Simple Page'
=> 'Page Simple',

   'Simple Problem'
=> 'Problme Simple',

   'Upload Document'
=> 'Tlcharger Document vers serveur',

   'Search'
=> 'Rechercher',

   'Import'
=> 'Importer',

   'Main Course Documents'
=> 'Documents Principaux du Cours',

   'Supplemental Course Documents'
=> 'Documents Supplementaires du Cours',

   'Bulletin Board'
=> 'Tableau d affichage et discussion',

   'Special Documents'
=> 'Documents Speciaux',

   'create'
=> 'crer',

   'grades'
=> 'notes',

   'commu-'
=> 'commu-',

   'nication'
=> 'nication',

   'enroll'
=> 'inscrire',

   'navigate'
=> 'naviguer',

   'contents'
=> 'contenu',

   'Navigate Contents'
=> 'Naviguer Contenu',

   'Announcements and Calendar'
=> 'Annonces et Calendrier',

   'Author'
=> 'Auteur',

   'Change Your Preferences'
=> 'Changer Ses Prfrences',

   'Choose the user role'
=> 'Choisir le rle de l utilisateur',

   'Co-Author'
=> 'Co-Auteur',

   'Communication and Messages'
=> 'Communication et Messages',

   'Course Coordinator'
=> 'Coordinateur du Cours',

   'Course Statistics and Charts'
=> 'Donnes statistiques du cours et diagrammes',

   'Course announcements and my calendar'
=> 'Annonces  propos du cours et Calendrier priv',

   'Create Users, Change User Privileges'
=> 'Crer Utilisateurs, Changer Privilges des Utilisateurs',

   'Domain Coordinator'
=> 'Coordinateur de Domaine',

   'Enrollment Manager'
=> 'Gestion des Inscriptions',

   'Enter grades from check-out assessment resources'
=> "Assignez les notes de contrle des ressources d'valuation",

   'Exam Proctor'
=> 'Surveillant d Examens',

   'Exit LON-CAPA'
=> 'Sortir de LON-CAPA',

   'Grades Spreadsheet'
=> 'Tableur de Notes',

   'Grading'
=> 'Assigner des notes',

   'Instructor'
=> 'Enseignant',

   'Launch Remote Control'
=> 'Activer la Tlcommande',

   'Main Menu'
=> 'Menu Principal',

   'Navigate Course Contents'
=> 'Naviguer le Contenu du Cours',

   'No Role, Cumulative Privileges'
=> 'Pas de rle, privilges cumuls',

   'Return to Last Location'
=> 'Retour en arrire',

   'Send and receive messages'
=> 'Envoi et reception de messages',

   'Set my user preferences'
=> 'Etablir mes prfrences d utilisateur',

   'Student'
=> 'Etudiant(e)',

   'Switch to another user role'
=> 'Changer  un autre rle d utilisateur',

   'Teaching Assistant'
=> 'Assistant de Cours',

   'Use or edit my bookmark collection'
=> 'Utilisez ou ditez ma collection de signet ',

   'User Roles'
=> 'Rles d utilsateurs',

   'Calculate course grades (Spreadsheet)'
=> 'Calculez les notes de cours (tableur)',

   'Enter the chatroom for the course'
=> 'Entrez le bavardoir (ChatRoom) du cours',

   'Navigate the table of contents for this course'
=> 'Naviguez la table des matires pour ce cours',

   'Syllabus'
=> 'Programmes d tudes',

   'View the course assessment progress chart'
=> 'Visualisez le diagramme de progrs des tudiants du cours',

   'Class Hours'
=> 'Heures de Cours',

   'Course Description'
=> 'Description du Cours',

   'Coursepack'
=> 'Paquet de cours',

   'Current Month'
=> 'Mois courant',

   'Deadlines'
=> 'Dates limites',

   'Fri'
=> 'Ven',

   'Grading Information'
=> 'Information concernant la correction des devoirs',

   'Helproom Hours'
=> 'Heures d ouverture de la salle d aide',

   'Instructor Information'
=> 'Information enseignant',

   'Mon'
=> 'Lun',

   'Next Month'
=> 'Mois Prochain',

   'Office Hours'
=> 'Heures d ouverture du bureau de l enseignant',

   'Prerequisites'
=> 'Choses ncessaires',

   'Previous Month'
=> 'Mois dernier',

   'Readings'
=> 'Lectures',

   'Sat'
=> 'Sam',

   'January'
=> 'Janvier',

   'February'
=> 'Fvrier',

   'March'
=> 'Mars',

   'April'
=> 'Avril',

   'May'
=> 'Mai',

   'June'
=> 'Juin',

   'July'
=> 'Juillet',

   'August'
=> 'Aout',

   'September'
=> 'Septembre',

   'October'
=> 'Octobre',

   'November'
=> 'Novembre',

   'December'
=> 'Dcembre',

   'Sun'
=> 'Dim',

   'Textbook'
=> 'Livre du Cours',

   'Thu'
=> 'Jeu',

   'Tue'
=> 'Mar',

   'Web Links'
=> 'Liens Hypertexte',

   'Wed'
=> 'Mer',

   'Drop/Add students in this course'
=> 'Enlever/Rajouter etudiants au cours',

   'You have entered that answer before'
=> 'Vous avez dj soumis cette rponse',

   'A score has been assigned.'
=> 'Une note a t attribue.',

   'You are correct.'
=> 'Correct!',

   'Your receipt is'
=> 'Votre numero de reu est',

   'You are excused from the problem.'
=> 'Vous tes excus dispens de faire ce problme.',

   'Incorrect'
=> 'Incorrect.',

   'Some parts were not submitted.'
=> 'Certaines parties n ont pas t soumises.',

   'An error occured while grading your answer.'
=> 'Une erreur est apparue lors de l valuation de votre rponse.',

   'The submitted answer was too long.'
=> 'La rponse soumise est trop longue.',

   'This question expects a numeric answer.'
=> 'La rponse  cette question doit tre numrique',

   'You have provided an invalid ranking'
=> 'L ordre soumis est incorrect',

   'please refer to'
=> 'SVP se rfrer ',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'L extension du fichier tlcharg est incorrecte.',

   'Units incorrect.'
=> 'Units incorrectes.',

   'Only a number required.'
=> 'Seul un nombre est requis.',

   'Units required'
=> 'Units sont requises',

   'Unable to understand formula'
=> 'Impossible d interpreter la formule',

   'Your submission has been recorded.'
=> 'Votre rponse/requete a t enregistre.',

   'Unknown message'
=> 'Message inconnu',

   'Answer Submitted'
=> 'Rponse Soumise',

   'Tries'
=> 'Nombre d essai',

   'Submit Answer'
=> 'Soumettre Rponse',

   'Prepare a printable document'
=> 'Preparer Document pour impression',

   'Go To My First Homework Problem'
=> 'Aller au premier problme du devoir',

   'Discussions'
=> 'Discussons',

   'New discussion since'
=> 'Nouvelle Discussion depuis',

   'Goodbye'
=> 'Au Revoir',

   'Select'
=> 'Slectionez',

   'Re-Initialize'
=> 'Rinitialisez',

   'Currently selected. '
=> 'Slection actuelle.',

   'Switch Server'
=> 'Changez de Serveur',

   'system wide'
=> 'pour tout le systme ',

   'Currently not available'
=> 'Pas disponible pour l instant',

   'No role specified'
=> 'Aucun rle n est spcifi',

   'Remark'
=> 'Remarque',

   'Extent'
=> 'Extension',

   'User Role'
=> 'Rle/fonction de l utilisateur',

   'Start'
=> 'Dbut/Commencez',

   'End'
=> 'Fin/Finir',

   'System'
=> 'Systme',

   'Display'
=> 'Afficher',

   'an unknown date'
=> 'une date inconnue',

   'an indeterminate date'
=> 'une date indtermine',

   'will open on'
=> 'sera disponible le',

   'is due at'
=> 'est d ',

   'was due on'
=> 'etait d le',

   'is closed but you are allowed to view it'
=> 'est ferm mais vous avez la permission de le visualiser',

   'Undid changes, Switched'
=> 'changements annuls, a commut',

   'Unable to undo, unable to switch'
=> 'Impossible d annuler, impossible de commuter',

   'Unable to make backup'
=> 'Impossible de faire une sauvegarde',

   'Saving Modifications to'
=> 'Changements enregistrs dans',

   'Unable to write to'
=> 'Impossible d ecrire dans ',

   'Analyzing a problem'
=> 'Analyse en cours d un problme',

   'EditXML'
=> 'Edition XML',

   'Discard Edits and View'
=> 'Ignorer Changements et Visualiser',

   'Submit Changes'
=> 'Soumettre Changements',

   'Submit Changes and View'
=> 'Soumettre Changements et Visualiser',

   'Edit'
=> 'Edition',

   ', select a template from the pull-down menu below'
=> ', choisissez un descripteur(gabarit)  partir du menu droulant ci-dessous',

   'undo'
=> 'annuler',

   'Answer'
=> 'Rponse',

   'Frequency'
=> 'Frquence',

   'You did not select a template.'
=> "Vous n'avez pas choisi un descripteur(gabarit).",

   'Analyze Progress'
=> 'Analyser le Progrs',

   'Getting Problem Variants'
=> 'Obtenant des variantes du Problme',

   'last problem'
=> 'dernier problme',

   'may open later.'
=> 'pourra tre disponible plus tard.',

   ', and answers will be available on'
=> ', et les rponses seront disponibles le',

   'Select a'
=> 'Slectionner un',

   'Unable to find'
=> 'Impossible de trouver',

   'Part'
=> 'Partie',

   'Then'
=> 'Ensuite',

   'Create'
=> 'Crer',

   'is in under construction'
=> 'se trouve dans l espace construction',

   'List of possible answers'
=> 'Liste des rponses possibles',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> "n'a trouv aucune partie analysable dans ce problme, pour l instant seul les rponses numriques, les formules et les chanes de caractres sont accepts.",

   'is not analyzable at this time'
=> 'ne peut pas tre analys en ce moment',

   'Access and Usage Statistics'
=> 'Statistiques d acces et utilisation',

   'Actions'
=> 'Actions',

   'All homework is currently completed'
=> 'tout le devoir est actuellement termin ',

   'Answer available'
=> 'Rponse disponible',

   'Answer submitted'
=> 'Rponse soumise',

   'Answer submitted, not yet graded'
=> 'Rponse soumise, pas note encore',

   'Back to Directory'
=> 'Retour au Rpertoire',

   'Cancel'
=> 'Annuler',

   'Construction Space Directory'
=> 'Rpertoire de l espace de construction',

   'Contact'
=> 'Contacter',

   'Copying file'
=> 'Copie du fichier en cours',

   'Date'
=> 'Date',

   'Empty'
=> 'Vide',

   'Evaluation Comments'
=> 'Commentaires d valuation',

   'Evaluation Data'
=> 'Donnes d valuation',

   'Excused by instructor'
=> 'Dispens(e) par l enseignant',

   'File'
=> 'Fichier',

   'Go Back'
=> 'Revenir en Arrire',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Il est vivement recommend d utiliser un anti-virus rcent avant d ouvrir ce fichier.',

   'Last Modified'
=> 'Dernire Modification',

   'Map'
=> 'Carte/Squence',

   'Map contents are not shown in order.'
=> 'Les contenus des CARTES ne sont pas montrs dans l ordre',

   'Name'
=> 'Nom',

   'New Messages'
=> 'Nouveaux Messages',

   'New Search'
=> 'Nouvelle Recherche',

   'No due date'
=> 'Sans date limite',

   'No upload file specified.'
=> 'Le fichier  tlcharger n a pas t spcifi.',

   'No write permission to user directory, FAIL'
=> 'Permission d ecrire dans le rpertoire utilisateur refuse, ECHEC',

   'Open, no due date'
=> 'Ouvert, pas de date limite',

   'Page'
=> 'Page',

   'Path'
=> 'voie d acces',

   "Please use browser 'Back' button and pick a filename"
=> "SVP, Utilisez le bouton 'Retour' du navigateur et slectionnez un nom de fichier",

   'Processing'
=> 'traitant',

   'Searching'
=> 'Recherche en cours',

   'Select the Construction Space'
=> 'Choisir l espace de Construction',

   'Sequence'
=> 'Squence',

   'Server Administration'
=> 'Administration du Serveur',

   'Show Only Uncompleted Homework'
=> 'Montrer uniquement les devoirs incomplets',

   'Status'
=> 'Etat',

   'Store uploaded file as '
=> 'Enregistrer le fichier tlcharg comme ',

   'System Administration'
=> 'Administration du Systme',

   'The target is an existing directory.'
=> 'La destination est un dossier existant.',

   'Title'
=> 'Titre',

   'Uncompleted Homework'
=> 'Devoir incomplet',

   'View All Messages'
=> 'Visualiser tous les Messages',

   'Was due'
=> 'tait d(e)',

   'Yes'
=> 'Oui',

   'You do not have authoring privileges for this resource'
=> 'Vous n avez pas de privilge d auteur pour cette ressource',

   'You have no unread messages'
=> 'Vous n avez pas de nouveaux messages',

   'You have no unread messages'
=> 'Vous n avez pas de nouveaux messages',

   'could not be copied.'
=> 'ne peut etre copie(e).',

   'could not be copied.'
=> 'ne peut tre copi(e).',

   'never'
=> 'jamais',

   'not displayed'
=> 'pas affich(e)',

   ', is reserved internally by LON-CAPA.'
=> ', est rserv de faon interne par LON-CAPA.',

   'Back to'
=> 'Retour ',

   'Back to Source'
=> 'Retour  la Source',

   'Back to Source Directory'
=> 'Retour au rpertoire Source',

   'Became this version on ...'
=> 'Devint cette version le ...',

   'Browse published resources'
=> 'Naviguer parmi les ressouces publies',

   'Choose the course to work on'
=> 'Choisir le cours sur lequel vous voulez travailler',

   'Create a new course'
=> 'crer un nouveau cours',

   'Customized right of use ...	'
=> 'Droit d utilisation sur mesure ...	',

   'Delete messages from bulletin boards'
=> 'Effacer Messages des Tableaux d affichage ', 

   'Domain only - use limited to courses in the domain'
=> 'Domaine seulement - usage limit aux cours dans le domaine',

   'Dynamic Metadata'
=> 'Meta-donnes dynamiques',

   'Edit and view documents included in this course'
=> 'Edition et Visualisation des documents inclus dans ce cours',

   'Edit/Modify DOCS'
=> 'Edition/Modification des DOCS',

   'Enter my resource construction space'
=> 'Entrer mon espace de construction de ressources',

   'FAIL'
=> 'ECHEC',

   'Failed to copy source'
=> 'Echec dans la copie de la source',

   'Failed to write metadata copy'
=> 'Echec dans la copie des meta-donnees',

   'File copied.'
=> 'Fichier copie',

   'Finalize Publication'
=> 'Finalisez Publication',

   'Grant/revoke role of Co-Author'
=> 'Octroyer/Rvoquer rle de Co-Auteur',

   'Grant/revoke role of Domain Coordinator'
=> 'Octroyer/Rvoquer rle de Coordinateur de Domaine',

   'Grant/revoke role of Exam Proctor'
=> 'Octroyer/Rvoquer rle de Surveillant d examen',

   'Grant/revoke role of Instructor'
=> 'Octroyer/Rvoquer rle d enseignant',

   'Grant/revoke role of Student'
=> 'Octroyer/Rvoquer rle d etudiant(e)',

   'Grant/revoke role of Superuser'
=> 'Octroyer/Rvoquer rle de Super-Utilisateur',

   'Illegal filename.'
=> 'Nom illegal de fichier.',

   'Name starting with'
=> 'Nom commenant par ',

   'No previous versions published.'
=> 'Pas de version antrieures publies.',

   'No write permission to'
=> 'Pas de permission d criture dans',

   'Please pick a version to retrieve'
=> 'SVP choisir version  rcuprer',

   'Private - visible to author only for testing purposes'
=> 'Prive - Visible uniquement  l auteur pour test seulement',

   'Private Publication - did not synchronize database'
=> "Publication prive - n'a pas synchronis la base de donnes",

   'Public - no authentication or authorization required for use'
=> 'Publique - peut tre utilis(e) sans authentification ou autorisation',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'Le retrait d une vielle version remplace compltement le fichier actuel dans l espace de construction',

   'Retrieve previous versions of'
=> 'Restaurer les versons antrieures de',

   'Retrieve version'
=> 'Restaurer la version',

   'Rule'
=> 'Rgles',

   'Search the contents of this course'
=> 'Rechercher les contenus de ce cours',

   'Search the database of published resources'
=> 'Rechercher la base de donnes des ressources publies',

   'Send broadcast and receipt-required email'
=> 'Diffuser un courriel(email) avec avis de reception',

   'Show Problem Completeness'
=> 'Montrer intgrit/cohrence du problme',

   'Switch to another course'
=> 'commutez  un autre cours ',

   'System wide - can be used for any courses system wide'
=> 'Pour tout le systme - peut tre utilis(e) par n importe quel cours dans le systme',

   'System wide - open source to all authors'
=> 'Pour tout le systme - source disponible  tous les auteurs',

   'The extension on this file'
=> "L'extension du fichier",

   'This resource has been marked obsolete by the author(s)'
=> "Cette ressource a t marque obsolete par l'auteur",

   'Unsupported character combination'
=> 'combinaison de caractres non acceptable ',

   'Uploaded'
=> 'A t tlcharg vers le serveur',

   'Users with Roles Assigned by'
=> 'Utilisateurs avec rles octroys par',

   'View documents included in this course'
=> 'Visualizer les documents inclus dans ce cours',

   'View file'
=> 'Afficher fichier',

   'untitled'
=> 'sans titre',

   "Click to download or use your browser's Save Link function"
=> "Cliquer pour tlcharger ou utiliser la fonction 'sauver lien' de votre navigateur",

   '#Stdnts'
=> '#Etudiant(e)s',

   '#YES'
=> '#OUI',

   '%Wrng'
=> '%Faux',

   '. . . for a particular section'
=> '. . . pour une section particulire',

   '. . . for all students in the course'
=> '. . . pour tous les tudiants dans le cours',

   '. . . for an individual student'
=> '. . . pour un(e) tudiant(e) particulier',

   '1 am'
=> '1:00',

   '1 pm'
=> '13:00',

   '10 am'
=> '10:00',

   '10 pm'
=> '22:00',

   '11 am'
=> '11:00',

   '11 pm'
=> '23:00',

   '12 am'
=> '00:00',

   '12 noon'
=> '12:00',

   '2 am'
=> '2:00',

   '2 pm'
=> '14:00',

   '3 am'
=> '3:00',

   '3 pm'
=> '15:00',

   '4 am'
=> '4:00',

   '4 pm'
=> '16:00',

   '5 am'
=> '5:00',

   '5 pm'
=> '17:00',

   '6 am'
=> '6:00',

   '6 pm'
=> '18:00',

   '7 am'
=> '7:00',

   '7 pm'
=> '19:00',

   '8 am'
=> '8:00',

   '8 pm'
=> '20:00',

   '9 am'
=> '9:00',

   '9 pm'
=> '21:00',

   '<- Previous'
=> '<- Prcdent ',

   'ALL'
=> 'TOUS',

   'About Me'
=> 'Donnes personelles',

   'Access Key Management'
=> 'Gestion des cls d access',

   'Additional Keywords'
=> 'Mots cls additionels',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Meta-donnes Additionelles (non-standard, paramtres, exports)',

   'Advanced Catalog Search'
=> 'Recherche Avance du Catalogue',

   'Advanced Search'
=> 'Recherche Avance',

   'All Maps or Folders'
=> 'Tous les CARTES et dossiers',

   'All versions'
=> 'Toutes les versions',

   'Any Language'
=> 'N importe quelle langage',

   'Any User'
=> 'N importe quel Utilisateur',

   'Any category'
=> 'N importe quelle Categorie',

   'Any copyright/distribution'
=> 'Toutes distributions/copyright ',

   'Assessment'
=> 'valuation',

   'Assessment URL and Title'
=> 'valuation, adresse URL et Titre',

   'Assigned User Roles'
=> 'Roles Attribus  l utilisateur',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Rles d Auteur et Co-Auteur ne sont disponibles que sur le serveur d acceuil.',

   'Author(s)'
=> 'Auteur(s)',

   'Average number of tries till solved'
=> 'Nombre moyen d essai pour rsoudre le problme',

   'Brief view of each students performance in course.'
=> 'Bref rsum de la performance de chaque tudiant du cours.',

   'Broadcast Message to Course'
=> 'Diffuser Message  tous les utilisateurs du cours',

   'Browse Resources'
=> 'Naviguer parmi les ressources',

   'Browse Resources'
=> 'Naviguer parmi les ressources',

   'Bulletin Board/Discussion'
=> 'Tableau d Affichage/Discussion',

   'Calculations'
=> 'Calculs',

   'Catalog Information'
=> 'Information de Catalogue',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'l activation des changements pour tous les tudiants peut prendre jusqu  10 minutes.',

   'Clear All'
=> 'Effacer Tout',

   'Clear Caches'
=> 'Effacer les Antmmoires',

   'Close'
=> 'Fermer',

   'Close All Folders'
=> 'Fermer tous les Dossiers',

   'Collapse Remote Control'
=> 'Supprimer la Tlcommande',

   'Comma Separated Values'
=> 'Valeurs spares par Virgule',

   'Compact View'
=> 'Visualisation Compacte',

   'Construction Space'
=> 'Espace de Construction',

   'Construction Space File Operation'
=> 'Operation de fichier de l espace de Construction',

   'Contact Information'
=> 'Information de contact',

   'Content changed'
=> 'Contenu chang',

   'Copied metadata'
=> 'Meta-donnes copies',

   'Copied old metadata'
=> 'Anciennes Meta-donnes copies',

   'Copied old target file'
=> 'Ancien fichier cible copi',

   'Copied source file'
=> 'Fichier source copi',

   'Copyright'
=> 'Copyright',

   'Copyright/Distribution'
=> 'Copyright/Distribution',

   'Could Not Process Request'
=> 'N a pas pu traiter la demande',

   'Could not write metadata'
=> 'Ne peut pas crire les meta-donnes',

   'Course Assessment Parameter - Helper Mode'
=> 'Paramtres d valuation du cours - Mode Assistance',

   'Course Assessment Parameters - Overview Mode'
=> 'Paramtres d valuation du cours - Mode de vue d ensemble',

   'Course Assessments Parameters - Table Mode'
=> 'Paramtres d valuation du cours - Mode Table',

   'Course Documents'
=> 'Documents du Cours',

   'Course Environment Parameters'
=> 'Paramtres d Environement du Cours',

   'Course ID'
=> 'Numero d identification du Cours',

   'Course Parameter Helper'
=> 'Aide pour tablir les paramtres du cours',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Les donnes statistiques et les diagrammes du cours ne peuvent pas tre rcupers jusqu  ce que la base de donnes soit relance. Vos donnees sont intactes mais ne peuvent pas tre affiches en ce moment.',

   'Course level sheet'
=> 'feuille au niveau du cours ',

   'Create New Environment Variable'
=> 'Crer une nouvelle variable d environement',

   'Creation Date'
=> 'Date de Cration',

   'Current Session Value'
=> 'Valeur pour la session Courrante',

   'Custom Distribution File'
=> 'Fichier de distribution fait sur commande',

   'Default'
=> 'Dfaut ',

   'Default Cataloging Information for Directory'
=> 'information de rpertoire pour le catalogue, par dfaut',

   'Default Value'
=> 'Valeur Par Defaut',

   'Degree of difficulty'
=> 'Degr de difficult',

   'Delete a role'
=> 'Eliminer un rle',

   'Detailed Citation View'
=> 'Affichage dtaill des citations',

   'Detailed Problem Analysis'
=> 'Analyse dtaille du problme',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Donnes statistiques dtailles et diagrammes illustrant la performance des tudiants rsolvant des problmes.',

   'Differences'
=> 'Differences',

   'Disable all communication among students'
=> 'Empecher toute comunication entre les tudiants',

   'Discard Selected'
=> 'Ignorez slection',

   'Distribute Messages from Uploaded File to Course'
=> 'Distrubuer les Messages du fichier tlcharg  tout le monde dans le cours',

   'DoDiff'
=> 'DoDiff',

   'Due'
=> 'est d ',

   'Dump Course DOCS to Construction Space'
=> 'Dcharger les DOCS du Cours dans l espace de Construction',

   'EMail and Messages'
=> 'Courriel(email) et Messages',

   'Edit Catalog Information'
=> 'Editer les Informations du Catalogue',

   'Edit Content of a Map'
=> 'Editer le Contenu de la Carte',

   'Edit Directory Catalog Information'
=> 'Editer les Informations du Catalogue de rpertoires',

   'Edit this resource'
=> 'Editer cette ressource',

   'Enclosing Map or Folder'
=> 'Enfermant Carte ou Dossier',

   'End Helper'
=> 'Arreter l aide',

   'Enrollment Status'
=> 'Etat de l Inscription',

   'Enter construction space as a co-author'
=> 'Entrer l espace de construction comme auteur',

   'Entering course ...'
=> 'Entrant le cours ...',

   'Error Messages'
=> 'Messages d Erreur',

   'Evaluate Resource'
=> 'Evaluer la ressource',

   'Every problem in a particular folder'
=> 'Chaque problme dans un dossier particulier',

   'Every problem in the course'
=> 'Chaque problme du cours',

   'Exam Information'
=> 'Information sur l Examen',

   'Excel'
=> 'Excel',

   'External Resource'
=> 'Ressource Externe',

   'Failed Access to Construction Space'
=> 'Accs a l espace de construction rat',

   'Fielded Format'
=> 'Format en Champs',

   'File Category'
=> 'Categorie de Fichier',

   'Finish Course Initialization'
=> 'Finaliser l initialisation du cours',

   'Folder'
=> 'Dossier',

   'For User'
=> 'Pour l Utilisateur',

   'Force publication of unmodified files'
=> 'Forcer la publication des fichiers non modifis',

   'Generate Spreadsheet'
=> 'Gnrer une feuille de calculs (Tableur)',

   'Generate Statistics'
=> 'Gnrer Donnes Statistiques',

   'Generate new role ...'
=> 'Gnrer un nouveau rle ...',

   'Go to the next resource in the course sequence'
=> 'Aller  la prochaine ressource dans la squence du cours',

   'Go to the previous resource in the course sequence'
=> 'Aller  la ressource prcdente dans la squence du cours',

   'Grant/revoke Course Custom Role'
=> 'Octroyer/annuler le rle sur mesure pour le cours' ,

   'Grant/revoke role of Administrator'
=> 'Octroyer/annuler le rle d Administrateur ',

   'Grant/revoke role of Author'
=> 'Octroyer/annuler le rle d auteur ',

   'Grant/revoke role of Course Coordinator'
=> 'Octroyer/annuler le rle de Coordinateur du cours',

   'Grant/revoke role of Domain Guest'
=> 'Octroyer/annuler le rle d invit de domaine ',

   'Grant/revoke role of Librarian'
=> 'Octroyer/annuler le rle de bibliothcaire',

   'Grant/revoke role of Scantron Operator'
=> 'Octroyer/annuler le rle d operateur Scantron',

   'Grant/revoke role of Teaching Assistant'
=> 'Octroyer/annuler le rle d aide enseignant ',

   'HTML'
=> 'HTML',

   'Host'
=> 'Hte',

   'Import a published document'
=> 'Importer un document publi',

   'Internally authenticated'
=> 'Authentification Interne',

   'Invalid date entry'
=> 'Saisie invalide de date',

   'Kerberos authenticated'
=> 'Authetification par Kerberos',

   'Keyword(s)'
=> 'Mot(s) Cl(s)',

   'Keywords'
=> 'Mots Cls',

   'LON-CAPA Helper:'
=> 'Aide de LON-CAPA:',

   'Last Week'
=>  'La semaine dernire',

   'Last access'
=> 'Dernier accs',

   'Last modified'
=> 'Dernire modification',

   'Last updated'
=> 'Dernire mise  jour',

   'Limit by copyright/distribution'
=> 'Limiter par copyright/distribution',

   'Limit by language'
=> 'Limiter par langage',

   'Load Map'
=> 'Charger Carte/Squence',

   'Load:'
=> 'Charger:',

   'Lock and unlock assessments'
=> 'Bloquer et dbloquer les devoirs',

   'Logged Out'
=> 'Session ferme',

   'MIME Type'
=> 'Type MIME',

   'Make notes and annotations about this resource'
=> 'Inserer notes et annotations au sujet de cette ressource',

   'Manage Access Keys'
=> 'Grer les Codes d Accs',

   'Manage access keys'
=> 'Grer les codes d accs',

   'Material appears to be correct'
=> 'Le materiel de cours semble tre correct',

   'Material covered with sufficient depth'
=> 'Le materiel de cours est trait avec suffisament de profondeur',

   'Material is helpful'
=> 'Le materiel de cours est utile',

   'Material presented in clear way'
=> 'Le materiel de cours est present de faon claire',

   'Max Possible To Date'
=> ' Maximum Possible Jusqu ici ',

   'Max Tries'
=> 'Maximum nombre d essai',

   'Mean Tries'
=> 'Moyenne du nombre d essai',

   'Metadata Information'
=> 'Information de meta-donnes',

   'Mime type'
=> 'Type Mime',

   'Modification Date'
=> 'Date de Modification',

   'Modified'
=> 'Modifi(e)',

   'Modify Course Assessment Parameters'
=> 'Modifier les paramtres des devoirs du cours',

   'Modify authentication mechanism and data for a user'
=> 'Modifier le mecanisme d authentification et les donnes de l utilisateur',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modifier les dates limites, etc. pour ce devoir',

   'Modify grades'
=> 'Modifier les notes',

   'Modify user grades for this assessment resource'
=> 'Modifier les notes de l utilisateur pour ce devoir',

   'Move Down'
=> 'Se dplacer vers le bas',

   'Move Up'
=> 'Se dplacer vers le haut',

   'My Personal Info'
=> 'Mes informations personnelles',

   'Network-wide number of accesses (hits)'
=> 'Nombre d accs  travers le rseau (hits)',

   'Network-wide number of courses using resource'
=> 'Nombre de cours  travers le rseau utilisant cette ressource',

   'New Title'
=> 'Nouveau Titre',

   'Next    '
=> 'Suivant    ',

   'No changes were made to the current settings.'
=> 'Aucun changement n a t fait  la configuration actuelle.',

   'Number of resources that follow this resource in maps'
=> 'Nombre de ressources suivant cette ressource dans les CARTES',

   'Number of resources that lead up to this resource in maps'
=> 'Nombre de ressources qui mnent  cette ressource dans les CARTES',

   'Number of resources using or importing resource'
=> 'Nombre de ressources utilisant ou important cette ressource',

   'Obsolete'
=> 'Dsuet',

   'One particular problem'
=> 'Un problme particulier',

   'Open'
=> 'Ouvrir',

   'Open All Folders'
=> 'Ouvrir tous les Dossiers',

   'Output'
=> 'Sortie',

   'Output Format'
=> 'Format en sortie',

   'Overall Problem Statistics'
=> 'Donnes Statistiques globales du Problme',

   'Owner/Publisher'
=> 'Propritaire/Editeur',

   'Parameter Name'
=> 'Nom du Paramtre',

   'Parameter Type'
=> 'Type de Paramtre',

   'Parameter in Effect'
=> 'Paramtre en Effet',

   'Parent Directory'
=> 'Rpertoire Parent',

   'Per Page'
=> 'Par page',

   'Personal Information'
=> 'Information Personnelle',

   'Please either'
=> "SVP l'un ou l'autre",

   'Please notify the server administrator '
=> 'SVP Notifiez l administrateur du serveur',

   'Please select a problem to analyze'
=> 'SVP, slectionnez un problme  analyser',

   'Please select a report to generate.'
=> 'SVP, slectionnez un rapport  crer.',

   'Post anonymously'
=> 'Poster de faon anonyme',

   'Post discussion on course resources'
=> 'Poster une discussion sur les ressources du cours',

   'Post system frontpage announcements'
=> 'Poster annonces en premire page du systme',

   'Post to live chatrooms'
=> 'Poster en temps rel au bavardoir (ChatRoom)',

   'Preparing Excel Spreadsheet'
=> 'Prparer Tableur Excel',

   'Printing Helper'
=> 'Assistant d impression',

   'Privacy Note'
=> 'Note Prive',

   'Problem Status Chart'
=> 'Tableau d tat des Problmes',

   'Problems Not Contained In A Folder'
=> 'Problmes non contenus dans un dossier',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problmes pour crer une feuille de calcul Excel.  Cette erreur a t journalise. Veuillez SVP informer l administrateur du systme LON-CAPA.',

   'Processing course structure'
=> 'Traitement de la struture du cours',

   'Processing first student'
=> 'Traitement du premier tudiant',

   'Project Information'
=> 'Information  propos du Projet',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Fournir un feedback et contribuer  la discussion du cours sur cette ressource',

   'Provide my evaluation of this resource'
=> 'Fournir mon valuation de cette ressource',

   'Publish'
=> 'Publier',

   'Publish Directory'
=> 'Publier Rpertoire',

   'Publish Directory and Sub Directories'
=> 'Publier Rpertoire et Sous-rpertoires',

   'Published'
=> 'Publi(e)',

   'Publisher/Owner'
=> 'Editeur/Propritaire',

   'Publishing'
=> 'En train de publier',

   'Quick Completed Problems Display'
=> 'Visualition rapide des Problmes Rsolus',

   'Reading results from'
=> 'Lisant rsultats  partir de ',

   'Related'
=> 'Reli  ',

   'Resource Feedback and Discussion'
=> 'Feedback et discussion de ressources',

   'Resource Level'
=> 'Niveau Ressource',

   'Resource Publication'
=> 'Publication de Ressource',

   'Resource is technically correct'
=> 'Ressource techniquement correte',

   'Retrieve'
=> 'Restaurer',

   'Revert to Last Saved'
=> 'Retourner  la dernire version sauve',

   'Revision Date'
=> 'Date de Revision',

   'Row'
=> 'Ligne',

   'S.D. tries'
=> 'Dev Stand nombre d essai',

   'Save as'
=> 'Enregister sous',

   'Save as & Make This Sheet the Default'
=> 'Enregistrer sous & faire le tableur par defaut',

   'Scantron Operator'
=> 'Operateur Scantron',

   'Score Upload Form'
=> 'Formulaire pour Tlcharger les notes',

   'Search Complete'
=> 'Recherche Complete',

   'Section'
=> 'Section',

   'Sections'
=> 'Sections',

   'Select All'
=> 'Tout Slectionner',

   'Select All Students'
=> 'Slectionner tous les tudiants',

   'Select Date'
=> 'Slectionner une Date',

   'Select Enclosing Map or Folder'
=> 'Slectionner une carte ou Dossier',

   'Select Map'
=> 'Slectionner Carte/Sequence',

   'Select Parameter Level'
=> 'Slectionner niveau du paramtre',

   'Select Spreadsheet File'
=> 'Slectionner Tableur',

   'Send Message to User(s)'
=> 'Envoyer message aux utilisateurs',

   'Send Scantron data to a course'
=> 'Envoyer rsultats Scantron  un cours',

   'Send internal email'
=> 'Envoyer courriel(email) interne',

   'Sequence or Folder'
=> 'Squence ou Dossier',

   'Sequences and Folders'
=> 'Squences et Dossiers',

   'Set Course Environment Parameters'
=> 'Configurer les paramtres de l environement du cours',

   'Set Date'
=> 'Fixer Date',

   'Set Defaults for All Resources in Course'
=> 'Fixer valeurs par defaut pour toutes les ressources du cours',

   'Set a bookmark for this resource'
=> 'Etablir un signet pour cette ressource',

   'Set a due date'
=> 'Fixer une date due',

   'Set an answer open date'
=> 'Fixer une date pour afficher les rponses',

   'Set an open date'
=> 'Fixer une date d ouverture',

   'Set opening date for all problems in the course for. . .'
=> 'Fixer la date de disponibilit de tous les problmes du cours pour  . .',

   'Set the number of tries'
=> 'Fixer le nombre d essai',

   'Set the problem weight'
=> 'Fixer le poids (coefficient) du problme',

   'Set/Modify Course Assessment Parameter'
=> 'Fixer/Modifier Paramtre des devoirs du Cours',

   'Set/Modify Course Assessment Parameters'
=> 'Fixer/Modifier Paramtres des devoirs du Cours',

   'Set/Modify Course Parameters'
=> 'Fixer/Modifier Parameres du Cours',

   'Shared by course faculty and staff'
=> 'Partage par le corps enseignant du cours',

   'Show More Options'
=> 'Montrer plus Options',

   'Show all rles'
=> 'Mostrer tous les roles',

   'Show catalog information'
=> 'Montrer information de catalogue',

   'Show resource'
=> 'Montrer ressource',

   'Significant figures are incorrect, submission was not graded.'
=> 'Nombres de chiffres significatifs incorrect, la rponse soumise n a pas t evalue.',

   'Since Start of Course'
=> 'Depuis le dbut du Cours',

   'Since Yesterday'
=> 'Depuis hier',

   'Size'
=> 'Taille',

   'Skew Tries'
=> 'Essai de biais',

   'Special documents'
=> 'Documents spcials',

   'Spreadsheet Computation'
=> 'Calcul de Tableur',

   'Spreadsheet Computation Status'
=> 'Etat du calcul du tableur',

   'Statistics'
=> 'Donnes satistiques',

   'Statistics and Problem Analysis'
=> 'Donnes satistiques et analyse de problmes',

   'Store'
=> 'Sauvegarder',

   'Store Catalog Information'
=> 'Sauvegarder information du catalogue',

   'Student level sheet'
=> 'Tableur au niveau tudiant',

   'Student performance statistics on all problems.'
=> 'Donnes statistiques de la performance de l tudiant avec tous les problmes.',

   'Students Affected'
=> 'Etudiants concerns',

   'Subject'
=> 'Sujet',

   'Successful Login'
=> 'Connection russie',

   'Suggested Replacement for Obsolete File'
=> 'Suggestion de remplacement pour fichier dsuet',

   'Summary'
=> 'Rsum',

   'Summary View'
=> 'Visualisation du Rsum',

   'Switching Role'
=> 'Changement de rle',

   'Synchronized SQL metadata database'
=> 'Base de donnes de meta-donnes SQL synchronise',

   'Target'
=> 'Cible',

   'Task'
=> 'Tche',

   'Template'
=> 'Gabarit',

   'Temporary Assembly Workspace'
=> 'Espace temporaire de montage',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'Toute information soumise est visible  tout utilisateur connect  LONCAPA. Ne soumettez aucune information que vous ne dsirez pas partager publiquement.',

   'There are currently no results'
=> 'Pas de resultats pour l instant',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> "cette aide vous aidera en fixant la dates d ouverture, la date de et la date d affichage des rponses ainsi que le nombre d essais permis pour les problmes. Vous serez invit  choisir pour quels problmes vous souhaitez fixer les paramtres, puis quel paramtre vous souhaitez fixer, ensuite vous choisirez qui sera affect par la nouvelle configuration. Aprs que l'aide ait fini sa tche, il vous montrera o dans l'interface avane vous auriez du all pour fixer le paramtre que vous avez choisi, pour qu  l'avenir vous puissiez le faire directement. Cliquez Suivant -&gt; pour commencer, ou cliquez &lt;- prcdent pour retourner  l'cran prcdent.",

   'This syllabus can be publicly viewed at'
=> 'Ce programme peut tre publiquement visualis ',

   'Topic'
=> 'Sujet',

   'Total'
=> 'Total',

   'Total Parts In Course'
=> 'Nombre total de composants du cours',

   'Total number of students who have worked on this problem'
=> 'Nombre total d tudiants qui ont travaill sur ce problme',

   'Type'
=> 'Type',

   'UNIX authenticated'
=> 'Authentification par UNIX',

   'URL'
=> 'Adresse URL',

   'URLs To Include in Syllabus'
=> 'Adresses URL  inclure dans le Programme du Cours',

   'USERS'
=> 'UTILISATEURS',

   'Unable to connect to database!'
=> 'incapable de connecter  la base de donnes!',

   'Unknown ID'
=> 'Identification inconnue',

   'Unknown user'
=> 'Utilisateur inconnu',

   'Unpublished'
=> 'Non publi(e)',

   'Unselect All'
=> 'Dslectioner Tout',

   'Unselect All Students'
=> 'Dslectioner Tous les Etudiants',

   'Up'
=> 'vers le haut ',

   'Update Course Assessment Parameter Display'
=> 'Mise  jour de la visualisation des paramtres des devoirs du cours',

   'Update Display'
=> 'Mise  jour de la visualisation',

   'Update Section or Specific User'
=> 'Mise  jour de la section ou d un utilisateur spcifique',

   'Upload Scantron data'
=> 'Tlcharger les donnes Scantron',

   'Upload a Photo'
=> 'Tlcharger une photo',

   'Upload a new main course document'
=> 'Tlcharger un nouveau document principal de cours',

   'Upload a new supplemental course document'
=> 'Tlcharger un nouveau document supplmentaire pour le cours',

   'User'
=> 'Utilisateur',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'Notes de l utilisateur, enregistrements des discussions en tte  tte , et Messages critiques du Cours',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'Notes de l utilisateur, enregistrements des discussions en tte  tte, et Messages critiques',

   'Verify Course Documents'
=> 'Vrifier les Documents du Cours',

   'Verify Selection'
=> 'Vrifier Slection',

   'Version'
=> 'Version',

   'Version Number'
=> 'Numero de Version',

   'View'
=> 'Visualiser',

   'View Critical Messages'
=> 'Visualiser Messages Critiques',

   'View Published Version'
=> 'Visualiser Version Publie',

   'View user submissions for this assessment resource'
=> 'Visualiser les rponses de l utilisateur pour ce devoir',

   'Web References'
=> 'Rfrences Web',

   'Welcome to the Assignment Parameter Helper'
=> 'Bienvenu au programme d aide de configuration et attribution des paramtres',

   'What parameter do you want to set for all problems in the course?'
=> 'Quel paramtre desirez vous etablir pour tous les problmes du cours?',

   'What should the opening date be set to?'
=> 'Quelle date d ouverture (du problme) voulez vous?',

   'Which Problem or Problems?'
=> 'Quel(s) Problme ou Problmes?',

   'Which problems do you wish to set a parameter for?'
=> 'Pour quels problmes voulez vous tablir le paramtre?',

   'Words'
=> 'Mots',

   'Wrote Metadata'
=> 'Mta-donnes enregistres',

   'XML/SGML'
=> 'XML/SGML',

   'You must choose at least one student to continue.'
=> 'Vous devez choisir au moins un tudiant pour continuer.',

   'You must choose one or more choices to continue.'
=> 'Vous devez slectionner une ou plusieurs options avant de continuer.',

   'You need to choose another user role or enter a specific course for this function'
=> 'Vous devez choisir un autre rle ou un cours spcifique pour cette fonction',

   'Your Excel Spreadsheet'
=> 'Votre tableur Excel',

   'Your home server is '
=> 'Votre Serveur d acceuil',

   'a.m.'
=> 'a.m.',

   'abstract'
=> 'rsum',

   'acc keys'
=> 'Touches d accs',

   'access denied'
=> 'accs refus',

   'according to course preferences'
=> 'd apres les prferences du cours',

   'according to resource settings'
=> 'd apres la configuration de la ressource',

   'according to user session state'
=> 'd apres l tat de la session de l utilisateur',

   'all'
=> 'tout',


   'anno-[_1]'
=> 'anno-[_1]',

   'announce'
=> 'annoncer',

   'at'
=> '',

   'at Domain'
=> 'au Domaine',

   'at domain'
=> 'au domaine',

   'audio'
=> 'audio',

   'author'
=> 'auteur',

   'backward[_1]'
=> 'backward[_1]',

   'bookmark[_2]'
=> 'bookmark[_2]',

   'catalog[_1]'
=> 'catalog[_1]',

   'chart'
=> 'diagramme',

   'chat'
=> 'causerie',

   'close this window'
=> 'fermez cette fentre',

   'connection down'
=> 'connexion ferme',

   'contacting'
=> 'entrant en contact',

   'copyright'
=> 'copyright',

   'custom distribution file'
=> 'fichier de distribution sur mesure ',

   'default'
=> 'par default',

   'directory'
=> 'rpertoire',

   'discuss[_1]'
=> 'discuss[_1]',

   'docs'
=> 'documents',

   'during the last'
=> 'durant la dernire',

   'edit'
=> 'diter',

   'evaluate[_1]'
=> 'evaluate[_1]',

   'exit'
=> 'sortir',

   'fas'
=> 'fas',

   'feedback[_1]'
=> 'feedback[_1]',

   'for Enclosing Map or Folder'
=> 'pour la carte ou le dossier',

   'for Resource'
=> 'pour la ressource',

   'forward[_1]'
=> 'forward[_1]',

   'from Enclosing Map or Folder'
=> 'de la carte ou du dossier',

   'general'
=> 'gneral',

   'in Course'
=> 'dans le Cours',

   'in Section/Group'
=> 'dans section/Groupe',

   'info'
=> 'info',

   'interface available'
=> 'interface disponible',

   'keywords'
=> 'mots-cls',

   'language'
=> 'langage',

   'last student'
=> 'dernier tudiant',

   'library'
=> 'bibliothque',

   'log in again'
=> 'Se connecter de nouveau',

   'manage'
=> 'grez',

   'may be open from a different computer.'
=> 'peut tre ouvert  partir d un ordinateur diffrent.',

   'midnight'
=> 'minuit',

   'minutes'
=> 'minutes',

   'missions'
=> 'missons',

   'movies'
=> 'films',

   'my'
=> 'mon/ma/mes',

   'noon'
=> 'midi',

   'not found'
=> 'non trouv',

   'notes'
=> 'notes',

   'num_override'
=> 'num_dpassement',

   'obsolete'
=> 'dsuet',

   'obsolete replacement'
=> 'remplacement obsolte',

   'of'
=> 'de',

   'or'
=> 'ou',

   'or ID'
=> 'ou ID',

   'p.m.'
=> 'p.m.',

   'pages'
=> 'pages',

   'parms'
=> 'paramtres',

   'part'
=> 'partie',

   'percent'
=> 'pourcent',

   'pictures'
=> 'figures',

   'prepare'
=> 'Prparez',

   'printout'
=> 'Tirage',

   'problem'
=> 'problme',

   'problem statistics grouped by sequence'
=> 'Donnes statistiques des problmes groupes par squences',

   'problem statistics ungrouped'
=> 'Donnes statistiques non groupes des problmes',

   'problem statistics, Excel'
=> 'Donnes statistiques des problmes, Excel',

   'remaining'
=> 'restant',

   'resource'
=> 'ressource',

   'resources'
=> 'ressources',

   'roles'
=> 'rles',

   'search'
=> 'cherchez',

   'second'
=> 'seconde',

   'seconds'
=> 'secondes',

   'seconds for'
=> 'secondes pour',

   'sequence'
=> 'squence',

   'set[_1]'
=> 'placez[_1]',

   'space'
=> 'espace',

   'stats'
=> 'Donnes statistiques',

   'con-'
=> 'construction-',

   'struct'
=> 'structure',

   'subject'
=> 'sujet',

   'switch'
=> 'commutez',

   'title'
=> 'titre',

   'unless locked'
=> ' moins que verrouill ',

   'updated periodically'
=> 'mis  jour priodiquement ',

   'user'
=> 'utilisateur',

   'users in'
=> 'utilisateurs dans',

   'view sub-'
=> 'visualisez sub-',

   'visible to author and co-authors only'
=> "visible  l'auteur et aux co-auteurs seulement",

   'waiting on'
=> 'attendant',

   'warning(s)'
=> 'avertissement(s)',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> "Bienvenue au rseau d'tude <i>en ligne </i>avec CAPA. Attendez s'il vous plat tandis que votre session se configure",

   'Welcome'
=> 'Bienvenue',

   'Calculate answers'
=> 'Calculez les rponses',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Montrer&nbsp;Toutes&nbsp;les Alternatives',

   '1 out of N multiple choice (radio button)'
=> '1 des N choix multiples (bouton radio)',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Incapable d inscrire: [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Incapable d inscrire. Aucun mot de passe indiqu.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Nom d utilisateur inacceptable pour l utilisateur [_2] [_3] [_4] [_5]',

   'Administrator'
=> 'Administrateur',

   'All Documents in Course'
=> 'Tous les documents du Cours',

   'All Resources (possibly large output)'
=> 'Toutes les ressources (probablement grande sortie)',

   'Analyze Over '
=> 'Analisez Sur ',

   'Analyze Problem'
=> 'Analisez le problme',

   'Analyze Problem Again'
=> 'Analisez le problme de nouveau',

   'Analyze as '
=> 'Analisez comme ',

   'Anonymous'
=> 'Anonyme',

   'Anonymous contribution to course discussion of resource'
=> 'Contribution anonyme  la discussion de cours sur la ressource',

   'Answer:'
=> 'Rponse:',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> "En rgle gnrale, seulement les auteurs ou les co-auteurs devraient tre authentifis par fichier  systme (ce qui permet l'accs au fichier systme du serveur).",

   'Associate columns with student attributes.'
=> 'Associez les colonnes aux attributs de l tudiant.',

   'Attachment'
=> 'Pice jointe',

   'Attribute'
=> 'Attribut',

   'Browsing resource, all submissions are temporary.'
=> 'Survolant la ressource, toutes les soumissions sont provisoires.',

   'By'
=> 'Par',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (valeurs spares par virgule, tableur) ',

   'Calculate answers'
=> 'Calculez les rponses',

   'Change'
=> 'Changez',

   'Change Random Seed To:'
=> 'Changez l initialisation du tirage alatoire a:',

   'Change Your Language Preferences'
=> 'Changez Vos Prfrences De Langage',

   'Changed discussion view mode'
=> 'Mode de visualisation de la discussion chang',

   'Check All'
=> 'Slectionez Tous',

   'Check Course Document Versions'
=> 'Slectionez la version du document du cours',

   'Check for All'
=> 'Slectionez pour tous',

   'Check for None'
=> 'Slectionez aucun',

   'Check for Section/Group'
=> 'Slectionez Section/Groupe',

   'Check/Set Resource Versions'
=> 'Slectionez/imposez les versions de la ressource',

   'Choose a different resource'
=> 'Choisir une ressource differente',

   'Chronological View'
=> 'Visualisation Chronologique',

   'Click-On Texts (comma sep):'
=> 'Textes cliquables (spars par virgule):',

   'Column'
=> 'Colonne ',

   'Column&nbsp;[_1]'
=> 'Column&nbsp;[_1]',

   'Concept:'
=> 'Concept:',

   'Concepts'
=> 'Concepts',

   'Continue enrollment?'
=> "Continuez l'inscription?",

   'Contribution to course discussion of resource'
=> 'Contribution  la discussion de la ressource du cours',

   'Correct Option:'
=> 'Option Correcte:',

   'Create a New Course'
=> 'Crez un nouveau cours ',

   'Critical Messages'
=> 'Messages Critiques',

   'Current'
=> 'Actuel',

   'Default:'
=> 'Dfaut:',

   'Delete'
=> 'Effacez',

   'Delete Checked'
=> 'Effacez ceux marqus',

   'Delete an option'
=> 'Effacez une option',

   'Delete:'
=> 'Effacez:',

   'Description:'
=> 'Description:',

   'Diffs'
=> 'Differences',

   'Diffs with Current Version'
=> 'Differences avec la version actuelle',

   'Diffs with Version'
=> 'Differences avec la version',

   'Diffs with current Version'
=> 'Differences avec la version actuelle',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> "Invalidez la Sauvegarde de l'Identification/numro d'tudiant et forcez le changement des identifications contradictoires ( faire seulement si vous savez ce que vous faites)",

   'Discussion Contributions'
=> 'Contributions  la Discussion',

   'Display All Messages'
=> 'Visualiser Tous les Messages',

   'Display all Messages'
=> 'Visualiser tous les Messages',

   'Display and analysis of submission times on assessments.'
=> 'Affichage et analyse des temps de soumission des devoirs.',

   'Display foils in order given'
=> 'Viusaliser les alternatives dans l ordre donn',

   'Display foils in random order'
=> 'Viusaliser les alternatives dans un ordre alatoire',

   'Domain Guest'
=> 'Invit de Domaine ',

   'Drop Students'
=> 'Exclure des tudiants',

   'Dropped [_1]'
=> 'Dropped [_1]',

   'Dropped [_1] student(s).'
=> 'Dropped [_1] student(s).',

   'Dropping Students'
=> 'Exclurant des tudiants',

   'Dump Course DOCS'
=> 'Videz les DOCS du cours',

   'EMail Address'
=> 'Adresse E-Mail',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> "Erreurs d'diteur - ces erreurs pourraient ne pas affecter l xecution du problme, mais ils poseront probablement des problmes avec l utilisation ultrieure du mode d dition. Veuillez employer le mode EditXML pour fixer ces erreurs.",

   'Enroll a single student'
=> 'Inscrire un seul tudiant',

   'Enrolling Students'
=> 'Inscription d tudiants',

   'Error'
=> 'Erreur',

   'Error dropping [_1]:[_2]'
=> 'Error dropping [_1]:[_2]',

   'False'
=> 'Faux',

   'Field'
=> 'Champs',

   'Filenames in Construction Space'
=> 'Noms de fichiers dans l espace de construction',

   'First Name'
=> 'Prnom',

   'Foil'
=> 'Alternative',

   'Foils'
=> 'Alternatives',

   'Folder in Construction Space'
=> 'Dossiers de fichiers dans l espace de construction',

   'Format:'
=> 'Format:',

   'Forward'
=> 'Expdiez vers l avant',

   'Forwarded message from'
=> 'Message expdi de',

   'Forwarding'
=> 'Expdiant',

   'From'
=> 'De',

   'Full Update'
=> 'Mise  jour Complte',

   'Full update (also print list of users not enrolled anymore)'
=> "Mise  jour Complte (imprimez galement la liste d'utilisateurs exclus)",

   'Functions'
=> 'Fonctions',

   'Generation'
=> 'Gnration ',

   'Group/Section'
=> 'Groupe/Section',

   'HTML/XML'
=> 'HTML/XML',

   'Height(pixel):'
=> 'Hauteur(pixel):',

   'Hide'
=> 'Cacher',

   'Hint Text'
=> 'Texte donnant un indice',

   'ID/Student Number'
=> 'ID/Numro d identification de l tudiant(e)',

   'Identify fields'
=> 'Champs d identification',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'si actif, le nouveau rle sera disponible  la prochaine connexion de l tudiant  LON-CAPA.',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'Si cette ressource est en utilisation active, les donnes de performance des tudiants sur la version prcdente peuvent devenir inaccessibles.',

   'Ignore First Line'
=> 'Ignorer la premire ligne',

   'Image:'
=> 'Image:',

   'Incorrect Answers:'
=> 'Rponses Incorrectes:',

   'Initial Password'
=> 'Mot de passe Initial',

   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (Association Internationale d une Langue Auxiliaire) - ISO',

   'Internal Filename'
=> 'Fichier interne',

   'Invalid home server specified'
=> 'Serveur HOME spcifi invalide',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Maintenez toutes les ressources  jour avec les versions les plus rcentes (dfaut) ',

   'LON-CAPA Domain for Students'
=> 'Domaine LON-CAPA pour les tudiants',

   'LON-CAPA Enrollment Manager'
=> 'Gestionnaire d Inscription de LON-CAPA ',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA domain: [_1]',

   'LaTeX batchmode'
=> 'LaTeX en tche de fond',

   'LaTeX mode:'
=> 'mode LaTeX:',

   'Last Name'
=> 'Nom',

   'Last Name, First Names'
=> 'Nom, Prnoms',

   'Last accessed'
=> 'Acced dernierement',

   'Librarian'
=> 'Bibliothcaire ',

   'Login Type'
=> 'Type de procdure de connexion',

   'Making Backup to'
=> 'Faisant une sauvegarde sur',

   'Mark Unread'
=> 'Marquez comme non lu',

   'Max Number Of Shown Foils:'
=> 'Nombre maximum d alternatives montres:',

   'Max number of foils displayed'
=> 'Nombre maximum d alternatives visualises:',

   'Metadata'
=> 'Mta-donnes ',

   'Metadata Version'
=> 'Version des Meta-donnes ',

   'Metadata current version'
=> 'Version Actuelle des Mta-donnes',

   'Middle Names/Initials'
=> 'Deuxime prnom/initiales ',

   'Modify Parameters'
=> 'Modifiez les Paramtres',

   'Modify student data'
=> 'Modifiez les donnes de l tudiant(e)',

   'Most recently published Version'
=> 'Version la plus rcemment publie ',

   'Name:'
=> 'Nom:',

   'New Problem Variation'
=> 'Nouvelle Variation du Problme',

   'New Randomization'
=> 'Nouveau tirage alatoire',

   'New parameters or stored values'
=> 'Nouveaux paramtres ou valeurs enregistres',

   'Next'
=> 'Prochain',

   'No'
=> 'Non',

   'No Kerberos domain was specified.'
=> 'Aucun domaine Kerberos n a t spcifi.',

   'No language preference'
=> 'Aucune prfrence de langage',

   'None Found'
=> 'Aucun trouv',

   'Not applicable - '
=> 'Non applicable - ',

   'Not set - '
=> 'Pas dtermin - ',

   'Not shown, not used'
=> 'Pas Montr, Pas utili',

   'Note: for large courses, this operation may be time consuming'
=> 'Note : pour de grands cours, cette opration peut prendre du temps',

   'Note: this will not take effect if the user already exists'
=> "Note : ceci n'entrera pas en vigueur si l'utilisateur existe dj",

   'Number of Plots:'
=> 'Nombre de Graphes:',

   'Obsolete parameters or stored values'
=> 'Paramtres ou valeurs enregistres dsuets',

   'One particular problem (overrides folder and course defaults)'
=> "Un problme particulier (ignore la chemise et les paramtres par dfauts du cours)",

   'Only Answers'
=> 'Rponse simplement',

   'Option Response Problem Analysis'
=> 'Analyse de problema  rponses  choix multiple',

   'Option response'
=> 'Rponse  choix multiple',

   'Please do not reply to this address.'
=> 'SVP ne rpondez pas  cette adresse.',

   'Please select a report to generate'
=> 'Choisissez SVP un rapport  produire ',

   'Position'
=> 'Position',

   'Preferred language'
=> 'Langage Prfre',

   'Preparing Printout'
=> 'Prparant la sortie d impression',

   'Previous'
=> 'Prcdent',

   'Print Index:'
=> 'Imprimez le lexique:',

   'Print Table of Contents:'
=> 'Imprimez la table des matires:',

   'Print:'
=> 'Imprimez:',

   'Problems'
=> 'Problmes',

   'Problems from entire course'
=> 'Problmes du cours entier',

   'Processed [_1] student(s).'
=> 'Processed [_1] student(s).',

   'Produce Excel Output'
=> 'Produire tableur Excel',

   'Question Text'
=> 'Texte de la Question',

   'Question Type'
=> 'Type de Question',

   'Random position'
=> 'Position alatoire ',

   'Re'
=> 'Re',

   'Re-enrollment will re-activate data.'
=> 'La Re-inscription ractivera les donnes.',

   'Record'
=> 'Registre',

   'Registering'
=> 'Enregistrement',

   'Reply'
=> 'Rpondre/rponse',

   'Reset Submissions'
=> 'Rinitialisez les Soumissions',

   'Resources from selected sequence in course'
=> 'Ressources de la squence de cours choisie ',

   'Retrieve Published Resources'
=> 'Rcuperez les Ressources Publies',

   'Retrieving current (most recent) version'
=> 'Rcupration de la version actuelle (plus rcente)',

   'Sample Points:'
=> 'Points chantillon:',

   'Samples'
=> 'Echantillons',

   'Save as ...'
=> 'Sauvegardez comme ...',

   'Select Printing Options:'
=> 'Slectionnez les options d impression:',

   'Select a course'
=> 'Slectionnez un cours',

   'Selecting a User'
=> 'Slectionnez un Utilisateur',

   'Send New'
=> 'Envoyez Nouveau',

   'Send Reply'
=> 'Envoyez Rponse',

   'Send as critical message'
=> 'Envoyez comme message critique',

   'Set Version to be used in Course'
=> 'Choisir la version  utiliser dans le cours',

   'Set Versions to be used in Course according to Selections below'
=> 'Choisir les versions  utiliser dans le cours selon des slections ci-dessous',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Fixez toutes les versions de ressource  la version en cours
(Corrigez versions) ',

   'Short string response'
=> 'Rponse type chane courte de caractres',

   'Show Preview'
=> 'Visualisation prliminaire',

   'Show always at bottom position'
=> 'Montrer toujours en position infrieure',

   'Show always at top position'
=> 'Montrer toujours en position suprieure',

   'Simple Problem Editor'
=> 'Editeur simple de problmes',

   'Size:'
=> 'Taille:',

   'Space separated'
=> 'separ(e) par un espace',

   'Starting'
=> 'Commenant',

   'Starting and Ending Dates'
=> 'Dates de dbut et fin',

   'Store Changes'
=> 'Sauvegarde des changements',

   'Student Data Compilation Progress'
=> 'Progrs de la Compilation des Donnes de l tudiant',

   'Student Data Compilation Status'
=> 'Etat de la Compilation des Donnes de l tudiant',

   'Student Number'
=> 'Numero d tudiant',

   'Student Sheet Links'
=> 'Liens hypertexte  la page de l tudiant',

   'Submission Time Analysis'
=> 'Analyse des temps de soumissions des rponses',

   'Submit Changes and Edit'
=> 'Soumettre les changements et Editer',

   'Tabulator separated'
=> 'Tableur spar',

   'TeXWidth(mm):'
=> 'LargeurTeX(mm):',

   'Text'
=> 'Texte',

   'Text Block'
=> 'Bloque de Texte',

   'The optional email address field was not specified.'
=> "Le Champs facultatif d adresse email n'a pas t spcifi.",

   'The optional name field was not specified.'
=> "Le Champs facultatif du nom n'a pas t spcifi.",

   'The optional section or group field was not specified.'
=> "Le Champs facultatif de la section ou groupe n'a pas t spcifi.",

   'The optional student number field was not specified.'
=> "Le Champs facultatif du numro d tudiant n'a pas t spcifi.",

   'There are no students currently enrolled.'
=> "Il n'y a aucun tudiant actuellement inscrit.",

   'There is no student data for this problem.'
=> "Il n'y a aucune donne d'tudiant pour ce problme.",

   'This is an automatic message generated by the LON-CAPA system.'
=> 'Ceci est un message automatique produit par le systme LON-CAPA.',

   'Threaded View'
=> 'Visualisation Filete (Threaded)',

   'Time'
=> 'Temps',

   'To'
=> 'Pour',

   'Total number of records found in file: [_1].'
=> 'Nombre total des enregistrements trouvs dans le fichier: [_1].',

   'True'
=> 'Vrai',

   'Type in value'
=> 'Saisir une valeur',

   'Type:'
=> 'Type:',

   'Unable to enroll students'
=> 'Incapable d inscrire les tudiants',

   'Uncheck All'
=> 'Dslectioner Tous',

   'Undetermined - ISO'
=> 'Indtermin - ISO',

   'Unit:'
=> 'Unite:',

   'Unsuccessful Login'
=> 'Procdure de connexion Non russie',

   'Update Student Data'
=> 'Mise  jour des Donnes tudiant',

   'Updating discussion time'
=> 'Mise  jour du temps de discussion',

   'Upload a class list'
=> 'Tlchargez la liste d tudiant du cours',

   'Upload file to Construction Space'
=> 'Tlchargez le fichier dans l espace construction',

   'Uploading Class List'
=> 'Tlchargement de la liste d tudiant du cours',

   'Value'
=> 'Valeur',

   'Verify Content'
=> 'Verifiez Contenu',

   'Version changes since Yesterday'
=> 'Changements de version depuis hier',

   'Version changes since last Month'
=> 'Changements de version depuis le mois dernier',

   'Version changes since last Week'
=> 'Changements de version depuis la semaine dernire',

   'Version changes since start of Course'
=> 'Changements de version depuis le dbut du cours',

   'Version used in Course'
=> 'Version utilise dans le cours',

   'View Class List'
=> 'Visualiser la liste des tudiants',

   'Warning!'
=> 'Alerte!',

   'Width(pixel):'
=> 'Largeur(pixel):',

   'With Answers'
=> 'Avec Rponses',

   'Without Answers'
=> 'Sans Rponses',

   'You have no critical messages.'
=> "Vous n'avez aucun message critique.",

   'You must choose an authentication type.'
=> "vous devez choisir un type d'authentification.",

   'You need to specify the Kerberos domain.'
=> 'vous devez indiquer le domaine de Kerberos.',

   'You need to specify the initial password.'
=> 'vous devez indiquer le mot de passe initial.',

   'You need to specify the username field.'
=> 'vous devez indiquer le Champs nom d utilisateur.',

   'Your Version Settings have been Stored'
=> 'Vos configurations de version ont t enregistres',

   '[_1] Do not change login data'
=> '[_1] Ne changez pas les donnes de procdure de connexion',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Fichier systme authentifi avec le mot de passe initial [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Authentifi de faon interne (avec le mot de passe initial [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Authentifi via Kerberos, domaine [_2] [_3] Version 4 [_4] Version 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Authentification locale avec arguement [_2]',

   'and return receipt'
=> 'et delivrez un reu',

   'anonymous'
=> 'anonyme',

   'bytes'
=> 'Octets',

   'can not be accessed from your location.'
=> 'ne peut pas tre consult depuis votre emplacement.',

   'file<br />extension'
=> 'extension<br /> de fichier',

   'most recent'
=> 'plus recent',

   'name only visible to course faculty'
=> 'nom visible uniquement aux enseignants du cours',

   'publisher<br />owner'
=> 'diteur<br />propritaire',

   'standard LaTeX mode'
=> 'mode standard LaTeX',

   'versions of this problem'
=> 'versons de ce problme',

   'loginproblems.html'
=> 'loginproblems.html',

# ----

   'Course announcements and my calendar'
=> 'Calendrier et annonces de cours',

   'calendar[_1]'
=> 'calendar[_1]',

   'announce[_1]'
=> 'announce[_1]',


# ----

   'Send and receive messages'
=> 'Envoyer et recevoir des messages',

   'commu-[_1]'
=> 'commu-[_1]',

   'nication[_1]'
=> 'nication[_1]',


# ----

   'Enter the chatroom for the course'
=> 'Entrer le bavardoir (Chatroom) pour le cours',

   'course[_10]'
=> 'course[_10]',

   'chat[_1]'
=> 'chat[_1]',


# ----

   'Search the contents of this course'
=> 'Recherchez le contenu de ce cours ',

   'search[_1]'
=> 'search[_1]',

   'course[_11]'
=> 'course[_11]',


# ----

   'Search the database of published resources'
=> 'Recherchez la base de donnes des ressources publies',

   'search[_2]'
=> 'search[_2]',

   'library[_1]'
=> 'library[_1]',


# ----

   'Set my user preferences'
=> "Configurez mes prfrences d'utilisateur",

   'prefer-[_1]'
=> 'prefer-[_1]',

   'ences[_1]'
=> 'ences[_1]',


# ----

   'Exit LON-CAPA'
=> 'Sortir de LON-CAPA',

   'exit[_1]'
=> 'exit[_1]',

   ' [_1]'
=> ' [_1]',


# ----

   'Switch to another user role'
=> "Changez  un autre rle d'utilisateur",

   'switch[_2]'
=> 'switch[_2]',

   'role[_1]'
=> 'role[_1]',


# ----

   'Choose the user role'
=> "Choisir le rle d'utilisateur",

   'choose[_2]'
=> 'choisir[_2]',

   'role[_2]'
=> 'rle[_2]',


# ----

   'Choose the course to work on'
=> 'choisissez le cours pour travailler',

   'choose[_1]'
=> 'choose[_1]',

   'course[_1]'
=> 'course[_1]',


# ----

   'Switch to another course'
=> 'Changez de cours',

   'switch[_1]'
=> 'switch[_1]',

   'course[_2]'
=> 'course[_2]',


# ----

   'View documents included in this course'
=> 'visualisez les documents inclus dans ce cours',

   'course[_3]'
=> 'cours[_3]',

   'docs[_1]'
=> 'docs[_1]',


# ----

   'Edit and view documents included in this course'
=> 'ditez et visualisez les documents inclus dans ce cours',

   'edit crs[_1]'
=> 'edit crs[_1]',

   'docs[_2]'
=> 'docs[_2]',


# ----

   'Navigate the table of contents for this course'
=> 'Navigez la table des matires pour ce cours ',

   'navigate[_1]'
=> 'navigate[_1]',

   'contents[_1]'
=> 'contents[_1]',


# ----

   'Show Problem Completeness'
=> 'Montrez l tat d avancement de ce Problme',

   'my[_1]'
=> 'my[_1]',

   'grades[_1]'
=> 'grades[_1]',


# ----

   'Calculate course grades (Spreadsheet)'
=> 'Calculez les notes du cours (Tableur)',

   'course[_4]'
=> 'course[_4]',

   'grades[_2]'
=> 'grades[_2]',


# ----

   'View the course assessment progress chart'
=> 'Visualisez le diagramme de progrs des devoirs du cours',

   'course[_5]'
=> 'course[_5]',

   'chart[_1]'
=> 'chart[_1]',


# ----

   'View course assessment statistics'
=> 'Visualisez les donnes statistiques des devoirs de cours',

   'course[_6]'
=> 'course[_6]',

   'stats[_1]'
=> 'stats[_1]',


# ----

   'Drop/Add students in this course'
=> 'Eliminez/Ajoutez des tudiants dans ce cours',

   'course[_7]'
=> 'course[_7]',

   'enroll[_1]'
=> 'enroll[_1]',


# ----

   'Manage Access Keys'
=> 'Grez les Cls d accs',

   'manage[_1]'
=> 'manage[_1]',

   'acc keys[_1]'
=> 'acc keys[_1]',


# ----

   'Create a user or modify the roles and privileges of a user'
=> "crez un utilisateur ou modifiez les rles et les privilges d'un utilisateur",

   'user[_1]'
=> 'user[_1]',

   'roles[_1]'
=> 'roles[_1]',


# ----

   'Create a user or modify the roles and privileges of a user'
=> "crez un utilisateur ou modifiez les rles et les privilges d'un utilisateur",

   'user[_1]'
=> 'user[_1]',

   'roles[_1]'
=> 'roles[_1]',


# ----

   'Create a user or modify the roles and privileges of a user'
=> "crez un utilisateur ou modifiez les rles et les privilges d'un utilisateur",

   'user[_1]'
=> 'user[_1]',

   'roles[_1]'
=> 'roles[_1]',


# ----

   'Create a new course'
=> 'Crer un nouveau cours',

   'create[_1]'
=> 'create[_1]',

   'course[_8]'
=> 'course[_8]',


# ----

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> "Dfinir les dates-limites et autres paramtres des devoirs, et aussi modifiez l'environnement de cours",

   'course[_9]'
=> 'course[_9]',

   'parms[_1]'
=> 'parms[_1]',


# ----

   'Enter my resource construction space'
=> 'Entrez mon espace construction de ressource',

   'con-[_1]'
=> 'con-[_1]',

   'struct[_1]'
=> 'struct[_1]',


# ----

   'Enter construction space as a co-author'
=> 'Entrer l espace construction comme co-auteur',

   'co con-[_1]'
=> 'co con-[_1]',

   'struct[_2]'
=> 'struct[_2]',


# ----

   'Browse published resources'
=> 'Naviguer les Ressources Publies',

   'resource[_1]'
=> 'resource[_1]',

   'space[_1]'
=> 'space[_1]',


# ----

   'Browse published resources'
=> 'Naviguer les Ressources Publies',

   'co res[_1]'
=> 'co res[_1]',

   'space[_2]'
=> 'space[_2]',


# ----

   'Browse published resources'
=> 'Naviguer les Ressources Publies',

   'resource[_1]'
=> 'resource[_1]',

   'space[_1]'
=> 'space[_1]',


# ----

   'Enter grades from check-out assessment resources'
=> "Ecrire les notes de contrle des ressources d'valuation",

   'enter[_1]'
=> 'enter[_1]',

   'grades[_2]'
=> 'grades[_2]',


# ----

   'Send Scantron data to a course'
=> 'Envoyer les donnees Scantron a un cours',

   'send[_1]'
=> 'send[_1]',

   'scantron[_1]'
=> 'scantron[_1]',


# ----

   'Use or edit my bookmark collection'
=> 'Utiliser ou editer ma collection de signets',

   'view[_1]'
=> 'view[_1]',

   'bookmark[_1]'
=> 'bookmark[_1]',


#SYNC Tue Aug 15 14:23:19 2006
   '"[_1]" for default hiding'
=> '"[_1]" for default hiding',
# "[_1]" fou par Dfaut  hiding
   '"[_1]" for visible separation'
=> '"[_1]" for visible separation',
# "[_1]" fou visible separion
   '"[_1]" if allowed, anything else if not'
=> '"[_1]" if allowed, anything else if not',
# "[_1]" if PouruPourMer, anything else if Nont
   '"[_1]" to disable, anything else if not'
=> '"[_1]" to disable, anything else if not',
# "[_1]" Pour disable, anything else if Nont
   '# Do not translate this line.  [_1] is a check box'
=> '# Do not translate this line.  [_1] is a check box',
# # Do Nont transle this line.  [_1] is a check box
   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field',
# # Do Nont transle this line.  [_1] is a check box, [_2] is a Texte entry Champs
   '# Do not translate this line.  [_1] is a column index.'
=> '# Do not translate this line.  [_1] is a column index.',
# # Do Nont transle this line.  [_1] is a Colonne  index.
   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Do not translate this line.  [_1] is a drop-down box listing domains.',
# # Do Nont transle this line.  [_1] is a drop-down box listing Domaines.
   '# Do not translate this line.  [_1] is a username'
=> '# Do not translate this line.  [_1] is a username',
# # Do Nont transle this line.  [_1] is a utiliseurNom
   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Do not translate this line.  [_1] is the number of students processed',
# # Do Nont transle this line.  [_1] is the number de Etudiant(e)s processed
   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.',
# # Do Nont transle this line.  [_1] is utiliseurNom, [_2] - [_5] aRe first, middle, and last Noms, and generion.
   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Do not translate this line.  [_1] is username, [_2] is error message',
# # Do Nont transle this line.  [_1] is utiliseurNom, [_2] is errou message
   '# Do not translate this line.  [_1] is username@domain'
=> '# Do not translate this line.  [_1] is username@domain',
# # Do Nont transle this line.  [_1] is utiliseurNom@Domaine
   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Do not translate this line.  [_1] is username@domain [_2] is the error message.',
# # Do Nont transle this line.  [_1] is utiliseurNom@Domaine [_2] is the errou message.
   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Do not translate this line.  [_1], [_3], and [_4] are check boxes',
# # Do Nont transle this line.  [_1], [_3], and [_4] aRe check boxes
   '# Do not translate this line.  [_2] is a text entry element'
=> '# Do not translate this line.  [_2] is a text entry element',
# # Do Nont transle this line.  [_2] is a Texte entry element
   '# [_1] is a drop-down selection box'
=> '# [_1] is a drop-down selection box',
# # [_1] is a drop-down Slectionezion box
   '# [_1] is a number [_2] is the current domain'
=> '# [_1] is a number [_2] is the current domain',
# # [_1] is a number [_2] is the Actuel Domaine
   '# [_1] is an html link to the current file '
=> '# [_1] is an html link to the current file ',
# # [_1] is an HTML link Pour the Actuel Fichier 
   '# _1 is a selection dialog'
=> '# _1 is a selection dialog',
# # [_1]1 is a Slectionezion dialog
   '# _1 is a server name'
=> '# _1 is a server name',
# # [_1]1 is a Serveur Nom
   '# _1 is search string'
=> '# _1 is search string',
# # [_1]1 is cherchez string
   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'",
# # [_1]1, [_1]3, and [_1]5 aRe link anchous, [_1]2,_4, and [_1]6 aRe '</a>'
   '#[_1] is the foil name'
=> '#[_1] is the foil name',
# #[_1] is the Alternative Nom
   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 is the foil name, _2 is the current value of the foil',
# #_1 is the Alternative Nom, [_1]2 is the Actuel Valeur de the Alternative
   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.',
# &quot; [_1] &quot; is Nont an acceptable number de NonmbRe d essai. NonmbRe d essai must be a positive number with Non decimal point.
   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.',
# &quot; [_1] &quot; is Nont an acceptable weight. Weight must be a positive number.
   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',
# (entRer maximum [_1] collabouous using utiliseurNom ou utiliseurNom@Domaine, e.g. smithje ou smithje@[_2].)
   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',
# (Hand in a Fichier you have PrpaRezd on your computer)
   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',
# , Slectionner un temple De the pull-down menu below.
   '1 minute'
=> '1 minute',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',
# <*Response>s aRe both inside de <Partieie> and outside de <Partieie>, this is Nont a valid problme, errous in Assigner des notes Mai occur.
   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.',
# <b>HTML PouruPourMer</b>: Discussion Partieieicipants can use limited HTML in their postings.
   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML banned</b>: HTML will not be allowed in discussion postings.',
# <b>HTML banned</b>: HTML will Nont be PouruPourMer in discussion postings.
   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructors will not be able to participate in discussions',
# <b>InstructuReou</b> - instructuReous will Nont be able Pour Partieieicipe in Discussons
   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructors will not be able to use or view the chat room',
# <b>InstructuReou</b> - instructuReous will Nont be able Pour use ou Visualiser the caUtiliSameurie room
   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Students</b> - students will not be able to participate in discussions',
# <b>Etudiant(e)s</b> - Etudiant(e)s will Nont be able Pour Partieieicipe in Discussons
   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Students</b> - students will not be able to use or view the chat room.',
# <b>Etudiant(e)s</b> - Etudiant(e)s will Nont be able Pour use ou Visualiser the caUtiliSameurie room.
   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions',
# <b>Assistant de Courss</b> - Assistant de Courss will Nont be able Pour Partieieicipe in Discussons
   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room',
# <b>Assistant de Courss</b> - Assistant de Courss will Nont be able use ou Visualiser the caUtiliSameurie room
   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>',
# <p>Your Actuel LON-CAPA Domaine is &quot;<b>[_1]</b>&quot;.</p>
   'ABSTRACT'
=> 'ABSTRACT',
# rsum
   'Access Control'
=> 'Access Control',

   'Activate'
=> 'Activate',
# Active
   'Add Roles'
=> 'Add Roles',
# Add rles
   'Add new option'
=> 'Add new option',

   "Add one empty page/column after each student's assignment"
=> "Add one empty page/column after each student's assignment",
# Add one Vide Page/Colonne  after each Etudiant(e)'s assignment
   "Add three empty pages/column after each student's assignment"
=> "Add three empty pages/column after each student's assignment",
# Add thRee Vide Pages/Colonne  after each Etudiant(e)'s assignment
   "Add two empty pages/column after each student's assignment"
=> "Add two empty pages/column after each student's assignment",
# Add two Vide Pages/Colonne  after each Etudiant(e)'s assignment
   'Additional Recipients'
=> 'Additional Recipients',

   'Additional settings, if specified below, will override cloned settings'
=> 'Additional settings, if specified below, will override cloned settings',

   'Advanced Edit'
=> 'Advanced Edit',
# Advanced diter
   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.',
# Advanced: You can sFin/Finir the feedback De diffeRent Sections Pour diffeRent people, Par doing the following: Separe each entry with a comma. Pour sFin/Finir feedback Pour a certain addRess fou diffeRent Sections, appFin/Finir the Section Nom ou Noms (separed Par semi-colons) in a paRentheTailled list after the utiliseur:Domaine. Fou example, john102:msu(001;002;003),bob293:msu(004;005;006),madevers le haut Nom:heRe(007;008;009) will route cours feedback Pour &quot;john102&quot; fou Sections [_1], 2, and 3, Pour &quot;bob293&quot; fou 4, 5, and 6, and Pour &quot;madevers le haut Nom:heRe&quot; fou 7, 8, and 9. Nonte theRe is Non RequiRement th the addResses be in any Partieieicular Domaine.
   'All Resources'
=> 'All Resources',
# Pourut Ressources
   'All Students'
=> 'All Students',
# Pourut Etudiant(e)s
   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.',
# Pourut settings which you can Changez with this Aideer can also be Changezd Par going Pour the Pa.m.scReen and clicking on the &quot;Set cours environment&quot; butPourn. If you do Nont have experience cooudining LON-CAPA courss ou if you pRefer the Aideer interface, please click Prochain -&gt;.
   'Allow limited HTML in discussion posts'
=> 'Allow limited HTML in discussion posts',
# PouruPourw limited HTML in discussion posts
   'Allow problems to be split over pages'
=> 'Allow problems to be split over pages',
# PouruPourw problmes Pour be split over Pages
   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Allowed File Extensions for Uploaded Files (uploadedfiletypes)',
# PouruPourMer Fichier Extensions fou A t tlcharg vers le serveur Fichiers (A t tlcharg vers le serveurFichierTypes)
   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',
# PouruPourMer FichierTypes: <b>[_1]</b>
   'An error occured during the attempt to change the section for this student.'
=> 'An error occured during the attempt to change the section for this student.',
# An errou occuRed during the tempt Pour Changez the Section fou this Etudiant(e).
   'An error occurred during the attempt to change the role information for this student.'
=> 'An error occurred during the attempt to change the role information for this student.',
# An errou occurRed during the tempt Pour Changez the rle infoumion fou this Etudiant(e).
   'Analyzing Results'
=> 'Analyzing Results',

   'Answer Date (answerdate)'
=> 'Answer Date (answerdate)',
# Rponse De (Rponsede)
   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',
# Rponse SoumettReted: Your final submission will be graded after the est d  de.
   'Answerable'
=> 'Answerable',
# Rponseable
   'Assessment Parameters'
=> 'Assessment Parameters',
# valuation Parameters
   'Automated Enrollment Manager'
=> 'Automated Enrollment Manager',
# AuPourmed inscriRement gRezr
   'Automated adds'
=> 'Automated adds',
# AuPourmed adds
   'Automated drops'
=> 'Automated drops',
# AuPourmed drops
   'Automated enrollment settings'
=> 'Automated enrollment settings',
# AuPourmed inscriRement settings
   'Bad Filename'
=> 'Bad Filename',
# Bad FichierNom
   'Begin Enrollment'
=> 'Begin Enrollment',
# Begin inscriRement
   'Binary File'
=> 'Binary File',
# Binary Fichier
   'Blank'
=> 'Blank',

   'Browse'
=> 'Browse',
# BLignese
   'Browse resources'
=> 'Browse resources',
# BLignese Ressources
   'CSV format'
=> 'CSV format',
# CSV foum
   'Cannot publish directory'
=> 'Cannot publish directory',
# CanNont Publier diRecPouruy
   'Cannot retrieve directory'
=> 'Cannot retrieve directory',
# CanNont RestauRer diRecPouruy
   'Catalog Search'
=> 'Catalog Search',
# Calog cherchez
   'Change User Privileges'
=> 'Change User Privileges',
# Changez utiliseur Privileges
   'Chat Participation'
=> 'Chat Participation',
# caUtiliSameurie Partieieicipion
   'Click here for FAQ'
=> 'Click here for FAQ',
# Click heRe fou FAQ
   'Click here for help'
=> 'Click here for help',
# Click heRe fou Aide
   'Click here to report bugs'
=> 'Click here to report bugs',
# Click heRe Pour Repout bugs
   'Click here to return to the chart.'
=> 'Click here to return to the chart.',
# Click heRe Pour Return Pour the diagra.m..
   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)',
# Client IP/Nom Access Control (acc)
   'Clone an existing course'
=> 'Clone an existing course',
# Clone an existing cours
   'Close This Window'
=> 'Close This Window',
# fermez cette fentRe
   'Closed'
=> 'Closed',
# Fermerd
   'Communication'
=> 'Communication',
# Communicion
   'Compare versions of'
=> 'Compare versions of',
# CompaRe Versions de
   'Completed'
=> 'Completed',

   'Completely new course'
=> 'Completely new course',
# Completely new cours
   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.',
# Confirm th this infoumion is couRect, Ensuite click &quot;Finish Aideer&quot; Pour complete setting the parameter.
   'Construction Space Version'
=> 'Construction Space Version',
# ConstructuReion espace Version
   'Continue'
=> 'Continue',

   'Copy current file to'
=> 'Copy current file to',
# Copy Actuel Fichier Pour
   'Copy selected'
=> 'Copy selected',
# Copy Slectionezed
   'Course Code'
=> 'Course Code',
# cours Code
   'Course Content'
=> 'Course Content',
# cours Content
   'Course Data'
=> 'Course Data',
# cours Da
   'Course Home Server'
=> 'Course Home Server',
# cours Home Serveur
   'Course ID or number'
=> 'Course ID or number',
# cours ID ou number
   'Course ID/Number'
=> 'Course ID/Number',
# cours ID/Number
   'Course Information'
=> 'Course Information',
# cours infoumion
   'Course Initialization Helper'
=> 'Course Initialization Helper',
# cours Initializion Aideer
   'Course Level'
=> 'Course Level',
# cours Level
   'Course Search'
=> 'Course Search',
# cours cherchez
   'Course Title'
=> 'Course Title',
# cours titRe
   'Course default for all problems'
=> 'Course default for all problems',
# cours par Dfaut  fou Pourut problmes
   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.',
# cours members can provide feedback about the cours. You can choisir who will Receive the feedback, such as a diffeRent instructuReou ou a TA. Please entRer their LON-CAPA addRess below, in the foum utiliseur:Domaine, wheRe &quot;utiliseur&quot; and &quot;Domaine&quot; aRe both the LON-CAPA utiliseurNom and LON-CAPA Domaine, Nont an Adresse E-Mail.
   'Courses'
=> 'Courses',
# courss
   'Create New User'
=> 'Create New User',
# crer New utiliseur
   'Create User'
=> 'Create User',
# crer utiliseur
   'Creating a new'
=> 'Creating a new',
# CReing a new
   'Crosslisted courses'
=> 'Crosslisted courses',
# Crosslisted courss
   'Current Class List'
=> 'Current Class List',
# Actuel Class List
   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',
# Actuel Fin/Finiring De: [_1]
   'Current Ending Date: not set'
=> 'Current Ending Date: not set',
# Actuel Fin/Finiring De: Nont set
   'Current Resource'
=> 'Current Resource',
# Actuel Ressource
   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',
# Actuel Commenant De: [_1]
   'Current Starting Date: not set'
=> 'Current Starting Date: not set',
# Actuel Commenant De: Nont set
   'Current Version'
=> 'Current Version',
# Actuel Version
   'Currently no active roles or courses'
=> 'Currently no active roles or courses',
# Actuelly Non active rles ou courss
   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',
# Actuelly Non additional rles ou courss
   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',
# Actuelly SoumettReted: <tt>[_1]</tt>
   'Custom Role Editor'
=> 'Custom Role Editor',
# CusPourm rle diterou
   'Cut selected'
=> 'Cut selected',
# Cut Slectionezed
   'Decompress'
=> 'Decompress',

   'Default Assessment Spreadsheet'
=> 'Default Assessment Spreadsheet',
# par Dfaut  valuation SpReadsheet
   'Default Course Spreadsheet'
=> 'Default Course Spreadsheet',
# par Dfaut  cours SpReadsheet
   'Default Student Spreadsheet'
=> 'Default Student Spreadsheet',
# par Dfaut  Etudiant(e) SpReadsheet
   'Default XML Style File'
=> 'Default XML Style File',
# par Dfaut  XML Style Fichier
   'Default beginning date when enrolling students'
=> 'Default beginning date when enrolling students',
# par Dfaut  beginning de when inscriReing Etudiant(e)s
   'Default ending date when enrolling students'
=> 'Default ending date when enrolling students',
# par Dfaut  Fin/Finiring de when inscriReing Etudiant(e)s
   'Default for new courses is'
=> 'Default for new courses is',
# par Dfaut  fou new courss is
   'Default set of options to pass to tth/m when converting tex'
=> 'Default set of options to pass to tth/m when converting tex',
# par Dfaut  set de options Pour pass Pour tth/m when converting tex
   'Define Role'
=> 'Define Role',
# Define rle
   'Dependencies'
=> 'Dependencies',
# DepFin/Finirencies
   'Disable display of problem receipts'
=> 'Disable display of problem receipts',
# Disable Afficher de problme Receipts
   'Disable student resource discussion'
=> 'Disable student resource discussion',
# Disable Etudiant(e) Ressource discussion
   'Disable student use of chatrooms'
=> 'Disable student use of chatrooms',
# Disable Etudiant(e) use de caUtiliSameurierooms
   'Disallow Resource Discussion for Roles'
=> 'Disallow Resource Discussion for Roles',
# DisPouruPourw Ressource Discussion fou rles
   'Disallow Resource Discussion for Users'
=> 'Disallow Resource Discussion for Users',
# DisPouruPourw Ressource Discussion fou utiliseurs
   'Disallow live chatroom use for Roles'
=> 'Disallow live chatroom use for Roles',
# DisPouruPourw live caUtiliSameurieroom use fou rles
   'Disallow live chatroom use for Users'
=> 'Disallow live chatroom use for Users',
# DisPouruPourw live caUtiliSameurieroom use fou utiliseurs
   'Discussion Participation'
=> 'Discussion Participation',
# Discussion Partieieicipion
   'Display file attributes'
=> 'Display file attributes',
# Afficher Fichier tributes
   'Do NOT generate as standard course'
=> 'Do NOT generate as standard course',
# Do NonT genere as standard cours
   'Do not show plain URL (encrypturl)'
=> 'Do not show plain URL (encrypturl)',
# Do Nont show plain AdResse URL (encryptAdResse URL)
   'Domain Level'
=> 'Domain Level',
# Domaine Level
   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Due Date (contentclose)'
=> 'Due Date (contentclose)',
# est d  De (contentFermer)
   'Due Date (duedate)'
=> 'Due Date (duedate)',
# est d  De (est d de)
   'Duration of automated classlist updates'
=> 'Duration of automated classlist updates',
# Durion de auPourmed classlist vers le haut des
   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',
# Dynamic Metada (mis  jour priodiquement )
   'ERROR'
=> 'ERROR',
# ERRou
   'Edit Custom Role Privileges'
=> 'Edit Custom Role Privileges',
# diter CusPourm rle Privileges
   'End Time'
=> 'End Time',
# Fin/Finir Temps
   'Ending Date'
=> 'Ending Date',
# Fin/Finiring De
   'English - ISO'
=> 'English - ISO',

   'Enroll One Student'
=> 'Enroll One Student',
# inscriRe One Etudiant(e)
   'Enroll as student'
=> 'Enroll as student',
# inscriRe as Etudiant(e)
   'Enrolling'
=> 'Enrolling',
# inscriReing
   'Enrolling Student'
=> 'Enrolling Student',
# inscriReing Etudiant(e)
   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.',
# entRer as many Champss as you can. The Systme will infoum you and bring you back Pour this Page if the da Slectionezed is insufficient Pour inscriRe Etudiant(e)s in your class.
   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below',
# entRer terms ou phrases separed Par AND, ou, ou NonT Ensuite pRess cherchez below
   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Enter terms or phrases separated by search operators such as AND, OR, or NOT',
# entRer terms ou phrases separed Par cherchez operous such as AND, ou, ou NonT
   'Entering Construction Space'
=> 'Entering Construction Space',
# entRering ConstructuReion espace
   'Error: Directory Non Empty'
=> 'Error: Directory Non Empty',
# Errou: DiRecPouruy Nonn Vide
   'Error: destination for operation is an existing directory.'
=> 'Error: destination for operation is an existing directory.',
# Errou: destinion fou operion is an existing diRecPouruy.
   'Essay, open end'
=> 'Essay, open end',
# Essay, Ouvrir Fin/Finir
   'Evaluation Error '
=> 'Evaluation Error ',
# Evaluion Errou 
   'Every problem in a particular folder (overrides course default)'
=> 'Every problem in a particular folder (overrides course default)',
# Every problme in a Partieieicular Dossier (overrides cours par Dfaut )
   'Exam Problem'
=> 'Exam Problem',
# Exam problme
   'Excel format'
=> 'Excel format',
# Excel foum
   'Exit'
=> 'Exit',
# sortir
   'Feedback Addresses for Course Content'
=> 'Feedback Addresses for Course Content',
# Feedback AddResses fou cours Content
   'Feedback Addresses for Course Content Comments'
=> 'Feedback Addresses for Course Content Comments',
# Feedback AddResses fou cours Content Comments
   'Feedback Addresses for Course Policy'
=> 'Feedback Addresses for Course Policy',
# Feedback AddResses fou cours Policy
   'Feedback Addresses for Resource Content Question'
=> 'Feedback Addresses for Resource Content Question',
# Feedback AddResses fou Ressource Content Question
   'Finish Helper'
=> 'Finish Helper',
# Finish Aideer
   'First'
=> 'First',

   'First Resource'
=> 'First Resource',
# First Ressource
   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',
# Alternative Nom <b><tt>[_1]</tt></b> appears moue than once. Alternative Noms need Pour be unique.
   'Folder/Map'
=> 'Folder/Map',
# Dossier/Carte/Squence
   'For one or more students'
=> 'For one or more students',
# Fou one ou moue Etudiant(e)s
   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',
# Found a <*Response> outside de a <Partieie> in a <Partieie>ed problme
   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',
# Found Non analyzable Respones in this problme, Actuelly only Numerical, Foumula and String Response styles aRe svers le haut pouted.
   'Generate messages from a file'
=> 'Generate messages from a file',
# Genere messages De a Fichier
   'German - ISO'
=> 'German - ISO',

   'Go'
=> 'Go',

   'Go to ...'
=> 'Go to ...',
# Go Pour ...
   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML can be allowed or banned inside of course discussion.',
# HTML can be PouruPourMer ou banned inside de cours discussion.
   'HTML in Discussions'
=> 'HTML in Discussions',
# HTML in Discussons
   'Hand Graded (handgrade)'
=> 'Hand Graded (handgrade)',

   'Help on Creating Courses'
=> 'Help on Creating Courses',
# Aide on CReing courss
   'Hide Empty Rows in Spreadsheets'
=> 'Hide Empty Rows in Spreadsheets',
# Cacher Vide Lignes in SpReadsheets
   'Home Server'
=> 'Home Server',
# Home Serveur
   'Homework problem'
=> 'Homework problem',
# Homewouk problme
   'How do I create a CSV file from a spreadsheet'
=> 'How do I create a CSV file from a spreadsheet',
# How do I crer a CSV Fichier De a spReadsheet
   'How do I create a class list from a spreadsheet'
=> 'How do I create a class list from a spreadsheet',
# How do I crer a class list De a spReadsheet
   'How many tries should be set for all problems in the course?'
=> 'How many tries should be set for all problems in the course?',
# How many NonmbRe d essai should be set fou Pourut problmes in the cours?
   'How many tries should be set for the selected folder?'
=> 'How many tries should be set for the selected folder?',
# How many NonmbRe d essai should be set fou the Slectionezed Dossier?
   'How many tries should be set for the selected problem?'
=> 'How many tries should be set for the selected problem?',
# How many NonmbRe d essai should be set fou the Slectionezed problme?
   'How should the results be printed?'
=> 'How should the results be printed?',

   'Immediately expire own role as Course Coordinator'
=> 'Immediately expire own role as Course Coordinator',
# Immediely expiRe own rle as cours Cooudinou
   'Import and Paste Area'
=> 'Import and Paste Area',
# Impout and Paste ARea
   'Include retrieval of student photographs?'
=> 'Include retrieval of student photographs?',
# Include Retrieval de Etudiant(e) phoPourgraphs?
   'Institutional Information'
=> 'Institutional Information',
# Institutional infoumion
   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',

   'Invalid characters in requested name have been removed.'
=> 'Invalid characters in requested name have been removed.',
# Invalid characters in Requested Nom have been Removed.
   'Invalid login mode or password.'
=> 'Invalid login mode or password.',
# Invalid login mode ou passwoud.
   'Invalid username or domain'
=> 'Invalid username or domain',
# Invalid utiliseurNom ou Domaine
   'Japanese - UTF'
=> 'Japanese - UTF',

   'KEYWORDS'
=> 'KEYWORDS',
# KEYWouDS
   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.',
# LON-CAPA has live caUtiliSameurie functionality. This cours will Receive its own caUtiliSameurie room. You Mai deny Etudiant(e)s, TAs, ou instructuReous the right Pour access the caUtiliSameurie room.
   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.',
# LON-CAPA Htes Discussons on Pourut Ressources in a cours. Par par Dfaut , Pourut utiliseurs aRe PouruPourMer Pour Partieieicipe in these Discussons. If you do Nont wish certain Types de utiliseurs Pour be able Pour use the discussion feuRes, Slectionez those Types below. Nonte your class Mai Nont have Pourut de these rles; you Mai safely igNonue rles you do Nont intFin/Finir Pour use. (Fou instance, &quot;Exam ProcPouru&quot; is gnerPouruty useful only fou large courss.) Types de utiliseurs Nont PouruPourMer Pour Partieieicipe in discussion can still Visualiser any discussion th other utiliseurs post.
   'Languages used'
=> 'Languages used',
# langages used
   'Last'
=> 'Last',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',
# Leave blank on scouing foum
   'List Directory'
=> 'List Directory',
# List DiRecPouruy
   'List of hidden parts (hiddenparts)'
=> 'List of hidden parts (hiddenparts)',
# List de hidden Partieies (hiddenPartieies)
   'Location'
=> 'Location',
# Locion
   'Login Data'
=> 'Login Data',
# Login Da
   'Logout'
=> 'Logout',

   'Mail'
=> 'Mail',

   'Make new directory'
=> 'Make new directory',
# Make new diRecPouruy
   'Make new file'
=> 'Make new file',
# Make new Fichier
   'Manual Grading'
=> 'Manual Grading',
# Manual Assigner des notes
   'Map has branchings. Use advanced editor.'
=> 'Map has branchings. Use advanced editor.',
# Carte/Squence has branchings. Use advanced diterou.
   'Map has conditions. Use advanced editor.'
=> 'Map has conditions. Use advanced editor.',
# Carte/Squence has conditions. Use advanced diterou.
   'Map has resource parameters. Use advanced editor.'
=> 'Map has resource parameters. Use advanced editor.',
# Carte/Squence has Ressource parameters. Use advanced diterou.
   'Map has unconnected resources. Use advanced editor.'
=> 'Map has unconnected resources. Use advanced editor.',
# Carte/Squence has unconnected Ressources. Use advanced diterou.
   'Maximum Number of Collaborators'
=> 'Maximum Number of Collaborators',
# Maximum Number de Collabouous
   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximum Number of Collaborators (maxcollaborators)',
# Maximum Number de Collabouous (maxcollabouous)
   'Maximum Number of Tries (maxtries)'
=> 'Maximum Number of Tries (maxtries)',
# Maximum Number de NonmbRe d essai (maxNonmbRe d essai)
   'Messaging'
=> 'Messaging',

   'Middle'
=> 'Middle',

   'Middle Name'
=> 'Middle Name',
# Middle Nom
   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',
# Missing Kerberos Domaine infoumion.
   'Modification may make assessment data inaccessible'
=> 'Modification may make assessment data inaccessible',
# Modificion Mai make valuation da inaccessible
   'Modify Enrollment for'
=> 'Modify Enrollment for',
# Modify inscriRement fou
   'Modify User'
=> 'Modify User',
# Modify utiliseur
   'Modify another students data'
=> 'Modify another students data',
# Modify aNonther Etudiant(e)s da
   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',
# Modify Dates limites, etc, fou this Ressource
   'Modifying data for user'
=> 'Modifying data for user',
# Modifying da fou utiliseur
   'Modifying this will make problems'
=> 'Modifying this will make problems',
# Modifying this will make problmes
   'Move current file to'
=> 'Move current file to',
# Move Actuel Fichier Pour
   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',
# Must crer new subdiRecPouruy inside a diRecPouruy
   'Name of Role'
=> 'Name of Role',
# Nom de rle
   'Navigate'
=> 'Navigate',
# naviguer
   'New Directory'
=> 'New Directory',
# New DiRecPouruy
   'New HTML file'
=> 'New HTML file',
# New HTML Fichier
   'New Resource'
=> 'New Resource',
# New Ressource
   'New Role'
=> 'New Role',
# New rle
   'New User'
=> 'New User',
# New utiliseur
   'New Value'
=> 'New Value',
# New Valeur
   'New assembled page'
=> 'New assembled page',

   'New assembled sequence'
=> 'New assembled sequence',
# New assembled squence
   'New custom rights file'
=> 'New custom rights file',
# New cusPourm rights Fichier
   'New file'
=> 'New file',
# New Fichier
   'New problem'
=> 'New problem',
# New problme
   'New style file'
=> 'New style file',
# New style Fichier
   'New subdirectory'
=> 'New subdirectory',
# New subdiRecPouruy
   'Next ->'
=> 'Next ->',
# Prochain ->
   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',
# Non Access ou Usages Stistics aRe available fou this Ressource.
   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',
# Non valuation Stistical Da is available fou this Ressource
   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',
# Non Evaluion Da is available fou this Ressource.
   'No new filename specified.'
=> 'No new filename specified.',
# Non new FichierNom specified.
   'No section assigned'
=> 'No section assigned',
# Non Section assigned
   'No such file'
=> 'No such file',
# Non such Fichier
   'Not Allowed'
=> 'Not Allowed',
# Nont PouruPourMer
   'Not open to be viewed'
=> 'Not open to be viewed',
# Nont Ouvrir Pour be VisualiseRed
   'Notification of enrollment changes'
=> 'Notification of enrollment changes',
# Nontificion de inscriRement Changezs
   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',
# Nontificion Pour cours cooudinou via LON-CAPa.m.ssage when inscriRement Changezs occur during the auPourmed vers le haut de?
   'Number of Tries before hints appear (hinttries)'
=> 'Number of Tries before hints appear (hinttries)',
# Number de NonmbRe d essai befoue hints appear (hintNonmbRe d essai)
   'Number of assignments printed at the same time:'
=> 'Number of assignments printed at the same time:',
# Number de assignments printed  the same Temps:
   'Number of bubbles in exam mode (numbubbles)'
=> 'Number of bubbles in exam mode (numbubbles)',
# Number de bubbles in exam mode (numbubbles)
   'Number of columns'
=> 'Number of columns',
# Number de Colonne s
   'Numerical Tolerance (tol)'
=> 'Numerical Tolerance (tol)',
# Numerical Pourlerance (Pourl)
   'Old Value'
=> 'Old Value',
# Old Valeur
   'Online Help'
=> 'Online Help',
# Online Aide
   'Only domain coordinators can change a users password.'
=> 'Only domain coordinators can change a users password.',
# Only Domaine cooudinous can Changez a utiliseurs passwoud.
   'Open Course'
=> 'Open Course',
# Ouvrir cours
   'Open all assessments'
=> 'Open all assessments',
# Ouvrir Pourut valuations
   'Open and correct'
=> 'Open and correct',
# Ouvrir and couRect
   'Open with full tries'
=> 'Open with full tries',
# Ouvrir with full NonmbRe d essai
   'Opening Date (contentopen)'
=> 'Opening Date (contentopen)',
# Ouvriring De (contenPourpen)
   'Opening Date (opendate)'
=> 'Opening Date (opendate)',
# Ouvriring De (Ouvrirde)
   'Output Format: [_1]'
=> 'Output Format: [_1]',
# Sortie Foum: [_1]
   'Page layout'
=> 'Page layout',

   'Paper type'
=> 'Paper type',

   'Parameter'
=> 'Parameter',

   'Part Description (display)'
=> 'Part Description (display)',
# Partieie Description (Afficher)
   'Paste after selected'
=> 'Paste after selected',
# Paste after Slectionezed
   'Personal Data'
=> 'Personal Data',
# Personal Da
   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',
# Please choisir the par Dfaut  auEnsuiteticion method Pour be used Par new utiliseurs added Pour this LON-CAPA Domaine Par the auPourmed inscriRement process
   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',
# Please click Back on your bLigneser and Slectionner unNonther utiliseur, ou 
   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Please contact your LON-CAPA administrator regarding this situation.',
# Please Contacter your LON-CAPA a.m.nistrou Regarding this situion.
   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',
# Please Slectionner unn auEnsuiteticion mechanism
   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',
# Please Slectionez the auEnsuiteticion mechanism
   'Please select the section you wish to set the answer open date for:'
=> 'Please select the section you wish to set the answer open date for:',
# Please Slectionez the Section you wish Pour set the Rponse Ouvrir de fou:
   'Please select the section you wish to set the due date for:'
=> 'Please select the section you wish to set the due date for:',
# Please Slectionez the Section you wish Pour set the est d  de fou:
   'Please select the section you wish to set the number of tries for:'
=> 'Please select the section you wish to set the number of tries for:',
# Please Slectionez the Section you wish Pour set the number de NonmbRe d essai fou:
   'Please select the section you wish to set the opening date for:'
=> 'Please select the section you wish to set the opening date for:',
# Please Slectionez the Section you wish Pour set the Ouvriring de fou:
   'Please select the section you wish to set the problem weight for:'
=> 'Please select the section you wish to set the problem weight for:',
# Please Slectionez the Section you wish Pour set the problme weight fou:
   'Please select the student you wish to set the answer open date for:'
=> 'Please select the student you wish to set the answer open date for:',
# Please Slectionez the Etudiant(e) you wish Pour set the Rponse Ouvrir de fou:
   'Please select the student you wish to set the due date for:'
=> 'Please select the student you wish to set the due date for:',
# Please Slectionez the Etudiant(e) you wish Pour set the est d  de fou:
   'Please select the student you wish to set the number of tries for:'
=> 'Please select the student you wish to set the number of tries for:',
# Please Slectionez the Etudiant(e) you wish Pour set the number de NonmbRe d essai fou:
   'Please select the student you wish to set the opening date for:'
=> 'Please select the student you wish to set the opening date for:',
# Please Slectionez the Etudiant(e) you wish Pour set the Ouvriring de fou:
   'Please select the student you wish to set the problem weight for:'
=> 'Please select the student you wish to set the problem weight for:',
# Please Slectionez the Etudiant(e) you wish Pour set the problme weight fou:
   'Please stand by.'
=> 'Please stand by.',
# Please stand Par.
   'Please use browser "Back" button and pick a filename'
=> 'Please use browser "Back" button and pick a filename',
# Please use bLigneser "Back" butPourn and pick a FichierNom
   'Portuguese - ISO'
=> 'Portuguese - ISO',
# Poutuguese - ISO
   'Print'
=> 'Print',

   'Privileged users that should not be hidden on staff listings'
=> 'Privileged users that should not be hidden on staff listings',
# Privileged utiliseurs th should Nont be hidden on staff listings
   'Processed file'
=> 'Processed file',
# Processed Fichier
   'Publish this Resource'
=> 'Publish this Resource',
# Publier this Ressource
   'Question Type (type)'
=> 'Question Type (type)',
# Type de Question (Type)
   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',
# Random seed fou randomly picking number de Ressources (optional, only set if you kNonw wh you aRe doing) (randompickseed)
   'Randomization algorithm used'
=> 'Randomization algorithm used',
# Randomizion algouithm used
   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',
# Randomly pick number de Ressources (randompick)
   'Reading results from [_1]'
=> 'Reading results from [_1]',
# Lisant rsultats  Partieir de  [_1]
   'Receipt algorithm used'
=> 'Receipt algorithm used',
# Receipt algouithm used
   'Receiving results from [_1]'
=> 'Receiving results from [_1]',
# Receiving Results De [_1]
   'Recent'
=> 'Recent',

   'Rename current file to'
=> 'Rename current file to',
# ReNonmmer Actuel Fichier Pour
   'Report a Bug'
=> 'Report a Bug',
# Repout a Bug
   'Resource'
=> 'Resource',
# Ressource
   'Resource Differences'
=> 'Resource Differences',
# Ressource Differences
   'Resource Hidden from Students (hiddenresource)'
=> 'Resource Hidden from Students (hiddenresource)',
# Ressource Hidden De Etudiant(e)s (hiddenRessource)
   'Resource alias name for conditions (mapalias)'
=> 'Resource alias name for conditions (mapalias)',
# Ressource alias Nom fou conditions (Carte/Squencealias)
   'Resources'
=> 'Resources',
# Ressources
   'Response'
=> 'Response',

   'Retrieve Old Version'
=> 'Retrieve Old Version',
# RestauRer Old Version
   'Return to DOCS'
=> 'Return to DOCS',
# Return Pour documents
   'Reverse Association'
=> 'Reverse Association',
# Reverse Associion
   'Revoke'
=> 'Revoke',

   'Revoke Existing Roles'
=> 'Revoke Existing Roles',
# Revoke Existing rles
   'Role'
=> 'Role',
# rle
   'Role Information'
=> 'Role Information',
# rle infoumion
   'Russian - KOI'
=> 'Russian - KOI',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',
# EnRegistRer enNonmbRe d essai below as a draft Rponse (Nont SoumettReting them fou crditer yet)
   'Search Complete [_1]'
=> 'Search Complete [_1]',
# cherchez Complete [_1]
   'Search: [_1]'
=> 'Search: [_1]',
# cherchez: [_1]
   'Select Action'
=> 'Select Action',
# Slectionner unction
   'Select All Files'
=> 'Select All Files',
# Slectionez Pourut Fichiers
   'Select All Published'
=> 'Select All Published',
# Slectionez Pourut Publi(e)
   'Select All Resources'
=> 'Select All Resources',
# Slectionez Pourut Ressources
   'Select Folder'
=> 'Select Folder',
# Slectionez Dossier
   'Select Only Current Students'
=> 'Select Only Current Students',
# Slectionez Only Actuel Etudiant(e)s
   'Select Problem'
=> 'Select Problem',
# Slectionez problme
   'Select Problem(s) to print'
=> 'Select Problem(s) to print',
# Slectionez problme(s) Pour print
   'Select Resource(s) to print'
=> 'Select Resource(s) to print',
# Slectionez Ressource(s) Pour print
   'Select Resources To Print'
=> 'Select Resources To Print',
# Slectionez Ressources Pour Print
   'Select Section'
=> 'Select Section',
# Slectionez Section
   'Select Sequence To Print From'
=> 'Select Sequence To Print From',
# Slectionez squence Pour Print De
   'Select Student'
=> 'Select Student',
# Slectionez Etudiant(e)
   'Select Students and Resources'
=> 'Select Students and Resources',
# Slectionez Etudiant(e)s and Ressources
   'Select Style File'
=> 'Select Style File',
# Slectionez Style Fichier
   'Select a user name to modify the students information'
=> 'Select a user name to modify the students information',
# Slectionner un utiliseur Nom Pour modify the Etudiant(e)s infoumion
   'Select a user name to view the users personal page.'
=> 'Select a user name to view the users personal page.',
# Slectionner un utiliseur Nom Pour Visualiser the utiliseurs personal Page.
   'Select for Section/Group'
=> 'Select for Section/Group',
# Slectionez fou Section/Grovers le haut 
   'Select resources for the assignment'
=> 'Select resources for the assignment',
# Slectionez Ressources fou the assignment
   'Select the folder you wish to set the parameter for:'
=> 'Select the folder you wish to set the parameter for:',
# Slectionez the Dossier you wish Pour set the parameter fou:
   'Select the problem you wish to set the parameter for:'
=> 'Select the problem you wish to set the parameter for:',
# Slectionez the problme you wish Pour set the parameter fou:
   'Set'
=> 'Set',

   'Set Course Environment'
=> 'Set Course Environment',
# Set cours Environment
   'Set End Date'
=> 'Set End Date',
# Set Fin/Finir De
   'Set Individual User Roles'
=> 'Set Individual User Roles',
# Set Individual utiliseur rles
   'Set Problem Tries'
=> 'Set Problem Tries',
# Set problme NonmbRe d essai
   'Set Problem Weight'
=> 'Set Problem Weight',
# Set problme Weight
   'Set Start Date'
=> 'Set Start Date',
# Set Dbut/Commencez De
   'Set answer open date for all problems in the course for ...'
=> 'Set answer open date for all problems in the course for ...',
# Set Rponse Ouvrir de fou Pourut problmes in the cours fou ...
   'Set answer open date for the selected folder for ...'
=> 'Set answer open date for the selected folder for ...',
# Set Rponse Ouvrir de fou the Slectionezed Dossier fou ...
   'Set answer open date for the selected problem for ...'
=> 'Set answer open date for the selected problem for ...',
# Set Rponse Ouvrir de fou the Slectionezed problme fou ...
   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',
# Set content feedback Pour cours Cooudinou
   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',
# Set cours policy feedback Pour cours Cooudinou
   'Set due date for all problems in the course for ...'
=> 'Set due date for all problems in the course for ...',
# Set est d  de fou Pourut problmes in the cours fou ...
   'Set due date for the selected folder for ...'
=> 'Set due date for the selected folder for ...',
# Set est d  de fou the Slectionezed Dossier fou ...
   'Set due date for the selected problem for ...'
=> 'Set due date for the selected problem for ...',
# Set est d  de fou the Slectionezed problme fou ...
   'Set number of tries for all problems in the course for ...'
=> 'Set number of tries for all problems in the course for ...',
# Set number de NonmbRe d essai fou Pourut problmes in the cours fou ...
   'Set number of tries for the selected folder for ...'
=> 'Set number of tries for the selected folder for ...',
# Set number de NonmbRe d essai fou the Slectionezed Dossier fou ...
   'Set number of tries for the selected problem for ...'
=> 'Set number of tries for the selected problem for ...',
# Set number de NonmbRe d essai fou the Slectionezed problme fou ...
   'Set opening date for all problems in the course for ...'
=> 'Set opening date for all problems in the course for ...',
# Set Ouvriring de fou Pourut problmes in the cours fou ...
   'Set opening date for the selected folder for ...'
=> 'Set opening date for the selected folder for ...',
# Set Ouvriring de fou the Slectionezed Dossier fou ...
   'Set opening date for the selected problem for ...'
=> 'Set opening date for the selected problem for ...',
# Set Ouvriring de fou the Slectionezed problme fou ...
   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . .',
# Set Ouvriring defou Pourut problmes in the cours fou. . .
   'Set problem weight for all problems in the course for ...'
=> 'Set problem weight for all problems in the course for ...',
# Set problme weight fou Pourut problmes in the cours fou ...
   'Set problem weight for the selected folder for ...'
=> 'Set problem weight for the selected folder for ...',
# Set problme weight fou the Slectionezed Dossier fou ...
   'Set problem weight for the selected problem for ...'
=> 'Set problem weight for the selected problem for ...',
# Set problme weight fou the Slectionezed problme fou ...
   'Set to ...'
=> 'Set to ...',
# Set Pour ...
   'Set value to "[_1]" to allow'
=> 'Set value to "[_1]" to allow',
# Set Valeur Pour "[_1]" Pour PouruPourw
   'Setting the [_1]'
=> 'Setting the [_1]',

   'Setting the [_1] to [_2]'
=> 'Setting the [_1] to [_2]',
# Setting the [_1] Pour [_2]
   'Show Answer'
=> 'Show Answer',
# Show Rponse
   'Show Feedback'
=> 'Show Feedback',

   'Show Problem Status (problemstatus)'
=> 'Show Problem Status (problemstatus)',
# Show problme Stus (problmestus)
   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',
# Show Units - Disable Entry (turndefunit)
   'Show all roles'
=> 'Show all roles',
# Show Pourut rles
   'Significant Digits (sig)'
=> 'Significant Digits (sig)',

   'Simple Edit'
=> 'Simple Edit',
# Simple diter
   'Some items were not submitted'
=> 'Some items were not submitted',
# Some items weRe Nont SoumettReted
   'Start Time'
=> 'Start Time',
# Dbut/Commencez Temps
   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Start each student's assignment on a new page/column (add a pagefeed after each assignment)",
# Dbut/Commencez each Etudiant(e)'s assignment on a new Page/Colonne  (add a Pagefeed after each assignment)
   'Starting Date'
=> 'Starting Date',
# Commenant De
   'Student ID'
=> 'Student ID',
# Etudiant(e) ID
   'Student Information'
=> 'Student Information',
# Etudiant(e) infoumion
   'Student Name'
=> 'Student Name',
# Etudiant(e) Nom
   'Student Status'
=> 'Student Status',
# Etudiant(e) Stus
   'Student Status: [_1]'
=> 'Student Status: [_1]',
# Etudiant(e) Stus: [_1]
   'Student information updated successfully.'
=> 'Student information updated successfully.',
# Etudiant(e) infoumion vers le haut ded successfully.
   'Students need access key to enter course'
=> 'Students need access key to enter course',
# Etudiant(e)s need access key Pour entRer cours
   'Students with expired roles'
=> 'Students with expired roles',
# Etudiant(e)s with expiRed rles
   'Subject:'
=> 'Subject:',
# sujet:
   'Submissions'
=> 'Submissions',
# Submissons
   'Submit Modifications'
=> 'Submit Modifications',
# SoumettRe Modificions
   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',
# SoumettRe enNonmbRe d essai below as Rponse Pour Receive crditer
   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',
# SMerish Chef
   'System Level'
=> 'System Level',
# Systme Level
   'Target Edit Map'
=> 'Target Edit Map',
# Cible diter Carte/Squence
   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',
# TeX unconverted est d  Pour errous
   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',
# TeX unconverted est d  Pour Prcdent errous
   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.',
# The &quot;cours Description&quot; is the Nom de the cours th will be seen Par the Etudiant(e)s. You Mai Nonw modify the description and hit &quot;Prochain -&gt;&quot; Pour continue.
   'The error reported was'
=> 'The error reported was',
# The errou Repouted was
   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',
# The following enNonmbRe d essai will be used Pour identify the cours accouding Pour the naming scheme adopted Par your institution. Your choices will be used Pour Carte/Squence an internal LON-CAPA cours ID Pour the couResponding cours Section ID(s) used Par the defice Responsible fou providing deficial class lists fou courss  your institution. This Carte/Squenceping is RequiRed if you choisir Pour employ auPourmic populion de class lists.
   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",
# The following settings control auPourmic inscriRement de Etudiant(e)s in this class based on infoumion available fou this specific cours De your institution's deficial classlists.
   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',
# The question can Nont be gotten couRect, the following Alternatives in the &lt;optionResponse&gt; have invalid couRect options
   'The requested file'
=> 'The requested file',
# The Requested Fichier
   'The student must log out and log in again to see these changes.'
=> 'The student must log out and log in again to see these changes.',
# The Etudiant(e) must log out and Se connecter de Nonuveau Pour see these Changezs.
   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',
# TheRe aRe Actuelly Non Errou Messages fou this Ressource.
   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',
# TheRe aRe Non Evaluion Comments on this Ressource.
   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',
# TheRe aRe Non Actuelly inscriReed Etudiant(e)s in the cours.
   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',
# TheRe aRe Non Actuelly inscriReed Etudiant(e)s in the Slectionezed Sections.
   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',
# TheRe aRe Non Prcdently inscriReed Etudiant(e)s in the cours.
   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',
# TheRe aRe Non Prcdently inscriReed Etudiant(e)s in the Slectionezed Sections.
   'There are no students in the course.'
=> 'There are no students in the course.',
# TheRe aRe Non Etudiant(e)s in the cours.
   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',
# TheRe aRe Non Etudiant(e)s in the Slectionezed Sections.
   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',
# TheRe was an errou determining the environment Valeurs fou
   'This controls how receipt numbers are generated.'
=> 'This controls how receipt numbers are generated.',
# This controls how Receipt numbers aRe genered.
   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'This helper will set up your LON-CAPA course and choose which features will be active.',
# This Aideer will set vers le haut  your LON-CAPA cours and choisir which feuRes will be active.
   'To create a new'
=> 'To create a new',
# Pour crer a new
   'Top Level Map'
=> 'Top Level Map',
# Pourp Level Carte/Squence
   'Turkish - ISO'
=> 'Turkish - ISO',

   'Type Name Here'
=> 'Type Name Here',
# Type Nom HeRe
   'Type-in value'
=> 'Type-in value',
# Type-in Valeur
   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',
# UNAfficherABLE
   'Unable to enroll'
=> 'Unable to enroll',
# Unable Pour inscriRe
   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are',
# Unable Pour Publier Fichier, it contains dvers le haut liced ID(s), ID(s) need Pour be unique. The dvers le haut liced ID(s) aRe
   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',
# Unable Pour RestauRer environment da fou
   'Unable to set default dates for course'
=> 'Unable to set default dates for course',
# Unable Pour set par Dfaut  des fou cours
   'Unavailable course'
=> 'Unavailable course',
# Unavailable cours
   'Unknown Action'
=> 'Unknown Action',
# UnkNonwn Action
   'Unselect All Files'
=> 'Unselect All Files',
# UnSlectionez Pourut Fichiers
   'Unselect All Published'
=> 'Unselect All Published',
# UnSlectionez Pourut Publi(e)
   'Unselect All Resources'
=> 'Unselect All Resources',
# UnSlectionez Pourut Ressources
   'Unselect for Section/Group'
=> 'Unselect for Section/Group',
# UnSlectionez fou Section/Grovers le haut 
   'Upload class list'
=> 'Upload class list',
# vers le haut Charge du Serveur class list
   'Upload file'
=> 'Upload file',
# vers le haut Charge du Serveur Fichier
   'VIEW'
=> 'VIEW',
# Visualiser
   'View the FAQ'
=> 'View the FAQ',
# Visualiser the FAQ
   'Visibly Separate Items on Pages'
=> 'Visibly Separate Items on Pages',
# Visibly Separe Items on Pages
   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'WARNING: The metadata table does not exist in the LON-CAPA database.',
# WARNING: The metada table does Nont exist in the LON-CAPA dabase.
   'Warning: change of MIME type!'
=> 'Warning: change of MIME type!',
# Warning: Changez de Type Mime!
   'Warning: target file exists!'
=> 'Warning: target file exists!',
# Warning: Cible Fichier exists!
   'Warning: target file exists, and has been published!'
=> 'Warning: target file exists, and has been published!',
# Warning: Cible Fichier exists, and has been Publi(e)!
   'Weight (weight)'
=> 'Weight (weight)',

   'Welcome to Your New LON-CAPA Course'
=> 'Welcome to Your New LON-CAPA Course',
# Bienvenue Pour Your New LON-CAPA cours
   'What parameter do you want to set for the selected folder?'
=> 'What parameter do you want to set for the selected folder?',
# Wh parameter do you want Pour set fou the Slectionezed Dossier?
   'What parameter do you want to set for the selected problem?'
=> 'What parameter do you want to set for the selected problem?',
# Wh parameter do you want Pour set fou the Slectionezed problme?
   'What should the answer open date be set to?'
=> 'What should the answer open date be set to?',
# Wh should the Rponse Ouvrir de be set Pour?
   'What should the due date be set to?'
=> 'What should the due date be set to?',
# Wh should the est d  de be set Pour?
   'What weight should be set for all problems in the course?'
=> 'What weight should be set for all problems in the course?',
# Wh weight should be set fou Pourut problmes in the cours?
   'What weight should be set for the selected folder?'
=> 'What weight should be set for the selected folder?',
# Wh weight should be set fou the Slectionezed Dossier?
   'What weight should be set for the selected problem?'
=> 'What weight should be set for the selected problem?',
# Wh weight should be set fou the Slectionezed problme?
   'Width'
=> 'Width',

   'You are working with an unsaved version of your map.'
=> 'You are working with an unsaved version of your map.',
# You aRe wouking with an unEnRegistRerd Version de your Carte/Squence.
   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',
# You Changezd the Etudiant(e)s id but did Nont disable the ID Changez safeguard. The Etudiant(e)s id will Nont be Changezd.
   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.',
# Your cours is Nonw set vers le haut . Please Slectionez the Finish cours Initializion butPourn Pour Re-intialize the cours with your chosen settings. Remember th Pourut de these settings can be Modifi(e) in the paramtRes scReen, Par pushing the cours Environment butPourn.
   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',
# Your Request Pour Changez the rle infoumion fou this Etudiant(e) was Refused. You do Nont appear Pour have sufficient authouity Pour Changez Etudiant(e) infoumion.
   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',
# [_1] (wh you just saw on the scReen)
   '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])'
=> '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])',
# [_1] FichierSystme AuEnsuiteticed (mit Anfangspasswout [_2])
   '[_1] Internally authenticated (mit Anfangspasswort [_2])'
=> '[_1] Internally authenticated (mit Anfangspasswort [_2])',
# [_1] InternPouruty auEnsuiteticed (mit Anfangspasswout [_2])
   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',
# [_1] Local AuEnsuiteticion with argument [_2]
   '[_1] Records per Page'
=> '[_1] Records per Page',
# [_1] Recouds Par Page
   '[_1] minutes'
=> '[_1] minutes',

   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',
# [_1] minutes, [_2] secondees
   '[_1] with value [_2]'
=> '[_1] with value [_2]',
# [_1] with Valeur [_2]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# [_1]pRev[_2] &nbsp; [_3]ReCharge du Serveur[_4] &nbsp; [_5]Prochain[_6]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',
# [_1]pRev[_2] &nbsp; [_3]ReCharge du Serveur[_4] &nbsp; Prochain
   '[_2] seconds'
=> '[_2] seconds',
# [_2] secondees
   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',
# a comma separed list de cours Sections crosslisted with the Actuel cours, with each entry including the institutional cours Section Nom folloMer Par a colon and Ensuite the (optional) grovers le haut ID Pour be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2
   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',
# a comma separed list de institutional Section numbers, each separed Par a colon De the (optional) couResponding Section/grovers le haut  ID Pour be used in LON-CAPA e.g., 001:1,002:2
   'aboutlon.gif'
=> 'aboutlon.gif',

   'accessbutton.gif'
=> 'accessbutton.gif',
# accessbutPourn.gif
   'after selected'
=> 'after selected',
# after Slectionezed
   'all resources in the course'
=> 'all resources in the course',
# Pourut Ressources in the cours
   'all students in course'
=> 'all students in course',
# Pourut Etudiant(e)s dans le Cours
   'and'
=> 'and',

   'anno-'
=> 'anno-',
# anNon-
   'anno.gif'
=> 'anno.gif',
# anNon.gif
   'anonymous students'
=> 'anonymous students',
# aNonnyme Etudiant(e)s
   'anot.gif'
=> 'anot.gif',
# aNont.gif
   'answer date'
=> 'answer date',
# Rponse de
   'backward'
=> 'backward',

   'bchat.gif'
=> 'bchat.gif',
# bcaUtiliSameurie.gif
   'between'
=> 'between',

   'bookmark'
=> 'bookmark',

   'button'
=> 'button',
# butPourn
   'by'
=> 'by',
# Par
   'catalog'
=> 'catalog',
# calog
   'catalog.gif'
=> 'catalog.gif',
# calog.gif
   'ccrs.gif'
=> 'ccrs.gif',

   'changes will not show until next login'
=> 'changes will not show until next login',
# Changezs will Nont show until Prochain login
   'check all'
=> 'check all',
# check Pourut
   'chmod error'
=> 'chmod error',
# chmod errou
   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'click on the',

   'co con-'
=> 'co con-',
# co construction-
   'co res'
=> 'co res',

   'com.gif'
=> 'com.gif',

   'contacting [_1]'
=> 'contacting [_1]',
# entrant en Contacter [_1]
   'copy Error'
=> 'copy Error',
# copy Errou
   'courses.gif'
=> 'courses.gif',
# courss.gif
   'cprv.gif'
=> 'cprv.gif',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'currently does not exist',
# Actuelly does Nont exist
   'custom'
=> 'custom',
# cusPourm
   'customdistributionfile'
=> 'customdistributionfile',
# cusPourmdistributionFichier
   'discuss'
=> 'discuss',

   'docs.gif'
=> 'docs.gif',
# documents.gif
   'domain'
=> 'domain',
# Domaine
   'due date'
=> 'due date',
# est d  de
   'edit crs'
=> 'edit crs',
# diter crs
   'egrd.gif'
=> 'egrd.gif',

   'enrl.gif'
=> 'enrl.gif',

   'eval.gif'
=> 'eval.gif',

   'evaluate'
=> 'evaluate',
# evalue
   'expired or revoked'
=> 'expired or revoked',
# expiRed ou Revoked
   'extension'
=> 'extension',

   'external'
=> 'external',

   'fdbk.gif'
=> 'fdbk.gif',

   'feedback'
=> 'feedback',

   'first name'
=> 'first name',
# first Nom
   'for'
=> 'for',
# fou
   'for <b>all resources in the course</b>'
=> 'for <b>all resources in the course</b>',
# fou <b>Pourut Ressources in the cours</b>
   'for <b>all students in course</b>'
=> 'for <b>all students in course</b>',
# fou <b>Pourut Etudiant(e)s dans le Cours</b>
   'for [_1]'
=> 'for [_1]',
# fou [_1]
   'for section [_1]'
=> 'for section [_1]',
# fou Section [_1]
   'for the map named [_1]'
=> 'for the map named [_1]',
# fou the Carte/Squence Nomd [_1]
   'for the resource named [_1]'
=> 'for the resource named [_1]',
# fou the Ressource Nomd [_1]
   'for visible separation'
=> 'for visible separation',
# fou visible separion
   'forward'
=> 'forward',
# fouward
   'from'
=> 'from',
# De
   'from current subdirectory'
=> 'from current subdirectory',
# De Actuel subdiRecPouruy
   'generation'
=> 'generation',
# generion
   'grds.gif'
=> 'grds.gif',

   'have different numbers and answers'
=> 'have different numbers and answers',
# have diffeRent numbers and Rponses
   'helper'
=> 'helper',
# Aideer
   'in'
=> 'in',

   'in domain'
=> 'in domain',
# in Domaine
   'instructor'
=> 'instructor',
# instructuReou
   'internal'
=> 'internal',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',
# is in this ste Par royal decRee.
   'is ready for download'
=> 'is ready for download',
# is Ready fou downCharge du Serveur
   'keys.gif'
=> 'keys.gif',

   'last name'
=> 'last name',
# last Nom
   'logout.gif'
=> 'logout.gif',

   'make these dates the default for future enrollment'
=> 'make these dates the default for future enrollment',
# make these des the par Dfaut  fou futuRe inscriRement
   'middle name'
=> 'middle name',
# middle Nom
   'name'
=> 'name',
# Nom
   'nav.gif'
=> 'nav.gif',

   'no ending date'
=> 'no ending date',
# Non Fin/Finiring de
   'number'
=> 'number',

   'number of tries'
=> 'number of tries',
# number de NonmbRe d essai
   'obsoletereplacement'
=> 'obsoletereplacement',
# dsuetReplacement
   'only check if you know what you are doing'
=> 'only check if you know what you are doing',
# only check if you kNonw wh you aRe doing
   'only search domain'
=> 'only search domain',
# only cherchez Domaine
   'opening date'
=> 'opening date',
# Ouvriring de
   'optional'
=> 'optional',

   'or any other value'
=> 'or any other value',
# ou any other Valeur
   'parm.gif'
=> 'parm.gif',
# pa.m.gif
   'pref.gif'
=> 'pref.gif',

   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# pRev &nbsp; [_3]ReCharge du Serveur[_4] &nbsp; [_5]Prochain[_6]
   'private'
=> 'private',
# prive
   'problem weight'
=> 'problem weight',
# problme weight
   'prt.gif'
=> 'prt.gif',

   'public'
=> 'public',

   'res.gif'
=> 'res.gif',

   'role,role,...'
=> 'role,role,...',
# rle,rle,...
   'roles.gif'
=> 'roles.gif',
# rles.gif
   'sbkm.gif'
=> 'sbkm.gif',

   'section'
=> 'section',

   'selected students'
=> 'selected students',
# Slectionezed Etudiant(e)s
   'set'
=> 'set',

   'spacer.gif'
=> 'spacer.gif',
# espacer.gif
   'spellcheck_lang'
=> 'spellcheck_lang',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'standard'
=> 'standard',

   'standard courses only'
=> 'standard courses only',
# standard courss only
   'stat.gif'
=> 'stat.gif',
# st.gif
   'student'
=> 'student',
# Etudiant(e)
   'student name'
=> 'student name',
# Etudiant(e) Nom
   'tations'
=> 'tations',
# tions
   'template'
=> 'template',
# temple
   'this'
=> 'this',

   'to'
=> 'to',
# Pour
   'to [_1] ([_2])'
=> 'to [_1] ([_2])',
# Pour [_1] ([_2])
   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',
# Pour interface with institutional da, e.g., fs03glg231 fou FPourut 2003 Geology 231
   'unable to enroll'
=> 'unable to enroll',
# unable Pour inscriRe
   'uncheck all'
=> 'uncheck all',
# uncheck Pourut
   'use related words'
=> 'use related words',
# use Reled wouds
   'userauthentication.gif'
=> 'userauthentication.gif',
# utiliseurauEnsuiteticion.gif
   'username'
=> 'username',
# utiliseurNom
   'vbkm.gif'
=> 'vbkm.gif',

   'versus'
=> 'versus',

   'waiting on [_1]'
=> 'waiting on [_1]',
# tFin/Finirant [_1]
   'what you just saw on the screen'
=> 'what you just saw on the screen',
# wh you just saw on the scReen
   'with server'
=> 'with server',
# with Serveur
   'yes'
=> 'yes',
# Oui


#SYNC Tue Aug 15 14:43:21 2006
   '# 16 Aug 14:45'
=> '# 16 Aug 14:45',
# # [_1]6 Aug [_1]4:45
   'Enter my portfolio space'
=> 'Enter my portfolio space',
# entRer Lun/ma.m.s poutfolio espace
   'No syllabus information provided.'
=> 'No syllabus information provided.',
# Non Programmes d tudes infoumion provided.
   'Post Discussion'
=> 'Post Discussion',

   'Sorry ...'
=> 'Sorry ...',
# Soury ...
   'This resource might be part of another course.'
=> 'This resource might be part of another course.',
# this Ressource might be Partieie de aNonther cours.


#SYNC Tue Aug 15 16:12:11 2006
   '# mt fehlt'
=> '# mt fehlt',

   'Agree'
=> 'Agree',

   'Any comments? '
=> 'Any comments? ',

   'Copy this column'
=> 'Copy this column',
# Copy this Colonne 
   'Disagree'
=> 'Disagree',

   'General Intro'
=> 'General Intro',
# gneral intro
   'Greek Symbols'
=> 'Greek Symbols',

   'HTML character enties'
=> 'HTML character enties',

   'Highest Grade Level'
=> 'Highest Grade Level',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',
# If you aRe Visualisering this online, copy and paste the Texte De any de the right Colonne s inPour your Texte aRea Pour get the symbol on the left.
   'LON-CAPA Help'
=> 'LON-CAPA Help',
# LON-CAPA Aide
   'Landscape'
=> 'Landscape',

   'Launch navigation window'
=> 'Launch navigation window',
# Launch navigion window
   'Lowest Grade Level'
=> 'Lowest Grade Level',

   'Mark all posts read'
=> 'Mark all posts read',
# Mark Pourut posts Read
   'My question/comment/feedback:'
=> 'My question/comment/feedback:',
# Lun/ma.m.s question/comment/feedback:
   'Not set -'
=> 'Not set -',
# Nont Set -
   'Other Symbols'
=> 'Other Symbols',

   'Please check at least one of the following feedback types:'
=> 'Please check at least one of the following feedback types:',
# Please check  least one de the following feedback Types:
   'Please rank the following criteria:'
=> 'Please rank the following criteria:',

   'Portrait'
=> 'Portrait',
# Poutrait
   'Question about resource content'
=> 'Question about resource content',
# Question about Ressource content
   'Question/Comment/Feedback about course policy'
=> 'Question/Comment/Feedback about course policy',
# Question/Comment/feedback about cours policy
   'Select a Course to Enter'
=> 'Select a Course to Enter',
# Slectionner un cours Pour entRer
   'Sending Messages'
=> 'Sending Messages',
# SFin/Finiring Messages
   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',
# Show Me Lun/ma.m.s First Homewouk problme
   'Standards'
=> 'Standards',

   'Strongly Agree'
=> 'Strongly Agree',

   'Strongly Disagree'
=> 'Strongly Disagree',

   'Symbol'
=> 'Symbol',

   'The material appears to be correct '
=> 'The material appears to be correct ',
# The merial appears Pour be couRect 
   'The material is helpful '
=> 'The material is helpful ',
# The merial is Aideful 
   'The material is presented in a clear way '
=> 'The material is presented in a clear way ',
# The merial is pResented in a clear way 
   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) ',
# The Ressource is technicPouruty couRect (Charge du Serveurs fast eNonugh, does Nont produce errous, links wouk, etc) 


#SYNC Tue Aug 15 18:55:42 2006


#SYNC Fri Aug 18 20:46:55 2006
   'HTML character entities'
=> 'HTML character entities',


#SYNCMARKER
);

1;
