# The LON-CAPA dummy student photo fetch mechnism
#
# $Id: localstudentphoto.pm,v 1.4 2006/02/10 02:38:59 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# 8/24 Guy Albertelli


package localstudentphoto;
use lib '/home/httpd/lib/perl/';
use LONCAPA::Configuration;

sub fetch {
    my ($domain,$user,$pid,$response)=@_;
    my $temptxt = '';
    unless (ref($response)) {
        $response = \$temptxt;
    }
    if ($udom eq '' || $uname eq '') {
        $$response = 'nouser';
        return '';
    }
    return &main::propath($domain,$user).
	'/userfiles/internal/studentphoto.jpg';
}

sub fetch_thumbnail {
    my ($udom,$uname) = @_;
    if ($udom eq '' || $uname eq '') {
        return '';
    }
    my $userdir=&main::propath($udom,$uname);
    my $filepath = '/userfiles/internal/studentphoto.jpg';
    my $thumbnail = '/userfiles/internal/studentphoto_tn.gif';
    my $source =  "$userdir/$filepath";
    my $dest = "$userdir/$thumbnail";
    if (-e $dest) {
        return $dest;
    } else {
        if (!-e $source) {
            my $file = &fetch($udom,$uname);
        }
        if (-e $source) {
            my ($fullsize,$thumbsize)=&localstudentphoto::thumbsettings($udom);
            if ($fullsize && $thumbsize) {
                system("convert -size $fullsize $source -thumbnail $thumbsize $dest");
            }
            if (-e $dest) {
                return $dest;
            }
        }
    }
    return '';
}   

sub thumbsettings {
    my ($dom) = @_;
    my $fullsize = '240x240';
    my $thumbsize = '40x40';
    return ($fullsize,$thumbsize);
}

###############################
# sub AUTOLOAD
#
# Incoming data: none
# Returns ''
#
# Prevents errors when undefined subroutines are called in this package
# Will allow new routines added in the future to be called from lond etc.
# without the need for customized versions of local*.pm packages to be
# modified to include the new subroutines immediately.
#
# See "Programming Perl" 3rd ed. pp 296-298.
###############################
                                                                                
sub AUTOLOAD {
    our $AUTOLOAD;
    return '';
}

1;
__END__
