#!/usr/bin/perl

=pod

=head1 NAME

test_weblayer.pl - Test the LON-CAPA web layer by coordinating simulated web transactions

=cut

# The LearningOnline Network
# test_weblayer.pl - Test the web layer
#
# $Id: test_weblayer.pl,v 1.4 2003/02/03 18:03:52 harris41 Exp $
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# YEAR=2002
#
###

=pod

=head1 SYNOPSIS

B<perl test_weblayer.pl>

=head1 DESCRIPTION

This program reads in the machine's host id and domain for LON-CAPA.
A password is randomly generated and a test user with a name beginning
with 'ZXQTEST' is created.  A test login is run.

=cut

# ------------------------------------------------ determine host id and domain
my %perlvar;
open (CONFIG,"/etc/httpd/conf/access.conf") || die "Can't read access.conf";
while ($configline=<CONFIG>) {
    if ($configline =~ /^[^\#]*PerlSetVar/) {
	my ($dummy,$varname,$varvalue)=split(/\s+/,$configline);
        chomp($varvalue);
        $perlvar{$varname}=$varvalue;
    }
}
close(CONFIG);
open (CONFIG,"/etc/httpd/conf/loncapa.conf") || die "Can't read loncapa.conf";
while ($configline=<CONFIG>) {
    if ($configline =~ /^[^\#]*PerlSetVar/) {
	my ($dummy,$varname,$varvalue)=split(/\s+/,$configline);
        chomp($varvalue);
        $perlvar{$varname}=$varvalue;
    }
}
close(CONFIG);
if ($perlvar{'lonRole'} ne 'library') {
    print(<<END);
Skipping web layer test...
   (lonRole is defined as $perlvar{'lonRole'}
    and the web layer test only runs on library servers.)
END
    exit(0);
}

my $hostid=$perlvar{'lonHostID'};
my $domain=$perlvar{'lonDefDomain'};

print "Testing web layer, hostid=$hostid, domain=$domain\n";

# ---------------------------------------------------------- determine password
srand;
my @abet=('a'..'z','A'..'Z',0..9);
my $passwd='';
for (my $i=0;$i<11;$i++) {
    $passwd.=$abet[int(rand(62))];
}

# -------------------------------------------------------------- make test user
open OUT, "|perl make_test_user.pl ${hostid}$$ $domain" or
    (print("**** ERROR **** cannot run make_test_user.pl\n") and exit(1));
print OUT $passwd;
close OUT;
print "**** ERROR **** problems encountered with making user\n" 
    and exit(1) if $?;

# ---------------------------------------------------------------- try to login
open OUT, "|perl test_login.pl" or 
    (print("**** ERROR **** cannot run test_login.pl\n") and exit(1));
print OUT "ZXQTEST${hostid}$$\n";
print OUT "$passwd";
close OUT;
print "**** ERROR **** problems encountered with testing login\n"
    and exit(1) if $?;

# ---------------------------------------------------------- clean up test user
`rm -Rf /home/httpd/lonUsers/$domain/Z/X/Q/ZXQTEST${hostid}*`;

=pod

=head1 AUTHOR


=cut
