#!/usr/bin/perl
# CGI-script to allow download of all essay submissions of 
# multiple students.
#
# $Id: multidownload.pl,v 1.35 2007/05/23 20:40:44 banghart Exp $
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use lib '/home/httpd/lib/perl';
use LONCAPA::loncgi;
use File::Path;
use File::Basename;
use File::Copy;
use IO::File;
use Apache::lonhtmlcommon();
use Apache::lonnavmaps;
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonlocal;
use Apache::lonmsg();
use Apache::lonnet;
use LONCAPA::Enrollment;
use strict;

sub is_flat {
    my ($partlist, $res) = @_;
    my $flat_part = 1;
    my $flat_resp = 1;
    if (scalar(@$partlist) > 1) {
        $flat_part = 0;
    }
    foreach my $partid (@$partlist) {
        my @ids = $res->responseIds($partid);
        if (scalar(@ids) > 1 ) {
            $flat_resp = 0;
        }
    }
    return ($flat_part, $flat_resp);
}
sub get_part_resp_path {
    my ($flat_part, $flat_resp, $part_id, $resp_id) = @_;
    my $part_resp_path = "";
    if (!$flat_part) {
        $part_resp_path = "part$part_id/";
    } 
    if (!$flat_resp) {
        $part_resp_path .= "resp$resp_id/";
    }
    $part_resp_path =~ s/\/^//; 
    return('/'.$part_resp_path);
}
$|=1;
if (! &LONCAPA::loncgi::check_cookie_and_load_env()) {
    print <<END;
Content-type: text/html

<html>
<head><title>Bad Cookie</title></head>
<body>
Your cookie information is incorrect.
</body>
</html>
END
    return;
}
&Apache::lonlocal::get_language_handle();
&Apache::loncommon::content_type(undef,'text/html');
my $identifier = $ENV{'QUERY_STRING'};
my $unique_path = $identifier.time();
print(&Apache::loncommon::start_page('Multiple Downloads'));
    

my $scope = $env{'request.course.id'};
if ($env{'request.course.sec'}) {
    $scope .= '/'.$env{'request.course.sec'};
}
if (&Apache::lonnet::allowed('vgr',$scope) eq 'F') {
    my $symb = $env{'cgi.'.$identifier.'.symb'};
    my $navmap = Apache::lonnavmaps::navmap->new();
    my $res = $navmap->getBySymb($symb);
    my $partlist = $res->parts();
    my ($flat_part, $flat_resp) = &is_flat($partlist, $res);
    my ($zipout) = ($symb =~ /^.*\/(.+)\.problem$/);
    $zipout =~ s/\s/_/g;
    $zipout .= "$identifier.zip";
    my $courseid = $env{'request.course.id'};
    my @stuchecked = split(/\n/,$env{'cgi.'.$identifier.'.students'});
    my $number_of_students = scalar(@stuchecked);
    my %prog_state=&Apache::lonhtmlcommon::Create_PrgWin('','Processing Status',
                                                    'Preparing Zip File',$number_of_students,'inline','80');
    my @parts = split(/\n/,$env{'cgi.'.$identifier.'.parts'});
    my $doc_zip_root = $Apache::lonnet::perlvar{'lonZipDir'};
    my $uname = $env{'user.name'};
    my $udom = $env{'user.domain'};
    my $unique_user = $uname.":".$udom;
    &mkpath($doc_zip_root."/zipdir/$unique_user/$unique_path",0,0700);
    if (!open(MANIFEST, ">$doc_zip_root/zipdir/$unique_user/$unique_path/manifest.txt")) {
        &Apache::lonnet::logthis("Problem making manifest");
    }
    print MANIFEST (&mt("Zip file generated on [_1]",&Apache::lonlocal::locallocaltime(time()))."\n");
    print MANIFEST (&mt("Course: [_1]",$env{"course.$courseid.description"})."\n");
    print MANIFEST (&mt("Problem: [_1]",$res->compTitle)."\n");
    print MANIFEST (&mt("Files contained in this zip:\n"));
    my $file_problem = 0;
    my $current_student = 0;
    foreach my $stu (@stuchecked) {
        $current_student ++;
        &Apache::lonhtmlcommon::Update_PrgWin('',\%prog_state,"Processing student $current_student of $number_of_students");
        my %files_saved;
        my ($stuname,$studom,$fullname) = split(/:/,$stu);
        my %record = &Apache::lonnet::restore($symb,$courseid,$studom,$stuname);
        my $file_url = '/uploaded/'.$studom.'/'.$stuname.'/portfolio';
        print MANIFEST ($fullname."\n");
        my $submission_count = 0;
        foreach my $partid (@$partlist) {
            my @ids = $res->responseIds($partid);
            foreach my $respid(@ids) {
                my $part_resp_path = &get_part_resp_path($flat_part,$flat_resp, $partid, $respid);
                &mkpath($doc_zip_root."/zipdir/$unique_user/$unique_path/$stuname/$part_resp_path",0,0700);
                foreach my $file (split(',',$record{"resource.$partid.$respid.portfiles"})) {
                    $file = $file_url.$file;
                    my ($file_name_only) = ($file =~ /^.*\/(.+$)/);
                    print MANIFEST ("\t$file_name_only (".&mt("Part [_1]",$partid).
                                    ") (".&mt("Response [_1]",$respid).")"."\n");
                    $submission_count ++;
                    &Apache::lonnet::repcopy($file);
                    my $source = &Apache::lonnet::filelocation("",$file);
                    my $destination = "$doc_zip_root/zipdir/$unique_user/$unique_path/$stuname$part_resp_path/$file_name_only";
                    if (exists($files_saved{$destination})) {
                        # file has already been saved once
                        my ($file_name,$file_ext) = ($destination =~ /(^.*)(\..+$)/);
                        $destination = $file_name.$files_saved{$destination}.$file_ext;
                        $files_saved{$destination} ++;
                    }
                    $files_saved{$destination}++;
                    if (!&copy($source,$destination)) {
                        if (!$file_problem) {
                            print(&mt("Unable to create: <br />"));
                            $file_problem = 1;
                        }
                        print("$stuname/part$partid/resp$respid/$file_name_only <br />");
                    }
                }
            }
        }
        if (!$submission_count) {
            print MANIFEST ("\t".&mt("No Files Submitted")."\n");
        }
    }
    
    &mkpath($doc_zip_root."/zipout/$unique_user",0,0700);
    my $statement;
    if (! -e "$doc_zip_root/zipout/$unique_user/$zipout") {
        $statement = "cd $doc_zip_root/zipdir/$unique_user/$unique_path\n";
        $statement .= "zip -r $doc_zip_root/zipout/$unique_user/$zipout * > /dev/null";
        system($statement);
    } else {
        # should happen only if user reloads page 
        &Apache::lonnet::logthis("$zipout is already there");
    }
    $statement = "rm -rf $doc_zip_root/zipdir/$unique_user/$unique_path";
    system($statement);
    &Apache::lonhtmlcommon::Close_PrgWin('',\%prog_state);
    print('<p><a href="/zipspool/zipout/'.$unique_user.'/'.$zipout.'">'.
            &mt("Click to download").'</a></p><br />');
    close(MANIFEST);
} else {
    print(&mt('You are not authorized to download student submissions.'));
}
1;
__END__;
