/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.viewer.Atom;
import org.jmol.viewer.Backbone;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;

class BackboneRenderer
extends MpsRenderer {
    BackboneRenderer() {
    }

    void renderMpspolymer(Mps.Mpspolymer mpspolymer) {
        this.renderTraceChain((Backbone.Bbpolymer)mpspolymer);
    }

    void renderTraceChain(Backbone.Bbpolymer bbpolymer) {
        this.render1Chain(bbpolymer.monomerCount, bbpolymer.polymer.getLeadAtomIndices(), bbpolymer.mads, bbpolymer.colixes);
    }

    void render1Chain(int monomerCount, int[] atomIndices, short[] mads, short[] colixes) {
        int i = monomerCount - 1;
        while (--i >= 0) {
            short colixB;
            if (mads[i] == 0) continue;
            Atom atomA = this.frame.getAtomAt(atomIndices[i]);
            int xA = atomA.getScreenX();
            int yA = atomA.getScreenY();
            int zA = atomA.getScreenZ();
            Atom atomB = this.frame.getAtomAt(atomIndices[i + 1]);
            int xB = atomB.getScreenX();
            int yB = atomB.getScreenY();
            int zB = atomB.getScreenZ();
            short colixA = colixes[i];
            if (colixA == 0) {
                colixA = atomA.colixAtom;
            }
            if ((colixB = colixes[i + 1]) == 0) {
                colixB = atomB.colixAtom;
            }
            if (mads[i] < 0) {
                this.g3d.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
                continue;
            }
            short width = this.viewer.scaleToScreen((zA + zB) / 2, mads[i]);
            this.g3d.fillCylinder(colixA, colixB, (byte)3, width, xA, yA, zA, xB, yB, zB);
        }
    }
}

