#!/bin/bash

MAILADDR=certificate@lon-capa.org	# Email the cert request here.
DESTDIR=/home/httpd/lonCerts			# Destination for the key file.
DESTUID=www			# Who will own the private key.
DESTGROUP=www			# Gropu that owns the private key.

openssl req -newkey rsa:1024 -passout pass:loncapa \
    -keyout lonKey.enc -keyform PEM  \
    -out    CertRequest.pem -outform PEM

openssl rsa -passin pass:loncapa -in lonKey.enc -out lonKey.pem

install -d -m 0750 -o $DESTUID -g $DESTGROUP $DESTDIR
install -m 0400 -o $DESTUID -g $DESTGROUP lonKey.pem $DESTDIR
rm lonKey.{enc,pem}

mail <CertRequest.pem -s "Certificate Request" $MAILADDR
rm CertRequest.pem
