/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class GhemicalMMReader
extends AtomSetCollectionReader {
    GhemicalMMReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader input) throws Exception {
        String line;
        this.atomSetCollection = new AtomSetCollection("ghemicalMM");
        while ((line = input.readLine()) != null) {
            if (line.startsWith("!Header")) {
                this.processHeader(line);
                continue;
            }
            if (line.startsWith("!Info")) {
                this.processInfo(line);
                continue;
            }
            if (line.startsWith("!Atoms")) {
                this.processAtoms(input, line);
                continue;
            }
            if (line.startsWith("!Bonds")) {
                this.processBonds(input, line);
                continue;
            }
            if (line.startsWith("!Coord")) {
                this.processCoord(input, line);
                continue;
            }
            if (line.startsWith("!Charges")) {
                this.processCharges(input, line);
                continue;
            }
            if (!line.startsWith("!End")) continue;
            return this.atomSetCollection;
        }
        this.atomSetCollection.errorMessage = "unexpected end of file";
        return this.atomSetCollection;
    }

    void processHeader(String line) {
    }

    void processInfo(String line) {
    }

    void processAtoms(BufferedReader input, String line) throws Exception {
        int atomCount = this.parseInt(line, 6);
        System.out.println("atomCount=" + atomCount);
        for (int i = 0; i < atomCount; ++i) {
            if (this.atomSetCollection.atomCount != i) {
                throw new Exception("GhemicalMMReader error #1");
            }
            line = input.readLine();
            int atomIndex = this.parseInt(line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Atomsexpected: " + i + " saw:" + atomIndex);
            }
            int elementNumber = this.parseInt(line, this.ichNextParse);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (byte)elementNumber;
        }
    }

    void processBonds(BufferedReader input, String line) throws Exception {
        int bondCount = this.parseInt(line, 6);
        for (int i = 0; i < bondCount; ++i) {
            line = input.readLine();
            int atomIndex1 = this.parseInt(line);
            int atomIndex2 = this.parseInt(line, this.ichNextParse);
            String orderCode = this.parseToken(line, this.ichNextParse);
            int order = 0;
            switch (orderCode.charAt(0)) {
                case 'C': {
                    ++order;
                }
                case 'T': {
                    ++order;
                }
                case 'D': {
                    ++order;
                }
            }
            this.atomSetCollection.addNewBond(atomIndex1, atomIndex2, ++order);
        }
    }

    void processCoord(BufferedReader input, String line) throws Exception {
        for (int i = 0; i < this.atomSetCollection.atomCount; ++i) {
            line = input.readLine();
            int atomIndex = this.parseInt(line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Coordexpected: " + i + " saw:" + atomIndex);
            }
            Atom atom = this.atomSetCollection.atoms[i];
            atom.x = this.parseFloat(line, this.ichNextParse) * 10.0f;
            atom.y = this.parseFloat(line, this.ichNextParse) * 10.0f;
            atom.z = this.parseFloat(line, this.ichNextParse) * 10.0f;
        }
    }

    void processCharges(BufferedReader input, String line) throws Exception {
        for (int i = 0; i < this.atomSetCollection.atomCount; ++i) {
            line = input.readLine();
            int atomIndex = this.parseInt(line);
            if (atomIndex != i) {
                throw new Exception("bad atom index in !Chargesexpected: " + i + " saw:" + atomIndex);
            }
            Atom atom = this.atomSetCollection.atoms[i];
            atom.partialCharge = this.parseFloat(line, this.ichNextParse);
        }
    }
}

