#!/usr/bin/perl

# The LearningOnline Network with CAPA
# Perl script to rebuild the topic->tex file hash
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# 7-16-2002 Jeremy Bowers

use strict;
use GDBM_File;
use File::Spec;

# I had to chdir, because neither glob nor bsd_glob accept globs
# with ".." in them... sucky.
chdir "../../loncom/html/adm/help/";

# if the topic hash exists, kill it
unlink 'fragmentLabels.gdbm' if ( -e 'fragmentLabels.gdbm' );
print "Wiped old fragmentLabels.gdbm.\n";

tie (my %fragmentLabels, 'GDBM_File', 'fragmentLabels.gdbm', &GDBM_WRCREAT(), 0660);
my $error = 0;

chdir "tex";

foreach my $file ( glob("*.tex") ) 
{
    open F, $file;
    if ( index($file, "/") != "/" )
    {
	$file = substr($file, index($file, "/") + 1);
    } 
    my $contents = join("\n", <F>);
    my $label;
    
    # Search for labels, of the form '\label{labelname}'
    foreach $label ( $contents =~ /\\label\{([^}]*)\}/g )
    {
	if (exists $fragmentLabels{$label} )
	{
	    print "***ERROR: '$label' in both $fragmentLabels{$label} " .
	          "and $file. \n";
	    $error = 1;
	}
	$fragmentLabels{$label} = $file;
    }
}

if ($error == 0)
{
    print "There were no duplicate labels. Database rebuilt.\n";
}
else
{
    print "There were errors. You must correct the duplicate labels.\n";
}

untie %fragmentLabels;
