#!/usr/bin/perl

# The LearningOnline Network with CAPA
# verify.pl - Wraps around filecompare.pl for posteval lpml statements.
#
# $Id: verify.pl,v 1.3 2001/12/07 04:44:11 harris41 Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# YEAR=2001
# 12/5,12/6 Scott Harrison
#
###

use strict;

my $mode=shift @ARGV;

if ($mode eq 'file') {
    my $sourceroot=shift @ARGV;
    my $targetroot=shift @ARGV;
    my $source=shift @ARGV;
    my $target=shift @ARGV;
    my $chmod=shift @ARGV;
    my $chown=shift @ARGV;
    my $command="perl filecompare.pl -s SOURCE='$sourceroot' ".
	"TARGET='/$targetroot' ".
	"MODE=file $source $target 2>/dev/null";

    my @ret=`$command`;
    foreach my $r (@ret) {
	chomp $r;
	my ($name, $existence, $cvstime, $age, $md5sum, $size, $lines, $diffs)=
	    split(/\t/,$r);
	
	if ($existence eq 'existence: yes:yes') {
	    my ($user,$group)=split(/\:/,$chown);
	    my $verify=`perl verifymodown.pl /$targetroot$target '-m $chmod -o $user -g $group -N'`;
	    if ($verify) {
		print "$verify\n";
	    }
	}
	if ($existence eq 'existence: yes:yes' and
	    $md5sum eq 'md5sum: different') {
	    print "[DIFFERING CONTENTS]\n";
	}
	elsif ($existence eq 'existence: yes:no') {
	    print "[DOES NOT EXIST AT TARGET]\n";
	}
	elsif ($existence=~/^existence: no/) {
	    print "[DOES NOT EXIST AT SOURCE]\n";
	    if ($existence eq 'existence: no:no') {
		print "[DOES NOT EXIST AT TARGET]\n";
	    }
	}
    }
}
elsif ($mode eq 'link') {
    my $linkto=shift @ARGV;
    my $location=shift @ARGV;
    unless (-l $location) {
	print "[NOT A LINK]\n";
    }
    else {
	my $linkto2=readlink($location);
	if ($linkto ne $linkto2) {
	    print "[WRONG LINKTO; points to $linkto2]\n";
	}
    }
}
elsif ($mode eq 'directory') {
    my $location=shift @ARGV;
    my $chmod=shift @ARGV;
    my $chown=shift @ARGV;
    my ($user,$group)=split(/\:/,$chown);
    if (-d $location) {
	my $verify=`perl verifymodown.pl $location '-m $chmod -o $user -g $group -N'`;
	print "$verify\n" if $verify;
    }
    else {
	print "[MISSING]\n";
    }
}
elsif ($mode eq 'fileglob') {
    my $sourceroot=shift @ARGV;
    my $targetroot=shift @ARGV;
    my $glob=shift @ARGV;
    my $sourcedir=shift @ARGV;
    my $filenames=shift @ARGV;
    my $targetdir=shift @ARGV;
    my $chmod=shift @ARGV;
    my $chown=shift @ARGV;
    # does sourcedir&glob have extraneous files not given in filenames?
    # does targetdir lack files in filenames
    # are any of the files of incorrect permissions or ownership?
    # are there differences between any of the files
    my %files=map {($_,1)} (split(';',$filenames));
    my $command="perl filecompare.pl -s SOURCE='$sourceroot' ".
	"TARGET='/$targetroot' ".
	"MODE=fileglob $sourcedir$glob $targetdir$glob 2>/dev/null";
    my @ret=`$command`;
    foreach my $r (@ret) {
	chomp $r;
	my ($name, $existence, $cvstime, $age, $md5sum, $size, $lines, $diffs)=
	    split(/\t/,$r);
	
	if ($existence eq 'existence: yes:yes') {
	    my ($user,$group)=split(/\:/,$chown);
	    my $verify=`perl verifymodown.pl /$targetdir$name '-m $chmod -o $user -g $group -N'`;
	    if ($verify) {
		print "[$name $verify]\n";
	    }
	}
	if (!$files{$name}) {
	    print "[$name is undefined/unexpected in fileglob]\n";
	}
	elsif ($existence eq 'existence: yes:yes' and
	    $md5sum eq 'md5sum: different') {
	    print "[$name is different]\n";
	}
	elsif ($existence eq 'existence: yes:no') {
	    print "[$name does not exist at target]\n";
	}
	$files{$name}=2;
    }
    for my $f (keys %files) {
	if ($files{$f}!=2) {
	    print "[$f does not exist at source]\n";
	}
    }
}
else {
    print "[UNPROCESSED ".join(' ',@ARGV)."]\n";
}
