#!/usr/bin/perl
# Take machine offline, reroute traffic
#
# $Id: takeoffline.pl,v 1.2 2003/09/11 20:54:11 www Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

print "Content-type: text/html\n\n".
      "<html><body bgcolor=#FFFFFF><h1>Take Offline</h1>";
unless ($ENV{'QUERY_STRING'}) {
    print 'No reroute server given, taking completely offline.';
    &dead();
} else {
    ($otherserver,$domain)=split(/\&/,$ENV{'QUERY_STRING'});
    print 'Rerouting to '.$otherserver;
    &reroute();
}
open (STATUS,'>/home/httpd/html/lon-status/reroute.txt');
print STATUS "status=rerouting&server=$otherserver&domain=$domain&time=".time."\n";
close(STATUS);

print "</body></html>";

sub dead {
    open (OUT,'>/home/httpd/html/index.html');
    print OUT 'This LON-CAPA server is currently offline.';
    close(OUT);
}

sub reroute {
    open (OUT,'>/home/httpd/html/index.html');
    print OUT (<<ENDNEWINDEX);
<html>
 <head>
  <title>Welcome to the LearningOnline Network with CAPA</title>
  <meta HTTP-EQUIV="Refresh" CONTENT="0.5; url=http://$otherserver/adm/login?domain=$domain">
 </head>
 <body bgcolor="#004400" topmargin=0 leftmargin=0 marginwidth=0 marginheight=0>
  <img src="/adm/lonIcons/header.gif" />
<p><font color="#FFFFFF">Connecting to
<a href="http://$otherserver/adm/login?domain=$domain"><font color="#FFFFFF">http://$otherserver/</font></a></font></p>
</body>
</html>
ENDNEWINDEX
   close(OUT);
}
