# The LearningOnline Network with CAPA
# The LON-CAPA group sort handler
# Allows for sorting prior to import into RAT.
#
# $Id: groupsort.pm,v 1.50 2006/12/05 02:55:51 albertel Exp $
# 
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::groupsort;

use strict;

use Apache::Constants qw(:common);
use GDBM_File;
use Apache::loncommon;
use Apache::lonlocal;
use Apache::lonnet;
use LONCAPA();

my $iconpath; # variable to be accessible to multiple subroutines
my %hash; # variable to tie to user specific database


sub readfromdb {
    my ($r,$shash,$thash)=@_;

    my $diropendb = 
       "/home/httpd/perl/tmp/$env{'user.domain'}_$env{'user.name'}_sel_res.db";

# ----------------------------- diropendb is now the filename of the db to open
    if (tie(%hash,'GDBM_File',$diropendb,&GDBM_WRCREAT(),0640)) {
	my $acts = $env{'form.acts'};
	my @Acts = split(/b/,$acts);
	my %ahash;
	my %achash;
	my $ac = 0;
	foreach (@Acts) {
	    my ($state,$ref) = split(/a/);
	    $ahash{$ref} = $state;
	    $achash{$ref} = $ac;
	    $ac++;
	}
	foreach (sort {$achash{$a} <=> $achash{$b}} (keys %ahash)) {
	    my $key = $_;
	    if ($ahash{$key} eq '1') {
		$hash{'store_'.$hash{'pre_'.$key.'_link'}} =
		    $hash{'pre_'.$key.'_title'};
		$hash{'storectr_'.$hash{'pre_'.$key.'_link'}} =
		    $hash{'storectr'}+0;
		$hash{'storectr'}++;
	    }
	    if ($ahash{$key} eq '0') {
		if ($hash{'store_'.$hash{'pre_'.$key.'_link'}}) {
		    delete $hash{'store_'.$hash{'pre_'.$key.'_link'}};
		}
	    }
	}
	foreach (keys %hash) {
	    if ($_ =~ /^store_/) {
		my $key = $_;
		$key =~ s/^store_//;
		$$shash{$key} = $hash{'storectr_'.$key};
		if (&Apache::lonnet::gettitle($key) eq '') {
		    $$thash{$key} = $hash{'store_'.$key};
		} else {
		    $$thash{$key} = &Apache::lonnet::gettitle($key);
		}
	    }
	}
	if ($env{'form.oldval'}) {
	    my $newctr = 0;
	    my %chash;
	    foreach (sort {$$shash{$a} <=> $$shash{$b}} (keys %{$shash})) {
		my $key = $_;
		$newctr++;
		$$shash{$key} = $newctr;
		$hash{'storectr_'.$key} = $newctr;
		$chash{$newctr} = $key;
	    }
	    my $oldval = $env{'form.oldval'};
	    my $newval = $env{'form.newval'};
	    if ($oldval != $newval) {
		# when newval==0, then push down and delete
		if ($newval!=0) {
		    $$shash{$chash{$oldval}} = $newval;
		    $hash{'storectr_'.$chash{$oldval}} = $newval;
		} else {
		    $$shash{$chash{$oldval}} = $newctr;
		    $hash{'storectr_'.$chash{$oldval}} = $newctr;
		}
		if ($newval==0) { # push down
		    my $newval2=$newctr;
		    for my $idx ($oldval..($newval2-1)) {
			$$shash{$chash{$idx+1}} = $idx;
			$hash{'storectr_'.$chash{$idx+1}} = $idx;
		    }
		    delete $$shash{$chash{$oldval}};
		    delete $hash{'storectr_'.$chash{$oldval}};
		    delete $hash{'store_'.$chash{$oldval}};
		} elsif ($oldval < $newval) { # push down
		    for my $idx ($oldval..($newval-1)) {
			$$shash{$chash{$idx+1}} = $idx;
			$hash{'storectr_'.$chash{$idx+1}} = $idx;
		    }
		} elsif ($oldval > $newval) { # push up
		    for my $idx (reverse($newval..($oldval-1))) {
			$$shash{$chash{$idx}} = $idx+1;
			$hash{'storectr_'.$chash{$idx}} = $idx+1;
		    }
		}
	    }
	}
    } else {
	$r->print('Unable to tie hash to db file');
    }
    untie %hash;
    return ($shash,$thash);
}



sub cleanup {
    if (tied(%hash)){
	&Apache::lonnet::logthis('Cleanup groupsort: hash');
        unless (untie(%hash)) {
	    &Apache::lonnet::logthis('Failed cleanup groupsort: hash');
        }
    }
    return OK;
}

# -------------------------------------------------------------- Read from file

sub readfromfile {
    my ($r,$shash,$thash,$nhash)=@_;
    my $cont=&Apache::lonnet::getfile
	(&Apache::lonnet::filelocation('',$env{'form.readfile'}));
    if ($cont==-1) {
	$r->print('Unable to read file: '.
		  &Apache::lonnet::filelocation('',$env{'form.readfile'}));
    } else {
        my $parser = HTML::TokeParser->new(\$cont);
        my $token;
	my $n=1;
        while ($token = $parser->get_token) {
	    if ($token->[0] eq 'S') {
                if ($token->[1] eq 'resource') {
		    if ($env{'form.recover'}) {
			if ($token->[2]->{'type'} ne 'zombie') { next; }
		    } else {
			if ($token->[2]->{'type'} eq 'zombie') { next; }
		    }

		    my $url=$token->[2]->{'src'};
                    my $name=$token->[2]->{'title'};
		    $name=~s/ \[\((\d+)\,($LONCAPA::username_re)\,($LONCAPA::domain_re)\)\]$//;
		    if ($1) {
			$$nhash{$url}='<br />'.&mt('Removed by ').
			    &Apache::loncommon::plainname($2,$3).', '.
			    &Apache::lonlocal::locallocaltime($1);
		    }
		    $name=~s/\&colon\;/\:/g;
		    $$thash{$url}=$name;
                    $$shash{$url}=$n;
                    $n++;
		}
	    }
	}
    }
    return ($shash,$thash);
}

# --------------------------------------------------------- Read from bookmarks

sub readfrombookmarks {
    my ($r,$shash,$thash)=@_;
    my %bookmarks=&Apache::lonnet::dump('bookmarks');
# the bookmark "hash" is just one entry
# it's a javascript program code with arguments like ('title','url');
    my @bookmarks=($bookmarks{'bookmarks'}=~/\((?:\'([^\']+)\'\,\'([^\']+)\'|\"([^\"]+)\"\,\"([^\"]+)\")\)\;/g);
    my $order=1;
    for (my $index=0;$index<($#bookmarks+1)/2;$index++) {
        if ($bookmarks[$index*2+1]) {
	    $$thash{$bookmarks[$index*2+1]}=$bookmarks[$index*2];
	    $$thash{$bookmarks[$index*2+1]}=~s/^LON\-CAPA\s+//;
	    $$shash{$bookmarks[$index*2+1]}=$order;
	    $order++;
	}
    }
    return ($shash,$thash);
}

# ---------------------------------------------------------------- Main Handler
sub handler {
    my $r = shift;
 
   &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
			     ['acts','mode','readfile','recover','bookmarks']);
    # color scheme
    my $fileclr = '#ffffe6';
    my $titleclr = '#ddffff';

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

# finish_import looks different for graphical or "simple" RAT
    my $finishimport='';
    my $begincondition='';
    my $endcondition='';
    if (($env{'form.readfile'}) || ($env{'form.bookmarks'}))  {
        $begincondition='if (eval("document.forms.groupsort.include"+num+".checked")) {';
	$endcondition='}';
    }
    if ($env{'form.mode'} eq 'simple' || $env{'form.mode'} eq '') {
        $finishimport=(<<ENDSMP);
function finish_import() {
    opener.document.forms.simpleedit.importdetail.value='';
    for (var num=0; num<document.forms.groupsort.fnum.value; num++) {
	$begincondition
	opener.document.forms.simpleedit.importdetail.value+='&'+
              escape(eval("document.forms.groupsort.title"+num+".value"))+'='+
	      escape(eval("document.forms.groupsort.filelink"+num+".value"));
	$endcondition
    }
    opener.document.forms.simpleedit.submit();
    self.close();
}
ENDSMP
    } else {
        $finishimport=(<<ENDADV);
function finish_import() {
    var linkflag=false;
    for (var num=0; num<document.forms.groupsort.fnum.value; num++) {
	$begincondition
	insertRowInLastRow();
	placeResourceInLastRow(
	       eval("document.forms.groupsort.title"+num+".value"),
 	       eval("document.forms.groupsort.filelink"+num+".value"),
	       linkflag
	);
        linkflag=true;
	$endcondition
    }
    opener.editmode=0;
    opener.notclear=0;
    opener.linkmode=0;
    opener.draw();
    self.close();
}
ENDADV
    }

# output start of web page
    my $js = <<END;
<script type="text/javascript">
function insertRowInLastRow() {
    opener.insertrow(opener.maxrow);
    opener.addobj(opener.maxrow,'e&2');
}
function placeResourceInLastRow (title,url,linkflag) {
    opener.mostrecent=opener.newresource(opener.maxrow,2,opener.escape(title),
		       opener.escape(url),'false','normal');
    opener.save();
    if (linkflag) {
	opener.joinres(opener.linkmode,opener.mostrecent,0);
    }
    opener.linkmode=opener.mostrecent;
}
$finishimport
function selectchange(val) {
    var newval=0+eval("document.forms.groupsort.alt"+val+".selectedIndex");
    orderchange(val,newval);
}
function move(val,newval) {
    orderchange(val,newval);
}
function orderchange(val,newval) {
    document.forms.groupsort.oldval.value=val;
    document.forms.groupsort.newval.value=newval;
    document.forms.groupsort.submit();
}
</script>
END
    # read pertinent machine configuration
    my $domain  = $r->dir_config('lonDefDomain');
    $iconpath = $r->dir_config('lonIconsURL') . "/";

    my %shash; # sort order (key is resource location, value is sort order)
    my %thash; # title (key is resource location, value is title)
    my %nhash; # notes (key is resource location);

    if ($env{'form.readfile'}) {
	&readfromfile($r,\%shash,\%thash,\%nhash);
    } elsif ($env{'form.bookmarks'}) {
	&readfrombookmarks($r,\%shash,\%thash);
    } else {
	&readfromdb($r,\%shash,\%thash);
    }

    my $ctr = 0;
    my $clen = scalar(keys %shash);
    if (($clen > 1) || ($env{'form.readfile'}) || ($env{'form.bookmarks'})) {
	my %lt=&Apache::lonlocal::texthash(
		'fin'=> 'Finalize order of resources',
		'ci' => 'Continue Import',
		'cs' => 'Continue Search',
		'fi' => 'Finish Import',
		'ca' => 'Cancel',
		'co' => 'Change Order',
		'ti' => 'Title',
		'pa' => 'Path',
                'in' => 'Include'
		);
	$r->print(&Apache::loncommon::start_page('Sort Imported Resources',
						 $js));
	$r->print(<<END);
<b><font color="#888888">$lt{'fin'}</font></b>
<form method='post' action='/adm/groupsort' name='groupsort'
      enctype='application/x-www-form-urlencoded'>
<input type="hidden" name="fnum" value="$clen" />
<input type="hidden" name="oldval" value="" />
<input type="hidden" name="newval" value="" />
<input type="hidden" name="mode" value="$env{'form.mode'}" />
<input type="hidden" name="readfile" value="$env{'form.readfile'}" />
<input type="hidden" name="bookmarks" value="$env{'form.bookmarks'}" />
<input type="hidden" name="recover" value="$env{'form.recover'}" />
END

        # --- Continue Buttons
        my $resurl = 
	   &Apache::loncommon::escape_single(&Apache::loncommon::lastresurl());
        $r->print(<<END);
<input type="button" name="alter" value="$lt{'ci'}"
 onClick="window.location='$resurl?catalogmode=import'" />&nbsp;
<input type="button" name="altersearch" value="$lt{'cs'}"
 onClick="window.location='/adm/searchcat?catalogmode=import'" />&nbsp;
END
        # ---

	$r->print(<<END);
<input type="button" name="alter" value="$lt{'fi'}"
 onClick="finish_import()" />&nbsp;
<input type="button" name="alter" value="$lt{'ca'}" onClick="self.close()" />
END
        $r->print("<table border='0'><tr><td bgcolor='#eeeeee'>");
	$r->print("<table border=0><tr>\n");
	if (($env{'form.readfile'}) || ($env{'form.bookmarks'})) { 
	    $r->print("<td bgcolor='$titleclr'><b>$lt{'in'}</b></td>\n");
	} else { 
	    $r->print("<td colspan='2' bgcolor='$titleclr'><b>$lt{'co'}</b></td>\n"); 
	}
	$r->print("<td colspan='2' bgcolor='$titleclr'><b>$lt{'ti'}</b></td>\n");
	$r->print("<td bgcolor='$titleclr'><b>$lt{'pa'}</b></td></tr>\n");
    } else {
	$r->print(&Apache::loncommon::start_page(undef,$js,
						 {'only_body' => 1}));
	$r->print(<<END);
<form method='post' action='/adm/groupsort' name='groupsort'
      enctype='application/x-www-form-urlencoded'>
<input type="hidden" name="fnum" value="$clen" />
<input type="hidden" name="oldval" value="" />
<input type="hidden" name="newval" value="" />
<input type="hidden" name="mode" value="$env{'form.mode'}" />
END
    }
    foreach (sort {$shash{$a}<=>$shash{$b}} (keys %shash)) {
	my $key=$_;
	$ctr++;
	my $iconname=&Apache::loncommon::icon($key);
	if (($clen > 1) || ($env{'form.readfile'}) || ($env{'form.bookmarks'})) {
	    $r->print("<tr><td bgcolor='$fileclr'>");
            if (($env{'form.readfile'}) || ($env{'form.bookmarks'})) {
		$r->print(&checkbox($ctr-1));
	    } else {
		$r->print(&movers($clen,$ctr));
	    }
	}
	$r->print(&hidden($ctr-1,$thash{$key},$key));
	if (($clen > 1)  || ($env{'form.readfile'}) || ($env{'form.bookmarks'})) {
	    $r->print("</td>");
            unless (($env{'form.readfile'}) || ($env{'form.bookmarks'})) {
		$r->print("<td bgcolor='$fileclr'>".
			  &select_box($clen,$ctr).
			  "</td>");
	    }
	    $r->print("<td bgcolor='$fileclr'>");
	    $r->print("<img src='$iconname' />");
	    $r->print("</td><td bgcolor='$fileclr'>");
	    $r->print("$thash{$key}$nhash{$key}</td><td bgcolor='$fileclr'>\n");
	    $r->print("$key</td></tr>\n");
	} 
    }
    if (($clen > 1) || ($env{'form.readfile'}) || ($env{'form.bookmarks'})) {
	$r->print("</table></td></tr></table></form>");
    } else {
	$r->print(<<END);
<script type="text/javascript">
    finish_import();
</script>
END
    }

    $r->print(&Apache::loncommon::end_page());

    return OK;
}

# --------------------------------------- Hidden values (returns scalar string)
sub hidden {
    my ($sel,$title,$filelink) = @_;
    my $string = '<input type="hidden" name="title'.$sel.'" value="'.$title.
	'" />';
    $filelink=~s|^/ext/|http://|;
    $string .= '<input type="hidden" name="filelink'.$sel.'" value="'.
	$filelink.'" />';
    return $string;
}

# --------------------------------------- Moving arrows (returns scalar string)
sub movers {
    my ($total,$sel) = @_;
    my $dsel = $sel-1;
    my $usel = $sel+1;
    $usel = 1 if $usel > $total;
    $dsel = $total if $dsel < 1;
    my $string;
    $string = (<<END);
<table border='0' cellspacing='0' cellpadding='0'>
<tr><td><a href='javascript:move($sel,$dsel)'>
<img src="${iconpath}move_up.gif" alt='UP' border='0' /></a></td></tr>
<tr><td><a href='javascript:move($sel,$usel)'>
<img src="${iconpath}move_down.gif" alt='DOWN' border='0' /></a></td></tr>
</table>
END
    return $string;
}

# ------------------------------------------ Select box (returns scalar string)
sub select_box {
    my ($total,$sel) = @_;
    my $string;
    $string = '<select name="alt'.$sel.'"';
    $string .= " onChange='selectchange($sel)'>";
    $string .= "<option name='o0' value='0'>".&mt('discard')."</option>";
    for my $cur (1..$total) {
	$string .= "<option name='o$cur' value='$cur'";
	if ($cur == $sel) {
	    $string .= "selected";
	}
	$string .= ">$cur</option>";
    }
    $string .= "</select>\n";
    return $string;
}

# ------------------------------------------------------------------- Checkbox

sub checkbox {
    my $sel=shift;
    return "<label><input type='checkbox' name='include$sel'".
       ($env{"form.include$sel"}?' checked="checked"':'').
       ' />'.&mt('Include').'</label>';
}

1;

__END__
