# The LearningOnline Network
# Evaluate
#
# $Id: lonevaluate.pm,v 1.21 2007/05/02 01:33:49 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonevaluate;

use strict;
use Apache::lonnet;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonenc();
use LONCAPA();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    &Apache::loncommon::no_cache($r);
    
    $r->send_http_header;
    return OK if $r->header_only;

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['postdata']);
    my $feedurl=$env{'form.postdata'};
    $feedurl=~s/^http\:\/\///;
    $feedurl=~s/^$ENV{'SERVER_NAME'}//;
    $feedurl=~s/^$ENV{'HTTP_HOST'}//;

    $feedurl=&Apache::lonnet::declutter($feedurl);

    my $title=&Apache::lonnet::gettitle($feedurl);
    my $showurl=&Apache::lonenc::check_encrypt($feedurl);

    my ($rdomain,$rauth)=($feedurl=~/^($LONCAPA::domain_re)\/($LONCAPA::username_re)\//);

    my $prefix=$env{'user.name'}.'@'.$env{'user.domain'}.'___'.
	$feedurl.'___';

    my @items=('correct','helpful','depth','clear','technical','comments',
               'timestamp');

    my @retrieve=map{ $prefix.$_ } @items;

    my %currenteval=
       &Apache::lonnet::get('nohist_resevaldata',\@retrieve,$rdomain,$rauth);

    my $already=($currenteval{$prefix.'timestamp'} ne '');

    $env{'form.timestamp'}=time;

    my $warning='';

    if ($env{'form.submiteval'} eq 'true') {
# ------------------------------------------------ User is submitting something
        my $complete=1;
	foreach my $item (@items) {
	    if ($env{'form.'.$item}) {
		$currenteval{$prefix.$item}=$env{'form.'.$item};
            } elsif ($item ne 'comments') {
                $complete=0;
            }
        }
        if ($complete) {
	    my $showurl=&Apache::lonenc::check_encrypt(&Apache::lonnet::clutter($feedurl));
	    my $js =<<ENDJS;
<script type="text/javascript">
    function goback() {
	if ((window.name=='loncapaclient')) {
            window.location='$showurl';
        } else {
            self.close();
        }
    }
</script>
ENDJS

            my $start_page = 
	        &Apache::loncommon::start_page('Evaluate Resource',$js);
	    $r->print(<<ENDHEADER);
$start_page
<h1>Thank you for your input!</h1>
ENDHEADER
       $r->print('Saving feedback: '.
           &Apache::lonnet::put('nohist_resevaldata',\%currenteval,$rdomain,$rauth));
           unless ($already) {
	       $r->print('<br />Logging first evaluation');
           }
           $r->print(
            '<script type="text/javascript">setTimeout("goback()",2000);</script>'.&Apache::loncommon::end_page());
           return OK;
        } else {
	    $warning='Please fill out all fields below';
        }
   
    }

# ---------------------------------------------------------- Dial in old values
    my $dialold='';
    my $oldcomments='';

    foreach my $item (@items) {
       unless ($item eq 'comments') {
           unless (($item eq 'timestamp') || 
                   (!defined($currenteval{$prefix.$item}))) {
              $dialold.=
                   'document.evaluation.'.$item.'.selectedIndex='.
                   $currenteval{$prefix.$item}.";\n";
	   }
       } else {
           $oldcomments=$currenteval{$prefix.$item};
       }       
    }
# ------------------------------------------------------- Print out eval screen
    my $standardoptions=(<<ENDOPTIONS);
<option value="0">-</option>
<option value="1">Strongly Disagree</option>
<option value="2">Disagree</option>
<option value="3">Neutral</option>
<option value="4">Agree</option>
<option value="5">Strongly Agree</option>
ENDOPTIONS
    
    my $start_page = &Apache::loncommon::start_page('Evaluate Resource');
    my $end_page   = &Apache::loncommon::end_page();
    $r->print(<<ENDDOCUMENT);
$start_page
<tt>$title</tt><br /><br />
<h3><font color="red">$warning</font></h3>
Please rank the following criteria:
<form method="post" name="evaluation" action="/adm/evaluate">
<input type="hidden" name="submiteval" value="true" />
<input type="hidden" name="postdata" value="$showurl" />
The material appears to be correct
<br /><select name="correct">
$standardoptions
</select>
<hr />
The material is helpful
<br /><select name="helpful">
$standardoptions
</select>
<hr />
The material is covered with sufficient depth
<br /><select name="depth">
$standardoptions
</select>
<hr />
The material is presented in a clear way
<br /><select name="clear">
$standardoptions
</select>
<hr />
The resource is technically correct 
(loads fast enough, does not produce errors, links work, etc) 
<br /><select name="technical">
$standardoptions
</select>
<hr />
Any comments?
<br /><textarea name="comments" cols="40" rows="5">$oldcomments</textarea>
<script type="text/javascript">$dialold</script>
<br /><input type="submit" value="Submit Evaluation" />
</form>
$end_page
ENDDOCUMENT
    return OK;
} 

1;
__END__
