# The LearningOnline Network with CAPA
# Localization handler
#
# $Id: lonlocalize.pm,v 1.1 2006/04/07 22:03:55 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################

=pod

=head1 NAME

Apache::lonlocalize - handler to localize html files

=head1 SYNOPSIS

When fed a URL it will replace instances of MT{text} with the result of 
&mt(text)


=cut

package Apache::lonlocalize;

use strict;
use Apache::Constants qw(:common);
use Apache::lonlocal;

# ----------------------------------------------- Handler Routine /adm/localize
sub handler {
    my $r=shift;
    &Apache::lonlocal::get_language_handle($r);
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    my $uri=$r->uri;
    $uri=~s/^\/adm\/localize//;
    my $fn=$Apache::lonnet::perlvar{'lonDocRoot'}.$uri;

    my $file=&Apache::lonnet::getfile($fn);
    &Apache::lonlocal::transstatic(\$file);
    $r->print($file);
    return OK;
}

1;

__END__
