/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.util.Enumeration;
import org.jmol.applet.JmolAppletRegistry;
import org.jmol.g3d.Graphics3D;

public class JmolAppletControl
extends Applet {
    private static final String[][] parameterInfo = new String[][]{{"foo", "bar,baz,biz", "the description"}};
    private static final int typeChimePush = 0;
    private static final int typeChimeToggle = 1;
    private static final int typeChimeRadio = 2;
    private static final int typeButton = 3;
    private static final int typeCheckbox = 4;
    private static final int typeImmediate = 5;
    private static final String[] typeNames = new String[]{"chimepush", "chimetoggle", "chimeradio", "button", "checkbox", "immediate"};
    String myName;
    boolean mayScript;
    JmolAppletRegistry appletRegistry;
    AppletContext context;
    String targetName;
    String typeName;
    int type;
    int width;
    int height;
    Color colorBackground;
    Color colorForeground;
    String script;
    String label;
    String altScript;
    String buttonCallback;
    String groupName;
    boolean toggleState;
    Button awtButton;
    Checkbox awtCheckbox;
    Component myControl;

    public String getAppletInfo() {
        return "JmolAppletControl ... see jmol.sourceforge.net";
    }

    public String[][] getParameterInfo() {
        return parameterInfo;
    }

    private String getParam(String paramName) {
        String value = this.getParameter(paramName);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    private String getParamLowerCase(String paramName) {
        String value = this.getParameter(paramName);
        if (value != null && (value = value.trim().toLowerCase()).length() == 0) {
            value = null;
        }
        return value;
    }

    public void init() {
        this.context = this.getAppletContext();
        this.myName = this.getParam("name");
        this.mayScript = this.getParameter("mayscript") != null;
        this.appletRegistry = new JmolAppletRegistry(this.myName, this.mayScript, this);
        this.targetName = this.getParam("target");
        this.typeName = this.getParamLowerCase("type");
        this.type = typeNames.length;
        while (--this.type >= 0 && !typeNames[this.type].equals(this.typeName)) {
        }
        this.groupName = this.getParamLowerCase("group");
        String buttonState = this.getParamLowerCase("state");
        this.toggleState = buttonState != null && (buttonState.equals("on") || buttonState.equals("true") || buttonState.equals("pushed") || buttonState.equals("checked") || buttonState.equals("1"));
        this.label = this.getParameter("label");
        this.script = this.getParam("script");
        this.altScript = this.getParam("altScript");
        try {
            this.width = Integer.parseInt(this.getParam("width"));
            this.height = Integer.parseInt(this.getParam("height"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String colorName = this.getParam("bgcolor");
        this.setBackground(colorName == null ? Color.white : Graphics3D.getColorFromString(colorName));
        colorName = this.getParam("fgcolor");
        this.setForeground(colorName == null ? Color.black : Graphics3D.getColorFromString(colorName));
        this.buttonCallback = this.getParam("buttoncallback");
        this.setLayout(new GridLayout(1, 1));
        this.add(this.allocateControl());
        this.logWarnings();
        if (this.type == 5) {
            this.runScript();
        }
    }

    public boolean action(Event e, Object what) {
        switch (this.type) {
            case 1: {
                this.toggleState = !this.toggleState;
                this.awtButton.setLabel(this.toggleState ? "X" : "");
            }
            case 0: 
            case 3: 
            case 5: {
                this.runScript();
                break;
            }
            case 2: {
                if (this.toggleState) break;
                this.notifyRadioPeers();
                this.toggleState = true;
                this.awtButton.setLabel("X");
                this.runScript();
                break;
            }
            case 4: {
                if (this.toggleState == this.awtCheckbox.getState()) break;
                if (!this.toggleState && this.groupName != null) {
                    this.notifyRadioPeers();
                }
                this.toggleState = !this.toggleState;
                this.runScript();
            }
        }
        return true;
    }

    private void logWarnings() {
        if (this.targetName == null) {
            System.out.println(this.typeName + " with no target?");
        }
        if (this.type == -1) {
            System.out.println("unrecognized control type:" + this.typeName);
        }
        if (this.type == 2 && this.groupName == null) {
            System.out.println("chimeRadio with no group name?");
        }
        if (this.script == null) {
            System.out.println("control with no script?");
        }
        if (this.type == 1 && this.altScript == null) {
            System.out.println("chimeToggle with no altScript?");
        }
    }

    private Component allocateControl() {
        switch (this.type) {
            case 0: {
                this.label = "X";
            }
            case 3: {
                this.toggleState = true;
                this.awtButton = new Button(this.label);
                return this.awtButton;
            }
            case 1: 
            case 2: {
                this.awtButton = new Button(this.toggleState ? "X" : "");
                return this.awtButton;
            }
            case 4: {
                this.awtCheckbox = new Checkbox(this.label, this.toggleState);
                return this.awtCheckbox;
            }
            case 5: {
                this.toggleState = true;
                this.awtButton = new Button("immediate");
                return this.awtButton;
            }
        }
        return new Button("?");
    }

    private void notifyRadio(String radioGroupName) {
        if (this.type != 2 && this.type != 4 || radioGroupName == null || !radioGroupName.equals(this.groupName)) {
            return;
        }
        if (this.toggleState) {
            this.toggleState = false;
            if (this.type == 2) {
                this.awtButton.setLabel("");
            } else {
                this.awtCheckbox.setState(false);
            }
            this.runScript();
        }
    }

    private void notifyRadioPeers() {
        Enumeration e = this.appletRegistry.applets();
        while (e.hasMoreElements()) {
            Object peer = e.nextElement();
            if (!(peer instanceof JmolAppletControl)) continue;
            JmolAppletControl controlPeer = (JmolAppletControl)peer;
            controlPeer.notifyRadio(this.groupName);
        }
    }

    private void runScript() {
        String scriptToRun;
        String string = scriptToRun = this.toggleState ? this.script : this.altScript;
        if (scriptToRun == null) {
            return;
        }
        if (this.targetName == null) {
            System.out.println(this.typeName + " with name" + this.myName + " has no target?");
            return;
        }
        this.appletRegistry.scriptButton(this.targetName, scriptToRun, this.buttonCallback);
    }
}

