/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Shape;

class Balls
extends Shape {
    static final int minimumPixelSelectionRadius = 4;

    Balls() {
    }

    void setSize(int size, BitSet bsSelected) {
        short mad = (short)size;
        Atom[] atoms = this.frame.atoms;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            if (!bsSelected.get(i)) continue;
            atoms[i].setMadAtom(mad);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        int atomCount = this.frame.atomCount;
        Atom[] atoms = this.frame.atoms;
        if ("color" == propertyName) {
            short colix = this.g3d.getColix(value);
            int i = atomCount;
            while (--i >= 0) {
                if (!bs.get(i)) continue;
                atoms[i].setColixAtom(colix);
            }
            return;
        }
        if ("colorScheme" == propertyName) {
            if (value != null) {
                byte palette = this.viewer.getPalette((String)value);
                int i = atomCount;
                while (--i >= 0) {
                    Atom atom = atoms[i];
                    if (!bs.get(i)) continue;
                    atom.setColixAtom(this.viewer.getColixAtomPalette(atom, palette));
                }
            }
            return;
        }
    }

    void findNearestAtomIndex(int x, int y, Closest closest) {
        if (this.frame.atomCount == 0) {
            return;
        }
        Atom champion = null;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom contender = this.frame.atoms[i];
            if (!contender.isCursorOnTopOfVisibleAtom(x, y, 4, champion)) continue;
            champion = contender;
        }
        closest.atom = champion;
    }
}

