# The LearningOnline Network
# URL translation for encrypted filenames
#
# $Id: lonencurl.pm,v 1.3 2006/12/05 02:55:56 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonencurl;

use strict;
use Apache::Constants qw(:common :remotehost);
use CGI::Cookie();
use Apache::lonnet;
use Apache::lonenc;

sub handler {
    my $r = shift;
    my %cookies=CGI::Cookie->parse($r->header_in('Cookie'));
    my $lonid=$cookies{'lonID'};
    my $cookie;
    if ($lonid) {
	my $handle=&LONCAPA::clean_handle($lonid->value);
        my $lonidsdir=$r->dir_config('lonIDsDir');
	$env{'request.enc'}=1;
        if ((-e "$lonidsdir/$handle.id") && ($handle ne '')) {
# Initialize Environment
            &Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);
# Decrypt URL and redirect
	    my $redirect=&Apache::lonenc::unencrypted($r->uri);
	    if ($r->args) { $redirect.='?'.$r->args; }
	    $r->internal_redirect($redirect);
	    return OK;
	} 
    }
    return FORBIDDEN;
}

1;
__END__
