# The LearningOnline Network with CAPA
# essay (ungraded) style responses
#
# $Id: essayresponse.pm,v 1.83 2007/08/10 20:09:30 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::essayresponse;
use strict;
use Apache::lonxml();
use Apache::lonnet;
use Apache::lonlocal;
use LONCAPA;
 

BEGIN {
    &Apache::lonxml::register('Apache::essayresponse',('essayresponse'));
}

sub start_essayresponse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    my $id = &Apache::response::start_response($parstack,$safeeval);
    if ($target eq 'meta') {
	$result=&Apache::response::meta_package_write('essayresponse');
    } elsif ($target eq 'web' &&
	     $Apache::inputtags::status[-1] eq 'CAN_ANSWER') {
	my $part= $Apache::inputtags::part;
	my $ncol= &Apache::lonnet::EXT("resource.$part".'_'."$id.maxcollaborators");
	my $coll= &HTML::Entities::encode($Apache::lonhomework::history{"resource.$part.$id.collaborators"},'<>&"');
	my $uploadedfiletypes= &Apache::lonnet::EXT("resource.$part".'_'."$id.uploadedfiletypes");
        $uploadedfiletypes=~s/[^\w\,]//g;
	if ( $Apache::lonhomework::type eq 'survey' ) {
	    $result.= '<input type="hidden" name="HWDRAFT'.$part.'_'.$id.'" value="yes" /> ';
	}
	$result.='<br /><table border="1">';
	if ( $Apache::lonhomework::type ne 'survey' ) {
	    $result.= '<tr><td>'.
		'<label>'.
		'<input type="radio" name="HWDRAFT'.$part.'_'.$id.'" value="yes" checked="checked" /> '.
		&mt('Submit entries below as answer to receive credit').
		'</label> <br />'.
		'<label>'.
		'<input type="radio" name="HWDRAFT'.$part.'_'.$id.'" value="no" /> '.
		&mt('Save entries below as a draft answer (not submitting them for credit yet)').
		'</label>'.
		'</td></tr>';
	}

	if ($ncol > 0) {
	    $result .='<tr><td>'.'<label>'.
		'Collaborators: <input type="text" size="70" max="80" name="HWCOL'.
		$part.'_'.$id.'" value="'.$coll.'" /><br />'.
		&mt('(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',$ncol,$env{'user.domain'}).
                '</label><br />';
	    $result .= &check_collaborators($ncol,$coll) if ($coll =~ /\w+/);
	    $result .='</td></tr>';
	}
	$result.=&Apache::inputtags::file_selector($part,$id,
						   $uploadedfiletypes,'both');
        $result.='</table>';
    } elsif ($target eq 'web' &&
	     $Apache::inputtags::status[-1] ne 'CAN_ANSWER') {
	my $part= $Apache::inputtags::part;
	my @msgs;
	if ($Apache::lonhomework::history{"resource.$part.$id.collaborators"} =~ /\S/) {
	    my $coll= &HTML::Entities::encode($Apache::lonhomework::history{"resource.$part.$id.collaborators"},'<>&"');
	    $result .= '<td>'.&mt('Collaborated with [_1]',$coll).'</td>';
	}

	my $file_submission = 
	    &Apache::inputtags::show_past_file_submission($part,$id);
	if ($file_submission) {
	    $result .= '<td>'.$file_submission.'</td>';
	}

	my $port_submission = 
	    &Apache::inputtags::show_past_portfile_submission($part,$id);
	if ($port_submission) {
	    $result .= '<td>'.$port_submission.'</td>';
	}

	if ($result ne '') {
	    $result = 
		'<table class="LC_pastsubmission"><tr>'.$result.
		'</tr></table>';
	}
    }
    return $result;
}

sub end_essayresponse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $part          = $Apache::inputtags::part;
    my $id            = $Apache::inputtags::response[-1];
    my $increment     = &Apache::response::repetition();
    my $result;
    if ( $target eq 'grade' ) {
	my $collaborators = $env{'form.HWCOL'.$part.'_'.$id};	
	if ($collaborators =~ /[^\s]/) {
	    my $previous_list= &HTML::Entities::encode($Apache::lonhomework::history{"resource.$part.$id.collaborators"},'<>&"');
	    $Apache::lonhomework::results{"resource.$part.$id.collaborators"}=$collaborators
		if ($collaborators ne $previous_list);
	}
	if (  &Apache::response::submitted('scantron') ) {
	    $increment=&Apache::response::scored_response($part,$id);
	} elsif ( &Apache::response::submitted() ) {
	    my $response      = $env{'form.HWVAL_'.$id};
            my $filename= $env{'form.HWFILE'.$part.'_'.$id.'.filename'};
            my $portfiles = $env{'form.HWPORT'.$part.'_'.$id};
	    if (( $response =~ /[^\s]/) || ($filename =~ /[^\s]/) || ($portfiles =~ /[^\s]/)) {
 		my $award='DRAFT';
        	if ($env{'form.HWDRAFT'.$part.'_'.$id} eq 'yes') {
		    $award='SUBMITTED';
		}
                my $uploadedflag=0;
		&file_submission($part,$id,'filename',\$award,\$uploadedflag);
		&file_submission($part,$id,'portfiles',\$award,\$uploadedflag);
		$Apache::lonhomework::results{"resource.$part.$id.submission"}=$response;
		$Apache::lonhomework::results{"resource.$part.$id.awarddetail"}=$award;
		my %previous=&Apache::response::check_for_previous($response,$part,$id);
		unless ($uploadedflag) { &Apache::response::handle_previous(\%previous,$award); }
#
# Store with resource author for similarity testing
#
                if ($award eq 'SUBMITTED') {
		    my ($symb,$crsid,$domain,$name)=
			&Apache::lonnet::whichuser();
		    if ($crsid) {
			my $akey=join('.',&escape($name),&escape($domain),
				      &escape($crsid));
			my $essayurl=
			    &Apache::lonnet::declutter($ENV{'REQUEST_URI'});
			my ($adom,$aname,$apath)=
			    ($essayurl=~/^($LONCAPA::domain_re)\/($LONCAPA::username_re)\/(.*)$/);
                        $apath=&escape($apath);
			$apath=~s/\W/\_/gs;
			&Apache::lonnet::put('nohist_essay_'.$apath,
					 { $akey => $response },$adom,$aname);
		    }
                }
	    }
	} 
    } elsif ($target eq 'edit') {
	$result.=&Apache::edit::end_table();

    } elsif ($target eq 'tex'
	     && $Apache::lonhomework::type eq 'exam') {
	$result .= &Apache::inputtags::exam_score_line($target);

    } elsif ($target eq 'answer') {
	$result.=&Apache::response::answer_header($$tagstack[-1]);
	my $answer = &mt('Essay will be hand graded.');
	$result.=&Apache::response::answer_part($$tagstack[-1],$answer,
						{'no_verbatim' => 1});
	$result.=&Apache::response::answer_footer($$tagstack[-1]);
    }
    if ($target eq 'web') {
	&Apache::response::setup_prior_tries_hash(\&format_prior_response,
						  ['portfiles',
						   'uploadedurl']);
    }

    if ($target eq 'grade' || $target eq 'web' || $target eq 'answer' ||
	$target eq 'tex' || $target eq 'analyze') {
	&Apache::lonxml::increment_counter($increment);
    }
    &Apache::response::end_response;

    return $result;
}

sub format_prior_response {
    my ($mode,$answer,$other_data) = @_;
    my $output;

    my (undef,undef,$udom,$uname) = &Apache::lonnet::whichuser();
    my $port_url = '/uploaded/'.$udom.'/'.$uname.'/portfolio/';

    my $file_list;

    foreach my $file (split(/\s*,\s*/,
			    $other_data->[0].','.$other_data->[1])) {
	next if ($file!~/\S/);
	if ($file !~ m{^/uploaded/}) { $file=$port_url.$file; }
	$file=~s|/+|/|g;
	&Apache::lonnet::allowuploaded('/adm/essayresponse',$file);
	$file_list.='<li><span class="LC_nobreak"><a href="'.$file.'?rawmode=1" target="lonGRDs"><img src="'.
	    &Apache::loncommon::icon($file).'" alt="file icon" border="0" /> '.$file.
	    '</a></span></li>'."\n";
    }
    if ($file_list) {
	$output.= &mt('Submitted Files').'<ul>'.$file_list.'</ul>';
    }
    if ($answer =~ /\S/) {
	$output.='<p>'.&mt('Submitted text').
	    '<blockquote>'.$answer.'</blockquote></p>';
    }

    return '<div class="LC_prior_essay">'.$output.'</div>';
}

sub file_submission {
    my ($part,$id,$which,$award,$uploadedflag)=@_;
    my $files;
    my $jspart=$part;
    $jspart=~s/\./_/g;
    if ($which eq 'portfiles') { $files= $env{'form.HWPORT'.$jspart.'_'.$id}; }
    if ($which eq 'filename') {
	$files = $env{'form.HWFILE'.$jspart.'_'.$id.'.filename'};
    }
    
    if ($files =~ /[^\s]/) {
	$files =~s/,$//;
	$Apache::lonhomework::results{"resource.$part.$id.$which"}=$files;
	
	my @submitted_files = ($files);
	if ( $which eq 'portfiles' ) {
	    @submitted_files = split(/\s*,\s*/,$files);
	}

	my $uploadedfiletypes= &Apache::lonnet::EXT("resource.$part".'_'."$id.uploadedfiletypes");
	if ($uploadedfiletypes) {
	    $uploadedfiletypes=~s/[^\w\,]//g;
	    $uploadedfiletypes=','.$uploadedfiletypes.',';
	    foreach my $file (@submitted_files) {
		my ($extension)=($file=~/\.(\w+)$/);
		unless ($uploadedfiletypes=~/\,$extension\,/i) {
		    $$award='INVALID_FILETYPE';
		}
	    }
	}
	if ($$award ne 'INVALID_FILETYPE' && ref($uploadedflag)) {
	    $$uploadedflag=1;
	}
	if ($$award ne 'INVALID_FILETYPE' && $which eq 'portfiles') {
	    my ($symb,$crsid,$domain,$name)=&Apache::lonnet::whichuser();
	    &Apache::lonnet::unmark_as_readonly($domain,$name,[$symb,$crsid]);
	    &Apache::lonnet::mark_as_readonly($domain,$name,\@submitted_files,[$symb,$crsid]);
	    &Apache::lonnet::clear_selected_files($name);
	}
	if ($$award ne 'INVALID_FILETYPE' && $which eq 'filename') {
	    $Apache::lonhomework::results{"resource.$part.$id.uploadedfile"}=
		$files;
	    $Apache::lonhomework::results{"resource.$part.$id.uploadedurl"}=
		&Apache::lonnet::userfileupload('HWFILE'.$jspart.'_'.$id,undef,
						'essayresponse');
	}
    } elsif ($which eq 'portfiles' &&
	     $Apache::lonhomework::history{"resource.$part.$id.$which"}) {
	my ($symb,$crsid,$domain,$name)=&Apache::lonnet::whichuser();
	&Apache::lonnet::unmark_as_readonly($domain,$name,[$symb,$crsid]);
	$Apache::lonhomework::results{"resource.$part.$id.$which"}="";
    }
}

sub check_collaborators {
    my ($ncol,$coll) = @_;
    my %classlist=&Apache::lonnet::dump('classlist',
					$env{'course.'.$env{'request.course.id'}.'.domain'},
					$env{'course.'.$env{'request.course.id'}.'.num'});
    my (@badcollaborators,$result);
    my (@collaborators) = split(/\,?\s+/,$coll);
    foreach (@collaborators) {
	my $collaborator = $_;
	if (/@/) {
	    $collaborator =~ s/@/:/;
	} else {
	    $collaborator = $_.':'.$env{'user.domain'};
	}
	push @badcollaborators, $_ if (!grep /^$collaborator/i,keys %classlist);
    }
    
    if (scalar(@badcollaborators)) {
	$result = '<table border="0"><tr bgcolor="#ffbbbb"><td> The following user'.
	    (scalar(@badcollaborators) > 1 ? 's are' : ' is').' invalid: '.
	    join(', ',@badcollaborators).'. Please correct.</td></tr></table>';
    }
    my $toomany = scalar(@collaborators) - $ncol;
    if ($toomany > 0) {
	$result .= '<table border="0"><tr bgcolor="#ffbbbb"><td>'.
	    'You have too many collaborators. Please remove '.$toomany.' collaborator'.
	    ($toomany > 1 ? 's' :'').'.</td></tr></table>';
    }
    return $result;
}

1;
__END__
