# The LearningOnline Network
# Pick a student from the classlist
#
# $Id: lonpickstudent.pm,v 1.23 2007/08/10 23:20:09 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonpickstudent;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::loncoursedata;
use Apache::lonnet;
use Apache::lonlocal;
use Apache::longroup;
use LONCAPA;

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

# ------------------------------------------------------------ Print the screen
    $r->print(&Apache::loncommon::start_page("Selecting a User",undef,
					     {'no_nav_bar' => 1}));


    &Apache::loncommon::get_unprocessed_cgi
        ($ENV{'QUERY_STRING'},['filter','form','unameelement','udomelement',
			       'roles']);
# Allowed?
    my $allowed;
    my $scope = $env{'request.course.id'};
    if (!($allowed = &Apache::lonnet::allowed('srm',$scope))) {
	$scope .= '/'.$env{'request.course.sec'};
	$allowed = &Apache::lonnet::allowed('srm',$scope);
	if ($allowed) { $allowed = 'section';	}
    }

    unless (($env{'form.roles'}) ||
            (($env{'request.course.id'}) && ($allowed))) {
	$r->print(&mt('No context.').
		  &Apache::loncommon::end_page());
        return OK;
    }

# See if filter present
    my $filter=$env{'form.filter'};
    my $filtermsg;
    my $encoded_filter = &HTML::Entities::encode($filter,'<>&"');
    $filter = quotemeta($filter);
    my $change = &mt('Change');
    my $filterbutton =<<FILTER;
  <input type="text" name="filter" value="$encoded_filter" />
  <input type="submit" name="Change" value="$change" />
FILTER
    foreach my $name ('form','unameelement','udomelement','roles') {
	my $value = &HTML::Entities::encode($env{"form.$name"},'<>&"');
	$filterbutton .= <<HIDDEN;
   <input type="hidden" name="$name" value="$value" />
HIDDEN
    }
    $filtermsg = '<br />'.
	&mt('Showing users with a name starting with [_1]',
	    $filterbutton).'<br />';
    if ($filter eq '') {
	$filter = '.'
    }

    my $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    my $cnum = $env{'course.'.$env{'request.course.id'}.'.num'};
    my $classlist=&Apache::loncoursedata::get_classlist();
    my %grouplist=&Apache::lonnet::get_group_membership($cdom,$cnum);
    my $now = time;
    my %allgroups = &Apache::longroup::coursegroups($cdom,$cnum);

# --------------------------------------- There is such a user, get environment

    $r->print(<<ENDSCRIPT);
<script type="text/javascript">
function gochoose(uname,udom) {
    opener.document.$env{'form.form'}.$env{'form.unameelement'}.value=uname;
    var slct=opener.document.$env{'form.form'}.$env{'form.udomelement'};
    var i;
    for (i=0;i<slct.length;i++) {
        if (slct.options[i].value==udom) { slct.selectedIndex=i; }
    }
    self.close();
}
</script>
ENDSCRIPT

    $r->print('<form>');
    if ($allowed && (!$env{'form.roles'})) {
# -------------------------------------------------------- Get course personnel
	$r->print('<h3>'.$env{'course.'.$env{'request.course.id'}.'.description'}.
		  '</h3>');
	my %coursepersonnel=
	    &Apache::lonnet::get_course_adv_roles();
	$r->print(&Apache::loncommon::start_data_table());
	foreach my $role (sort(keys(%coursepersonnel))) {
	    foreach my $user (split(/\,/,$coursepersonnel{$role})) {
		my ($puname,$pudom)=split(/\:/,$user);
		$role = &Apache::lonnet::plaintext($role,
						   &Apache::loncommon::course_type());
		$r->print(&Apache::loncommon::start_data_table_row().
			  '<td>'.
			  '<input type="button" value="Select" onClick="gochoose('.
			  "'".$puname."','".$pudom."')".'" /></td><td>'.$role.'</td><td>'.
			  &Apache::loncommon::aboutmewrapper(&Apache::loncommon::plainname($puname,$pudom),$puname,$pudom).'</td>'.
			  &Apache::loncommon::end_data_table_row());
	    }
	}
	$r->print(&Apache::loncommon::end_data_table().'<p>&nbsp;');

	$r->print($filtermsg);

	$r->print('</p>');

# ------------------------------------------------------------------ Students
	my $result;
	foreach my $user (sort(keys(%$classlist))) {
	    # the following undefs are for 'domain', and 'username' respectively.
	    my (undef,undef,$end,$start,$id,$section,$fullname,$status)=
		@{$classlist->{$user}};
	    if ($allowed eq 'section' && $section ne $env{'request.course.sec'}) {
		next;
	    }
	    if ($user=~/^($LONCAPA::username_re)\:($LONCAPA::domain_re)$/) {
		my ($uname,$udom)=($1,$2);
		if (($uname=~/^$filter/) || 
		    ($fullname=~/^$filter/i)) {
		    my $grouplist = '';
		    foreach my $group (sort(keys(%allgroups))) {
			if (exists($grouplist{$group.':'.$uname.':'.$udom})) {
			    my ($end,$start) = split(/:/,$grouplist{$group.':'.$uname.':'.$udom});
			    if (($end!=0) && ($end<$now)) { next; }
			    if (($start!=0) && ($start>$now)) {next; }
			    $grouplist .= " $group,"; 
			}
		    }
		    $grouplist =~ s/,$//;
		    $result .=&Apache::loncommon::start_data_table_row().
			      '<td>'.
			      '<input type="button" value="'.&mt('Select').'" onClick="gochoose('.
			      "'".$uname."','".$udom."')".'" /></td>'.
			      '<td><tt>'.$uname.'</tt></td><td> <tt>'.$udom.
			      '</tt></td><td>'.
			      &Apache::loncommon::aboutmewrapper($fullname,
								 $uname,$udom).
			      '</td><td>'.$id.'</td><td>'.$section.
			      '</td><td>'.$grouplist.'</td>'.
			      &Apache::loncommon::end_data_table_row();
		}
	    }
	}
	if (!$result) {
	    $r->print('<p>'.&mt('No students found.').'</p>');
	} else {
	    $r->print(&Apache::loncommon::start_data_table().
		      &Apache::loncommon::start_data_table_header_row().
		      &Apache::loncommon::end_data_table_header_row().
		      '<th>&nbsp;</th>'.
		      '<th>'.&mt('username').'</th>'.
		      '<th>'.&mt('domain').'</th>'.
		      '<th>'.&mt('Name').'</th>'.
		      '<th>'.&mt('ID').'</th>'.
		      '<th>'.&mt('section').'</th>'.
		      '<th>'.&mt('active group(s)').'</th>'.
		      &Apache::loncommon::end_data_table_header_row().
		      $result.
		      &Apache::loncommon::end_data_table());
	}
    } else {
	$r->print('<h3>'.&mt('Users with Roles Assigned by').' '.
		  &Apache::loncommon::plainname($env{'user.name'},
						$env{'user.domain'}).'</h3>');
	$r->print($filtermsg);

	$r->print('<p>'.&Apache::loncommon::start_data_table());
	my %user_role=&Apache::lonnet::get_my_roles();
	my %users;
	foreach my $user_role (keys(%user_role)) {
	    next if ($user_role !~
		     /^($LONCAPA::username_re):($LONCAPA::domain_re):(\w+)$/);
	    my ($uname,$udom,$urole)=($1,$2,$3);
	    my $fullname=&Apache::loncommon::plainname($uname,$udom);
	    next if (($uname!~/^$filter/i) && ($fullname=~/^$filter/i));
	    
	    if (!exists($users{"$uname:$udom"})) {
		$users{"$uname:$udom"} = {'fullname' => $fullname };
	    }
	    push(@{$users{"$uname:$udom"}{'roles'}},$urole);
	}
	foreach my $user (sort {lc($a) cmp lc($b)} (keys(%users))) {
	    my ($uname,$udom) = split(':',$user);
	    $r->print(&Apache::loncommon::start_data_table_row().
		      '<td>'.
		      '<input type="button" value="Select" onClick="gochoose('.
		      "'".$uname."','".$udom."')".'" /></td>'.
		      '<td><tt>'.$uname.'</tt></td>'.
		      '<td><tt>'.$udom.'</tt></td><td>'.
		      &Apache::loncommon::aboutmewrapper($users{$user}{'fullname'},
							 $uname,$udom).'</td>'.
		      '<td>'.
		      join(', ',sort(map {&Apache::lonnet::plaintext($_)}
				         (@{$users{$user}{'roles'}}))).
		      '</td>'.
		      &Apache::loncommon::end_data_table_row());
	}
	$r->print(&Apache::loncommon::end_data_table().'</p>');
    }
    $r->print('</form>'.&Apache::loncommon::end_page());
    return OK;
} 

1;
__END__
