# The LearningOnline Network with CAPA
# German Localization Lexicon
#
# $Id: de.pm,v 1.94 2007/08/06 10:35:10 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::de;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,
          
'char_encoding'=> 'ISO-8859-1',
'language_code'=> 'de',
'date_locale'  => 
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds Uhr',
'date_months'  => 'Jan,Febr,Mrz,April,Mai,Juni,Juli,Aug,Sept,Okt,Nov,Dez',
'date_days'    => 'So,Mo,Di,Mi,Do,Fr,Sa',
'date_am' => 'vormittags',
'date_pm' => 'nachmittags',
'htmlarea_lang' => 'de',
'spellcheck_lang' => 'de',

   'Domain'
=> 'Domne',

   'Server'
=> 'Server',

   'Load'
=> 'Serverlast',

   'User Load'
=> 'Nutzerlast',

   'Help'
=> 'Hilfe',

   'Log in'
=> 'Anmelden',

   'Username'
=> 'Benutzername',

   'Password'
=> 'Passwort',

   'choose'
=> 'whle',

   'enter'
=> 'eingeben',

   'view'
=> 'sehe',

   'calendar'
=> 'Kalender',

   'prefer-'
=> 'Prfe-',

   'ences'
=> 'renzen',

   'role'
=> 'Rolle',

   'course'
=> 'Kurs',

   'Course'
=> 'Kurs',

   'Section/Group'
=> 'Sektion/Gruppe',

   'today'
=> 'heute',

   'last week'
=> 'letzte Woche',

   'last month'
=> 'letzten Monat',

   'last three months'
=> 'letzte drei Monate',

   'last six months'
=> 'letzte sechs Monate',

   'last year'
=> 'letztes Jahr',

   'Submit'
=> 'Abschicken',

   'Rename'
=> 'Umbenennen',

   'Save'
=> 'Speichern',

   'Done'
=> 'Fertig',

   'Select User'
=> 'Benutzer auswhlen',

   'Select Course'
=> 'Kurs auswhlen',

   'Changes will become active for your current session after'
=> 'nderungen werden fr Ihre derzeitige Sitzung aktiv, nachdem Sie',

   're-initializing course'
=> 'Kurs neu initialisieren',

   ', or the next time you log in.'
=> 'haben, oder wenn Sie sich das nchste Mal anmelden.',

   'Uploaded Document'
=> 'Hochgeladenes Dokument',

   'No content modifications yet.'
=> 'Noch keine Inhaltsnderungen.',

   'Part is not open to be viewed. It'
=> 'Aufgabenteil nicht verfgbar. Er',

'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Aufgrund von Netzwerkproblemen kann nicht festgestellt werden, ob diese Ressource verfgbar ist. Bitte versuchen Sie es spter noch einmal.',

'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Beachten Sie, dass es bis zu 10 Minuten dauern kann, bis nderungen fr alle Benutzer aktiv werden.',

   'Language'
=> 'Sprache',

   'Notes'
=> 'Notizen',

   'Abstract'
=> 'Beschreibung',
 
   'Create a user or modify the roles and privileges of a user'
# => 'Benutzeraccounts erstellen oder Benutzerrollen und -priviligien ndern',
=> 'Benutzeraccounts und Rechte verwalten',

   'View course assessment statistics'
=> 'Aufgabenstatistiken', #??? [SB 20.10.2006]

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Setzen von Deadlines und anderen Parametern zur Beurteilung sowie ndern der Kursumgebung',

   'New Folder'
=> 'Neues Verzeichnis',

   'Simple Page'
=> 'Einfache Seite',

   'Simple Problem'
=> 'Einfache Aufgabe',

   'Upload Document'
=> 'Dokument hochladen',

   'Search'
=> 'Suchen',

   'Import'
=> 'Importieren',

   'Main Course Documents'
=> 'Kursdokumente',

   'Supplemental Course Documents'
=> 'Zustzliche Kursdokumente',

   'Bulletin Board'
=> 'Schwarzes Brett',

   'Special Documents'
=> 'Spezielle Dokumente',

   'create'
=> 'erstelle',

   'grades'
=> 'Noten',

   'commu-'
=> 'Kommu-',

   'nication'
=> 'nikation',

   'enroll'
=> 'Kurs belegen',

   'navigate'
=> 'Inhalts-',

   'contents'
=> 'verzeich',

   'Navigate Contents'
=> 'Inhaltsverzeichnis',

   'Announcements and Calendar'
=> 'Bekanntmachungen und Kalender',

   'Author'
=> 'Autor',

   'Change Your Preferences'
=> 'ndern Ihrer Benutzerprferenzen',

   'Choose the user role'
=> 'Benutzerrolle wechseln',

   'Co-Author'
=> 'Co-Autor',

   'Communication and Messages'
=> 'Kommunikation und Nachrichten',

   'Course Coordinator'
=> 'Kurs-Koordinator',

   'Course Statistics and Charts'
=> 'Kursstatistiken und Notenbersicht',

   'Course announcements and my calendar'
# => 'Kursbekanntmachungen und mein Kalender',
=> 'Bekanntmachungen und Kalender',

   'Create Users, Change User Privileges'
# => 'Erstellen neuer Benutzeraccounts, ndern von Benutzerprivilegien',
  => 'Benutzeraccounts und Rechte verwalten',

   'Domain Coordinator'
=> 'Domnen-Koordinator',

   'Enrollment Manager'
=> 'Kursbelegungs-Verwaltung',

   'Enter grades from check-out assessment resources'
=> 'Eingeben von Bewertungen fr Beurteilungs-Ressourcen', #??? [SB 20.10.2006]

   'Exam Proctor'
=> 'Exam-Proktor', #??? [SB 20.10.2006]

   'Exit LON-CAPA'
=> 'Abmelden',

   'Grades Spreadsheet'
=> 'Spreadsheet mit Noten',

   'Grading'
=> 'Benotung',

   'Instructor'
=> 'Lehrender',

   'Launch Remote Control'
=> 'Fernbedienung aktivieren',

   'Main Menu'
=> 'Hauptmen',

   'Navigate Course Contents'
=> 'Inhaltsverzeichnis',

   'No Role, Cumulative Privileges'
=> 'Keine Rolle, kumulative Privilegien',

   'Return to Last Location'
=> 'Zurck zum zuletzt verwendeten Kursdokument',

   'Send and receive messages'
# => 'Verschicken und Empfangen von Nachrichten',
# => 'Interne Nachrichten verwalten',
=> 'Kommunikation und Nachrichten',

   'Set my user preferences'
=> 'Benutzereinstellungen',

   'Student'
=> 'Studierender',

   'Switch to another user role'
# => 'Andere Benutzerrolle whlen',
=> 'Benutzerrolle wechseln',

   'Teaching Assistant'
=> 'Tutor',

   'Use or edit my bookmark collection'
# => 'Meine Lesezeichen-Sammlung verwenden oder editieren',
=> 'Lesezeichen-Sammlung',

   'User Roles'
=> 'Benutzerrollen',

   'Calculate course grades (Spreadsheet)'
=> 'Noten berechnen (Spreadsheet)',

   'Enter the chatroom for the course'
=> 'Kurs-Chatroom',

   'Navigate the table of contents for this course'
=> 'Inhaltsverzeichnis des Kurses',

   'Syllabus'
=> 'Kursberblick',

   'View the course assessment progress chart'
=> 'Aufgabenfortschritt des Kurses',

   'Class Hours'
=> 'Vorlesungstermine',

   'Course Description'
=> 'Kurstitel',

   'Coursepack'
=> 'Kurspaket',

   'Current Month'
=> 'Dieser Monat',

   'Deadlines'
=> 'Flligkeitsdaten',

   'Fri'
=> 'Fr',

   'Grading Information'
=> 'Information zur Benotung',

   'Helproom Hours'
=> 'Hilfe',

   'Instructor Information'
=> 'Information ber die Lehrenden',

   'Mon'
=> 'Mo',

   'Next Month'
=> 'Nchster Monat',

   'Office Hours'
=> 'Sprechstunden',

   'Prerequisites'
=> 'Voraussetzungen',

   'Previous Month'
=> 'Letzter Monat',

   'Readings'
=> 'Material',

   'Sat'
=> 'Sa',

   'January'
=> 'Januar',

   'February'
=> 'Februar',

   'March'
=> 'Mrz',

   'April'
=> 'April',

   'May'
=> 'Mai',

   'June'
=> 'Juni',

   'August'
=> 'August',

   'September'
=> 'September',

   'October'
=> 'Oktober',

   'November'
=> 'November',

   'December'
=> 'Dezember',

   'Sun'
=> 'So',

   'Textbook'
=> 'Bcherliste',

   'Thu'
=> 'Do',

   'Tue'
=> 'Di',

   'Web Links'
=> 'Weblinks',

   'Wed'
=> 'Mi',

   'Drop/Add students in this course'
=> 'Einschreibungsliste verwalten',

   'You have entered that answer before'
=> 'Sie hatten diese Antwort bereits eingegeben',

   'A score has been assigned.'
=> 'Eine Note ist vergeben worden.',

   'You are correct.'
=> 'Korrekt!',

   'Your receipt is'
=> 'Ihr Nachweis ist',

   'You are excused from the problem.'
=> 'Die Aufgabe ist Ihnen erlassen worden.',

   'Incorrect'
=> 'Inkorrekt',

   'Some parts were not submitted.'
=> 'Einige Aufgabenteile sind nicht bearbeitet worden.',

   'An error occured while grading your answer.'
=> 'Whrend der Bewertung Ihrer Antwort ist ein Fehler aufgetreten.',

   'Due'
=> 'Fllig',

   'The submitted answer was too long.'
=> 'Ihre Antwort war zu lang.',

   'This question expects a numeric answer.'
=> 'Eine numerische Antwort ist gefragt.',

   'You have provided an invalid ranking'
=> 'Die eingebene Rangordnung ist ungltig.',

   'please refer to'
=> 'schauen Sie nach unter',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'Die Endung der von Ihnen eingereichten Datei ist nicht erlaubt.',

   'Units incorrect.'
=> 'Einheit inkorrekt.',

   'Only a number required.'
=> 'Als Eingabe ist nur eine Zahl zulssig.',

   'Units required'
=> 'Einheiten erwartet',

   'Unable to understand formula'
=> 'Die eingebene Formel kann nicht ausgewertet werden',

   'Your submission has been recorded.'
=> 'Ihre Antwort wurde gespeichert.',

   'Unknown message'
=> 'Unbekannte Nachricht',

   'Answer Submitted'
=> 'Antwort bermittelt',

   'Tries'
=> 'Versuche',

   'Submit Answer'
=> 'Antwort einreichen',

   'Prepare a printable document'
=> 'Drucken', # long version: 'Druckbares Dokument erstellen',

   'Go To My First Homework Problem'
=> 'Springe zu meiner ersten Hausbungs-Aufgabe',

   'Cancel'
=> 'Abbrechen',

   'Discussions'
=> 'Diskussionen',

   'New discussion since'
=> 'Neue Diskussion seit',

   'Goodbye'
=> 'Auf Wiedersehen',

   'Select'
=> 'Auswhlen',

   'Re-Initialize'
=> 'Neu initialisieren',

   'Currently selected. '
=> 'Derzeit ausgewhlt. ',

   'Switch Server'
=> 'Server wechseln',

   'system wide'
=> 'systemweit',

   'Currently not available'
=> 'Derzeit nicht verfgbar',

   'No role specified'
=> 'Keine bestimmte Rolle',

   'Remark'
=> 'Bemerkung',

   'Extent'
=> 'Bereich',

   'User Role'
=> 'Benutzerrolle',

   'Start'
=> 'Anfang',

   'End'
=> 'Ende',

   'System'
=> 'System',

   'Display'
=> 'Anzeigen',

   "an unknown date"
=> 'unbekannter Zeitpunkt',

   "an indeterminate date"
=> 'unbestimmter Zeitpunkt',

   "will open on"
=> "wird verfgbar sein am",

   "is due at"
=> "ist fllig am",

   "was due on"
=> "war fllig am",

   'is closed but you are allowed to view it'
=> "ist geschlossen, kann aber von Ihnen betrachtet werden",

   "Undid changes, Switched"
=> "nderungen rckgngig gemacht. Austausch von",

   "Unable to undo, unable to switch"
=> "nderungen konnten nicht rckgngig gemacht werden, nicht umgeschaltet",

   "Unable to make backup"
=> "Konnte keine Sicherheitskopie erstellen",

   "Saving Modifications to [_1]"
=> "Speichere nderungen in [_1]",

   "Unable to write to"
=> "Konnte nicht speichern unter",

   "Analyzing a problem"
=> "Analysiere Aufgabe",

   "EditXML"
=> "XML-Editor",

   'Discard Edits and View'
=> 'nderungen verwerfen und betrachten',

   'Submit Changes'
=> 'Speichern und weiterbearbeiten', # 'nderungen speichern',

   'Submit Changes and View'
=> 'Speichern und betrachten',

   'Edit'
=> 'Editor',

   ', select a template from the pull-down menu below'
=> 'whlen Sie eine Vorlage aus dem unterstehenden Auswahlmen',

   'undo'
=> 'Rckgngig machen',

   'Answer'
=> 'Antwort',

   'Frequency'
=> 'Hufigkeit',

   'You did not select a template.'
=> 'Sie haben keine Vorlage ausgewhlt.',

   'Analyze Progress'
=> 'Fortschritt analysieren',

   'Getting Problem Variants'
=> 'Berechne Aufgabenvariationen',

   'last problem'
=> 'letzte Aufgabe',

   "may open later."
=> 'knnte zu einem spteren Zeitpunkt verfgbar werden',

   ', and answers will be available on'
=> ', und Antworten werden verfgbar sein am',

   "Select a"
=> "Whlen Sie",

   'Unable to find'
=> 'Konnte nicht gefunden werden',

   'Part'
=> 'Aufgabenteil',

   "Then"
=> 'Dann',

   'Create'
=> 'Erzeuge Datei vom Typ',

   'is in under construction'
=> 'ist in Arbeit',

   'List of possible answers'
=> 'Liste von mglichen Antworten',

'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Keine analysierbaren Aufgabenteile gefunden.  Derzeit werden nur numerische Ausdrcke, Formeln und Strings als Antworttypen untersttzt.',

   'is not analyzable at this time'
=> 'ist derzeit nicht analysierbar',

   'Title'
=> 'Titel',

   'Path'
=> 'Pfad',

   'New Search'
=> 'Neue Suche',

   'Go Back'
=> 'Zurck',

   'File'
=> 'Datei',

   'Date'
=> 'Datum',

   'You have no unread messages'
=> 'Sie haben keine ungelesenen Nachrichten',

   'New Messages'
=> 'Neue Nachrichten',

   'View All Messages'
=> 'Alle Nachrichten',

   'Map'
=> 'Inhaltszusammenstellung',

   'Page'
=> 'Seite',

   'Sequence'
=> 'Sequenz',

   'Map contents are not shown in order.'
=> 'Inhaltszusammenstellungs-Inhalte werden nicht sortiert angezeigt.',

   'Empty'
=> 'Leer',

   'could not be copied.'
=> 'konnte nicht kopiert werden.',

   'Back to Directory'
=> 'Zurck zum Verzeichnis',

   'No upload file specified.'
=> 'Keine Datei zum Hochladen angegeben.',

   'The target is an existing directory.'
=> 'Die Zieldatei ist ein existierendes Verzeichnis.',

   'Please use browser "Back" button and pick a filename'
=> 'Bitte benutzen Sie "Zurck" in Ihrem Webbrowser und geben Sie einen Dateinamen an',

   "You do not have authoring privileges for this resource"
=> "Sie haben fr diese Ressource keine Schreibberechtigung!",

   'Copying file'
=> 'Kopiere Datei',

   'No write permission to user directory, FAIL'
=> 'Keine Schreibberechtigung fr dieses Verzeichnis, Abbruch',

   'Actions'
=> 'Aktionen',

   'Name'
=> 'Name',

   'Status'
=> 'Zustand',

   'Last Modified'
=> 'Letzte nderung',

   'Yes'
=> 'Ja',

   'Construction Space Directory'
=> 'Konstruktionsbereich Verzeichnis',

   'Contact'
=> 'Kontaktieren Sie',

   'Save uploaded file as '
=> 'Speichere hochgeladene Datei unter ',

   'Searching'
=> 'Suche',

   'Select the Construction Space'
=> 'Whlen Sie den Konstruktionsbereich',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Es wird grundstzlich empfohlen, einen aktuellen Virenscanner zu benutzen, bevor Sie diese Datei verwenden.',

   'You have no unread messages'
=> 'Sie haben keine ungelesenen Nachrichten',

   'not displayed'
=> 'nicht angezeigt',

   "Open, no due date"
=> "Verfgbar, kein Flligkeitsdatum",

   "Uncompleted Homework"
=> "Unerledigte Hausbungen",

   "Show Only Uncompleted Homework"
=> "Zeige nur unerledigte Hausbungen",

   "All homework is currently completed"
=> "Derzeit sind alle Hausbungen erledigt",

   "Go To My First Homework Problem"
=> "Gehe zu meiner ersten Hausbung",

   "Was due"
=> "War fllig",

   "Answer available"
=> "Antwort verfgbar",

   "Excused by instructor"
=> "Vom Lehrenden erlassen",

   "Answer submitted, not yet graded"
=> "Antwort eingereicht, noch nicht benotet",

   "No due date"
=> "Kein Flligkeitsdatum",

   'never'
=> 'niemals',

   'Answer submitted'
=> 'Antwort eingereicht',

   'Processing'
=> 'Wird verarbeitet',

   'Access and Usage Statistics'
=> 'Zugangs- und Benutzungsstatistiken',

   'Evaluation Comments'
=> 'Beurteilungskommentare',

   'Evaluation Data'
=> 'Beurteilungsdaten',

   'July'
=> 'Juli',

   'Server Administration'
=> 'Serververwaltung',

   'System Administration'
=> 'Systemverwaltung',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'Users with Roles Assigned by'
=> 'Benutzer mit Rollen vergeben von',

   'Name starting with'
=> 'Name beginnt mit',

   'This resource has been marked obsolete by the author(s)'
=> 'Dieses Ressource wurde von den Autoren als berholt gekennzeichnet',

   'Uploaded'
=> 'Hochgeladen',

   'Dynamic Metadata'
=> 'Dynamische Metadaten',

   'View file'
=> 'Datei betrachten',

   'could not be copied.'
=> 'konnte nicht kopiert werden.',

   'Illegal filename.'
=> 'Ungltiger Dateiname.',

   'Rule'
=> 'Regel',

   'Back to Source Directory'
=> 'Zurck zum Quellverzeichnis',

   'Back to Source'
=> 'Zurck zur Quelldatei',

   'File copied.'
=> 'Datei kopiert.',

   'FAIL'
=> 'Abbruch',

   'Back to'
=> 'Zurck zu',

   'untitled'
=> 'kein Titel',

   ', is reserved internally by LON-CAPA.'
=> ', ist intern reserviert fr LON-CAPA.',

   'Became this version on ...'
=> 'Wurde diese Version am ...',

   'Browse published resources'
# => 'Verffentlichte Dokumente betrachten',
=> 'Verffentlichte Ressourcen',

   'Choose the course to work on'
=> 'Whlen Sie den Kurs, in dem Sie arbeiten wollen',

   'Create a new course'
=> 'Kurse erstellen',

   'Customized right of use ...	'
=> 'Spezielle Nutzungsrechte ... ',

   'Delete messages from bulletin boards'
=> 'Lsche Nachrichten vom Schwarzen Brett',

   'Domain only - use limited to courses in the domain'
=> 'Beschrnkt auf Domne - Nutzung begrenzt auf Kurse innerhalb dieser Domne',

   'Edit and view documents included in this course'
=> 'Kurs-Ressourcen bearbeiten',

   'Edit/Modify DOCS'
=> 'Editiere/ndere DOKUS',

   'Enter my resource construction space'
# => 'Konstruktionsbereich aufrufen',
=> 'Konstruktionsbereich',

   'Failed to copy source'
=> 'Konnte Quelldatei nicht kopieren',

   'Failed to write metadata copy'
=> 'Konnte Metadaten nicht kopieren',

   'Finalize Publication'
=> 'Verffentlichung abschlieen',

   'Grant/revoke role of Co-Author'
=> 'Vergebe/entziehe Co-Autorenrollen',

   'Grant/revoke role of Domain Coordinator'
=> 'Vergebe/Entziehe Domnen-Koordinator-Rolle',

   'Grant/revoke role of Exam Proctor'
=> 'Vergebe/Entziehe Rolle des Exam Proktors',

   'Grant/revoke role of Instructor'
=> 'Vergebe/Entziehe Rolle des Lehrenden',

   'Grant/revoke role of Student'
=> 'Vergebe/Entziehe Rolle des Studierenden',

   'Grant/revoke role of Superuser'
=> 'Vergebe/Entziehe Rolle des Superusers',

   'No previous versions published.'
=> 'Keine vorhergehenden Versionen verffentlicht.',

   'No write permission to'
=> 'Keine Schreibberechtigung fr', 

   'Please pick a version to retrieve'
=> 'Whlen Sie bitte eine Version aus, die Sie wiederherstellen mchten',

   'Private - visible to author only for testing purposes'
=> 'Privat - fr den Autor nur zu Testzwecken sichtbar',

   'Private Publication - did not synchronize database'
=> 'Private Verffentlichung - nicht mit Datenbank synchronisiert',

   'Public - no authentication or authorization required for use'
=> 'ffentlich - keine Anmeldung zur Benutzung notwendig',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'Der Abruf einer alten Version berschreibt die derzeit im Konstruktionsbereich vorhandene Datei!',

   'Retrieve previous versions of'
=> 'Wiederherstellen vorheriger Versionen von',

   'Retrieve version'
=> 'Ausgewhlte Version wiederherstellen',

   'Search the contents of this course'
=> 'Kursinhalts-Suche',

   'Search the database of published resources and accessible portfolio files'
=> 'Datenbank verffentlichter Ressourcen und Portfolio-Dateien',

   'Send broadcast and receipt-required email'
=> 'Sende Broadcast-E-Mail und E-Mail mit Empfangsbesttigung',

   'Show Problem Completeness'
=> 'Zeige Aufgabenvollstndigkeit',

   'Switch to another course'
=> 'Zu einem anderen Kurs wechseln',

   'System wide - can be used for any courses system wide'
=> 'Systemweit - kann fr alle Kurse systemweit verwendet werden',

   'System wide - open source to all authors'
=> 'Systemweit - Open Source fr alle Autoren',

   'The extension on this file'
=> 'Die Endung dieser Datei',

   'Unsupported character combination'
=> 'Ungltige Zeichenkombination',

   'View documents included in this course'
=> 'Zustzliche Kursdokumente',

   'Additional Keywords'
=> 'Zustzliche Schlsselwrter',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Zustzliche Metadaten (nicht standardisiert, Parameter, Exporte)', #??? [SB 22.06.2007]

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Autoren- und Co-Autoren-Rollen knnten auf anderen Servern als Ihrem Heimatserver nicht verfgbar sein.',

   'Author(s)'
=> 'Autor(en)',

   'Average number of tries till solved'
=> 'Durchschnittliche Anzahl an Versuchen bis zur erfolgreichen Lsung',

   'Browse Resources'
=> 'Ressourcen durchsehen',

   'Catalog Information'
=> 'Katalogisierungs-Information',

   'Collapse Remote Control'
=> 'Fernbedienung deaktivieren',

   'Construction Space'
=> 'Konstruktionsbereich',

   'Copied metadata'
=> 'Metadaten kopiert',

   'Copied source file'
=> 'Quelldatei kopiert',

   'Copyright/Distribution'
=> 'Copyright/Zugriffsrechte',

   'Course Documents'
=> 'Kursdokumente',

   'Creation Date'
=> 'Ersterstellungsdatum',

   'Custom Distribution File'
=> 'Datei zum Maschneidern der Zugriffsrechte',

   'Degree of difficulty'
=> 'Schwierigkeitsgrad',

   'Dump Course DOCS to Construction Space'
=> 'Ablage in Konstruktionsbereich',

   'Entering course ...'
=> 'An Kurs teilnehmen ...',

   'Exam Information'
=> 'Prfungsinformationen',

   'External Resource'
=> 'Externe Ressource',

   'Generate new role ...'
=> 'Erzeuge neue Rolle ...',

   'Go to the next resource in the course sequence'
=> 'Weiter', # long version: 'Gehe zur nchsten Ressource in der Kurssequenz',

   'Go to the previous resource in the course sequence'
=> 'Zurck', # long version: 'Gehe zur vorhergehenden Ressource in der Kurssequenz',

   'Import a published document'
=> 'Importieren einer verffentlichten Ressource',

   'Keyword(s)'
=> 'Schlsselwrter',

   'Logged Out'
=> 'Abgemeldet',

   'MIME Type'
=> 'MIME-Typ',

   'Make notes and annotations about this resource'
=> 'Notizen', # long version: 'Notizen zu dieser Ressource erstellen',

   'The material is covered with sufficient depth'
=> 'Das Thema wird in ausreichender Tiefe behandelt',

   'Metadata Information'
=> 'Metadaten-Information',

   'My Personal Info'
=> 'Meine ber-Mich-Seite', # 'Informationen zu meiner Person',

   'Network-wide number of accesses (hits)'
=> 'Netzwerkweite Anzahl von Zugriffen ("Hits")',

   'Network-wide number of courses using resource'
=> 'Netzwerkweite Anzahl von Kursen, die diese Ressource verwenden',

   'Number of resources that follow this resource in maps'
=> 'Anzahl der Ressourcen, die in Inhaltszusammenstellungen Nachfolger zu dieser Ressource sind',

   'Number of resources that lead up to this resource in maps'
=> 'Anzahl der Ressourcen, die in Inhaltszusammenstellung Vorgnger zu dieser Ressource sind',

   'Number of resources using or importing resource'
=> 'Anzahl der Ressourcen, die diese Ressource verwenden oder importieren',

   'Obsolete'
=> 'berholt',

   'Parent Directory'
=> 'bergeordnetes Verzeichnis',

   'Please either'
=> 'Bitte entweder',

   'Project Information'
=> 'Projektinformation',

   'Publisher/Owner'
=> 'Herausgeber/Besitzer',

   'Publishing'
=> 'Verffentlichung',

   'Resource Publication'
=> 'Verffentlichung von Ressourcen',

   'Resource is technically correct'
=> 'Die Ressource ist technisch in Ordnung',

   'Score Upload Form'
=> 'Formular zum Hochladen von Noten',

   'Select Map'
=> 'Whle Inhaltszusammenstellung',

   'Load Map'
=> 'Hochladen', # 'Lade Inhaltszusammenstellung',

   'Set a bookmark for this resource'
=> 'Lesezeichen setzen', # long version: 'Lesezeichen auf diese Ressource setzen',

   'Show all roles'
=> 'Zeige alle Rollen',

   'Special documents'
=> 'Spezielle Dokumente',

   'Subject'
=> 'Thema',

   'Successful Login'
=> 'Erfolgreich angemeldet',

   'Suggested Replacement for Obsolete File'
=> 'Vorgeschlagener Ersatz fr berholte Datei',

   'Switching Role'
=> 'Benutzerrolle wechseln',

   'Target'
=> 'Ziel',

   'This syllabus can be publicly viewed at'
=> 'Dieser Kursberblick kann ffentlich abgerufen werden unter',

   'Total number of students who have worked on this problem'
=> 'Gesamtzahl von Studierenden, die diese Aufgabe bearbeitet haben',

   'URLs To Include in Syllabus'
=> 'URLs, die in den Kursberblick eingefgt werden sollen',

   'Upload a new main course document'
=> 'Externe Dokumente',

   'Upload a new supplemental course document'
=> 'Zustzliche Kursdokumente',

   'User'
=> 'Benutzer',

   'Wrote Metadata'
=> 'Metadaten geschrieben',

   'Your home server is '
=> 'Ihr Heimatserver ist ',

   'anno-'
=> 'Bemerk-',

   'announce'
=> 'ankndigen',

   'backward'
=> 'backward',

   'bookmark'
=> 'Lesezeichen',

   'chart'
=> 'Chart',

   'chat'
=> 'Chat',

   'close this window'
=> 'dieses Fenster schlieen',

   'con-'
=> 'con-',

   'docs'
=> 'Dokus',

   'edit crs'
=> 'Bearbeite crs',

   'exit'
=> 'abmelden',

   'fas'
=> 'fas',

   'forward'
=> 'forward',

   'library'
=> 'Bibliothek',

   'log in again'
=> 'erneut anmelden',

   'my'
=> 'mein',

   'or'
=> 'oder',

   'parms'
=> 'parms',

   'prepare'
=> 'Vorbereiten',

   'printout'
=> 'Ausdruck',

   'resource'
=> 'Ressource',

   'roles'
=> 'Rollen',

   'search'
=> 'suche',

   'set'
=> 'setze',

   'space'
=> 'Bereich',

   'stats'
=> 'Statistiken',

   'struct'
=> 'Struktur',

   'switch'
=> 'wechsle',

   'tations'
=> 'ungen',

   'updated periodically'
=> 'periodisch ermittelt',

   'user'
=> 'Benutzer',

   'visible to author and co-authors only'
=> 'nur fr Autoren und Co-Autoren sichtbar',

   'All versions'
=> 'Alle Versionen',

   'Could not write metadata'
=> 'Konnte Metadaten nicht schreiben',

   'Default Cataloging Information for Directory'
=> 'Voreinstellung der Katalogisierungs-Information fr gesamtes Verzeichnis',

   'Error Messages'
=> 'Fehlermeldungen',

   'Save Catalog Information'
=> 'Speichere Katalogisierungs-Informationen',

   'Update Display'
=> 'Neu anzeigen',

   'Content changed'
=> 'Inhalt gendert',

   'Differences'
=> 'Unterschiede',

   'Last Week'
=> 'letzte Woche',

   'Modification Date'
=> 'nderungsdatum',

   'Since Start of Course'
=> 'seit Anfang des Kurses',

   'Since Yesterday'
=> 'seit gestern',

   'Verify Course Documents'
=> 'berprfe Kursdokumente',

   'Version'
=> 'Version',

   'access denied'
=> 'Zugriff verweigert',

   'connection down'
=> 'Verbindung unterbrochen',

   'during the last'
=> 'whrend der letzten',

   'not found'
=> 'nicht gefunden',

   'warning(s)'
=> 'Warnung(en)',



#SYNC Mon Sep 29 11:02:04 2003

   'Advanced Catalog Search'
=> 'Erweiterte Katalogsuche',

   'Advanced Search'
=> 'Erweiterte Suche',

   'Any Language'
=> 'Beliebige Sprache',

   'Any category'
=> 'Beliebige Kategorie',

   'Any copyright/distribution'
=> 'Beliebiges Copyright/Zugriffsrecht',

   'Broadcast Message to Course'
=> 'Nachricht an gesamten Kurs senden',

   "Click to download or use your browser's Save Link function"
=> "Zum Speichern hier klicken oder 'Ziel speichern unter'-Funktion des Webbrowsers verwenden",

   'Close'
=> 'Schlieen',

   'Compact View'
=> 'Kompaktansicht',

   'Detailed Citation View'
=> 'Detailierte Zitatansicht',

   'Distribute Messages from Uploaded File to Course'
=> 'Verteile Nachrichten der hochgeladenen Datei an den Kurs',

   'Edit Catalog Information'
=> 'Bearbeite Katalogisierungs-Informationen',

   'Edit Content of a Map'
=> 'Bearbeite Inhalt der Inhaltszusammenstellung',

   'Edit Directory Catalog Information'
=> 'Bearbeite Informationen des Verzeichniskataloges',

   'Evaluate Resource'
=> 'Ressource bewerten',

   'Failed Access to Construction Space'
=> 'Zugriff auf Konstruktionsbereich fehlgeschlagen',

   'Fielded Format'
=> 'In Felder aufgeteiltes Format',

   'File Category'
=> 'Dateikategorie',

   'Force publication of unmodified files'
=> 'verffentliche auch ungenderte Dateien',

   'Keywords'
=> 'Schlsselwrter',

   'Last access'
=> 'Letzter Zugriff',

   'Last modified'
=> 'Letzte nderungen',

   'Limit by copyright/distribution'
=> 'Durch Copyright/Zugriffsrechte einschrnken',

   'Limit by language'
=> 'Durch Sprache einschrnken',

   'Open'
=> 'ffnen',

   'Per Page'
=> 'Pro Seite',

   'Printing Helper'
=> 'Hilfsprogramm zum Drucken',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Feedback, Kursdiskussion', # long version: 'Feedback geben oder an der Kursdiskussion zu dieser Ressource teilnehmen',

   'Provide my evaluation of this resource'
=> 'Bewerten', # long version: 'Diese Ressource bewerten',

   'Publish'
=> 'Verffentlichen',

   'Publish Directory'
=> 'Verffentliche Verzeichnis',

   'Publish Directory and Sub Directories'
=> 'Verffentliche Verzeichnis und Unterverzeichnisse',

   'Related'
=> 'Verwandte',

   'Resource Feedback and Discussion'
=> 'Feedback und Diskussion zu dieser Ressource',

   'Search Complete'
=> 'Suche beendet',

   'Send Message to User(s)'
=> 'Sende Nachricht an Benutzer',

   'Show catalog information'
=> 'Katalogisierungsinformationen', # long version: 'Katalogisierungsinformationen zeigen',

   'Show resource'
=> 'Zeige Ressource an',

   'Size'
=> 'Gre',

   'Statistics'
=> 'Statistiken',

   'Summary View'
=> 'Zusammenfassung',

   'There are currently no results'
=> 'Derzeit noch keine Ergebnisse',

   'URL'
=> 'URL',

   'Unpublished'
=> 'unverffentlicht',

   'Up'
=> 'Hoch',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'Notizen von Benutzern, Protokolle von Besprechungen mit Studierenden, und kritische Nachrichten',

   'View'
=> 'Betrachten',

   'View Critical Messages'
=> 'Kritische Nachrichten ansehen',

   'Words'
=> 'Wrter',

   'XML/SGML'
=> 'XML/SGML',

   'abstract'
=> 'Zusammenfassung',

   'audio'
=> 'Audio',

   'author'
=> 'Autor',

   'catalog'
=> 'katalog',

   'copyright'
=> 'Copyright',

   'customdistributionfile'
=> 'customdistributionfile',

   'directory'
=> 'Verzeichnis',

   'discuss'
=> 'Diskutiere',

   'evaluate'
=> 'Auswerten',

   'feedback'
=> 'Feedback',

   'info'
=> 'Info',

   'keywords'
=> 'Schlsselwrter',

   'language'
=> 'Sprache',

   'movies'
=> 'Filme',

   'notes'
=> 'Notizen',

   'obsolete'
=> 'berholt',

   'obsoletereplacement'
=> 'obsoletereplacement',

   'pages'
=> 'Seiten',

   'pictures'
=> 'Bilder',

   'problem'
=> 'Aufgabe',

   'resources'
=> 'Ressourcen',

   'sequence'
=> 'Sequenz',

   'subject'
=> 'Thema',

   'this'
=> 'Diese',

   'title'
=> 'Titel',


#SYNC Sat Oct  4 20:36:34 2003
   'About Me'
=> 'ber mich',

   'Bulletin Board/Discussion'
=> 'Schwarzes Brett/Diskusion',

   'Clear All'
=> 'Lsche alle',

   'Close All Folders'
=> 'Schliee alle Verzeichnisse',

   'Construction Space File Operation'
=> 'Dateioperation im Konstruktionsbereich',

   'Contact Information'
=> 'Kontaktdaten',

   'Copied old metadata'
=> 'Alte Metadaten kopiert',

   'Copied old target file'
=> 'Alte Zieldatei kopiert',

   'Copyright'
=> 'Copyright',

   'Could Not Process Request'
=> 'Konnte Befehl nicht ausfhren',

   'Default'
=> 'Standard',

   'Discard Selected'
=> 'Verwerfe ausgewhlte',

   'EMail and Messages'
=> 'E-Mail und Nachrichten',

   'Edit this resource'
=> 'Bearbeiten', # long version: 'Bearbeite diese Ressource',

   'Enter construction space as a co-author'
=> 'Konstruktionsbereich als Co-Autor aufrufen',

   'Host'
=> 'Rechner',

   'Last updated'
=> 'Zuletzt aktualisiert',

   'Mime type'
=> 'MIME Typ',

   'Modified'
=> 'gendert',

   'Modify deadlines, etc, for this assessment resource'
=> 'Bearbeite Flligkeitsdaten, etc. fr diese Beurteilungs-Ressource',

   'Modify user grades for this assessment resource'
=> 'Manuelle Benotung', # 'Bearbeite die Noten des Benutzers fr diese Beurteilungs-Ressource',

   'Move Down'
=> 'Nach unten',

   'Move Up'
=> 'Nach oben',

   'New Title'
=> 'Neuer Titel',

   'Open All Folders'
=> 'ffne alle Verzeichnisse',

   'Owner/Publisher'
=> 'Besitzer/Herausgeber',

   'Personal Information'
=> 'Persnliche Informationen',

   'Privacy Note'
=> 'Hinweis zur Privatssphre',

   'Published'
=> 'verffentlicht',

   'Reading results from'
=> 'Lese Ergebnisse von',

   'Retrieve'
=> 'Wiederherstellen',

   'Revert to Last Saved'
=> 'Gehe zur letzten gespeicherten Version',

   'Revision Date'
=> 'nderungsdatum',

   'Shared by course faculty and staff'
=> 'Gemeinsam fr Kursdozenten und Personal',

   'Save'
=> 'Speichern',

   'Synchronized SQL metadata database'
=> 'SQL Metadaten-Datenbank synchronisiert',

   'Task'
=> 'Aufgabe',

   'Temporary Assembly Workspace'
=> 'Temporrer Gruppenarbeitsbereich',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'Die Daten, die Sie hier bereitstellen, knnen von jeder Person, die in LON-CAPA angemeldet ist, eingesehen werden. Stellen Sie daher keine Information zur Verfgung, die Sie hier nicht ffentlich machen wollen.',

   'Topic'
=> 'Thema',

   'Upload a Photo'
=> 'Foto hochladen',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'Benutzermeldungen, Aufzeichnungen von Gesprchen und kritische Nachrichten fr den Kurs',

   'Version Number'
=> 'Versionsnummer',

   'View Published Version'
=> 'Verffentlichte Version betrachten',

   'View user submissions for this assessment resource'
=> 'Betrachte Benutzer-Einreichungen fr diese Beurteilungs-Ressource',

   'Web References'
=> 'Webreferenzen',

   'co con-'
=> 'Co-Kon-',

   'co res'
=> 'co-res',

   'contacting'
=> 'kontaktiere',

   'edit'
=> 'Bearbeite',

   'interface available'
=> 'Interface verfgbar',

   'missions'
=> 'Aufgaben',

   'view sub-'
=> 'Betrachte Unter-',

   'waiting on'
=> 'warte auf',


#SYNC Wed Oct  8 14:13:34 2003
   '#Stdnts'
=> 'Anzahl Stud.',

   '#YES'
=> 'Anzahl Ja',

   '%Wrng'
=> '%Wrng',

   'Brief view of each students performance in course.'
=> 'Kurze bersicht der Leistungen eines jeden Studenten im Kurs.',

   'Clear Caches'
=> 'Cache lschen',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Kurs-Statistiken und -Diagramme knnen solange nicht empfangen werden, bis die Datenbank neu gestartet wurde. Ihre Daten sind vorhanden, knnen aber zu diesem Zeitpunkt nicht angezeigt werden.',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Ausfhrliche Statistiken und Graphen der studentischen Leistung hinsichtlich der Aufgaben',

   'DoDiff'
=> 'Verwende diff',

   'Enrollment Status'
=> 'Kursbelegungs-Status',

   'Generate Statistics'
=> 'Erzeuge Statistiken',

   'Max Tries'
=> 'Max. Anz. an Vers.',

   'Mean Tries'
=> 'Mittelw. Vers.',

   'Output'
=> 'Ausgabe',

   'Overall Problem Statistics'
=> 'Insgesamte Aufgabenstatistik',

   'Please notify the server administrator '
=> 'Benachrichtigen Sie bitte den Server-Administrator ',

   'Please select a report to generate.'
=> 'Whlen Sie bitte einen Bericht, den Sie erstellen mchten.',

   'Preparing Excel Spreadsheet'
=> 'Bereite ein Excel-Spreadsheet vor',

   'Problem Status Chart'
=> 'Aufgabenstatus-Diagramm',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Es traten Probleme beim Erstellen der neuen Excel-Datei auf. Dieser Fehler wurde mitgeloggt. Bitte benachrichtigen Sie Ihren LON-CAPA-Administrator.',

   'S.D. tries'
=> 'S.D. Versuche',

   'Sections'
=> 'Sektionen',

   'Sequence or Folder'
=> 'Sequenz oder Verzeichnis',

   'Sequences and Folders'
=> 'Sequenzen und Verzeichnisse',

   'Skew Tries'
=> 'Schiefe Treffer',

   'Statistics and Problem Analysis'
=> 'Statistiken und Aufgabenanalysen',

   'Student performance statistics on all problems.'
=> 'Statistik studentischer Leistungen hinsichtlich aller Aufgaben',

   'Unable to connect to database!'
=> 'Verbindungsaufbau zur Datenbank nicht mglich!',

   'Your Excel Spreadsheet'
=> 'Ihr Excel-Spreadsheet',

   'part'
=> 'Aufgabenteil',

   'problem statistics grouped by sequence'
=> 'Aufgabenstatistiken, gruppiert nach Sequenz',

   'problem statistics ungrouped'
=> 'Aufgabenstatistiken, nicht gruppiert',

   'problem statistics, Excel'
=> 'Aufgabenstatistiken, Excel',

#SYNC Wed Oct  8 14:49:53 2003
   'Significant figures are incorrect, submission was not graded.'
=> 'Die Anzahl der signifikanten Stellen ist inkorrekt. Dieser Versuch wurde nicht gezhlt.',



#SYNC Fri Oct 10 11:36:26 2003
   '. . . for a particular section'
=> '. . . fr eine bestimmte Sektion',

   '. . . for all students in the course'
=> '. . . fr alle Studenten im Kurs',

   '. . . for an individual student'
=> '. . . fr einen bestimmten Studenten',

   '1 am'
=> '1:00',

   '1 pm'
=> '13:00',

   '10 am'
=> '10:00',

   '10 pm'
=> '22:00',

   '11 am'
=> '11:00',

   '11 pm'
=> '23:00',

   '12 am'
=> '00:00',

   '12 noon'
=> '12:00',

   '2 am'
=> '2:00',

   '2 pm'
=> '14:00',

   '3 am'
=> '3:00',

   '3 pm'
=> '15:00',

   '4 am'
=> '4:00',

   '4 pm'
=> '16:00',

   '5 am'
=> '5:00',

   '5 pm'
=> '17:00',

   '6 am'
=> '6:00',

   '6 pm'
=> '18:00',

   '7 am'
=> '7:00',

   '7 pm'
=> '19:00',

   '8 am'
=> '8:00',

   '8 pm'
=> '20:00',

   '9 am'
=> '9:00',

   '9 pm'
=> '21:00',

   '<- Previous'
=> '<- Zurck',

   'ALL'
=> 'ALLE',

   'All Maps or Folders'
=> 'Alle Inhaltszusammenstellungen oder Verzeichnisse',

   'Any User'
=> 'Jeder Benutzer',

   'Assessment URL and Title'
=> 'Beurteilungs-URL und -Titel',

   'Assigned User Roles'
=> 'Zugewiesene Benutzerrollen',

   'Browse resources'
=> 'Durchsuche Ressourcen',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Es kann bis zu 10 Minuten dauern, bis diese nderungen fr alle Studierenden aktiviert worden sind.',

   'Course Assessment Parameter - Helper Mode'
=> 'Parameter zur Kursbeurteilung - Hilfsmodus',

   'Course Assessment Parameters - Overview Mode'
=> 'Parameter zur Kursbeurteilung - bersichtsmodus',

   'Course Assessments Parameters - Table Mode'
=> 'Parameter zur Kursbeurteilung - Tabellenmodus',

   'Course Environment Parameters'
=> 'Kursumgebungsparameter',

   'Course Parameter Helper'
=> 'Kursparameter-Hilfsprogramm',

   'Create New Environment Variable'
=> 'Erstelle neue Umgebungsvariable',

   'Current Session Value'
=> 'Wert fr diese Sitzung',

   'Default Value'
=> 'Voreingestellter Wert',

   'Delete a role'
=> 'Rolle lschen',

   'Disable all communication among students'
=> 'Unterbinde jegliche Kommunikation zwischen Studenten',

   'Enclosing Map or Folder'
=> 'Eingeschlossene(s) Inhaltszusammenstellung oder Verzeichnis',

   'Every problem in a particular folder'
=> 'Jede Aufgabe in einem bestimmten Verzeichnis',

   'Every problem in the course'
=> 'Jede Aufgabe im Kurs',

   'Folder'
=> 'Verzeichnis',

   'For User'
=> 'Fr Benutzer',

   'Grant/revoke Course Custom Role'
=> 'Vergebe/Entziehe Kurssonderrolle',

   'Grant/revoke role of Administrator'
=> 'Vergebe/Entziehe Rolle des Administrators',

   'Grant/revoke role of Author'
=> 'Vergebe/Entziehe Rolle des Autors',

   'Grant/revoke role of Course Coordinator'
=> 'Vergebe/Entziehe Rolle des Kurs-Koordinators',

   'Grant/revoke role of Domain Guest'
=> 'Vergebe/Entziehe Rolle des Domnengasts',

   'Grant/revoke role of Librarian'
=> 'Vergebe/Entziehe Rolle des Bibliothekars',

   'Grant/revoke role of Teaching Assistant'
=> 'Vergebe/Entziehe die Rolle Tutor',

   'Internally authenticated'
=> 'Intern authentifiziert',

   'Kerberos authenticated'
=> 'Kerberos authentifiziert',

   'LON-CAPA Helper:'
=> 'LON-CAPA-Hilfsprogramm:',

   'Lock and unlock assessments'
=> 'Sperren und Entsperren von Beurteilungen',

   'Manage Access Keys'
=> 'Zugriffsschlssel verwalten',

   'Manage access keys'
=> 'Zugriffsschlssel verwalten',

   'Max Possible To Date'
=> 'Bis heute maximal erreichbar', #??? 'Maximal erreichbar bis zum Datum' ??? [SB 18.10.2006]

   'Modify Course Assessment Parameters'
=> 'Bearbeite Parameter fr die Kursbeurteilung',

   'Modify authentication mechanism and data for a user'
=> 'Bearbeite Authentifizierungs-Methode und Daten fr einen Benutzer',

   'Modify grades'
=> 'Bewertungen ändern',

   'Next ->'
=> 'Weiter ->',

   'One particular problem'
=> 'Eine bestimmte Aufgabe',

   'Parameter Name'
=> 'Parametername',

   'Parameter Type'
=> 'Parametertyp',

   'Parameter in Effect'
=> 'Effektiver Parameter',

   'Please select a problem to analyze'
=> 'Whlen Sie die zu analysierende Aufgabe',

   'Post anonymously'
=> 'Anonym absenden',

   'Post discussion on course resources'
=> 'Diskussion zu den Ressourcen des Kurses absenden',

   'Post system frontpage announcements'
=> 'Sende Ankndigungen auf der Hauptseite des Systems',

   'Post to live chatrooms'
=> 'In die Live-Chatrooms senden',

   'Problems Not Contained In A Folder'
=> 'Aufgaben, die sich nicht in einem Verzeichnis befinden',

   'Quick Completed Problems Display'
# => 'Schnelle Ansicht der gelschten Aufgaben',
=> 'Schnelle Ansicht der abgeschlossenen Aufgaben', #??? [SB 18.10.2006]

   'Resource Level'
=> 'Ressourcen-Niveau',

   'Section'
=> 'Sektion',

   'Select Date'
=> 'Whle Datum',

   'Select Enclosing Map or Folder'
=> 'Eingeschlossene(s) Inhaltszusammenstellung oder Verzeichnis',

   'Select Parameter Level'
=> 'Parameterlevel',

   'Send internal email'
=> 'Verschicke interne Nachrichten',

   'Set Course Environment Parameters'
=> 'Setze Kursumgebungs-Parameter',

   'Set Date'
=> 'Setze Datum',

   'Set Defaults for All Resources in Course'
=> 'Setze voreingestellte Werte fr alle Ressourcen im Kurs',

   'Set a due date'
=> 'Setze Flligkeitsdatum',

   'Set an answer open date'
=> 'Setze Antwort-Verfgbarkeits-Datum',

   'Set an open date'
=> 'Setze eine Bearbeitungsbeginn-Datum',

   'Set opening datefor all problems in the course for. . .'
=> 'Setze ffnungsdatum fr alle Aufgaben im Kurs auf. . .',

   'Set the number of tries'
=> 'Setze Anzahl von Versuchen',

   'Set the problem weight'
=> 'Setze Aufgabengewicht',

   'Set/Modify Course Assessment Parameter'
=> 'Setze/ndere Parameter zur Kursbeurteilung',

   'Set/Modify Course Assessment Parameters'
=> 'Setze/ndere Parameter zur Kursbeurteilung',

   'Set/Modify Course Parameters'
=> 'Setze/ndere Kursparameter',

   'Show More Options'
=> 'Zeige mehr Optionen',

   'Students Affected'
=> 'Betroffene Studierende',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'Dieses Hilfsprogramm wird Ihnen dabei helfen, das Datum fr den Bearbeitungsbeginn, die Flligkeit und die Antwort-Verfgbarkeit fr Aufgaben zu setzen und die Anzahl der Versuche fr Aufgaben festzulegen. Sie werden gefragt, fr welche Aufgaben Sie die Parameter zu setzen wnschen, dann, welche Parameter Sie setzen mchten. Schlielich whlen Sie aus, wen diese Einstellungen betreffen. Nach Abschluss dieser Hilfeuntersttzung wird Ihnen gezeigt, wo Sie in dem erweiterten Interface die Parameter setzen knnen, die Sie ausgewhlt haben, damit Sie dies in Zukunft direkt erledigen knnen. Klicken Sie auf Weiter -&gt; um zu beginnen oder whlen Sie &lt;- Zurck, um zur vorherigen Seite zurckzukehren.',

   'Total'
=> 'Gesamt',

   'Total Parts In Course'
=> 'Gesamtanzahl an Aufgabenteilen in dem Kurs',

   'Type'
=> 'Typ',

   'UNIX authenticated'
=> 'UNIX authentifiziert',

   'USERS'
=> 'BENUTZER',

   'Unknown ID'
=> 'Unbekannte ID',

   'Unknown user'
=> 'Unbekannter Benutzer',

   'Update Course Assessment Parameter Display'
=> 'Aktualisiere die Anzeige der Parameter zur Kursbeurteilung',

   'Update Section or Specific User'
=> 'Aktualisiere Sektion oder bestimmten Benutzer',

   'Verify Selection'
=> 'berprfe Auswahl',

   'Welcome to the Assignment Parameter Helper'
=> 'Willkommen zum Hilfsprogramm fr bungs-Parameter',

   'What parameter do you want to set for all problems in the course?'
=> 'Welche Parameter mchten Sie fr alle Aufgaben in dem Kurs setzen?',

   'What should the opening date be set to?'
=> 'Auf wann soll das ffnungsdatum gesetzt werden?',

   'Which Problem or Problems?'
=> 'Welche Aufgabe oder Aufgaben?',

   'Which problems do you wish to set a parameter for?'
=> 'Fr welche Aufgaben mchten Sie die Parameter setzen?',

   'You need to choose another user role or enter a specific course for this function'
=> 'Fr diese Funktion mssen Sie eine andere Benutzerrolle whlen oder einen spezifischen Kurs eingeben',

   'a.m.'
=> 'vorm.',

   'acc keys'
=> 'acc keys',

   'according to course preferences'
=> 'nach den Kurseinstellungen',

   'according to resource settings'
=> 'nach den Ressourceneinstellungen',

   'according to user session state'
=> 'nach dem Status der Benutzersitzung',

   'all'
=> 'alle',

   'at'
=> 'in',

   'at Domain'
=> 'in Domne',

   'at domain'
=> 'in Domne',

   'default'
=> 'voreingestellt',

   'for Enclosing Map or Folder'
=> 'fr eingeschlossene(s) Inhaltszusammenstellung oder Verzeichnis', #??? [SB 18.10.2006]

   'for Resource'
=> 'fr Ressource',

   'from Enclosing Map or Folder'
=> 'aus eingeschlossener/m Inhaltszusammenstellung oder Verzeichnis', #??? [SB 18.10.2006]

   'general'
=> 'generell',

   'in Course'
=> 'in Kurs',

   'in Section/Group'
=> 'in Sektion/Gruppe',

   'manage'
=> 'verwalte',

   'midnight'
=> 'Mitternacht',

   'noon'
=> 'Mittag',

   'num_override'
=> 'num_override',

   'of'
=> 'von',

   'or ID'
=> 'oder ID',

   'p.m.'
=> 'nachm.',

   'percent'
=> 'Prozent',

   'unless locked'
=> 'falls nicht gesperrt',

   'users in'
=> 'Benutzer in',


#SYNC Tue Oct 14 14:28:20 2003

   'Access Key Management'
=> 'Zugriffsschlsselverwaltung',

   'Assessment'
=> 'Beurteilung',

   'Calculations'
=> 'Berechnungen',

   'Comma Separated Values'
=> 'CSV (kommaseparierte Liste)',

   'Course ID'
=> 'Kurs ID',

   'Course level sheet'   
=> 'Kurs-Level-Bogen', # ??? [SB 2007-07-02]

   'Detailed Problem Analysis'
=> 'Detaillierte Aufgabenanalyse',

   'End Helper'
=> 'Hilfsprogramm beenden',

   'Excel'
=> 'Excel',

   'Finish Course Initialization'
=> 'Beende Kursinitialisierung',

   'Generate Spreadsheet'
=> 'Erzeuge Spreadsheet',

   'Grant/revoke role of Scantron Operator'
=> 'Vergebe/Entziehe Rolle des Scantron Operators',

   'HTML'
=> 'HTML',

   'Invalid date entry'
=> 'Ungltiger Datumseintrag',

   'Load:'
=> 'Lade:',

   'No changes were made to the current settings.'
=> 'An den derzeitigen Einstellungen wurden keine Vernderungen vorgenommen.',

   'Output Format'
=> 'Ausgabeformat',

   'Processing course structure'
=> 'Kursstruktur verarbeiten',

   'Processing first student'
=> 'Fr ersten Studierenden berechnen',

   'Row'
=> 'Reihe',

   'Save as'
=> 'Speichere unter',

   'Save as & Make This Sheet the Default'
=> 'Speichern unter & dieses Sheet als Default einstellen',

   'Scantron Operator'
=> 'Scantron Operator',

   'Select All'
=> 'Whle alle',

   'Select All Students'
=> 'Whle alle Studierenden',

   'Select Spreadsheet File'
=> 'Whle Spreadsheet-Datei',

   'Send Scantron data to a course'
=> 'Scantron-Daten an einen Kurs senden',

   'Spreadsheet Computation'
=> 'Spreadsheet berechnen',

   'Spreadsheet Computation Status'
=> 'Status der Spreadsheet-Berechnung',

   'Student level sheet'
=> 'Studierdenden-Level-Bogen',

   'Summary'
=> 'Zusammenfassung',

   'Template'
=> 'Vorlage',

   'Unselect All'
=> 'Auswahl komplett aufheben', # 'Alle deselektieren',

   'Unselect All Students'
=> 'Alle Studenten deselektieren',

   'Upload Scantron data'
=> 'Scantron-Daten hochladen',

   'You must choose at least one student to continue.'
=> 'Zum Fortfahren mssen Sie mindestens einen Studierenden auswhlen.',

   'You must choose one or more choices to continue.'
=> 'Zum Fortfahren mssen Sie mindestens eine oder mehrere Auswahlen treffen.',

   'last student'
=> 'letzten Studierenden',

   'may be open from a different computer.'
=> 'knnte von einem anderen Computer aus geffnet sein.',

   'minutes'
=> 'Minuten',

   'remaining'
=> 'brig',

   'second'
=> 'Sekunde',

   'seconds'
=> 'Sekunden',

   'seconds for'
=> 'Sekunden fÃr',

#SYNC Wed Oct 15 20:34:21 2003
   'Additional Recipients'
=> 'Weitere Empfnger',

   'Analyze Over '
=> 'Analyse ber ',

   'Analyze Problem'
=> 'Analysiere Aufgabe',

   'Analyze Problem Again'
=> 'Aufgabe erneut analysieren',

   'Analyze as '
=> 'Analysiere als ',

   'Browsing resource, all submissions are temporary.'
=> 'Eingereichte Antworten werden nicht gespeichert.',

   'By'
=> 'Durch',

   'Check All'
=> 'Alle markieren',

   'Check for All'
=> 'berprfe fr alle',

   'Check for None'
=> 'berprfe fr nichts',

   'Check for Section/Group'
=> 'berprfe fr Sektion/Gruppe',

   'Choose a different resource'
=> 'Eine andere Ressource auswhlen',

   'Concepts'
=> 'Konzepte',

   'Critical Messages'
=> 'Kritische Nachrichten',

   'Delete'
=> 'Lschen',

   'Delete Checked'
=> 'Lsche markierte',

   'Display All Messages'
=> 'Zeige alle Nachrichten',

   'Display all Messages'
=> 'Zeige alle Nachrichten',

   'Foils'
=> 'Auswahlmglichkeiten',

   'Forward'
=> 'Weiterleiten',

   'Forwarded message from'
=> 'Weitergeleitete Nachricht von',

   'Forwarding'
=> 'Weiterleiten',

   'From'
=> 'Von',

   'Functions'
=> 'Funktionen',

   'Mail'
=> 'Nachricht',

   'Mark Unread'
=> 'Kennzeichne als ungelesen',

   'New Problem Variation'
=> 'Neue Aufgabenvariation',

   'New Randomization'
=> 'Neue Variation',

   'Next'
=> 'Weiter',

   'Number of Plots:'
=> 'Anzahl an Graphen:',

   'Option Response Problem Analysis'
=> 'Analyse von option response-Aufgabe',

   'Previous'
=> 'Vorherige',

   'Re'
=> 'Antw',

   'Record'
=> 'Eintrag',

   'Reply'
=> 'Antworten',

   'Reset Submissions'
=> 'Einreichungen zurcksetzen',

   'Select a course'
=> 'Kurs auswhlen',

   'Selecting a User'
=> 'Benutzer auswhlen',

   'Send New'
=> 'Sende neue',

   'Send Reply'
=> 'Sende Antwort',

   'Send as critical message'
=> 'Sende als kritische Nachricht',

   'Simple Problem Editor'
=> 'Einfacher Aufgabeneditor',

   'Starting'
=> 'Starte',

   'Student Data Compilation Progress'
=> 'Kompilierungsfortschritt der studentischen Daten',

   'Student Data Compilation Status'
=> 'Kompilierungsstatus der studentischen Daten',

   'There is no student data for this problem.'
=> 'Fr diese Aufgabe existieren keine studentischen Daten.',

   'Time'
=> 'Zeit',

   'To'
=> 'An',

   'Uncheck All'
=> 'Alle deselektieren',

   'Unsuccessful Login'
=> 'Login fehlgeschlagen',

   'Update Student Data'
=> 'Aktualisiere Studentendaten',

   'You have no critical messages.'
=> 'Sie haben keine kritischen Nachrichten.',

   'and return receipt'
=> 'und mit Antwortbeleg',

   'can not be accessed from your location.'
=> 'kann von Ihrere Position aus nicht aufgerufen werden.',


#SYNC Fri Nov  7 16:59:44 2003

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  Kursblegung fehlgeschlagen fr: [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: Kursbelegung fehlgeschlagen.  Kein Passwort angegeben.',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: Unzulssiger Benutzername fr den Benutzer [_2] [_3] [_4] [_5]',

   'All Documents in Course'
=> 'Alle Ressourcen im Kurs',

   'All Resources (possibly large output)'
=> 'Alle Ressourcen (mglicherweise lange Ausgabe)',

   'Anonymous'
=> 'Anonym',

   'Anonymous contribution to course discussion of resource'
=> 'Anonyme Teilnahme an der Kursdiskussion ber diese Ressource',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'Generell sollten nur Autoren und Co-Autoren ber das Dateisystem authentifiziert sein (erlaubt Zugriff auf das Server-Dateisystem).',

   'Associate columns with student attributes.'
=> 'Verknpfung der Spalten aus der Datei mit den studentischen Eigenschaftsfeldern',

   'Attribute'
=> 'Eigenschaft',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (komma-separierte Liste, Tabelle)',

   'Check Course Document Versions'
=> 'berprfe Versionen der Kursdokumente',

   'Check/Set Resource Versions'
=> 'Versionen einstellen',

   'Chronological View'
=> 'Chronologische Sicht',

   'Column'
=> 'Spalte',

   'Column&nbsp;[_1]'
=> 'Spalte&nbsp;[_1]',

   'Continue enrollment?'
=> 'Trotzdem mit der Kursbelegung fortfahren?',

   'Contribution to course discussion of resource'
=> 'Normale Teilnahme an der Kursdiskussion ber die Ressource',

   'Diffs'
=> 'Unterschiede',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'Deaktiviere ID/Matrikelnummer-Safeguard und erzwinge nderung von in Konflikt stehenden IDs (Machen Sie dies nur, wenn Sie wirklich wissen, was Sie tun).',

   'Discussion Contributions'
=> 'Diskussionsbeitrge',

   'Drop Students'
=> 'Studenten ausschlieen',

   'Dropped [_1]'
=> '[_1] ausgeschlossen',

   'Dropped [_1] student(s).'
=> '[_1] Student(en) ausgeschlossen.',

   'Dropping Students'
=> 'Schliee Studenten aus',

   'Dump Course DOCS'
=> 'Kurs-Dokumente ablegen', # n.t.

   'EMail Address'
=> 'E-Mail-Adresse',

   'Enroll a single student'
=> 'Einen einzelnen Studenten eintragen',

   'Enrolling Students'
=> 'Trage Studenten ein',

   'Error'
=> 'Fehler',

   'Error dropping [_1]:[_2]'
=> 'Fehler beim Ausschlieen von [_1]:[_2]',

   'Field'
=> 'Feld',

   'Filenames in Construction Space'
=> 'Dateinamen im Konstruktionsbereich',

   'First Name'
=> 'Vorname',

   'Folder in Construction Space'
=> 'Verzeichnis im Konstruktionsbereich',

   'Full Update'
=> 'Vollstndiges Update',

   'Full update (also print list of users not enrolled anymore)'
=> 'Vollstndiges Update (auch Liste von Studenten ausgeben, die den Kurs nicht mehr belegt haben)',

   'Generation'
=> 'Generation',

   'Group/Section'
=> 'Gruppe/Sektion',

   'HTML/XML'
=> 'HTML/XML',

   'Hide'
=> 'Verbergen',

   'ID/Student Number'
=> 'ID/Matrikelnummer',

   'Identify fields'
=> 'Identifiziere Felder',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'Falls aktiv, dann wird die neue Rolle verfgbar sein, wenn sich die Studenten das nchste Mal in LON-CAPA anmelden.',

   'Ignore First Line'
=> 'Ignoriere erste Zeile',

   'Initial Password'
=> 'Anfangspasswort',

   'Internal Filename'
=> 'Interner Dateiname',

   'Invalid home server specified'
=> 'Ungltiger Home-Server angegeben',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Alle Ressourcen immer mit den neuesten Versionen aktuell halten (voreingestellt)',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA-Domne fr Studierende',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA-Kursbelegungs-Verwaltung',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA-Domne: [_1]',

   'Last Name'
=> 'Nachname',

   'Last Name, First Names'
=> 'Nachname, Vornamen',

   'Login Type'
=> 'Login-Typ',

   'Middle Names/Initials'
=> 'Zweiter Vorname/Initialen',

   'Modify Parameters'
=> 'Parameter ndern',

   'Modify student data'
=> 'Bearbeite Studentendaten',

   'Most recently published Version'
=> 'Zuletzt verffentlichte Version',

   'No Kerberos domain was specified.'
=> 'Es wurde keine Kerberos-Domne angegeben.',

   'None Found'
=> 'Kein gefunden',

   'Note: for large courses, this operation may be time consuming'
=> 'Anmerkung: Fr groe Kurse kann die Ausfhrung lange dauern.',

   'Note: this will not take effect if the user already exists'
=> 'Anmerkung: Diese Einstellung bleibt ohne Wirkung, falls der Benutzer bereits existiert.',

   'Processed [_1] student(s).'
=> '[_1] Studierende bearbeitet.',

   'Re-enrollment will re-activate data.'
=> 'Eine erneute Kursbelegung wird die Daten reaktivieren.',

   'Registering'
=> 'Registriere',

   'Samples'
=> 'Beispiele',

   'Save as ...'
=> 'Speichern unter...',

   'Set Version to be used in Course'
=> 'Setze Version als die im Kurs genutzte',

   'Set Versions to be used in Course according to Selections below'
=> 'Versionen gem der unten getroffenen Auswahlen einstellen',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Alle Ressourcen auf die derzeitige Version festsetzen',

   'Show Preview'
=> 'Zeige Vorschau',

   'Space separated'
=> 'Durch Leerzeichen getrennt',

   'Starting and Ending Dates'
=> 'Start- und Endezeitpunkte',

   'Student Number'
=> 'Matrikelnummer',

   'Tabulator separated'
=> 'Durch Tabulatoren getrennt',

   'The optional email address field was not specified.'
=> 'Das optionale E-Mail-Adress-Feld wurde nicht ausgefllt.',

   'The optional name field was not specified.'
=> 'Das optionale Namensfeld wurde nicht ausgefllt.',

   'The optional section or group field was not specified.'
=> 'Das optionale Sektions- oder Gruppenfeld wurde nicht ausgefllt.',

   'The optional student number field was not specified.'
=> 'Das optionale Matrikelnummer-Feld wurde nicht ausgefllt.',

   'There are no students currently enrolled.'
=> 'Derzeit haben keine Studierenden den Kurs belegt.',

   'Threaded View'
=> 'Thread-Ansicht',

   'Total number of records found in file: [_1].'
=> 'Gesamtanzahl an Eintrgen, die in der Datei gefunden wurden: [_1].',

   'Unable to enroll students'
=> 'Konnte Studenten nicht eintragen.',

   'Updating discussion time'
=> 'Aktualisiere Diskussionszeit',

   'Upload a class list'
=> 'Kursteilnehmerliste hochladen',

   'Uploading Class List'
=> 'Lade Kursteilnehmerliste hoch',

   'Verify Content'
=> 'Inhalte prfen',

   'Version changes since Yesterday'
=> 'Versionsnderungen seit gestern',

   'Version changes since last Month'
=> 'Versionsnderungen seit letztem Monat',

   'Version changes since last Week'
=> 'Versionsnderungen seit letzter Woche',

   'Version changes since start of Course'
=> 'Versionsnderungen seit Beginn des Kurses',

   'Version used in Course'
=> 'Version, die im Kurs verwendet wird',

   'View Class List'
=> 'Zeige Kursteilnehmerliste',

   'Welcome'
=> 'Willkommen',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'Willkommen zu LON-CAPA. Bitte warten Sie whrend Ihre Sitzung vorbereitet wird',

   'You must choose an authentication type.'
=> 'Sie mssen einen Authentifizierungstyp auswhlen.',

   'You need to specify the Kerberos domain.'
=> 'Sie mssen eine Kerberos-Domne auswhlen.',

   'You need to specify the initial password.'
=> 'Sie mssen ein initiales Passwort auswhlen.',

   'You need to specify the username field.'
=> 'Sie mssen das Benutzernamen-Feld ausfllen.',

   'Your Version Settings have been Saved'
=> 'Ihre Versionseinstellungen wurden gespeichert',

   '[_1] Do not change login data'
=> '[_1] Login-Daten nicht ndern',

   '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])'
=> '[_1] Authentifizierung ueber Dateisystem (mit Anfangspasswort [_2])',

   '[_1] Internally authenticated (mit Anfangspasswort [_2])'
=> '[_1] Intern authentifiziert (mit Anfangspasswort [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authentifiziert mit Domnen [_2] [_3] Version 4 [_4] Version 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Lokal authentifiziert mit Argument [_2]',

   'most recent'
=> 'neuester',

   'name only visible to course faculty'
=> 'Name nur fr Kursverwaltung sichtbar',



#SYNC Fri Nov  7 22:00:17 2003
   'Calculate answers'
=> 'Berechne Antworten',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Zeige&nbsp;alle&nbsp;Auswahlmglichkeiten',

   '1 out of N multiple choice (radio button)'
=> '1-aus-N-Auswahl (radio button)',

   'Add new option'
=> 'Fge neue Option ein',

   'Administrator'
=> 'Administrator',

   'Answer:'
=> 'Antwort:',

   'Attachment'
=> 'Anhang',

   'Calculate answers'
=> 'Berechne Antworten',

   'Change'
=> 'ndern',

   'Change Random Seed To:'
=> 'Zufallszahlengenerator-Startwert:',

   'Change Your Language Preferences'
=> 'ndere Spracheinstellungen',

   'Concept:'
=> 'Konzept:',

   'Correct Option:'
=> 'Korrekte Auswahl:',

   'Create a New Course'
# => 'Erzeuge einen neuen Kurs',
=> 'Kurse erstellen',

   'Current'
=> 'Derzeitig',

   'Delete an option'
=> 'Lsche eine Option',

   'Delete:'
=> 'Lschen:',

   'Diffs with Current Version'
=> 'Unterschiede zur derzeitigen Version',

   'Diffs with Version'
=> 'Unterscheidet sich von Version',

   'Diffs with current Version'
=> 'Unterschiede zur derzeitigen Version',

   'Display and analysis of submission times on assessments.'
=> 'Anzeige und Analyse der Einreichungszeiten in Beurteilungen',

   'Display foils in order given'
=> 'Auswahlmglichkeiten in gegebener Sortierung anzeigen',

   'Display foils in random order'
=> 'Auswahlmglichkeiten in zuflliger Reihenfolge anzeigen',

   'Domain Guest'
=> 'Domnengast',

   'Essay, open end'
=> 'Essay, keine Zeitbegrenzung',

   'False'
=> 'Falsch',

   'Foil'
=> 'Auswahlmglichkeit',

   'Format:'
=> 'Format:',

   'Height(pixel):'
=> 'Hhe (Pixel):',

   'Hint Text'
=> 'Lsungshinweis',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'Wenn diese Ressource in Benutzung ist, ist es mglich, dass auf Leistungsdaten der Studenten von vorhergehenden Versionen nicht mehr zugegriffen werden kann.',

   'Image:'
=> 'Bild:',

   'Incorrect Answers:'
=> 'Falsche Antworten:',

   'Last accessed'
=> 'Zuletzt zugegriffen',

   'Librarian'
=> 'Bibliothekar',

   'Making Backup to [_1]'
=> 'Erstelle Sicherungsdatei in [_1]',

   'Max Number Of Shown Foils:'
=> 'Maximale Anzahl anzuzeigender Auswahlmglichkeiten:',

   'Max number of foils displayed'
=> 'Maximale Anzahl gezeigter Auswahlmglichkeiten',

   'Metadata'
=> 'Metadaten',

   'Metadata Version'
=> 'Metadaten-Version',

   'Metadata current version'
=> 'Derzeitige Version der Metadaten',

   'Name:'
=> 'Name:',

   'New parameters or saved values'
=> 'Neue Parameter oder gespeicherte Werte',

   'No language preference'
=> 'Keine Sprachprferenz',

   'Not shown, not used'
=> 'Nicht gezeigt, nicht benutzt',

   'Obsolete parameters or saved values'
=> 'Veraltete Parameter oder gespeicherte Werte',

   'Option response'
=> 'Option Antwort',

   'Please do not reply to this address.'
=> 'Bitte nicht an diese Adresse antworten.',

   'Please select a report to generate'
=> 'Bitte einen Bericht zum Erstellen auswhlen',

   'Position'
=> 'Position',

   'Preferred language'
=> 'Bevorzugte Sprache',

   'Problems'
=> 'Probleme',

   'Produce Excel Output'
=> 'Erstelle Excel-Ausgabe',

   'Question Text'
=> 'Fragetext',

   'Question Type'
=> 'Aufgabentyp',

   'Random position'
=> 'Zufllige Position',

   'Retrieve Published Resources'
=> 'Verffentlichte Ressourcen wiederherstellen',

   'Short string response'
=> 'Kurze String-Antwort',

   'Show always at bottom position'
=> 'Immer am Ende anzeigen',

   'Show always at top position'
=> 'Immer an Anfang anzeigen',

   'Size:'
=> 'Gre:',

   'Save Changes'
=> 'nderungen speichern',

   'Submission Time Analysis'
=> 'Analyse der Einreichzeit',

   'Submit Changes and Edit'
=> 'Speichern und weiterbearbeiten',

   'TeXWidth(mm):'
=> 'TeX-Breite (mm):',

   'Text'
=> 'Text',

   'Text Block'
=> 'Textblock',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'Dies ist eine durch LON-CAPA automatisch erstellte Nachricht.',

   'True'
=> 'Wahr',

   'Type-in value'
=> 'eingebbarer Wert',

   'Unit:'
=> 'Einheit:',

   'Value'
=> 'Wert',

   'Warning!'
=> 'Achtung!',

   'Width(pixel):'
=> 'Breite (Pixel):',

   'anonymous'
=> 'anonym',

   'bytes'
=> 'Bytes',

   'loginproblems.html'
=> 'loginproblems.html',

   'versions of this problem'
=> 'Versionen von dieser Aufgabe',


   'calendar[_1]'
=> 'Kalender[_1]',

   'announce[_1]'
=> 'ankndigen[_1]',


   'commu-[_1]'
=> 'Kommu-[_1]',

   'nication[_1]'
=> 'nikation[_1]',


   'course[_10]'
=> 'Kurs[_10]',

   'chat[_1]'
=> 'chat[_1]',


   'search[_1]'
=> 'suche[_1]',

   'course[_11]'
=> 'Kurs[_11]',


   'search[_2]'
=> 'search[_2]',

   'library[_1]'
=> 'library[_1]',


   'prefer-[_1]'
=> 'Prfe-[_1]',

   'ences[_1]'
=> 'renzen[_1]',


   'exit[_1]'
=> 'abmelden[_1]',

   ' [_1]'
=> ' [_1]',


   'switch[_2]'
=> 'wechsle[_2]',

   'role[_1]'
=> 'Rolle[_1]',


   'choose[_2]'
=> 'whle[_2]',

   'role[_2]'
=> 'Rolle[_2]',


   'choose[_1]'
=> 'whle[_1]',

   'course[_1]'
=> 'Kurs[_1]',


   'switch[_1]'
=> 'wechsle[_1]',

   'course[_2]'
=> 'Kurs[_2]',


   'course[_3]'
=> 'Kurs[_3]',

   'docs[_1]'
=> 'Dokumente[_1]',


   'edit crs[_1]'
=> 'Bearbeite crs[_1]',

   'docs[_2]'
=> 'Dokumentation[_2]',


   'navigate[_1]'
=> 'Inhalts-[_1]',

   'contents[_1]'
=> 'verzeich[_1]',


   'my[_1]'
=> 'meine[_1]',

   'grades[_1]'
=> 'Noten[_1]',


   'course[_4]'
=> 'Kurs[_4]',

   'grades[_2]'
=> 'Noten[_2]',


   'course[_5]'
=> 'Kurs[_5]',

   'chart[_1]'
=> 'Diagramm[_1]',


   'course[_6]'
=> 'Kurs[_6]',

   'stats[_1]'
=> 'Statistiken[_1]',


   'course[_7]'
=> 'Kurs[_7]',

   'enroll[_1]'
=> 'Kursbelegung durchfhren fr[_1]',


   'manage[_1]'
=> 'verwalte[_1]',

   'acc keys[_1]'
=> 'acc keys[_1]',


   'user[_1]'
=> 'Benutzer[_1]',

   'roles[_1]'
=> 'Rollen[_1]',


   'user[_1]'
=> 'Benutzer[_1]',

   'roles[_1]'
=> 'Rollen[_1]',


   'user[_1]'
=> 'Benutzer[_1]',

   'roles[_1]'
=> 'Rollen[_1]',


   'create[_1]'
=> 'erstelle[_1]',

   'course[_8]'
=> 'Kurs[_8]',


   'course[_9]'
=> 'Kurs[_9]',

   'parms[_1]'
=> 'Parameter[_1]',


   'con-[_1]'
=> 'Kon-[_1]',

   'struct[_1]'
=> 'strukt[_1]',


   'co con-[_1]'
=> 'Co-Kon-[_1]',

   'struct[_2]'
=> 'strukt[_2]',


   'resource[_1]'
=> 'Ressource[_1]',

   'space[_1]'
=> 'Bereich[_1]',


   'co res[_1]'
=> 'Co-Res[_1]',

   'space[_2]'
=> 'Bereich[_2]',


   'resource[_1]'
=> 'Ressource[_1]',

   'space[_1]'
=> 'Bereich[_1]',


   'enter[_1]'
=> 'eingeben[_1]',

   'grades[_2]'
=> 'Noten[_2]',


   'send[_1]'
=> 'schicke[_1]',

   'scantron[_1]'
=> 'Scantron[_1]',


   'view[_1]'
=> 'betrachte[_1]',

   'bookmark[_1]'
=> 'Lesezeichen[_1]',



#SYNC Sat Apr 17 10:04:35 2004

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Geben Sie maximal [_1] Mitarbeiternamen ein, in der Form Benutzername oder Benutzername@Domne, z.B. mustermann oder mustermann@[_2].)',

   '(Hand in a file you have prepared on your computer)'
=> '(Reichen Sie eine Datei ein, die Sie auf Ihrem Computer vorbereitet haben)',

   ', select a template from the pull-down menu below.'
=> ', whlen Sie eine Vorlage aus dem folgenden Auswahlmen aus.',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>-Tags sind zugleich innerhalb und auerhalb eines <part>-Tags. Dies ist keine gltige Aufgabe. Beim Bewerten knnen Fehler auftreten.',

   'ABSTRACT'
=> 'BERBLICK',

   'Access Control'
=> 'Zugangskontrolle',

   'Activate'
=> 'Aktivieren',

   'Add Roles'
=> 'Rollen hinzufgen',

   "Add one empty page/column after each student's assignment"
=> "Fge eine leere Seite/Spalte nach jeder studentischen bung ein",

   "Add three empty pages/column after each student's assignment"
=> "Fge drei leere Seiten/Spalten nach jeder studentischen bung ein",

   "Add two empty pages/column after each student's assignment"
=> "Fge zwei leere Seiten/Spalten nach jeder studentischen bung ein",

   'Additional settings, if specified below, will override cloned settings'
=> 'Weitere Einstellungen, falls unten angegeben, werden erzeugte Einstellungen berschreiben',

   'Advanced Edit'
=> 'Erweiterter Editor',

   'All Resources'
=> 'Alle Ressourcen',

   'All Students'
=> 'Alle Studierenden',

   'Allowed filetypes: <b>[_1]</b>'
=> 'Akzeptierte Dateitypen: <b>[_1]</b>',

   'An error occured during the attempt to change the section for this student.'
=> 'Beim ndern der Sektion fr diesen Studenten trat ein Fehler auf.',

   'An error occurred during the attempt to change the role information for this student.'
=> 'Beim ndern der Rolleninformationen fr diesen Studenten trat ein Fehler auf.',

   'Analyzing Results'
=> 'Analysiere Ergebnisse',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Antwort eingereicht. Die Daten werden nach dem Flligkeitsdatum ausgewertet.',

   'Answerable'
=> 'Beantwortbar',

   'Assessment Parameters'
=> 'Parameter zur Beurteilung',

   'Automated Enrollment Manager'
=> 'Automatisierte Kursbelegungs-Verwaltung',

   'Automated adds'
=> 'Automatische Hinzufgungen',

   'Automated drops'
=> 'Automatische Ausschlieungen',

   'Automated enrollment settings'
=> 'Einstellungen fr automatische Kursbelegung',

   'Bad Filename'
=> 'Ungltiger Dateiname',

   'Begin Enrollment'
=> 'Kursbelegung beginnen',

   'Binary File'
=> 'Binrdatei',

   'Blank'
=> 'Leer',

   'Browse'
=> 'Durchblttern',

   'CSV format'
=> 'CSV Format',

   'Cannot publish directory'
=> 'Kann Verzeichnis nicht verffentlichen',

   'Cannot retrieve directory'
=> 'Kann Verzeichnis nicht wiederherstellen',

   'Catalog Search'
=> 'Katalogsuche',

   'Change User Privileges'
=> 'Benutzerrechte ndern',

   'Changed discussion view mode'
=> 'Ansichtsmodus der Diskussion gendert',

   'Click here for FAQ'
=> 'Hufig gestellte Fragen',

   'Click here for help'
=> 'Hilfe',

   'Click here to report bugs'
=> 'Hier zum Melden von Fehlern klicken',

   'Click-On Texts (comma sep):'
=> 'Texte zum Anklicken (durch Kommas getrennt):',

   'Clone an existing course'
=> 'Einen bestehenden Kurs clonen',

   'Close This Window'
=> 'Dieses Fenster schlieen',

   'Closed'
=> 'Geschlossen',

   'Communication'
=> 'Kommunikation',

   'Compare versions of'
=> 'Vergleiche Versionen von',

   'Completely new course'
=> 'Komplett neuer Kurs',

   'Construction Space Version'
=> 'Version des Konstruktionsbreichs',

   'Continue'
=> 'Weiter',

   'Copy current file to'
=> 'Kopiere derzeitige Datei nach',

   'Copy selected'
=> 'Kopiere ausgewhlte',

   'Course Code'
=> 'Kurscode',

   'Course Content'
=> 'Kursinhalt',

   'Course Data'
=> 'Kursdaten',

   'Course Home Server'
=> 'Heimatserver des Kurses',

   'Course ID/Number'
=> 'Kurs ID/Nummer',

   'Course Information'
=> 'Kursinformationen',

   'Course Level'
=> 'Auf Kursebene',

   'Course Search'
=> 'Suche im Kurs',

   'Course Title'
=> 'Kurstitel',

   'Create New User'
=> 'Neuen Benutzer erstellen',

   'Create User'
=> 'Benutzer erstellen',

   'Creating a new'
=> 'Erstelle neue',

   'Crosslisted courses'
=> 'Fachbereichsbergreifene Kurse',

   'Current Class List'
=> 'Aktuelle Kursteilnehmerliste',

   'Current Ending Date: [_1]'
=> 'Derzeitiges Endedatum: [_1]',

   'Current Ending Date: not set'
=> 'Derzeitiges Endedatum: nicht gesetzt',

   'Current Resource'
=> 'Derzeitige Ressource',

   'Current Starting Date: [_1]'
=> 'Derzeitiges Anfangsdatum: [_1]',

   'Current Starting Date: not set'
=> 'Derzeitiges Anfangsdatum: nicht gesetzt',

   'Current Version'
=> 'Derzeitige Version',

   'Currently no active roles or courses'
=> 'Derzeit keine aktiven Rollen oder Kurse',

   'Currently no additional roles or courses'
=> 'Derzeit keine zustzlichen Rollen oder Kurse',

   'Currently submitted: <tt>[_1]</tt>'
=> 'Derzeit eingereicht: <tt>[_1]</tt>',

   'Custom Role Editor'
=> 'Individueller Rolleneditor',

   'Cut selected'
=> 'Auswahl ausschneiden',

   'Decompress'
=> 'Dekomprimieren',

   'Default Assessment Spreadsheet'
=> 'Standard-Beurteilungsbogen',

   'Default Course Spreadsheet'
=> 'Standardkursbogen',

   'Default Student Spreadsheet'
=> 'Standardstudentenbogen',

   'Default XML Style File'
=> 'Standard-XML-Style-Datei',

   'Default for new courses is'
=> 'Standard fr neue Kurse ist',

   'Default:'
=> 'Voreingestellt:',

   'Define Role'
=> 'Definiere Rolle',

   'Dependencies'
=> 'Abhngigkeiten',

   'Description:'
=> 'Beschreibung:',

   'Disable student resource discussion'
=> 'Deaktiviere Studentendiskussion ber Ressource',

   'Disable student use of chatrooms'
=> 'Chatroom-Nutzungsmglichkeit fr Studenten deaktivieren',

   'Display file attributes'
=> 'Zeige Dateiattribute',

   'Do NOT generate as standard course'
=> 'NICHT als Standard-Kurs erstellen',

   'Domain Level'
=> 'Auf Domnenebene',

   "Don't Show Feedback"
=> "Kein Feedback anzeigen",

   'Duration of automated classlist updates'
=> 'Dauer der automatischen Updates der Kursteilnehmerlisten',

   'Dynamic Metadata (updated periodically)'
=> 'Dynamische Metadaten (periodisch erneuert)',

   'ERROR'
=> 'FEHLER',

   'Edit Custom Role Privileges'
=> 'Bearbeite individuelle Rollenprivilegien',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Fehler - diese Fehler mssen das Ausfhren der Aufgabe nicht beeinflussen, aber sie werden wahrscheinlich Probleme mit der weiteren Benutzung des Editormodus verursachen. Bearbeiten Sie bitte die Aufgabe im XML-Modus, um diese Fehler zu beheben.',

   'End Time'
=> 'Endezeit',

   'Ending Date'
=> 'Endedatum',

   'English - ISO'
=> 'Englisch - ISO',

   'Enroll One Student'
=> 'Einen einzelnen Studenten den Kurs belegen lassen',

   'Enroll as student'
=> 'Student den Kurs belegen lassen',

   'Enrolling'
=> 'Belege',

   'Enrolling Student'
=> 'Student wird in den Kurs aufgenommen',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Fllen Sie so viele Felder wie mglich aus. Das System wird Sie informieren und zu dieser Seite zurckbringen, falls die Daten nicht ausreichen, Studierende in Ihren Kurs einzuschreiben.',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Geben Sie Suchbegriffe oder -Stze ein. Sie knnen AND, OR und NOT als Such-Operatoren verwenden. Klicken Sie anschlieend unten auf SUCHEN.',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Geben Sie Suchbegriffe oder -Stze ein. Sie knnen als Such-Operatoren AND, OR und NOT verwenden.',

   'Entering Construction Space'
=> 'Betrete Konstruktionsbereich',

   'Error: Directory Non Empty'
=> 'Fehler: Verzeichnis nicht leer',

   'Error: destination for operation is an existing directory.'
=> 'Fehler: Das Ziel der Operation ist ein existierendes Verzeichnis.',

   'Evaluation Error '
=> 'Auswertefehler',

   'Exam Problem'
=> 'Prfungsaufgabe',

   'Excel format'
=> 'Excel-Format',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback-Adressen fr Kommentare zu Kursinhalten',

   'Feedback Addresses for Course Policy'
=> 'Feedback-Adressen fr Kursrichtlinien',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback-Adressen fr Fragen zum Inhalt der Ressourcen',

   'First'
=> 'Erste',

   'First Resource'
=> 'Erste Ressource',

   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Die Auswahlmglichkeits-Bezeichnung <b><tt>[_1]</tt></b> tritt mehr als einmal auf. Bezeichnungen fr Auswahlmglichkeiten mssen eindeutig sein.',

   'Folder/Map'
=> 'Verzeichnis/Inhaltszusammenstellung',

   'For one or more students'
=> 'Fr einen oder mehrere Studierende',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Es wurde ein &lt;*response&gt;-Tag auerhalb eines &lt;part&gt;-Bereichs einer Aufgabe gefunden, die Aufgabenteile verwendet.',

   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Keine analysierbaren korrekten Antworten in dieser Aufgabe gefunden. Derzeit werden nur numerische Ausdrcke, Formeln und Strings als Antworttypen untersttzt.',

   'Generate messages from a file'
=> 'Erstelle Nachrichten aus Datei',

   'German - ISO'
=> 'Deutsch - ISO',

   'Go'
=> 'Go',

   'Go to ...'
=> 'Gehe nach ...', # n.t.

   'Help on Creating Courses'
=> 'Hilfe bei der Kurserstellung',

   'Home Server'
=> 'Heimatserver',

   'Homework problem'
=> 'Hausaufgabe',

   'How do I create a CSV file from a spreadsheet'
=> 'Wie erstelle ich eine CSV-Datei von einem Spreadsheet?',

   'How do I create a class list from a spreadsheet'
=> 'Wie erstelle ich eine Kursteilnehmerliste von einem Spreadsheet',

   'How should the results be printed?'
=> 'Wie sollten die Resultate ausgedruckt werden?',

   'Immediately expire own role as Course Coordinator'
=> 'Eigene Rolle als Kurs-Koordinator mit sofortiger Wirkung verfallen lassen',

   'Import and Paste Area'
=> 'Feld zum Importieren und Einfgen',

   'Include retrieval of student photographs?'
=> 'Abfrage von Studentenbildern einbinden?',

   'Institutional Information'
=> 'Institutionelle Information',

   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',

   'Invalid Significant figures detected'
=> 'Unpassende signifikante Stellen entdeckt',

   'Invalid characters in requested name have been removed.'
=> 'Ungltige Buchstaben in dem angefragten Namen sind entfernt worden.',

   'Invalid login mode or password.'
=> 'Falscher Login-Modus oder Password.',

   'Invalid username or domain'
=> 'Ungltiger Benutzername oder Domne',

   'Japanese - UTF'
=> 'Japanisch - UTF',

   'KEYWORDS'
=> 'SCHLSSELWRTER',

   'LaTeX batchmode'
=> 'LaTeX-Batchmodus',

   'LaTeX mode'
=> 'LaTeX-Modus',

   'Languages used'
=> 'Benutzte Sprachen',

   'Last'
=> 'Letzte',

   'Leave blank on scoring form'
=> 'Im Bewertungsformular leer lassen',

   'List Directory'
=> 'Verzeichnisinhalt auflisten',

   'Location'
=> 'Ort',

   'Login Data'
=> 'Login Daten',

   'Logout'
=> 'Abmelden',

   'Make new directory'
=> 'Neues Verzeichnis erstellen',

   'Make new file'
=> 'Neue Datei erstellen',

   'Manual Grading'
=> 'Manuelle Benotung',

   'Map has branchings. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Verzweigungen. Verwenden Sie den erweiterten Editor.',

   'Map has conditions. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Bedingungen. Verwenden Sie den erweiterten Editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Ressourcen-Parameter. Verwenden Sie den erweiterten Editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat unverknpfte Ressourcen. Verwenden Sie den erweiterten Editor.',

   'Maximum Number of Collaborators'
=> 'Maximale Anzahl an Mitarbeitern',

   'Messaging'
=> 'Versenden von Nachrichten',

   'Middle'
=> 'Mitte',

   'Middle Name'
=> '2. Vorname',

   'Missing Kerberos domain information.'
=> 'Fehlende Kerberos-Domnen-Informationen.',

   'Modification may make assessment data inaccessible'
=> 'Eine Vernderung knnte die Beurteilungsdaten unzugnglich machen',

   'Modify Enrollment for'
=> 'Bearbeite Kursbelegung fr',

   'Modify User'
=> 'Benutzerdaten modifizieren',

   'Modify another students data'
=> 'Daten eines anderen Studenten bearbeiten',

   'Modify deadlines, etc, for this resource'
=> 'Deadlines, etc, fr diese Ressource bearbeiten',

   'Modifying data for user'
=> 'Daten fr Benutzer bearbeiten',

   'Modifying this will make problems'
=> 'Eine Vernderung wird bewirken, dass Aufgaben', # 1/2: whole text instead of two parts is recommended [SB 19.10.2006]

   'Move current file to'
=> 'Derzeitige Datei verschieben nach',

   'Must create new subdirectory inside a directory'
=> 'Mssen ein neues Unterverzeichnis in dem Verzeichnis erstellen',

   'Name of Role'
=> 'Bezeichnung der Rolle',

   'Navigate'
=> 'Navigiere',

   'New Directory'
=> 'Neues Verzeichnis',

   'New HTML file'
=> 'Neue HTML-Datei',

   'New Resource'
=> 'Neue Ressource',

   'New Role'
=> 'Neue Rolle',

   'New User'
=> 'Neuer Benutzer',

   'New Value'
=> 'Neuer Wert',

   'New assembled page'
=> 'Neue zusammengesetzte Seite',

   'New assembled sequence'
=> 'Neue zusammengesetzte Sequenz',

   'New custom rights file'
=> 'Neue Datei zur Zugriffkontrolle',

   'New file'
=> 'Neue Datei',

   'New problem'
=> 'Neue Aufgabe',

   'New style file'
=> 'Neue Style-Datei',

   'New subdirectory'
=> 'Neues Unterverzeichnis',

   'Next    '
=> 'Weiter    ',

   'No'
=> 'Nein',

   'No Access or Usages Statistics are available for this resource.'
=> 'Keine Zugriffs- oder Nutzungsstatistiken fr diese Ressource verfgbar.',

   'No Assessment Statistical Data is available for this resource'
=> 'Fr diese Ressource ist keine Beurteilungs-Statistik verfgbar.',

   'No Evaluation Data is available for this resource.'
=> 'Fr diese Ressource sind keine Auswertungsdaten verfgbar.',

   'No new filename specified.'
=> 'Kein neuer Dateiname angegeben.',

   'No such file'
=> 'Datei nicht gefunden',

   'Not Allowed'
=> 'Verboten',

   'Not applicable -'
=> 'Nicht anwendbar -',

   'Not open to be viewed'
=> 'Ressource darf nicht betrachtet werden',

   'Not set -'
=> 'Nicht gesetzt -',

   'Notification of enrollment changes'
=> 'Benachrichtigung ber nderungen der Kursbelegung',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Soll LON-CAPA den <b>Kurs-Koordinator</b> benachrichtigen, wenn whrend eines automatischen Updates nderungen an der Kursbelegung auftreten?',

   'Number of columns'
=> 'Anzahl an Spalten',

   'Old Value'
=> 'Alter Wert',

   'One particular problem (overrides folder and course defaults)'
=> 'Eine bestimmte Aufgabe (berschreibt Verzeichnis- und Kurs-Defaultwerte)',

   'Online Help'
=> 'Online-Hilfe',

   'Only Answers'
=> 'Nur Antworten',

   'Only domain coordinators can change a users password.'
=> 'Nur Domnen-Koordinatoren knnen das Passwort eines Benutzers ndern.',

   'Open Course'
=> 'Kurs anlegen',

   'Open all assessments'
=> 'Mache alle Beurteilungen zugnglich',

   'Open and correct'
=> 'ffnen und korrigieren',

   'Open with full tries'
=> 'ffnen mit allen Versuchen',

   'Output Format: [_1]'
=> 'Ausgabeformat: [_1]',

   'Page layout'
=> 'Seitenlayout',

   'Paper type'
=> 'Papiertyp',

   'Parameter'
=> 'Parameter',

   'Paste after selected'
=> 'In Auswahl einfgen',

   'Personal Data'
=> 'Persnliche Daten',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Whlen Sie hier die voreingestellte Authentifizierungs-Methode aus, die bei durch automatisierten Einschreibungsprozess dieser LON-CAPA-Domne hinzugefgten Benutzern verwendet werden soll.',

   'Please click Back on your browser and select another user, or '
=> 'Bitte klicken Sie auf Zurck in Ihrem Webbrowser und whlen Sie einen anderen Benutzer aus oder ',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Bitte kontaktieren Sie zu dieser Angelegenheit Ihren LON-CAPA-Administrator.',

   'Please select an authentication mechanism'
=> 'Whlen Sie bitte eine Authentifizierungs-Methode aus',

   'Please select the authentication mechanism'
=> 'Auswahl der Authentifizierungs-Methode',

   'Please stand by.'
=> 'Bitte warten.',

   "Please use browser 'Back' button and pick a filename"
=> "Benutzen Sie bitte den Zurck-Button des Webbrowsers und whlen Sie einen Dateinamen aus",

   'Portuguese - ISO'
=> 'Portugiesisch- ISO',

   'Preparing Printout'
=> 'Bereite Ausdruck vor',

   'Print'
=> 'Drucken',

   'Print Index'
=> 'Drucke Index',

   'Print Table of Contents'
=> 'Drucke Inhaltsverzeichnis',

   'Print:'
=> 'Drucke:',

   'Problems from entire course'
=> 'Aufgaben des gesamten Kurses',

   'Processed file'
=> 'verarbeitete Datei',

   'Publish this Resource'
=> 'Diese Ressource verffentlichen',

   'Randomization algorithm used'
=> 'Verwendeter Randomisierungs-Algorithmus',

   'Recent'
=> 'zuletzt',

   'Rename current file to'
=> 'Derzeitige Datei umbenennen in',

   'Report a Bug'
=> 'Einen Fehler melden',

   'Resource'
=> 'Ressource',

   'Resource Differences'
=> 'Ressourcen-Unterschiede',

   'Resources from selected sequence in course'
=> 'Ressourcen von ausgewhlten Sequenzen im Kurs',

   'Response'
=> 'Antwort',

   'Retrieve Old Version'
=> 'Alte Version wiederherstellen',

   'Retrieving current (most recent) version'
=> 'Rufe aktuelleste Version ab',

   'Return to DOCS'
=> 'Zurck zu "Kursdokumente"',

   'Reverse Association'
=> 'Umgekehrte Assoziierung', # n.t.

   'Revoke'
=> 'Entziehen',

   'Revoke Existing Roles'
=> 'Bestehende Rollen entziehen',

   'Role'
=> 'Rolle',

   'Role Information'
=> 'Information zur Rolle',

   'Russian - KOI'
=> 'Russisch - KOI',

   'Sample Points:'
=> 'Abtastpunkte:',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Die untenstehenden Eintragungen als Entwurf speichern (aber noch nicht endgltig einreichen)',

   'Select Action'
=> 'Aktion auswhlen',

   'Select All Resources'
=> 'Alle Ressourcen auswhlen',

   'Select Printing Options:'
=> 'Druckoptionen auswhlen:',

   'Select Problem(s) to print'
=> 'Aufgaben zum Ausdrucken whlen',

   'Select Resource(s) to print'
=> 'Ressource(n) zum Ausdrucken whlen',

   'Select Resources To Print'
=> 'Ressourcen zum Ausdrucken whlen',

   'Select Section'
=> 'Sektion auswhlen',

   'Select Sequence To Print From'
=> 'Sequenz, von der gedruckt werden soll, auswhlen',

   'Select Students and Resources'
=> 'Studierenden und Ressourcen auswhlen',

   'Select Style File'
=> 'Styledatei auswhlen',

   'Select a user name to modify the students information'
=> 'Whlen Sie einen Benutzernamen zum ndern der Informationen des Studierenden',

   'Select a user name to view the users personal page.'
=> 'Whlen Sie einen Benutzernamen, von welchem Sie die persnliche Seite ansehen mchten.',

   'Select resources for the assignment'
=> 'Whlen Sie Ressourcen fr die bung aus',

   'Set'
=> 'Setze',

   'Set Course Environment'
=> 'Kursumgebung einstellen', # conflict: menu and button

   'Set End Date'
=> 'Endedatum festlegen',

   'Set Individual User Roles'
=> 'Benutzerrollen und -rechte einstellen',

   'Set Start Date'
=> 'Startdatum festlegen',

   'Set content feedback to Course Coordinator'
=> 'Inhaltsbezogenes Feedback soll Kurs-Koordinator erhalten',

   'Set course policy feedback to Course Coordinator'
=> 'Feedback bzgl. Kursrichtlinien soll Kurs-Koordinator erhalten',

   'Set opening date for all problems in the course for. . .'
=> 'Setze ffnungstermin fr alle Aufgaben in dem Kurs auf. . .',

   'Set to ...'
=> 'Setze auf ...',

   'Show Answer'
=> 'Zeige Antwort',

   'Show Feedback'
=> 'Zeige Feedback',

   'Show all rles'
=> 'Zeige alle Rollen',

   'Simple Edit'
=> 'Einfacher Editor',

   'Some items were not submitted.'
=> 'Die Fragen wurden nicht vollstndig beantwortet.',

   'Start Time'
=> 'Startzeit',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Beginne jede studentische bung auf einer neuen Seite/Spalte (fge einen Seitenvorschub nach jeder bung ein)",

   'Starting Date'
=> 'Anfangsdatum',

   'Student ID'
=> 'Matrikelnummer',

   'Student Information'
=> 'Studenten-Informationen',

   'Student Sheet Links'
=> 'Tabellenlinks des Studierenden',

   'Student Status'
=> 'Studierendenstatus',

   'Student Status: [_1]'
=> 'Studierendenstatus: [_1]',

   'Student information updated successfully.'
=> 'Studenten-Informationen erfolgreich aktualisiert.',

   'Students need access key to enter course'
=> 'Die Studierenden bentigen einen Zugangskey zum Betreten des Kurses',

   'Students with expired roles'
=> 'Studierende mit abgelaufenen Rollen',

   'Subject:'
=> 'Betreff:',

   'Submissions'
=> 'Einreichungen',

   'Submit Modifications'
=> 'Vernderungen einreichen',

   'Submit entries below as answer to receive credit'
=> 'Die untenstehenden Eintragungen einreichen',

   'Survey Question'
=> 'Umfrage-Frage',

   'System Level'
=> 'Systemlevel',

   'Target Edit Map'
=> 'Ziel Editor Inhaltszusammenstellung', #??? [SB 18.10.2006]

   'TeX unconverted due to errors'
=> 'TeX wegen Fehlern nicht konvertiert',

   'TeX unconverted due to previous errors'
=> 'TeX aufgrund vorheriger Fehler nicht konvertiert',

   'The error reported was'
=> 'Der genannte Fehler war',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'Die folgenden Eintrge werden benutzt, um den Kurs gem des Namensschemas Ihrer Institution zu identifizieren. Ihre Auswahl wird benutzt werden, um eine interne LON-CAPA-Kurs-ID mit der/den zugehrigen Kurs-Sektion-ID(s) zu verbinden. Diese ID(s) werden von der Einrichtung verwendet, die fr das zur Verfgungstellen der offiziellen Kurslisten an Ihrer Institution zustndig ist (z.B. Prfungsamt). Diese Zuordnung is notwendig, wenn Sie die automatische Ergnzung von Kurslisten whlen.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "Die folgenden Einstellungen kontrollieren das automatische Kurs-Belegen von Studierenden in diesen Kurs anhand der verfgbaren Informationen fr diesen Kurs von der offiziellen Kursteilnehmerliste Ihrer Institution.",

   'The requested file'
=> 'Die angeforderte Datei',

   'The student must log out and log in again to see these changes.'
=> 'Der Studierende muss sich ausloggen und neu einloggen, um diese nderungen zu sehen.',

   'There are currently no Error Messages for this resource.'
=> 'Momentan liegen keine Fehlermeldungen zu dieser Ressource vor.',

   'There are no Evaluation Comments on this resource.'
=> 'Es liegen keine Auswertungskommentare bezglich dieser Ressource.',

   'There was an error determining the environment values for'
=> 'Es trat ein Fehler auf bei der Bestimmung der Umgebungswerte fr',

   'To create a new'
=> 'Zum Erstellen einer neuen Datei vom Typ',

   'Top Level Map'
=> 'Top-Level-Inhaltszusammenstellung',

   'Turkish - ISO'
=> 'Trkisch - ISO',

   'Type Name Here'
=> 'Hier Name eingeben',

   'Type in value'
=> 'Wert eingeben',

   'Type:'
=> 'Typ:',

   'UNDISPLAYABLE'
=> 'NICHT DARSTELLBAR',

   'Unable to enroll'
=> 'Kursbelegung nicht mglich',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Konnte Datei nicht verffentlichen, denn Sie enthlt doppelte IDs. ID mssen aber eindeutig sein. Die doppelten IDs sind',

   'Unable to retrieve environment data for'
=> 'Konnte die Umgebungsdaten nicht wiederherstellen fr',

   'Unable to set default dates for course'
=> 'Konnte die Defaulttermine des Kurses nicht setzen fr',

   'Unavailable course'
=> 'Nicht verfgbarer Kurs',

   'Undetermined - ISO'
=> 'Unbestimmt - ISO',

   'Unknown Action'
=> 'Unbekannte Aktion',

   'Upload class list'
=> 'Lade Kursteilnehmerliste hoch',

   'Upload file'
=> 'Datei hochladen',

   'Upload file to Construction Space'
=> 'Datei in den Konstruktionsbereich hochladen',

   'VIEW'
=> 'ANSICHT',

   'View the FAQ'
=> 'Zeige das FAQ',

   'Visibly Separate Items on Pages'
=> 'Sichtbar unterschiedliche Einzelteile auf Seiten',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'ACHTUNG: Die Metadaten-Tabelle existiert nicht in der LON-CAPA-Datenbank.',

   'Warning: change of MIME type!'
=> 'Achtung: nderung des MIME-Typs!',

   'Warning: target file exists!'
=> 'Achtung: Zieldatei existiert bereits!',

   'Warning: target file exists, and has been published!'
=> 'Achtung: Zieldatei existiert und wurde bereits verffentlicht!',

   'Width'
=> 'Breite',

   'With Answers'
=> 'Mit Antworten',

   'Without Answers'
=> 'Ohne Antworten',

   'You are working with an unsaved version of your map.'
=> 'Sie arbeiten momentan an einer nicht gespeicherten Version Ihrer Inhaltszusammenstellung.',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'Sie haben die Matrikelnummer gendert, aber nicht den ID-Sicherungsdienst deaktiviert. Die Matrikelnummer wird nicht gendert.',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Ihre Versuch zur nderung der Rolleninformationen fr diesen Studenten wurde abgelehnt. Sie haben offensichtlich nicht gengend Rechte zum ndern der Studenten-Daten.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (was Sie gerade auf dem Bildschirm sahen)',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] Lokale Authentifizierung mit Argument [_2]',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'Eine komma-separierte Liste von Kurs-Sektionen zusammen mit dem derzeitigen Kurs, wobei jeder Eintrag den institutionellen Kurssektionsnamen gefolgt von einem Doppelpunkt und dann der (optinalen) Gruppen-ID zur Verwendung in LON-CAPA, beinhaltet, z.B. fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'Eine komma-separierte Liste institutioneller Sektionsnummern, jeweils getrennt durch einen Doppelpunkt von der in LON-CAPA verwendeten entsprechenden (optionalen) Sektions-/Gruppen-ID, z.B. 001:1,002:2',

   'after selected'
=> 'nach erfolgter Auswahl',

   'and'
=> 'und',

   'anno-[_1]'
=> 'anno-[_1]',

   'anno.gif'
=> 'anno.gif',

   'anot.gif'
=> 'anot.gif',

   'backward[_1]'
=> 'backward[_1]',

   'bchat.gif'
=> 'bchat.gif',

   'between'
=> 'zwischen',

   'bookmark[_2]'
=> 'Lesezeichen[_2]',

   'button'
=> 'Button',

   'by'
=> 'durch',

   'catalog.gif'
=> 'catalog.gif',

   'catalog[_1]'
=> 'Katalog[_1]',

   'ccrs.gif'
=> 'ccrs.gif',

   'changes will not show until next login'
=> 'nderungen werden erst nach nchstem Login aktiv',

   'check all'
=> 'Alle auswhlen',

   'chmod error'
=> 'Fehler beim Aufhren von chmod',

   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'klicken Sie bitte auf',

   'com.gif'
=> 'com.gif',

   'copy Error'
=> 'Kopierfehler',

   'courses.gif'
=> 'courses.gif',

   'cprv.gif'
=> 'cprv.gif',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'existiert z.Z. nicht',

   'custom'
=> 'anpassbar',

   'custom distribution file'
=> 'anpassbare Datei ',

   'discuss[_1]'
=> 'diskutiere[_1]',

   'docs.gif'
=> 'docs.gif',

   'domain'
=> 'Domne',

   'egrd.gif'
=> 'egrd.gif',

   'enrl.gif'
=> 'enrl.gif',

   'eval.gif'
=> 'eval.gif',

   'evaluate[_1]'
=> 'auswerten[_1]',

   'expired or revoked'
=> 'abgelaufen oder widerrufen',

   'extension'
=> 'Endung',

   'external'
=> 'extern',

   'fdbk.gif'
=> 'fdbk.gif',

   'feedback[_1]'
=> 'Feedback[_1]',

   'file<br />extension'
=> 'Datei-<br />Endung',

   'first name'
=> 'Vorname',

   'for visible separation'
=> 'fr sichtbare Trennung',

   'forward[_1]'
=> 'forward[_1]',

   'generation'
=> 'Generation',

   'grds.gif'
=> 'grds.gif',

   'have different numbers and answers'
=> 'unterschiedliche Zahlen und Antworten haben werden', # 2/2: whole text instead of two different parts is recommended. [SB 19.10.2006]

   'in domain'
=> 'in Domne',

   'internal'
=> 'intern',

   'is in this state by royal decree.'
=> 'hat die Erlaubnis aufgrund eines kniglichen Erlasses.',

   'is ready for download'
=> 'steht zum Download bereit',

   'keys.gif'
=> 'keys.gif',

   'last name'
=> 'Nachname',

   'logout.gif'
=> 'logout.gif',

   'make these dates the default for future enrollment'
=> 'Diese Datumswerte als voreingestellte Werte fr zuknftige Kursbelegungen verwenden',

   'middle name'
=> 'zweiter Vorname',

   'name'
=> 'Name',

   'nav.gif'
=> 'nav.gif',

   'no ending date'
=> 'kein Endedatum',

   'number'
=> 'Nummer',

   'obsolete replacement'
=> 'veraltete Ersetzung',

   'only check if you know what you are doing'
=> 'nur auswhlen, wenn Sie wissen, was Sie tun',

   'only search domain'
=> 'suche nur in Domäne',

   'optional'
=> 'optional',

   'or any other value'
=> 'oder jeder andere Wert',

   'parm.gif'
=> 'parm.gif',

   'pref.gif'
=> 'pref.gif',

   'private'
=> 'privat',

   'prt.gif'
=> 'prt.gif',

   'public'
=> 'ffentlich',

   'publisher<br />owner'
=> 'Herausgeber<br />Besitzer',

   'res.gif'
=> 'res.gif',

   'roles.gif'
=> 'roles.gif',

   'sbkm.gif'
=> 'sbkm.gif',

   'section'
=> 'Sektion',

   'set[_1]'
=> 'Set[_1]',

   'spacer.gif'
=> 'spacer.gif',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'standard'
=> 'Standard',

   'standard LaTeX mode'
=> 'Standard LaTeX Modus',

   'standard courses only'
=> 'Nur Standard-Kurse',

   'stat.gif'
=> 'stat.gif',

   'student name'
=> 'Name des Studenten',

   'template'
=> 'Vorlage',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'Zur Kopplung mit institutionellen Daten, z.B. <tt>ss08inf345</tt> fr <i>Sommersemester 2008 Informatik 345</i>',

   'unable to enroll'
=> 'Einschreibung nicht mglich',

   'uncheck all'
=> 'Gesamte Auswahl aufheben',

   'use related words'
=> 'verwende hnliche Wrter',

   'username'
=> 'Benutzername',

   'vbkm.gif'
=> 'vbkm.gif',

   'versus'
=> 'gegen',

   'with server'
=> 'mit Server',

   'yes'
=> 'ja',

   'Swedish Chef'
=> 'Schwedischer Koch',


#SYNC Tue Aug 15 14:23:05 2006
   ' [_1]'
=> ' [_1]',

   '"[_1]" for default hiding'
=> '"[_1]" fr Verbergen gem Voreinstellung',

   '"[_1]" for visible separation'
=> '"[_1]" fr sichtbare Trennung',

   '"[_1]" if allowed, anything else if not'
=> '"[_1]", um zu erlauben. Alles andere, um nicht zu erlauben.',

   '"[_1]" to disable, anything else if not'
=> '"[_1]", um zu deaktivieren. Alles andere, um zu aktivieren.',

   '"[_1]" to suppress, anything else to not suppress'
=> '"[_1]", um zu unterdrcken. Alles andere, um nicht zu unterdrcken.',

   'or set value to "[_1]" to allow all roles'
=> 'Tragen Sie "[_1]" ein, um fr alle Rollen zu erlauben.',


   '# Do not translate this line.  [_1] is a check box'
=> '# Diese Zeile nicht bersetzen .  [_1] ist ein Ankreuzfeld',

   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Diese Zeile nicht bersetzen.  [_1] ist ein Ankreuzfeld, [_2] ist ein Texteingabefeld',

   '# Do not translate this line.  [_1] is a column index.'
=> '# Diese Zeile nicht bersetzen.  [_1] ist ein Spaltenindex.',

   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Diese Zeile nicht bersetzen.  [_1] ist ein Feld, um Domnen auszuwhlen.',

   '# Do not translate this line.  [_1] is a username'
=> '# Diese Zeile nicht bersetzen.  [_1] ist ein Benutzername',

   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Diese Zeile nicht bersetzen.  [_1] ist die Anzahl der bearbeiteten Studierdendatenstze',

   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Diese Zeile nicht bersetzen.  [_1] ist Benutzername, [_2] - [_5] sind Vorname, 2. Vorname, Nachname und Generation.',

   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Diese Zeile nicht bersetzen.  [_1] ist Benutzername, [_2] ist Fehlermeldung',

  '# Do not translate this line.  [_1] is username@domain'
=> '# Diese Zeile nicht bersetzen.  [_1] ist benutzername@domne',

   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Diese Zeile nicht bersetzen.  [_1] ist benutzername@domne [_2] ist die Fehlermeldung.',

   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Diese Zeile nicht bersetzen.  [_1], [_3], und [_4] sind Auswahlfelder',

   '# Do not translate this line.  [_2] is a text entry element'
=> '# Diese Zeile nicht bersetzen.  [_2] ist ein Texteingabefeld',

   '# [_1] is a drop-down selection box'
=> '# [_1] ist ein Drop-Down-Auswahlmen',

   '# [_1] is a number [_2] is the current domain'
=> '# [_1] ist eine Nummer [_2] ist der derzeitige Bereich',

   '# [_1] is an html link to the current file '
=> '# [_1] ist eine html-Verknpfung zur derzeitigen Datei ',

   '# _1 is a selection dialog'
=> '# _1 ist ein Auswahldialog',

   '# _1 is a server name'
=> '# _1 ist ein Servername',

   '# _1 is search string'
=> '# _1 ist ein Suchbegriff',

   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, und _5 sind Verknpfungsanker, _2,_4, und _6 sind '</a>'",

   '#[_1] is the foil name'
=> '#[_1] ist die Bezeichnung der Auswahlmglichkeit',

   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 ist die Bezeichnung der Auswahlmglichkeit, _2 ist der aktuelle Wert der Auswahlmglichkeit',

   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot; ist keine zulssige Anzahl von Versuchen. Die Anzahl muss eine positive, ganze Zahl (ohne Dezimalkurs) sein.',

   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot; ist keine zulssige Gewichtung. Die Gewichtung muss eine positive Zahl sein.',

   '1 minute'
=> '1 Minute',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML zugelassen</b>: Diskussionsteilnehmer knnen in ihren Beitrgen eingeschrnkten HTML-Befehlssatz verwenden.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML verboten</b>: HTML wird in Diskussionen nicht zugelassen.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Dozent</b> - Dozenten werden nicht an den Diskussionen teilnehmen knnen.',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Dozent</b> - Dozenten werden den Chatroom weder betreten noch die Inhalte einsehen knnen',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Studierende</b> - Studenten werden nicht an Diskussionen teilnehmen knnen',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Studierende</b> - Studenten werden den Chatroom weder betreten noch die Inhalte einsehen knnen',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Tutor</b> - Tutoren werden nicht an den Diskussionen teilnehmen knnen',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Tutor</b> - Tutoren werden den Chatroom weder betreten noch die Inhalte einsehen knnen',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>Ihre derzeitige LON-CAPA-Domne ist &quot;<b>[_1]</b>&quot;.</p>',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Fortgeschritten: Sie knnen Feedback von unterschiedlichen Sektionen aus an unterschiedliche Personen senden. Hierzu ist jeder Eintrag mit einem Komma zu trennen. Um Feedback an eine bestimmte Adresse fr unterschiedliche Sektionen zu senden, hngen Sie die die Sektionsbezeichnung(en) (getrennt durch Semicola) in einer Klammerliste nach benutzer:domne an. Beispiel: john102:msu(001;002;003), bob293:msu(004;005;006), irgendwer:irgendwo(007;008;009) wird Feedback an &quot; john102&quot; fr Abschnitte 1, 2 und 3, an &quot; bob293&quot; fr 4, 5 und 6 und zum &quot; irgendwer:irgendwo&quot; fr 7, 8 und 9 gesandt. Beachten Sie, dass es nicht erforderlich ist, dass die Adressen in einer bestimmten Domne liegen.',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> 'Alle Einstellungen, die mit diesem Hilfsprogramm nderbar sind, knnen auch ber die Kurs- und Ressourcen-Parameter im Unterpunkt "Kursumgebung" gendert werden. Wenn Sie noch keine Erfahrung mit der Koordination von LON-CAPA-Kursen haben oder wenn Sie dieses Hilfsprogramm bevorzugen, klicken Sie bitte jetzt auf <tt>Weiter -&gt;</tt>.',

   'Allow limited HTML in discussion posts'
=> 'Beschrnkte Verwendung von HTML in den Diskussionsbeitrgen zulassen',

   'Allow problems to be split over pages'
=> 'Erlauben, dass Aufgaben sich auf mehrere Seiten aufteilen',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Dateiendungen fr hochgeladene Dateien erlauben (uploadedfiletypes)',

   'Answer Date (answerdate)'
=> 'Antwort-Verfgbarkeits-Datum (answerdate)',

   'Chat Participation'
=> 'Teilnahme an Chat',

   'Click here to return to the chart.'
=> 'Klicken Sie hier, um zum Chart zurckzukehren.',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Namen-Zugriffssteuerung (acc)',

   'Completed'
=> 'Ausgefhrt',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> 'Besttigen Sie, dass diese Informationen richtig sind. Klicken Sie dann auf &quot;Beende Hilfsprogramm&quot;, um das Einstellen der Parameter abzuschlieen.',

   'Course ID or number'
=> 'Kurs-ID oder -Nummer',

   'Course Initialization Helper'
=> 'Hilfsprogramm zur Kurs-Einrichtung',

   'Course default for all problems'
=> 'Default-Einstellungen des Kurses fr alle Aufgaben',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> 'Kursmitglieder knnen Feedback zum Kurs geben. Sie knnen hier auswhlen, wer das Feedback empfangen soll, wie z.B. ein anderer Dozent oder ein Tutor. Bitte geben Sie die entsprechende LON-CAPA-Adresse unten in der Form benutzer:domne ein, wobei &quot;benutzer&quot; und &quot;domne&quot; LON-CAPA-Benutzername bzw. LON-CAPA-Domne sind. Verwenden Sie keine E-Mail-Adresse!',

   'Courses'
=> 'Kurse',

   'Default beginning date when enrolling students'
=> 'Default-Startdatum fr die Kursbelegung der Studenten',

   'Default ending date when enrolling students'
=> 'Default-Endedatum fr die Kursbelegung der Studenten',


   'Default set of options to pass to tth/m when converting tex'
=> 'Voreingestellte Optionen fr tth/m fr die Konvertierung von TeX',

   'Disable display of problem receipts'
=> 'Anzeige von Aufgaben-Empfangsquittungen deaktivieren',

   'Disallow Resource Discussion for Roles'
=> 'Diskussion ber Ressource fr folgende Rollen nicht gestatten:',

   'Disallow Resource Discussion for Users'
=> 'Diskussion ber Ressource fr folgende Benutzer nicht gestatten:',

   'Disallow live chatroom use for Roles'
=> 'Nutzungsmglichkeit des Live-Chatrooms fr folgende Rollen nicht gestatten:',

   'Disallow live chatroom use for Users'
=> 'Besuchen des Live-Chatrooms fr folgende Benutzer nicht gestatten:',

   'Discussion Participation'
=> 'Diskussionsteilnahme',

   'Do not show plain URL (encrypturl)'
=> 'Blanke URL nicht anzeigen  (encrypturl)',

   'Due Date (contentclose)'
=> 'Flligkeitsdatum (contentclose)',

   'Due Date (duedate)'
=> 'Flligkeitsdatum (duedate)',

   'Every problem in a particular folder (overrides course default)'
=> 'Jede Aufgabe in einen bestimmten Verzeichnis ablegen (berschreibt Default-Einstellungen des Kurses)',

   'Exit'
=> 'Beenden',

   'Feedback Addresses for Course Content'
=> 'Feedback-Adressen fr Kursinhalt',

   'Finish Helper'
=> 'Beende Hilfsprogramm',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML kann innerhalb von Kursdiskussionen erlaubt oder verboten werden.',

   'HTML in Discussions'
=> 'HTML in Diskussionen',

   'Hand Graded (handgrade)'
=> 'von Hand bewertet (handgrade)',

   'Hide Empty Rows in Spreadsheets'
=> 'Verstecke leere Zeilen in den Verteilungsbgen ',

   'How many tries should be set for all problems in the course?'
=> 'Wieviele Versuche sollten fr alle Aufgaben im Kurs gesetzt werden?',

   'How many tries should be set for the selected folder?'
=> 'Wieviele Versuche sollten fr alle gewhlten Verzeichnisse gesetzt werden?',

   'How many tries should be set for the selected problem?'
=> 'Wieviele Versuche sollten fr die ausgewhlte Aufgabe gesetzt werden?',

   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA bietet eine Live-Chat-Funktion an. Dieser Kurs wird seinen eigenen Chatroom erhalten. Sie knnen Kursteilnehmern, Tutoren oder Dozenten das Recht verweigern, den Chatroom zu nutzen.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA bietet fr alle Ressourcen des Kurses eine Diskussionsmglichkeit an. In der Grundeinstellung drfen allen Benutzer an diesen Diskussionen teilnehmen. Wenn Sie nicht wollen, dass bestimmte Arten von Benutzern an den Diskussionen teilnehmen sollen drfen, whlen Sie diese unten aus. Beachten Sie, dass Ihr Kurs nicht jede Art von Benutzerrollen haben knnte. Sie knnen problemlos Rollen ignorieren, die Sie nicht verwenden wollen (Beispiel: Prfungs-Proktoren blicherweise nur fr sehr groe Kurse hilfreich.) Benutzergruppen, die nicht an der Diskussion teilnehmen drfen, knnen dennoch jede Diskussion der anderen Benutzer mitlesen.',

   'List of hidden parts (hiddenparts)'
=> 'Liste der versteckten Aufgabenteile (hiddenparts)',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximale Anzahl an Mitarbeitern (maxcollaborators)',

   'Maximum Number of Tries (maxtries)'
=> 'Maximale Anzahl an Versuchen (maxtries)',

   'No section assigned'
=> 'Keiner Sektion zugewiesen',

   'Number of Tries before hints appear (hinttries)'
=> 'Anzahl der Versuche, bevor Hinweise erscheinen (hinttries)',

   'Number of assignments printed at the same time:'
=> 'Anzahl von bungen, die gleichzeitig gedruckt werden sollen:',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Anzahl der Ankreuzfelder im Prfungmodus (numbubbles)',

   'Numerical Tolerance (tol)'
=> 'Numerische Toleranz (tol)',

   'Opening Date (contentopen)'
=> 'Bearbeitungsbeginn-Datum (contentopen)',

   'Opening Date (opendate)'
=> 'Bearbeitungsbeginn-Datum (opendate)',

   'Part Description (display)'
=> 'Aufgabenteil-Beschreibung (display)',

   'Please adjust significant figures.'
=> 'Bitte passen Sie die signifikanten Stellen an.',
 
   'Please select the section you wish to set the answer open date for:'
=> 'Bitte whlen Sie die Sektion, fr die Sie das Antwort-Verfgbarkeits-Datum festlegen wollen:',

   'Please select the section you wish to set the due date for:'
=> 'Bitte whlen Sie die Sektion, fr die Sie das Flligkeitsdatum festlegen wollen:',

   'Please select the section you wish to set the number of tries for:'
=> 'Bitte whlen Sie die Sektion, fr die Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the section you wish to set the opening date for:'
=> 'Bitte whlen Sie die Sektion, fr die Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the section you wish to set the problem weight for:'
=> 'Bitte whlen Sie die Sektion, fr die Sie die Aufgabengewichtung festlegen wollen:',

   'Please select the student you wish to set the answer open date for:'
=> 'Bitte whlen Sie den Studenten, fr den Sie das Antwort-Verfgbarkeits-Datum festlegen wollen:',

   'Please select the student you wish to set the due date for:'
=> 'Bitte whlen Sie den Studenten, fr den Sie das Flligkeitsdatum festlegen wollen:',

   'Please select the student you wish to set the number of tries for:'
=> 'Bitte whlen Sie den Studenten, fr den Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the student you wish to set the opening date for:'
=> 'Bitte whlen Sie den Studenten, fr den Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the student you wish to set the problem weight for:'
=> 'Bitte whlen Sie den Studenten, fr den Sie die Aufgabengewichtung festlegen wollen:',

   'Privileged users that should not be hidden on staff listings'
=> 'Privilegierte Nutzer, die auf Personallisten nicht verborgen werden sollen',

   'Question Type (type)'
=> 'Fragetyp (type)',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Zufallszahlengenerator-Startwert fr zufllige Wahl der Ressourcen-Anzahl (optional. Setzen Sie dies nur, wenn Sie die Funktionalitt verstehen) (randompickseed)',

   'Randomly pick number of resources (randompick)'
=> 'Ressourcenanzahl zufllig whlen (randompick)',

   'Reading results from [_1]'
=> 'Lese Ergebnisse von [_1]',

   'Receipt algorithm used'
=> 'Verwendetes Verfahren fr Empfangsquittungen',

   'Receiving results from [_1]'
=> 'Erhalte Ergebnisse von [_1]',

   'Resource Hidden from Students (hiddenresource)'
=> 'Ressource vor Studierenden verborgen (hiddenresource)',

   'Resource alias name for conditions (mapalias)'
=> 'Ressourcen-Aliasname fr Bedingungen (mapalias)',

   'Resources'
=> 'Ressourcen',

   'Search Complete [_1]'
=> ' Suche vollstndige(n) [_1]',

   'Search: [_1]'
=> 'Suche: [_1]',

   'Select All Files'
=> 'Alle Dateien auswhlen',

   'Select All Published'
=> 'Alle verffentlichten Ressourcen auswhlen',

   'Select Folder'
=> 'Verzeichnis auswhlen',

   'Select Only Current Students'
=> 'Nur aktuelle Studenten auswhlen',

   'Select Problem'
=> 'Aufgabe auswhlen',

   'Select Student'
=> 'Studenten auswhlen',

   'Select for Section/Group'
=> 'Auswahl fr Sektion/Gruppe',

   'Select the folder you wish to set the parameter for:'
=> 'Whlen Sie das Verzeichnis, fr den sie den Parameter einstellen wollen:',

   'Select the problem you wish to set the parameter for:'
=> 'Whlen Sie die Aufgabe, fr die Sie den Parameter einstellen wollen:',

   'Set Problem Tries'
=> 'Aufgaben-Versuche einstellen',

   'Set Problem Weight'
=> 'Aufgaben-Gewichtung einstellen',

   'Set answer open date for all problems in the course for ...'
=> 'Setze Antwort-Verfgbarkeits-Datum aller Aufgaben des Kurses fr...',

   'Set answer open date for the selected folder for ...'
=> 'Setze Antwort-Verfgbarkeits-Datum des ausgewhlten Verzeichnisses fr...',

   'Set answer open date for the selected problem for...'
=> 'Setze Antwort-Verfgbarkeits-Datum der ausgewhlten Aufgabe fr...',

   'Set due date for all problems in the course for ...'
=> 'Setze Flligkeitsdatum aller Aufgaben des Kurses fr...',

   'Set due date for the selected folder for ...'
=> 'Setze Flligkeitsdatum des ausgewhlten Verzeichnisses fr...',

   'Set due date for the selected problem for ...'
=> 'Setze Flligkeitsdatum der ausgewhlten Aufgabe fr ...',

   'Set number of tries for all problems in the course for ...'
=> 'Setze Anzahl der Versuche aller Aufgaben des Kurses fr...',

   'Set number of tries for the selected folder for ...'
=> 'Setze Anzahl der Versuche des ausgewhlten Verzeichnisses fr...',

   'Set number of tries for the selected problem for ...'
=> 'Setze Anzahl der Versuche der ausgewhlten Aufgabe fr...',

   'Set opening date for all problems in the course for ...'
=> 'Setze Bearbeitungsbeginn-Datum aller Aufgaben des Kurses fr...',

   'Set opening date for the selected folder for ...'
=> 'Setzte Bearbeitsbeginn-Datum des ausgewhlten Verzeichnisses fr...',

   'Set opening date for the selected problem for ...'
=> 'Setze Bearbeitungsbeginn-Datum der ausgewhlten Aufgabe fr...',

   'Set problem weight for all problems in the course for ...'
=> 'Setze Aufgabengewichtung aller Aufgaben des Kurses fr...',

   'Set problem weight for the selected folder for ...'
=> 'Setze Aufgabengewichtung des ausgewhlten Verzeichnisses...',

   'Set problem weight for the selected problem for ...'
=> 'Setze Aufgabengewichtung der ausgewhlten Aufgabe fr...',

   'Set value to "[_1]" to allow'
=> 'Setze Wert auf "[_1]", um zu erlauben',

   'Setting the [_1]'
=> 'Einstellung auf [_1] setzen',   

   'Setting the [_1] to [_2]'
=> 'Einstellung ndern von [_1] auf [_2]',

   'Show Problem Status (problemstatus)'
=> 'Aufgabenstatus anzeigen (problemstatus)',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Zeige Einheiten - Eintrag sperren (turnoffunit)',

   'Significant Digits (sig)'
=> 'Signifikante Stellen (sig)',

   'Student Name'
=> 'Name des Studenten',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> 'Die &quot; Kursbezeichnung&quot; ist der Name des Kurses, der von den Kursteilnehmern gesehen wird. Sie knnen diese Bezeichnung nun ndern und mit &quot;Weiter -&gt;&quot; fortfahren',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'Die Antwort auf diese Frage kann niemals richtig werden. Die folgenden Auswahlmglichkeiten im &lt;optionresponse&gt;-Tag beinhalten unzulssige richtige Optionen',

   'There are no currently enrolled students in the course.'
=> 'Es gibt keine derzeit eingeschriebenen Kursteilnehmer im Kurs.',

   'There are no currently enrolled students in the selected sections.'
=> 'Es gibt keine derzeit eingeschriebenen Kursteilnehmer in der ausgewhlen Sektion.',

   'There are no previously enrolled students in the course.'
=> 'Es gibt keine schon zuvor eingeschriebenen Kursteilnehmer im Kurs.',

   'There are no previously enrolled students in the selected sections.'
=> 'Es gibt keine in der Vergangenheit eingeschriebenen Kursteilnehmer in den ausgewhlten Sektionen.',

   'There are no students in the course.'
=> 'Es gibt keine Kursteilnehmer im Kurs.',

   'There are no students in the selected sections.'
=> 'Es gibt keine Kursteilnehmer in den ausgewhlten Sektionen.',

   'This controls how receipt numbers are generated.'
=> 'Steuert die Erzeugung der Quittungsnummern.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'Dieses Hilfsprogramm untersttzt Sie dabeiwird Ihren LON-CAPA-Kurs einzurichten und zu whlen, welche Einstellungen aktiv sein werden.',

   'Unselect All Files'
=> 'Auswahl fr alle Dateien aufheben',

   'Unselect All Published'
=> 'Auswahl fr alle verffentlichten Dokumente aufheben',

   'Unselect All Resources'
=> 'Auswahl fr alle Ressourcen aufheben',

   'Unselect for Section/Group'
=> 'Auswahl fr Sektion/Gruppe aufheben',

   'Weight (weight)'
=> 'Gewichtung',

   'Welcome to Your New LON-CAPA Course'
=> 'Willkommen in Ihrem neuen LON-CAPA-Kurs',

   'What parameter do you want to set for the selected folder?'
=> 'Welchen Parameter mchten Sie fr das ausgewhlte Verzeichnis setzen?',

   'What parameter do you want to set for the selected problem?'
=> 'Welchen Parameter mchten Sie fr die ausgewhlte Aufgabe setzen?',

   'What should the answer open date be set to?'
=> 'Auf welchen Wert soll das Antwort-Verfgbarkeits-Datum gesetzt werden?',

   'What should the due date be set to?'
=> 'Auf welchen Wert soll das Flligkeitsdatum gesetzt werden?',

   'What weight should be set for all problems in the course?'
=> 'Auf welchen Wert soll die Gewichtung fr alle Aufgaben im Kurs gesetzt werden?',

   'What weight should be set for the selected folder?'
=> 'Auf welchen Wert soll die Gewichtung fr das ausgewhlte Verzeichnis gesetzt werden?',

   'What weight should be set for the selected problem?'
=> 'Auf welchen Wert soll die Gewichtung der ausgewhlten Aufgabe gesetzt werden?',

   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> 'Ihr Kurs ist nun eingerichtet. Bitte klicken Sie auf den Button Beende Kurs-Initialisierung, um den Kurs mit Ihren neuen Einstellungen neu zu initialisieren. Beachten Sie, dass all diese Einstellungen auf der PARMS-Seite durch Klick auf den Kursumgebungs-Button gendert werden knnen.',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Authentifizierung ber Dateisystem (mit Anfangspasswort [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] LON-CAPA-interne Authentifizierung (mit Anfangspasswort [_2])',

   '[_1] Records per Page'
=> '[_1] Suchergebnisse je Seite',

   '[_1] minutes'
=> '[_1] Minuten',

   '[_1] minutes, [_2] seconds'
=> '[_1] Minuten, [_2] Sekunden',

   '[_1] with value [_2]'
=> '[_1] mit dem Wert [_2]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]zurck[_2] &nbsp; [_3]neu laden[_4] &nbsp; [_5]weiter[_6]',

   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]zurck[_2] &nbsp; [_3]neu laden[_4] &nbsp; weiter',

   '[_2] seconds'
=> '[_2] seconds',

   'all resources in the course'
=> 'alle Ressourcen des Kurses',

   'all students in course'
=> 'alle Teilnehmer des Kurses',

   'anonymous students'
=> 'Anonyme Studenten',

   'answer date'
=> 'Antwortdatum',

   'contacting [_1]'
=> 'kontaktiere [_1]',

   'due date'
=> 'Flligkeitsdatum',

   'for'
=> 'fr',

   'for <b>all resources in the course</b>'
=> 'fr <b>alle Ressourcen des Kurses</b>',

   'for <b>all students in course</b>'
=> 'fr <b>alle Teilnehmer des Kurses</b>',

   'for [_1]'
=> 'fr [_1]',

   'for section [_1]'
=> 'fr den Sektion [_1]',

   'for the map named [_1]'
=> 'fr die Inhaltszusammenstellung mit der Bezeichnung [_1]',

   'for the resource named [_1]'
=> 'fr die Ressource mit der Bezeichnung [_1]',

   'from'
=> 'von',

   'from current subdirectory'
=> 'von derzeitigem Unterverzeichnis',

   'helper'
=> 'Hilfsprogramm',

   'in'
=> 'in ',

   'instructor'
=> 'Dozent',

   'number of tries'
=> 'Anzahl der Versuche',

   'opening date'
=> 'Startdatum',

   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'zurck &nbsp; [_3]neu laden[_4] &nbsp; [_5]weiter[_6]',

   'problem weight'
=> 'Gewichtung der Aufgabe',

   'role,role,...'
=> 'Rolle, Rolle,...',

   'selected students'
=> 'ausgewhlte Studierende',

   'student'
=> 'Student',

   'textual_remote_display'
=> 'textual_remote_display',

   'to'
=> 'auf',

   'to [_1] ([_2])'
=> 'auf [_1] ([_2])',

   'waiting on [_1]'
=> 'warte auf [_1]',

   'what you just saw on the screen'
=> 'was Sie gerade auf dem Bildschirm gesehen haben',

#SYNC Tue Aug 15 14:43:20 2006
   'Enter my portfolio space'
=> 'Portfolio-Bereich',

   'No syllabus information provided.'
=> 'Kein Kursberblick vorhanden.',

   'Post Discussion'
=> 'Diskussionsbeitrag verfassen',

   'Sorry ...'
=> 'Sorry ...', # n.t.

   'This resource might be part of another course.'
=> 'Diese Ressource ist wahrscheinlich Bestandteil eines anderen Kurses.',

#SYNC Tue Aug 15 16:12:09 2006
   'Agree'
=> 'Trifft eher zu',

   'Any comments?'
=> 'Kommentare:',

   'Copy this column'
=> 'Kopiere diese Spalte',

   'Disagree'
=> 'Trifft eher nicht zu',

   'General Intro'
=> 'Allgemeine Einfhrung',

   'Greek Symbols'
=> 'Griechische Buchstaben',

   'HTML character entities'
=> 'HTML-Zeichencode',

   'Highest Grade Level'
=> 'Hchstes Kursniveau',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'Wenn Sie sich diesen Text online ansehen, kopieren Sie den Eintrag in der rechten Spalte und fgen sie ihn in den Texteingabebereich ein, um das entsprechende Symbol auf der linken Seite zu erhalten.',

   'LON-CAPA Help'
=> 'LON-CAPA-Hilfe',

   'Landscape'
=> 'Querformat',

   'Launch navigation window'
=> 'Navigationsfenster starten',

   'Lowest Grade Level'
=> 'Niedrigstes Kursniveau',

   'Mark all posts read'
=> 'Alle Diskussionsbeitrge als gelesen kennzeichnen',

   'My question/comment/feedback:'
=> 'Meine Frage/Anmerkung/Feedback:',

   'Not set -'
=> 'Nicht gesetzt -',

   'Other Symbols'
=> 'Weitere Symbole',

   'Please check at least one of the following feedback types:'
=> 'Bitte whlen Sie eine der angebotenen Optionen:',

   'Please rank the following criteria:'
=> 'Bitte bewerten Sie anhand der folgenden Kriterien:',

   'Portrait'
=> 'Hochformat',

   'Question about resource content'
=> 'Frage zum Inhalt der Ressource',

   'Question/Comment/Feedback about course policy'
=> 'Frage/Anmerkung/Rckmeldung zu Regeln des Kurses ',

   'Select a Course to Enter'
=> 'Whlen Sie den gewnschten Kurs aus',

   'Sending Messages'
=> 'Sende Nachricht',

   'Show Me My First Homework Problem'
=> 'Zeige mir meine erste Hausarbeits-Aufgabe',

   'Standards'
=> 'Standards',

   'Strongly Agree'
=> 'Trifft vllig zu',

   'Strongly Disagree'
=> 'Trifft berhaupt nicht zu',

   'Symbol'
=> 'Symbol',

   'The material appears to be correct'
=> 'Das Material scheint korrekt zu sein',

   'The material is helpful'
=> 'Das Material ist hilfreich',

   'The material is presented in a clear way'
=> 'Das Material wird in einer verstndlichen Art dargestellt',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'Die Ressource ist technisch einwandfrei (ldt ausreichend schnell, erzeugt keine Fehlermeldungen, verlinkte Seiten sind erreichbar, etc.) ',


#SYNC Fri Aug 18 20:46:54 2006
   'HTML character enties'
=> 'HTML-Zeichen-Entitys',



#SYNC Sat Aug 19 09:31:18 2006
   '"Waiting for Remote Control window to load: "+[_1]'
=> '"Warte auf das Laden der Fernbedienung: "+[_1]',

   '<a href="[_1]">Continue</a> on in Inline Menu mode'
=> '<a href="[_1]">Weiter</a> im Kopfzeilenmen-Modus',

   'All posts'
=> 'Alle Diskussionsbeitrge',

   'Arabic - UTF'
=> 'Arabisch - UTF',

   'Change Color Scheme'
=> 'Farben',

   'Change Colors'
=> 'Farben',

   'Change Discussion Display Preferences'
=> 'Darstellung der Diskussionsbeitrge',

   'Change How Math Equations Are Displayed'
=> 'Darstellung mathematischer Symbole',

   'Change Language'
=> 'Sprache',

   'Change Language Preferences'
=> 'Sprache',

   'Change Message Forwarding and Notification Email Addresses'
=> 'Nachrichtenweiterleitung und Benachrichtigung',

   'Change Password'
=> 'Passwort',

   'Change Preferences'
# => 'Prferenzen ndern',
=> 'Benutzereinstellungen',

   'Change Roles Page Preferences'
=> 'Benutzerrollen-Schnellzugriffsliste',

   'Change Screen Name'
=> 'Nicknamen',

   'Change Screenname'
=> 'Nicknamen ndern',

   'Change WYSIWYG Editor Preferences'
=> 'WYSIWYG-Editor',

   'Contact Helpdesk'
=> 'Helpdesk kontaktieren',

   'Current discussion settings'
=> 'Einstellung fr diesen Diskussionsbeitrag',

   'Duedate'
=> 'Flligkeitsdatum',

   'Each post can be toggled read/unread'
=> 'Jeder Diskussionsbeitrag kann zwischen als gelesen und als ungelesen umgeschaltet werden',

   "Edit the 'About Me' Personal Information Screen"
=> "Persnliche-Informationen-Seite ('ber mich')",

   'Enable WYSIWYG Editor'
=> 'WYSIWYG-Editor verwenden',

   'End of Sequence'
=> 'Ende der Sequenz',

   'Entering Course'
=> 'Betrete Kurs',

   'French - ISO'
=> 'Franzsisch - ISO',

   'Get help'
=> 'Hilfe abrufen',

   'Go to main menu'
=> 'Zum Hauptmen wechseln',

   'Has New Discussion'
=> 'hat neuen Diskussionsbeitrag',

   'Hebrew - ISO'
=> 'Hebrisch - ISO',

   'Launching of the Remote Control menu will fail if pop-up window filters are active. To use the Remote Control, disable the filter for this site.'
=> 'Das Starten der Fernbedienung wird scheitern, wenn ein Filter gegen Pop-Up-Fenster aktiviert ist. Um die Fernbedienung zu verwenden, deaktivieren Sie diesen Filter fr diese Webseite.',

   'Navigate Course Content'
=> 'Kurs-Inhaltsverzeichnis',

   'New posts only'
=> 'Nur neue Diskussionsbeitrge',

   'No Resource'
=> 'Keine Ressource',

   'No syllabus available'
=> 'Kein Kursberblick verfgbar',

   'Not currently assigned.'
=> 'Derzeit nicht als Aufgabe gestellt.',

   'Not new'
=> 'Nicht neu',

   'Off'
=> 'Aus',

   'On'
=> 'An',

   'Once displayed'
=> 'Sobald angezeigt',

   'Once marked not NEW'
=> 'Sobald nicht als NEU markiert',

   'Persian - UTF'
=> 'Persisch - UTF',

   'Please click on the the resource you intend to access'
=> 'Bitte klicken Sie auf die Ressource, auf die Sie zugreifen wollen',

   'Posts cease to be marked "NEW"'
=> 'Posts cease to be marked "NEW"',

   'Posts to be displayed'
=> 'Diskussionsbeitrge, die angezeigt werden sollen',

   'Role selected. Please stand by.'
=> 'Rolle ausgewhlt. Bitte warten.',

   'Send'
=> 'Sende',

   'Set User Preferences'
=> 'Benutzereinstellungen',

   'Show Preview and Check Spelling'
=> 'Zeige Vorschau und prfe Rechtschreibung',

   'Sort by:'
=> 'Sortieren nach:',

   'Spanish (Castellan) - ISO'
=> 'Spanisch (Kastellanisch) - ISO',

   'Swedish Chef - ISO'
=> 'Dnischer Koch - ISO',

   'The external menu (Remote Control) has been disabled, and you will be working with the smaller inline menu. You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser. To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> 'Die Fernbedienung wurde deaktiviert und durch das Kopfzeilenmenu ersetzt. Sie haben entweder das Fernbedienungsfenster geschlossen oder es wurde durch einen Filter fr Pop-Up-Fenster von Ihrem Webbrowser geblockt. Um die Fernbedienung in solch einem Fall dennoch zu verwenden, deaktivieren Sie den Filter fr diese Webseite und aktivieren Sie die Fernbedienung aus dem Kopfzeilenmen erneut.', # n.t.

   'There are several possibilities of where to go next'
=> 'Es gibt mehrere Mglichkeite, wohin Sie als nchstes gehen knnen',

   'To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> 'Um die Fernbedienung zu verwenden, deaktivieren Sie den Filter gegen Pop-Up-Fenster fr diese Webseite und starten die Fernbedienung aus dem Kopfzeilenmen erneut.',

   'Toggle read/unread'
=> 'Umschalten zwischen gelesen/ungelesen',

   'Unread only'
=> 'Nur ungelesene',

   'View this users personal page'
=> 'Persnliche Seite dieses Nutzers betrachten',

   'You have reached the end of the sequence of materials.'
=> 'Sie haben das Ende der Sequenz von Lehrmaterialien erreicht.',

   'You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser.'
=> 'Sie haben entweder das Fernbedienungsfenster geschlossen oder es wurde vom Filter gegen Pop-Up-Fenster Ihres Webbrowsers blockiert.',

   'attachments'
=> 'Anhnge',

   'folio[_1]'
=> 'folio[_1]',

   'info[_1]'
=> 'info[_1]',

   'port-[_1]'
=> 'port-[_1]',

   'prepare[_1]'
=> 'prepare[_1]',

   'printout[_1]'
=> 'printout[_1]',

   'tations[_1]'
=> 'tations[_1]',

   'this[_1]'
=> 'this[_1]',


#SYNC Sat Aug 19 11:48:11 2006
   'About User'
=> 'ber-Mich-Seite',

   'All documents out of a published map into this folder'
=> 'Alle Dokumente aus einer verffentlichten Inhaltszusammenstellung in dieses Verzeichnis',

   'Change Math Pref'
=> 'Darstellung mathematischer Symbole',

   'Change Math Preferences'
=> 'Darstellung mathematischer Symbole',

   'Comment'
=> 'Kommentar',

   'Communication/Messages'
=> 'Kommunikation und Nachrichten',

   'Configure blocking of student communication during exams'
=> 'Blockieren von studentischer Kommunikation whrend Prfungen konfigurieren',

   'Convert to Images'
=> 'In Grafik konvertieren',

   'Course and Catalog Search'
=> 'Kurs- und Katalog-Suche',

   'Create Subdirectory'
=> 'Erzeuge Unterverzeichnis',

   'Create subdirectory in current directory:'
=> 'Erzeuge neues Unterverzeichnis im aktuellen Verzeichnis:',

   'Critical'
=> 'Kritisch',

   'Currently no documents.'
=> 'Zurzeit keine Dokumente.',

   'Enter terms or phrases, then press "Search" below'
=> 'Geben Sie Suchbegriffe oder -Stze ein und klicken Sie dann unten auf "Suchen"',

   'INBOX'
=> 'POSTEINGANG',

   'If HTML file, upload embedded images/multimedia files'
=> 'Bei HTML-Dateien: Eingebettete Bilder und Multimedia-Dateien mit hochladen', # 'Wenn HTML-Datei, eingebettete Bilder-/Multimedia-Dateien hochladen',

   'Import IMS package'
=> 'Importiere IMS-Paket',

   'Import a document'
=> 'LON-CAPA-interne Dokumente',

   'Make New Folder'
=> 'Erstelle neues Verzeichnis',

   'New Composite Page'
=> 'Neue zusammengesetzte Seite',

   'New Messages Only'
=> 'Nur neue Nachrichten',

   'Portfolio Manager'
=> 'Portfolio-Manager',

   'Preferred method to display Math'
=> 'Bevorzugte Methode, um mathematische Symbole darzustellen',

   'Published documents'
=> 'Verffentlichte Dokumente',

   'Recover Deleted Resources'
=> 'Entfernte Ressourcen wiederherstellen',

   'Send a Message'
=> 'Nachricht versenden',

   'Sent Messages'
=> 'Gesendet',

   'Show'
=> 'Zeige',

   'TRASH'
=> 'Papierkorb',

   'TeX to HTML'
=> 'TeX nach HTML',

   'Upload'
=> 'Hochladen',

   'Upload file to current directory:'
=> 'Datei in aktuelles Verzeichnis laden:',

   'View Folder'
=> 'Betrachte Verzeichnis',

   'fulltext search (time consuming)'
=> 'Volltextsuche (zeitaufwndig)',

   'jsMath'
=> 'jsMath',

   'search discussion postings (resources and bulletin boards)'
=> 'suche in Diskussionsbeitrgen (Ressourcen und Bulletin-Boards)',


#SYNC Sat Aug 19 11:49:40 2006
   'Author and Co-Author roles are not available on servers other than their respective home servers.'
=> 'Autoren- und Co-Autor-Rollen sind nur auf dem jeweiligen Heimatserver verfgbar.',

   'Roles'
=> 'Rollen',


#SYNC Sat Aug 19 12:35:56 2006
   '"Calculate answers'
=> '"Berechne Antworten',

   'Select style file'
=> 'Whle Stil-Dateie',

   '(mark them then click "next" button)'
=> '(markieren und dann auf "Weiter" klicken)',

   '100 Level'
=> '1. Studienjahr',

   '200 Level'
=> '2. Studienjahr',

   '300 Level'
=> '3. Studienjahr',

   '400 Level'
=> '4. Studienjahr',

   'Action'
=> 'Aktion',

   'Actions for current directory'
=> 'Aktionen fr dieses Verzeichnis',

   'Change Discussion Preferences'
=> 'ndere Prferenzen fr Diskussionen',

   'Change Message Forwarding'
=> 'Nachrichtenweiterleitung und Benachrichtigung',

   'Change WYSIWYG Preferences'
=> 'WYSIWYG-Editor',

   'Change to '
=> 'ndere zu ',

   'Clean Up'
=> 'Aufrumen',

   'Closed - XML source is closed to everyone'
=> 'Gesperrt - XML-Quellcode ist fr alle gesperrt',

   'Copy'
=> 'Kopieren',

   'Create a new directory or LON-CAPA document'
=> 'Neue Ressource oder neues Verzeichnis erstellen',

   'Current setting '
=> 'Derzeitige Eintellung ',

   'Delete Directory'
=> 'Verzeichnis lschen',

   'Delete directory'
=> 'Verzeichnis lschen',

   'Delete this resource'
=> 'Ressource lschen', # long version: 'Lsche diese Ressource',

   'Disable WYSIWYG editor'
=> 'WYSIWYG-Editor nicht verwenden',

   'Display Preference'
=> 'Prferenzen bzgl. Darstellung',

   'Edit catalog information'
=> 'Editiere Kataloginformation',

   'Enable WYSIWYG editor'
=> 'WYSIWYG-Editor verwenden',

   'Grade 1'
=> '1. Klasse',

   'Grade 10'
=> '10. Klasse',

   'Grade 11'
=> '11. Klasse',

   'Grade 12'
=> '12. Klasse',

   'Grade 13'
=> '13. Klasse',

   'Grade 2'
=> '2. Klasse',

   'Grade 3'
=> '3. Klasse',

   'Grade 4'
=> '4. Klasse',

   'Grade 5'
=> '5. Klasse',

   'Grade 6'
=> '6. Klasse',

   'Grade 7'
=> '7. Klasse',

   'Grade 8'
=> '8. Klasse',

   'Grade 9'
=> '9. Klasse',

   'Graduate Level'
=> 'Graduierten-Niveau',

   'List current directory'
=> 'Verzeichnis', # long version: 'Aktuelles Verzeichnis anzeigen',

   'Mark obsolete'
=> 'Markiere als berholt',

   'Move'
=> 'Verschiebe',

   'New library file'
=> 'Neue Bibliographie-Datei',

   'New posts cease to be identified as "New"?'
=> 'Sollen neue Diskussionsbeitrge nicht mehr als "Neu" identifiziert werden?',

   'No file'
=> 'Datei nicht vorhanden',

   'No personal information provided'
=> 'Keine Informationen zur Person zur Verfgung gestellt',

   'Not specified'
=> 'Nicht spezifiziert',

   'Once marked as read'
=> 'Sobald als gelesen markiert',

   'Open - XML source is open to people who want to use it'
=> 'Lesbar - XML-Quellcode ist fr interessierte Autoren lesbar',

   'Points Display'
=> 'Bewertungs-Informationen',

   'Points Scored'
=> 'Erreichte Punkte',

   'Posts displayed?'
=> 'Welche Beitrge sollen angezeigt werden?',

   'Preferences can be set that determine'
=> 'Prferenzen knnen gesetzt werden, die festlegen',

   'Print contents of directory'
=> 'Inhalte diese Verzeichnis drucken',

   'Print directory'
=> 'Verzeichnis drucken',

   'Problem Document'
=> 'Aufgaben-Dokument',

   'Publish this Directory'
=> 'Dieses Verzeichnis verffentlichen',

   'Publish this resource'
=> 'Verffentlichen', # long version: 'Diese Ressource verffentlichen',

   'Re-publish'
=> 'Neu verffentlichen',

   'Retrieve old version'
=> 'Alte Version wiederherstellen',

   'Select action'
=> 'Aktion auswhlen',

   'Send message'
=> 'Nachricht versenden',

   'Set display preferences for discussion posts for both bulletin boards and individual resources in all your courses.'
=> 'Hier knnen Sie festlegen, wie Diskussionsbeitrge, Nachrichten an schwarzen Brettern und einzelne Ressourcen in allen Ihren Kursen angezeigt werden sollen.',

   'Show all foils'
=> 'Alle Auswahlmglichkeiten anzeigen',

   'Source Distribution'
=> 'Zugriffsrechte auf Quellcode',

   'The preferences you set here can be overridden within each individual discussion.'
=> 'Die Einstellungen, die Sie hier vornehmen, knnen bei jedem Diskussionsbeitrag individuell gendert werden.',

   'Under what circumstances posts are identfied as "New"'
=> 'unter welchen Bedingungen Diskussionsbeitrge als "Neu" erkannt werden sollen.',

   'Upload a new document'
=> 'Externes Dokument hochladen',

   'Use random seed'
=> 'Startwert fr Zufallszahlengenerator',

   'Use style file'
=> 'Verwende Stil-Datei',

   'Which posts are displayed when you display a bulletin board or resource, and'
=> 'welche Nachrichten angezeigt werden, wenn Sie ein schwarzes Brett oder eine Ressource anzeigen und',

   'closed'
=> 'Quellcode gesperrt', # !

   'del.gif'
=> 'del.gif',

   'delete[_1]'
=> 'lsche[_1]',

   'dir[_1]'
=> 'dir[_1]',

   'list.gif'
=> 'list.gif',

   'list[_1]'
=> 'Liste[_1]',

   'open'
=> 'Quellcode ffentlich', # !

   'pub.gif'
=> 'pub.gif',

   'publish[_1]'
=> 'verffentliche [_1]',

   'resource[_2]'
=> 'Ressource[_2]',

   'retrieve[_1]'
=> 'wiederherstellen[_1]',

   'rtrv.gif'
=> 'rtrv.gif',

   'version[_1]'
=> 'Version[_1]',


#SYNC Fri Sep  1 16:36:19 2006
   '(mark desired resources then click "next" button)'
=> '(markieren Sie gewnschte Ressourcen und klicken Sie dann auf "Weiter")',

   '<b>Change</b> for just <a href="/adm/whatsnew?command=courseinit&refpage=[_1]">this course</a>'
=> '<b>ndere</b> nur fr <a href="/adm/whatsnew?command=courseinit&refpage=[_1]">diesen Kurs</a>',

   'Add or Edit Blog Entries'
=> 'Blog-Eintrge hinzufgen oder bearbeiten',

   'Add to my public course blog'
=> 'Zu meinem ffentlichen Kurs-Blog hinzufgen',

   'Annotator'
=> 'Annotator',

   'Av. Attempts'
=> 'Mittlere Anzahl an Versuchen',

   'Available RSS Feeds and Blogs'
=> 'Verfgbare RSS-Feeds und Blogs',

   'Average number of attempts'
=> 'Durchschnittliche Anzahl an Versuchen',

   'Bookmarks'
=> 'Lesezeichen',

   'Change interval?'
=> 'Intervall ndern',

   'Change options?'
=> 'Optionen ndern',

   'Change thresholds?'
=> 'Schwellenwerte ndern',

   'Clean up'
=> 'Aufrumen',

   'Close Folder'
=> 'Verzeichnis schlieen',

   'Configure Blocking of Student Communication during Exams'
=> 'Blockieren studentischer Kommunikation whrend Prfungen konfigurieren',

   'Course Action Items'
=> 'Kurs-Aktionselemente',

   'Creating PDF'
=> 'PDF erzeugen',

   'Currently: <i>[_1]</i>'
=> 'Zurzeit: <i>[_1]</i>',

   'Deg. Diff'
=> 'Schwierigkeitsgrad',

   'Description'
=> 'Beschreibung',

   'Display Action Items'
=> 'Aktionselemente anzeigen',

   'Enter my groups in the course'
=> 'Meine Kurs-Gruppen',

   'Entering [_1]'
=> 'Betrete [_1]',

   'Entering [_1] ...'
=> 'Betrete [_1] ...',

   'Entering [_1] ....'
=> 'Betrete [_1] ....',

   'First resource'
=> 'Erste Ressource',

   'Generated [_1] ([_2] bytes)'
=> 'Erzeugt am [_1] ([_2] bytes)',

   'Go to first resource'
=> 'Gehe zur ersten Ressource',

   'Group Documents'
=> 'Gruppen-Dokumente',

   'Groups'
=> 'Gruppen',

   'Help Menu'
=> 'Hilfemen',

   'Hide all'
=> 'Alle verbergen',

   'Hide this Feed'
=> 'Diesen Feed verbergen',

   'LON-CAPA Feed "[_1]" for [_2]'
=> 'LON-CAPA-Feed "[_1]" fr [_2]',

   'Last Reset'
=> 'Letzte Zurcksetzung',

   'Last revised'
=> 'Letzte nderung',

   'Link'
=> 'Link',

   'Log In'
=> 'Anmelden',

   'Move'
=> 'Verschieben',

   'Move Checked to Folder'
=> 'Verschiebe Auswahl in Verzeichnis',

   'Name for New Feed'
=> 'Name des neuen Feed',

   'Name of this Feed'
=> 'Name dieses Feeds',

   'New course messages'
=> 'Neue Kursnachrichten',

   'New critical messages in course'
=> 'Neue kritische Kursnachrichten',

   'New in course'
=> 'Neu im Kurs',

   'New version'
=> 'Neue Version',

   'No messages sent.'
=> 'Keine Nachrichten verschickt.',

   'No new course messages'
=> 'Keine neuen Kursnachrichten',

   'No personal information provided'
=> 'Keine persnlichen Informationen zur Verfgung gestellt',

   'No problems require handgrading'
=> 'Keine Aufgaben mssen handkorrigiert werden',

   'No problems satisfy threshold criteria'
=> 'Keine Aufgaben erfllen die Schwellenkriterien',

   'No problems with errors'
=> 'Keine Aufgaben mit Fehlern',

   'No unread critical messages in course'
=> 'Kein ungelesenen kritischen Kursnachrichten',

   'No unread posts in course discussions'
=> 'Kein ungelesenen Beitrge in Kursdiskussionsforen',

   'No updated versions'
=> 'Keine aktualisierten Versionen',

   'Num. students'
=> 'Studierendenanzahl',

   'Number of errors'
=> 'Fehleranzahl',

   'Number of new posts'
=> 'Anzahl neuer Diskussionsbeitrge',

   'Number ungraded'
=> 'Anzahl unkorrigierter',

   'Open Folder'
=> 'Verzeichnis ffnen',

   'Open all folders'
=> 'Alle Verzeichnisse ffnen',

   'Page set to be displayed after you have selected a role in this course'
=> 'Seite, die angezeigt werden soll, nachdem Sie eine Rolle in diesem Kurs ausgewhlt haben',

   'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role'
=> 'Bitte whlen Sie den Typ der LON-CAPA-Entitt - Kurs oder Gruppe - fr den Sie die Benutzerrolle hinzufgen/ndern wollen.',

   'Please stand by while processing your print request, this may take some time ...'
=> 'Ihr Druckauftrag wird bearbeitet. Dies kann einige Zeit dauern. Bitte warten Sie...',

   'Preferences can be set that determine'
=> 'Prferenzen knnen gesetzt werden, die festlegen',

   'Print contents of directory'
=> 'Inhalte des Verzeichnisses drucken',

   'Print directory'
=> 'Verzeichnis drucken',

   'Problem'
=> 'Aufgabe',

   'Problem Document'
=> 'Aufgabe',

   'Problem Name'
=> 'Aufgabenbezeichnung',

   'Problem is not open to be viewed. It'
=> 'Aufgabe nicht zur Betrachtung freigegeben. Es',

   'Problems requiring handgrading'
=> 'Aufgaben, die von Hand korrigiert werden mssen',

   'Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2] <br /> and total number of students with submissions &ge; [_3]'
=> 'Aufgaben mit durchschnittlicher Anzahl an Versuchen &ge; [_1] oder Schwierigkeitsgrad &ge; [_2] <br /> und insgesamte Anzahl an Studierenden, die etwas eingereicht haben &ge; [_3]',

   'Problems with errors'
=> 'Aufgaben mit Fehlern',

   'Re-publish'
=> 'Neu verffentlichen',

   'Recently generated printouts'
=> 'Zuletzt erzeugte Ausdrucke',

   'Reset Count?'
=> 'Zhler zurcksetzen?',

   'Reset counters to 0'
=> 'Zhler auf 0 zurcksetzen',

   'Select [_1]'
=> 'Whle [_1]',

   'Select the sequence to print resources from:'
=> 'Whlen Sie die Sequenz, aus der Ressourcen gedruckt werden sollen:',

   'Selected <b>Problems</b> in folder <b><i>[_1]</i></b>'
=> 'Bestimmte <b>Aufgaben</b> im Verzeichnis <b><i>[_1]</i></b>',

   'Selected <b>Resources</b> in folder <b><i>[_1]</i></b>'
=> 'Bestimmte <b>Ressourcen</b> im Verzeichnis <b><i>[_1]</i></b>',

   'Send Message'
=> 'Nachricht versenden',

   'Send message'
=> 'Nachricht versenden',

   'Show all'
=> 'Alle anzeigen',

   'Show my first due problem'
=> 'Zeige meine erste zu bearbeitende Aufgabe',

   'Show only uncompleted problems'
=> 'Nur noch nicht abgeschlossene Aufgaben zeigen',

   'Showing messages [_1] through [_2] of [_3]'
=> 'Showing messages [_1] through [_2] of [_3]',

   'Speller Suggestions'
=> 'Speller Suggestions',

   'Start a New Feed'
=> 'Neuen Feed starten',

   'Save Marked Changes'
=> 'Markierte nderungen speichern',

   'Save changes'
=> 'nderungen speichern',

   'The preferences you set here can be overridden within each individual discussion.'
=> 'Die hier einstellbaren Prferenzen knnen innerhalb jedes Diskussionsbeitrages gendert werden.',

   'This action is currently not authorized.'
=> 'Diese Aktion ist zurzeit nicht erlaubt.',

   'Time of last post'
=> 'Uhrzeit des letzten Beitrags', #??? [SB 20.10.2006]

   'Title of document goes here'
=> 'Dokumententitel hier eintragen',

   'Total number of students with submissions'
=> 'Gesamtzahl an Studierenden, die etwas eingereicht haben',

   'Under what circumstances posts are identfied as "New"'
=> 'unter welchen Bedingungen Diskussionsbeitrge als "Neu" identifiziert werden',

   'Unread course discussion posts'
=> 'Nichtgelesene Kursdiskussionsbeitrge',

   'Version used'
=> 'verwendetete Version',

   'Version[_1]'
=> 'Version[_1]',

   'View current problem status and grading information'
=> 'Bewertungs-Informationen',

   "What's New?"
=> "Was gibt's Neues?",

   "What's New? page"
=> "Was-gibt's-Neues-Seite",

   'You are accessing an invalid course'
=> 'Sie versuchen auf einen ungltigen Kurs zuzugreifen.',

   'course only'
=> 'nur Kurs',

   'course[_12]'
=> 'Kurs[_12]',

   'delete'
=> 'Lschen',

   'first resource in the course'
=> 'erste Kursressource',

   'groups[_1]'
=> 'Gruppen[_1]',

   'grps.gif'
=> 'grps.gif',

   'hidden'
=> 'verborgen',

   'list[_1]'
=> 'list[_1]',

   'new feed'
=> 'new feed',

   'or for all <a href="/adm/preferences?action=changecourseinit&refpage=[_1]">your courses</a>.'
=> 'oder fr alle <a href="/adm/preferences?action=changecourseinit&refpage=[_1]">Ihre Kurse</a>.',

   'since last month'
=> 'seit letztem Monat',

   'since last week'
=> 'set letzter Woche',

   'since start of course'
=> 'seit Kursbeginn',

   'since yesterday'
=> 'seit gestern',

   'specific setting for this course'
=> 'spezifische Einstellung fr diesen Kurs',

   'test.problem'
=> 'test.problem',

   'the resource you just saw on the screen'
=> 'die Ressource, die Sie zuletzt betrachtet haben',

   'user preference'
=> 'Benutzerprferenz',

   'version[_1]'
=> 'Version[_1]',

   "what's new? page"
=> "Was-gibt's-Neues-Seite",

   'your general user preferences'
=> 'Ihre allgemeinen Benutzerprferenzen',


#SYNC Fri Sep  1 17:10:10 2006
   'Move'
=> 'Verschieben',

   'Send Message'
=> 'Nachricht versenden',

   'Send message'
=> 'Nachricht versenden',

   'Show all'
=> 'Alle zeigen',

   'Show only uncompleted problems'
=> 'Nur nicht abgeschlossene Aufgaben anzeigen',

   'Save changes'
=> 'nderungen speichern',

   'Submitting as Comment'
=> 'Als Kommentar einreichen',

   'Submitting as Policy Feedback'
=> 'Submitting as Policy Feedback',

   'Submitting as Question'
=> 'Als Frage einreichen',

   'Total Points In Course'
=> 'Gesamtpunkte im Kurs',

   'Version used'
=> 'Verwendete Version',

   "What's New?"
=> "Was gibt's Neues?",

   'You are accessing an invalid course'
=> 'Sie versuchen auf einen ungltigen Kurs zuzugreifen',

   'course only'
=> 'nur Kurs',

   'course[_12]'
=> 'Kurse[_12]',

   'delete'
=> 'lschen',

   'first resource in the course'
=> 'erste Kursressource',

   'since last month'
=> 'seit letztem Monat',

   'since last week'
=> 'seit letzter Woche',

   'since start of course'
=> 'seit Kursanfang',

   'since yesterday'
=> 'seit gestern',

   'specific setting for this course'
=> 'spezifische Einstellung fr diesen Kurs',

   'the resource you just saw on the screen'
=> 'die zuletzt betrachtete Ressource',

   'user preference'
=> 'Benutzerprferenz',

   "what's new? page"
=> "Was-gibt's-Neues-Seite",

   'your general user preferences'
=> 'Ihre allgemeinen Benutzereinstellungen',


#SYNC Fri Sep  1 22:23:03 2006
   'Annotations'
=> 'Notizen',

   'Close (no save)'
=> 'Schlieen (ohne Speichern)',

   'Save and Update'
=> 'Speichern und aktualisieren',


#SYNC Fri Sep  1 22:39:12 2006
   'Bookmark Tree Viewer/Editor'
=> 'Lesezeichenbaum-Anzeige/Editor',

   'Chat'
=> 'Chat',

   'Chat room'
=> 'Chatroom',

   'Download your Calendar as iCalendar File'
=> 'Download Ihres Kalenders als iCalendar-Datei',

   'Drop Box'
=> 'Drop Box',

   'Import Bookmarks'
=> 'Lesezeichen importieren',

   'The LearningOnline Network with CAPA'
=> 'The LearningOnline Network with CAPA',


#SYNC Fri Sep  1 23:07:39 2006
   'Although your current role has privileges to view any existing groups in thiscourse, you do not have privilegesto create new groups.'
=> 'Obwohl Sie in Ihrer derzeitigen Rolle ber das Recht verfgen alle Gruppen in diesem Kurs anzusehen, haben Sie nicht das Recht neue Gruppen zu erzeugen.',

   'Collaborative Tools'
=> 'Kollaborative Werkzeuge',

   'Course content'
=> 'Kursinhalt',

   'Create a new group'
=> 'Neue Gruppe erstellen',

   'Created'
=> 'Erstellt',

   'Creator'
=> 'Ersteller',

   'Discussion Boards'
=> 'Diskussionsforen',

   'Disk Use (%)'
=> 'Plattennutzung (%)',

   'Enable Recent Roles Hotlist:'
=> 'Verwende Schnellzugriff fr zuletzt verwendete Rollen:',

   'Erster Kurs'
=> 'Erster Kurs',

   'Files'
=> 'Dateien',

   'Group Name'
=> 'Gruppen-Name',

   'Group Title'
=> 'Gruppen-Titel',

   'Members'
=> 'Mitglieder',

   'Modify'
=> 'Verndern',

   'No groups exist.'
=> 'Es existieren keine Gruppen.',

   'Number of roles in Hotlist:'
=> 'Anzahl der Rollen in Schnellzugriffsliste:',

   'Portofolio Manager'
=> 'Portfolio-Manager',

   'Quota (Mb)'
=> 'Quota (Mb)',

   'Remote Control'
=> 'Fernbedienung',

   'Some LON-CAPA users have a long list of roles. The Recent Roles Hotlist feature keeps track of the last N roles which have been visited and places a table of these at the top of the roles page. People with very few roles should leave this feature disabled.'
=> 'Einige LON-CAPA-Benutzer haben sehr viele Rollen. Der Schnellzugriff auf zuletzt verwendete Rollen speichert die letzten n Rollen, die Sie verwendet haben und bietet Ihnen eine Liste mit diesen Rollen am Anfang Ihrer Rollenauswahlseite. Benutzer mit nur wenigen Rollen sollten diese Schnellzugriffsliste deaktiviert lassen.',

   'Switch to Inline Menu Mode'
=> 'Wechsle zum Modus mit Kopfzeilenmen',

   'This list below can be used to <q>freeze</q> roles on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.'
=> 'Die nachfolgende Liste kann verwendet werden, um Rollen <q>einzufrieren</q>. Rollen, die als eingefroren markiert wurden, werden nicht aus der Liste beseitigt werden, selbst wenn sie in letzter Zeit nicht verwendet wurden.',

   'View Status'
=> 'Status anzeigen',

   'View/Change Status'
=> 'Status anzeigen/ndern',

   'You are not currently a member of any active [_1]s in this [_2]'
=> 'Sie sind zurzeit nicht Mitglied einer aktiven [_1] in diesem [_2]',

   'with no related words'
=> 'ohne hnliche Begriffe',


#SYNC Fri Sep  1 23:29:38 2006
   'Change Roles Preferences'
=> 'Rollenprferenzen ndern',

   'Display [_1] Most Recent Roles'
=> 'Zeige [_1] der zuletzt verwendeten Rollen',

   'Freeze Role'
=> 'Rolle einfrieren',

   'Recent Roles Hotlist is Disabled'
=> 'Schnellzugriffsliste auf zuletzt verwendete Rollen wird nicht verwendet',

   'Recent Roles Hotlist is Enabled'
=> 'Schnellzugriffsliste auf zuletzt verwendete Rollen wird verwendet',


#SYNC Sat Sep  2 00:00:45 2006
   'Author Space'
=> 'Autorenbereich',

   'Course Restricting Metadata'
=> 'Course Restricting Metadata',

   'Degree of discrimination'
=> 'Grad der Abgrenzung',

   'Disable WYSIWYG Editor'
=> 'WYSIWYG-Editor deaktivieren',

   'Hypertext Document'
=> 'HTML-Dokument',

   'Last Modifying User'
=> 'Zuletzt modifizierender Benutzer',

   'Last Revision Date'
=> 'Datum der letzten berarbeitung',

   'Linked/Related Resources'
=> 'Verknpfte/Verwandte Ressourcen',

   'Network-wide courses using resource'
=> 'Netzwerkweite Kurse, die diese Ressource verwenden',

   'Never'
=> 'Niemals',

   'Preview'
=> 'Voransicht',

   'Resources that follow this resource in maps'
=> 'Ressourcen, die in einer Inhaltszusammenstellung Nachfolger dieser Ressource sind',

   'Resources that lead up to this resource in maps'
=> 'Ressourcen, die in einer Inhaltszusammenstellung Vorlufer dieser Ressource sind',

   'Resources used by this resource'
=> 'Ressourcen, die von dieser Ressource verwendet werden',

   'Resources using or importing resource'
=> 'Ressourcen, die diese Ressource benutzen', #??? [SB 18.10.2006]

   'Return'
=> 'Zurck',

   'Selected <b>Problems</b> from current subdirectory <b><i>[_1]</i></b>'
=> 'Ausgewhlte <b>Aufgaben</b> aus aktuellem Unterverzeichnis <b><i>[_1]</i></b>',

   'Setting WYSIWYG editor to:'
=> 'Setze WYSIWYG-Editor auf:',

   'Source Available'
=> 'Quellcode verfgbar',

   'Source Custom Distribution File'
=> 'Datei zum Maschneidern der Zugriffsrechte',

   'Start new page<br />before selected'
=> 'Start new page<br />before selected',

   'on'
=> 'an',


#SYNC Sat Sep  2 20:43:30 2006
   '(re-initialize course to access)'
=> '(Kurs neu initialisieren, um Zugriff zu erhalten)',

   'All Parts'
=> 'Alle Teile',

   'Changes will become active for your current session after [_1], or the next time you log in.'
# => 'Um die nderungen fr die aktuelle Sitzung zu bernehmen, klicken Sie [_1] oder melden Sie sich neu an.',
=> '[_1] Hier klicken, um die letzten nderungen sofort zu bernehmen.',

   'Cut'
=> 'Ausschneiden',

   'Due and Answer Available'
=> 'Flligkeit und Antwort verfgbar', #??? [SB 19.10.2006]

   'Dump [_1] DOCS'
=> 'Dump [_1] DOCS',

   'Edit any group in the course'
=> 'Kurs-Gruppen verwalten',

   'Editing the Table of Contents for your Course'
=> 'Das Inhaltsverzeichnis des Kurses bearbeiten',

   'Enter any group in the course'
=> 'Einer beliebigen Gruppe des Kurses beitreten',

   'Existing Parameter Settings for Your Resources'
=> 'Bestehende Parameter-Einstellungen fr Ihre Ressourcen',

   'Export Course to IMS'
=> 'IMS-Export',

   'Group'
=> 'Gruppe',

   'Hidden'
=> 'Verborgen',

   'List Symbs'
=> 'Interne Bezeichner',

   'Symb List'
=> 'Liste interner Bezeichner',

   'Manage Course Slots'
=> 'Manage Course Slots',

   'Manage student enrollment '
=> 'Studentische Kursbelegungen verwalten ',

   'Modify Resource Parameters - Overview Mode'
=> 'ndern von Ressourcen-Parametern - bersichtsmodus',

   'Modify parameter settings (due dates, etc) for resources and the course'
=> 'Kurs- und Ressourcen-Parameter',

   'Modify parameter settings for this resource'
=> 'Parametereinstellungen', # long version: 'Parametereinstellungen fr diese Ressource ndern',

   'New and Existing Parameter Settings for Your Resources'
=> 'Neue und bestehende Parameter-Einstellungen fr die Ressourcen',

   'Parameter Change Log and Course Blog Posting/User Notification'
=> 'Parameternderungs-Protokoll und Kurs-Blog-Posting/Benutzer-Benachrichtigung',

   'Parameter Manager'
=> 'Kurs- und Ressourcen-Parameter',

   'Randomly Pick: '
=> 'Whle zufllig: ',

   'Remove'
=> 'Entfernen',

   'Rendering'
=> 'Rendern',

   'Select Parameters to View'
=> 'Auswahl der Parameter, die angezeigt werden sollen',

   'Select Parts to View'
=> 'Auswahl der Teile, die angezeigt werden sollen',

   'Set Parameter Setting Default Actions'
=> 'Setze Parameter-Einstellungen fr Default-Aktionen',

   'Set Portfolio Metadata'
=> 'Portfolio-Metadaten',

   'Set/Modify Resource Parameters - Helper Mode'
=> 'Ressourcen-Parameter - Hilfsmodus',

   'Set/Modify Resource Parameters - Overview Mode'
=> 'Ressourcen-Parameter - bersichtsmodus',

   'Set/Modify Resource Parameters - Table Mode'
=> 'Ressourcen-Parameter - Tabellenmodus',

   'Settings for Your Course'
=> 'Kurs-Einstellungen',

   'Table Mode'
=> 'Tabellenmodus',

   'Table Mode Parameter Setting'
=> 'Tabellenmodus-Parameter-Einstellungen',

   'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".'
=> 'Die Ressourcen in "[_1]" knnen nur zeitlich begrenzt bearbeitet werden. Sobald Sie auf "[_2]" klicken, haben Sie [_3], um alle Ressourcen in "[_1]" zu bearbeiten.',

   'URL hidden'
=> 'URL verborgen',

   'Update Parameter Display'
=> 'Parameteranzeige aktualisieren',

   'View calculated grades (Spreadsheet)'
=> 'Berechnete Noten (Spreadsheet)',

   "What's new?"
=> "Was gibt's Neues?",

   '[quant,_1,day]'
=> '[quant,_1,Tag]',

   'edit[_1]'
=> 'edit[_1]',

   'grades[_3]'
=> 'grades[_3]',

   'new.gif'
=> 'new.gif',

   'new[_1]'
=> 'new[_1]',

   'parms[_2]'
=> 'parms[_2]',

   'pgrd.gif'
=> 'pgrd.gif',

   'pparm.gif'
=> 'pparm.gif',

   'problem[_1]'
=> 'problem[_1]',

   'problem[_2]'
=> 'problem[_2]',

   're-initializing Course'
=> 'Kurs neu initialisieren',

   'what is[_1]'
=> 'was ist[_1]', #??? [SB 19.10.2006]

   'Show Resource'
=> 'Zeige Ressource',

   "Computer's answer now shown above."
=> "Die als richtig hinterlegte Antwort wird oben angezeigt.",

   'Only a number required. Computer reads units of "[_1]".'
=> 'Als Eingabe ist nur eine Zahl zulssig. Rechner interpretiert Ihre Eingabe so, dass Sie die Einheit "[_1]" verwenden.',

'Feedback to resource author'
=> 'Rckmeldung an den Autor der Ressource',

'Submission not graded. Use fewer digits.'
=> 'Die Eingabe wurde nicht gewertet. Verwenden Sie weniger Dezimalstellen.',

'Submission not graded. Use more digits.'
=> 'Die Eingabe wurde nicht gewertet. Verwenden Sie mehr Dezimalstellen.',


#

   'Click to add/remove attachments',
=> 'Hier klicken, um Anhnge anzufgen/zu entfernen',

   'New attachments'
=> 'Neue Anhnge',

   'Retained attachments'
=> 'Zurckbehaltene Anhnge',

   'Add a new attachment to this post.'
=> 'Neuen Anhang fr diese Nachricht erstellen:',

   'Discussion Post Attachments'
=> 'Anhnge fr Diskussions-Nachrichten',


#

   'Modify course settings'
=> 'Kurseinstellungen',

   'Send and display broadcast e-mail'
=> 'Broadcast-Nachrichten',

   'Total Points'
=> 'Gesamtpunktzahl',

   'Create a single course'
=> 'Einen neuen, einzelnen Kurs erstellen',

   'Create a new course by completing an online form.'
=> 'Einen neuen Kurs durch Ausfllen eines Formulars erstellen.',

   'current'
=> 'aktuell',


#
   'A draft copy has been saved.'
=> 'Ihr Entwurf wurde gespeichert.',


#
   'Update Class List'
=> 'Kursteilnehmerliste aktualisieren', # n.t.

   'Version changes'
=> 'Version gendert',

   'Change interval'
=> 'Intervall ndern',

    'Resources in course with version changes '
 => 'Ressourcen im Kurs mit Versionsnderungen ', #??? lonwhatsnew.pm  SB [22.06.2007]

   'Student Submission Reports'
=> 'Berichte studentischer Einreichungen',

   'Prepare reports of student submissions.'
=> 'Berichte zu den studentischen Einreichungen erstellen',

   'Survey Reports'
=> 'Umfrage-Berichte',

   'Prepare reports on survey results.'
=> 'Berichte zu Umfrage-Ergebnissen erstellen',

   'Correct Problems Plot'
=> 'Richtige-Antworten-Diagramme',

   'Display a histogram of student performance in the course.'
=> 'Histogramm studentischer Kursleistungen anzeigen',

   'Access Status'
=> 'Zugriffsstatus',

   'Limit by time'
=> 'Zeitliche Begrenzung', # n.t.

   'Submission Time Plots'
=> 'Einreichungszeit-Diagramme',

   'Currently Has Access'
=> 'Aktueller Zugriff',

   'Will Have Future Access'
=> 'Zuknftiger Zugriff',

   'Previously Had Access'
=> 'In der Vergangenheit liegender Zugriff',

   'Any Access Status'
=> 'Beliebiger Zugriffsstatus',

   'Previous Problem'
=> 'Vorherige Aufgabe',

   'Next Problem'
=> 'Nchste Aufgabe',

   'Choose a different Problem'
=> 'Eine andere Aufgabe auswhlen',

   'Update Caches'
=> 'Cache aktualisieren',

   'Begin'
=> 'Beginn',

   'There are no students in the sections selected'
=> 'In den gewhlten Sektionen sind keine Studenten.',

   'Graph Problem Submission Times'
=> 'Graph Aufgaben-Einreichungszeiten',


#
   'Return to Directory'
=> 'Zurck zum Verzeichnis',


# 2007-06-15

   'My Roles'
=> 'Meine Rollen',

   'My Space'
=> 'Mein Bereich',

   'Edit blogs, RSS feeds, and podcasts'
=> 'Blogs, RSS-Feeds und Podcasts',

   'Content Library'
=> 'Inhalte',

   'Search the contents of this course or accessible portfolio files'
=> 'Kurs- und Portfolio-Suche',

   'Grading and Statistics'
=> 'Bewertungen und Statistiken',

   'Other'
=> 'Sonstiges',

   'group'
=> 'Gruppe',

   'Actions'
=> 'Aktionen',

   'Size'
=> 'Gre',

   'Current Access Status'
=> 'Aktueller Zugriffsstatus',

   'Delete Checked Files'
=> 'Markierte Dateien lschen', # n.t.

   'Using the portfolio file list'
=> 'Verwendung der Portfolio-Dateiliste',

   'Help on the portfolio'
=> 'Hilfe zum Portfolio-Bereich', # n.t.

   'Rename'
=> 'Umbenennen',

   'Private'
=> 'privat',

   'Change How Menus are Displayed'
=> 'Darstellung der Mens',

   'Use icons and text'
=> 'Icons mit Text',

   'Use buttons and text'
=> 'Buttons mit Text',

   'Use icons only'
=> 'Nur Icons',

   'Previous Tries'
=> 'Bisherige Antworten',

   'Change Main Menu'
=> 'Darstellung der Mens',

   'New screenname (shown if you post anonymously):'
=> 'Nickname fr anonyme Beitrge:',

   'New nickname (shown if you post non-anonymously):'
=> 'Nickname fr nicht anonyme Beitrge:',

   'Choose the time window to use for display of version changes for resources in the course.'
=> 'Auswahl des Zeitfensters zur Anzeige von Versionsnderungen von Kurs-Ressourcen.',

   'User Management'
=> 'Benutzerverwaltung',

   'Manage student enrollment'
=> 'Studentische Kursbelegungen',

   'Modify an existing group'
=> 'Bestehende Gruppe ndern',

   'Delete an existing group'
=> 'Bestehende Gruppe lschen',

   'Re-enable a deleted group'
=> 'Gelschte Gruppe wiederherstellen',

   'Enter an existing group'
=> 'Einer bestehenden Gruppe beitreten',

   'Course Management'
=> 'Kurs-Verwaltung',

   'Reset Student Access Times'
=> 'Studentische Zugriffszeiten zurcksetzen',

   'Submission #'
=> 'Antwort-Nr.',

   'Try'
=> 'Versuch',

   'Submitted Answer'
=> 'Eingereichte Antwort',

   'Close Window'
=> 'Fenster schlieen',

   'Portfolio Search'
=> 'Portfolio-Suche',

   'Enter words and quoted phrases'
=> 'Eingabe von Wrtern und in Anfhrungszeichen gesetzten Ausdrcken',

   'Portfolio and Course Search'
=> 'Kurs- und Portfolio-Suche',

   'Message Status'
=> 'Nachrichten-Status',

   'Any'
=> 'Beliebig',

   'Unread'
=> 'Ungelesen',

   'Read'
=> 'Gelesen',

   'Replied to'
=> 'Beantwortet',

   'Forwarded'
=> 'Weitergeleitet',

   'Rename Folder'
=> 'Verzeichnis umbenennen',

   'Delete Folder'
=> 'Verzeichnis lschen',

   'Recent Roles'
=> 'Zuletzt benutzte Rollen',

   'Close navigation window'
=> 'Navigationsfenster beenden',

   'Post Anonymous'
=> 'Anonym absenden',

   'Post'
=> 'Absenden',

   'Back to preferences menu'
=> 'Zurck',

   'Forwarding Address(es) (user:domain,user:domain,...):'
=> 'Weiterleitungsadresse(n) (Benutzer:Domne,Benutzer:Domne,...)',

   'Message Notification Email Address(es) (joe@doe.com):'
=> 'Nachrichten-Benachrichtigungs-E-Mail-Adresse(n) (hans@wurst.de)',

   'Notification address'
=> 'Benachrichtungsadresse',

   'Types of message to forward to this address'
=> 'Art der Nachrichten, die weitergeleitet werden sollen',

   'Excerpt retains HTML tags in message'
=> 'Im Nachrichtenauszug HTML beibehalten',

   'All'
=> 'alle',

   'Critical only'
=> 'nur kritische',

   'Non-critical only'
=> 'nur nicht-kritische',

   'Add new address'
=> 'Neue Adresse hinzufgen',

   'What are forwarding and notification addresses'
=> 'Was sind Weiterleitungs- und Benachrichtigungs-Adressen',

   'What are critical messages'
=> 'Was sind kritische Nachrichten',

   'Change Roles Page Pref'
=> 'Benutzerrollen-Schnellzugriffsliste',

   'Number of Roles in Hotlist:'
=> 'Anzahl Rollen in Schnellzugriffsliste:',

   'Current Password'
=> 'Derzeitiges Passwort',

   'New Password'
=> 'Neues Passwort',

   'Confirm Password'
=> 'Besttigung neues Passwort',

   'Passwords must be a minimum of 7 characters long. Please try again.'
=> 'Das Passwort muss mindestens 7 Zeichen lang sein. Bitte versuchen Sie es noch einmal.',

   'The new passwords you entered do not match. Please try again.'
=> 'Die Bestaetigung des neuen Passworts stimmt nicht mit dem neuen Passwort ueberein. Bitte versuchen Sie es noch einmal.',

   'Please make sure your old password was entered correctly.'
=> 'Stellen Sie sicher, dass das alte Passwort korrekt eingegeben wurde.',

   'Send me a message'
=> 'Diesem Benutzer eine Nachricht schicken',

   'Show Public View'
=> 'ffentliche Sicht zeigen',

   'Delete Photo'
=> 'Foto lschen',

   'Help with filling in text boxes'
=> 'Hilfe zur Eingabe in Textfeldern',

   'Examples:'
=> 'Beispiele:',

   'off'
=> 'aus',

   'Summary Preview'
=> 'Zusammenfassungsvorschau',

   'Send copy to permanent email address (if known)'
=> 'Sende Kopie an externe E-Mail-Adresse (falls hinterlegt)',

   'Include in course RSS newsfeed'
=> 'In kursinterne RSS-Feeds einbinden',

   'Allow replies:'
=> 'Antworten zulassen:',

   'Reply to:'
=> 'Antwort an:',

   'Domain Management'
=> 'Domnen-Verwaltung',

   ''
=> '',

   'Course ID of Key Authority:'
=> 'Course ID of Key Authority:',

   'Set domain configuration'
=> 'Domnen-Konfiguration',

   'Domain Configuration'
=> 'Domnen-Konfiguration',

   'View/Modify Domain Settings'
=> 'Domnen-Konfiguration',

   'Menu'
=> 'Men',

   'Domain Settings'
=> 'Domnen-Konfiguration',

   'Course Environment'
=> 'Kursumgebung',

   'Edit Course Environment'
=> 'Kursumgebung',

   'Users allowed to clone course'
=> 'Kursklonungsberechtigte Benutzer',

   'Users with active Course Coordinator role in the course automatically have the right to clone it, and can be omitted from list.'
=> 'Benutzer mit aktiver Kurs-Koordinator-Rolle zu diesem Kurs haben automatisch das Recht zum Klonen und brauchen daher hier nicht eingetragen werden.',

   'URL of Syllabus (not using internal handler)'
=> 'Externe URL des Kursberblicks',

   'Custom Text for Resource Content Question Option in Feedback'
=> 'Eigener Text fr Ressourcen-Inhaltsfragen-Option beim Feedback',

   'Custom Text for Course Content Option in Feedback'
=> 'Eigener Text fr Kursinhalts-Option beim Feedback',

   'Custom Text for Course Policy Option in Feedback'
=> 'Eigener Text fr Kursrichtlinien-Option beim Feedback',

   'Allow students to view classlist.'
=> 'Studenten erlauben, die Kursteilnehmerliste einzusehen',

   'students can view all sections'
=> 'Studenten knnen alle Sektionen sehen',

   'Allow users with specified roles to edit/delete their own discussion posts'
=> 'Erlaube Benutzern mit angegebenen Rollen, ihre eigenen Diskussionsbeitrge zu editieren/lschen',

   'Suppress number of tries in printing'
=> 'Angabe der Anzahl der Versuche beim Druck auslassen',

   'Default paper type'
=> 'Standard-Papierformat',

   'Default beginning date for student access.'
=> 'Voreingestelltes Startdatum fr studentischen Zugriff',

   'Default ending date for student access.'
=> 'Voreingestelltes Endedatum fr studentischen Zugriff',

   'Disable checking of Significant Figures'
=> 'berprfung signifikanter Stellen deaktivieren',

   'Disable automatically printing point values onto exams.'
=> 'Disable automatically printing point values onto exams.',

   'Send message to student when clicking Done on Tasks'
=> 'Send message to student when clicking Done on Tasks',

   'Restrict Metadata'
=> 'Portfolio-Metadaten',

   'Show to student'
=> 'dem Studenten zeigen',

   'Provide text area for students to type catalog information'
=> 'dem Studenten Textfeld anbieten, um Kataloginformationen eingeben zu knnen',

   'Provide choices for students to select from'
=> 'dem Studenten Auswahl anbieten, um whlen zu knnen aus',

   'Student may select multiple choices from list'
=> 'Mehrfachauswahl aus Liste erlauben',

   'Student may select only one choice from list'
=> 'Nur eine Auswahl aus der Liste erlauben',

   'Add a Metadata Field'
=> 'Ein Metadatenfeld hinzufgen',

   'Order Metadata Fields'
=> 'Order Metadata Fields',

   'Continue Import'
=> 'Import fortsetzen',

   'Continue Search'
=> 'Suche fortsetzen',

   'Finish Import'
=> 'Import abschlieen',

   'Include'
=> 'Einbinden',

   'CLOSE'
=> 'Schlieen', # n.t.

   'LON-CAPA Catalog Search'
=> 'LON-CAPA-Katalog-Suche',

   'include external resources'
=> 'externe Ressourcen mit einbeziehen',

   'Change Course Initialization Preference'
=> 'Kurs-Initialisierung',

   'Change Course Init. Pref.'
=> 'Kurs-Initialisierung',

   'Reset Access Times'
=> 'Studentische Zugriffszeiten zurcksetzen',

   'Select Scope'
=> 'Bereich whlen',

   'Reset times on one or more folders/maps for a single student.'
=> 'Zeiten in einem/r oder mehreren Verzeichnissen/Inhaltszusammenstellungen fr einen einzelnen Studenten zurcksetzen',

   'Reset times on a single folder/map for a section or whole clase.'
=> 'Zeiten fr ein(e) einzelne(s) Verzeichnis/Inhaltszusammenstellung fr eine Sektion oder einen gesamten Kurs zurcksetzen',

   'Choose a student:'
=> 'Student auswhlen:',

   'Select Currently Enrolled Students and Active Course Personnel'
=> 'Wahl derzeit eingeschriebener Studenten oder aktiven Kurspersonals',

   'This is a list of folders/maps and times they were accessed, plese select those you want deleted.'
=> 'Hier ist eine Liste der Verzeichnisse/Inhaltszusammenstellungen und Zeiten, an denen Zugriff auf diese bestand. Bitte whlen Sie die aus, die gelscht werden sollen.',

   'Select:'
=> 'Auswahl:',

   'All Course Personnel'
=> 'Gesamtes Kurspersonal',

   'No Section'
=> 'Keine Sektion',

   'Unselect'
=> 'Auswahl aufheben',

   'Select a folder/map'
=> 'Verzeichnis/Inhaltszusammenstellung whlen',

   'Will remove access times for'
=> 'Werde Zugriffszeiten entfernen fr',

   'from users'
=> 'von Benutzern',

   'No Access times found for student'
=> 'Keine Zugriffszeit gefunden fr Student',

   'Finish'
=> 'Beenden',

   'Name of New Folder'
=> 'Name des neuen Verzeichnisses:',

   'Name of New Page'
=> 'Name der neuen zusammengesetzten Seite',

   'New Page'
=> 'Neue zusammengesetzte Seite',

   'WARNING: Removing a resource makes associated grades and scores inaccessible! Remove [_1]?'
=> 'Warnung: Entfernen der Ressource macht damit verbundene Bewertungen und Punkte unerreichbar! [_1] wirklich entfernen?',

   'Paste'
=> 'Einfgen',

   'Listed Title for the Page'
=> 'Titel der zusammengesetzten Seite',

   'Listed Title for the Problem'
=> 'Titel der Aufgabe',

   'This may take a few moments to display.'
=> 'Die Berechnung knnte einen Moment dauern.',

   'Detailed Citation Preview'
=> 'Detailierte Zitatsvorschau',

   'related words'
=> 'hnliche Wrter',

   'Any domain'
=> 'Beliebige Domne',

   'Reset'
=> 'Zurcksetzen',

   'MIME Type Category'
=> 'MIME-Typ-Kategorie',

   'Domains'
=> 'Domnen',

   'Custom Metadata fields'
=> 'Eigene Metadaten-Felder',

   'Field Name'
=> 'Feldbezeichnung',

   'Field Value(s)'
=> 'Feldinhalt(e)',

   'Another custom field/value pair?'
=> 'Ein weiteres eigenes Metadaten-Feld?',

   'Creation and Modification dates'
=> 'Erstellungs- und nderungsdaten',

   'Created between'
=> 'Erstellung zwischen',

   'Last modified between'
=> 'Zuletzt gendert zwischen',

   'Standard Portfolio Metadata'
=> 'Standard-Portfolio-Metadaten',

   'Advanced Portfolio Search'
=> 'Erweiterte Portfolio-Suche',

   'Standard Catalog Metadata'
=> 'Standard-Katalog-Metadaten',

   'Problem Statistics'
=> 'Aufgaben-Statistiken',

   'Statistics calculated for number of students'
=> 'Statistiken berechnet fr bestimmte Anzahl an Studenten',

   'Portfolio and Catalog Search'
=> 'Datenbank verffentlichter Ressourcen und Portfolio-Dateien',

# 2007-06-22
   'Search the database of accessible portfolio files'
=> 'Datenbank der Portfolio-Dateien',

   'Construction Space:'
=> 'Konstruktionsbereich:',

   'Problem Status:'
=> 'Aufgabenstatus:',

   'Problem Type:'
=> 'Aufgabentyp:',

   'Feedback Mode:'
=> 'Feedback-Modus:',

   'Answer for Part:'
=> 'Antwort fr Teil:', # n.t.

   'Script Vars'
=> 'Skript-Variablen',

   'Regular file'
=> 'Regulre Datei',

   'Testbank file'
=> 'Testbank-Datei',

   'IMS package'
=> 'IMS-Paket',

   'There are unsaved changes'
=> 'Es liegen ungespeicherte nderungen vor!',

   'Found no analyzable responses in this problem, currently only Numerical,
Formula and String response styles are supported.'
=> 'Keine analysierbaren Antwortblcke in der Aufgabe gefunden. Derzeit werden
nur numericalresponse, formalaresponse und stringresponse untersttzt.',

   'Active Link'
=> 'Aktive Links',

   'Font'
=> 'Zeichen',

   'Un-Visited Link'
=> 'Unbesuchte Links',

   'Page Background'
=> 'Seitenhintergrund',

   'Header Border'
=> 'Seitenkopf-Rahmen',

   'Header Background'
=> 'Seitenkopf-Hintergrund',

   'Visited Link'
=> 'Besuchte Links',

   'Change Custom Colors'
=> 'Farbeinstellungen bernehmen',

   'Reset All Colors to Default'
=> 'Alle Farben auf Voreinstellung zurcksetzen',

   'Directory Contents:'
=> 'Inhaltsverzeichnis:', # n.t.

   'Save and Edit'
=> 'Speichern und weiterbearbeiten',

   'Save and View'
=> 'Speichern und betrachten',

   'Check Spelling'
=> 'Rechtschreibprfung',

   'Selecting a Course'
=> 'Kurs auswhlen',

   'Course Activity:'
=> 'Letzte Kursaktivitt:',

   'Course Domain:'
=> 'Kurs-Domne:',

   'Course Institutional Code:'
=> 'Kurs-Instituts-Code:',

   "Course Owner's Username:"
=> 'Benutzername des Kurs-Eigentmers:',

   "Course Owner's Domain:"
=> 'Domne des Kurs-Eigentmers:',

   'LON-CAPA course ID:'
=> 'LON-CAPA-Kurs-ID:',

   'Course Description:'
=> 'Kurstitel:',

   'Resource Space Home'
=> 'Ressourcenbereich-Hauptverzeichnis',

   'Default start and end dates for student access'
=> 'Voreingestelltes Start- und Ende-Datum fr studentischen Zugriff',

   'Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Soll LON-CAPA den <b>Domnen-Koordinator</b> benachrichtigen, wenn whrend eines automatischen Updates nderungen an der Kursbelegung auftreten?',

   'Course Group Settings'
=> 'Kursgruppen-Einstellungen',

   'Set a quota for the total disk space available for storage of course group
portfolio files.'
=> 'Verfgbarer Gesamtspeicherplatz fr Portfolio-Dateien fr alle Kursgruppen dieses Kurses:',

   'Creation Options'
=> 'Erstellungsoptionen',

   ' Creation Settings'
=> ' Erstellungs-Einstellungen',

   'Creation Outcome'
=> 'Ergebnis der Erstellung',

   'New LON-CAPA course ID:'
=> 'Neue LON-CAPA-Kurs-ID:',

   'Created on:'
=> 'Erstellt in Domne:',

   'Cloning course from'
=> 'Kurs geclont aus Domne',

   'Setting environment:'
=> 'Einstellung der Kursumgebung:',

   'Assigning role of Course Coordinator to'
=> 'Zuweisung der Rolle Kurs-Koordinator an',

   'Roles will be active at next login.'
=> 'Rollen werden ab dem nchsten Login aktiv sein.',

   'Create Another Course'
=> 'Einen weiteren Kurs anlegen',

   'from domain'
=> 'aus der Domne',

   'Submit Evaluation'
=> 'Bewertung absenden',

   'Standard Problem'
=> 'Standard-Aufgabe',

   'Practice'
=> 'bung',

   'Exam'
=> 'Prfung',

   'Survey'
=> 'Umfrage',

   'Library'
=> 'Bibliothek', #??? [SB 22.06.2007]

   'Value:'
=> 'Wert:',

   'String Value'
=> 'Text-Wert',

   'Specifically for'
=> 'Im Speziellen fr',

   'practice'
=> 'bung',

   'Loading Domain Coordinator Menu'
=> 'Lade Domnen-Koordinator-Men',

   "Disk space allocated to user's portfolio files"
=> "Speicherplatz fr Portfolio-Dateien des Benutzers",

   'Current quota:'
=> 'Derzeitiger Speicherplatz:', # n.t.

   'For this user, the default quota is'
=> 'Fr diesen Benutzer ist der voreingestellte Speicherplatz', # n.t.

   'Change quota:'
=> 'Speicherplatz ndern:', # n.t.

   'Custom quota:'
=> 'Selbsteingestellter Speicherplatz:', # n.t.

   'Existing sections'
=> 'Bestehende Sektionen',

   'Define new section'
=> 'Neue Sektion festlegen',

   'Create/Modify Another User'
=> 'Weitere Benutzeraccounts erstellen oder ndern', # n.t.

   'Set Privileges for New User'
=> 'Einstellungen fr neuen Benutzer',

   'Generating user:'
=> 'Erstelle Benutzer:',

   'Home server:'
=> 'Heimatserver:',

   'Modifying Roles'
=> 'Passe Benutzerrollen an',

   'starting'
=> 'Start am',

   'Add to classlist:'
=> 'Hinzufgen zur Kursteilnehmerliste:',

   'Change Current Login Data'
=> 'Derzeitige Login-Einstellung ndern',

   'Enter New Login Data'
=> 'Neue Login-Einstellungen',

   ') (will override current values)'
=> ') (berschreibt derzeitgen Wert)',

   'Set a quota for the total disk space available for storage of course group portfolio files.'
=> 'Verfgbarer Gesamtspeicherplatz fr Portfolio-Dateien fr alle Kursgruppen dieses Kurses:',

   'Section Numbers and corresponding LON-CAPA section IDs'
=> 'Sektionsnummern and korrespondierende LON-CAPA-Sektions-IDs',

   'Overall Assessment Statistical Data'
=> 'bergreifende statistische Beurteilungsdaten',

   'No new dynamic data found.'
=> 'Keine dynamischen Daten gefunden.',

   'Selected <b>Resources</b> from <b>selected folder</b> in course'
=> 'Ausgewhlte <b>Ressourcen</b> im </b>ausgewhlten Ordner</b> im Kurs',

   'Current value is'
=> 'Aktuelle Einstellung ist',

   'Interval set to version changes'
=> 'Intervall gesetzt auf Versionsnderungen',

   'Creating a new problem resource.'
=> 'Neue Aufgabe erstellen',

   'Creating a new library resource.'
=> 'Neue Bibliographie-Datei erstellen',

   'Creating a new survey resource.'
=> 'Neue Umfrage-Datei erstellen',

   'The requested file [_1] currently does not exist.'
=> 'Die angeforderte Datei [_1] existiert momentan nicht.',

   'To create a new problem, select a template from thepull-down menu below. Then click on the "Create problem" button.'
=> 'Um eine neue Aufgabe zu erstellen, whlen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Erzeuge Datei vom Typ problem"-Button.',

   'To create a new library, select a template from thepull-down menu below. Then click on the "Create library" button.'
=> 'Um eine neue Bibliographie-Datei zu erstellen, whlen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Erzeuge Datei vom Typ library"-Button.',

   'To create a new survey, select a template from thepull-down menu below. Then click on the "Create survey" button.'
=> 'Um eine neue Umfrage-Datei zu erstellen, whlen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Erzeuge Datei vom Typ survey"-Button.',

'Accessibility Options'
=> 'Alternativ-Login',

   'About LON-CAPA'
=> 'ber LON-CAPA',

   'Course Catalog'
=> 'Kursbersicht',

   'User Authentication'
=> 'Benutzer-Authentifizierung',

   'Log-in Help'
=> 'Login-Hilfe',

   'Forgot password?'
=> 'Passwort vergessen?',

   'Crosslisted'
=> 'querverwiesen',

   'Owner'
=> 'Eigentmer',

   'Code'
=> 'Kurscode',

   'Course listing'
=> 'Kursbersicht',

   'Course Listing'
=> 'Kursbersicht',

   'Display information about official [_1] classes for which LON-CAPA courses have been created:'
=> 'Informationen zu offiziellen Kursen der [_1], fr die LON-CAPA-Kurse eingerichtet wurden',

   'LON-CAPA help/support'
=> 'LON-CAPA Hilfe und Support',

   'Log-in help'
=> 'Login-Hilfe',

   'Ask helpdesk'
=> 'Anfrage an Helpdesk abschicken',

   'Back to last location'
=> 'Zurck zum letzten Ort',

   'Please review the information in "Log-in help" if you are unable to log-in. If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.'
=> 'Bitte schauen Sie zunchst in "Login-Hilfe" nach, wenn Sie sich nicht einloggen knnen. Wenn sich damit die Probleme nicht lsen lassen, dann knnen Sie das Formular auf dieser Seite ausfllen und eine Anfrage an das Helpdesk schicken.', # n.t.

   '<b>Note:</b> Student questions about course content should be directed to the course instructor.'
=> '<b>Beachten Sie:</b> Studentische Fragen zum Kursinhalt richten Sie bitte direkt an den Kurs-Koordinator.', # n.t.

   'Submit Request'
=> 'Anfrage abschicken',

   'E-mail address'
=> 'E-Mail-Adresse',

   'Enter the username you use to log-in to your LON-CAPA system, and choose your domain.'
=> 'Geben Sie Ihren LON-CAPA-Benutzernamen ein und whlen Sie Ihre Domne.',

   'URL of page'
=> 'URL der Seite',

   'Phone'
=> 'Telefon',

   'Course Details'
=> 'Kursdetails',

   'Enter institutional course code'
=> 'Kurs-Instituts-Code',

   'Enter course title'
=> 'Kurstitel',

   'Section Number'
=> 'Sektions-Nummer',

   'Detailed Description'
=> 'Detailierte Beschreibung',

   'Clear Form'
=> 'Formular zurcksetzen',

   'Material presented in clear way'
=> 'Das Material wird in einer verstndlichen Art dargestellt',

   'Material covered with sufficient depth'
=> 'Das Thema wird in ausreichender Tiefe behandelt',

   'Material is helpful'
=> 'Das Material ist hilfreich',

   'Material appears to be correct'
=> 'Das Material scheint korrekt zu sein',

   'This will only retrieve the resource, if you want to retrieve the metadata you will need to do that separately.'
=> 'Die Aktion wird lediglich die Ressource selbst wiederherstellen. Mchten Sie auch eine alte Version der Metadaten zu dieser Ressource wiederherstellen, mssen Sie dies extra tun.',

   'The problem is in this state due to author settings.'
=> 'Die Aufgabe befindet sich aufgrund von Einstellungen des Autors temporr in diesem Zustand.',

   'User Data for'
=> 'Benutzerdaten von',

   'Email Address'
=> 'E-Mail-Adresse',

   'Enroll Student'
=> 'Studenten Kurs belegen lassen',

   'If active, the new role will be available when the student next logs in to LON-CAPA.'
=> 'Falls bereits aktiv, wird die Rolle ab dem nchsten Login fr den Studenten verfgbar sein.',

   'Enroll another student'
=> 'Einen weiteren Studenten einschreiben',

   'start date'
=> 'Start-Datum',

   'end date'
=> 'Ende-Datum',

   'active groups'
=> 'Aktive Gruppen',

   "Select a user name to view the user's personal page."
=> "Klicken Sie auf den Benutzernamen, um die persnliche Informationsseite dieses Benutzers anzuschauen.",

   'View recent activity by this student'
=> 'Zuletzt stattgefundene Aktivitten dieser Person', # n.t.

   'Recent activity of [_1]:[_2]'
=> 'Zuletzt stattgefundene Aktivtten von [_1]:[_2]',

   'Compiling student activity data can take a long time. Your request continues to be processed while results are displayed.'
=> 'Das Zusammenstellen der Aktivittsdaten kann eine Weile dauern. Ihre Anfrage wird weiter verarbeitet, whrend die schon vorhandenen Ergebnisse bereits angezeigt werden.', # n.t.

   'Composing Query'
=> 'Stelle Anfrage zusammen',

   'Student Activity'
=> 'Studentische Aktivitten',

   'Waiting up to [_1] seconds for results'
=> 'Warte noch maximal [_1] Sekunden auf Ergebnisse',

   'Activity data compiled up to [_1]'
=> 'Aktivittsdaten zusammengestellt bis [_1]',

   'While data is processed, periodically reload this page for more recent activity'
=> 'Whrend die Daten verarbeitet werden, knnen Sie gelegentlich die Seite aktualisieren, um aktuellere Aktivittsdaten zu erhalten.',

   'Data'
=> 'Daten',

   'Resubmit last request to check for newer data'
=> 'Letzte Anfrage erneut abschicken, um auf aktuellere Daten zu prfen', # n.t.

   'View Classlist'
=> 'Kursteilnehmerliste anschauen',

   'Count'
=> 'Zhler', # n.t.

   'The optional section field was not specified.'
=> 'Das optionale Sektionsfeld wurde nicht ausgefllt.',

   'Modifying authentication:'
=> 'ndere Authentifizierung:',

   'Home server: [_1]'
=> 'Heimatserver: [_1]',

   'Modify User Privileges'
=> 'Benutzerrechte anpassen',

   'Insert:'
=> 'Einfgen:', # n.t.

   'Randomize Foil Order'
=> 'Reihenfolge der Auswahlmglichkeiten randomisieren', # n.t.

   'Display Direction'
=> 'Anzeige-Richtung:',

   'vertical'
=> 'vertikal',

   'horizontal'
=> 'horizontal',

   'Script'
=> 'Skript-Block', # n.t.

   'Problem Editing Help'
=> 'Hilfe zur Aufgabenerstellung', # n.t.

   'Hint'
=> 'Hinweis', # n.t.

   'Show hint even if problem Correct:'
=> 'Hinweis auch zeigen, wenn Aufgabe richtig beantwortet wurde:', # n.t.

   'Single Line Text Entry Area'
=> 'Zeile mit Texteingabefeld', # n.t.

   'Parameters for a response'
=> 'Parameter fr Antworttyp', # n.t.

   'Problem Part'
=> 'Aufgabenteil', # n.t.

   'Part ID:'
=> 'Aufgabenteil-ID:',

   'Displayed Part Description:'
=> 'Anzuzeigende Aufgabenteil-Beschreibung:',

   'Readonly:'
=> 'Nur lesbar:', # n.t.

   'Response: Numerical'
=> 'Antwortblock: numerisch', # n.t.

   'random'
=> 'zufllig',

   'top'
=> 'am Anfang',

   'bottom'
=> 'am Ende',

   'Add new Option:'
=> 'Option hinzufgen:',

   'Delete an Option:'
=> 'Option lschen:', # n.t.

   'Print options:'
=> 'Ausgabe der Optionen:',

   "Don't show option list"
=> "Optionsliste nicht anzeigen", # n.t.

   'Display of options when printed'
=> 'Anzeigeart der Optionen beim Druck',

   'Normal list'
=> 'Normale Liste',

   'Listed in vertical column'
=> 'In senkrechter Spalte aufgelistet',

   'Multiple Option Response Question'
=> 'Antworttyp: Optionsauswahl', # n.t.

   'Select Options'
=> 'Whlbare Optionen', # n.t.

   'Image'
=> 'Bild', # n.t.

   'Image Url:'
=> 'URL des Bildes:',

   'width (pixel):'
=> 'Breite (Pixel):',

   'height (pixel):'
=> 'Hhe (Pixel):',

   'Alignment:'
=> 'Ausrichtung:', # n.t.

   'Encrypt URL:'
=> 'URL verschlsseln:', # n.t.

   'no'
=> 'nein',

   'Location:'
=> 'Stelle:', # n.t.

   'Randomly labeled image'
=> 'Dynamisch beschriftetes Bild', # n.t.

   'Response: Click on Image'
=> 'Antworttyp: Klick-ins-Bild', # n.t.

   'Collection of Imageresponse foils'
=> 'Sammlung von Bildantwort-Auswahlmglichkeiten', # n.t.

   'Image response foil'
=> 'Bildantwort-Auswahlmglichkeit', # n.t.

   'Enter Coordinates' # n.t.
=> 'Koordinaten festlegen',

   'Rectangle'
=> 'Rechteck', # n.t.

   'Coordinate Pairs'
=> 'Koordinatenpaar',

   'Polygon'
=> 'Polygon',

   'Coordinate list'
=> 'Koordinatenliste', # n.t.

   'Create Polygon Data'
=> 'Polygon-Daten festlegen', # n.t.

   'Task Description'
=> 'Beschreibung der Aufgabe', # n.t.

   'Clickable Image'
=> 'Klickbares Bild', # n.t.

   'Image Source File'
=> 'Pfad und Name der Bilddatei', # n.t.

   'Enter Coordinate or click finish to close Polygon'
=> 'Klicken Sie in das Bild, um die Koordinaten fr das Polygon festzulegen.',

   'Select First Coordinate on Image'
=> 'Klicken Sie an die Stelle der ersten Koordinate.',

   'Select Second Coordinate on Image'
=> 'Klicken Sie an die Stelle der zweiten Koordinate.',

   'Select Finish to save selection.'
=> 'Klicken Sie Beenden zum Beenden oder Abbruch zum Abbrechen.',

   'for access.'
=> ', um Zugriff zu erhalten.', # n.t.

   'New Name'
=> 'Neuer Dateiname',

   'Make Obsolete'
=> 'Als berholt markieren',

   'Set Margins'
=> 'Seitenrnder festlegen',

   'How should each column be formatted?'
=> 'Wie soll jede Spalte formatiert werden?', # n.t.

   'Width:'
=> 'Breite:', # n.t.

   'Height:'
=> 'Hhe:', # n.t.

   'Left Margin:'
=> 'Linker Rand:', # n.t.

   'Username and/or password could not be authenticated.'
=> 'Benutzername und/oder Passwort konnten nicht erfolgreich authentifiziert werden.', # n.t.

   'Please'
=> 'Bitte',

   'Information needed to verify your login information is missing, inaccessible or expired.'
=> 'Die Daten, um Ihr Login zu berprfen, fehlen, knnen nicht gelesen werden oder sind abgelaufen.',

   'Sending'
=> 'Sende',

   'Completed.'
=> 'Ausgefhrt.',

   'Messages being sent.'
=> 'Nachrichten wurden gesendet',

   'showing messages'
=> 'zeige Nachrichten',

   'Assigning'
=> 'Zuweisung der Rolle',

   'ending'
=> 'Ende am',

   'Assistant Co-Author'
=> 'Co-Autor-Assistent',

   'Catalog Information for'
=> 'Katalogisierungs-Informationen fr',

   'Try [_1]'
=> 'Versuch [_1]', # n.t.

   'There are [_1] matches to your query.'
=> 'Ihre Suche hat [_1] Treffer ergeben.', # n.t.

   'Revise search'
=> 'Suche ndern',

   'in LON-CAPA domain'
=> 'in LON-CAPA-Domne', # n.t.

   'Sort by'
=> 'Sortieren nach', # n.t.

   'Number of accesses'
=> 'Anzahl der Zugriffe',

   'Ascending'
=> 'aufsteigend',

   'Descending'
=> 'absteigend',

   'Students Attempting'
=> 'Studentische Versuche', # ??? [SB 2007-07-03]

   'Average Number of Tries'
=> 'Durchschnittliche Anzahl an Versuchen',

   'Mean Degree of Difficulty'
=> 'Durchschnittlicher Schwierigkeitsgrad',

   'Mean Degree of Discrimination'
=> 'Durchschnittlicher Grad der Abgrenzung',

   'Evaluation: Clear'
=> 'Bewertung: Klar',

   'Evaluation: Technically Correct'
=> 'Bewertung: Technisch korrekt',

   'Evaluation: Material is Correct'
=> 'Bewertung: Material ist korrekt',

   'Evaluation: Material is Helpful'
=> 'Bewertung: Material ist hilfreich',

   'Evaluation: Material has Depth'
=> 'Bewertung: Tiefe des Themas',

   'Prev'
=> 'Zurck',

   'Reload'
=> 'Aktualisieren',

   'Results [_1] to [_2] out of [_3]'
=> 'Treffer [_1] bis [_2] von insgesamt [_3]',

   'Unactionable Search Queary'
=> 'Suchanfrage zurckgewiesen',

   'You did not fill in enough information for the search to be started. You need to fill in relevant fields on the search page in order for a query to be processed.'
=> 'Sie haben nicht gengend Informationen eingetragen, damit die Suche gestartet werden kann. Fllen Sie relevante Felder aus, damit die Suche ausgefhrt werden kann.', # n.t.

   'Revise Search Request'
=> 'Suchanfrage ndern',

   'LON-CAPA Access Control'
=> 'LON-CAPA-Zugriffskontrolle', # n.t.

   'Access  :'
=> 'Zugriff  :', # n.t.

   'Resource:'
=> 'Ressource:', # n.t.

   'Action  :'
=> 'Aktion   :', # n.t.

   'Published on ...'
=> 'Verffentlicht am...',

   'Currently published version'
=> 'Derzeit verffentlichte Version',

   'Edit Metadata'
=> 'Metadaten ndern', # n.t.

   'Cleanup XML Document'
=> 'XML-Code aufrumen',

   'Select actions to attempt:'
=> 'Auswahl der gewnschten Aktionen:',

   'Linefeeds, formfeeds, and carriage returns'
=> 'Zeilenumbrche (LF), Seitenvorschbe und "Wagenrcklufe" (CR)',

   'Empty tags'
=> 'Leere Tags',

   'Lower casing'
=> 'Kleinschreibung',

   'Symbol font'
=> 'Symbolischer Zeichensatz', # ??? [SB 2007-07-03]

   'Cleanup'
=> 'Aufrumen',

   'Back to Source File'
=> 'Zurck zur Quelldatei',

   'Hypertext Cascading Style Sheet'
=> 'Stylesheet-Datei',

   'Online Survey'
=> 'Umfrage',

   ' Unable to find'
=> 'Kann folgende Datei nicht finden:', # n.t.

   'Check machines:'
=> 'Server auswhlen:', # n.t.

   'Post Server Announcements'
=> 'Server-Bekanntmachungen', # n.t.

   'Post announcements to the system login and roles screen'
=> 'Server-Bekanntmachungen fr die Login-Seite und die Rollenauswahl', # n.t.

   '(leave blank to delete announcement)'
=> '(leer lassen, um Bekanntmachung zu entfernen)',

   'Posting [_1]'
=> 'Sende an [_1]',

   'This is LON-CAPA [_1]'
=> 'Auf diesem Server luft LON-CAPA [_1]', # n.t.

   'Attachment (128 KB max size)'
=> 'Anhang (maximal 128 KB)',

   'Edit Answer'
=> 'Antwort editieren',

   'Date/Time'
=> 'Datum, Uhrzeit',

   'Threshold Name'
=> 'Schwellenwert-Name',

   'Current value'
=> 'Aktueller Wert',

   'Change?'
=> 'ndern',

   'Make changes'
=> 'Speichern', # n.t.

   'Change thresholds'
=> 'Schwellenwerte ndern',

   'Picture Conversion Status'
=> 'Bildkonvertierungs-Status',

   'Class Print Status'
=> 'Class Print Status', #??? [SB 2007-07-04]

   'Removing error messages:'
=> 'Entferne Fehlermeldungen:',

   'Initial version'
=> 'Urversion',

   'Press "Generate Statistics" when you are ready.'
=> 'Klicken Sie auf "Erzeuge Statistiken", wenn Sie die gewnschten Einstellungen vorgenommen haben.',

   'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.'
=> 'Es kann einige Zeit dauern, um die studentischen Daten fr die erste Analyse zu aktualisieren. Zuknftige Analysen werden nicht diese Verzgerung verursachen.', # n.t.

   'Show problem'
=> 'Aufgabe anzeigen', # n.t.

   'Analyze Over'
=> 'Analyse ber', # n.t.

   'Number of Plots'
=> 'Anzahl Plots', #???

   'none'
=> 'keine', # n.t.

   'Output as'
=> 'Ausgabetyp', # n.t.

   'Prepare Report'
=> 'Bericht erstellen',

   'Show correct answers'
=> 'Korrekte Antworten anzeigen', # n.t.

   'Show all submissions'
=> 'Alle Einreichungen anzeigen', # n.t.

   'Show problem grading'
=> 'Aufgabenbewertung anzeigen', # n.t.

   'Computing correct answers greatly increasese the amount of time required to prepare a report.'
=> '',

   'please select problems and use the <b>Prepare Report</b> button to continue.'
=> 'Whlen Sie die zu bercksichtigenden Aufgaben aus und klicken Sie anschlieend auf den <b>Bericht erstellen</b>-Button.',

   'Please select a Survey to analyze'
=> 'Whlen Sie eine Umfrage, die analysiert werden soll:',

   'There are no survey problems in this course'
=> 'Es existieren keine Umfragen in diesem Kurs.',

   'Generate Survey Report'
=> 'Umfragebericht generieren',

   'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin'
=> 'Whlen Sie eine Sequenz aus der "Sequenzen und Verzeichnisse"-Liste und klicken Sie auf "Diagramm erzeugen", um zu starten.',

   'Create Plot'
=> 'Diagramm erzeugen',

   'Start Time:'
=> 'Startzeit:',

   'End Time:'
=> 'Endezeit:',

   'Sender'
=> 'Absender',

   'Number'
=> 'Nummer',

   'Upload Classlist'
=> 'Kursteilnehmerliste hochladen',

   'Semicolon separated values'
=> 'Durch Semikolons getrennt',

   'with home server'
=> 'mit Heimatserver', # n.t.

   'Show Log'
=> 'Vernderungs-Protokoll',

   'Course Document Change Log'
=> 'Kursressourcen-Vernderungs-Protokoll',

   'Records'
=> 'Datenstze',

   'Before'
=> 'Vorher',

   'After'
=> 'Nachher',

   'Current folder/page'
=> 'Aktuelles Verzeichnis/Seite',

   'Containing phrase'
=> 'Enthlt Text:',

   'None'
=> 'nichts',

   'Users'
=> 'Benutzer',

   'Include parameter types'
=> 'Parametertypen zeigen',

   'Parameter Change Log'
=> 'Parameternderungs-Protokoll',

   'Announce'
=> 'Bekanntmachen',

   'Not active anymore'
=> 'nicht mehr aktiv',

   'Add to Course Announcements'
=> 'Den Kursbekanntmachungen hinzufgen',

   'Username : Domain'
=> 'Benutzername:Domne',

   'Active'
=> 'aktiv',

   'Sort by realm first, then student (group/section)'
=> 'Sortierung nach Bereich, dann nach Student (Gruppe/Sektion)',

   'Sort by student (group/section) first, then realm'
=> 'Sortierung nach Student (Gruppe/Sektion), dann nach Bereich',

   'Overview Mode'
=> 'bersichtsmodus',

   'Overview'
=> 'bersicht',

   'Set Parameters'
=> 'Parameter einstellen',

   'Parts'
=> 'Aufgabenteile',

   'Section(s)'
=> 'Sektion(en)',

   'Group(s)'
=> 'Gruppe(n)',

   'Select Common Only'
=> 'bliche whlen',

   'Add Problem Dates'
=> 'Auswahl: Aufgabendatumsfelder',

   'Add Content Dates'
=> 'Auswahl: Inhaltsdatumsfelder',

   'Add Discussion Settings'
=> 'Auswahl: Diskussions-Einstellungen',

   'Add Visibilities'
=> 'Auswahl: Sichtbarkeit',

   'Add Part Parameters'
=> 'Auswahl: Aufgabenteil-Parameter',

   'Group Files'
=> 'Gruppen-Dateien',

   "Enter user:domain for User's 'About Me' Page"
=> "Geben Sie Benutzername:Domne fr die ber-Mich-Seite des gewnschten Benutzers ein:",

   'No map selected.'
=> 'Keine Inhaltszusammenstellung gewhlt!',

   'Most Recent:'
=> 'Aktuellste:', # n.t.

   'In Course:'
=> 'Im Kurs:', # n.t.

   'Use:'
=> 'Verwende:', # n.t.

   'Search LON-CAPA help:'
=> 'Suche in der LON-CAPA-Hilfe (derzeit nur auf Englisch):', # n.t.

   'Before course enrollment start!'
=> 'Liegt VOR Kurseinschreibungs-Start!',

   'After course enrollment end!'
=> 'Liegt NACH Kurseinschreibungs-Ende!',

   'Choose'
=> 'bernehmen',

   'Title:'
=> 'Titel:',

   'URL:'
=> 'URL:',

   'Course, Portfolio and Catalog Search'
=> 'Katalog-Suche, Portfolio-Suche und Suche im Kurs',

   'ERROR:'
=> 'FEHLER:',

   'occured while running'
=> 'trat auf whrend der Ausfhrung von',

   '(click for example)'
=> '(Klicken fr Beispiel)',

   'Re-Enable'
=> 'wieder aktivieren',

   'Script Functions'
=> 'Funktionen in Skripten', # n.t.

   'Image Options'
=> 'Bildoptionen', # n.t.

   'middle'
=> 'mittig',

   'left'
=> 'links',

   'right'
=> 'rechts',

   'TeXwidth (mm):'
=> 'TeX-Breite (mm):',

   'TeXheight (mm):'
=> 'TeX-Hhe (mm):',

   'TeXwrap:'
=> 'TeX-Umbruch', # n.t., ??? [SB 2007-07-11]

   'Sorry!'
=> 'Schade...', # n.t.

   'Resource not available.'
=> 'Ressource nicht erreichbar.', # n.t.

   'Choose file type:'
=> 'Dateityp:',

   'Output of decompress:'
=> 'Ausgabe der Dekomprimierung:',

   'Decompress complete.'
=> 'Dekomprimierung abgeschlossen.',

   'Archive:'
=> 'Archiv:',

   'inflating:'
=> 'entpacke:',

   'Incorrect:'
=> 'Inkorrekt:',

   'Correct:'
=> 'Korrekt:',

   '<b>Correct</b>' # ?
=> '<b>Korrekt</b>',

   'Click to select a Coordinate or click Finish to save current selection.'
=> 'Klicken Sie in das Bild, um Koordinaten festzulegen.',

   '&lt;--Pick course first'
=> '&lt;--Erst Kurs auswhlen',

   'User Information Changed'
=> 'Genderte Benutzerdaten',

   'Changed To'
=> 'Gendert in',

   'disk space allocated to portfolio files'
=> 'Speicherplatz fr Portfolio-Dateien',

   ''
=> '',



#SYNCMARKER
);
1;
