# The LearningOnline Network with CAPA
# Russian Localization Lexicon
#
# $Id: ru.pm,v 1.47 2007/05/21 22:21:50 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::ru;
use base qw(Apache::localize);
%Lexicon=('_AUTO' => 1,
'char_encoding'=> 'KOI8-R',
'language_code'=> 'ru',
'date_locale'  => 
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds',
'date_months'  => ',,,,,,,,,,,',
'date_days'    => ',,,,,,',
'date_am' => 'am',
'date_pm' => 'pm',
'textual_remote_display' => 'on',
'htmlarea_lang' => 'ru',

   'calendar'
=> '',

   'January'
=> '',

   'February'
=> '',


#SYNC Fri Nov 14 14:31:31 2003
   "Calculate answers"
=> " ",

   '# Do not translate this line.  [_1] is a check box'
=> '# Do not translate this line.  [_1] is a check box',

   '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field'
=> '# Do not translate this line.  [_1] is a check box, [_2] is a text entry field',

   '# Do not translate this line.  [_1] is a column index.'
=> '# Do not translate this line.  [_1] is a column index.',

   '# Do not translate this line.  [_1] is a drop-down box listing domains.'
=> '# Do not translate this line.  [_1] is a drop-down box listing domains.',

   '# Do not translate this line.  [_1] is a username'
=> '# Do not translate this line.  [_1] is a username',

   '# Do not translate this line.  [_1] is the number of students processed'
=> '# Do not translate this line.  [_1] is the number of students processed',

   '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.'
=> '# Do not translate this line.  [_1] is username, [_2] - [_5] are first, middle, and last names, and generation.',

   '# Do not translate this line.  [_1] is username, [_2] is error message'
=> '# Do not translate this line.  [_1] is username, [_2] is error message',

   '# Do not translate this line.  [_1] is username@domain'
=> '# Do not translate this line.  [_1] is username@domain',

   '# Do not translate this line.  [_1] is username@domain [_2] is the error message.'
=> '# Do not translate this line.  [_1] is username@domain [_2] is the error message.',

   '# Do not translate this line.  [_1], [_3], and [_4] are check boxes'
=> '# Do not translate this line.  [_1], [_3], and [_4] are check boxes',

   '# Do not translate this line.  [_2] is a text entry element'
=> '# Do not translate this line.  [_2] is a text entry element',

   '#Stdnts'
=> '#',

   '#YES'
=> '#YES',

   '%Wrng'
=> '%Wrng',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;Show&nbsp;All&nbsp;Foils',

   '"[_1]" for default hiding'
=> '"[_1]"   -',

   '"[_1]" if allowed, anything else if not'
=> '"[_1]"  ,   - ',

   '"[_1]" to disable, anything else if not'
=> ' ,   - ',

   ', and answers will be available on'
=> ',    ',

   ', is reserved internally by LON-CAPA.'
=> ',   LON-CAPA-.',

   ', or the next time you log in.'
=> ',        .',

   ', select a template from the pull-down menu below'
=> ',     ',

   '. . . for a particular section'
=> '. . .   ',

   '. . . for all students in the course'
=> '. . .    ',

   '. . . for an individual student'
=> '. . .   ',

   '1 am'
=> '1',

   '1 out of N multiple choice (radio button)'
=> '1  N   ( )',

   '1 pm'
=> '13',

   '10 am'
=> '10',

   '10 pm'
=> '22',

   '11 am'
=> '11',

   '11 pm'
=> '23',

   '12 am'
=> '12',

   '12 noon'
=> '24',

   '2 am'
=> '2',

   '2 pm'
=> '14',

   '3 am'
=> '3',

   '3 pm'
=> '15',

   '4 am'
=> '4',

   '4 pm'
=> '16',

   '5 am'
=> '5',

   '5 pm'
=> '17',

   '6 am'
=> '6',

   '6 pm'
=> '18',

   '7 am'
=> '7',

   '7 pm'
=> '19',

   '8 am'
=> '8',

   '8 pm'
=> '20',

   '9 am'
=> '9',

   '9 pm'
=> '21',

   '<- Previous'
=> '<- ',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:   : [_2]',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>:  .    .',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>:      [_2] [_3] [_4] [_5]',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML </b>:      HTML    .',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML </b>: HTML     .',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b></b> -      ',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b></b> -        .',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b></b> -      ',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b></b> -        .',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b> </b> -       ',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b> </b> -         .',

   'Hand Graded (handgrade)'
=> '  (handgrade)',

   'Home Server'
=> ' ',

   'How many tries should be set for all problems in the course?'
=> '       ? <br /><br />',

   'How many tries should be set for the selected folder?'
=> '     ?<br /><br />',

   'How many tries should be set for the selected problem?'
=> '     ?<br /><br />',

   'How should the results be printed?'
=> '<br /><big><i><b> ?</b></i></big><br />',

   'helper'
=> '',

   'A score has been assigned.'
=> ' .',

   'ABSTRACT'
=> '',

   'ALL'
=> '',

   'About Me'
=> ' ',

   'Abstract'
=> '',

   'Access Control'
=> ' ',

   'Access Key Management'
=> '  ',

   'Access and Usage Statistics'
=> '   ',

   'Actions'
=> '',

   'Activate'
=> '',

   'Add Roles'
=> ' ',

   'Add new option'
=> '  ',

   'Add one empty page/column after each student\'s assignment'
=> '  /    ',

   'Add two empty pages/column after each student\'s assignment'
=> '   /    ',

   'Add three empty pages/column after each student\'s assignment'
=> '   /    ',

   'Additional Keywords'
=> '  ',

   'Additional Metadata (non-standard, parameters, exports)'
=> '  ( , , )',

   'Additional Recipients'
=> ' ',

   'Additional settings, if specified below, will override cloned settings'
=> ' ,   ,   ',

   'Administrator'
=> '',

   'Advanced Catalog Search'
=> '   ',

   'Advanced Edit'
=> ' ',

   'Advanced Search'
=> ' ',

   'All Documents in Course'
=> '   ',

   'All Maps or Folders'
=> '   ',

   'All Resources'
=> ' ',

   'All Resources (possibly large output)'
=> '  (  )',

   'All Students'
=> ' ',

   'All homework is currently completed'
=> '      ',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click Next -&gt;.'
=> '<p> /,        ,       PARM      &quot;  &quot;.</p> <p>       LON-CAPA      ,  <nobr><b> -&gt;</b></nobr>.</p>',

   '<p>Your current LON-CAPA domain is &quot;<b>[_1]</b>&quot;.</p>'
=> '<p>  LON-CAPA  - &quot;<b>[_1]</b>&quot;.</p>',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> '<p><b> </b>:           :</p> 
      <ul><li>   .</li>
          <li>        ,      (  ;)       <b>:</b>.</li></ul>
      <p>,</p>
      <p><b>john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009)</b></p>
      <p>   &quot;john102&quot;   1, 2,  3, 
         &quot;bob293&quot;  4, 5,  6,   &quot;madeupname:here&quot; 
         7, 8,  9. ,           .</p>',

   'All versions'
=> ' ',

   'Allow limited HTML in discussion posts'
=> '   HTML  ',

   'Allow problems to be split over pages'
=> '       ',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> '       (uploadedfiletypes)',

   'An error occurred during the attempt to change the role information for this student.'
=> '        .',

   'An error occured during the attempt to change the section for this student.'
=> '        .',

   'An error occured while grading your answer.'
=> '    .',

   'Analyze Over '
=> '  ',

   'Analyze Problem'
=> ' ',

   'Analyze Problem Again'
=> '  ',

   'Analyze Progress'
=> ' ',

   'Analyze as '
=> '  ',

   'Analyzing a problem'
=> ' ',

   'Announcements and Calendar'
=> '  ',

# Announcements and 
   'Anonymous'
=> '',

   'Anonymous contribution to course discussion of resource'
=> '     ',

   'Answer'
=> '',

   'Answer Date (answerdate)'
=> '   (answerdate)',

   'Answer Submitted'
=> ' ',

   'Answer available'
=> ' ',

   'Answer submitted'
=> ' ',

   'Answer submitted, not yet graded'
=> ' ,   ',

   'Answer:'
=> ':',

   'Any Language'
=> ' ',

   'Any User'
=> ' ',

   'Any category'
=> ' ',

   'Any copyright/distribution'
=> '  /',

   'April'
=> '',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> ' ,       filesystem authenticated (     ).',

   'Assessment'
=> '',

   'Assessment Parameters'
=> ' ',

   'Assessment URL and Title'
=> 'URL   ',

   'Assigned User Roles'
=> '  ',

   'Associate columns with student attributes.'
=> '    .',

   'Attachment'
=> '',

   'Attribute'
=> '',

   'August'
=> '',

   'Author'
=> '',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> '             .',

   'Author(s)'
=> '()',

   'Automated adds'
=> ' ',

   'Automated drops'
=> ' ',

   'Automated Enrollment Manager'
=> '  ',

   'Automated enrollment settings'
=> '  ',

   'Average number of tries till solved'
=> '    ',

   'Back to'
=> ' ',

   'Back to Directory'
=> '  ',

   'Back to Source'
=> '  ',

   'Back to Source Directory'
=> '   ',

   'Became this version on ...'
=> '    ...',

   'Bad Filename'
=> '  ',

   'Binary File'
=> ' ',

   'Blank'
=> '',

   'Brief view of each students performance in course.'
=> '      .',

   'Broadcast Message to Course'
=> '  ',

   'Browse'
=> '',

   'Browse Resources'
=> ' ',

   'Browse published resources'
=> '  ',

   'Browse resources'
=> ' ',

   'Browsing resource, all submissions are temporary.'
=> ' ,  submissions .',

   'Bulletin Board'
=> ' ',

   'Bulletin Board/Discussion'
=> ' /',

   'By'
=> 'By',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (,  , )',

   'CSV format'
=> 'CSV ',

   'Calculate answers'
=> ' ',

   'Calculate course grades (Spreadsheet)'
=> '    ()',

   'Calculations'
=> '',

   'Cancel'
=> '',

   'Catalog Information'
=> '  ',

   'Change'
=> '',

   'Change Random Seed To:'
=> '   :',

   'Change Your Language Preferences'
=> '   ',

   'Change Your Preferences'
=> '  ',

   'Change User Privileges'
=> '  ',

   'Changes can take up to 10 minutes before being active for all students.'
=> '       10 .',

   'Changes will become active for your current session after'
=> '       ',

   'Chat Participation'
=> '     ',

   'Check All'
=> ' ',

   'Check Course Document Versions'
=> '   ',

   'Check for All'
=> '  ',

   'Check for None'
=> '   ',

   'Check for Section/Group'
=> '  /',

   'Check/Set Resource Versions'
=> '/  ',

   'Choose a different resource'
=> '  ',

   'Choose the course to work on'
=> '   ',

   'Choose the user role'
=> '  ',

   'Chronological View'
=> ' ',

   'Class Hours'
=> ' (Class Hours)',

   'Clear All'
=> ' ',

   'Clear Caches'
=> ' ',

   "Click to download or use your browser's Save Link function"
=> "     Save Link  ",

   'Clone an existing course'
=> '   ',

   'Close'
=> '',

   'Close All Folders'
=> '  ',

   'Close This Window'
=> '  ',

   'Co-Author'
=> '',

   'Collapse Remote Control'
=> '   ',

   'Column'
=> '',

   'Column&nbsp;[_1]'
=> '&nbsp;[_1]',

   'Comma Separated Values'
=> ',  ',

   'Communication'
=> '',

   'Communication and Messages'
=> '  ',

   'Compact View'
=> 'Compact View',

   'Compare versions of'
=> ' ',

   'Completed'
=> '',

   'Completely new course'
=> '  ',

   'Concept:'
=> ':',

   'Concepts'
=> '',

   'Confirm that this information is correct, then click &quot;Finish Helper&quot; to complete setting the parameter.'
=> ',    ,   &quot; &quot;     .', 

   'Construction Space'
=> ' ',

   'Construction Space Directory'
=> '  ',

   'Construction Space File Operation'
=> '     ',

   'Construction Space Version'
=> '   ',

   'Contact'
=> '',

   'Contact Information'
=> ' ',

   'Content changed'
=> ' ',

   'Continue'
=> '',

   'Continue enrollment?'
=> ' ?',

   'Contribution to course discussion of resource'
=> '    ',

   'Copied metadata'
=> ' ',

   'Copied old metadata'
=> '  ',

   'Copied old target file'
=> '   ',

   'Copied source file'
=> '- ',

   'Copy selected'
=> ' ',
 
   'Copying file'
=> ' ',

   'Copy current file to'
=> '   ',

   'Copyright'
=> ' ',

   'Copyright/Distribution'
=> ' /',

   'Correct Option:'
=> ' :',

   'Could Not Process Request'
=> '    ',

   'Could not write metadata'
=> '    ',

   'Course'
=> '',

   'Course Assessment Parameter - Helper Mode'
=> '    -  ',

   'Course Assessment Parameters - Overview Mode'
=> '    -  ',

   'Course Assessments Parameters - Table Mode'
=> '    -  ',

   'Course Code'
=> ' ',

   'Course Content'
=> ' ',

   'Course Coordinator'
=> " ",

   'Course Data'
=> ' ',

   'Course Description'
=> ' ',

   'Course Documents'
=> ' ',

   'Course default for all problems'
=> '    -',

   'Course Environment Parameters'
=> '  ',

   'Course Home Server'
=> '  ',

   'Course ID'
=> 'ID ',

   'Course ID/Number'
=> 'ID/ ',

   'Course ID or number'
=> 'ID   ',

   'Course Information'
=> '  ',

   'Course Initialization Helper'
=> '   ',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an email address.'
=> '<p>        .         -    .    LON-CAPA     <b>:</b>,  &quot;&quot;  &quot;&quot;  LON-CAPA    LON-CAPA ,     .</p>',

   'Course Title'
=> ' ',

   'Course Level'
=> ' ',

   'Course Parameter Helper'
=> '    ',

   'Course Statistics and Charts'
=> '   ',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> '           .            .',

   'Course announcements and my calendar'
=> '   ',

# Course announcements and my 

   'Course level sheet'
=> ' ',

   'Coursepack'
=> '  (Coursepack)',

   'Create'
=> '',

   'Create New Environment Variable'
=> '    ',

   'Create New User'
=> '  ',

   'Create Users, Change User Privileges'
=> ' ,   ',

   'Create a New Course'
=> '  ',

   'Create a new course'
=> '  ',

   'Create a user or modify the roles and privileges of a user'
=> '      ',

   'Creation Date'
=> ' ',

   'Critical Messages'
=> ' ',

   'Crosslisted courses'
=> 'Crosslisted ',

   'Current'
=> '',

   'Current Class List'
=> '  ',

   'Current Month'
=> ' ',

   'Current Session Value'
=> '   ',

   'Current Version'
=> ' ',

   'Currently not available'
=> '   ',

   'Currently selected. '
=> '   . ',

   'Custom Distribution File'
=> '  ',

   'Custom Role Editor'
=> ' ',

   'Customized right of use ...	'
=> '   ...	',

   'Cut selected'
=> ' ',

   'Date'
=> '',

   'Deadlines'
=> '  (Deadlines)',

   'December'
=> '',

   'Decompress'
=> '',

   'Default'
=> ' ',

   'Default beginning date when enrolling students'
=> '    -',

   'Default Cataloging Information for Directory'
=> '   ( )  ',

   'Default ending date when enrolling students'
=> '    -',

   'Default set of options to pass to tth/m when converting tex'
=> '    tth/m   tex',

   'Default Value'
=> '  ',

   'Define Role'
=> ' ',

   'Degree of difficulty'
=> ' ',

   'Delete'
=> '',

   'Delete Checked'
=> ' ',

   'Delete a role'
=> ' ',

   'Delete an option'
=> ' ',

   'Delete messages from bulletin boards'
=> '    ',

   'Delete:'
=> ':',

   'Detailed Citation View'
=> '  ',

   'Detailed Problem Analysis'
=> '  ',

   'Detailed statistics and graphs of student performance on problems.'
=> '     .',

   'Differences'
=> '',

   'Diffs'
=> '',

   'Diffs with Current Version'
=> '   ',

   'Diffs with Version'
=> '  ',

   'Diffs with current Version'
=> '   ',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> '  ID/      ID (        )',

   'Disable all communication among students'
=> '    ',

   'Disable display of problem receipts'
=> '    ',

   'Disable student resource discussion'
=> '   ',

   'Disable student use of chatrooms'
=> '   chatrooms',

   'Disallow live chatroom use for Roles'
=> '    ',

   'Disallow live chatroom use for Users'
=> '    ',

   'Disallow Resource Discussion for Roles'
=> '    ',

   'Disallow Resource Discussion for Users'
=> '    ',

   'Discard Edits and View'
=> '   ',

   'Discard Selected'
=> '  ',

   'Discussion Contributions'
=> '  ',

   'Discussion Participation'
=> '  ',

   'Discussions'
=> '',

   'Display'
=> '',

   'Display All Messages'
=> '  ',

   'Display all Messages'
=> '  ',

   'Display and analysis of submission times on assessments.'
=> 'Display and analysis of submission times on assessments.',

   'Display foils in order given'
=> ' foils   ',

   'Display foils in random order'
=> ' foils   ',

   'Distribute Messages from Uploaded File to Course'
=> '    ',

   'Do NOT generate as standard course'
=> '    ',

   'Do not show plain URL (encrypturl)'
=> '  URL (encrypturl)',

   'DoDiff'
=> ' ',

   'Domain'
=> '',

   'Domain Coordinator'
=> ' ',

   'Domain Guest'
=> ' ',

   'Domain only - use limited to courses in the domain'
=> '      ',

   'Domain Level'
=> ' ',

   'Done'
=> '',

   'Drop Students'
=> ' ',

   'Drop/Add students in this course'
=> '/    ',

   'Dropped [_1]'
=> ' [_1]',

   'Dropped [_1] student(s).'
=> ' [_1] ().',

   'Dropping Students'
=> ' ',

   'Due'
=> '',

   'Due Date (contentclose)'
=> '   (contentclose)',

   'Due Date (duedate)'
=> '  (duedate)',

   'Dump Course DOCS'
=> 'Dump Course DOCS',

   'Dump Course DOCS to Construction Space'
=> '   DOCS   ',

   'Duration of automated classlist updates'
=> '    ',

   'Dynamic Metadata'
=> ' ',

   'EMail Address'
=> 'EMail ',

   'EMail and Messages'
=> 'EMail  ',

   'Edit'
=> '',

   'Edit Catalog Information'
=> '   ',

   'Edit Content of a Map'
=> '  ',

   'Edit Custom Role Privileges'
=> '  ',

   'Edit Directory Catalog Information'
=> '     ',

   'Edit and view documents included in this course'
=> '      ',

   'Edit this resource'
=> '  ',

   'Edit/Modify DOCS'
=> '/ DOCS',

   'EditXML'
=> ' XML',

   'Empty'
=> '()',

   'Enclosing Map or Folder'
=> '   ',

   'End'
=> '',

   'End Helper'
=> ' r',

   'End Time',
=> ' ',

   'Ending Date'
=> ' ',

   'Enroll a single student'
=> '  ',

   'Enroll as student'
=> '  ',

   'Enrolling'
=> '',

   'Enroll One Student'
=> '  ',

   'Enrolling Student'
=> ' ',

   'Enrolling Students'
=> ' ',

   'Enrollment Manager'
=> '/',

   'Enrollment Status'
=> ' ',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> '      .                   .',

   'Enter construction space as a co-author'
=> '      ',

   'Enter grades from check-out assessment resources'
=> '   check-out assessment resources',

   'Enter my resource construction space'
=> '    ',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> '     AND, OR,  NOT,   SEARCH',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> '      AND, OR,  NOT',

   'Enter the chatroom for the course'
=> 'Enter the chatroom for the course',

   'Entering course ...'
=> '   ...',

   'ERROR'
=> '',

   'Error'
=> '',

   'Error: Directory Non Empty'
=> ':   ',

   'Error: destination for operation is an existing directory.'
=> ':    -  .',

   'Error Messages'
=> '  ',

   'Error dropping [_1]:[_2]'
=> '  [_1]:[_2]',

   'Essay, open end'
=> 'Essay, open end',

   'Evaluate Resource'
=> ' ',

   'Evaluation Comments'
=> ' ',

   'Evaluation Data'
=> ' ',

   'Every problem in a particular folder (overrides course default)'
=> '     (    -)',

   'Every problem in the course'
=> '   ',

   'Exam Information'
=> '  ',

   'Exam Proctor'
=> 'Exam Proctor',

   'Excel'
=> 'Excel',

   'Excel format'
=> 'Excel ',

   'Excused by instructor'
=> ' ',

   'Exit LON-CAPA'
=> ' LON-CAPA',

   'Extent'
=> '',

   'External Resource'
=> ' ',

   'FAIL'
=> '',

   'Failed Access to Construction Space'
=> '    e',

   'Failed to copy source'
=> '  ',

   'Failed to write metadata copy'
=> 'Failed to write metadata copy',

   'False'
=> '',

   'Feedback Addresses for Course Content'
=> '      ',

   'Feedback Addresses for Course Policy'
=> '      ',

   'Feedback Addresses for Resource Content Question'
=> '      ',

   'Feedback Addresses for Course Content Comments'
=> '        ',

   'Field'
=> '',

   'Fielded Format'
=> 'Fielded ',

   'File'
=> '',

   'File Category'
=> ' ',

   'File copied.'
=> ' .',

   'Filenames in Construction Space'
=> '    ',

   'Finalize Publication'
=> ' ',

   'Finish Course Initialization'
=> '  ',

   'Finish Helper'
=> ' ',

   'First'
=> '',

   'First Name'
=> '',

   'First Resource'
=> ' ',

   'Foil'
=> 'Foil',

   'Foils'
=> 'Foils',

   'Folder'
=> '',

   'Folder in Construction Space'
=> '   ',

   'For User'
=> ' ',

   'Force publication of unmodified files'
=> '   ',

   'Format:'
=> ':',

   'Forward'
=> '',

   'Forwarded message from'
=> '  ',

   'Forwarding'
=> '',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> '   ,      ,    .',

   'Frequency'
=> '',

   'Fri'
=> '',

   'From'
=> '',

   'Full Update'
=> ' ',

   'Full update (also print list of users not enrolled anymore)'
=> '  (     )',

   'Functions'
=> '',

   'Generate Spreadsheet'
=> ' ',

   'Generate Statistics'
=> ' ',

   'Generate new role ...'
=> '   ...',

   'Generation'
=> '',

   'Getting Problem Variants'
=> '  ',

   'Go Back'
=> '',

   'Go To My First Homework Problem'
=> '    ',

   'Go to the next resource in the course sequence'
=> '      ',

   'Go to the previous resource in the course sequence'
=> '      ',

   'Goodbye'
=> ' ',

   'Grades Spreadsheet'
=> ' ',

   'Grading'
=> ' ',

   'Grading Information'
=> '  ',

   'Grant/revoke Course Custom Role'
=> '/    ',

   'Grant/revoke role of Administrator'
=> '/  ',

   'Grant/revoke role of Author'
=> '/  ',

   'Grant/revoke role of Co-Author'
=> '/  ',

   'Grant/revoke role of Course Coordinator'
=> '/   ',

   'Grant/revoke role of Domain Coordinator'
=> '/   ',

   'Grant/revoke role of Domain Guest'
=> '/   ',

   'Grant/revoke role of Exam Proctor'
=> '/   ',

   'Grant/revoke role of Instructor'
=> '/  ',

   'Grant/revoke role of Librarian'
=> '/  ',

   'Grant/revoke role of Scantron Operator'
=> 'Grant/revoke role of Scantron Operator',

   'Grant/revoke role of Student'
=> '/  ',

   'Grant/revoke role of Superuser'
=> '/  ',

   'Grant/revoke role of Teaching Assistant'
=> '/   ',

   'Group/Section'
=> '/',

   'HTML'
=> 'HTML',

   'HTML/XML'
=> 'HTML/XML',

   'HTML can be allowed or banned inside of course discussion.'
=> '<p>HTML        .</p>',

   'HTML in Discussions'
=> 'HTML  ',

   'Height(pixel):'
=> '(pixel):',

   'Help'
=> '',

   'Help on Creating Courses'
=> '   ',

   'Helproom Hours'
=> '  Helproom',

   'Hide'
=> '',

   'Hide Empty Rows in Spreadsheets'
=> '     ',

   'Hint Text'
=> 'Hint Text',

   'Host'
=> '',

   'ID/Student Number'
=> 'ID/ ',

   'Identify fields'
=> ' ',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'If active, the new role will be available when the students next log in to LON-CAPA.',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'If this resource is in active use, student performance data from the previous version may become inaccessible.',

   'Ignore First Line'
=> '  ',

   'Illegal filename.'
=> '  .',

   'Image:'
=> ':',

   'Immediately expire own role as Course Coordinator'
=> '     ',

   'Import'
=> '',

   'Import a published document'
=> '  ',

   'Import and Paste Area'
=> '  ',

   'Include retrieval of student photographs?'
=> '   ?',

   'Incorrect'
=> '',

   'Incorrect Answers:'
=> ' :',

   'Initial Password'
=> ' ',

   'Institutional Information'
=> '  /',

   'Instructor'
=> '',

   'instructor'
=> '',

   'Instructor Information'
=> '  ',

   'Internal Filename'
=> '  ',

   'Internally authenticated'
=> '  ',

   'Invalid characters in requested name have been removed.'
=> '      .',

   'Invalid date entry'
=> '  ',

   'Invalid home server specified'
=> '   ',

   'Invalid login mode or password.'
=> '    .',

   'Invalid username or domain'
=> '    ',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> '          .',

   'July'
=> '',

   'June'
=> '',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Keep all Resources up-to-date with most recent Versions (default)',

   'Kerberos authenticated'
=> 'Kerberos authenticated',

   'Keyword(s)'
=> ' ()',

   'Keywords'
=> ' ',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA   ',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA Enrollment Manager',

   'LON-CAPA has live chat functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> '<p>LON-CAPA     .       .    ,        .</p>',

   'LON-CAPA Helper:'
=> 'LON-CAPA Helper:',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA    ,   . -,       . <p>          ,    . ,         .       ,    . (, &quot;Exam Proctor&quot;     .)</p> <p> ,    ,        .</p>',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA : [_1]',

   'Language'
=> '',

   'Last'
=> '',

   'Last Modified'
=> ' ',

   'Last Name'
=> '',

   'Last Name, First Names'
=> ', ',

   'Last Week'
=> ' ',

   'Last access'
=> ' ',

   'Last accessed'
=> '   ',

   'Last modified'
=> '   ',

   'Last updated'
=> '   ()',

   'Launch Remote Control'
=> '   ',

   'Librarian'
=> '',

   'Limit by copyright/distribution'
=> '  /',

   'Limit by language'
=> ' ',

   'List of hidden parts (hiddenparts)'
=> '   (hiddenparts)',

   'List of possible answers'
=> '  ',

   'List Directory'
=> ' ',

   'Load'
=> '',

   'Load Map'
=> ' ',

   'Load:'
=> ':',

   'Location'
=> '',

   'Lock and unlock assessments'
=> 'Lock and unlock assessments',

   'Log in'
=> '',

   'Logged Out'
=> '',

   'Login Data'
=> '  ',

   'Login Type'
=> '   ',

   'MIME Type'
=> 'MIME ',

   'Mail'
=> '',

   'Main Course Documents'
=> '  ',

   'Main Menu'
=> ' ',

   'Make new directory'
=> '  ',

   'Make new file'
=> '  ',

   'Make notes and annotations about this resource'
=> '     ',

   'Making Backup to'
=> 'Making Backup to',

   'Manage Access Keys'
=> '  ',

   'Manage access keys'
=> '  ',

   'Map'
=> '',

   'Map contents are not shown in order.'
=> '     .',

   'Map has branchings. Use advanced editor.'
=> '  .   .',

   'Map has conditions. Use advanced editor.'
=> '  .   .',

   'Map has resource parameters. Use advanced editor.'
=> '   .   .',

   'Map has unconnected resources. Use advanced editor.'
=> '   .   .',

   'March'
=> '',

   'Mark Unread'
=> ' ',

   'Material appears to be correct'
=> ' ',

   'Material covered with sufficient depth'
=> '   ',

   'Material is helpful'
=> ' ',

   'Material presented in clear way'
=> '  ',

   'Max Number Of Shown Foils:'
=> '   Foils:',

   'Max Possible To Date'
=> 'Max Possible To Date',

   'Max Tries'
=> 'Max  ',

   'Max number of foils displayed'
=> 'Max number of foils displayed',

   'Maximum Number of Collaborators'
=> '  ',

   'Maximum Number of Collaborators (maxcollaborators)'
=> '   (maxcollaborators)',

   'Maximum Number of Tries (maxtries)'
=> '   (maxtries)',

   'May'
=> '',

   'Mean Tries'
=> '  ',

   'Messaging'
=> 'Messaging',

   'Metadata'
=> '',

   'Metadata Information'
=> '  ',

   'Metadata Version'
=> ' ',

   'Metadata current version'
=> '  ',

   'Middle Names/Initials'
=> '/',

   'Middle'
=> '',

   'Middle Name'
=> '',

   'Mime type'
=> 'Mime ',

   'Missing Kerberos domain information.'
=> 'Missing Kerberos domain information.',

   'Modification Date'
=> ' ',

   'Modified'
=> '',

   'Modify Course Assessment Parameters'
=> '    ',

   'Modify Enrollment for'
=> '  ',

   'Modify Parameters'
=> ' ',

   'Modify User'
=> ' ',

   'Modify another students data'
=> '   ',

   'Modify authentication mechanism and data for a user'
=> '      ',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modify deadlines, etc, for this assessment resource',

   'Modify grades'
=> ' ',

   'Modify student data'
=> '  ',

   'Modify user grades for this assessment resource'
=> 'Modify user grades for this assessment resource',

   'Modifying data for user'
=> '   ',

   'Mon'
=> '',

   'Most recently published Version'
=> '  ',

   'Move current file to'
=> '   ',

   'Move Down'
=> ' ',

   'Move Up'
=> ' ',

   'My Personal Info'
=> '  ',

   'Name'
=> '',

   'Name starting with'
=> '  ',

   'Name:'
=> ':',

   'Name of Role'
=> ' ',

   'Navigate'
=> 'Navigate',

   'Navigate Contents'
=> 'Navigate Contents',

   'Navigate Course Contents'
=> ' ',

   'Navigate the table of contents for this course'
=> 'Navigate the table of contents for this course',

   'Network-wide number of accesses (hits)'
=> '    ()',

   'Network-wide number of courses using resource'
=> '   ,  ',

   'New Directory'
=> ' ',

   'New Folder'
=> ' ',

   'New Messages'
=> ' ',

   'New Problem Variation'
=> '  ',

   'New Randomization'
=> ' ',

   'New Resource'
=> ' ',

   'New Role'
=> ' ',

   'New Search'
=> ' ',

   'New Title'
=> ' ',

   'New User'
=> ' ',

   'New Value'
=> ' ',

   'New assembled page'
=> '  ',

   'New assembled sequence'
=> '  ',

   'New custom rights file'
=> '   ',

   'New discussion since'
=> '  ',

   'New file'
=> ' ',

   'New HTML file'
=> ' HTML ',

   'New parameters or saved values'
=> '    ',

   'New problem'
=> ' ',

   'New style file'
=> '  ',

   'New subdirectory'
=> ' ',

   'Next'
=> '',

   'Next ->'
=> ' ->',

   'Next Month'
=> ' ',

   'No'
=> '',

   'No Kerberos domain was specified.'
=> 'Kerberos   .',

   'No Role, Cumulative Privileges'
=> ' ,  ',

   'No changes were made to the current settings.'
=> '    .',

   'No content modifications yet.'
=> '   .',

   'No due date'
=> '  ',

   'No language preference'
=> '  ',

   'No new filename specified.'
=> '    .',

   'No previous versions published.'
=> '   .',

   'No role specified'
=> '  ',

   'No section assigned'
=> '  ',

   'No such file'
=> '  ',

   'No upload file specified.'
=> '   .',

   'No write permission to'
=> 'No write permission to',

   'No write permission to user directory, FAIL'
=> 'No write permission to user directory, FAIL',

   'None Found'
=> '  ',

   'Not Allowed'
=> ' ',

   'Not shown, not used'
=> ' ,  ',

   'Note: for large courses, this operation may be time consuming'
=> ':       ',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Note: it can take up to 10 minutes for changes to take effect for all users.',

   'Note: this will not take effect if the user already exists'
=> ':        ',

   'Notes'
=> '',

   'Notification of enrollment changes'
=> 'Notification of enrollment changes',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?',

   'November'
=> '',

   'Number of assignments printed at the same time:'
=> '  ,  :',

   'Number of bubbles in exam mode (numbubbles)'
=> '     (numbubbles)',

   'Number of Plots:'
=> ' :',

   'Number of columns'
=> ' ',

   'Number of resources that follow this resource in maps'
=> '      ',

   'Number of resources that lead up to this resource in maps'
=> '     ',

   'Number of resources using or importing resource'
=> '     ',

   'Number of Tries before hints appear (hinttries)'
=> '     (hinttries)',

   'Numerical Tolerance (tol)'
=> '   (tol)',

   'Obsolete'
=> '',

   'Obsolete parameters or saved values'
=> '    ',

   'October'
=> '',

   'Office Hours'
=> '  ',

   'Old Value'
=> ' ',

   'One particular problem (overrides folder and course defaults)'
=> '   (      -)',

   'Only domain coordinators can change a users password.'
=> '      ',

   'Only a number required.'
=> '  .',

   'Open'
=> '',

   'Open Course'
=> ' ',

   'Open all assessments'
=> '  ',

   'Open All Folders'
=> '  ',

   'Open, no due date'
=> ',   ',

   'Opening Date (contentopen)'
=> '   (contentopen)',

   'Opening Date (opendate)'
=> '  (opendate)',

   'Option Response Problem Analysis'
=> 'Option Response Problem Analysis',

   'Option response'
=> 'Option response',

   'Output'
=> '',

   'Output Format'
=> ' ',

   'Overall Problem Statistics'
=> '   ',

   'Owner/Publisher'
=> '/',

   'Page'
=> '',

   'Page layout'
=> '',

   'Parameter Name'
=> ' ',

   'Parameter Type'
=> ' ',

   'Parameter in Effect'
=> ' ',

   'Parent Directory'
=> ' ',

   'Part'
=> '',

   'Part Description (display)'
=> '  (display)',

   'Part is not open to be viewed. It'
=> '    . ',

   'Paste after selected'
=> '  ',

   'Password'
=> '',

   'Path'
=> '',

   'Per Page'
=> ' ',

   'Personal Data'
=> ' ',

   'Personal Information'
=> ' ',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> '    LON-CAPA    .',

   'Please do not reply to this address.'
=> '     .',

   'Please either'
=> ' ',

   'Please notify the server administrator '
=> '    ',

   'Please pick a version to retrieve'
=> '  ',

   'Please select a problem to analyze'
=> '   ',

   'Please select a report to generate'
=> 'Please select a report to generate',

   'Please select a report to generate'
=> '  ',

   'Please select an authentication mechanism'
=> 'Please select an authentication mechanism',

   'Please select the authentication mechanism'
=> 'Please select the authentication mechanism',

   'Please select the section you wish to set the answer open date for:'
=> ' ,       ',

   'Please select the section you wish to set the due date for:'
=> ' ,      ',

   'Please select the section you wish to set the number of tries for:'
=> ' /,      ',

   'Please select the section you wish to set the opening date for:'
=> ' ,        ',

   'Please select the section you wish to set the problem weight for:'
=> ' ,      ',

   'Please select the student you wish to set the answer open date for:'
=> ' ,       ',

   'Please select the student you wish to set the due date for:'
=> ' ,      ',

   'Please select the student you wish to set the number of tries for:'
=> ' ,      ',

   'Please select the student you wish to set the opening date for:'
=> ' ,        ',

   'Please select the student you wish to set the problem weight for:'
=> ' ,      ',

   'Please use browser "Back" button and pick a filename'
=> 'Please use browser "Back" button and pick a filename',

   'Position'
=> '',

   'Post anonymously'
=> 'Post anonymously',

   'Post discussion on course resources'
=> 'Post discussion on course resources',

   'Post system frontpage announcements'
=> 'Post system frontpage announcements',

   'Post to live chatrooms'
=> 'Post to live chatrooms',

   'Preferred language'
=> ' ',

   'Prepare a printable document'
=> 'Prepare a printable document',

   'Preparing Excel Spreadsheet'
=> '   Excel',

   'Prerequisites'
=> '',

   'Previous'
=> '',

   'Previous Month'
=> ' ',

   'Print'
=> '',

   'Printing Helper'
=> ' ',

   'Privacy Note'
=> 'Privacy Note',

   'Private - visible to author only for testing purposes'
=> 'Private - visible to author only for testing purposes',

   'Private Publication - did not synchronize database'
=> 'Private Publication - did not synchronize database',

   'Privileged users that should not be hidden on staff listings'
=> '  ,        ',

   'Problem Status Chart'
=> 'Problem Status Chart',

   'Problems'
=> '',

   'Problems Not Contained In A Folder'
=> 'Problems Not Contained In A Folder',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.',

   'Processed file'
=> 'Processed file',

   'Processed [_1] student(s).'
=> 'Processed [_1] student(s).',

   'Processing'
=> 'Processing',

   'Processing course structure'
=> 'Processing course structure',

   'Processing first student'
=> 'Processing first student',

   'Produce Excel Output'
=> 'Produce Excel Output',

   'Project Information'
=> '  ',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Provide feedback messages or contribute to the course discussion about this resource',

   'Provide my evaluation of this resource'
=> 'Provide my evaluation of this resource',

   'Public - no authentication or authorization required for use'
=> 'Public - no authentication or authorization required for use',

   'Publish'
=> '',

   'Publish Directory'
=> ' ',

   'Publish Directory and Sub Directories'
=> '   ',

   'Publish this Resource'
=> '  ',

   'Published'
=> '',

   'Publisher/Owner'
=> '/',

   'Publishing'
=> '',

   'Question Text'
=> ' ',

   'Question Type'
=> ' ',

   'Question Type (type)'
=> '  (type)',

   'Quick Completed Problems Display'
=> 'Quick Completed Problems Display',

   'Random position'
=> ' ',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)',

   'Randomly pick number of resources (randompick)'
=> 'Randomly pick number of resources (randompick)',

   'Re'
=> 'Re',

   'Re-Initialize'
=> '',

   'Re-enrollment will re-activate data.'
=> 'Re-enrollment will re-activate data.',

   'Reading results from'
=> '  ',

   'Readings'
=> '',

   'Receipt algorithm used'
=> '    ',
 
   'Record'
=> '',

   'Registering'
=> '',

   'Related'
=> '  ',

   'Remark'
=> '',

   'Rename'
=> '',

   'Rename current file to'
=> '   ',

   'Reply'
=> '',

   'Reset Submissions'
=> 'Reset Submissions',

   'Resource alias name for conditions (mapalias)'
=> '      (mapalias)',

   'Resource Differences'
=> '  ',

   'Resource Feedback and Discussion'
=> 'Resource Feedback and Discussion',

   'Resource Level'
=> ' ',

   'Resource Publication'
=> ' ',

   'Resource is technically correct'
=> '  ',

   'Resources'
=> '',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> '        ',

   'Retrieve'
=> '',

   'Retrieve Published Resources'
=> '  ',

   'Retrieve previous versions of'
=> '  ',

   'Retrieve Old Version'
=> '  ',

   'Retrieve version'
=> ' ',

   'Return to Last Location'
=> 'Return to Last Location',

   'Reverse Association'
=> 'Reverse Association',

   'Revert to Last Saved'
=> 'Revert to Last Saved',

   'Revoke'
=> '',

   'Revoke Existing Roles'
=> '  ',

   'Revision Date'
=> ' ',

   'Role'
=> '',

   'role,role,...'
=> ',,...',

   'Role Information'
=> '  ',

   'Row'
=> '',

   'Rule'
=> '',

   'S.D. tries'
=> 'S.D. ',

   'Samples'
=> '',

   'Sat'
=> '',

   'Save'
=> '',

   'Save as'
=> ' ',

   'Save as & Make This Sheet the Default'
=> 'Save as & Make This Sheet the Default',

   'Save as ...'
=> '  ...',

   'Saving Modifications to'
=> '  ',

   'Scantron Operator'
=> 'Scantron Operator',

   'Score Upload Form'
=> 'Score Upload Form',

   'Search'
=> '',

   'Search Complete'
=> ' ',

   'Search the contents of this course'
=> 'Search the contents of this course',

   'Search the database of published resources'
=> '     ',

   'Searching'
=> '',

   'Section'
=> '',

   'Section/Group'
=> '/',

   'Sections'
=> '',

   'Select'
=> '',

   'Select Action'
=> ' ',

   'Select All'
=> ' ',

   'Select All Files'
=> '  ',

   'Select All Published'
=> '  ',

   'Select All Students'
=> '  ',

   'Select Course'
=> ' ',

   'Select Date'
=> ' ',

   'Select Enclosing Map or Folder'
=> '    ',

   'Select Folder'
=> ' ',

   'Select Map'
=> ' ',

   'Select Only Current Students'
=> '   ',

   'Select Parameter Level'
=> '  ',

   'Select Problem'
=> ' ',

   'Select Problem(s) to print'
=> ' ()  ',

   'Select Printing Options:'
=> ' :',

   'Select Spreadsheet File'
=> '  ',

   'Select User'
=> ' ',

   'Select a'
=> '',

   'Select a course'
=> ' ',

   'Select a user name to modify the students information'
=> '       ',

   'Select a user name to view the users personal page.'
=> '       .',

   'Select for Section/Group'
=> '  /',

   'Select the Construction Space'
=> '  ',

   'Select the folder you wish to set the parameter for:'
=> ' ,      :',

   'Select the problem you wish to set the parameter for:'
=> ' ,      :',

   'Selecting a User'
=> ' ',

   'Send Message to User(s)'
=> '  ()',

   'Send New'
=> ' ',

   'Send Reply'
=> ' ',

   'Send Scantron data to a course'
=> 'Send Scantron data to a course',

   'Send and receive messages'
=> '   ',

   'Send as critical message'
=> '   ',

   'Send broadcast and receipt-required email'
=> 'Send broadcast and receipt-required email',

   'Send internal email'
=> '  email',

   'September'
=> '',

   'Sequence'
=> '',

   'Sequence or Folder'
=> '  ',

   'Sequences and Folders'
=> '  ',

   'Server'
=> '',

   'Server Administration'
=> ' ',

   'Set Course Environment Parameters'
=> '   ',

   'Set Date'
=> ' ',

   'Set Defaults for All Resources in Course'
=> '       ',

   'Set End Date'
=> '  ',

   'Set Problem Tries'
=> '  ',

   'Set Problem Weight'
=> '  ',

   'Set Start Date'
=> '  ',

   'Set value to "[_1]" to allow'
=> '  "[_1]"  ',

   'Set Version to be used in Course'
=> '    ',

   'Set Versions to be used in Course according to Selections below'
=> ' ,      ',

   'Set content feedback to Course Coordinator'
=> 'Set content feedback to Course Coordinator',

   'Set course policy feedback to Course Coordinator'
=> 'Set course policy feedback to Course Coordinator',

   'Set a bookmark for this resource'
=> '    ',

   'Set a due date'
=> ' <b> </b>',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Set all Resource Versions to current Version (Fix Versions)',

   'Set an answer open date'
=> ' <b>  </b>',

   'Set an open date'
=> ' <b> </b>',

   'Set answer open date for all problems in the course for ...'
=> '         ...',

   'Set answer open date for the selected folder for ...'
=> '        ...',

   'Set answer open date for the selected problem for ...'
=> '        ...',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'Set deadlines and other assessment parameters, as well as modify course environment',

   'Set due date for all problems in the course for ...'
=> '        ...',

   'Set due date for the selected folder for ...'
=> '       ...',

   'Set due date for the selected problem for ...'
=> '       ...',

   'Set my user preferences'
=> '   ',

   'Set number of tries for all problems in the course for ...'
=> '        ...',

   'Set number of tries for the selected folder for ...'
=> '     ',

   'Set number of tries for the selected problem for ...'
=> '       ...',

   'Set opening date for all problems in the course for ...'
=> '         . . .',

   'Set opening date for the selected folder for ...'
=> '       ...',

   'Set opening date for the selected problem for ...'
=> '       ...',

   'Set problem weight for all problems in the course for ...'
=> '       ...',

   'Set problem weight for the selected folder for ...'
=> '        ...',

   'Set problem weight for the selected problem for ...'
=> '        ...',

   'Set the number of tries'
=> ' <b> </b>',

   'Set the problem weight'
=> ' <b> </b>',

   'Set/Modify Course Assessment Parameter'
=> '/    ',

   'Set/Modify Course Assessment Parameters'
=> 'Set/Modify Course Assessment Parameters',

   'Set/Modify Course Parameters'
=> '/  ',

   'Setting the [_1]'
=> '  [_1]',

   'Setting the [_1] to [_2]'
=> '  [_1]  [_2]',

   'Shared by course faculty and staff'
=> 'Shared by course faculty and staff',

   'Short string response'
=> 'Short string response',

   'Show More Options'
=> '  ',

   'Show Only Uncompleted Homework'
=> '   ',

   'Show Preview'
=> 'Show Preview',

   'Show Problem Completeness'
=> 'Show Problem Completeness',

   'Show Problem Status (problemstatus)'
=> '   (problemstatus)',

   'Show all roles'
=> '  ',

   'Show always at bottom position'
=> '  ',

   'Show always at top position'
=> '  ',

   'Show catalog information'
=> 'Show catalog information',

   'Show resource'
=> ' ',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Show Units - Disable Entry (turnoffunit)',

   'Significant Digits (sig)'
=> '  (sig)',
 
   'Significant figures are incorrect, submission was not graded.'
=> 'Significant figures are incorrect, submission was not graded.',

   'Simple Edit'
=> ' ',

   'Simple Page'
=> ' ',

   'Simple Problem'
=> ' ',

   'Simple Problem Editor'
=> '  ',

   'Since Start of Course'
=> '   ',

   'Since Yesterday'
=> '  ',

   'Size'
=> '',

   'Size:'
=> ':',

   'Skew Tries'
=> ' ',

   'Some parts were not submitted.'
=> 'Some parts were not submitted.',

   'Space separated'
=> ' ',

   'Special Documents'
=> ' ',

   'Special documents'
=> ' ',

   'Spreadsheet Computation'
=> ' ',

   'Spreadsheet Computation Status'
=> '  ',

   'Start'
=> '',

   'Start each student\'s assignment on a new page/column (add a pagefeed after each assignment)'
=> '      /',

   'Start Time',
=> ' ',

   'Starting'
=> '',

   'Starting and Ending Dates'
=> '   ',

   'Starting Date'
=> ' ',

   'Statistics'
=> '',

   'Statistics and Problem Analysis'
=> '   ',

   'Status'
=> '',

   'Save'
=> '',

   'Save Catalog Information'
=> 'Save Catalog Information',

   'Save Changes'
=> ' ',

   'Save uploaded file as '
=> 'Save uploaded file as ',

   'Student'
=> '',

   'student'
=> '',

   'Student ID'
=> 'ID ',

   'Student Information'
=> '  ',

   'Student information updated successfully.'
=> '    .',

   'Student Data Compilation Progress'
=> 'Student Data Compilation Progress',

   'Student Data Compilation Status'
=> 'Student Data Compilation Status',

   'Student Name'
=> ' ',

   'Student Number'
=> ' ',

   'Student Status'
=> ' ',

   'Student level sheet'
=> 'Student level sheet',

   'Student performance statistics on all problems.'
=> '    .',

   'Students Affected'
=> ' ',

   'Students need access key to enter course'
=> '        ',

   'Students with expired roles',
=> '   ',

   'Subject'
=> '',

   'Subject:'
=> ':',

   'Submission Time Analysis'
=> '  ',

   'Submit'
=> '',

   'Submit Answer'
=> ' ',

   'Submit Changes'
=> ' ',

   'Submit Changes and Edit'
=> '   ',

   'Submit Changes and View'
=> '   ',

   'Submit Modifications'
=> ' ',

   'Successful Login'
=> '   ',

   'Suggested Replacement for Obsolete File'
=> '   ',

   'Summary'
=> '',

   'Summary View'
=> 'Summary View',

   'Sun'
=> '',

   'Supplemental Course Documents'
=> '  ',

   'Switch Server'
=> ' ',

   'Switch to another course'
=> '   ',

   'Switch to another user role'
=> '   ',

   'Switching Role'
=> ' ',

   'Syllabus'
=> ' ',

   'Synchronized SQL metadata database'
=> ' SQL  ',

   'System'
=> '',

   'System Administration'
=> ' ',

   'System Level'
=> ' ',

   'System wide - can be used for any courses system wide'
=> 'System wide - can be used for any courses system wide',

   'System wide - open source to all authors'
=> 'System wide - open source to all authors',

   'Tabulator separated'
=> ' ',

   'Target'
=> '',

   'Target Edit Map'
=> ' -  ',

   'Task'
=> '',

   'TeXWidth(mm):'
=> 'TeXWidth(mm):',

   'Teaching Assistant'
=> ' ',

   'Template'
=> '',

   'Temporary Assembly Workspace'
=> '   ',

   'Text'
=> '',

   'Text Block'
=> ' ',

   'Textbook'
=> '',

   'The &quot;Course Description&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next -&gt;&quot; to continue.'
=> '&quot; &quot;   ,      .         <nobr>&quot;<b> -&gt;</b>&quot;</nobr>  .<br />',

   'The error reported was'
=> 'The error reported was',

   'The extension on this file'
=> '  ',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'The filetype extension of the file you uploaded is not allowed.',


   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists.",

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.',

   'The optional email address field was not specified.'
=> 'The optional email address field was not specified.',

   'The optional name field was not specified.'
=> 'The optional name field was not specified.',

   'The optional section or group field was not specified.'
=> 'The optional section or group field was not specified.',

   'The optional student number field was not specified.'
=> '     .',

   'The student must log out and log in again to see these changes.'
=> '           .',

   'The submitted answer was too long.'
=> '    .',

   'The target is an existing directory.'
=> ' -  .',

   'Then'
=> '',

   'There are currently no results'
=> '    ',

   'There are no students currently enrolled.'
=> '     .',

   'There is no student data for this problem.'
=> '     .',

   'There was an error determining the environment values for'
=> 'There was an error determining the environment values for',

   'This controls how receipt numbers are generated.'
=> '       .',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> '<p>    <b>  , ,    </b>,   <b>    </b>.</p><p>     <b>"      ?"</b>, <b>"    ?"</b>, <b>"   / ?"</b>.               () ,     /  .</p> <p> <b> -&gt;</b>  ,   <b>&lt;- </b>     .</p>',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> '             .',

   'This is an automatic message generated by the LON-CAPA system.'
=> ' ,   LON-CAPA .',

   'This question expects a numeric answer.'
=> '    .',

   'This resource has been marked obsolete by the author(s)'
=> '     ',

   'This syllabus can be publicly viewed at'
=> '       ',

   'Threaded View'
=> 'Threaded View',

   'Thu'
=> '',

   'Time'
=> '',

   'Title'
=> '',

   'To'
=> 'To',

   'Topic'
=> '',

   'Total'
=> '',

   'Total Parts In Course'
=> '    ',

   'Total number of records found in file: [_1].'
=> '    : [_1].',

   'Total number of students who have worked on this problem'
=> ' ,    ',

   'Tries'
=> '',

   'True'
=> '',

   'Tue'
=> '',

   'Type'
=> '',

   'Type in value'
=> 'Type in value',

   'Type Name Here'
=> '  ',

   'UNIX authenticated'
=> 'UNIX authenticated',

   'URL'
=> 'URL',

   'URLs To Include in Syllabus'
=> 'URLs    ',

   'USERS'
=> '',

   'Unable to connect to database!'
=> '    !',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Unable to determine if this resource is open due to network problems. Please try again later.',

   'Unable to enroll'
=> ' ',

   'Unable to enroll students'
=> '  ',

   'Unable to find'
=> ' ',

   'Unable to make backup'
=> 'Unable to make backup',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> '  ,    ID(s), ID(s)   .  ID(s):',

   'Unable to retrieve environment data for'
=> 'Unable to retrieve environment data for',

   'Unable to set default dates for course'
=> '       ',

   'Unable to understand formula'
=> '  ',

   'Unable to undo, unable to switch'
=> 'Unable to undo, unable to switch',

   'Unable to write to'
=> '  ',

   'Unavailable course'
=> ' ',

   'Uncheck All'
=> '  ',

   'Uncompleted Homework'
=> '  ',

   'Undid changes, Switched'
=> 'Undid changes, Switched',

   'Unit:'
=> ' :',

   'Units incorrect.'
=> '  .',

   'Units required'
=> '  ',

   'Unknown Action'
=> ' ',

   'Unknown ID'
=> ' ID',

   'Unknown message'
=> ' ',

   'Unknown user'
=> ' ',

   'Unpublished'
=> '',

   'Unselect All'
=> '  ',

   'Unselect All Files'
=> '   ', 

   'Unselect All Published'
=> '   ',

   'Unselect All Students'
=> '   ',

   'Unselect All Resources'
=> '   ',

   'Unselect for Section/Group'
=> '   /',

   'Unsuccessful Login'
=> ' Login',

   'Unsupported character combination'
=> '  ',

   'Up'
=> '',

   'Update Course Assessment Parameter Display'
=> '   ',

   'Update Display'
=> ' ',

   'Update Section or Specific User'
=> '   ',

   'Update Student Data'
=> '  ',

   'Updating discussion time'
=> '  ',

   'Upload Document'
=> ' ',

   'Upload Scantron data'
=> ' Scantron ',

   'Upload a Photo'
=> ' ',

   'Upload a class list'
=> '    ',

   'Upload class list'
=> '    ',

   'Upload a new main course document'
=> '    ',

   'Upload a new supplemental course document'
=> '    ',

   'Upload file'
=> ' ',

   'Uploaded'
=> '',

   'Uploaded Document'
=> ' ',

   'Uploading Class List'
=> '   ',

   'Use or edit my bookmark collection'
=> '/   ',

   'User'
=> '',

   'User Load'
=> 'User Load',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'User Notes, Records of Face-to-Face Discussions, and Critical Messages',

   'User Role'
=> ' ',

   'User Roles'
=> ' ',

   'Username'
=> ' ',

   'Users with Roles Assigned by'
=> '  ,  ',

   'Value'
=> '',

   'Verify Content'
=> ' ',

   'Verify Course Documents'
=> '  ',

   'Verify Selection'
=> ' ',

   'Version'
=> '',

   'Version Number'
=> ' ',

   'Version changes since Yesterday'
=> '    ',

   'Version changes since last Month'
=> '    ',

   'Version changes since last Week'
=> '    ',

   'Version changes since start of Course'
=> '     ',

   'Version used in Course'
=> ',   ',

   'View'
=> '',

   'View All Messages'
=> '  ',

   'View Class List'
=> '  ',

   'View Critical Messages'
=> '  ',

   'View Published Version'
=> '  ',

   'View course assessment statistics'
=> 'View course assessment statistics',

   'View documents included in this course'
=> ' ,   ',

   'View file'
=> ' ',

   'View the course assessment progress chart'
=> 'View the course assessment progress chart',

   'View user submissions for this assessment resource'
=> 'View user submissions for this assessment resource',

   'Warning!'
=> '!',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> ':     LON-CAPA  .',

   'Warning: change of MIME type!'
=> ':  MIME !',

   'Warning: target file exists!'
=> ':   !',

   'Warning: target file exists, and has been published!'
=> ':      !',

   'Was due'
=> 'Was due',

   'Web Links'
=> 'Web Links',

   'Web References'
=> 'Web References',

   'Wed'
=> '',

   'Weight (weight)'
=> ' (weight)',   

   'Welcome'
=> '',

   'Welcome to the Assignment Parameter Helper'
=> '    ',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up',

   'Welcome to Your New LON-CAPA Course'
=> '     ',

   'What parameter do you want to set for all problems in the course?'
=> '        ?',

   'What parameter do you want to set for the selected folder?'
=> '       ?',

   'What parameter do you want to set for the selected problem?'
=> '       ?',

   'What should the opening date be set to?'
=> '  ? <br /><br />',

   'What should the due date be set to?'
=> '  ? <br /><br />',

   'What should the answer open date be set to?'
=> '     ? <br /><br />',

   'What weight should be set for all problems in the course?'
=> '       ?<br /></br > ',

   'What weight should be set for the selected folder?'
=> '      ?<br /></br >',

   'What weight should be set for the selected problem?'
=> '      ?<br /></br >',

   'Which Problem or Problems?'
=> '   ?',

   'Which problems do you wish to set a parameter for?'
=> '      ?',

   'Width(pixel):'
=> '(pixel):',

   'Without Answers'
=> ' ',

   'With Answers'
=> ' ',

   'Only Answers'
=> ' ',

   'Words'
=> '',

   'Wrote Metadata'
=> ' ',

   'XML/SGML'
=> 'XML/SGML',

   'Yes'
=> '',

   'You are correct.'
=> ' .',

   'You are excused from the problem.'
=> '     .',

   'You are working with an unsaved version of your map.'
=> '      ',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.',

   'You did not select a template.'
=> '   .',

   'You do not have authoring privileges for this resource'
=> 'You do not have authoring privileges for this resource',

   'You have entered that answer before'
=> '    ',

   'You have no critical messages.'
=> '    .',

   'You have no unread messages'
=> '    ',

   'You have provided an invalid ranking'
=> 'You have provided an invalid ranking',

   'You must choose an authentication type.'
=> 'You must choose an authentication type.',

   'You must choose at least one student to continue.'
=> '     .',

   'You must choose one or more choices to continue.'
=> '     .',

   'You need to choose another user role or enter a specific course for this function'
=> 'You need to choose another user role or enter a specific course for this function',

   'You need to specify the Kerberos domain.'
=> '   Kerberos .',

   'You need to specify the initial password.'
=> '    .',

   'You need to specify the username field.'
=> '    .',

   'Your course is now set up. Please select the Finish Course Initialization button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen, by pushing the Course Environment button.'
=> '  .    <b>  </b>      . <p>         <b>PARMS</b>     <b> </b>.</p>',

   'Your Excel Spreadsheet'
=> '   Excel',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.',

   'Your Version Settings have been Saved'
=> '     ',

   'Your home server is '
=> '   ',

   'Your receipt is'
=> 'Your receipt is',

   'Your submission has been recorded.'
=> 'Your submission has been recorded.',

   '&quot; [_1] &quot; is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '&quot; [_1] &quot;     .   -   .',

   '&quot; [_1] &quot; is not an acceptable weight. Weight must be a positive number.'
=> '&quot; [_1] &quot;    .  -   .',

   '[_1] Do not change login data'
=> '[_1] Do not change login data',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Filesystem Authenticated (with initial password [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Internally authenticated (with initial password [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local Authentication with arguement [_2]',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section/group ID to be used in LON-CAPA e.g., 001:1,002:2',
   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2'
=> 'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) groupID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:bot2',

   'a.m.'
=> 'a.m.',

   'aboutlon.gif'
=> 'aboutlon.gif',

   'abstract'
=> '',

   'acc keys'
=> ' ',

   'access denied'
=> '  ',

   'accessbutton.gif'
=> 'accessbutton.gif',

   'according to course preferences'
=> 'according to course preferences',

   'according to resource settings'
=> 'according to resource settings',

   'according to user session state'
=> 'according to user session state',

   'after selected'
=> ' ',

   'all'
=> '',

   'all resources in the course'
=> '  ',

   'all students in course'
=> '  ',

   'an indeterminate date'
=> ' ',

   'an unknown date'
=> ' ',

   'and return receipt'
=> 'and return receipt',

   'anno-'
=> 'anno-',

   'announce'
=> 'announce',

   'anonymous'
=> '',

   'anonymous students'
=> ' ',

   'answer date'
=> '  ',

   'at'
=> 'at',

   'at Domain'
=> ' ',

   'at domain'
=> ' ',

   'audio'
=> '',

   'author'
=> '',

   'backward'
=> 'backward',

   'bookmark'
=> '',

   'bytes'
=> '',

   'can not be accessed from your location.'
=> 'can not be accessed from your location.',

   'catalog'
=> '',

   'chart'
=> 'chart',

   'chat'
=> 'chat',

   'chmod error'
=> 'chmod ',

   'choose'
=> '',

   'close this window'
=> '  ',

   'co con-'
=> 'co con-',

   'co res'
=> 'co res',

   'commu-'
=> 'commu-',

   'con-'
=> 'con-',

   'connection down'
=> ' ',

   'contacting'
=> 'contacting',

   'contents'
=> '',

   'copy Error'
=> ' ',

   'copyright'
=> 'copyright',

   'could not be copied.'
=> '  .',

   'course'
=> '',

   'create'
=> '',

   'customdistributionfile'
=> 'customdistributionfile',

   'default'
=> ' ',

   'directory'
=> '',

   'discuss'
=> '',

   'docs'
=> 'docs',

   'due date'
=> ' ',

   'during the last'
=> 'during the last',

   'edit'
=> '',

   'edit crs'
=> 'edit crs',

   'ences'
=> 'ences',

   'enroll'
=> '',

   'enter'
=> '',

   'evaluate'
=> 'evaluate',

   'exit'
=> '',

   'expired or revoked'
=> '  ',

   'extension'
=> '',

   'fas'
=> 'fas',

   'feedback'
=> 'feedback',

   'first name'
=> '',

   'for'
=> '', 

   'for [_1]'
=> ' [_1]',

   'for <b>all resources in the course</b>'
=> ' <b>  </b>',

   'for <b>all students in course</b>'
=> ' <b>  </b>',

   'for section [_1]'
=> '  [_1]',

   'for Enclosing Map or Folder'
=> '    ',

   'for Resource'
=> ' ',

   'for the map named [_1]'
=> '    [_1]',

   'for the resource named [_1]'
=> '    [_1]',

   'forward'
=> '',

   'from'
=> '',

   'from current subdirectory'
=> '  ',

   'from Enclosing Map or Folder'
=> '    ',

   'general'
=> '',

   'generation'
=> '',

   'grades'
=> '',

   'in'
=> '',

   'in Course'
=> ' ',

   'in domain'
=> ' ',

   'in Section/Group'
=> ' /',

   'info'
=> '',

   'interface available'
=> 'interface available',

   'is closed but you are allowed to view it'
=> 'is closed but you are allowed to view it',

   'is due at'
=> 'is due at',

   'is in under construction'
=> 'is in under construction',

   'is not analyzable at this time'
=> 'is not analyzable at this time',

   'is ready for download'
=> 'is ready for download',

   'keywords'
=> ' ',

   'language'
=> '',

   'last month'
=> ' ',

   'last name'
=> '',

   'last problem'
=> ' ',

   'last six months'
=> '  ',

   'last student'
=> ' ',

   'last three months'
=> '  ',

   'last week'
=> ' ',

   'last year'
=> ' ',

   'library'
=> '',

   'log in again'
=> 'log in again',

   'loginproblems.html'
=> 'loginproblems.html',

   'make these dates the default for future enrollment'
=> '       ',

   'manage'
=> 'manage',

   'may open later.'
=> 'may open later.',

   'middle name'
=> '',

   'midnight'
=> '',

   'minutes'
=> '',

   'missions'
=> 'missions',

   'most recent'
=> '',

   'movies'
=> '',

   'my'
=> '',

   'name'
=> '',

   'name only visible to course faculty'
=> 'name only visible to course faculty',

   'navigate'
=> 'navigate',

   'never'
=> '',

   'nication'
=> 'nication',

   'noon'
=> '',

   'not displayed'
=> 'not displayed',

   'no ending date'
=> '  ',

   'not found'
=> ' ',

   'notes'
=> '',

   'number'
=> '',

   'number of tries'
=> ' ',

   'num_override'
=> 'num_override',

   'obsolete'
=> '',

   'obsoletereplacement'
=> ' ',

   'of'
=> 'of',

   'only check if you know what you are doing'
=> 'only check if you know what you are doing',

   'opening date'
=> '   ',

   'or'
=> '',

   'or ID'
=> ' ID',

   'p.m.'
=> 'p.m.',

   'pages'
=> '',

   'parms'
=> 'parms',

   'part'
=> '',

   'percent'
=> '',

   'pictures'
=> '',

   'please refer to'
=> 'please refer to',

   'prefer-'
=> 'prefer-',

   'prepare'
=> 'prepare',

   'printout'
=> 'printout',

   'problem'
=> '',

   'problem statistics grouped by sequence'
=> 'problem statistics grouped by sequence',

   'problem statistics ungrouped'
=> 'problem statistics ungrouped',

   'problem statistics, Excel'
=> ' , Excel',

   'problem weight'
=> ' ',

   're-initializing course'
=> '- ',

   'remaining'
=> '',

   'resource'
=> '',

   'resources'
=> '',

   'role'
=> '',

   'roles'
=> '',

   'search'
=> '',

   'second'
=> '',

   'seconds'
=> '',

   'seconds for'
=> ' ',

   'selected students'
=> ' ',

   'sequence'
=> '',

   'set'
=> '',

   'space'
=> '',

   'standard courses only'
=> '   ',   

   'stats'
=> 'stats',

   'struct'
=> 'struct',

   'subject'
=> '',

   'switch'
=> 'switch',

   'system wide'
=> 'system wide',

   'tations'
=> 'tations',

   'this'
=> 'this',

   'title'
=> '',

   'to'
=> '',

   'to [_1] ([_2])'
=> ' [_1] ([_2])',

   'today'
=> '',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231',

   'unable to enroll'
=> 'unable to enroll',

   'undo'
=> '',

   'unless locked'
=> 'unless locked',

   'untitled'
=> ' ',

   'updated periodically'
=> ' ',

   'user'
=> '',

   'userauthentication.gif'
=> 'userauthentication.gif',

   'users in'
=> ' ',

   'versions of this problem'
=> '  ',

   'versus'
=> '',

   'view'
=> 'view',

   'view sub-'
=> 'view sub-',

   'visible to author and co-authors only'
=> 'visible to author and co-authors only',

   'waiting on'
=> 'waiting on',

   'warning(s)'
=> 'warning(s)',

   'was due on'
=> 'was due on',

   'will open on'
=> 'will open on',

   'with server'
=> ' ',


   'Select resources for the assignment'
=> '<br /><big><i><b>   </b></i></big><br />',

   'Print:'
=> "<hr width='33%' /><table><tr><td align='right'>: </td><td>",

   'LaTeX mode:'
=> "<tr><td align='right'> LaTeX: </td><td>",

   'standard LaTeX mode'
=> ' ',

   'Print Table of Contents:'
=> "</td></tr><tr><td align='right'> : </td><td>",

   'Print Index:'
=> "<tr><td align='right'> : </td><td>",

   'what you just saw on the screen'
=> "       ",

   'Select All Resources'
=> '  ',

   'Resource Hidden from Students (hiddenresource)'
=> ',    (hiddenresource)',

   'Resources from selected sequence in course'
=> "<b></b>  <b> </b> ",

   'Problems from entire course'
=> '<b></b>  <b> </b>',

   'Select Resource(s) to print'
=> ' ()  ',

   'Select Student'
=> ' ',

   'Select Students and Resources'
=> '   ',

   'Select Sequence To Print From'
=> '      ',

   'Select Resources To Print'
=> '   ',

   'Upload class list'
=> '  ',

   'Begin Enrollment'
=> ' ',

   'Catalog Search'
=> '  ',

   'Course Search'
=> '  ',

   'Generate messages from a file'
=> '   ',

   'Parameter'
=> '',

   'Set to ...'
=> ' ',

   'Set Individual User Roles'
=> '   ', 
   
   'Width'
=> '',

   'Page layout'
=> ' ',

   'Paper type'
=> ' ',

   'Top Level Map'
=> ' ',

   'Modification may make assessment data inaccessible'
=> '    ',

   'Display file attributes'
=> '  ',

   'number'
=> '',

   'internal'
=> '',

   'optional'
=> '',

   'standard'
=> '',

   'external'
=> '',

   'or any other value'
=> '   ',

   'Default for new courses is'
=> '    ',

   'Default XML Style File'
=> 'XML    ',

   'Select Style File'
=> '  ',

   'Languages used'
=> ' ',

   'Randomization algorithm used'
=> '  ',

   'Modifying this will make problems'
=> '     ',

   'have different numbers and answers'
=> '    ',

   'Resource'
=> '', 

   'Folder/Map'
=> '/',

   'Set'
=> '',

   'yes'
=> '',

   'Visibly Separate Items on Pages'
=> '    ',

   '"[_1]" for visible separation'
=> '"[_1]"   ',

   'changes will not show until next login'
=> '       ',

   'Default Student Spreadsheet'
=> '   ',

   'Default Course Spreadsheet'
=> '   ',
 
   'Default Assessment Spreadsheet'
=> '     ',

   'Set Course Environment'
=> '  ',

   'Entering Construction Space'
=> '   ',

   'Go to ...'
=> '  ...',

   'Manual Grading'
=> '  ',

   'Current Resource'
=> ' ',

   'Select Section'
=> ' ',

   'For one or more students'
=> '    ',

   'Client IP/Name Access Control (acc)'
=> 'Client IP/Name Access Control (acc)', 

   'Click here for help'
=> '',

   'Dependencies'
=> '',

   'KEYWORDS'
=> ' ', 

   'check all'
=>  ' ',

   'uncheck all'
=> '  ',

   'use related words'
=> '  ',

   'only search domain'
=> '   ',

   'VIEW'
=> '',

   'between'
=> '',

   'and'
=> '',

   'username'
=> ' ',

   'domain'
=> '',

   'student name'
=> ' ',

   'section'
=> '',

   'How do I create a class list from a spreadsheet'
=> '      ',

   'How do I create a CSV file from a spreadsheet'
=> '   CSV   ',


# ----

   'calendar[_1]'
=> '',

   'announce[_1]'
=> 'announce',


# ----

   'commu-[_1]'
=> 'commu-',

   'nication[_1]'
=> 'nication',


# ----

   'course[_10]'
=> '',

   'chat[_1]'
=> 'chat',


# ----

   'search[_1]'
=> '',

   'course[_11]'
=> '',


# ----

   'search[_2]'
=> '',

   'library[_1]'
=> '',


# ----

   'prefer-[_1]'
=> 'prefer-',

   'ences[_1]'
=> 'ences',


# ----

   'exit[_1]'
=> '',

   ' [_1]'
=> '',


# ----

   'switch[_2]'
=> 'switch',

   'role[_1]'
=> '',


# ----

   'choose[_2]'
=> '',

   'role[_2]'
=> '',


# ----

   'choose[_1]'
=> '',

   'course[_1]'
=> '',


# ----

   'switch[_1]'
=> 'switch',

   'course[_2]'
=> '',


# ----

   'course[_3]'
=> '',

   'docs[_1]'
=> 'docs',


# ----

   'edit crs[_1]'
=> 'edit crs',

   'docs[_2]'
=> 'docs',


# ----

   'navigate[_1]'
=> 'navigate',

   'contents[_1]'
=> 'contents',


# ----

   'my[_1]'
=> '',

   'grades[_1]'
=> '',


# ----

   'course[_4]'
=> '',

   'grades[_2]'
=> '',


# ----

   'course[_5]'
=> '',

   'chart[_1]'
=> 'chart',


# ----

   'course[_6]'
=> '',

   'stats[_1]'
=> 'stats',


# ----

   'course[_7]'
=> '',

   'enroll[_1]'
=> '',


# ----

   'manage[_1]'
=> 'manage',

   'acc keys[_1]'
=> 'acc keys',


# ----

   'user[_1]'
=> '',

   'roles[_1]'
=> '',


# ----

   'user[_1]'
=> '',

   'roles[_1]'
=> '',


# ----

   'user[_1]'
=> '',

   'roles[_1]'
=> '',


# ----

   'create[_1]'
=> '',

   'course[_8]'
=> '',


# ----

   'course[_9]'
=> '',

   'parms[_1]'
=> 'parms',


# ----

   'con-[_1]'
=> 'con-',

   'struct[_1]'
=> 'struct',


# ----

   'co con-[_1]'
=> 'co con-',

   'struct[_2]'
=> 'struct',


# ----

   'resource[_1]'
=> '',

   'space[_1]'
=> '',


# ----

   'co res[_1]'
=> 'co res',

   'space[_2]'
=> '',


# ----

   'resource[_1]'
=> '',

   'space[_1]'
=> '',


# ----

   'enter[_1]'
=> '',

   'grades[_2]'
=> '',


# ----

   'send[_1]'
=> 'send',

   'scantron[_1]'
=> 'scantron',


# ----

   'view[_1]'
=> 'view',

   'bookmark[_1]'
=> '',



#SYNC Tue Aug 15 14:23:47 2006
   ' [_1]'
=> ' [_1]',

   '# [_1] is a drop-down selection box'
=> '# [_1] is a drop-down selection box',
# # [_1] is a drop-down ion box
   '# [_1] is a number [_2] is the current domain'
=> '# [_1] is a number [_2] is the current domain',
# # [_1] is a  [_2] is the  doma
   '# [_1] is an html link to the current file '
=> '# [_1] is an html link to the current file ',
# # [_1] is an HTML lk  the   
   '# _1 is a selection dialog'
=> '# _1 is a selection dialog',
# #1 is a ion dialog
   '# _1 is a server name'
=> '# _1 is a server name',
# #1 is a  
   '# _1 is search string'
=> '# _1 is search string',
# #1 is  strg
   "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'"
=> "# _1, _3, and _5 are link anchors, _2,_4, and _6 are '</a>'",
# #1,3, 5 aRe lk anchs,2,_4, 6 aRe '</a>'
   '#[_1] is the foil name'
=> '#[_1] is the foil name',
# #[_1] is the Foil 
   '#_1 is the foil name, _2 is the current value of the foil'
=> '#_1 is the foil name, _2 is the current value of the foil',
# #_1 is the Foil ,2 is the   of the Foil
   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)',
# ( maximum [_1] collabars usg     @doma, e.g. smithje  smithje@[_2].)
   '(Hand in a file you have prepared on your computer)'
=> '(Hand in a file you have prepared on your computer)',
# (H  a  you have pRepaRed on your computer)
   ', select a template from the pull-down menu below.'
=> ', select a template from the pull-down menu below.',
# ,    the pull-down menu below.
   '1 minute'
=> '1 minute',
# 1 mute
   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.',
# <*Response>s aRe both side of <>  outside of <>, this is t a valid , errs  gradg  occur.
   'Allowed filetypes: <b>[_1]</b>'
=> 'Allowed filetypes: <b>[_1]</b>',
# o s: <b>[_1]</b>
   'Analyzing Results'
=> 'Analyzing Results',
# Analyzg Results
   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Answer Submitted: Your final submission will be graded after the due date.',
#  ted: Your fal submission will be graded after the  .
   'Answerable'
=> 'Answerable',
# able
   'Cannot publish directory'
=> 'Cannot publish directory',
# Cant  diRecry
   'Cannot retrieve directory'
=> 'Cannot retrieve directory',
# Cant  diRecry
   'Changed discussion view mode'
=> 'Changed discussion view mode',
# d ion  mode
   'Click here for FAQ'
=> 'Click here for FAQ',
# Click heRe f FAQ
   'Click here to report bugs'
=> 'Click here to report bugs',
# Click heRe  Rept bugs
   'Click here to return to the chart.'
=> 'Click here to return to the chart.',
# Click heRe  Return  the chart.
   'Click-On Texts (comma sep):'
=> 'Click-On Texts (comma sep):',
# Click-On s (comma sep):
   'Closed'
=> 'Closed',
# d
   'Courses'
=> 'Courses',
# s
   'Create User'
=> 'Create User',
#  
   'Creating a new'
=> 'Creating a new',
# CReatg a new
   'Current Ending Date: [_1]'
=> 'Current Ending Date: [_1]',
#  g : [_1]
   'Current Ending Date: not set'
=> 'Current Ending Date: not set',
#  g : t 
   'Current Starting Date: [_1]'
=> 'Current Starting Date: [_1]',
#  g : [_1]
   'Current Starting Date: not set'
=> 'Current Starting Date: not set',
#  g : t 
   'Currently no active roles or courses'
=> 'Currently no active roles or courses',
# ly  active   s
   'Currently no additional roles or courses'
=> 'Currently no additional roles or courses',
# ly  additional   s
   'Currently submitted: <tt>[_1]</tt>'
=> 'Currently submitted: <tt>[_1]</tt>',
# ly ted: <tt>[_1]</tt>
   'Default:'
=> 'Default:',
#  :
   'Description:'
=> 'Description:',

   "Don't Show Feedback"
=> "Don't Show Feedback",

   'Dynamic Metadata (updated periodically)'
=> 'Dynamic Metadata (updated periodically)',
# Dynamic  ( )
   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.',
# Edir Errs - these errs might t effect the runng of the , but they will likely cause s with further use of the  mode. Please use the XML mode  fix these errs.
   'English - ISO'
=> 'English - ISO',

   'Evaluation Error '
=> 'Evaluation Error ',
# Evaluation Err 
   'Every problem in a particular folder'
=> 'Every problem in a particular folder',
# Every   a icular 
   'Exam Problem'
=> 'Exam Problem',
# Exam 
   'Exit'
=> 'Exit',
# 
   'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.'
=> 'Foil name <b><tt>[_1]</tt></b> appears more than once. Foil names need to be unique.',
# Foil  <b><tt>[_1]</tt></b> appears me than once. Foil s need  be unique.
   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Found a <*response> outside of a <part> in a <part>ed problem',
# Found a <*Response> outside of a <>  a <>ed 
   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.',
# Found  analyzable Respones  this , ly only Numerical, Fmula  Strg Response styles aRe spted.
   'German - ISO'
=> 'German - ISO',

   'Go'
=> 'Go',

   'Homework problem'
=> 'Homework problem',
# Homewk 
   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',
# terlgua (ternational Auxiliary  Association) - ISO
   'Invalid Significant figures detected'
=> 'Invalid Significant figures detected',
# valid Significant figuRes detected
   'Japanese - UTF'
=> 'Japanese - UTF',

   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'Leave blank on scoring form'
=> 'Leave blank on scoring form',
# Leave  on scg fm
   'Logout'
=> 'Logout',

   'Modify deadlines, etc, for this resource'
=> 'Modify deadlines, etc, for this resource',
# Modify deadles, etc, f this 
   'Must create new subdirectory inside a directory'
=> 'Must create new subdirectory inside a directory',
# Must  new subdiRecry side a diRecry
   'Next    '
=> 'Next    ',
#     
   'No Access or Usages Statistics are available for this resource.'
=> 'No Access or Usages Statistics are available for this resource.',
#  Access  Usages  aRe available f this .
   'No Assessment Statistical Data is available for this resource'
=> 'No Assessment Statistical Data is available for this resource',
#   Statistical Data is available f this 
   'No Evaluation Data is available for this resource.'
=> 'No Evaluation Data is available for this resource.',
#    is available f this .
   'Not applicable - '
=> 'Not applicable - ',
# t applicable - 
   'Not open to be viewed'
=> 'Not open to be viewed',
# t   be vie
   'Not set - '
=> 'Not set - ',
# t  - 
   'One particular problem'
=> 'One particular problem',
# One icular 
   'Online Help'
=> 'Online Help',
# Onle 
   'Open and correct'
=> 'Open and correct',
#   cRect
   'Open with full tries'
=> 'Open with full tries',
#  with full 
   'Output Format: [_1]'
=> 'Output Format: [_1]',
#  Fmat: [_1]
   'Please adjust significant figures.'
=> 'Please adjust significant figures.',

   'Please click Back on your browser and select another user, or '
=> 'Please click Back on your browser and select another user, or ',
# Please click Back on your bser  ther ,  
   'Please select a report to generate.'
=> 'Please select a report to generate.',
# Please  Rept  generate.
   'Please stand by.'
=> 'Please stand by.',
# Please st By.
   "Please use browser 'Back' button and pick a filename"
=> "Please use browser 'Back' button and pick a filename",
# Please use bser 'Back' butn  pick a 
   'Portuguese - ISO'
=> 'Portuguese - ISO',
# Ptuguese - ISO
   'Preparing Printout'
=> 'Preparing Printout',
# PReparg Prut
   'Reading results from [_1]'
=> 'Reading results from [_1]',
# Readg Results  [_1]
   'Receiving results from [_1]'
=> 'Receiving results from [_1]',
# Receivg Results  [_1]
   'Recent'
=> 'Recent',

   'Report a Bug'
=> 'Report a Bug',
# Rept a Bug
   'Response'
=> 'Response',

   'Retrieving current (most recent) version'
=> 'Retrieving current (most recent) version',
# Retrievg  () 
   'Return to DOCS'
=> 'Return to DOCS',
# Return  docs
   'Russian - KOI'
=> 'Russian - KOI',

   'Sample Points:'
=> 'Sample Points:',
# Sample Pots:
   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Save entries below as a draft answer (not submitting them for credit yet)',
#  en below as a draft  (t tg them f cr yet)
   'Search Complete [_1]'
=> 'Search Complete [_1]',
#  Complete [_1]
   'Search: [_1]'
=> 'Search: [_1]',
# : [_1]
   'Set opening date for all problems in the course for. . .'
=> 'Set opening date for all problems in the course for. . .',
#      f  s  the  f. . .
   'Set opening datefor all problems in the course for. . .'
=> 'Set opening datefor all problems in the course for. . .',
#     f  s  the  f. . .
   'Show Answer'
=> 'Show Answer',
# Show 
   'Show Feedback'
=> 'Show Feedback',

   'Show all rles'
=> 'Show all rles',
# Show  rles
   'Some items were not submitted'
=> 'Some items were not submitted',
# Some items weRe t ted
   'Student Sheet Links'
=> 'Student Sheet Links',
#  Sheet Lks
   'Student Status: [_1]'
=> 'Student Status: [_1]',
#  : [_1]
   'Submissions'
=> 'Submissions',

   'Submit entries below as answer to receive credit'
=> 'Submit entries below as answer to receive credit',
#  en below as   Receive cr
   'Survey Question'
=> 'Survey Question',

   'Swedish Chef'
=> 'Swedish Chef',
# Sish Chef
   'TeX unconverted due to errors'
=> 'TeX unconverted due to errors',
# TeX unconverted   errs
   'TeX unconverted due to previous errors'
=> 'TeX unconverted due to previous errors',
# TeX unconverted    errs
   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options',
# The question can t be gotten cRect, the followg Foils  the &lt;optionResponse&gt; have valid cRect options
   'The requested file'
=> 'The requested file',
# The Requested 
   'There are currently no Error Messages for this resource.'
=> 'There are currently no Error Messages for this resource.',
# TheRe aRe ly  Err Messages f this .
   'There are no Evaluation Comments on this resource.'
=> 'There are no Evaluation Comments on this resource.',
# TheRe aRe    on this .
   'There are no currently enrolled students in the course.'
=> 'There are no currently enrolled students in the course.',
# TheRe aRe  ly ed s  the .
   'There are no currently enrolled students in the selected sections.'
=> 'There are no currently enrolled students in the selected sections.',
# TheRe aRe  ly ed s  the ed s.
   'There are no previously enrolled students in the course.'
=> 'There are no previously enrolled students in the course.',
# TheRe aRe  ly ed s  the .
   'There are no previously enrolled students in the selected sections.'
=> 'There are no previously enrolled students in the selected sections.',
# TheRe aRe  ly ed s  the ed s.
   'There are no students in the course.'
=> 'There are no students in the course.',
# TheRe aRe  s  the .
   'There are no students in the selected sections.'
=> 'There are no students in the selected sections.',
# TheRe aRe  s  the ed s.
   'To create a new'
=> 'To create a new',
#   a new
   'Turkish - ISO'
=> 'Turkish - ISO',

   'Type-in value'
=> 'Type-in value',
# - 
   'Type:'
=> 'Type:',
# :
   'UNDISPLAYABLE'
=> 'UNDISPLAYABLE',
# UNABLE
   'Undetermined - ISO'
=> 'Undetermined - ISO',
# Undetermed - ISO
   'Upload file to Construction Space'
=> 'Upload file to Construction Space',
#    Construction 
   'View the FAQ'
=> 'View the FAQ',
#  the FAQ
   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',
# [_1] (       )
   '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])'
=> '[_1] Filesystem Authenticated (mit Anfangspasswort [_2])',
# [_1]  Auticated (mit Anfangspasswt [_2])
   '[_1] Internally authenticated (mit Anfangspasswort [_2])'
=> '[_1] Internally authenticated (mit Anfangspasswort [_2])',
# [_1] ly auticated (mit Anfangspasswt [_2])
   '[_1] Local Authentication with argument [_2]'
=> '[_1] Local Authentication with argument [_2]',
# [_1] Local Autication with argument [_2]
   '[_1] Records per Page'
=> '[_1] Records per Page',
# [_1] Recds  
   '[_1] minutes'
=> '[_1] minutes',
# [_1] 
   '[_1] minutes, [_2] seconds'
=> '[_1] minutes, [_2] seconds',
# [_1] , [_2] 
   '[_1] with value [_2]'
=> '[_1] with value [_2]',
# [_1] with  [_2]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# [_1]pRev[_2] &nbsp; [_3]Re[_4] &nbsp; [_5][_6]
   '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next'
=> '[_1]prev[_2] &nbsp; [_3]reload[_4] &nbsp; next',
# [_1]pRev[_2] &nbsp; [_3]Re[_4] &nbsp; 
   '[_2] seconds'
=> '[_2] seconds',
# [_2] 
   'anno-[_1]'
=> 'anno-[_1]',
# an-[_1]
   'anno.gif'
=> 'anno.gif',
# an.gif
   'anot.gif'
=> 'anot.gif',
# at.gif
   'backward[_1]'
=> 'backward[_1]',

   'bchat.gif'
=> 'bchat.gif',

   'bookmark[_2]'
=> 'bookmark[_2]',
# [_2]
   'button'
=> 'button',
# butn
   'by'
=> 'by',

   'catalog.gif'
=> 'catalog.gif',
# .gif
   'catalog[_1]'
=> 'catalog[_1]',
# [_1]
   'ccrs.gif'
=> 'ccrs.gif',

   'chrt.gif'
=> 'chrt.gif',

   'click on the'
=> 'click on the',

   'com.gif'
=> 'com.gif',

   'contacting [_1]'
=> 'contacting [_1]',
# g [_1]
   'courses.gif'
=> 'courses.gif',
# s.gif
   'cprv.gif'
=> 'cprv.gif',

   'cstr.gif'
=> 'cstr.gif',

   'currently does not exist'
=> 'currently does not exist',
# ly does t exist
   'custom'
=> 'custom',
# cusm
   'custom distribution file'
=> 'custom distribution file',
# cusm distribution 
   'discuss[_1]'
=> 'discuss[_1]',
# [_1]
   'docs.gif'
=> 'docs.gif',

   'egrd.gif'
=> 'egrd.gif',

   'enrl.gif'
=> 'enrl.gif',

   'eval.gif'
=> 'eval.gif',

   'evaluate[_1]'
=> 'evaluate[_1]',

   'fdbk.gif'
=> 'fdbk.gif',

   'feedback[_1]'
=> 'feedback[_1]',

   'file<br />extension'
=> 'file<br />extension',
# <br />
   'for visible separation'
=> 'for visible separation',
# f visible separation
   'forward[_1]'
=> 'forward[_1]',
# fward[_1]
   'grds.gif'
=> 'grds.gif',

   'is in this state by royal decree.'
=> 'is in this state by royal decree.',
# is  this state By royal decRee.
   'keys.gif'
=> 'keys.gif',

   'logout.gif'
=> 'logout.gif',

   'may be open from a different computer.'
=> 'may be open from a different computer.',
#  be   a diffeRent computer.
   'nav.gif'
=> 'nav.gif',

   'obsolete replacement'
=> 'obsolete replacement',
#  Replacement
   'parm.gif'
=> 'parm.gif',
# pa.m.gif
   'pref.gif'
=> 'pref.gif',

   'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]'
=> 'prev &nbsp; [_3]reload[_4] &nbsp; [_5]next[_6]',
# pRev &nbsp; [_3]Re[_4] &nbsp; [_5][_6]
   'private'
=> 'private',

   'prt.gif'
=> 'prt.gif',

   'public'
=> 'public',

   'publisher<br />owner'
=> 'publisher<br />owner',
# er<br />owner
   'res.gif'
=> 'res.gif',

   'roles.gif'
=> 'roles.gif',
# .gif
   'sbkm.gif'
=> 'sbkm.gif',

   'set[_1]'
=> 'set[_1]',
# [_1]
   'spacer.gif'
=> 'spacer.gif',
# r.gif
   'spellcheck_lang'
=> 'spellcheck_lang',

   'sprs.gif'
=> 'sprs.gif',

   'src.gif'
=> 'src.gif',

   'stat.gif'
=> 'stat.gif',

   'template'
=> 'template',
# 
   'vbkm.gif'
=> 'vbkm.gif',

   'waiting on [_1]'
=> 'waiting on [_1]',
# waitg on [_1]


#SYNC Tue Aug 15 14:43:22 2006
   '# 16 Aug 14:45'
=> '# 16 Aug 14:45',
# # [_1]6 Aug [_1]4:45
   'Enter my portfolio space'
=> 'Enter my portfolio space',
#   ptfolio 
   'No syllabus information provided.'
=> 'No syllabus information provided.',
#    fmation provided.
   'Post Discussion'
=> 'Post Discussion',
# Post ion
   'Sorry ...'
=> 'Sorry ...',
# Sry ...
   'This resource might be part of another course.'
=> 'This resource might be part of another course.',
# this  might be  of ather .


#SYNC Tue Aug 15 16:12:14 2006
   '# mt fehlt'
=> '# mt fehlt',

   'Agree'
=> 'Agree',

   'Any comments? '
=> 'Any comments? ',

   'Copy this column'
=> 'Copy this column',
# Copy this 
   'Disagree'
=> 'Disagree',

   'General Intro'
=> 'General Intro',
#  tro
   'Greek Symbols'
=> 'Greek Symbols',

   'HTML character enties'
=> 'HTML character enties',

   'Highest Grade Level'
=> 'Highest Grade Level',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.',
# If you aRe g this onle, copy  paste the   any of the right s  your  aRea  get the symbol on the left.
   'LON-CAPA Help'
=> 'LON-CAPA Help',
# LON-CAPA 
   'Landscape'
=> 'Landscape',
# Lscape
   'Launch navigation window'
=> 'Launch navigation window',
# Launch navigation wdow
   'Lowest Grade Level'
=> 'Lowest Grade Level',

   'Mark all posts read'
=> 'Mark all posts read',
# Mark  posts Read
   'My question/comment/feedback:'
=> 'My question/comment/feedback:',
#  question/comment/feedback:
   'Not set -'
=> 'Not set -',
# t  -
   'Other Symbols'
=> 'Other Symbols',

   'Please check at least one of the following feedback types:'
=> 'Please check at least one of the following feedback types:',
# Please check at least one of the followg feedback s:
   'Please rank the following criteria:'
=> 'Please rank the following criteria:',
# Please rank the followg criteria:
   'Portrait'
=> 'Portrait',
# Ptrait
   'Question about resource content'
=> 'Question about resource content',
# Question about  content
   'Question/Comment/Feedback about course policy'
=> 'Question/Comment/Feedback about course policy',
# Question/Comment/feedback about  policy
   'Select a Course to Enter'
=> 'Select a Course to Enter',
#    
   'Sending Messages'
=> 'Sending Messages',
# Sg Messages
   'Show Me My First Homework Problem'
=> 'Show Me My First Homework Problem',
# Show Me   Homewk 
   'Standards'
=> 'Standards',
# s
   'Strongly Agree'
=> 'Strongly Agree',

   'Strongly Disagree'
=> 'Strongly Disagree',

   'Symbol'
=> 'Symbol',

   'The material appears to be correct '
=> 'The material appears to be correct ',
# The material appears  be cRect 
   'The material is helpful '
=> 'The material is helpful ',
# The   
   'The material is presented in a clear way '
=> 'The material is presented in a clear way ',
# The material is pResented  a clear way 
   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) '
=> 'The resource is technically correct (loads fast enough, does not produce errors, links work, etc) ',
# The  is technicy cRect (s fast eugh, does t produce errs, lks wk, etc) 


#SYNC Tue Aug 15 18:55:42 2006


#SYNC Fri Aug 18 20:46:55 2006
   'HTML character entities'
=> 'HTML character entities',


#SYNCMARKER
);

1;

