#!/usr/bin/perl
# The LearningOnline Network
#
# $Id: cleanup_file_caches.pl,v 1.5 2007/04/20 22:00:40 banghart Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#################################################

=pod

=head1 NAME

cleanup_file_caches.pl - Remove temporary files from the LON-CAPA print
spool, the multidownload zip spool, and userfiles cache.

=head1 SYNOPSIS

cleanup_file_caches.pl deletes files from lonPrtDir, lonZipDir and
lonDocRoot/userfiles that have not been accessed in 24 hours.

=head1 DESCRIPTION

cleanup_file_caches.pl examines each file in lonPrtDir, lonZipDir and
lonDocRoot/userfiles and checks its last access time.  Those
files which have not been accessed in 24 hours are unlinked.

=cut

#################################################

use strict;
use lib '/home/httpd/lib/perl/';
use File::Find;
use File::stat;
use LONCAPA::Configuration;
my $conf = LONCAPA::Configuration::read_conf('loncapa.conf');
my $killtime = $conf->{'lonExpire'};
my $prt_spool_dir = $conf->{'lonPrtDir'};
my $zip_spool_dir = $conf->{'lonZipDir'};
my $userfile_dir = $conf->{'lonDocRoot'}.'/userfiles';
sub kill_if_old {
    my $filename = $File::Find::name;
    return if (! -f $filename); # We only want files
    my $inode = stat($filename);
    if ((time-$inode->atime) > $killtime) {
        unlink($filename);
    }
}

find (\&kill_if_old,$prt_spool_dir);
find (\&kill_if_old,$zip_spool_dir);
find (\&kill_if_old,$userfile_dir);
