/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;

class Sphere3D {
    Graphics3D g3d;
    static final int maxSphereCache = 128;
    static final int maxOddSizeSphere = 49;
    static int[][] sphereShapeCache = new int[128][];
    static boolean sphereShadingCalculated = false;
    static final byte[] sphereIntensities = new byte[65536];

    Sphere3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    void render(short colix, int diameter, int x, int y, int z) {
        int[] shades = this.g3d.getShades(colix);
        if (diameter >= 128) {
            this.renderLargeSphere(shades, diameter, x, y, z);
            return;
        }
        if (diameter > 49) {
            diameter &= 0xFFFFFFFE;
        }
        int radius = diameter + 1 >> 1;
        int minX = x - radius;
        int maxX = x + radius;
        int minY = y - radius;
        int maxY = y + radius;
        int minZ = z - radius;
        if (maxX < 0 || minX >= this.g3d.width || maxY < 0 || minY >= this.g3d.height || z < this.g3d.slab || minZ > this.g3d.depth) {
            return;
        }
        int[] ss = this.getSphereShape(diameter);
        if (minX < 0 || maxX >= this.g3d.width || minY < 0 || maxY >= this.g3d.height || minZ < this.g3d.slab || z > this.g3d.depth) {
            this.renderShapeClipped(shades, ss, diameter, x, y, z);
        } else {
            this.renderShapeUnclipped(shades, ss, diameter, x, y, z);
        }
    }

    void renderShapeUnclipped(int[] shades, int[] sphereShape, int diameter, int x, int y, int z) {
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int offsetSphere = 0;
        int width = this.g3d.width;
        int evenSizeCorrection = 1 - (diameter & 1);
        int offsetSouthCenter = width * y + x;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * width;
        int nLines = (diameter + 1) / 2;
        do {
            int packed;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            do {
                int zPixel;
                if ((zPixel = z - ((packed = sphereShape[offsetSphere++]) & 0x7F)) < zbuf[offsetSE]) {
                    zbuf[offsetSE] = (short)zPixel;
                    pbuf[offsetSE] = shades[packed >> 7 & 0x3F];
                }
                if (zPixel < zbuf[offsetSW]) {
                    zbuf[offsetSW] = (short)zPixel;
                    pbuf[offsetSW] = shades[packed >> 13 & 0x3F];
                }
                if (zPixel < zbuf[offsetNE]) {
                    zbuf[offsetNE] = (short)zPixel;
                    pbuf[offsetNE] = shades[packed >> 19 & 0x3F];
                }
                if (zPixel < zbuf[offsetNW]) {
                    zbuf[offsetNW] = (short)zPixel;
                    pbuf[offsetNW] = shades[packed >> 25 & 0x3F];
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
            } while (packed >= 0);
            offsetSouthCenter += width;
            offsetNorthCenter -= width;
        } while (--nLines > 0);
    }

    void renderShapeClipped(int[] shades, int[] sphereShape, int diameter, int x, int y, int z) {
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int offsetSphere = 0;
        int width = this.g3d.width;
        int height = this.g3d.height;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int evenSizeCorrection = 1 - (diameter & 1);
        int offsetSouthCenter = width * y + x;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * width;
        int nLines = (diameter + 1) / 2;
        int ySouth = y;
        int yNorth = y - evenSizeCorrection;
        do {
            int packed;
            boolean tSouthVisible = ySouth >= 0 && ySouth < height;
            boolean tNorthVisible = yNorth >= 0 && yNorth < height;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            int xEast = x;
            int xWest = x - evenSizeCorrection;
            do {
                int zPixel;
                boolean tWestVisible = xWest >= 0 && xWest < width;
                boolean tEastVisible = xEast >= 0 && xEast < width;
                if ((zPixel = z - ((packed = sphereShape[offsetSphere++]) & 0x7F)) >= slab && zPixel <= depth) {
                    if (tSouthVisible) {
                        if (tEastVisible && zPixel < zbuf[offsetSE]) {
                            zbuf[offsetSE] = (short)zPixel;
                            pbuf[offsetSE] = shades[packed >> 7 & 0x3F];
                        }
                        if (tWestVisible && zPixel < zbuf[offsetSW]) {
                            zbuf[offsetSW] = (short)zPixel;
                            pbuf[offsetSW] = shades[packed >> 13 & 0x3F];
                        }
                    }
                    if (tNorthVisible) {
                        if (tEastVisible && zPixel < zbuf[offsetNE]) {
                            zbuf[offsetNE] = (short)zPixel;
                            pbuf[offsetNE] = shades[packed >> 19 & 0x3F];
                        }
                        if (tWestVisible && zPixel < zbuf[offsetNW]) {
                            zbuf[offsetNW] = (short)zPixel;
                            pbuf[offsetNW] = shades[packed >> 25 & 0x3F];
                        }
                    }
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
                ++xEast;
                --xWest;
            } while (packed >= 0);
            offsetSouthCenter += width;
            offsetNorthCenter -= width;
            ++ySouth;
            --yNorth;
        } while (--nLines > 0);
    }

    int[] getSphereShape(int diameter) {
        int[] ss;
        if (diameter > 128) {
            diameter = 128;
        }
        if ((ss = sphereShapeCache[diameter - 1]) != null) {
            return ss;
        }
        int[] nArray = this.createSphereShape(diameter);
        Sphere3D.sphereShapeCache[diameter - 1] = nArray;
        ss = nArray;
        return ss;
    }

    static void flushImageCache() {
        sphereShapeCache = new int[128][];
    }

    int[] createSphereShape(int diameter) {
        int countSE = 0;
        boolean oddDiameter = (diameter & 1) != 0;
        float radiusF = (float)diameter / 2.0f;
        float radiusF2 = radiusF * radiusF;
        int radius = (diameter + 1) / 2;
        float y = oddDiameter ? 0.0f : 0.5f;
        int i = 0;
        while (i < radius) {
            float y2 = y * y;
            float x = oddDiameter ? 0.0f : 0.5f;
            int j = 0;
            while (j < radius) {
                float x2 = x * x;
                float z2 = radiusF2 - y2 - x2;
                if (z2 >= 0.0f) {
                    ++countSE;
                }
                ++j;
                x += 1.0f;
            }
            ++i;
            y += 1.0f;
        }
        int[] sphereShape = new int[countSE];
        int offset = 0;
        y = oddDiameter ? 0.0f : 0.5f;
        int i2 = 0;
        while (i2 < radius) {
            float y2 = y * y;
            float x = oddDiameter ? 0.0f : 0.5f;
            int j = 0;
            while (j < radius) {
                float x2 = x * x;
                float z2 = radiusF2 - y2 - x2;
                if (z2 >= 0.0f) {
                    float z = (float)Math.sqrt(z2);
                    int height = (int)z;
                    byte intensitySE = Shade3D.calcDitheredNoisyIntensity(x, y, z, radiusF);
                    byte intensitySW = Shade3D.calcDitheredNoisyIntensity(-x, y, z, radiusF);
                    byte intensityNE = Shade3D.calcDitheredNoisyIntensity(x, -y, z, radiusF);
                    byte intensityNW = Shade3D.calcDitheredNoisyIntensity(-x, -y, z, radiusF);
                    int packed = height | intensitySE << 7 | intensitySW << 13 | intensityNE << 19 | intensityNW << 25;
                    sphereShape[offset++] = packed;
                }
                ++j;
                x += 1.0f;
            }
            int n = offset - 1;
            sphereShape[n] = sphereShape[n] | Integer.MIN_VALUE;
            ++i2;
            y += 1.0f;
        }
        return sphereShape;
    }

    void calcSphereShading() {
        if (!sphereShadingCalculated) {
            float xF = -127.5f;
            for (int i = 0; i < 256; ++i) {
                float yF = -127.5f;
                for (int j = 0; j < 256; ++j) {
                    byte intensity = 0;
                    float z2 = 16900.0f - xF * xF - yF * yF;
                    if (z2 > 0.0f) {
                        float z = (float)Math.sqrt(z2);
                        intensity = Shade3D.calcDitheredNoisyIntensity(xF, yF, z, 130.0f);
                    }
                    Sphere3D.sphereIntensities[(j << 8) + i] = intensity;
                    yF += 1.0f;
                }
                xF += 1.0f;
            }
            sphereShadingCalculated = true;
        }
    }

    static byte calcSphereIntensity(int x, int y, int r) {
        int y8;
        int x8;
        int d = 2 * r + 1;
        if ((x += r) < 0) {
            x = 0;
        }
        if ((x8 = (x << 8) / d) > 255) {
            x8 = 255;
        }
        if ((y += r) < 0) {
            y = 0;
        }
        if ((y8 = (y << 8) / d) > 255) {
            y8 = 255;
        }
        return sphereIntensities[(y8 << 8) + x8];
    }

    void renderLargeSphere(int[] shades, int diameter, int x, int y, int z) {
        if (!sphereShadingCalculated) {
            this.calcSphereShading();
        }
        this.renderQuadrant(shades, diameter, x, y, z, -1, -1);
        this.renderQuadrant(shades, diameter, x, y, z, -1, 1);
        this.renderQuadrant(shades, diameter, x, y, z, 1, -1);
        this.renderQuadrant(shades, diameter, x, y, z, 1, 1);
    }

    void renderQuadrant(int[] shades, int diameter, int x, int y, int z, int xSign, int ySign) {
        int z2Status;
        int xStatus;
        int n = x < 0 ? -1 : (xStatus = x < this.g3d.width ? 0 : 1);
        int yStatus = y < 0 ? -1 : (y < this.g3d.height ? 0 : 1);
        boolean zStatus = z >= this.g3d.depth;
        int r = diameter / 2;
        int x2 = x + r * xSign;
        int x2Status = x2 < 0 ? -1 : (x2 < this.g3d.width ? 0 : 1);
        int y2 = y + r * ySign;
        int y2Status = y2 < 0 ? -1 : (y2 < this.g3d.height ? 0 : 1);
        int n2 = z2Status = z < this.g3d.slab ? -1 : 0;
        if (xStatus < 0 && x2Status < 0 || xStatus > 0 && x2Status > 0 || yStatus < 0 && y2Status < 0 || yStatus > 0 && y2Status > 0) {
            return;
        }
        if (xStatus == 0 && x2Status == 0 && yStatus == 0 && y2Status == 0 && !zStatus && z2Status == 0) {
            this.renderQuadrantUnclipped(shades, diameter, x, y, z, xSign, ySign);
        } else {
            this.renderQuadrantClipped(shades, diameter, x, y, z, xSign, ySign);
        }
    }

    void renderQuadrantUnclipped(int[] shades, int diameter, int x, int y, int z, int xSign, int ySign) {
        int r = diameter / 2;
        int r2 = r * r;
        int dDivisor = r * 2 + 1;
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int width = this.g3d.width;
        int offsetPbufBeginLine = width * y + x;
        if (ySign < 0) {
            width = -width;
        }
        offsetPbufBeginLine -= width;
        int i = 0;
        int i2 = 0;
        while (i2 <= r2) {
            int offsetPbuf = (offsetPbufBeginLine += width) - xSign;
            int s2 = r2 - i2;
            int z0 = z - r;
            int y8 = (i * ySign + r << 8) / dDivisor;
            int j = 0;
            int j2 = 0;
            while (j2 <= s2) {
                int k;
                if (zbuf[offsetPbuf += xSign] > z0 && zbuf[offsetPbuf] > (z0 = z - (k = (int)Math.sqrt(s2 - j2)))) {
                    int x8 = (j * xSign + r << 8) / dDivisor;
                    pbuf[offsetPbuf] = shades[sphereIntensities[(y8 << 8) + x8]];
                    zbuf[offsetPbuf] = (short)z0;
                }
                j2 += j + j + 1;
                ++j;
            }
            i2 += i + i + 1;
            ++i;
        }
    }

    void renderQuadrantClipped(int[] shades, int diameter, int x, int y, int z, int xSign, int ySign) {
        int r = diameter / 2;
        int r2 = r * r;
        int dDivisor = r * 2 + 1;
        int[] pbuf = this.g3d.pbuf;
        short[] zbuf = this.g3d.zbuf;
        int slab = this.g3d.slab;
        int depth = this.g3d.depth;
        int height = this.g3d.height;
        int width = this.g3d.width;
        int offsetPbufBeginLine = width * y + x;
        int lineIncrement = width;
        if (ySign < 0) {
            lineIncrement = -width;
        }
        int yCurrent = y - ySign;
        int i = 0;
        int i2 = 0;
        while (i2 <= r2) {
            if ((yCurrent += ySign) < 0) {
                if (ySign < 0) {
                    return;
                }
            } else if (yCurrent >= height) {
                if (ySign > 0) {
                    return;
                }
            } else {
                int offsetPbuf = offsetPbufBeginLine;
                int s2 = r2 - i2;
                int z0 = z - r;
                int xCurrent = x - xSign;
                int y8 = (i * ySign + r << 8) / dDivisor;
                int j = 0;
                int j2 = 0;
                while (j2 <= s2) {
                    int k;
                    if ((xCurrent += xSign) < 0) {
                        if (xSign < 0) {
                            break;
                        }
                    } else if (xCurrent >= width) {
                        if (xSign > 0) {
                            break;
                        }
                    } else if (zbuf[offsetPbuf] > z0 && (z0 = z - (k = (int)Math.sqrt(s2 - j2))) >= slab && z0 <= depth && zbuf[offsetPbuf] > z0) {
                        int x8 = (j * xSign + r << 8) / dDivisor;
                        pbuf[offsetPbuf] = shades[sphereIntensities[(y8 << 8) + x8]];
                        zbuf[offsetPbuf] = (short)z0;
                    }
                    j2 += j + j + 1;
                    ++j;
                    offsetPbuf += xSign;
                }
            }
            i2 += i + i + 1;
            ++i;
            offsetPbufBeginLine += lineIncrement;
        }
    }
}

