#!/usr/bin/perl
#
#
# Copyright Michigan State University Board of Trustees
# $Id
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/cgi-bin/decompress.pl
#
# http://www.lon-capa.org/
#
# The LearningOnline Network with CAPA
#
# A CGI script that decompresses compressed files for mass uploading into
# construction space
####
use strict;
use lib '/home/httpd/lib/perl';
use LONCAPA::loncgi;

my %location_of;
foreach my $program ('tar','gunzip','bunzip2','unzip') {
    foreach my $dir ('/bin/','/usr/bin/','/usr/local/bin/','/sbin/',
		     '/usr/sbin/') {
	if (-x $dir.$program) {
	    $location_of{$program} = $dir.$program;
	}
    }
}

if (!&LONCAPA::loncgi::check_cookie_and_load_env()) {
    print("Content-type: text/html\n\n");
    print(<<END);
    <html><body>NO COOKIE!</body></html>
END
} else {
    print "Content-type: text/html\n\n";
    my $file=$Apache::lonnet::env{'cgi.file'};
    my $dir=$Apache::lonnet::env{'cgi.dir'}; 
    if(! $file || ! $dir) {
        print(<<END);
        <html><body>Bad Enviroment!</body></html>
END
    } else {
        print(<<END);
	<html><body><p><b>Output of decompress:</b></p>
END
        chdir($dir);
	my @cmd;
        if ($file =~ m|\.zip$|) {
            @cmd = ($location_of{'unzip'},"-o");
        } elsif ($file =~ m|\.tar\.gz$|
		 || $file =~ m|\.tgz$| ) {
            @cmd = ($location_of{'tar'},"-zxpvf");
        } elsif ($file =~ m|\.tar\.bz2$|) {
            @cmd = ($location_of{'tar'},"-jxpvf");
        } elsif ($file =~ m|\.bz2$|) {
            @cmd = ($location_of{'bunzip2'});
        } elsif ($file =~ m|\.gz$|) {
	    @cmd = ($location_of{'gunzip'});
        } elsif ($file =~ m|\.tar$|) {
            @cmd = ($location_of{'tar'},"-xpvf");
        } else {
            print("There has been an error in determining the file type of $file, please check name");
        }
	if (@cmd) {
	    undef($!);
	    undef($@);
	    open(OUTPUT,"-|", @cmd, $file);
	    while (my $line = <OUTPUT>) { print("$line<br />"); }
	    close(OUTPUT);
	    print("<p><b>Decompress complete.</b></p>");
	    if ($! || $@) {
		print("<p><b>An error occurred</b></p><p>$!</p><p>$@</p>");
	    }
	    print("</body></html>");
	}
    }
}

