use strict;
use IO::File;

sub get_scantron_config {
    my ($which) = @_;
    my $fh=IO::File->new('scantronformat.tab');
    my %config;
    #FIXME probably should move to XML it has already gotten a bit much now
    foreach my $line (<$fh>) {
	my ($name,$descrip)=split(/:/,$line);
	print ($name ."\n".$which."\n");
	if ($name ne $which ) { next; }
	chomp($line);
	my @config=split(/:/,$line);
	$config{'name'}=$config[0];
	$config{'description'}=$config[1];
	$config{'CODElocation'}=$config[2];
	$config{'CODEstart'}=$config[3];
	$config{'CODElength'}=$config[4];
	$config{'IDstart'}=$config[5];
	$config{'IDlength'}=$config[6];
	$config{'Qstart'}=$config[7];
	$config{'Qlength'}=$config[8];
	$config{'Qoff'}=$config[9];
	$config{'Qon'}=$config[10];
	$config{'PaperID'}=$config[11];
	$config{'PaperIDlength'}=$config[12];
	$config{'FirstName'}=$config[13];
	$config{'FirstNamelength'}=$config[14];
	$config{'LastName'}=$config[15];
	$config{'LastNamelength'}=$config[16];
	last;
    }
    return %config;
}

sub scantron_parse_scanline {
    my ($line,$whichline,$scantron_config)=@_;
    my %record;
    my $questions=substr($line,$$scantron_config{'Qstart'}-1);
    my $data=substr($line,0,$$scantron_config{'Qstart'}-1);
    if ($$scantron_config{'CODElocation'} ne 0) {
	if ($$scantron_config{'CODElocation'} < 0) {
	    $record{'scantron.CODE'}=substr($data,$$scantron_config{'CODEstart'}-1,
					    $$scantron_config{'CODElength'});
	} else {
	    #FIXME interpret first N questions
	}
    }
    $record{'scantron.ID'}=substr($data,$$scantron_config{'IDstart'}-1,
				  $$scantron_config{'IDlength'});
    $record{'scantron.PaperID'}=
	substr($data,$$scantron_config{'PaperID'}-1,
	       $$scantron_config{'PaperIDlength'});
    $record{'scantron.FirstName'}=
	substr($data,$$scantron_config{'FirstName'}-1,
	       $$scantron_config{'FirstNamelength'});
    $record{'scantron.LastName'}=
	substr($data,$$scantron_config{'LastName'}-1,
	       $$scantron_config{'LastNamelength'});
    my @alphabet=('A'..'Z');
    my $questnum=0;
    while ($questions) {
	$questnum++;
	my $currentquest=substr($questions,0,$$scantron_config{'Qlength'});
	substr($questions,0,$$scantron_config{'Qlength'})='';
	if (length($currentquest) < $$scantron_config{'Qlength'}) { next; }
	my @array=split($$scantron_config{'Qon'},$currentquest,-1);
	if (length($array[0]) eq $$scantron_config{'Qlength'}) {
	    $record{"scantron.$questnum.answer"}='';
	} else {
	    $record{"scantron.$questnum.answer"}=$alphabet[length($array[0])];
	}
 	if (scalar(@array) gt 2) {
 	    push(@{$record{'scantron.doubleerror'}},$questnum);
 	    my @ans=@array;
 	    my $i=length($ans[0]);shift(@ans);
	    while ($#ans) {
 		$i+=length($ans[0])+1;
 		$record{"scantron.$questnum.answer"}.=$alphabet[$i];
 		shift(@ans);
 	    }
 	}
    }
    $record{'scantron.maxquest'}=$questnum;
    return \%record;
}

sub print_record {
    my ($scan_record)=@_;
    print "Name: ".$scan_record->{'scantron.LastName'};
    print "  ID: ".$scan_record->{'scantron.ID'};
    print "  Paper ID: ".$scan_record->{'scantron.PaperID'};
    print "\n";
    for (my $i=1;$i<100;$i++) {
	if (!exists($scan_record->{"scantron.$i.answer"})) {
	    print "\n";
	    return;
	}
	if ($scan_record->{"scantron.$i.answer"} eq '') {
	    print " ";
	} else {
	    print $scan_record->{"scantron.$i.answer"};
	}
    }
}

open(FILE,'scantron.data');
my %scantron_config=&get_scantron_config('msunocode');
print(join(':',%scantron_config)."\n");
my $i=0;
while (my $line=<FILE>) {
    my $scan_record=&scantron_parse_scanline($line,$i,\%scantron_config);
    $i++;
    print_record($scan_record);
}
