#!/usr/bin/perl
#
# The LearningOnline Network
#
# - propagate the ids in ids.db to all course classlists
#
# $Id: updateclasslist.pl,v 1.3 2006/07/05 21:34:20 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#################################################
use strict;
BEGIN {
    eval "use Apache2::compat;";
}
use lib '/home/httpd/lib/perl';
use Apache::lonnet;
use Apache::loncoursedata;
use LONCAPA::Configuration;
use File::Find;

my $perlvar = LONCAPA::Configuration::read_conf('loncapa.conf');
my $ver=&get_loncapa_version();

&main();

sub main {
    my @domains = &Apache::lonnet::current_machine_domains();
    my @hostids = &Apache::lonnet::current_machine_ids();
    foreach my $dom (sort(@domains)) {
	my %courses = 
	    &Apache::lonnet::courseiddump($dom,'.',1,'.','.','.',1,\@hostids);
	my $total = scalar(keys(%courses));
	print("Found $total to do\n");
	my $i=0;
	foreach my $course (keys(%courses)) {
	    $i++;
	    print("Done $i/$total\n");
	    my ($cdom,$cnum) = split('_',$course);
	    my $classlist = ($ver =~ /^2\.0/) 
		? &Apache::loncoursedata::get_classlist($cdom.'_'.$cnum,$cdom,$cnum)
		: &Apache::loncoursedata::get_classlist($cdom,$cnum);

	    foreach my $user (keys(%{ $classlist })) {
		my ($uname,$udom) = split(':',$user);
		my %info=&Apache::lonnet::get('environment',['id'],
					      $udom, $uname);
		my $id=$info{'id'};
		my $cur_id = $classlist->{$user}[&Apache::loncoursedata::CL_ID()];
		if (defined($id) && $id ne $cur_id) {
		    print("needs update $user -- $id <- $cur_id\n");
		    my $enrolldata = join(':',
					  $classlist->{$user}[&Apache::loncoursedata::CL_END()],
					  $classlist->{$user}[&Apache::loncoursedata::CL_START()],
					  $id,
					  $classlist->{$user}[&Apache::loncoursedata::CL_SECTION()],
					  $classlist->{$user}[&Apache::loncoursedata::CL_FULLNAME()]);
		    my $reply=&Apache::lonnet::cput('classlist',
						    {$user => $enrolldata},
						    $cdom,$cnum);
		}
	    } 
	}
    }
}
exit;

######################################
sub unescape {
    my $str=shift;
    $str =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
    return $str;
}
sub get_loncapa_version {
    open(REL,'</etc/loncapa-release');
    my $line = <REL>;
    $line =~ s/LON\-CAPA release//;
    $line =~ s/-\d+//;
    $line =~ s/\s//g;
    return $line;
}
