# The LearningOnline Network with CAPA
# external style responses
#
# $Id: externalresponse.pm,v 1.7 2007/04/18 00:19:37 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::externalresponse;
use strict;
use HTTP::Request::Common;
use Apache::loncapagrade;
use Apache::lonnet;

BEGIN {
    &Apache::lonxml::register('Apache::externalresponse',('externalresponse'));
}

#FIXME
# send of response params and there current values
# accept a string to be printed out (Where does it get shown?) (.message)
# need to get a correct answer from somewhere (probably here since randomized)
sub start_externalresponse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    my $id = &Apache::response::start_response($parstack,$safeeval);
    return $result;
}

sub end_externalresponse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    my $part=$Apache::inputtags::part;
    my $id = $Apache::inputtags::response['-1'];
    my $increment     = 1;
    if ($target eq 'grade') {
	if (  &Apache::response::submitted('scantron') ) {
	    my $increment=&Apache::response::scored_response($part,$id);
	} elsif ( &Apache::response::submitted() ) {
	    my $response = &Apache::response::getresponse();
	    if ( $response =~ /[^\s]/) {
		my $url = &Apache::lonxml::get_param('url',$parstack,$safeeval);
		my $answer = &Apache::lonxml::get_param('answer',$parstack,$safeeval);
		my %form = &Apache::lonxml::get_param_var('form',$parstack,$safeeval);
		$form{'LONCAPA_student_response'}=$response;
		$form{'LONCAPA_correct_answer'}=$answer;
		$form{'LONCAPA_language'}=
		    &Apache::lonnet::metadata($ENV{'REQUEST_URI'},'language');
		&Apache::lonxml::debug("Asking $url, with:");
		&Apache::lonhomework::showhash(%form);
		my $ua = LWP::UserAgent->new;
		my $res = $ua->request(POST $url, \%form);
		my %previous = &Apache::response::check_for_previous($response,
								     $part,$id);
		%Apache::loncapagrade::results=();
		$Apache::lonhomework::results{"resource.$part.$id.submission"}=$response;
		if ($res->{_rc} != '200') {
		    $Apache::loncapagrade::results{'awarddetail'}='ERROR';
		} else {
		    &Apache::lonxml::register('Apache::loncapagrade',
					      ('loncapagrade'));
		    my $result=&Apache::scripttag::xmlparse($res->{_content});
		    &Apache::lonxml::debug("Got a result of :$result:");
		}
		foreach my $key (keys(%Apache::loncapagrade::results)) {
		    $Apache::lonhomework::results{"resource.$part.$id.$key"}=
			$Apache::loncapagrade::results{$key};
		}
		&Apache::response::handle_previous(\%previous,
						   $Apache::loncapagrade::results{'awarddetail'});
		&Apache::lonxml::debug("response of");
		&Apache::lonhomework::showhash(%$res);
		&Apache::lonxml::debug("capagrade of");
		&Apache::lonhomework::showhash(%Apache::loncapagrade::results);
		&Apache::lonxml::debug("results of");
		&Apache::lonhomework::showhash(%Apache::lonhomework::results);
	    }
	}
    }
    if ($target eq 'web') {
	&Apache::response::setup_prior_tries_hash(\&format_prior_response);
    }

    if ($target eq 'grade' || $target eq 'web' || $target eq 'answer' ||
	$target eq 'tex' || $target eq 'analyze') {
	&Apache::lonxml::increment_counter($increment);
    }
    &Apache::response::end_response();
    return $result;
}

sub format_prior_response {
    my ($mode,$answer) =@_;
    return '<span class="LC_prior_external">'.
	    &HTML::Entities::encode($answer,'"<>&').'</span>';
}

1;
__END__


