/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.lang.reflect.Array;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;

abstract class AtomSetCollectionReader {
    AtomSetCollection atomSetCollection;
    JmolAdapter.Logger logger;
    int ichNextParse;
    static float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f};
    static float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};

    AtomSetCollectionReader() {
    }

    void setLogger(JmolAdapter.Logger logger) {
        this.logger = logger;
    }

    void initialize() {
    }

    abstract AtomSetCollection readAtomSetCollection(BufferedReader var1) throws Exception;

    float parseFloat(String str) {
        return this.parseFloatChecked(str, 0, str.length());
    }

    float parseFloat(String str, int ich) {
        int cch = str.length();
        if (ich >= cch) {
            return Float.NaN;
        }
        return this.parseFloatChecked(str, ich, cch);
    }

    float parseFloat(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (ichStart >= ichMax) {
            return Float.NaN;
        }
        return this.parseFloatChecked(str, ichStart, ichMax);
    }

    float parseFloatChecked(String str, int ichStart, int ichMax) {
        char ch;
        int ich;
        boolean digitSeen = false;
        float value = 0.0f;
        for (ich = ichStart; ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t'); ++ich) {
        }
        boolean negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            ++ich;
            negative = true;
        }
        ch = '\u0000';
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10.0f + (float)(ch - 48);
            ++ich;
            digitSeen = true;
        }
        if (ch == '.') {
            int iscale = 0;
            while (++ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
                if (iscale < decimalScale.length) {
                    value += (float)(ch - 48) * decimalScale[iscale];
                }
                ++iscale;
                digitSeen = true;
            }
        }
        if (!digitSeen) {
            value = Float.NaN;
        } else if (negative) {
            value = -value;
        }
        if (ich < ichMax && (ch == 'E' || ch == 'e')) {
            if (++ich >= ichMax) {
                return Float.NaN;
            }
            ch = str.charAt(ich);
            if (ch == '+' && ++ich >= ichMax) {
                return Float.NaN;
            }
            int exponent = this.parseIntChecked(str, ich, ichMax);
            if (exponent == Integer.MIN_VALUE) {
                return Float.NaN;
            }
            if (exponent > 0) {
                value = (float)((double)value * (exponent < tensScale.length ? (double)tensScale[exponent - 1] : Math.pow(10.0, exponent)));
            } else if (exponent < 0) {
                value = (float)((double)value * (-exponent < decimalScale.length ? (double)decimalScale[-exponent - 1] : Math.pow(10.0, exponent)));
            }
        } else {
            this.ichNextParse = ich;
        }
        return value;
    }

    int parseInt(String str) {
        return this.parseIntChecked(str, 0, str.length());
    }

    int parseInt(String str, int ich) {
        int cch = str.length();
        if (ich >= cch) {
            return Integer.MIN_VALUE;
        }
        return this.parseIntChecked(str, ich, cch);
    }

    int parseInt(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (ichStart >= ichMax) {
            return Integer.MIN_VALUE;
        }
        return this.parseIntChecked(str, ichStart, ichMax);
    }

    int parseIntChecked(String str, int ichStart, int ichMax) {
        char ch;
        int ich;
        boolean digitSeen = false;
        int value = 0;
        for (ich = ichStart; ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t'); ++ich) {
        }
        boolean negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            negative = true;
            ++ich;
        }
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10 + (ch - 48);
            digitSeen = true;
            ++ich;
        }
        if (!digitSeen) {
            value = Integer.MIN_VALUE;
        } else if (negative) {
            value = -value;
        }
        this.ichNextParse = ich;
        return value;
    }

    String[] getTokens(String line) {
        return this.getTokens(line, 0);
    }

    String[] getTokens(String line, int ich) {
        if (line == null) {
            return null;
        }
        int cchLine = line.length();
        if (ich > cchLine) {
            return null;
        }
        int tokenCount = this.countTokens(line, ich);
        String[] tokens = new String[tokenCount];
        this.ichNextParse = ich;
        for (int i = 0; i < tokenCount; ++i) {
            tokens[i] = this.parseTokenChecked(line, this.ichNextParse, cchLine);
        }
        return tokens;
    }

    int countTokens(String line, int ich) {
        int tokenCount = 0;
        if (line != null) {
            int ichMax = line.length();
            while (true) {
                char ch;
                if (ich < ichMax && ((ch = line.charAt(ich)) == ' ' || ch == '\t')) {
                    ++ich;
                    continue;
                }
                if (ich == ichMax) break;
                ++tokenCount;
                while (++ich < ichMax && (ch = line.charAt(ich)) != ' ' && ch != '\t') {
                }
            }
        }
        return tokenCount;
    }

    String parseToken(String str) {
        return this.parseTokenChecked(str, 0, str.length());
    }

    String parseToken(String str, int ich) {
        int cch = str.length();
        if (ich >= cch) {
            return null;
        }
        return this.parseTokenChecked(str, ich, cch);
    }

    String parseToken(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (ichStart >= ichMax) {
            return null;
        }
        return this.parseTokenChecked(str, ichStart, ichMax);
    }

    String parseTokenChecked(String str, int ichStart, int ichMax) {
        char ch;
        int ich;
        for (ich = ichStart; ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t'); ++ich) {
        }
        int ichNonWhite = ich;
        while (ich < ichMax && (ch = str.charAt(ich)) != ' ' && ch != '\t') {
            ++ich;
        }
        this.ichNextParse = ich;
        if (ichNonWhite == ich) {
            return null;
        }
        return str.substring(ichNonWhite, ich);
    }

    String parseTrimmed(String str) {
        return this.parseTrimmedChecked(str, 0, str.length());
    }

    String parseTrimmed(String str, int ich) {
        int cch = str.length();
        if (ich >= cch) {
            return null;
        }
        return this.parseTrimmedChecked(str, ich, cch);
    }

    String parseTrimmed(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (ichStart >= ichMax) {
            return null;
        }
        return this.parseTrimmedChecked(str, ichStart, ichMax);
    }

    String parseTrimmedChecked(String str, int ichStart, int ichMax) {
        int ichLast;
        char ch;
        int ich;
        for (ich = ichStart; ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t'); ++ich) {
        }
        for (ichLast = ichMax - 1; ichLast >= ich && ((ch = str.charAt(ichLast)) == ' ' || ch == '\t'); --ichLast) {
        }
        if (ichLast < ich) {
            return null;
        }
        this.ichNextParse = ichLast + 1;
        return str.substring(ich, ichLast + 1);
    }

    static int[] doubleLength(int[] array) {
        return AtomSetCollectionReader.setLength(array, array.length * 2);
    }

    static String[] doubleLength(String[] array) {
        return AtomSetCollectionReader.setLength(array, array.length * 2);
    }

    static Object doubleLength(Object[] array) {
        return AtomSetCollectionReader.setLength(array, array.length * 2);
    }

    static Object setLength(Object array, int newLength) {
        Object t = Array.newInstance(array.getClass().getComponentType(), newLength);
        int oldLength = Array.getLength(array);
        System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        return t;
    }

    static String[] setLength(String[] array, int newLength) {
        String[] t = new String[newLength];
        if (array != null) {
            int oldLength = array.length;
            System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        }
        return t;
    }

    static int[] setLength(int[] array, int newLength) {
        int oldLength = array.length;
        int[] t = new int[newLength];
        System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        return t;
    }

    static float[] setLength(float[] array, int newLength) {
        int oldLength = array.length;
        float[] t = new float[newLength];
        System.arraycopy(array, 0, t, 0, oldLength < newLength ? oldLength : newLength);
        return t;
    }

    void discardLines(BufferedReader reader, int nLines) throws Exception {
        int i = nLines;
        while (--i >= 0) {
            reader.readLine();
        }
    }

    String discardLinesUntilStartsWith(BufferedReader reader, String startsWith) throws Exception {
        String line;
        while ((line = reader.readLine()) != null && !line.startsWith(startsWith)) {
        }
        return line;
    }

    String discardLinesUntilContains(BufferedReader reader, String containsMatch) throws Exception {
        String line;
        while ((line = reader.readLine()) != null && line.indexOf(containsMatch) < 0) {
        }
        return line;
    }

    void discardLinesUntilBlank(BufferedReader reader) throws Exception {
        String line;
        while ((line = reader.readLine()) != null && line.length() != 0) {
        }
    }

    String discardLinesUntilNonBlank(BufferedReader reader) throws Exception {
        String line;
        while ((line = reader.readLine()) != null && line.length() == 0) {
        }
        return line;
    }
}

