/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

class Triangle3D {
    Graphics3D g3d;
    int[] ax = new int[4];
    int[] ay = new int[4];
    int[] az = new int[4];
    int[] axW = new int[32];
    int[] azW = new int[32];
    int[] axE = new int[32];
    int[] azE = new int[32];

    Triangle3D(Graphics3D g3d) {
        this.g3d = g3d;
    }

    void fillTriangleNoisy() {
        int dyMidMin;
        int iMaxY;
        int iMidY;
        int iMinY = 0;
        if (this.ay[1] < this.ay[0]) {
            iMinY = 1;
        }
        if (this.ay[2] < this.ay[iMinY]) {
            iMinY = 2;
        }
        if (this.ay[iMidY = (iMinY + 1) % 3] > this.ay[iMaxY = (iMinY + 2) % 3]) {
            int t = iMidY;
            iMidY = iMaxY;
            iMaxY = t;
        }
        int yMin = this.ay[iMinY];
        int yMid = this.ay[iMidY];
        int yMax = this.ay[iMaxY];
        int nLines = yMax - yMin + 1;
        if (nLines > this.axW.length) {
            this.reallocRasterArrays(nLines);
        }
        if ((dyMidMin = yMid - yMin) == 0) {
            if (this.ax[iMidY] < this.ax[iMinY]) {
                int t = iMidY;
                iMidY = iMinY;
                iMinY = t;
            }
            this.generateRaster(nLines, iMinY, iMaxY, this.axW, this.azW, 0);
            this.generateRaster(nLines, iMidY, iMaxY, this.axE, this.azE, 0);
        } else if (yMid == yMax) {
            if (this.ax[iMaxY] < this.ax[iMidY]) {
                int t = iMidY;
                iMidY = iMaxY;
                iMaxY = t;
            }
            this.generateRaster(nLines, iMinY, iMidY, this.axW, this.azW, 0);
            this.generateRaster(nLines, iMinY, iMaxY, this.axE, this.azE, 0);
        } else {
            int axSplit;
            int dxMaxMin = this.ax[iMaxY] - this.ax[iMinY];
            int roundFactor = nLines / 2;
            if (dxMaxMin < 0) {
                roundFactor = -roundFactor;
            }
            if ((axSplit = this.ax[iMinY] + (dxMaxMin * dyMidMin + roundFactor) / nLines) < this.ax[iMidY]) {
                this.generateRaster(nLines, iMinY, iMaxY, this.axW, this.azW, 0);
                this.generateRaster(dyMidMin, iMinY, iMidY, this.axE, this.azE, 0);
                this.generateRaster(nLines - dyMidMin, iMidY, iMaxY, this.axE, this.azE, dyMidMin);
            } else {
                this.generateRaster(dyMidMin, iMinY, iMidY, this.axW, this.azW, 0);
                this.generateRaster(nLines - dyMidMin, iMidY, iMaxY, this.axW, this.azW, dyMidMin);
                this.generateRaster(nLines, iMinY, iMaxY, this.axE, this.azE, 0);
            }
        }
        this.fillRaster(yMin, nLines);
    }

    void reallocRasterArrays(int n) {
        n = n + 31 & 0xFFFFFFE0;
        this.axW = new int[n];
        this.azW = new int[n];
        this.axE = new int[n];
        this.azE = new int[n];
    }

    void generateRaster(int dy, int iN, int iS, int[] axRaster, int[] azRaster, int iRaster) {
        int xMajorError;
        int xMajorIncrement;
        int errorTerm;
        int width;
        int xIncrement;
        int xN = this.ax[iN];
        int zN = this.az[iN];
        int xS = this.ax[iS];
        int zS = this.az[iS];
        int dx = xS - xN;
        int dz = zS - zN;
        int xCurrent = xN;
        if (dx >= 0) {
            xIncrement = 1;
            width = dx;
            errorTerm = 0;
        } else {
            xIncrement = -1;
            width = -dx;
            errorTerm = -dy + 1;
        }
        int zCurrentScaled = (zN << 10) + 512;
        int roundingFactor = dy / 2;
        if (dz < 0) {
            roundingFactor = -roundingFactor;
        }
        int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
        if (dy >= width) {
            xMajorIncrement = 0;
            xMajorError = width;
        } else {
            xMajorIncrement = dx / dy;
            xMajorError = width % dy;
        }
        int y = 0;
        while (y < dy) {
            axRaster[iRaster] = xCurrent;
            azRaster[iRaster++] = zCurrentScaled >> 10;
            xCurrent += xMajorIncrement;
            if ((errorTerm += xMajorError) > 0) {
                xCurrent += xIncrement;
                errorTerm -= dy;
            }
            ++y;
            zCurrentScaled += zIncrementScaled;
        }
    }

    void fillRaster(int y, int numLines) {
        int i = 0;
        if (y < 0) {
            numLines += y;
            i -= y;
            y = 0;
        }
        if (y + numLines > this.g3d.height) {
            numLines = this.g3d.height - y;
        }
        while (--numLines >= 0) {
            int xW = this.axW[i];
            this.g3d.plotNoisyPixelsClipped(this.axE[i] - xW + 1, xW, y, this.azW[i], this.azE[i]);
            ++y;
            ++i;
        }
    }
}

