# The LearningOnline Network
# Simple Page Editor
#
# $Id: lonsimplepage.pm,v 1.52 2007/09/10 19:22:22 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonsimplepage;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lontexconvert;
use Apache::lonfeedback;
use Apache::lonlocal;
use Apache::lonprintout;
use Apache::lonxml;
use Apache::longroup;
use HTML::Entities();
use LONCAPA;

sub get_db_name {
    my ($url) = @_;
    my ($udom,$uname,$marker)=(split(m{/},$url))[2,3,4];
    my $dom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    my $crs = $env{'course.'.$env{'request.course.id'}.'.num'};

    my $db_name;

    if ($dom && $crs && ($udom eq $dom) && ($uname eq $crs)) {
	$marker =~ s/\W//g;
	$db_name = 'grppage_'.$marker;
    } else {
	$marker=~s/\D//g;
        $db_name = 'smppage_'.$marker;
    }
    return if (!defined($marker));

    return $db_name;
}

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
    my $target=$env{'form.grade_target'};
# ------------------------------------------------------------ Print the screen
    if ($target eq 'tex') {
	$r->print(&Apache::lonprintout::print_latex_header($env{'form.latex_type'}));
    } 

# Is this even in a course?
    unless ($env{'request.course.id'}) {
	if ($target ne 'tex') {
	    &Apache::loncommon::simple_error_page($r,'','Not in a course');
	} else {
	    $r->print('\textbf{Not in a course}\end{document}');
	}
	return OK;
    }

    my $db_name = &get_db_name($r->uri);

    my $dom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    my $crs = $env{'course.'.$env{'request.course.id'}.'.num'};
    my ($group,$group_desc,$group_home_view,$group_home_edit,
        $group_view_perm,$group_edit_perm);
    my %curr_group = ();
    my %groupinfo = ();
    if ($db_name =~ /^grppage_/) {
        $group = (split(m{/},$r->uri))[4];
	$group =~ s/\W//g;
        my %curr_groups = &Apache::longroup::coursegroups($dom,$crs,$group);
        if (!%curr_groups) {
	    &Apache::loncommon::simple_error_page($r,'','Invalid group name');
	    return OK;
        }
        %groupinfo = 
	    &Apache::longroup::get_group_settings($curr_groups{$group});
        $group_desc = &unescape($groupinfo{'description'});
    }

    if (!$db_name) {
	&Apache::loncommon::simple_error_page($r,'','Invalid call');
	return OK;
    }

# --------------------------------------------------------- The syllabus fields
    my %syllabusfields=&Apache::lonlocal::texthash(
       'aaa_title'         => 'Page Title',
       'bbb_content'       => 'Content',
       'ccc_webreferences' => 'Web References');
    if ($group ne '') {
        $syllabusfields{'abb_links'} = &mt('Available Group Tools');
    }


# ------------------------------------------------------------ Get query string
    &Apache::loncommon::get_unprocessed_cgi
                        ($ENV{'QUERY_STRING'},['forcestudent','forceedit',
                                               'register','ref']);
# --------------------------------------------------------------- Force Student
    my $forcestudent='';
    if ($env{'form.forcestudent'} || $target eq 'tex' ) { $forcestudent='student'; };
    my $forceedit='';
    if ($env{'form.forceedit'}) { $forceedit='edit'; }

    my $refarg;
    if ($env{'form.ref'}) {
        $refarg = '&amp;ref='.$env{'form.ref'};
    }
   
    my %syllabus=&Apache::lonnet::dump($db_name,$dom,$crs);
       
# --------------------------------------- There is such a user, get environment

    if ($target ne 'tex') {
        my $title = 'Course Page';
        if ($group ne '') {
            $title = 'Group Page';
        }
	my $start_page = 
	    &Apache::loncommon::start_page($title,undef,
					   {'function'       => $forcestudent,
					    'domain'         => $dom,
					    'force_register' =>
						$env{'form.register'},});
	$r->print($start_page);
    }

    if ($group ne '') {
        my $group_view_perm =
               &Apache::lonnet::allowed('vcg',$env{'request.course.id'}.
               ($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''));
        $group_edit_perm =
               &Apache::lonnet::allowed('mdg',$env{'request.course.id'}.
               ($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''));
        $group_home_view = &Apache::lonnet::allowed('vgh',
                                         $env{'request.course.id'}.'/'.$group);
        $group_home_edit = &Apache::lonnet::allowed('mgh',
                                         $env{'request.course.id'}.'/'.$group);
        if ($group_view_perm || $group_edit_perm || $group_home_view || 
            $group_home_edit || &Apache::longroup::check_group_access($group)) {
            if (($env{'form.ref'} eq 'grouplist') && ($target ne 'tex')) {
                $r->print(&grouppage_breadcrumbs($dom,$crs,$group,$group_desc));
            }
            if ((!$group_home_edit) && (!$group_home_view) && 
                (!$group_view_perm) && (!$group_edit_perm)) {
                &display_group_links($r,$target,$group,'view',$refarg,%groupinfo);
                if ($env{'form.grade_target'} ne 'tex') {
                    $r->print(&Apache::loncommon::end_page());
                } else {
                    $r->print('\end{document}');
                }
                return OK;
            }
        } else {
	    my $msg = 
		&mt('You do not currently have rights to view this group.');
            if ($target ne 'tex') {
                $r->print("<p>$msg</p>".
			  &Apache::loncommon::end_page());
            } else {
                $r->print('\textbf{'.$msg.'}\end{document}');
            }
	    return OK;
        }
        my ($blocked,$blocktext) = 
             &Apache::loncommon::blocking_status('groups');
        if ($blocked) {
            $r->print($blocktext);
            $r->print(&Apache::loncommon::end_page());
            return OK;
        }
    }

    my $allowed;
    
    if ($group ne '') {
        $allowed  = $group_edit_perm;
        if (!$allowed) {
            $allowed = $group_home_edit; 
        }
    } else { 
        $allowed=&Apache::lonnet::allowed('mdc',$env{'request.course.id'});
    }
    my $privileged=$allowed;
    if (($syllabus{'uploaded.lastmodified'}) && (!$forceedit)) {
	$forcestudent='student';
    }

    if ($forcestudent or $target eq 'tex') { $allowed=0; }

    if ($allowed) {
	$r->print('<p>'.
		  &Apache::loncommon::help_open_topic('Uploaded_Templates_TextBoxes','Help with filling in text boxes').'<br /><a href="'.$r->uri.'?forcestudent=1'.$refarg.'"><font size="+1">'.&mt('Show Student View').'</font></a>'.
		  &Apache::loncommon::help_open_topic('Uploaded_Templates_PublicView').'</p>');
    } elsif ($privileged and $target ne 'tex') {
        my $edittext = &mt('Edit');
        if ($group ne '') {
            $edittext = &mt('Edit Group Homepage');
        }
	$r->print('<a href="'.$r->uri.'?forceedit=edit'.$refarg.'"><font size="+1">'.$edittext.'</font></a>');
        if ($group ne '') {
            if ($group_edit_perm) {
                $r->print('&nbsp;&nbsp;&nbsp;<font size="+1">'.
               '<a href="/adm/coursegroups?action=modify&amp;refpage=grouplist'.
               '&amp;state=pick_task&amp;groupname='.$group.'">'.
               &mt('Edit Group Settings').'</a></font>');
            }
        }    
    } 
    if (($env{'form.uploaddoc.filename'} and $target ne 'tex') &&
	($env{'form.storeupl'}) && ($allowed)) {
	if ($env{'form.uploaddoc.filename'}=~/\.(gif|jpg|png|jpeg)$/i) {
	    if ($syllabus{'uploaded.photourl'}) {
		&Apache::lonnet::removeuploadedurl($syllabus{'uploaded.photourl'});
	    }
            if ($group ne '') {
                $syllabus{'uploaded.photourl'}=&Apache::lonnet::userfileupload(
                                              'uploaddoc',1,"grouppage/$group");
            } else {
	        $syllabus{'uploaded.photourl'}=
		     &Apache::lonnet::userfileupload('uploaddoc',1,'simplepage');
            }
	}
	$syllabus{'uploaded.lastmodified'}=time;
	&Apache::lonnet::put($db_name,\%syllabus,$dom,$crs);
    }
    if (($allowed) && ($env{'form.storesyl'})) {
	foreach my $syl_field (keys(%syllabusfields)) {
	    my $field=$env{'form.'.$syl_field};
	    chomp($field);
	    $field=~s/\s+$//s;
	    $field=~s/^\s+//s;
	    $field=~s/\<br\s*\/*\>$//s;
	    $field=&Apache::lonfeedback::clear_out_html($field,1);
	    $syllabus{$syl_field}=$field;
	}
	$syllabus{'uploaded.lastmodified'}=time;
	&Apache::lonnet::put($db_name,\%syllabus,$dom,$crs);
    }

# ---------------------------------------------------------------- Get syllabus
    if ((($syllabus{'uploaded.lastmodified'}) && 
         (($group ne '' && ($group_home_view || $group_edit_perm ||  
           $group_view_perm)) || ($group eq ''))) || ($allowed)) {
	if ($syllabus{'uploaded.photourl'}) {
	    &Apache::lonnet::allowuploaded('/adm/smppg',
					   $syllabus{'uploaded.photourl'});
	    
	    my $image='<img src="'.$syllabus{'uploaded.photourl'}.'"
                            align="right" />';
	    if ($target eq 'tex') {
		$image=&Apache::lonxml::xmlparse($r,'tex',$image);
	    }
	    $r->print($image);
	}
	if ($allowed) {
	    $r->print(
		      '<form method="post" enctype="multipart/form-data">'.
		      '<input type="hidden" name="forceedit" value="edit" />'.
		      '<h3>Upload a Photo</h3>'.
		      '<input type="file" name="uploaddoc" size="50" />'.
		      '<input type="submit" name="storeupl" value="Upload" />'.
		      '</form><form method="post">');
	}
	foreach my $field (sort(keys(%syllabusfields))) {
	    if (($syllabus{$field}) || ($allowed) || 
                ($field eq 'abb_links' && $group ne '')) {
		my $message=$syllabus{$field};
		&Apache::lonfeedback::newline_to_br(\$message);
		$message
		    =~s/(https*\:\/\/[^\s]+)/\<a href=\"$1\"\>\<tt\>$1\<\/tt\>\<\/a\>/g;
		if ($allowed) {
		    $message=&Apache::lonspeller::markeduptext($message);
		}
		$message=&Apache::lontexconvert::msgtexconverted($message);
                if ($field eq 'abb_links' && $group ne '') {
                    $r->print('<br /><input type="hidden" name="'.$field.
                                          '" value="'.$syllabus{$field}.'" />');
                    &display_group_links($r,$target,$group,'edit',$refarg,
                                         %groupinfo);
                    $r->print('<br />');
                } elsif ($field eq 'aaa_title') {
                    if ($target ne 'tex') {
                        $r->print('<h1>'.$message.'</h1>');
                    } else {
                        my $safeinit;
                        $r->print(&Apache::lonxml::xmlparse($r,'tex','<h1>'.$message.'</h1>'));
                    }
                    if ($allowed) {
                        if ($env{'form.grade_target'} ne 'tex') {
                            $r->print(
                                      '<br />Title<br /><textarea cols="80" rows="2" name="'.$field.'">'.
                                      &HTML::Entities::encode($syllabus{$field},'"&<>').
                                      '</textarea><input type="submit" name="storesyl" value="Save" />');
                        } else {
                            my $safeinit;
                            $r->print(&Apache::lonxml::xmlparse($r,'tex',$syllabus{$field},$safeinit));
                        }
                    }
                } else {
		    if (($field ne 'bbb_content') || ($allowed)) {
			if ($target ne 'tex') {
			    $r->print('<h3>'.$syllabusfields{$field}.'</h3>');
			} else {
			    my $safeinit;
			    $r->print(&Apache::lonxml::xmlparse($r,'tex','<h3>'.$syllabusfields{$field}.'</h3>'));
			}
		    }
		    if ($target ne 'tex') {
			$r->print('<blockquote>'.
				  $message.'</blockquote>');
		    } else {
			my $safeinit;
			$r->print(&Apache::lonxml::xmlparse($r,'tex',$message));
		    }
		    if ($allowed) {
			if ($target ne 'tex') {
			    $r->print('<br /><textarea cols="80" rows="24" name="'.$field.'" id="'.$field.'">'.
                                      &HTML::Entities::encode($syllabus{$field},'"&<>').
				      '</textarea><input type="submit" name="storesyl" value="Save" />');
			} else {
			    my $safeinit;
			    $r->print(&Apache::lonxml::xmlparse($r,'tex',$syllabus{$field},$safeinit));
			}
		    }
		}
	    }
	}
	if ($allowed && ($env{'form.grade_target'} ne 'tex')) {
	    $r->print(&Apache::lonhtmlcommon::htmlareaselectactive
		      ('bbb_content').'</form>');
	}
	if ($env{'form.grade_target'} ne 'tex') {$r->print('</p>');}
    } else {
        if ($group ne '') {
            &display_group_links($r,$target,$group,'view',$refarg,%groupinfo);
        } else {
	    $r->print(&mt('<p>No page information provided.</p>'));
        }
    }
    if ($env{'form.grade_target'} ne 'tex') {
	$r->print(&Apache::loncommon::end_page());
    } else {
	$r->print('\end{document}');
    }
    return OK;
}

sub display_group_links {
    my ($r,$target,$group,$context,$refarg,%groupinfo) = @_;
    my @available = ();
    my %menu = ();
    %{$menu{'email'}} = (
                        text => 'Group e-mail',
                        href => '/adm/email?compose=group&amp;group='.$group.
                                $refarg,
                      );
    %{$menu{'discussion'}} = (
                        text => 'Discussion Boards',
                        href => '/adm/groupboards?group='.$group.$refarg,
                      );
    %{$menu{'chat'}} = (
                        text => 'Group chat',
                        href => "javascript:group_chat('$group')",
                      );
    %{$menu{'files'}} = (
                        text => 'File repository',
                        href => '/adm/coursegrp_portfolio?group='.$group.
                                $refarg,
                      );
    %{$menu{'roster'}} = (
                        text => 'Membership roster',
                        href => '/adm/grouproster?group='.$group.$refarg,
                      );
    foreach my $tool (sort(keys(%menu))) {
        if ($groupinfo{functions}{$tool} eq 'on') {
            push(@available,$tool);
        }
    }
    if (@available > 0) {
        my $output = '<table cellspacing="4" cellpadding="4"><tr>';
        foreach my $tool (@available) {
            if ($target eq 'tex') {
                $output .= '<td>'.&mt($menu{$tool}{text}).'</td>';
            } else {
                $output .= '<td><a href="'.$menu{$tool}{href}.'">'.
                           $menu{$tool}{text}.'</a></td>';
            }
        }
        $output .= '</tr></table>';
        if ($target eq 'tex') {
            $r->print(&Apache::lonxml::xmlparse($r,'tex',&mt('Available functions').'<br /><br />'.$output));
        } else {
            $r->print('<h3>'.&mt('Available Group Tools').'</h3>'.$output);
        }
    } else {
        my $output;
        if ($context eq 'edit') {
            $output = &mt('No group functionality.');
        } else {  
            $output = &mt('No group functionality (e.g., e-mail, discussion, chat or file upload) is currently available to you in this group: <b>[_1]</b>.',&unescape($groupinfo{'description'}));
        }
        if ($target eq 'tex') {
            $r->print(&Apache::lonxml::xmlparse($r,'tex',$output));
        } else {
            $r->print($output);
        }
    }
}

sub grouppage_breadcrumbs {
    my ($cdom,$cnum,$group,$description) = @_;
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"/adm/coursegroups",
          text=>"Groups",
          title=>"Display Groups"},
        {href=>"/adm/$cdom/$cnum/$group/smppg?ref=grouplist",
          text=>"Group: $description",
          title=>"Go to group's home page"},
        );
    my $output .= &Apache::lonhtmlcommon::breadcrumbs(&mt('Group page - [_1]',
                                                           $description));
    return $output;
}

1;
__END__
