#!/usr/bin/perl

# The LearningOnline Network with CAPA
#
# YEAR=2001
# 11/16 Scott Harrison
#
#
###

my $dir='fctest';
my %tests=(
	   "perl ../build/filecompare.pl -p $dir/fileA.txt $dir/fileB.txt",
	   "$dir/fileA.txt\texistence: yes:yes\tcvstime: n/a\tage: 0\tmd5sum: same\tsize: 0\tlines: 0\tdiffs: 0:0",
	   "perl ../build/filecompare.pl -p $dir/fileA.txt $dir/fileE.txt",
	   "",
	   "perl ../build/filecompare.pl -p $dir/fileA.txt $dir/fileC.txt",
	   "",
	   "perl ../build/filecompare.pl -n $dir/fileA.txt $dir/fileB.txt",
	   "",
	   "perl ../build/filecompare.pl -n $dir/fileA.txt $dir/fileE.txt",
	   "$dir/fileA.txt\texistence: yes:yes\tcvstime: n/a\tage: 0\tmd5sum: different\tsize: 29\tlines: 1\tdiffs: 1:0",
	   "perl ../build/filecompare.pl -n $dir/fileA.txt $dir/fileC.txt",
	   "$dir/fileA.txt\texistence: yes:yes\tcvstime: n/a\tage: 0\tmd5sum: different\tsize: -2\tlines: 0\tdiffs: 1:1",
	   "perl ../build/filecompare.pl -n $dir/fileA.txt $dir/fileF.txt",
	   "$dir/fileA.txt\texistence: yes:yes\tcvstime: n/a\tage: -3\tmd5sum: different\tsize: 29\tlines: 1\tdiffs: 1:0",
	   "perl ../build/filecompare.pl -q $dir/fileA.txt $dir/fileF.txt",
	   "$dir/fileA.txt",
	   "perl ../build/filecompare.pl -b1 $dir/fileA.txt $dir/fileB.txt",
	   "1",
	   "perl ../build/filecompare.pl -b1 $dir/fileA.txt $dir/fileC.txt",
	   "2",
	   "perl ../build/filecompare.pl -n $dir/fileA.txt $dir/fileC.txt age",
	   "",
	   "perl ../build/filecompare.pl -n $dir/fileA.txt $dir/fileC.txt age size",
	   "$dir/fileA.txt\texistence: yes:yes\tcvstime: n/a\tage: 0\tmd5sum: different\tsize: -2\tlines: 0\tdiffs: 1:1",
	   );

unless (-d $dir) {
    `mkdir $dir`;
}
chdir $dir;
open OUT,">fileA.txt";
print OUT <<END;
Mary had a little lamb
Little lamb
Little lamb
Mary had a little lamb
whose hair was white as snow
END
close OUT;
open OUT,">fileB.txt";
print OUT <<END;
Mary had a little lamb
Little lamb
Little lamb
Mary had a little lamb
whose hair was white as snow
END
close OUT;
open OUT,">fileC.txt";
print OUT <<END;
Mary had a little lamb
Little lamb
Little lamb
Mary had a little lamb
whose fleece was white as snow
END
close OUT;
open OUT,">fileD.txt";
print OUT <<END;
Mary had a little lamb
Little lamb
Little lamb
Mary had a little lamb
whose fleece was white as snow
END
close OUT;
open OUT,">fileE.txt";
print OUT <<END;
Mary had a little lamb
Little lamb
Little lamb
Mary had a little lamb
END
close OUT;
my $now=time;
utime($now,$now,'fileA.txt');
utime($now,$now,'fileB.txt');
utime($now,$now,'fileC.txt');
utime($now,$now,'fileD.txt');
utime($now,$now,'fileE.txt');
sleep 3;
open OUT,">fileF.txt";
print OUT <<END;
Mary had a little lamb
Little lamb
Little lamb
Mary had a little lamb
END
close OUT;
`install -d CVS`;
open OUT,">CVS/Entries";
print OUT <<END;
/fileA.txt/3.14/Mon May  3 15:33:20 1976//
/fileF.txt/3.14/Mon May  3 15:33:20 1976//
END
close OUT;

chdir '..';
my $tc=1;
my $tt=0;
foreach my $test (keys %tests) {
    print "Test $tc...";
    my $value=`$test 2>/dev/null`; chomp $value;
    my $ec=$?/256;
    if (length($tests{$test})==1 and $ec==$tests{$test}) {
	print "ok\n";
	$tt++;
    }
    elsif (length($tests{$test})==1 and $ec!=$tests{$test}) {
	print "FAILED\n";
    }
    elsif ($value eq $tests{$test}) {
	print "ok\n";
	$tt++;
    }
    else {
	print "FAILED $test\n";
    }
    $tc++;
}
$tc--;

print "Tests: $tt/$tc successful (".sprintf("%3.1f",$tt/$tc*100)." \%)\n";
if ($tt!=$tc) {
    print "ERROR with filecompare.pl\n";
    exit 1;
}
exit 0;
