/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;

public final class JmolConstants {
    public static final String copyright = "(C) 2004 The Jmol Development Team";
    public static final String version = "10.00";
    public static final String cvsDate = "$Date: 2004/12/17 18:55:13 $";
    public static final String date = "$Date: 2004/12/17 18:55:13 $".substring(7, 23);
    public static final boolean officialRelease = false;
    public static final byte LABEL_NONE = 0;
    public static final byte LABEL_SYMBOL = 1;
    public static final byte LABEL_TYPENAME = 2;
    public static final byte LABEL_ATOMNO = 3;
    public static final short MAR_DELETED = Short.MIN_VALUE;
    public static final byte STYLE_DELETED = -1;
    public static final byte STYLE_NONE = 0;
    public static final byte STYLE_WIREFRAME = 1;
    public static final byte STYLE_SHADED = 2;
    public static final byte PALETTE_COLOR = -1;
    public static final byte PALETTE_NONE_CPK = 0;
    public static final byte PALETTE_FORMALCHARGE = 1;
    public static final byte PALETTE_STRUCTURE = 2;
    public static final byte PALETTE_AMINO = 3;
    public static final byte PALETTE_SHAPELY = 4;
    public static final byte PALETTE_CHAIN = 5;
    public static final byte PALETTE_PARTIALCHARGE = 6;
    public static final byte PALETTE_TYPE = 7;
    public static final byte PALETTE_TEMPERATURE = 8;
    public static final byte PALETTE_FIXEDTEMP = 9;
    public static final byte PALETTE_GROUP = 10;
    public static final byte PALETTE_MONOMER = 11;
    public static final byte PALETTE_MAX = 12;
    public static final String[] colorSchemes = new String[]{"cpk", "charge", "structure", "amino", "shapely", "chain", "partialCharge", "type", "temperature", "fixedTemperature", "group", "monomer"};
    public static final byte AXES_NONE = 0;
    public static final byte AXES_UNIT = 1;
    public static final byte AXES_BBOX = 2;
    public static final int MOUSE_ROTATE = 0;
    public static final int MOUSE_ZOOM = 1;
    public static final int MOUSE_XLATE = 2;
    public static final int MOUSE_PICK = 3;
    public static final int MOUSE_DELETE = 4;
    public static final int MOUSE_MEASURE = 5;
    public static final int MOUSE_ROTATE_Z = 6;
    public static final int MOUSE_SLAB_PLANE = 7;
    public static final int MOUSE_POPUP_MENU = 8;
    public static final byte MULTIBOND_NEVER = 0;
    public static final byte MULTIBOND_WIREFRAME = 1;
    public static final byte MULTIBOND_SMALL = 2;
    public static final byte MULTIBOND_ALWAYS = 3;
    public static final short madMultipleBondSmallMaximum = 500;
    public static final int PICKING_OFF = 0;
    public static final int PICKING_IDENT = 1;
    public static final int PICKING_DISTANCE = 2;
    public static final int PICKING_MONITOR = 3;
    public static final int PICKING_ANGLE = 4;
    public static final int PICKING_TORSION = 5;
    public static final int PICKING_LABEL = 6;
    public static final int PICKING_CENTER = 7;
    public static final int PICKING_COORD = 8;
    public static final int PICKING_BOND = 9;
    public static final int PICKING_SELECT_ATOM = 10;
    public static final int PICKING_SELECT_GROUP = 11;
    public static final int PICKING_SELECT_CHAIN = 12;
    public static final String[] pickingModeNames = new String[]{"off", "ident", "distance", "monitor", "angle", "torsion", "label", "center", "coord", "bond", "atom", "group", "chain"};
    public static final int MODEL_TYPE_OTHER = 0;
    public static final int MODEL_TYPE_PDB = 1;
    public static final int MODEL_TYPE_XYZ = 2;
    public static final short BOND_COVALENT = 3;
    public static final short BOND_AROMATIC_MASK = 4;
    public static final short BOND_AROMATIC = 5;
    public static final short BOND_STEREO_MASK = 24;
    public static final short BOND_STEREO_NEAR = 9;
    public static final short BOND_STEREO_FAR = 18;
    public static final short BOND_SULFUR_MASK = 32;
    public static final short BOND_HBOND_SHIFT = 6;
    public static final short BOND_HYDROGEN_MASK = 960;
    public static final short BOND_H_REGULAR = 64;
    public static final short BOND_H_PLUS_2 = 128;
    public static final short BOND_H_PLUS_3 = 192;
    public static final short BOND_H_PLUS_4 = 256;
    public static final short BOND_H_PLUS_5 = 320;
    public static final short BOND_H_MINUS_3 = 384;
    public static final short BOND_H_MINUS_4 = 448;
    public static final short BOND_H_NUCLEOTIDE = 512;
    public static final short BOND_ALL_MASK = -1;
    public static final int[] argbsHbondType = new int[]{-38476, -256, -1, -65281, -65536, -23296, -16711681, -16711936, -32640};
    public static final String[] elementSymbols = new String[]{"Xx", "H", "He", "Li", "Be", "B", "C", "N", "O", "F", "Ne", "Na", "Mg", "Al", "Si", "P", "S", "Cl", "Ar", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Ge", "As", "Se", "Br", "Kr", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Sb", "Te", "I", "Xe", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt"};
    private static Hashtable htElementMap;
    public static final int elementNumberMax;
    public static final String[] elementNames;
    public static final byte[] alternateElementNumbers;
    public static final String[] alternateElementNames;
    public static final short[] vanderwaalsMars;
    private static final short[] covalentMars;
    public static final int FORMAL_CHARGE_MIN = -4;
    public static final int FORMAL_CHARGE_MAX = 7;
    public static final short[] ionicLookupTable;
    public static final short[] ionicMars;
    public static final int MAXIMUM_AUTO_BOND_COUNT = 20;
    public static final int[] argbsCpk;
    public static final int[] argbsCpkRasmol;
    public static final byte PROTEIN_STRUCTURE_NONE = 0;
    public static final byte PROTEIN_STRUCTURE_TURN = 1;
    public static final byte PROTEIN_STRUCTURE_SHEET = 2;
    public static final byte PROTEIN_STRUCTURE_HELIX = 3;
    public static final byte PROTEIN_STRUCTURE_DNA = 4;
    public static final byte PROTEIN_STRUCTURE_RNA = 5;
    public static final int[] argbsStructure;
    public static final int[] argbsAmino;
    public static final int argbShapelyBackbone = -4671304;
    public static final int argbShapelySpecial = -10616738;
    public static final int argbShapelyDefault = -65281;
    public static final int[] argbsShapely;
    public static final int[] argbsChainAtom;
    public static final int[] argbsChainHetero;
    public static final int[] argbsCharge;
    public static final int[] argbsRwbScale;
    public static final int[] argbsBlueRedRainbow;
    public static final String[] specialAtomNames;
    public static final int ATOMID_MAX;
    public static final byte ATOMID_AMINO_NITROGEN = 1;
    public static final byte ATOMID_ALPHA_CARBON = 2;
    public static final byte ATOMID_CARBONYL_CARBON = 3;
    public static final byte ATOMID_O5_PRIME = 5;
    public static final byte ATOMID_O3_PRIME = 9;
    public static final byte ATOMID_NUCLEIC_PHOSPHORUS = 12;
    public static final byte ATOMID_TERMINATING_OXT = 32;
    public static final byte ATOMID_CARBONYL_OXYGEN = 40;
    public static final byte ATOMID_O1 = 41;
    public static final byte ATOMID_H5T_TERMINUS = 45;
    public static final byte ATOMID_O5T_TERMINUS = 46;
    public static final byte ATOMID_RNA_O2PRIME = 50;
    public static final byte ATOMID_H3T_TERMINUS = 59;
    public static final byte ATOMID_N1 = 64;
    public static final byte ATOMID_C2 = 65;
    public static final byte ATOMID_N3 = 66;
    public static final byte ATOMID_C4 = 67;
    public static final byte ATOMID_C5 = 68;
    public static final byte ATOMID_C6 = 69;
    public static final byte ATOMID_O2 = 70;
    public static final byte ATOMID_N7 = 71;
    public static final byte ATOMID_C8 = 72;
    public static final byte ATOMID_N9 = 73;
    public static final byte ATOMID_N4 = 74;
    public static final byte ATOMID_N2 = 75;
    public static final byte ATOMID_N6 = 76;
    public static final byte ATOMID_C5M = 77;
    public static final byte ATOMID_O6 = 78;
    public static final byte ATOMID_O4 = 79;
    public static final byte ATOMID_S4 = 80;
    public static final byte ATOMID_NUCLEIC_WING = 69;
    public static final int ATOMID_PROTEIN_MASK = 14;
    public static final int ATOMID_ALPHA_ONLY_MASK = 4;
    public static final int ATOMID_NUCLEIC_MASK = 4064;
    public static final int ATOMID_PHOSPHORUS_ONLY_MASK = 4096;
    public static final int ATOMID_DISTINGUISHING_ATOM_MAX = 32;
    public static final int ATOMID_BACKBONE_MAX = 64;
    public static final int GROUPID_PROLINE = 15;
    public static final int GROUPID_PURINE_MIN = 24;
    public static final int GROUPID_PURINE_LAST = 29;
    public static final int GROUPID_PYRIMIDINE_MIN = 30;
    public static final int GROUPID_PYRIMIDINE_LAST = 35;
    public static final int GROUPID_GUANINE = 26;
    public static final int GROUPID_PLUS_GUANINE = 27;
    public static final int GROUPID_GUANINE_1_MIN = 40;
    public static final int GROUPID_GUANINE_1_LAST = 46;
    public static final int GROUPID_GUANINE_2_MIN = 55;
    public static final int GROUPID_GUANINE_2_LAST = 57;
    public static final short GROUPID_AMINO_MAX = 23;
    public static final short GROUPID_SHAPELY_MAX = 36;
    public static final String[] predefinedGroup3Names;
    public static String[] predefinedSets;
    public static final String DEFAULT_FONTFACE = "SansSerif";
    public static final String DEFAULT_FONTSTYLE = "Plain";
    public static final int LABEL_MINIMUM_FONTSIZE = 6;
    public static final int LABEL_MAXIMUM_FONTSIZE = 63;
    public static final int LABEL_DEFAULT_FONTSIZE = 13;
    public static final int LABEL_DEFAULT_X_OFFSET = 4;
    public static final int LABEL_DEFAULT_Y_OFFSET = 4;
    public static final int MEASURE_DEFAULT_FONTSIZE = 15;
    public static final int AXES_DEFAULT_FONTSIZE = 14;
    public static final int SHAPE_BALLS = 0;
    public static final int SHAPE_STICKS = 1;
    public static final int SHAPE_HSTICKS = 2;
    public static final int SHAPE_SSSTICKS = 3;
    public static final int SHAPE_LABELS = 4;
    public static final int SHAPE_VECTORS = 5;
    public static final int SHAPE_MEASURES = 6;
    public static final int SHAPE_DOTS = 7;
    public static final int SHAPE_BACKBONE = 8;
    public static final int SHAPE_TRACE = 9;
    public static final int SHAPE_CARTOON = 10;
    public static final int SHAPE_STRANDS = 11;
    public static final int SHAPE_MESHRIBBON = 12;
    public static final int SHAPE_RIBBONS = 13;
    public static final int SHAPE_ROCKETS = 14;
    public static final int SHAPE_MIN_SELECTION_INDEPENDENT = 15;
    public static final int SHAPE_AXES = 15;
    public static final int SHAPE_BBCAGE = 16;
    public static final int SHAPE_UCCAGE = 17;
    public static final int SHAPE_FRANK = 18;
    public static final int SHAPE_ECHO = 19;
    public static final int SHAPE_HOVER = 20;
    public static final int SHAPE_PRUEBA = 21;
    public static final int SHAPE_MAX = 22;
    public static final String[] shapeClassBases;

    public static byte elementNumberFromSymbol(String elementSymbol) {
        if (htElementMap == null) {
            Hashtable<String, Integer> map = new Hashtable<String, Integer>();
            int elementNumber = elementNumberMax;
            while (--elementNumber >= 0) {
                String symbol = elementSymbols[elementNumber];
                Integer boxed = new Integer(elementNumber);
                map.put(symbol, boxed);
                if (symbol.length() == 2) {
                    symbol = "" + symbol.charAt(0) + Character.toUpperCase(symbol.charAt(1));
                    map.put(symbol, boxed);
                }
                if (elementNumber != 1) continue;
                map.put("D", boxed);
            }
            htElementMap = map;
        }
        if (elementSymbol == null) {
            return 0;
        }
        Integer boxedAtomicNumber = (Integer)htElementMap.get(elementSymbol);
        if (boxedAtomicNumber != null) {
            return (byte)boxedAtomicNumber.intValue();
        }
        System.out.println("" + elementSymbol + "' is not a recognized symbol");
        return 0;
    }

    public static short getBondingMar(int elementNumber, int charge) {
        if (charge != 0) {
            short ionic = (short)((elementNumber << 4) + (charge + 4));
            int iMin = 0;
            int iMax = ionicLookupTable.length;
            while (iMin != iMax) {
                int iMid = (iMin + iMax) / 2;
                if (ionic < ionicLookupTable[iMid]) {
                    iMax = iMid;
                    continue;
                }
                if (ionic > ionicLookupTable[iMid]) {
                    iMin = iMid + 1;
                    continue;
                }
                return ionicMars[iMid];
            }
        }
        return covalentMars[elementNumber];
    }

    static {
        elementNumberMax = elementSymbols.length;
        elementNames = new String[]{"unknown", "hydrogen", "helium", "lithium", "beryllium", "boron", "carbon", "nitrogen", "oxygen", "fluorine", "neon", "sodium", "magnesium", "aluminum", "silicon", "phosphorus", "sulfur", "chlorine", "argon", "potassium", "calcium", "scandium", "titanium", "vanadium", "chromium", "manganese", "iron", "cobalt", "nickel", "copper", "zinc", "gallium", "germanium", "arsenic", "selenium", "bromine", "krypton", "rubidium", "strontium", "yttrium", "zirconium", "niobium", "molybdenum", "technetium", "ruthenium", "rhodium", "palladium", "silver", "cadmium", "indium", "tin", "antimony", "tellurium", "iodine", "xenon", "cesium", "barium", "lanthanum", "cerium", "praseodymium", "neodymium", "promethium", "samarium", "europium", "gadolinium", "terbium", "dysprosium", "holmium", "erbium", "thulium", "ytterbium", "lutetium", "hafnium", "tantalum", "tungsten", "rhenium", "osmium", "iridium", "platinum", "gold", "mercury", "thallium", "lead", "bismuth", "polonium", "astatine", "radon", "francium", "radium", "actinium", "thorium", "protactinium", "uranium", "neptunium", "plutonium", "americium", "curium", "berkelium", "californium", "einsteinium", "fermium", "mendelevium", "nobelium", "lawrencium", "rutherfordium", "dubnium", "seaborgium", "bohrium", "hassium", "meitnerium"};
        alternateElementNumbers = new byte[]{0, 13, 16, 55};
        alternateElementNames = new String[]{"dummy", "aluminium", "sulphur", "caesium"};
        vanderwaalsMars = new short[]{1000, 1200, 1400, 1820, 1700, 2080, 1950, 1850, 1700, 1730, 1540, 2270, 1730, 2050, 2100, 2080, 2000, 1970, 1880, 2750, 1973, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1630, 1400, 1390, 1870, 1700, 1850, 1900, 2100, 2020, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1630, 1720, 1580, 1930, 2170, 2200, 2060, 2150, 2160, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1720, 1660, 1550, 1960, 2020, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1860, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700, 1700};
        covalentMars = new short[]{0, 230, 930, 680, 350, 830, 680, 680, 680, 640, 1120, 970, 1100, 1350, 1200, 750, 1020, 990, 1570, 1330, 990, 1440, 1470, 1330, 1350, 1350, 1340, 1330, 1500, 1520, 1450, 1220, 1170, 1210, 1220, 1210, 1910, 1470, 1120, 1780, 1560, 1480, 1470, 1350, 1400, 1450, 1500, 1590, 1690, 1630, 1460, 1460, 1470, 1400, 1980, 1670, 1340, 1870, 1830, 1820, 1810, 1800, 1800, 1990, 1790, 1760, 1750, 1740, 1730, 1720, 1940, 1720, 1570, 1430, 1370, 1350, 1370, 1320, 1500, 1500, 1700, 1550, 1540, 1540, 1680, 1700, 2400, 2000, 1900, 1880, 1790, 1610, 1580, 1550, 1530, 1510, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600};
        ionicLookupTable = new short[]{19, 53, 69, 70, 85, 87, 96, 104, 113, 117, 119, 121, 130, 131, 133, 138, 147, 155, 165, 181, 197, 198, 215, 224, 227, 229, 232, 241, 247, 249, 258, 262, 264, 266, 275, 281, 283, 293, 309, 325, 326, 343, 357, 358, 359, 360, 374, 375, 376, 377, 389, 390, 391, 394, 406, 407, 408, 411, 422, 423, 438, 439, 454, 469, 470, 485, 486, 501, 503, 512, 518, 520, 529, 535, 537, 546, 547, 549, 552, 554, 563, 569, 571, 597, 614, 631, 645, 648, 661, 664, 665, 677, 680, 682, 699, 712, 727, 742, 744, 757, 758, 773, 774, 791, 800, 803, 806, 808, 817, 823, 825, 834, 835, 837, 840, 842, 851, 857, 859, 885, 901, 902, 917, 919, 933, 935, 936, 951, 952, 967, 983, 999, 1014, 1015, 1031, 1047, 1048, 1063, 1079, 1095, 1111, 1126, 1127, 1143, 1160, 1177, 1192, 1194, 1208, 1211, 1224, 1226, 1240, 1254, 1256, 1269, 1271, 1285, 1286, 1301, 1303, 1318, 1320, 1333, 1335, 1337, 1354, 1371, 1397, 1414, 1431, 1448, 1463, 1464, 1465, 1480, 1482, 1495, 1496, 1499, 1511, 1512, 1527, 1528};
        ionicMars = new short[]{1540, 680, 440, 350, 350, 230, 2600, 160, 1710, 250, 160, 130, 1320, 1760, 220, 90, 1330, 80, 1120, 970, 820, 660, 510, 2710, 3840, 650, 420, 2120, 440, 350, 1840, 2190, 370, 300, 1810, 340, 270, 1540, 1330, 1180, 990, 732, 960, 940, 760, 680, 880, 740, 630, 590, 810, 890, 630, 520, 800, 660, 600, 460, 740, 640, 720, 630, 690, 960, 720, 880, 740, 810, 620, 2720, 730, 530, 2220, 580, 460, 1910, 2320, 660, 500, 420, 1960, 470, 390, 1470, 1120, 893, 1090, 790, 1000, 740, 690, 930, 700, 620, 979, 670, 680, 800, 650, 1260, 890, 1140, 970, 810, 2940, 3700, 930, 710, 2450, 760, 620, 2110, 2500, 820, 700, 560, 2200, 620, 500, 1670, 1530, 1340, 1390, 1016, 1270, 1034, 920, 1013, 900, 995, 979, 964, 1090, 950, 938, 923, 840, 908, 894, 881, 870, 930, 858, 850, 780, 680, 700, 620, 720, 560, 880, 690, 680, 800, 650, 1370, 850, 1270, 1100, 1470, 950, 1200, 840, 980, 960, 740, 670, 620, 1800, 1430, 1180, 1020, 1130, 980, 890, 970, 800, 1100, 950, 710, 1080, 930, 1070, 920};
        argbsCpk = new int[]{-60269, -1, -2490369, -3374849, -3997952, -19019, -7303024, -13610760, -62195, -7282608, -4987915, -5546766, -7667968, -4217178, -997216, Short.MIN_VALUE, -208, -14684129, -8334877, -7388972, -12714240, -1644826, -4209977, -5855573, -7693881, -6522169, -2070989, -1011552, -11481008, -3637197, -8552272, -4026481, -10055793, -4357917, -24320, -5887703, -10700591, -9425232, -16711936, -7012353, -7020320, -9190711, -11225675, -12869986, -14381169, -16089716, -16750203, -4144960, -9841, -5868173, -10059648, -6397003, -2852352, -7077740, -12411216, -11069553, -16725760, -9382657, -57, -2490425, -3670073, -6029369, -7340089, -10354745, -12189753, -13566009, -14680121, -16711780, -16718219, -16722862, -16728264, -16733404, -11681025, -11688193, -14576426, -14254677, -14260586, -15248249, -3092256, -11997, -4671280, -5876659, -11052703, -6402123, -5547008, -9089211, -12418410, -12451738, -16745216, -9393158, -16729345, -16735745, -16740353, -16744193, -16749569, -11248398, -8889117, -7712797, -6211884, -5038124, -5038150, -5042778, -4387449, -3735450, -3407783, -3080113, -2555835, -2097096, -1703890, -1376218};
        argbsCpkRasmol = new int[]{16716947, 0x1FFFFFF, 50315467, 0x3B22222, 0x500FF00, 0x6C8C8C8, 0x78F8FFF, 0x8F00000, 165324064, 0xB0000FF, 203590434, 226525328, 249210144, 268412160, 285198386, 0x1100FF00, 343965840, 377520272, 411074704, 427851920, 452961536, 480586282, 497363498, 514140714, 598026794, 796950672, 899686640, 956278016, 1339729184};
        if (elementSymbols.length != elementNames.length || elementSymbols.length != vanderwaalsMars.length || elementSymbols.length != covalentMars.length || elementSymbols.length != argbsCpk.length) {
            System.out.println("ERROR!!! Element table length mismatch:\n elementSymbols.length=" + elementSymbols.length + "\n elementNames.length=" + elementNames.length + "\n vanderwaalsMars.length=" + vanderwaalsMars.length + "\n covalentMars.length=" + covalentMars.length + "\n argbsCpk.length=" + argbsCpk.length);
        }
        argbsStructure = new int[]{-1, -10452737, -14336, -65408, -5373698, -196254};
        argbsAmino = new int[]{-4284306, -3618616, -15443201, -16720676, -1701366, -1645056, -16720676, -1701366, -1315861, -8224046, -15760881, -15760881, -15443201, -1645056, -13487446, -2320766, -354816, -354816, -4957516, -13487446, -15760881, -38476, -38476};
        argbsShapely = new int[]{-65281, -7536756, -16777092, -33680, -6291390, -144, -46004, -10092544, -1, -9408257, -16757760, -12231099, -12105800, -4677566, -11318190, -11382190, -36798, -4699136, -11581952, -7573428, -29441, -65281, -65281, -65281, -6250241, -6250241, -36752, -36752, -8323073, -8323073, -29621, -29621, -6226016, -6226016, -32640, -32640};
        argbsChainAtom = new int[]{-1, -4140801, -5177424, -16184, -128, -16129, -5181200, -12176, -1015680, -663885, -16728065, -3318692, -10039894, -6632142, -1146130, -16724271, -16711809, -12799119, -16777077, -4343957, -16751616, -8388608, -8355840, -8388480, -16744320, -4684277, -5103070};
        argbsChainHetero = new int[]{-1, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382};
        argbsCharge = new int[]{-65536, -49088, -32640, -16192, -1, -2565889, -4934401, -7302913, -9671425, -12039937, -14408449, -16776961};
        argbsRwbScale = new int[]{-65536, -61424, -57312, -53200, -49088, -44976, -40864, -36752, -32640, -28528, -24416, -20304, -16192, -12080, -7968, -1, -2039553, -3092225, -4144897, -5197569, -6250241, -7302913, -8355585, -9408257, -10460929, -11513601, -12566273, -13618945, -14671617, -15724289, -16776961};
        argbsBlueRedRainbow = new int[]{-16776961, -16768769, -16760577, -16752385, -16744193, -16736001, -16727809, -16719617, -16711681, -16711712, -16711744, -16711776, -16711808, -16711840, -16711872, -16711904, -16711936, -14614784, -12517632, -10420480, -8323328, -6226176, -4129024, -2031872, -256, -8192, -16384, -24576, Short.MIN_VALUE, -40960, -49152, -57344, -65536};
        specialAtomNames = new String[]{null, "N", "CA", "C", null, "O5'", "C5'", "C4'", "C3'", "O3'", "C2'", "C1'", "P", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "OXT", "H", "1H", "2H", "3H", "HA", "1HA", "2HA", "O", "O1", null, null, null, "H5T", "O5T", "O1P", "O2P", "O4'", "O2'", "1H5'", "2H5'", "H4'", "H3'", "1H2'", "2H2'", "2HO'", "H1'", "H3T", null, null, null, null, "N1", "C2", "N3", "C4", "C5", "C6", "O2", "N7", "C8", "N9", "N4", "N2", "N6", "C5M", "O6", "O4", "S4"};
        ATOMID_MAX = specialAtomNames.length;
        predefinedGroup3Names = new String[]{"", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "A", "+A", "G", "+G", "I", "+I", "C", "+C", "T", "+T", "U", "+U", "1MA", "AMO", "5MC", "OMC", "1MG", "2MG", "M2G", "7MG", "G7M", "OMG", "YG", "QUO", "H2U", "5MU", "4SU", "PSU", "AMP", "ADP", "ATP", "GMP", "GDP", "GTP", "IMP", "IDP", "ITP", "CMP", "CDP", "CTP", "TMP", "TDP", "TTP", "UMP", "UDP", "UTP", "HOH", "DOD", "WAT", "PO4", "SO4"};
        predefinedSets = new String[]{"@amino _g>0 & _g<=23", "@acidic asp,glu", "@basic arg,his,lys", "@charged acidic,basic", "@negative acidic", "@positive basic", "@neutral amino&!(acidic,basic)", "@polar amino&!hydrophobic", "@cyclic his,phe,pro,trp,tyr", "@acyclic amino&!cyclic", "@aliphatic ala,gly,ile,leu,val", "@aromatic his,phe,trp,tyr", "@buried ala,cys,ile,leu,met,phe,trp,val", "@surface !buried", "@hydrophobic ala,gly,ile,leu,met,phe,pro,trp,tyr,val", "@ligand hetero & !solvent", "@mainchain backbone", "@small ala,gly,ser", "@medium asn,asp,cys,pro,thr,val", "@large arg,glu,gln,his,ile,leu,lys,met,phe,trp,tyr", "@c nucleic & within(group,_a=74)", "@g nucleic & within(group,_a=75)", "@cg c,g", "@a nucleic & within(group,_a=76)", "@t nucleic & within(group,_a=77)", "@at a,t", "@i nucleic & within(group,_a=78) & !g", "@u nucleic & within(group,_a=79) & !t", "@tu nucleic & within(group,_a=80)", "@solvent _g>=70 & _g<=74", "@hoh water", "@water _g>=70 & _g<=72", "@ions _g=70,_g=71", "@alpha _a=2", "@backbone (protein,nucleic) & _a>0 & _a<=63", "@sidechain (protein,nucleic) & !backbone", "@base nucleic & !backbone", "@turn _structure=1", "@sheet _structure=2", "@helix _structure=3", "@bonded _bondedcount>0"};
        shapeClassBases = new String[]{"Balls", "Sticks", "Hsticks", "Sssticks", "Labels", "Vectors", "Measures", "Dots", "Backbone", "Trace", "Cartoon", "Strands", "MeshRibbon", "Ribbons", "Rockets", "Axes", "Bbcage", "Uccage", "Frank", "Echo", "Hover", "Prueba"};
        if (ionicLookupTable.length != ionicMars.length) {
            System.out.println("ionic table mismatch!");
            throw new NullPointerException();
        }
        int i = ionicLookupTable.length;
        while (--i > 0) {
            if (ionicLookupTable[i - 1] < ionicLookupTable[i]) continue;
            System.out.println("ionicLookupTable not sorted properly");
            throw new NullPointerException();
        }
        if (argbsCharge.length != 12) {
            System.out.println("charge color table length");
            throw new NullPointerException();
        }
        if (shapeClassBases.length != 22) {
            System.out.println("graphicBaseClasses wrong length");
            throw new NullPointerException();
        }
        if (colorSchemes.length != 12) {
            System.out.println("colorSchemes wrong length");
            throw new NullPointerException();
        }
        if (argbsAmino.length != 23) {
            System.out.println("argbsAmino wrong length");
            throw new NullPointerException();
        }
        if (argbsShapely.length != 36) {
            System.out.println("argbsShapely wrong length");
            throw new NullPointerException();
        }
    }
}

