# The LearningOnline Network
# Starts a user off based of an existing token.
#
# $Id: migrateuser.pm,v 1.11 2007/09/29 02:09:50 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::migrateuser;

use strict;
use LONCAPA;
use Apache::Constants qw(:common :http :methods);
use Apache::lonauth;
use Apache::lonnet;
use Apache::lonlocal;

sub goto_login {
    my ($r) = @_;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    $r->print(&Apache::loncommon::start_page('Going to login',undef,
					     {'redirect' =>
						  [0,'/adm/login'],}).
	      '<h1>'.&mt('One moment please...').'</h1>'.
	      '<p>'.&mt('Transferring to login page.').'</p>'.
	      &Apache::loncommon::end_page());
    return OK;
}


sub sso_check {
    my ($data) = @_;
    my %extra_env;
    if ($data->{'sso.login'}) {
	$extra_env{'request.sso.login'} = $data->{'sso.login'};
    }
    if ($data->{'sso.reloginserver'}) {
        $extra_env{'request.sso.reloginserver'} = 
            $data->{'sso.reloginserver'};
    }
    return \%extra_env;
}

sub handler {
    my ($r) = @_;
    
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['token']);
    my %data =   &Apache::lonnet::tmpget($env{'form.token'});
    my $delete = &Apache::lonnet::tmpdel($env{'form.token'});

    &Apache::lonlocal::get_language_handle($r);

    if ($delete ne 'ok') {
	return &goto_login($r);
    }

    if ($data{'ip'} ne $ENV{'REMOTE_ADDR'} || !defined($data{'username'}) ||
	!defined($data{'domain'}) ) {
	return &goto_login($r);
    }

    &Apache::lonnet::logthis("Allowing access for $data{'username'}\@$data{'domain'} to $data{'role'}");
    my $home=&Apache::lonnet::homeserver($data{'username'},$data{'domain'});
    if ($home =~ /(con_lost|no_such_host)/) { return &goto_login($r); }

    my $extra_env = &sso_check(\%data);

    if (!$data{'role'}) {
	# check for exisiting valid session 
	my %cookies=CGI::Cookie->parse($r->header_in('Cookie'));
	my $lonid=$cookies{'lonID'};
	my $handle;
	if ($lonid) {
	    $handle=&LONCAPA::clean_handle($lonid->value);
	}
	if ($lonid 
	    && -e $r->dir_config('lonIDsDir').'/'.$handle.'.id' 
	    && $handle ne '') {
	    &Apache::lonnet::transfer_profile_to_env($r->dir_config('lonIDsDir'),
						     $handle);
	    if ($env{'request.course.id'}) {
		$r->internal_redirect('/adm/navmaps');
	    } else {
		$r->internal_redirect('/adm/roles');
	    }
	} else {
	    &Apache::lonauth::success($r,$data{'username'},$data{'domain'},
				      $home,'/adm/roles',$extra_env);

	}
	return OK;

    }

    my $next_url='/adm/roles?selectrole=1&amp;'.&escape($data{'role'}).'=1';

    
    &Apache::lonauth::success($r,$data{'username'},$data{'domain'},$home,
			      $next_url,$extra_env);
    return OK;
}

1;
__END__
