# doc_template.pl - A perl script for beautifying doc/build/*.html files

# (Quick and dirty xml reading and substitution.)


# --------------------------------------- slurp in information
unless (scalar(@ARGV)==2) {
    die("invalid invocation of doc_template.pl");
}
my $template=shift @ARGV; my $data=shift @ARGV;
my @lines;
open IN,"<$data" or die("no file $data");
@lines=<IN>; close IN;
my $d=join('',@lines);
open IN,"<$template" or die("no file $data");
@lines=<IN>; close IN;
my $t=join('',@lines);

# ------- read in values from data
$d=~/\<title.*?\>(.*?)\<\/title.*?\>/s;
my $title=$1;
$t=~s/\<TITLE \/\>/$title/g;
$d=~/\$(.*?)\$/;
my $e=$1;
$e=~s/\S*\s\S*\s+\S*$/ last updated/;
my $cvsdate="<p align=\"left\"><font size=\"-2\"><i>CVS $e</i></font></p>";
$t=~s/\<DATE \/\>/$cvsdate/g;
$d=~/\<\!\-\- pdfahref (.*?) \-\-\>/;
my $pdfahref="<a href='$1'>";
$t=~s/\<PDFAHREF \/\>/$pdfahref/g;

my %bhash=(
    'CONFIGURE' => '/docs/reconfig/index.html',
    'INSTALL' => '/docs/install/index.html',
    'UPGRADE' => '/docs/upgrade/index.html',
    'FAQ' => '/docs/faq/index.html',
    'DOWNLOADS' => '/docs/downloads/index.html',
    'CONTACT' => '/docs/contact/index.html',
    'MAIN-SITE' => 'http://install.lon-capa.org',
    'LICENSE' => '/docs/license/index.html',
);

$d=~/\<\!\-\- button (.*?) \-\-\>/;
my $buttonv=$1;
while (1) {
    if ($t=~/\<BUTTON NAME=\'(.*?)\' \/\>/) {
	my $bname=$1;
	my $button;
	my $bh=$bhash{$bname};
	if ($buttonv eq $bname) {
	    $button=<<END;
<table cellpadding='5' cellspacing='0' border='3'><tr><td>
<a href='$bh'>
<font face='helvetica'>
<font color='#009900'>
$bname
</font>
</font>
</a>
</td></tr></table>
END
        }
	else {
	    $button=<<END;
<table cellpadding='5' cellspacing='0' border='1'><tr><td>
<a href='$bh'>
<strong><font face='helvetica'>
<font color='#009900'>$bname</font>
</font></strong></a>
</td></tr></table>
END
	}
	$t=~s/\<BUTTON NAME=\'$bname\' \/\>/$button/g;
    }
    else {
	last;
    }
}
$d=~/\<\!\-\- preamble start \-\-\>(.*?)\<\!\-\- preamble end \-\-\>/s;
my $preamble=$1;
$preamble=~s/\<p([^\>]*)\>/<p$1><font face="helvetica">/g;
$preamble=~s/\<\/p([^\>]*)\>/<\/font><\/p$1>/g;
$preamble=~s/\<li([^\>]*)\>/<li$1><font face="helvetica">/g;
$preamble=~s/\<\/li([^\>]*)\>/<\/font><\/li$1>/g;
$t=~s/\<PREAMBLE \/\>/$preamble/g;
$d=~/\<\!\-\- maintext start \-\-\>(.*?)\<\!\-\- maintext end \-\-\>/s;
my $maintext=$1;
$t=~s/\<MAINTEXT \/\>/$maintext/g;
my $v=(<<END);
<p align="right">
 <a href="http://validator.w3.org/check/referer"><img
        src="/loncapa_doc_icons/valid-xhtml10"
        alt="Valid XHTML 1.0!" height="31" width="88" /></a>
</p>
END
if ($d=~/\<\!\-\- validated \-\-\>/) {
    $t=~s/\<VALIDATED \/\>/$v/g;
}
else {
    $t=~s/\<VALIDATED \/\>//g;
}
print $t;
