#!/usr/bin/perl

# The LearningOnline Network with CAPA
# lpml_html_posteval.pl - runs posteval lpml statements in a lpml document.
#
# $Id: lpml_html_posteval.pl,v 1.4 2001/12/15 20:20:11 harris41 Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# YEAR=2001
# 12/5,12/6 Scott Harrison
#
###

use strict;

my %chash;
while(<>) {
    my $line=$_;
    my $arguments='';
    my $category='';
    if ($line=~/\<\!\-\- POSTEVAL \[(.+)\] (.*?) \-\-\>/) {
	$category=$1;
	$arguments=$2;
    }
    if ($arguments=~/^verify\.pl /) {
	my @values=`perl $arguments`;
	my $ret=join('',@values);
	unless ($ret) {
	    $ret='correct';
	}
	else {
	    $chash{$category}++;
	    $ret="<font color='#ff0000'><b>$ret</b></font>";
	}
	$line=~s/\<\!\-\- POSTEVAL .*? \-\-\>/$ret/;
    }
    elsif ($arguments=~/^byteandlinecount/) {

    }
    if ($line=~/\<\!\-\- POSTEVALINLINE (.*?) \-\-\>/) {
	my $count=$chash{$1}+0;
	$line=~s/<\!\-\- POSTEVALINLINE .*? \-\-\>/$count/;
    }
    print $line;
}
