#!/usr/bin/perl -w
#
use strict;
use GDBM_File;
use lib '/home/httpd/lib/perl/';
use LONCAPA;

my %resourceaccess;

sub main {
    my $file=$ARGV[0];
    my $target = $ARGV[1];
    my ($owner) = ($target =~ m:.*/(.*)/nohist_accesscount.db:);
    print STDERR "source: $file\ntarget: $target\nowner: $owner\n";
    my $accesstime = 0;
    my $starttime = time;
    if (-e $target) {
	my $accessDB = &LONCAPA::locking_hash_tie($target,&GDBM_READER());
	if (! $accessDB) {
            warn "Unable to tie to $target";
            return;
        }
        #
        if (exists($accessDB->{'tabulated '.$file})) {
            $accesstime = $accessDB->{'tabulated '.$file};
        }
	&LONCAPA::locking_hash_untie($accessDB);
    }
    #
    my $line;
    open FILEID,'<'.$file;
    my @allaccess;
    print STDERR "Access by resource after $accesstime\n\n";
    my $numlines = 0;
    while ($line=<FILEID>) {
        $numlines++;
        if (int($numlines / 1000)*1000 == $numlines) {
            if (int($numlines / 10000)*10000 == $numlines) {
                print STDERR '*';
            } else {
                print STDERR '.';
            }
            if (int($numlines / 50000)*50000 == $numlines) {
                print STDERR $/;
            }
        }
        next if ($line eq '' || $line !~ /:/);
        chomp($line);
        my ($time,$machine,$what)=split(':',$line);
	$what=&unescape($what);
        my @accesses = split(/(\d{10}):/,$what);
        shift(@accesses);
	while (@accesses) {
            my $date = shift(@accesses);
            next if ($date =~ /\D/ || $date < $accesstime);
            my $access = shift(@accesses);
            next if (! defined($access) || $access eq '' || 
                     ! defined($date)   || $date   eq '');
            $access =~ s/(\&$|^:)//g;
            my ($resource,$who,$domain,$post,@posts)=split(':',$access);
	    if (!$resource || $resource eq '') {
                next; 
            }
            $resource = &unescape($resource);
            if ($resource !~ m:/$owner/:) {
                next;
            }
            if ($resource =~ /___\d+___/) {
                (undef,$resource) = split(/___\d+___/,$resource);
            }
            next if ($resource =~ m:^/(res/adm|adm)/:);
            $resource =~ s:^/?res/::;
            $resourceaccess{$resource}++;            
	}
    }
    print STDERR 'done.  Updating '.$target.$/;

    my $accessDB = &LONCAPA::locking_hash_tie($target,&GDBM_WRCREAT());
    if (! $accessDB) {
        warn "Unable to open $target to store data".$/;
        return;
    }
    #
    while (my ($resource,$count) = each(%resourceaccess)) {
        $resource = &escape($resource);
        if (exists($accessDB->{$resource})) {
            $accessDB->{$resource}+=$count;
        } else {
            $accessDB->{$resource} = $count;
        }
        print sprintf("%10.0f",$count).':'.$resource."\n";
    }
    $accessDB->{'tabulated '.$file} = $starttime;
    &LONCAPA::locking_hash_untie($accessDB);
}

main;
