# The LearningOnline Network with CAPA
# external style responses
#
# $Id: loncapagrade.pm,v 1.3 2005/10/18 14:14:12 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# 1/26 Guy
package Apache::loncapagrade;
use strict;

#Globals
# results of parse end up in here
%Apache::loncapagrade::result=();

BEGIN {
#  &Apache::lonxml::register('Apache::loncapagrade',
#			    ('loncapagrade','awardetail','message'));
}

sub start_loncapagrade {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'grade') {
	%Apache::loncapagrade::results=();
	&Apache::lonxml::register('Apache::loncapagrade',
				  ('awarddetail','message'));
    }
    return $result;
}

sub end_loncapagrade {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'grade') {
	&Apache::lonxml::deregister('Apache::loncapagrade',
				    ('loncapagrade','awardetail','message'));
    }
    return $result;
}

sub start_awarddetail {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'grade') { &Apache::lonxml::startredirection(); }
    return $result;
}

sub end_awarddetail {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'grade') {
	$Apache::loncapagrade::results{'awarddetail'}=
	    &Apache::lonxml::endredirection();
    }
    return $result;
}

sub start_message {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'grade') { &Apache::lonxml::startredirection(); }
    return $result;
}

sub end_message {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'grade') {
	$Apache::loncapagrade::results{'message'}=
	    &Apache::lonxml::endredirection();
    }
    return $result;
}

1;
__END__

