# The LearningOnline Network
# "Group Chat Frame" Personal Information
#
# $Id: longroupchat.pm,v 1.9 2006/06/26 22:21:37 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
package Apache::longroupchat;

use strict;
use Apache::Constants qw(:common);
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonlocal;
use Apache::longroup();
use lib '/home/httpd/lib/perl/';
use LONCAPA;
 

sub handler {
    my ($r) = @_;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['group']);
    my $group = $env{'form.group'};
    my $grouptitle;
    if (defined($group)) {
        my $cnum=$env{'course.'.$env{'request.course.id'}.'.num'};
        my $cdom=$env{'course.'.$env{'request.course.id'}.'.domain'};
        my %curr_groups = &Apache::longroup::coursegroups($cdom,$cnum,$group);
        if (%curr_groups) {
            my %group_info = 
		&Apache::longroup::get_group_settings($curr_groups{$group});
            $grouptitle = &mt('Group Chat:').' '.
		&unescape($group_info{description});
        }
    }

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
    my $start_page =
	&Apache::loncommon::start_page($grouptitle,undef,
				       {'frameset'    => 1,
					'add_entries' => {
					    'rows'   => "80,100,*",
					    'border' => "0"},});
    my $end_page =
	&Apache::loncommon::end_page({'frameset' => 1});

    $r->print(<<"END");
$start_page
<frame name="chatacc" src="/adm/chatfetch?group=$group">
<frame name="chatpost" src="/adm/chat?group=$group">
<frame name="chatout" src="/adm/rat/empty.html">
$end_page
END
    return OK;
}

1;
