/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolBioResolver;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.CellInfo;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Mmset;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class ModelLoader
extends ModelSet {
    private ModelLoader mergeModelSet;
    private boolean merging;
    private boolean isMultiFile;
    private boolean isTrajectory = false;
    private final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    private String[] group3Lists;
    private int[][] group3Counts;
    private Group[] groups;
    private int groupCount;
    private boolean someModelsHaveUnitcells;
    private boolean someModelsHaveFractionalCoordinates;
    private static final int ATOM_GROWTH_INCREMENT = 2000;
    private final Hashtable htAtomMap = new Hashtable();
    private static final int defaultGroupCount = 32;
    private Chain[] chains;
    private String[] group3s;
    private int[] seqcodes;
    private int[] firstAtomIndexes;
    private int currentModelIndex;
    private Model currentModel;
    private char currentChainID;
    private Chain currentChain;
    private int currentGroupSequenceNumber;
    private char currentGroupInsertionCode;
    private String currentGroup3;
    private Chain nullChain;
    Group nullGroup;
    private int baseModelIndex = 0;
    private int baseModelCount = 0;
    private int baseAtomIndex = 0;
    private int baseBondIndex = 0;
    private int baseGroupIndex = 0;
    private boolean appendNew = true;
    private BitSet structuresDefinedInFile = new BitSet();
    private final Point3f pointMin = new Point3f();
    private final Point3f pointMax = new Point3f();
    private static final Point3f[] unitBboxPoints = new Point3f[]{new Point3f(1.0f, 1.0f, 1.0f), new Point3f(1.0f, 1.0f, -1.0f), new Point3f(1.0f, -1.0f, 1.0f), new Point3f(1.0f, -1.0f, -1.0f), new Point3f(-1.0f, 1.0f, 1.0f), new Point3f(-1.0f, 1.0f, -1.0f), new Point3f(-1.0f, -1.0f, 1.0f), new Point3f(-1.0f, -1.0f, -1.0f)};
    private boolean haveBioClasses = true;
    private JmolBioResolver jbr = null;

    ModelLoader(Viewer viewer, String string) {
        this.viewer = viewer;
        this.initializeInfo(string, 1, null, null);
        this.initializeModelSet(null, null);
    }

    ModelLoader(Viewer viewer, JmolAdapter jmolAdapter, Object object, ModelLoader modelLoader) {
        this.mergeModelSet = modelLoader;
        this.merging = modelLoader != null && modelLoader.atomCount > 0;
        this.viewer = viewer;
        this.initializeInfo(jmolAdapter.getFileTypeName(object).toLowerCase().intern(), jmolAdapter.getEstimatedAtomCount(object), jmolAdapter.getAtomSetCollectionProperties(object), jmolAdapter.getAtomSetCollectionAuxiliaryInfo(object));
        this.initializeModelSet(jmolAdapter, object);
        jmolAdapter.finish(object);
    }

    private void initializeInfo(String string, int n, Properties properties, Hashtable hashtable) {
        this.g3d = this.viewer.getGraphics3D();
        this.modelSetTypeName = string;
        this.isXYZ = this.modelSetTypeName == "xyz";
        this.setZeroBased();
        this.mmset = new Mmset(this);
        this.mmset.setModelSetProperties(properties);
        this.mmset.setModelSetAuxiliaryInfo(hashtable);
        this.isMultiFile = this.mmset.getModelSetAuxiliaryInfoBoolean("isMultiFile");
        this.isPDB = this.mmset.getModelSetAuxiliaryInfoBoolean("isPDB");
        this.trajectories = (Vector)this.mmset.getModelSetAuxiliaryInfo("trajectories");
        this.isTrajectory = this.trajectories != null;
        this.someModelsHaveSymmetry = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.someModelsHaveFractionalCoordinates = this.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        if (this.merging) {
            this.someModelsHaveSymmetry |= this.mergeModelSet.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
            this.someModelsHaveUnitcells |= this.mergeModelSet.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
            this.someModelsHaveFractionalCoordinates |= this.mergeModelSet.mmset.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        }
        this.initializeBuild(n);
    }

    private void initializeBuild(int n) {
        if (n <= 0) {
            n = 2000;
        }
        if (this.merging) {
            this.atoms = this.mergeModelSet.atoms;
            this.bonds = this.mergeModelSet.bonds;
        } else {
            this.atoms = new Atom[n];
            this.bonds = new Bond[250 + n];
        }
        this.htAtomMap.clear();
        this.initializeGroupBuild();
    }

    private void initializeGroupBuild() {
        this.chains = new Chain[32];
        this.group3s = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
        this.currentModelIndex = -1;
        this.currentModel = null;
    }

    private void initializeModelSet(JmolAdapter jmolAdapter, Object object) {
        this.modelCount = jmolAdapter == null ? 1 : jmolAdapter.getAtomSetCount(object);
        int n = this.modelCount;
        this.initializeAtomBondModelCounts();
        if (jmolAdapter == null) {
            this.mmset.setModelNameNumberProperties(0, "", 1, null, null, false);
        } else {
            boolean bl = this.appendNew = this.modelCount > 1 || this.viewer.getAppendNew();
            if (this.modelCount > 0) {
                Logger.info((String)("ModelSet: haveSymmetry:" + this.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.someModelsHaveFractionalCoordinates));
                Logger.info((String)(this.modelCount + " model" + (this.modelCount == 1 ? "" : "s") + (this.isTrajectory ? ", " + this.trajectories.size() + " trajectories" : "") + " in this collection. Use getProperty \"modelInfo\" or" + " getProperty \"auxiliaryInfo\" to inspect them."));
            }
            this.iterateOverAllNewModels(jmolAdapter, object, n);
            this.iterateOverAllNewAtoms(jmolAdapter, object);
            this.iterateOverAllNewBonds(jmolAdapter, object);
            this.iterateOverAllNewStructures(jmolAdapter, object);
            this.initializeUnitCellAndSymmetry(n);
            this.initializeBonding();
        }
        this.finalizeGroupBuild();
        this.freeze();
        this.calcAverageAtomPoint();
        this.calcBoundBoxDimensions();
        this.finalizeShapes();
    }

    private void initializeAtomBondModelCounts() {
        this.atomCount = 0;
        this.bondCount = 0;
        if (this.merging) {
            this.baseModelCount = this.mergeModelSet.modelCount;
            if (this.appendNew) {
                this.baseModelIndex = this.baseModelCount;
                this.modelCount += this.baseModelCount;
            } else {
                this.baseModelIndex = this.viewer.getCurrentModelIndex();
                if (this.baseModelIndex < 0) {
                    this.baseModelIndex = this.baseModelCount - 1;
                }
                this.modelCount = this.baseModelCount;
            }
            this.atomCount = this.baseAtomIndex = this.mergeModelSet.atomCount;
            this.bondCount = this.baseBondIndex = this.mergeModelSet.bondCount;
            this.groupCount = this.baseGroupIndex = this.mergeModelSet.groupCount;
        }
        this.mmset.setModelCount(this.modelCount);
    }

    private void initializeMerge() {
        this.mmset.merge(this.mergeModelSet.mmset);
        this.bsSymmetry = this.mergeModelSet.bsSymmetry;
        if (this.mergeModelSet.group3Lists != null) {
            for (int i = 0; i < this.baseModelCount; ++i) {
                this.group3Lists[i] = this.mergeModelSet.group3Lists[i];
                this.group3Counts[i] = this.mergeModelSet.group3Counts[i];
                this.structuresDefinedInFile.set(i);
            }
            this.group3Lists[this.modelCount] = this.mergeModelSet.group3Lists[this.baseModelCount];
            this.group3Counts[this.modelCount] = this.mergeModelSet.group3Counts[this.baseModelCount];
        }
        if (!this.appendNew && this.isPDB) {
            this.structuresDefinedInFile.clear(this.baseModelIndex);
        }
        this.atomNames = this.mergeModelSet.atomNames;
        this.clientAtomReferences = this.mergeModelSet.clientAtomReferences;
        this.vibrationVectors = this.mergeModelSet.vibrationVectors;
        this.occupancies = this.mergeModelSet.occupancies;
        this.bfactor100s = this.mergeModelSet.bfactor100s;
        this.partialCharges = this.mergeModelSet.partialCharges;
        this.specialAtomIDs = this.mergeModelSet.specialAtomIDs;
        this.surfaceDistance100s = null;
    }

    private void iterateOverAllNewModels(JmolAdapter jmolAdapter, Object object, int n) {
        if (this.modelCount > 0) {
            this.nullChain = new Chain(this, this.mmset.getModel(this.baseModelIndex), ' ');
            this.nullGroup = new Group(this.nullChain, "", 0, -1, -1);
        }
        this.group3Lists = new String[this.modelCount + 1];
        this.group3Counts = new int[this.modelCount + 1][];
        this.structuresDefinedInFile = new BitSet();
        if (this.merging) {
            this.initializeMerge();
        }
        int n2 = this.baseModelIndex;
        int n3 = 0;
        while (n3 < n) {
            Hashtable hashtable;
            Properties properties;
            boolean bl;
            int n4 = this.appendNew ? jmolAdapter.getAtomSetNumber(object, n3) : Integer.MAX_VALUE;
            String string = jmolAdapter.getAtomSetName(object, n3);
            if (string == null) {
                String string2 = string = n4 == Integer.MAX_VALUE ? "" : "" + n4;
            }
            if (bl = this.mmset.setModelNameNumberProperties(n2, string, n4, properties = jmolAdapter.getAtomSetProperties(object, n3), hashtable = jmolAdapter.getAtomSetAuxiliaryInfo(object, n3), this.isPDB)) {
                this.group3Lists[n2] = JmolConstants.group3List;
                this.group3Counts[n2] = new int[JmolConstants.group3Count + 10];
                if (this.group3Lists[this.modelCount] == null) {
                    this.group3Lists[this.modelCount] = JmolConstants.group3List;
                    this.group3Counts[this.modelCount] = new int[JmolConstants.group3Count + 10];
                }
            }
            if (this.mmset.getModelAuxiliaryInfo(n2, "periodicOriginXyz") != null) {
                this.someModelsHaveSymmetry = true;
            }
            ++n3;
            ++n2;
        }
        this.mmset.finalizeModelNumbers(this.baseModelCount);
    }

    private void iterateOverAllNewAtoms(JmolAdapter jmolAdapter, Object object) {
        short s;
        short s2 = this.viewer.getMadAtom();
        JmolAdapter.AtomIterator atomIterator = jmolAdapter.getAtomIterator(object);
        while (atomIterator.hasNext()) {
            s = (short)atomIterator.getElementNumber();
            if (s <= 0) {
                s = JmolConstants.elementNumberFromSymbol(atomIterator.getElementSymbol());
            }
            char c = atomIterator.getAlternateLocationID();
            this.addAtom(atomIterator.getAtomSetIndex() + this.baseModelIndex, atomIterator.getAtomSymmetry(), atomIterator.getAtomSite(), atomIterator.getUniqueID(), s, atomIterator.getAtomName(), s2, atomIterator.getFormalCharge(), atomIterator.getPartialCharge(), atomIterator.getOccupancy(), atomIterator.getBfactor(), atomIterator.getX(), atomIterator.getY(), atomIterator.getZ(), atomIterator.getIsHetero(), atomIterator.getAtomSerial(), atomIterator.getChainID(), atomIterator.getGroup3(), atomIterator.getSequenceNumber(), atomIterator.getInsertionCode(), atomIterator.getVectorX(), atomIterator.getVectorY(), atomIterator.getVectorZ(), c, atomIterator.getClientAtomReference(), atomIterator.getRadius());
        }
        short s3 = -1;
        for (s = 0; s < this.atomCount; ++s) {
            if (this.atoms[s].modelIndex == s3) continue;
            s3 = this.atoms[s].modelIndex;
            this.mmset.setFirstAtomIndex(s3, s);
        }
    }

    private void addAtom(int n, BitSet bitSet, int n2, Object object, short s, String string, short s2, int n3, float f, int n4, float f2, float f3, float f4, float f5, boolean bl, int n5, char c, String string2, int n6, char c2, float f6, float f7, float f8, char c3, Object object2, float f9) {
        this.checkNewGroup(this.atomCount, n, c, string2, n6, c2);
        if (this.atomCount == this.atoms.length) {
            this.growAtomArrays(2000);
        }
        Atom atom = new Atom(this, this.currentModelIndex, this.atomCount, bitSet, n2, s, string, s2, n3, f, n4, f2, f3, f4, f5, bl, n5, c, string2, f6, f7, f8, c3, object2, f9);
        this.atoms[this.atomCount++] = atom;
        this.htAtomMap.put(object, atom);
    }

    private void checkNewGroup(int n, int n2, char c, String string, int n3, char c2) {
        String string2;
        String string3 = string2 = string == null ? null : string.intern();
        if (n2 != this.currentModelIndex) {
            this.currentModel = this.mmset.getModel(n2);
            this.currentModelIndex = n2;
            this.currentChainID = (char)65535;
        }
        if (c != this.currentChainID) {
            this.currentChainID = c;
            this.currentChain = this.currentModel.getOrAllocateChain(c);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
        }
        if (n3 != this.currentGroupSequenceNumber || c2 != this.currentGroupInsertionCode || string2 != this.currentGroup3) {
            this.currentGroupSequenceNumber = n3;
            this.currentGroupInsertionCode = c2;
            this.currentGroup3 = string2;
            while (this.groupCount >= this.group3s.length) {
                this.chains = (Chain[])ArrayUtil.doubleLength((Object)this.chains);
                this.group3s = ArrayUtil.doubleLength((String[])this.group3s);
                this.seqcodes = ArrayUtil.doubleLength((int[])this.seqcodes);
                this.firstAtomIndexes = ArrayUtil.doubleLength((int[])this.firstAtomIndexes);
            }
            this.firstAtomIndexes[this.groupCount] = n;
            this.chains[this.groupCount] = this.currentChain;
            this.group3s[this.groupCount] = string;
            this.seqcodes[this.groupCount] = Group.getSeqcode(n3, c2);
            ++this.groupCount;
        }
    }

    private void growAtomArrays(int n) {
        int n2 = this.atomCount + n;
        this.atoms = (Atom[])ArrayUtil.setLength((Object)this.atoms, (int)n2);
        if (this.clientAtomReferences != null) {
            this.clientAtomReferences = (Object[])ArrayUtil.setLength((Object)this.clientAtomReferences, (int)n2);
        }
        if (this.vibrationVectors != null) {
            this.vibrationVectors = (Vector3f[])ArrayUtil.setLength((Object)this.vibrationVectors, (int)n2);
        }
        if (this.occupancies != null) {
            this.occupancies = ArrayUtil.setLength((byte[])this.occupancies, (int)n2);
        }
        if (this.bfactor100s != null) {
            this.bfactor100s = ArrayUtil.setLength((short[])this.bfactor100s, (int)n2);
        }
        if (this.partialCharges != null) {
            this.partialCharges = ArrayUtil.setLength((float[])this.partialCharges, (int)n2);
        }
        if (this.atomNames != null) {
            this.atomNames = ArrayUtil.setLength((String[])this.atomNames, (int)n2);
        }
        if (this.atomSerials != null) {
            this.atomSerials = ArrayUtil.setLength((int[])this.atomSerials, (int)n2);
        }
        if (this.specialAtomIDs != null) {
            this.specialAtomIDs = ArrayUtil.setLength((byte[])this.specialAtomIDs, (int)n2);
        }
    }

    private void iterateOverAllNewBonds(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.BondIterator bondIterator = jmolAdapter.getBondIterator(object);
        if (bondIterator != null) {
            while (bondIterator.hasNext()) {
                this.bondAtoms(bondIterator.getAtomUniqueID1(), bondIterator.getAtomUniqueID2(), (short)bondIterator.getEncodedOrder());
            }
        }
    }

    private void bondAtoms(Object object, Object object2, short s) {
        Atom atom;
        if (this.defaultCovalentMad == 0) {
            this.defaultCovalentMad = this.viewer.getMadBond();
        }
        if ((atom = (Atom)((Object)this.htAtomMap.get(object))) == null) {
            Logger.error((String)("bondAtoms cannot find atomUid1?:" + object));
            return;
        }
        Atom atom2 = (Atom)((Object)this.htAtomMap.get(object2));
        if (atom2 == null) {
            Logger.error((String)("bondAtoms cannot find atomUid2?:" + object2));
            return;
        }
        if (atom.isBonded(atom2)) {
            return;
        }
        Bond bond = this.bondMutually(atom, atom2, s, this.getDefaultMadFromOrder(s));
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength((Object)this.bonds, (int)(this.bondCount + 4000));
        }
        this.setBond(this.bondCount++, bond);
    }

    private void iterateOverAllNewStructures(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.StructureIterator structureIterator = jmolAdapter.getStructureIterator(object);
        if (structureIterator != null) {
            while (structureIterator.hasNext()) {
                if (structureIterator.getStructureType().equals("turn")) continue;
                this.defineStructure(structureIterator.getModelIndex() + this.baseModelIndex, structureIterator.getStructureType(), structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
        if ((structureIterator = jmolAdapter.getStructureIterator(object)) != null) {
            while (structureIterator.hasNext()) {
                if (!structureIterator.getStructureType().equals("turn")) continue;
                this.defineStructure(structureIterator.getModelIndex() + this.baseModelIndex, structureIterator.getStructureType(), structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
    }

    private void defineStructure(int n, String string, char c, int n2, char c2, char c3, int n3, char c4) {
        this.structuresDefinedInFile.set(n);
        this.mmset.defineStructure(n, string, c, n2, c2, c3, n3, c4);
    }

    private void initializeUnitCellAndSymmetry(int n) {
        int n2;
        int n3;
        if (this.someModelsHaveUnitcells) {
            n3 = n == 1 ? 1 : 0;
            this.cellInfos = new CellInfo[this.modelCount];
            for (n2 = 0; n2 < this.baseModelCount; ++n2) {
                this.cellInfos[n2] = this.mergeModelSet.cellInfos != null ? this.mergeModelSet.cellInfos[n2] : new CellInfo(n2, false, this.mmset.getModelAuxiliaryInfo(n2));
            }
            for (n2 = this.baseModelCount; n2 < this.modelCount; ++n2) {
                this.cellInfos[n2] = new CellInfo(n2, n3 != 0, this.mmset.getModelAuxiliaryInfo(n2));
            }
        }
        if (this.someModelsHaveSymmetry) {
            this.getSymmetrySet();
            n2 = -1;
            int n4 = 0;
            for (n3 = this.baseAtomIndex; n3 < this.atomCount; ++n3) {
                if (this.atoms[n3].modelIndex != n2) {
                    n2 = this.atoms[n3].modelIndex;
                    n4 = this.baseAtomIndex + this.mmset.getModelAuxiliaryInfoInt(n2, "presymmetryAtomIndex") + this.mmset.getModelAuxiliaryInfoInt(n2, "presymmetryAtomCount");
                }
                if (n3 < n4) continue;
                this.bsSymmetry.set(n3);
            }
        }
        if (this.someModelsHaveFractionalCoordinates) {
            for (n3 = this.baseAtomIndex; n3 < this.atomCount; ++n3) {
                n2 = this.atoms[n3].modelIndex;
                if (!this.cellInfos[n2].coordinatesAreFractional) continue;
                this.cellInfos[n2].toCartesian((Point3f)this.atoms[n3]);
                if (!Logger.isActiveLevel((int)0)) continue;
                Logger.debug((String)("atom " + n3 + ": " + (Object)((Object)this.atoms[n3])));
            }
        }
    }

    private void initializeBonding() {
        boolean bl;
        boolean bl2 = bl = this.bondCount == this.baseBondIndex || this.isMultiFile || this.isPDB && this.bondCount - this.baseBondIndex < (this.atomCount - this.baseAtomIndex) / 2 || this.someModelsHaveSymmetry && !this.viewer.getApplySymmetryToBonds();
        if (this.viewer.getForceAutoBond() || bl && this.viewer.getAutoBond() && this.getModelSetProperty("noautobond") == null) {
            BitSet bitSet = null;
            if (this.merging) {
                bitSet = new BitSet(this.atomCount);
                for (int i = this.baseAtomIndex; i < this.atomCount; ++i) {
                    bitSet.set(i);
                }
            }
            Logger.info((String)"ModelSet: autobonding; use  autobond=false  to not generate bonds automatically");
            this.autoBond(bitSet, bitSet, null);
        } else {
            Logger.info((String)"ModelSet: not autobonding; use forceAutobond=true to force automatic bond creation");
        }
    }

    private void calcBoundBoxDimensions() {
        this.calcAtomsMinMax();
        if (this.cellInfos != null) {
            this.calcUnitCellMinMax();
        }
        this.centerBoundBox.add((Tuple3f)this.pointMin, (Tuple3f)this.pointMax);
        this.centerBoundBox.scale(0.5f);
        this.boundBoxCornerVector.sub((Tuple3f)this.pointMax, (Tuple3f)this.centerBoundBox);
        int n = 8;
        while (--n >= 0) {
            Point3f point3f = this.bboxVertices[n] = new Point3f(unitBboxPoints[n]);
            point3f.x *= this.boundBoxCornerVector.x;
            point3f.y *= this.boundBoxCornerVector.y;
            point3f.z *= this.boundBoxCornerVector.z;
            point3f.add((Tuple3f)this.centerBoundBox);
        }
    }

    private void calcAtomsMinMax() {
        if (this.atomCount < 2) {
            this.pointMin.set(-10.0f, -10.0f, -10.0f);
            this.pointMax.set(10.0f, 10.0f, 10.0f);
            return;
        }
        this.pointMin.set((Tuple3f)this.atoms[0]);
        this.pointMax.set((Tuple3f)this.atoms[0]);
        int n = this.atomCount;
        while (--n > 0) {
            this.checkMinMax((Point3f)this.atoms[n]);
        }
    }

    private void calcUnitCellMinMax() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.cellInfos[i].coordinatesAreFractional) continue;
            Point3f[] point3fArray = this.cellInfos[i].getUnitCell().getVertices();
            for (int j = 0; j < 8; ++j) {
                this.checkMinMax(point3fArray[j]);
            }
        }
    }

    private void checkMinMax(Point3f point3f) {
        float f = point3f.x;
        if (f < this.pointMin.x) {
            this.pointMin.x = f;
        } else if (f > this.pointMax.x) {
            this.pointMax.x = f;
        }
        f = point3f.y;
        if (f < this.pointMin.y) {
            this.pointMin.y = f;
        } else if (f > this.pointMax.y) {
            this.pointMax.y = f;
        }
        f = point3f.z;
        if (f < this.pointMin.z) {
            this.pointMin.z = f;
        } else if (f > this.pointMax.z) {
            this.pointMax.z = f;
        }
    }

    private void finalizeGroupBuild() {
        Hashtable hashtable;
        int n;
        this.groups = new Group[this.groupCount];
        if (this.merging) {
            for (n = 0; n < this.baseGroupIndex; ++n) {
                this.groups[n] = this.mergeModelSet.groups[n];
                this.groups[n].setModelSet(this);
            }
        }
        for (n = this.baseGroupIndex; n < this.groupCount; ++n) {
            this.distinguishAndPropagateGroup(n, this.chains[n], this.group3s[n], this.seqcodes[n], this.firstAtomIndexes[n], n == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[n + 1]);
            this.chains[n] = null;
            this.group3s[n] = null;
        }
        this.chains = null;
        this.group3s = null;
        if (this.group3Lists != null && (hashtable = this.getModelSetAuxiliaryInfo()) != null) {
            hashtable.put("group3Lists", this.group3Lists);
            hashtable.put("group3Counts", this.group3Counts);
        }
        this.group3Counts = null;
        this.group3Lists = null;
        for (int i = this.baseGroupIndex; i < this.groupCount; ++i) {
            Group group = this.groups[i];
            if (this.jbr == null) continue;
            this.jbr.buildBioPolymer(group, this.groups, i);
        }
    }

    private void distinguishAndPropagateGroup(int n, Chain chain, String string, int n2, int n3, int n4) {
        Object object;
        int n5 = n4 - 1;
        if (n5 < n3) {
            throw new NullPointerException();
        }
        short s = this.atoms[n3].modelIndex;
        Group group = null;
        if (string != null && this.specialAtomIDs != null && this.haveBioClasses) {
            if (this.jbr == null && this.haveBioClasses) {
                try {
                    object = Class.forName("org.jmol.modelsetbio.Resolver");
                    this.jbr = (JmolBioResolver)((Class)object).newInstance();
                    this.haveBioClasses = true;
                }
                catch (Exception exception) {
                    Logger.error((String)"developer error: org.jmol.modelsetbio.Resolver could not be found");
                    this.haveBioClasses = false;
                }
            }
            if (this.haveBioClasses) {
                group = this.jbr.distinguishAndPropagateGroup(chain, string, n2, n3, n4, (int)s, this.modelCount, this.specialAtomIndexes, this.specialAtomIDs, this.atoms);
            }
        }
        if (group == null) {
            group = new Group(chain, string, n2, n3, n5);
            object = "o>";
        } else {
            Object object2 = group.isProtein() ? "p>" : (group.isNucleic() ? "n>" : (object = group.isCarbohydrate() ? "c>" : "o>"));
        }
        if (string != null) {
            this.countGroup(s, (String)object, string);
        }
        chain.addGroup(group);
        this.groups[n] = group;
        int n6 = n4;
        while (--n6 >= n3) {
            this.atoms[n6].setGroup(group);
        }
    }

    private void countGroup(int n, String string, String string2) {
        if (this.group3Lists == null || this.group3Lists[n] == null) {
            return;
        }
        String string3 = (string2 + "   ").substring(0, 3);
        int n2 = this.group3Lists[n].indexOf(string3);
        if (n2 < 0) {
            int n3 = n;
            this.group3Lists[n3] = this.group3Lists[n3] + ",[" + string3 + "]";
            n2 = this.group3Lists[n].indexOf(string3);
            this.group3Counts[n] = ArrayUtil.setLength((int[])this.group3Counts[n], (int)(this.group3Counts[n].length + 10));
        }
        int[] nArray = this.group3Counts[n];
        int n4 = n2 / 6;
        nArray[n4] = nArray[n4] + 1;
        n2 = this.group3Lists[n].indexOf(",[" + string3);
        if (n2 >= 0) {
            this.group3Lists[n] = this.group3Lists[n].substring(0, n2) + string + this.group3Lists[n].substring(n2 + 2);
        }
        if (n < this.modelCount) {
            this.countGroup(this.modelCount, string, string2);
        }
    }

    private void freeze() {
        if (this.atomCount < this.atoms.length) {
            this.growAtomArrays(0);
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength((Object)this.bonds, (int)this.bondCount);
        }
        int n = 5;
        while (--n > 0) {
            this.numCached[n] = 0;
            Bond[][] bondArray = this.freeBonds[n];
            int n2 = bondArray.length;
            while (--n2 >= 0) {
                bondArray[n2] = null;
            }
        }
        this.setAtomNamesAndNumbers();
        this.findElementsPresent();
        if (this.isPDB) {
            this.calculateStructuresAllExcept(this.structuresDefinedInFile);
        }
        this.modelCount = this.mmset.getModelCount();
        this.molecules = null;
        this.moleculeCount = 0;
        this.currentModel = null;
        this.currentChain = null;
        this.htAtomMap.clear();
    }

    private void setAtomNamesAndNumbers() {
        Atom atom;
        int n;
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.atomCount];
        }
        int s = Integer.MAX_VALUE;
        int n2 = 0;
        for (n = 0; n < this.atomCount; ++n) {
            short s2;
            atom = this.atoms[n];
            if (atom.modelIndex != s2) {
                s2 = atom.modelIndex;
                int n3 = n2 = this.isZeroBased ? 0 : 1;
            }
            if (this.atomSerials[n] != 0) continue;
            this.atomSerials[n] = n < this.baseAtomIndex ? this.mergeModelSet.atomSerials[n] : n2++;
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atomCount];
        }
        for (n = 0; n < this.atomCount; ++n) {
            if (this.atomNames[n] != null) continue;
            atom = this.atoms[n];
            this.atomNames[n] = atom.getElementSymbol() + atom.getAtomNumber();
        }
    }

    private void findElementsPresent() {
        int n;
        this.elementsPresent = new BitSet[this.modelCount];
        for (n = 0; n < this.modelCount; ++n) {
            this.elementsPresent[n] = new BitSet();
        }
        n = this.atomCount;
        while (--n >= 0) {
            int n2 = this.atoms[n].getAtomicAndIsotopeNumber();
            if (n2 >= 128) {
                n2 = JmolConstants.elementNumberMax + JmolConstants.altElementIndexFromNumber(n2);
            }
            this.elementsPresent[this.atoms[n].modelIndex].set(n2);
        }
    }

    private void calcAverageAtomPoint() {
        this.averageAtomPoint.set(0.0f, 0.0f, 0.0f);
        if (this.atomCount == 0) {
            return;
        }
        int n = this.atomCount;
        while (--n >= 0) {
            this.averageAtomPoint.add((Tuple3f)this.atoms[n]);
        }
        this.averageAtomPoint.scale(1.0f / (float)this.atomCount);
    }

    private void finalizeShapes() {
        if (this.merging) {
            for (int i = 0; i < 31; ++i) {
                this.shapes[i] = this.mergeModelSet.shapes[i];
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(this);
            }
            this.viewer.getFrameRenderer().clear();
            this.merging = false;
            return;
        }
        this.loadShape(0);
        this.loadShape(1);
        this.loadShape(6);
        this.loadShape(19);
        this.loadShape(20);
    }
}

