/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementPending;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;

public class Measures
extends Shape {
    BitSet bsColixSet;
    BitSet bsSelected;
    static final int measurementGrowthIncrement = 16;
    int measurementCount = 0;
    Measurement[] measurements = new Measurement[16];
    MeasurementPending pendingMeasurement;
    short mad = (short)-1;
    short colix;
    String strFormat;
    boolean showMeasurementNumbers = true;
    boolean isAllConnected = false;
    Font3D font3d;
    float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};

    protected void initModelSet() {
        this.pendingMeasurement = new MeasurementPending(this.modelSet);
    }

    public void initShape() {
        super.initShape();
        this.font3d = this.g3d.getFont3D(15);
    }

    public void setSize(int n, BitSet bitSet) {
        this.mad = (short)n;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("select".equals(string)) {
            BitSet bitSet2 = (BitSet)object;
            if (bitSet2 == null || BitSetUtil.cardinalityOf((BitSet)bitSet2) == 0) {
                this.bsSelected = null;
            } else {
                this.bsSelected = new BitSet();
                this.bsSelected.or(bitSet2);
            }
            return;
        }
        if ("color".equals(string)) {
            short s;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            short s2 = s = object == null ? (short)0 : Graphics3D.getColix((Object)object);
            if (this.bsSelected == null) {
                this.colix = s;
            }
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i] == null || (this.bsSelected == null || !this.bsSelected.get(i)) && (this.bsSelected != null || s != 0 && this.measurements[i].getColix() != 0)) continue;
                this.measurements[i].setColix(s);
                this.bsColixSet.set(i);
            }
            return;
        }
        if ("delete".equals(string)) {
            this.delete(object);
            this.setIndices();
            return;
        }
        if ("hideAll".equals(string)) {
            this.showHide((Boolean)object);
            return;
        }
        if ("setFormats".equals(string)) {
            this.setFormats((String)object);
            return;
        }
        this.bsSelected = null;
        if ("hide".equals(string)) {
            this.showHide((int[])object, true);
        } else if ("show".equals(string)) {
            this.showHide((int[])object, false);
        } else if ("setRange".equals(string)) {
            this.setRange((float[])object);
        } else if ("setFormat".equals(string)) {
            this.strFormat = (String)object;
        } else if ("setConnected".equals(string)) {
            this.setConnected((Boolean)object);
        } else if ("defineVector".equals(string)) {
            this.define((Vector)object, false, false, false);
        } else if ("deleteVector".equals(string)) {
            this.define((Vector)object, true, false, false);
            this.setIndices();
        } else if ("hideVector".equals(string)) {
            this.define((Vector)object, false, false, true);
        } else if ("showVector".equals(string)) {
            this.define((Vector)object, false, true, false);
        } else if ("toggle".equals(string)) {
            this.toggle((int[])object);
        } else if ("toggleOn".equals(string)) {
            this.toggleOn((int[])object);
        } else if ("pending".equals(string)) {
            this.pending((int[])object);
        } else if ("font".equals(string)) {
            this.font3d = (Font3D)object;
        } else if ("clear".equals(string)) {
            this.clear();
        } else if ("showMeasurementNumbers".equals(string)) {
            this.showMeasurementNumbers = (Boolean)object;
        } else if ("reformatDistances".equals(string)) {
            this.reformatDistances();
        }
    }

    public Object getProperty(String string, int n) {
        if ("count".equals(string)) {
            return new Integer(this.measurementCount);
        }
        if ("countPlusIndices".equals(string)) {
            return n < this.measurementCount ? this.measurements[n].getCountPlusIndices() : null;
        }
        if ("stringValue".equals(string)) {
            return n < this.measurementCount ? this.measurements[n].getString() : null;
        }
        if ("info".equals(string)) {
            return this.getAllInfo();
        }
        if ("infostring".equals(string)) {
            return this.getAllInfoAsString();
        }
        return null;
    }

    private void clear() {
        int n = this.measurementCount;
        this.measurementCount = 0;
        int n2 = n;
        while (--n2 >= 0) {
            this.measurements[n2] = null;
        }
    }

    private int defined(int[] nArray) {
        int n = this.measurementCount;
        while (--n >= 0) {
            if (!this.measurements[n].sameAs(nArray)) continue;
            return n;
        }
        return -1;
    }

    private void toggle(int[] nArray) {
        this.rangeMinMax[0] = Float.MAX_VALUE;
        int n = this.defined(nArray);
        if (n >= 0 && !this.measurements[n].isHidden()) {
            this.define(nArray, true, false, false);
        } else {
            this.define(nArray, false, true, false);
        }
        this.setIndices();
    }

    private void toggleOn(int[] nArray) {
        this.rangeMinMax[0] = Float.MAX_VALUE;
        this.bsSelected = new BitSet();
        this.define(nArray, false, true, true);
        this.setIndices();
        this.reformatDistances();
    }

    private void delete(Object object) {
        if (object instanceof int[]) {
            this.define((int[])object, true, false, false);
        } else if (object instanceof Integer) {
            this.define(this.measurements[(Integer)object].getCountPlusIndices(), true, false, false);
        }
    }

    private void define(Vector vector, boolean bl, boolean bl2, boolean bl3) {
        int n = vector.size();
        if (n < 2) {
            return;
        }
        boolean bl4 = true;
        for (int i = 0; i < n && bl4; ++i) {
            if (BitSetUtil.cardinalityOf((BitSet)((BitSet)vector.get(i))) <= 1) continue;
            bl4 = false;
        }
        int[] nArray = new int[5];
        nArray[0] = n;
        this.nextMeasure(0, n, vector, nArray, bl4 ? -1 : 0, bl, bl2, bl3);
    }

    private void setIndices() {
        for (int i = 0; i < this.measurementCount; ++i) {
            this.measurements[i].setIndex(i);
        }
    }

    private void define(int[] nArray, boolean bl, boolean bl2, boolean bl3) {
        if (this.viewer.getMeasureAllModelsFlag()) {
            if (bl2) {
                this.define(nArray, true, false, false);
                if (bl) {
                    return;
                }
            }
            Vector<BitSet> vector = new Vector<BitSet>();
            int n = nArray[0];
            for (int i = 1; i <= n; ++i) {
                Atom atom = this.modelSet.atoms[nArray[i]];
                vector.addElement(this.viewer.getAtomBits("atomno", atom.getAtomNumber()));
            }
            this.define(vector, bl, false, false);
            return;
        }
        this.define(nArray, bl, bl3);
    }

    private void define(int[] nArray, boolean bl, boolean bl2) {
        int n = this.defined(nArray);
        int n2 = nArray[0];
        if (n < 0 && bl || nArray[1] == nArray[2] || n2 > 2 && nArray[1] == nArray[3] || n2 == 4 && nArray[2] == nArray[4]) {
            return;
        }
        float f = this.modelSet.getMeasurement(nArray);
        if (this.rangeMinMax[0] != Float.MAX_VALUE && (f < this.rangeMinMax[0] || f > this.rangeMinMax[1])) {
            return;
        }
        if (n >= 0) {
            if (bl) {
                this.viewer.setStatusNewDefaultModeMeasurement("measureDeleted", n, "");
                System.arraycopy(this.measurements, n + 1, this.measurements, n, this.measurementCount - n - 1);
                --this.measurementCount;
                this.measurements[this.measurementCount] = null;
            } else {
                this.measurements[n].setHidden(false);
                if (bl2) {
                    this.bsSelected.set(n);
                }
            }
            return;
        }
        Measurement measurement = new Measurement(this.modelSet, nArray, f, this.colix, this.strFormat, this.measurementCount);
        if (this.measurementCount == this.measurements.length) {
            this.measurements = (Measurement[])ArrayUtil.setLength((Object)this.measurements, (int)(this.measurementCount + 16));
        }
        this.viewer.setStatusNewDefaultModeMeasurement("measureCompleted", this.measurementCount, measurement.toVector().toString());
        this.measurements[this.measurementCount++] = measurement;
    }

    private void showHide(int[] nArray, boolean bl) {
        int n = this.defined(nArray);
        if (n < 0) {
            return;
        }
        this.measurements[n].setHidden(bl);
    }

    private void showHide(boolean bl) {
        int n = this.measurementCount;
        while (--n >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(n)) continue;
            this.measurements[n].setHidden(bl);
        }
    }

    private void nextMeasure(int n, int n2, Vector vector, int[] nArray, int n3, boolean bl, boolean bl2, boolean bl3) {
        BitSet bitSet = (BitSet)vector.get(n);
        int n4 = this.modelSet.getAtomCount();
        for (int i = 0; i < n4; ++i) {
            if (!bitSet.get(i) || n > 0 && i == nArray[n]) continue;
            int n5 = this.modelSet.atoms[i].getModelIndex();
            if (n3 >= 0) {
                if (n == 0) {
                    n3 = n5;
                } else if (n3 != n5) continue;
            }
            nArray[n + 1] = i;
            if (n == n2 - 1) {
                if (this.isAllConnected && !this.isConnected(nArray)) continue;
                int n6 = this.defined(nArray);
                if (n6 >= 0) {
                    if (bl) {
                        this.define(nArray, true, false);
                        continue;
                    }
                    if (this.strFormat != null) {
                        this.measurements[n6].formatMeasurement(this.strFormat, true);
                        continue;
                    }
                    this.showHide(nArray, bl3);
                    continue;
                }
                if (bl || bl3 || bl2) continue;
                this.define(nArray, false, true);
                continue;
            }
            this.nextMeasure(n + 1, n2, vector, nArray, n3, bl, bl2, bl3);
        }
    }

    private boolean isConnected(int[] nArray) {
        Atom[] atomArray = this.modelSet.atoms;
        for (int i = nArray[0]; i > 1; --i) {
            if (atomArray[nArray[i]].isBonded(atomArray[nArray[i - 1]])) continue;
            return false;
        }
        return true;
    }

    private void setRange(float[] fArray) {
        this.rangeMinMax[0] = fArray[0];
        this.rangeMinMax[1] = fArray[1];
    }

    private void setConnected(boolean bl) {
        this.isAllConnected = bl;
    }

    private void pending(int[] nArray) {
        this.pendingMeasurement.setCountPlusIndices(nArray);
        if (this.pendingMeasurement.getCount() > 1) {
            this.viewer.setStatusNewDefaultModeMeasurement("measurePending", this.pendingMeasurement.getCount(), this.pendingMeasurement.getString());
        }
    }

    private void reformatDistances() {
        int n = this.measurementCount;
        while (--n >= 0) {
            this.measurements[n].reformatDistanceIfSelected();
        }
    }

    private void setFormats(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        int n = this.measurementCount;
        while (--n >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(n)) continue;
            this.measurements[n].formatMeasurement(string, false);
        }
    }

    private Vector getAllInfo() {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.measurementCount; ++i) {
            vector.addElement(this.getInfo(i));
        }
        return vector;
    }

    private String getAllInfoAsString() {
        String string = "Measurement Information";
        for (int i = 0; i < this.measurementCount; ++i) {
            string = string + "\n" + this.getInfoAsString(i);
        }
        return string;
    }

    private Hashtable getInfo(int n) {
        int n2 = this.measurements[n].getCount();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("index", new Integer(n));
        hashtable.put("type", n2 == 2 ? "distance" : (n2 == 3 ? "angle" : "dihedral"));
        hashtable.put("strMeasurement", this.measurements[n].getString());
        hashtable.put("count", new Integer(n2));
        hashtable.put("value", new Float(this.measurements[n].getValue()));
        Vector vector = new Vector();
        for (int i = 0; i < n2; ++i) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            Atom atom = this.modelSet.atoms[this.measurements[n].getIndex(i + 1)];
            hashtable2.put("_ipt", new Integer(atom.getAtomIndex()));
            hashtable2.put("atomno", new Integer(atom.getAtomNumber()));
            hashtable2.put("info", atom.getInfo());
            vector.addElement(hashtable2);
        }
        hashtable.put("atoms", vector);
        return hashtable;
    }

    private String getInfoAsString(int n) {
        int n2 = this.measurements[n].getCount();
        String string = (n2 == 2 ? "distance" : (n2 == 3 ? "angle" : "dihedral")) + " \t" + this.measurements[n].getValue() + " \t" + this.measurements[n].getString();
        for (int i = 0; i < n2; ++i) {
            Atom atom = this.modelSet.atoms[this.measurements[n].getIndex(i + 1)];
            string = string + " \t" + atom.getInfo();
        }
        return string;
    }

    void setVisibilityInfo() {
        int n = this.measurementCount;
        block0: while (--n >= 0) {
            this.measurements[n].setVisible(false);
            if (this.mad == 0 || this.measurements[n].isHidden()) continue;
            for (int i = this.measurements[n].getCount(); i > 0; --i) {
                Atom atom = this.modelSet.getAtomAt(this.measurements[n].getIndex(i));
                if (!atom.isClickable()) continue block0;
            }
            this.measurements[n].setVisible(true);
        }
    }

    public String getShapeState() {
        String string;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.measurementCount; ++n2) {
            stringBuffer.append(this.getState(n2));
        }
        if (!this.showMeasurementNumbers) {
            stringBuffer.append("set measures off; # numbers off\n");
        }
        Shape.appendCmd(stringBuffer, "measures = " + this.viewer.getMeasureDistanceUnits());
        Shape.appendCmd(stringBuffer, Shape.getFontCommand("measures", this.font3d));
        n2 = 0;
        Hashtable hashtable = new Hashtable();
        BitSet bitSet = new BitSet(this.measurementCount);
        for (n = 0; n < this.measurementCount; ++n) {
            if (this.measurements[n].isHidden()) {
                ++n2;
                bitSet.set(n);
            }
            if (this.bsColixSet != null && this.bsColixSet.get(n)) {
                Shape.setStateInfo(hashtable, n, this.getColorCommand("measure", this.measurements[n].getColix()));
            }
            if (this.measurements[n].getStrFormat() == null) continue;
            Shape.setStateInfo(hashtable, n, "measure " + Escape.escape((String)this.measurements[n].getStrFormat()));
        }
        if (n2 > 0) {
            if (n2 == this.measurementCount) {
                stringBuffer.append("measures off; # lines and numbers off\n");
            } else {
                for (n = 0; n < this.measurementCount; ++n) {
                    if (!this.measurements[n].isHidden()) continue;
                    Shape.setStateInfo(hashtable, n, "measure off");
                }
            }
        }
        if ((string = Shape.getShapeCommands(hashtable, null, -1, "select measures")) != null) {
            stringBuffer.append(string);
            Shape.appendCmd(stringBuffer, "select measures ({null})");
        }
        return stringBuffer.toString();
    }

    private String getState(int n) {
        int n2 = this.measurements[n].getCount();
        String string = "measure";
        for (int i = 0; i < n2; ++i) {
            string = string + "({" + this.measurements[n].getIndex(i + 1) + "})";
        }
        string = string + "; # " + this.getInfoAsString(n) + "\n";
        return string;
    }
}

