/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Platform3D;
import org.jmol.util.Logger;

class Text3D {
    int height;
    int ascent;
    int width;
    int size;
    int[] bitmap;
    private static final Hashtable htFont3d = new Hashtable();

    public int getWidth() {
        return this.width;
    }

    static int plot(int n, int n2, int n3, int n4, int n5, String string, Font3D font3D, Graphics3D graphics3D) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.indexOf("<su") >= 0) {
            return Text3D.plotByCharacter(n, n2, n3, n4, n5, string, font3D, graphics3D);
        }
        Text3D text3D = Text3D.getText3D(string, font3D, graphics3D.platform);
        if (text3D.width == 0) {
            return 0;
        }
        int[] nArray = text3D.bitmap;
        int n6 = text3D.width;
        int n7 = text3D.height;
        if (n + n6 < 0 || n > graphics3D.width || n2 + n7 < 0 || n2 > graphics3D.height) {
            return n6;
        }
        if (n < 0 || n + n6 > graphics3D.width || n2 < 0 || n2 + n7 > graphics3D.height) {
            Text3D.plotClipped(n, n2, n3, n4, n5, graphics3D, n6, n7, nArray);
        } else {
            Text3D.plotUnclipped(n, n2, n3, n4, n5, graphics3D, n6, n7, nArray);
        }
        return n6;
    }

    private static int plotByCharacter(int n, int n2, int n3, int n4, int n5, String string, Font3D font3D, Graphics3D graphics3D) {
        int n6 = 0;
        int n7 = string.length();
        int n8 = (int)((double)font3D.fontMetrics.getHeight() * 0.25);
        int n9 = -((int)((double)font3D.fontMetrics.getHeight() * 0.3));
        for (int i = 0; i < n7; ++i) {
            if (string.charAt(i) == '<') {
                if (i + 4 < n7 && string.substring(i, i + 5).equals("<sub>")) {
                    i += 4;
                    n2 += n8;
                    continue;
                }
                if (i + 4 < n7 && string.substring(i, i + 5).equals("<sup>")) {
                    i += 4;
                    n2 += n9;
                    continue;
                }
                if (i + 5 < n7 && string.substring(i, i + 6).equals("</sub>")) {
                    i += 5;
                    n2 -= n8;
                    continue;
                }
                if (i + 5 < n7 && string.substring(i, i + 6).equals("</sup>")) {
                    i += 5;
                    n2 -= n9;
                    continue;
                }
            }
            n6 += Text3D.plot(n + n6, n2, n3, n4, n5, string.substring(i, i + 1), font3D, graphics3D);
        }
        return n6;
    }

    private static void plotUnclipped(int n, int n2, int n3, int n4, int n5, Graphics3D graphics3D, int n6, int n7, int[] nArray) {
        boolean bl;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int[] nArray2 = graphics3D.zbuf;
        int n12 = graphics3D.width;
        int n13 = n2 * n12 + n;
        boolean bl2 = bl = n5 != 0;
        while (n10 < n7) {
            while (n11 < n6) {
                if ((n8 & 0x1F) == 0) {
                    n9 = nArray[n8 >> 5];
                }
                if (n9 == 0 && !bl) {
                    int n14 = 32 - (n8 & 0x1F);
                    n11 += n14;
                    n8 += n14;
                    n13 += n14;
                    continue;
                }
                if (n3 < nArray2[n13]) {
                    if (n9 < 0) {
                        graphics3D.addPixel(n13, n3, n4);
                    } else if (bl) {
                        graphics3D.addPixel(n13, n3, n5);
                    }
                }
                n9 <<= 1;
                ++n8;
                ++n11;
                ++n13;
            }
            while (n11 >= n6) {
                ++n10;
                n11 -= n6;
                n13 += n12 - n6;
            }
        }
    }

    private static void plotClipped(int n, int n2, int n3, int n4, int n5, Graphics3D graphics3D, int n6, int n7, int[] nArray) {
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n10 < n7) {
            while (n11 < n6) {
                if ((n8 & 0x1F) == 0) {
                    n9 = nArray[n8 >> 5];
                }
                if (n9 == 0 && n5 == 0) {
                    int n12 = 32 - (n8 & 0x1F);
                    n11 += n12;
                    n8 += n12;
                    continue;
                }
                if (n9 < 0 || n5 != 0) {
                    graphics3D.plotPixelClippedNoSlab(n9 < 0 ? n4 : n5, n + n11, n2 + n10, n3);
                }
                n9 <<= 1;
                ++n8;
                ++n11;
            }
            while (n11 >= n6) {
                ++n10;
                n11 -= n6;
            }
        }
    }

    private Text3D(String string, Font3D font3D, Platform3D platform3D) {
        if (!this.calcMetrics(string, font3D)) {
            return;
        }
        platform3D.checkOffscreenSize(this.width, this.height);
        this.renderOffscreen(string, font3D, platform3D);
        this.rasterize(platform3D);
    }

    private boolean calcMetrics(String string, Font3D font3D) {
        FontMetrics fontMetrics = font3D.fontMetrics;
        this.ascent = fontMetrics.getAscent();
        this.height = this.ascent + fontMetrics.getDescent();
        this.width = fontMetrics.stringWidth(string);
        this.size = this.width * this.height;
        return this.width > 0;
    }

    private void renderOffscreen(String string, Font3D font3D, Platform3D platform3D) {
        Graphics graphics = platform3D.gOffscreen;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.white);
        graphics.setFont(font3D.font);
        graphics.drawString(string, 0, this.ascent);
    }

    private void rasterize(Platform3D platform3D) {
        PixelGrabber pixelGrabber = new PixelGrabber(platform3D.imageOffscreen, 0, 0, this.width, this.height, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            Logger.debug("Que? 7748");
        }
        int[] nArray = (int[])pixelGrabber.getPixels();
        int n = this.size + 31 >> 5;
        this.bitmap = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.size) {
            if ((nArray[n3] & 0xFFFFFF) != 0) {
                n2 |= 1;
            }
            if ((n3 & 0x1F) == 31) {
                this.bitmap[n3 >> 5] = n2;
            }
            ++n3;
            n2 <<= 1;
        }
        if ((n3 & 0x1F) != 0) {
            this.bitmap[n3 >> 5] = n2 <<= 31 - (n3 & 0x1F);
        }
    }

    private static synchronized Text3D getText3D(String string, Font3D font3D, Platform3D platform3D) {
        Text3D text3D;
        Hashtable<String, Text3D> hashtable = (Hashtable<String, Text3D>)htFont3d.get(font3D);
        if (hashtable != null) {
            text3D = (Text3D)hashtable.get(string);
            if (text3D != null) {
                return text3D;
            }
        } else {
            hashtable = new Hashtable<String, Text3D>();
            htFont3d.put(font3D, hashtable);
        }
        if ((text3D = new Text3D(string, font3D, platform3D)) != null) {
            hashtable.put(string, text3D);
        }
        return text3D;
    }
}

