/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Escape;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class StateManager {
    public static final int OBJ_BACKGROUND = 0;
    public static final int OBJ_AXIS1 = 1;
    public static final int OBJ_AXIS2 = 2;
    public static final int OBJ_AXIS3 = 3;
    public static final int OBJ_BOUNDBOX = 4;
    public static final int OBJ_UNITCELL = 5;
    public static final int OBJ_FRANK = 6;
    public static final int OBJ_MAX = 7;
    private static final String objectNameList = "background axis1      axis2      axis3      boundbox   unitcell   frank      ";
    Viewer viewer;
    Hashtable saved = new Hashtable();
    String lastOrientation = "";
    String lastConnections = "";
    String lastSelected = "";
    String lastState = "";
    String lastShape = "";

    static int getObjectIdFromName(String string) {
        if (string == null) {
            return -1;
        }
        int n = objectNameList.indexOf(string.toLowerCase());
        return n < 0 ? n : n / 11;
    }

    static String getObjectNameFromId(int n) {
        if (n < 0 || n >= 7) {
            return null;
        }
        return objectNameList.substring(n * 11, n * 11 + 11).trim();
    }

    StateManager(Viewer viewer) {
        this.viewer = viewer;
    }

    GlobalSettings getGlobalSettings() {
        GlobalSettings globalSettings = new GlobalSettings();
        globalSettings.registerAllValues();
        return globalSettings;
    }

    static void clear(GlobalSettings globalSettings) {
        globalSettings.clear();
    }

    void setCrystallographicDefaults() {
        this.viewer.setAxesModeUnitCell(true);
        this.viewer.setShowAxes(true);
        this.viewer.setShowUnitCell(true);
        this.viewer.setBooleanProperty("perspectiveDepth", false);
    }

    void setCommonDefaults() {
        this.viewer.setBooleanProperty("perspectiveDepth", true);
        this.viewer.setIntProperty("percentVdwAtom", 20);
        this.viewer.setFloatProperty("bondTolerance", 0.45f);
        this.viewer.setFloatProperty("minBondDistance", 0.4f);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 150);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "Jmol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", false);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", false);
    }

    void setRasMolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "RasMol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", true);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", true);
        this.viewer.setIntProperty("percentVdwAtom", 0);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 1);
    }

    String getStandardLabelFormat() {
        int n = this.viewer.getModelCount();
        String string = this.viewer.getChainCount() > n ? "[%n]%r:%c.%a" : (this.viewer.getGroupCount() <= n ? "%e%i" : "[%n]%r.%a");
        if (this.viewer.getModelCount() > 1) {
            string = string + "/%M";
        }
        return string;
    }

    String listSavedStates() {
        String string = "";
        Enumeration enumeration = this.saved.keys();
        while (enumeration.hasMoreElements()) {
            string = string + "\n" + enumeration.nextElement();
        }
        return string;
    }

    void saveSelection(String string, BitSet bitSet) {
        string = this.lastSelected = "Selected_" + string;
        BitSet bitSet2 = (BitSet)bitSet.clone();
        this.saved.put(string, bitSet2);
    }

    boolean restoreSelection(String string) {
        String string2 = string.length() > 0 ? "Selected_" + string : this.lastSelected;
        BitSet bitSet = (BitSet)this.saved.get(string2);
        if (bitSet == null) {
            this.viewer.select(new BitSet(), false);
            return false;
        }
        this.viewer.select(bitSet, false);
        return true;
    }

    void saveState(String string) {
        string = this.lastState = "State_" + string;
        this.saved.put(string, this.viewer.getStateInfo());
    }

    String getSavedState(String string) {
        String string2 = string.length() > 0 ? "State_" + string : this.lastState;
        String string3 = (String)this.saved.get(string2);
        return string3 == null ? "" : string3;
    }

    void saveStructure(String string) {
        string = this.lastShape = "Shape_" + string;
        this.saved.put(string, this.viewer.getStructureState());
    }

    String getSavedStructure(String string) {
        String string2 = string.length() > 0 ? "Shape_" + string : this.lastShape;
        String string3 = (String)this.saved.get(string2);
        return string3 == null ? "" : string3;
    }

    void saveOrientation(String string) {
        Orientation orientation = new Orientation();
        orientation.saveName = this.lastOrientation = "Orientation_" + string;
        this.saved.put(orientation.saveName, orientation);
    }

    boolean restoreOrientation(String string, float f) {
        String string2 = string.length() > 0 ? "Orientation_" + string : this.lastOrientation;
        Orientation orientation = (Orientation)this.saved.get(string2);
        if (orientation == null) {
            return false;
        }
        orientation.restore(f);
        return true;
    }

    void saveBonds(String string) {
        Connections connections = new Connections();
        connections.saveName = this.lastConnections = "Bonds_" + string;
        this.saved.put(connections.saveName, connections);
    }

    boolean restoreBonds(String string) {
        String string2 = string.length() > 0 ? "Bonds_" + string : this.lastConnections;
        Connections connections = (Connections)this.saved.get(string2);
        if (connections == null) {
            return false;
        }
        connections.restore();
        return true;
    }

    static boolean isMeasurementUnit(String string) {
        String string2 = ";" + string.toLowerCase() + ";";
        return ";angstroms;au;bohr;nanometers;nm;picometers;pm;".indexOf(string2) >= 0;
    }

    public static void setStateInfo(Hashtable hashtable, int n, int n2, String string) {
        BitSet bitSet;
        if (hashtable.containsKey(string)) {
            bitSet = (BitSet)hashtable.get(string);
        } else {
            bitSet = new BitSet();
            hashtable.put(string, bitSet);
        }
        for (int i = n; i <= n2; ++i) {
            bitSet.set(i);
        }
    }

    public static String getCommands(Hashtable hashtable) {
        return StateManager.getCommands(hashtable, null, -1, "select");
    }

    public static String getCommands(Hashtable hashtable, Hashtable hashtable2, int n) {
        return StateManager.getCommands(hashtable, hashtable2, n, "select");
    }

    public static String getCommands(Hashtable hashtable, Hashtable hashtable2, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = StateManager.getCommands(hashtable, stringBuffer, null, n, string);
        if (hashtable2 != null) {
            StateManager.getCommands(hashtable2, stringBuffer, string2, n, string);
        }
        return stringBuffer.toString();
    }

    public static String getCommands(Hashtable hashtable, StringBuffer stringBuffer, String string, int n, String string2) {
        if (hashtable == null) {
            return "";
        }
        String string3 = "({0:" + (n - 1) + "})";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            String string5 = Escape.escape((BitSet)((BitSet)hashtable.get(string4)));
            if (string5.length() < 5) continue;
            if (!string5.equals(string)) {
                StringBuffer stringBuffer2 = new StringBuffer().append(string2).append(" ");
                if (string5.equals(string3)) {
                    // empty if block
                }
                StateManager.appendCmd(stringBuffer, stringBuffer2.append(string5).toString());
            }
            string = string5;
            if (string4.indexOf("-") == 0) continue;
            StateManager.appendCmd(stringBuffer, string4);
        }
        return string;
    }

    public static void appendCmd(StringBuffer stringBuffer, String string) {
        if (string.length() == 0) {
            return;
        }
        stringBuffer.append(string).append(";\n");
    }

    class GlobalSettings {
        boolean specular = true;
        int specularPercent = 22;
        int specularExponent = 6;
        int specularPower = 40;
        int diffusePercent = 84;
        int ambientPercent = 45;
        char inlineNewlineChar = (char)124;
        boolean appendNew = true;
        boolean applySymmetryToBonds = false;
        boolean zeroBasedXyzRasmol = false;
        boolean forceAutoBond = false;
        boolean autoBond = true;
        boolean allowEmbeddedScripts = true;
        int percentVdwAtom = 20;
        short bondRadiusMilliAngstroms = (short)150;
        float bondTolerance = 0.45f;
        float minBondDistance = 0.4f;
        String defaultLoadScript = "";
        String defaultDirectory = null;
        String loadFormat = "http://www.rcsb.org/pdb/files/%FILE.pdb";
        private final Point3f ptDefaultLattice = new Point3f();
        boolean allowRotateSelected = false;
        boolean solventOn = false;
        boolean measureAllModels = false;
        boolean justifyMeasurements = false;
        String defaultDistanceLabel = "%VALUE %UNITS";
        String defaultAngleLabel = "%VALUE %UNITS";
        String defaultTorsionLabel = "%VALUE %UNITS";
        boolean enableFullSceneAntialiasing = false;
        boolean greyscaleRendering = false;
        boolean zoomLarge = true;
        boolean dotsSelectedOnly = false;
        boolean dotSurface = true;
        boolean displayCellParameters = true;
        boolean showHiddenSelectionHalos = false;
        boolean showMeasurements = true;
        boolean zShade = false;
        boolean dynamicMeasurements = false;
        boolean bondModeOr = false;
        boolean showMultipleBonds = true;
        boolean showHydrogens = true;
        boolean ssbondsBackbone = false;
        boolean hbondsBackbone = false;
        boolean hbondsSolid = false;
        byte modeMultipleBond = (byte)2;
        boolean rasmolHydrogenSetting = true;
        boolean rasmolHeteroSetting = true;
        boolean cartoonRockets = false;
        boolean ribbonBorder = false;
        boolean chainCaseSensitive = false;
        boolean rangeSelected = false;
        boolean traceAlpha = true;
        boolean highResolutionFlag = false;
        int ribbonAspectRatio = 16;
        int hermiteLevel = 0;
        float sheetSmoothing = 1.0f;
        boolean hideNameInPopup = false;
        boolean disablePopupMenu = false;
        float vibrationScale = 1.0f;
        float vibrationPeriod = 1.0f;
        float vectorScale = 1.0f;
        float cameraDepth = 3.0f;
        float solventProbeRadius = 1.2f;
        int scriptDelay = 0;
        int hoverDelayMs = 500;
        boolean hideNavigationPoint = false;
        boolean showNavigationPointAlways = false;
        String propertyColorScheme = "roygb";
        boolean useNumberLocalization = true;
        float defaultTranslucent = 0.5f;
        boolean autoFps = false;
        int[] objColors = new int[7];
        boolean[] objStateOn = new boolean[7];
        short[] objMad = new short[7];
        String stereoState = null;
        boolean navigationMode = false;
        boolean navigationPeriodic = false;
        boolean navigationCentered = false;
        float navigationSpeed = 5.0f;
        int axesMode = 0;
        float axesScale = 2.0f;
        int pickingSpinRate = 10;
        String helpPath = "http://www.stolaf.edu/academics/chemapps/jmol/docs/index.htm";
        boolean debugScript = false;
        boolean testFlag1 = false;
        boolean testFlag2 = false;
        boolean testFlag3 = false;
        boolean testFlag4 = false;
        private String measureDistanceUnits = "nanometers";
        Hashtable htParameterValues;
        Hashtable htPropertyFlags;
        static final String volatileProperties = ";selectionhalos;";
        static final String unnecessaryProperties = ";refreshing;defaults;backgroundmodel;stereo;perspectivemodel;;appendnew;bondsymmetryatoms;backgroundcolor;axescolor;axis1color;axis2color;axis3color;boundboxcolor;unitcellcolor;;ambientpercent;diffusepercent;specular;specularexponent;specularpower;specularpercent;;debugscript;showfrank;showaxes;showaxis1;showaxis2;showaxis3;showunitcell;showboundbox;;slabEnabled;zoomEnabled;axeswindow;axesunitcell;axesmolecular;windowcentered;;cameradepth;navigationmode;rotationradius;;zerobasedxyzrasmol;axesorientationrasmol;;language;_spinning;_animating;_modelnumber;_modelname;_currentmodelnumberinfile;;_currentfilenumber;_modelfile;_modeltitle;_version;_memory;;_width;_height;_atompicked;_atomhovered;";

        GlobalSettings() {
        }

        String getLoadState() {
            StringBuffer stringBuffer = new StringBuffer();
            StateManager.appendCmd(stringBuffer, "allowEmbeddedScripts = false");
            if (this.allowEmbeddedScripts) {
                this.setParameterValue("allowEmbeddedScripts", true);
            }
            StateManager.appendCmd(stringBuffer, "autoBond = " + this.autoBond);
            StateManager.appendCmd(stringBuffer, "appendNew = " + this.appendNew);
            StateManager.appendCmd(stringBuffer, "applySymmetryToBonds = " + this.applySymmetryToBonds);
            if (StateManager.this.viewer.getAxesOrientationRasmol()) {
                StateManager.appendCmd(stringBuffer, "axesOrientationRasmol = true");
            }
            StateManager.appendCmd(stringBuffer, "bondRadiusMilliAngstroms = " + this.bondRadiusMilliAngstroms);
            StateManager.appendCmd(stringBuffer, "bondTolerance = " + this.bondTolerance);
            if (this.defaultDirectory != null) {
                StateManager.appendCmd(stringBuffer, "defaultDirectory = " + Escape.escape((String)this.defaultDirectory));
            }
            StateManager.appendCmd(stringBuffer, "defaultLattice = " + Escape.escape((Tuple3f)this.ptDefaultLattice));
            StateManager.appendCmd(stringBuffer, "defaultLoadScript = \"\"");
            if (this.defaultLoadScript.length() > 0) {
                this.setParameterValue("defaultLoadScript", this.defaultLoadScript);
            }
            StateManager.appendCmd(stringBuffer, "loadFormat = " + Escape.escape((String)this.loadFormat));
            StateManager.appendCmd(stringBuffer, "forceAutoBond = " + this.forceAutoBond);
            StateManager.appendCmd(stringBuffer, "minBondDistance = " + this.minBondDistance);
            StateManager.appendCmd(stringBuffer, "percentVdwAtom = " + this.percentVdwAtom);
            if (this.zeroBasedXyzRasmol) {
                StateManager.appendCmd(stringBuffer, "zeroBasedXyzRasmol = true");
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        void setDefaultLattice(Point3f point3f) {
            this.ptDefaultLattice.set((Tuple3f)point3f);
        }

        Point3f getDefaultLatticePoint() {
            return this.ptDefaultLattice;
        }

        int[] getDefaultLatticeArray() {
            int[] nArray = new int[4];
            nArray[1] = (int)this.ptDefaultLattice.x;
            nArray[2] = (int)this.ptDefaultLattice.y;
            nArray[3] = (int)this.ptDefaultLattice.z;
            return nArray;
        }

        void clear() {
            StateManager.this.viewer.setShowAxes(false);
            StateManager.this.viewer.setShowBbcage(false);
            StateManager.this.viewer.setShowUnitCell(false);
            this.clearVolatileProperties();
        }

        String getWindowState() {
            StringBuffer stringBuffer = new StringBuffer("# window state;\n# height " + StateManager.this.viewer.getScreenHeight() + ";\n# width " + StateManager.this.viewer.getScreenWidth() + ";\n");
            StateManager.appendCmd(stringBuffer, "initialize");
            StateManager.appendCmd(stringBuffer, "stateVersion = " + this.getParameter("_version"));
            StateManager.appendCmd(stringBuffer, "refreshing = false");
            for (int i = 0; i < 7; ++i) {
                if (this.objColors[i] == 0) continue;
                StateManager.appendCmd(stringBuffer, StateManager.getObjectNameFromId(i) + "Color = \"" + Escape.escapeColor((int)this.objColors[i]) + '\"');
            }
            stringBuffer.append(this.getSpecularState());
            if (this.stereoState != null) {
                StateManager.appendCmd(stringBuffer, "stereo" + this.stereoState);
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        String getSpecularState() {
            StringBuffer stringBuffer = new StringBuffer("");
            StateManager.appendCmd(stringBuffer, "ambientPercent = " + Graphics3D.getAmbientPercent());
            StateManager.appendCmd(stringBuffer, "diffusePercent = " + Graphics3D.getDiffusePercent());
            StateManager.appendCmd(stringBuffer, "specular = " + Graphics3D.getSpecular());
            StateManager.appendCmd(stringBuffer, "specularPercent = " + Graphics3D.getSpecularPercent());
            StateManager.appendCmd(stringBuffer, "specularPower = " + Graphics3D.getSpecularPower());
            StateManager.appendCmd(stringBuffer, "specularExponent = " + Graphics3D.getSpecularExponent());
            return stringBuffer.toString();
        }

        void setMeasureDistanceUnits(String string) {
            if (string.equalsIgnoreCase("angstroms")) {
                this.measureDistanceUnits = "angstroms";
            } else if (string.equalsIgnoreCase("nanometers") || string.equalsIgnoreCase("nm")) {
                this.measureDistanceUnits = "nanometers";
            } else if (string.equalsIgnoreCase("picometers") || string.equalsIgnoreCase("pm")) {
                this.measureDistanceUnits = "picometers";
            } else if (string.equalsIgnoreCase("bohr") || string.equalsIgnoreCase("au")) {
                this.measureDistanceUnits = "au";
            }
        }

        String getMeasureDistanceUnits() {
            return this.measureDistanceUnits;
        }

        void clearVolatileProperties() {
            String string;
            Enumeration enumeration = this.htPropertyFlags.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (volatileProperties.indexOf(";" + string + ";") < 0 && string.charAt(0) != '@') continue;
                this.htPropertyFlags.remove(string);
            }
            enumeration = this.htParameterValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (volatileProperties.indexOf(";" + string + ";") < 0 && string.charAt(0) != '@') continue;
                this.htParameterValues.remove(string);
            }
            this.setParameterValue("_atompicked", -1);
            this.setParameterValue("_atomhovered", -1);
        }

        void removeParameter(String string) {
            if (this.htPropertyFlags.containsKey(string)) {
                this.htPropertyFlags.remove(string);
                return;
            }
            if (this.htParameterValues.containsKey(string)) {
                this.htParameterValues.remove(string);
            }
        }

        void setParameterValue(String string, boolean bl) {
            if (this.htParameterValues.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htPropertyFlags.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        }

        void setParameterValue(String string, int n) {
            if (this.htPropertyFlags.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htParameterValues.put(string, new Integer(n));
        }

        void setParameterValue(String string, float f) {
            string = string.toLowerCase();
            if (Float.isNaN(f)) {
                this.htParameterValues.remove(string);
                this.htPropertyFlags.remove(string);
                return;
            }
            if (this.htPropertyFlags.containsKey(string)) {
                return;
            }
            this.htParameterValues.put(string, new Float(f));
        }

        void setParameterValue(String string, String string2) {
            if (string2 == null || this.htPropertyFlags.containsKey(string)) {
                return;
            }
            string = string.toLowerCase();
            this.htParameterValues.put(string, string2);
        }

        boolean doRegister(String string) {
            return unnecessaryProperties.indexOf(";" + string + ";") < 0;
        }

        String getParameterEscaped(String string) {
            return this.getParameterEscaped(string, 0);
        }

        String getParameterEscaped(String string, int n) {
            if (this.htParameterValues.containsKey(string = string.toLowerCase())) {
                String string2 = Escape.escape(this.htParameterValues.get(string));
                if (n > 0 && string2.length() > n) {
                    string2 = string2.substring(0, n) + "\n#...(" + string2.length() + " bytes -- use SHOW " + string + " or MESSAGE @" + string + " to view)";
                }
                return string2;
            }
            if (this.htPropertyFlags.containsKey(string)) {
                return this.htPropertyFlags.get(string).toString();
            }
            return "<not set>";
        }

        Object getParameter(String string) {
            if ((string = string.toLowerCase()).equals("_memory")) {
                Runtime runtime = Runtime.getRuntime();
                float f = (float)runtime.totalMemory() / 1000000.0f;
                float f2 = (float)runtime.freeMemory() / 1000000.0f;
                return TextFormat.formatDecimal((float)(f - f2), (int)1) + "/" + TextFormat.formatDecimal((float)f, (int)1);
            }
            if (this.htParameterValues.containsKey(string)) {
                return this.htParameterValues.get(string);
            }
            if (this.htPropertyFlags.containsKey(string)) {
                return this.htPropertyFlags.get(string);
            }
            return "";
        }

        String getAllSettings(int n) {
            String string;
            StringBuffer stringBuffer = new StringBuffer("");
            Object[] objectArray = new String[this.htPropertyFlags.size() + this.htParameterValues.size()];
            int n2 = 0;
            Enumeration enumeration = this.htPropertyFlags.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                objectArray[n2++] = string + " = " + this.htPropertyFlags.get(string);
            }
            enumeration = this.htParameterValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.charAt(0) == '@' || string.charAt(0) == '_') continue;
                Object object = this.htParameterValues.get(string);
                if (object instanceof String) {
                    object = Escape.escape((String)((String)object));
                }
                objectArray[n2++] = string + " = " + object;
            }
            Arrays.sort(objectArray, 0, n2);
            for (int i = 0; i < n2; ++i) {
                if (objectArray[i] == null) continue;
                StateManager.appendCmd(stringBuffer, (String)objectArray[i]);
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        String getState() {
            String string;
            int n = 0;
            Object[] objectArray = new String[this.htPropertyFlags.size() + this.htParameterValues.size()];
            StringBuffer stringBuffer = new StringBuffer("# settings;\n");
            StateManager.appendCmd(stringBuffer, "refreshing = false");
            Enumeration enumeration = this.htPropertyFlags.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!this.doRegister(string)) continue;
                objectArray[n++] = string + " = " + this.htPropertyFlags.get(string);
            }
            enumeration = this.htParameterValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.charAt(0) == '@' || !this.doRegister(string)) continue;
                Object object = this.htParameterValues.get(string);
                if (string.charAt(0) == '_') {
                    string = string.substring(1) + " ";
                } else {
                    if (string.indexOf("default") == 0) {
                        string = " " + string;
                    }
                    string = string + " = ";
                    if (object instanceof String) {
                        object = Escape.escape((String)((String)object));
                    }
                }
                objectArray[n++] = string + object;
            }
            switch (this.axesMode) {
                case 2: {
                    objectArray[n++] = "axes = unitcell";
                    break;
                }
                case 0: {
                    objectArray[n++] = "axes = window";
                    break;
                }
                default: {
                    objectArray[n++] = "axes = molecular";
                }
            }
            enumeration = this.htParameterValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.charAt(0) != '@') continue;
                objectArray[n++] = string + " " + this.htParameterValues.get(string);
            }
            Arrays.sort(objectArray, 0, n);
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) continue;
                StateManager.appendCmd(stringBuffer, (String)objectArray[i]);
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        void registerAllValues() {
            this.htParameterValues = new Hashtable();
            this.htPropertyFlags = new Hashtable();
            this.setParameterValue("allowEmbeddedScripts", this.allowEmbeddedScripts);
            this.setParameterValue("allowRotateSelected", this.allowRotateSelected);
            this.setParameterValue("ambientPercent", this.ambientPercent);
            this.setParameterValue("appendNew", this.appendNew);
            this.setParameterValue("applySymmetryToBonds", this.applySymmetryToBonds);
            this.setParameterValue("autoBond", this.autoBond);
            this.setParameterValue("autoFps", this.autoFps);
            this.setParameterValue("axesMode", this.axesMode);
            this.setParameterValue("axesScale", this.axesScale);
            this.setParameterValue("bondModeOr", this.bondModeOr);
            this.setParameterValue("bondRadiusMilliAngstroms", this.bondRadiusMilliAngstroms);
            this.setParameterValue("bondTolerance", this.bondTolerance);
            this.setParameterValue("cameraDepth", this.cameraDepth);
            this.setParameterValue("cartoonRockets", this.cartoonRockets);
            this.setParameterValue("chainCaseSensitive", this.chainCaseSensitive);
            this.setParameterValue("debugScript", this.debugScript);
            this.setParameterValue("defaultAngleLabel", this.defaultAngleLabel);
            this.setParameterValue("defaultDirectory", this.defaultDirectory);
            this.setParameterValue("defaultDistanceLabel", this.defaultDistanceLabel);
            this.setParameterValue("defaultLoadScript", this.defaultLoadScript);
            this.setParameterValue("defaultTorsionLabel", this.defaultTorsionLabel);
            this.setParameterValue("defaultTranslucent", this.defaultTranslucent);
            this.setParameterValue("diffusePercent", this.diffusePercent);
            this.setParameterValue("disablePopupMenu", this.disablePopupMenu);
            this.setParameterValue("displayCellParameters", this.displayCellParameters);
            this.setParameterValue("dotsSelectedOnly", this.dotsSelectedOnly);
            this.setParameterValue("dotSurface", this.dotSurface);
            this.setParameterValue("dynamicMeasurements", this.dynamicMeasurements);
            this.setParameterValue("forceAutoBond", this.forceAutoBond);
            this.setParameterValue("greyscaleRendering", this.greyscaleRendering);
            this.setParameterValue("hbondsBackbone", this.hbondsBackbone);
            this.setParameterValue("hbondsSolid", this.hbondsSolid);
            this.setParameterValue("helpPath", this.helpPath);
            this.setParameterValue("hermiteLevel", this.hermiteLevel);
            this.setParameterValue("hideNameInPopup", this.hideNameInPopup);
            this.setParameterValue("hideNavigationPoint", this.hideNavigationPoint);
            this.setParameterValue("highResolutionFlag", this.highResolutionFlag);
            this.setParameterValue("hoverDelay", (float)this.hoverDelayMs / 1000.0f);
            this.setParameterValue("justifyMeasurements", this.justifyMeasurements);
            this.setParameterValue("loadFormat", this.loadFormat);
            this.setParameterValue("measureAllModels", this.measureAllModels);
            this.setParameterValue("minBondDistance", this.minBondDistance);
            this.setParameterValue("navigationCentered", this.navigationCentered);
            this.setParameterValue("navigationMode", this.navigationMode);
            this.setParameterValue("navigationPeriodic", this.navigationPeriodic);
            this.setParameterValue("navigationSpeed", this.navigationSpeed);
            this.setParameterValue("percentVdwAtom", this.percentVdwAtom);
            this.setParameterValue("pickingSpinRate", this.pickingSpinRate);
            this.setParameterValue("propertyColorScheme", this.propertyColorScheme);
            this.setParameterValue("propertyDataField", 0);
            this.setParameterValue("propertyAtomNumberField", 0);
            this.setParameterValue("rangeSelected", this.rangeSelected);
            this.setParameterValue("ribbonAspectRatio", this.ribbonAspectRatio);
            this.setParameterValue("ribbonBorder", this.ribbonBorder);
            this.setParameterValue("scriptDelay", this.scriptDelay);
            this.setParameterValue("selectHetero", this.rasmolHeteroSetting);
            this.setParameterValue("selectHydrogen", this.rasmolHydrogenSetting);
            this.setParameterValue("sheetSmoothing", this.sheetSmoothing);
            this.setParameterValue("showaxes", false);
            this.setParameterValue("showboundbox", false);
            this.setParameterValue("showfrank", false);
            this.setParameterValue("showHiddenSelectionHalos", this.showHiddenSelectionHalos);
            this.setParameterValue("showHydrogens", this.showHydrogens);
            this.setParameterValue("showMeasurements", this.showMeasurements);
            this.setParameterValue("showMultipleBonds", this.showMultipleBonds);
            this.setParameterValue("showNavigationPointAlways", this.showNavigationPointAlways);
            this.setParameterValue("showunitcell", false);
            this.setParameterValue("solvent", this.solventOn);
            this.setParameterValue("solventProbeRadius", this.solventProbeRadius);
            this.setParameterValue("specular", this.specular);
            this.setParameterValue("specularExponent", this.specularExponent);
            this.setParameterValue("specularPercent", this.specularPercent);
            this.setParameterValue("specularPower", this.specularPower);
            this.setParameterValue("ssbondsBackbone", this.ssbondsBackbone);
            this.setParameterValue("stereoState", this.stereoState);
            this.setParameterValue("testFlag1", this.testFlag1);
            this.setParameterValue("testFlag2", this.testFlag2);
            this.setParameterValue("testFlag3", this.testFlag3);
            this.setParameterValue("testFlag4", this.testFlag4);
            this.setParameterValue("traceAlpha", this.traceAlpha);
            this.setParameterValue("useNumberLocalization", this.useNumberLocalization);
            this.setParameterValue("vectorScale", this.vectorScale);
            this.setParameterValue("vibrationPeriod", this.vibrationPeriod);
            this.setParameterValue("vibrationScale", this.vibrationScale);
            this.setParameterValue("zoomLarge", this.zoomLarge);
            this.setParameterValue("zShade", this.zShade);
        }
    }

    static class Connection {
        int atomIndex1;
        int atomIndex2;
        short mad;
        short colix;
        short order;
        int shapeVisibilityFlags;

        Connection(int n, int n2, short s, short s2, short s3, int n3) {
            this.atomIndex1 = n;
            this.atomIndex2 = n2;
            this.mad = s;
            this.colix = s2;
            this.order = s3;
            this.shapeVisibilityFlags = n3;
        }
    }

    class Connections {
        String saveName;
        int bondCount;
        Connection[] connections;

        Connections() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            this.bondCount = modelSet.getBondCount();
            this.connections = new Connection[this.bondCount + 1];
            Bond[] bondArray = modelSet.getBonds();
            int n = this.bondCount;
            while (--n >= 0) {
                Bond bond = bondArray[n];
                this.connections[n] = new Connection(bond.getAtomIndex1(), bond.getAtomIndex2(), bond.getMad(), bond.getColix(), bond.getOrder(), bond.getShapeVisibilityFlags());
            }
        }

        void restore() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            modelSet.deleteAllBonds();
            int n = this.bondCount;
            while (--n >= 0) {
                Connection connection = this.connections[n];
                int n2 = modelSet.getAtomCount();
                if (connection.atomIndex1 >= n2 || connection.atomIndex2 >= n2) continue;
                Bond bond = modelSet.bondAtoms(modelSet.atoms[connection.atomIndex1], modelSet.atoms[connection.atomIndex2], connection.order, connection.mad, null);
                bond.setColix(connection.colix);
                bond.setShapeVisibilityFlags(connection.shapeVisibilityFlags);
            }
            n = this.bondCount;
            while (--n >= 0) {
                modelSet.getBondAt(n).setIndex(n);
            }
            StateManager.this.viewer.setShapeProperty(1, "reportAll", null);
        }
    }

    class Orientation {
        String saveName;
        Matrix3f rotationMatrix = new Matrix3f();
        float xTrans;
        float yTrans;
        float zoom;
        float rotationRadius;
        Point3f center = new Point3f();
        Point3f navCenter = new Point3f();
        float xNav = Float.NaN;
        float yNav = Float.NaN;
        float navDepth = Float.NaN;
        boolean windowCenteredFlag;
        boolean navigationMode;

        Orientation() {
            StateManager.this.viewer.getRotation(this.rotationMatrix);
            this.xTrans = StateManager.this.viewer.getTranslationXPercent();
            this.yTrans = StateManager.this.viewer.getTranslationYPercent();
            this.zoom = StateManager.this.viewer.getZoomPercentFloat();
            this.center.set((Tuple3f)StateManager.this.viewer.getRotationCenter());
            this.windowCenteredFlag = StateManager.this.viewer.isWindowCentered();
            this.rotationRadius = StateManager.this.viewer.getRotationRadius();
            this.navigationMode = StateManager.this.viewer.getNavigationMode();
            if (this.navigationMode) {
                this.navCenter = StateManager.this.viewer.getNavigationOffset();
                this.xNav = StateManager.this.viewer.getNavigationOffsetPercent('X');
                this.yNav = StateManager.this.viewer.getNavigationOffsetPercent('Y');
                this.navDepth = StateManager.this.viewer.getNavigationDepthPercent();
                this.navCenter = StateManager.this.viewer.getNavigationCenter();
            }
        }

        void restore(float f) {
            StateManager.this.viewer.setBooleanProperty("windowCentered", this.windowCenteredFlag);
            StateManager.this.viewer.setBooleanProperty("navigationMode", this.navigationMode);
            StateManager.this.viewer.moveTo(f, this.rotationMatrix, this.center, this.zoom, this.xTrans, this.yTrans, this.rotationRadius, this.navCenter, this.xNav, this.yNav, this.navDepth);
        }
    }
}

