/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.shape.Closest;
import org.jmol.viewer.JmolConstants;

public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte[] interestingNucleicAtomIDs = new byte[]{-13, 69, -51, 68, 69, 64, 65, 66, 67, -71, -72, -73, -74, -80, -79, -75, -78, -77, -76, -81, -46, -47, 5, -60, 9, -13, 8};
    boolean hasRnaO2Prime;
    static final byte[] ring5OffsetIndexes = new byte[]{3, 10, 11, 12, 8};

    public static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray, Atom[] atomArray) {
        byte[] byArray = Monomer.scanForOffsets(n2, nArray, interestingNucleicAtomIDs);
        if (byArray == null) {
            return null;
        }
        NucleicMonomer nucleicMonomer = new NucleicMonomer(chain, string, n, n2, n3, byArray);
        return nucleicMonomer;
    }

    NucleicMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
        if (byArray[0] == -1) {
            byte by = byArray[20];
            if (by == -1) {
                by = byArray[21];
            }
            if (by == -1) {
                by = byArray[22];
            }
            byArray[0] = by;
        }
        this.hasRnaO2Prime = byArray[2] != -1;
        this.isPyrimidine = byArray[9] != -1;
        this.isPurine = byArray[10] != -1 && byArray[11] != -1 && byArray[12] != -1;
    }

    public boolean isNucleicMonomer() {
        return true;
    }

    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public boolean isGuanine() {
        return this.offsets[18] != -1;
    }

    public byte getProteinStructureType() {
        return this.hasRnaO2Prime ? (byte)5 : 4;
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(5);
    }

    Atom getN3() {
        return this.getAtomFromOffsetIndex(7);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(18);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(9);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(15);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(13);
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[23] != -1 ? 23 : 24);
    }

    Atom getO3PrimeAtom() {
        return this.getAtomFromOffsetIndex(24);
    }

    Atom getPhosphorusAtom() {
        return this.getAtomFromOffsetIndex(25);
    }

    Atom getO5PrimeAtom() {
        return this.getAtomFromOffsetIndex(22);
    }

    Atom getC3PrimeAtom() {
        return this.getAtomFromOffsetIndex(26);
    }

    public void getBaseRing6Points(Point3f[] point3fArray) {
        int n = 6;
        while (--n >= 0) {
            Atom atom = this.getAtomFromOffsetIndex(n + 3);
            point3fArray[n] = atom;
        }
    }

    public boolean maybeGetBaseRing5Points(Point3f[] point3fArray) {
        if (this.isPurine) {
            int n = 5;
            while (--n >= 0) {
                Atom atom = this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]);
                point3fArray[n] = atom;
            }
        }
        return this.isPurine;
    }

    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        Atom atom = this.getPhosphorusAtom();
        if (atom == null) {
            return false;
        }
        if (!(monomer instanceof NucleicMonomer)) {
            return false;
        }
        NucleicMonomer nucleicMonomer = (NucleicMonomer)monomer;
        return nucleicMonomer.getO3PrimeAtom().isBonded(atom);
    }

    public void findNearestAtomIndex(int n, int n2, Closest closest, short s, short s2) {
        int n3;
        Atom atom = closest.atom;
        Atom atom2 = this.getLeadAtom();
        Atom atom3 = this.getO5PrimeAtom();
        Atom atom4 = this.getC3PrimeAtom();
        int n4 = s / 2;
        if (n4 < 1900) {
            n4 = 1900;
        }
        if ((n3 = this.scaleToScreen(atom2.screenZ, n4)) < 4) {
            n3 = 4;
        }
        if (this.isCursorOnTopOf(atom2, n, n2, n3, atom) || this.isCursorOnTopOf(atom3, n, n2, n3, atom) || this.isCursorOnTopOf(atom4, n, n2, n3, atom)) {
            closest.atom = atom2;
        }
    }

    public void setModelClickability() {
        Atom atom;
        if (this.isAtomHidden(this.getLeadAtomIndex())) {
            return;
        }
        int n = 6;
        while (--n >= 0) {
            atom = this.getAtomFromOffsetIndex(n + 3);
            atom.setClickable(JmolConstants.CARTOON_VISIBILITY_FLAG);
        }
        if (this.isPurine) {
            n = 5;
            while (--n >= 0) {
                atom = this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]);
                atom.setClickable(JmolConstants.CARTOON_VISIBILITY_FLAG);
            }
        }
    }
}

