# $Id: imagechoice.pm,v 1.13 2007/05/02 01:33:02 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/cgi-bin/plot.gif
#
# http://www.lon-capa.org/
#
package Apache::imagechoice;
use strict;
use Apache::Constants qw(:common :http);
use Apache::lonnet;
use LONCAPA;
 

sub deletedata {
    my ($id)=@_;
    &Apache::lonnet::delenv("imagechoice\\.$id\\.coords");
}

sub closewindow {
    my ($r,$output,$filename,$needimage,$display)=@_;
    if ($needimage) {
	$needimage="<img name=\"pickimg\" src=\"$filename\" />";
    }
    my $js=<<"ENDSUBM";
<script type="text/javascript">
    function submitthis() {
	$output
	self.close();
    }
</script>
ENDSUBM

    my $start_page =
        &Apache::loncommon::start_page('Close Window',$js,
				       {'bgcolor'     => '#FFFFFF',
					'only_body'   => 1,
					'add_entries' => {
					    onload => 'submitthis();'},});

    my $end_page =
        &Apache::loncommon::end_page();

    $r->print(<<"ENDSUBM");
$start_page
<h3>Position Selected</h3>
$display
$needimage
$end_page
ENDSUBM
}

sub storedata {
    my ($r,$type,$filename,$id)=@_;

    my (undef,@coords)=split(':',$env{"imagechoice.$id.coords"});

    my ($output,$needimage);

    if ($env{"imagechoice.$id.formwidth"}) {
	$output.='opener.document.forms.'.$env{"imagechoice.$id.formname"}.'.'.$env{"imagechoice.$id.formwidth"}.'.value=document.pickimg.width;';
	$needimage=1;
    }
    if ($env{"imagechoice.$id.formheight"}) {
	$output.='opener.document.forms.'.$env{"imagechoice.$id.formname"}.'.'.$env{"imagechoice.$id.formheight"}.'.value=document.pickimg.height;';
	$needimage=1;
    }

    my $display;
    if ($type eq 'point') {
	my (undef,$x,$y)=split(':',$env{"imagechoice.$id.coords"});
	if ($env{"imagechoice.$id.formx"}) {
	    $output.='opener.document.forms.'.$env{"imagechoice.$id.formname"}.'.'.$env{"imagechoice.$id.formx"}.'.value='.$x.';';
	    $display.="<p>The X coordinate is $x</p>\n";
	}
	if ($env{"imagechoice.$id.formy"}) {
	    $output.='opener.document.forms.'.$env{"imagechoice.$id.formname"}.'.'.$env{"imagechoice.$id.formy"}.'.value='.$y.';';
	    $display.="<p>The Y coordinate is $y</p>\n";
	}
    } elsif ($type eq 'polygon' or $type eq 'box') {
	my $coordstr;
	while (@coords) {
	    $coordstr.='('.shift(@coords).','.shift(@coords).')-';
	}
	chop($coordstr);
	$display.="<p>The selected coordinates are <tt>$coordstr</tt></p>\n";
	$output.='opener.document.forms.'.$env{"imagechoice.$id.formname"}.'.'.$env{"imagechoice.$id.formcoord"}.'.value="'.$coordstr.'";';
    }
    if ($display) {
	$display.="<p>If this window fails to close you may need to manually replace the old coordinates with the above value.</p>\n";
    }
    &deletedata($id);
    &closewindow($r,$output,$filename,$needimage,$display);
}

sub getcoord {
    my ($r,$type,$filename,$id)=@_;
    my $heading='Select Position on Image';
    my $nextstage='';
    if ($type eq 'box') {
	my (undef,@coords)=split(':',$env{"imagechoice.$id.coords"});
	my $step=scalar(@coords)/2;
	if ($step == 0) { 
	    $heading='Select First Coordinate on Image';
	    #$nextstage='<input type="hidden" name="type" value="pairtwo" />';
	} elsif ($step == 1) {
	    $heading='Select Second Coordinate on Image';
	    #$nextstage='<input type="hidden" name="type" value="pairthree" />';
	} else {
	    $heading='Select Finish to save selection.';
	    $nextstage='<input type="submit" name="finish" value="Finish" />';
	}
    } elsif ($type eq 'polygon') {
	$heading='Enter Coordinate or click finish to close Polygon';
	$nextstage='<input type="submit" name="finish" value="Finish" />';
    } elsif ($type eq 'point') {
	$heading='Click to select a Coordinate or click Finish to save current selection.';
	$nextstage='<input type="submit" name="finish" value="Finish" />';
    }

    my $start_page =
        &Apache::loncommon::start_page('Get Coordinates',undef,
				       {'bgcolor'     => '#FFFFFF',
					'only_body'   => 1,});

    my $end_page =
        &Apache::loncommon::end_page();
    $r->print(<<"END");
$start_page
<h3>$heading</h3>
<form method="POST" action="/adm/imagechoice?token=$id">
$nextstage
<input type="submit" name="cancel" value="Cancel" />
<br />
<input name="image" type="image" src="$filename" />
</form>
$end_page
END
}

sub savecoord {
    my ($id,$type)=@_;
    if (defined($env{"form.image.x"}) && defined($env{"form.image.y"})) {
	my $data;
	if ($type eq 'point') {
	    $data=join(':',(undef,$env{"form.image.x"},$env{"form.image.y"}));
	} else {
	    $data=join(':',($env{"imagechoice.$id.coords"},
			    $env{"form.image.x"},$env{"form.image.y"}));
	}
	&Apache::lonnet::appenv("imagechoice.$id.coords"=>$data);
    }
    return int(scalar(split(':',$env{"imagechoice.$id.coords"}))/2);
}

sub add_obj {
    my ($x,$id,$type,$args,$extra)=@_;

    $$x{"cgi.$id.OBJTYPE"}.=$type.':';
    my $i=$$x{"cgi.$id.OBJCOUNT"}++;
    $$x{"cgi.$id.OBJ$i"}=$args;
    if (defined($extra)) { $$x{"cgi.$id.OBJEXTRA$i"}=$extra; }
}

sub drawX {
    my ($data,$imid,$x,$y)=@_;
    my $length = 6;
    my $width = 1;
    my $extrawidth = 2;
    &add_obj($data,$imid,'LINE',
	     join(':',(($x-$length),($y-$length),($x+$length),($y+$length),
		       "FFFFFF",($width+$extrawidth))));
    &add_obj($data,$imid,'LINE',
	join(':',(($x-$length),($y+$length),($x+$length),($y-$length),
		  "FFFFFF",($width+$extrawidth))));
    &add_obj($data,$imid,'LINE',
	join(':',(($x-$length),($y-$length),($x+$length),($y+$length),
		  "FF0000",($width))));
    &add_obj($data,$imid,'LINE',
	join(':',(($x-$length),($y+$length),($x+$length),($y-$length),
		  "FF0000",($width))));
}

sub drawPolygon {
    my ($data,$id,$imid)=@_;
    my (undef,@coords)=split(':',$env{"imagechoice.$id.coords"});
    my $coordstr;
    while (@coords) {
	$coordstr.='('.shift(@coords).','.shift(@coords).')-';
    }
    chop($coordstr);
    my $width = 1;
    my $extrawidth = 2;
    &add_obj($data,$imid,'POLYGON',
	     join(':',("FFFFFF",($width+$extrawidth)),'1'),$coordstr);
    &add_obj($data,$imid,'POLYGON',
	     join(':',("00FF00",($width)),'1'),$coordstr);
}

sub drawBox {
    my ($data,$id,$imid)=@_;
    my (undef,@coords)=split(':',$env{"imagechoice.$id.coords"});
    if (scalar(@coords) < 4) { return ''; }
    my $width = 1;
    my $extrawidth = 2;
    &add_obj($data,$imid,'RECTANGLE',
	     join(':',(@coords,"FFFFFF",($width+$extrawidth))));
    &add_obj($data,$imid,'RECTANGLE',join(':',(@coords,"00FF00",$width)));
}

sub drawimage {
    my ($r,$type,$filename,$id)=@_;
    my $imid=&Apache::loncommon::get_cgi_id();
    my (undef,@coords)=split(':',$env{"imagechoice.$id.coords"});
    if (scalar(@coords) < 2) { return &Apache::lonnet::hreflocation('',$filename); }
    my %data;
    $data{"cgi.$imid.BGIMG"}=$filename;
    my $x=$coords[-2];
    my $y=$coords[-1];
    &drawX(\%data,$imid,$x,$y);
    if ($type eq "polygon") { &drawPolygon(\%data,$id,$imid); }
    if ($type eq "box") { &drawBox(\%data,$id,$imid); }
    &Apache::lonnet::appenv(%data);
    return "/adm/randomlabel.png?token=$imid"
}

sub handler {
    my ($r)=@_;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    my %data;
    my (undef,$id) = split(/=/,$ENV{'QUERY_STRING'});
    my $filename = &unescape($env{"imagechoice.$id.file"});
    my $formname = $env{"imagechoice.$id.formname"};
    if ($env{'form.cancel'} eq 'Cancel') {
	&deletedata($id);
	&closewindow($r,'',$filename);
	return OK;
    }
    my $type=$env{"imagechoice.$id.type"};
    if (defined($env{'form.type'})) { $type=$env{'form.type'}; }
    my $numcoords=&savecoord($id,$type);
    my $imurl=&drawimage($r,$type,$filename,$id);
    if (($env{'form.finish'} eq 'Finish')) {
	&storedata($r,$type,$imurl,$id);
    } else {
	&getcoord($r,$type,$imurl,$id);
    }
    return OK;
}

1;

__END__


