# The LearningOnline Network
# User Authentication Module
#
# $Id: lonremote.pm,v 1.21 2006/08/30 15:26:29 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

package Apache::lonremote;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonmenu();
use Apache::lonlocal;

sub launchremote {
    my ($r,$lowerurl)=@_;
    &Apache::lonnet::put('environment',{'remote' => 'on'});
    &Apache::lonnet::appenv('environment.remote' => 'on');
# -------------------------------------------------------- Menu script and info
    my $windowinfo=&Apache::lonmenu::open($env{'browser.os'});
    my $startupremote=&Apache::lonmenu::startupremote($lowerurl);
    my $start_page = &Apache::loncommon::start_page('Remote Control',
						    $startupremote);
    my $end_page   = &Apache::loncommon::end_page();
    my $remoteinfo=&Apache::lonmenu::load_remote_msg($lowerurl);
    my $setflags=&Apache::lonmenu::setflags();
    my $maincall=&Apache::lonmenu::maincall();
    my $message=&mt("Launching of the Remote Control menu will fail if pop-up window filters are active. To use the Remote Control, disable the filter for this site.");
    $r->print(<<ENDLAUNCH);
$start_page
$setflags
$windowinfo
$message
$remoteinfo
$maincall
$end_page
ENDLAUNCH
}

sub collapseremote {
    my ($r,$lowerurl)=@_;
# -------------------------------------------------------- Menu script and info
    my $start_page = &Apache::loncommon::start_page('Collapse Remote Control',
						    undef,
						    {'no_inline_link' => 1,});
    my $end_page  =  &Apache::loncommon::end_page();
    my $windowinfo=&Apache::lonmenu::close();
#    my $switch='<meta HTTP-EQUIV="Refresh" CONTENT="0.5; url='.$lowerurl.'">';
    my $message='<p>'.&mt("The external menu (Remote Control) has been disabled, and you will be working with the smaller inline menu.\nYou may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser.\nTo use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.").'</p>'; 
    $r->print(<<ENDCOLLAPSE);
$start_page
$windowinfo
<p>
$message
</p>
<a href="$lowerurl">Continue</a>
$end_page
ENDCOLLAPSE
   &Apache::lonnet::put('environment',{'remote' => 'off'});
   &Apache::lonnet::appenv('environment.remote' => 'off');
}

sub handler {
    my $r = shift;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                            ['action','url']);
    unless ($env{'form.action'}) {
	if ($env{'environment.remote'} ne 'off') {
	    $env{'form.action'}='collapse';
        } else {
	    $env{'form.action'}='launch';
        }
    }

    my $lowerurl=$env{'form.url'};
    unless ($lowerurl) { $lowerurl='/adm/menu'; }

    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    if ($env{'form.action'} eq 'launch') {
	&launchremote($r,$lowerurl);
    } else {
        &collapseremote($r,$lowerurl);
    }
    return OK;
}

1;
__END__


