#!/usr/bin/perl
# The LearningOnline Network
# zip all .db and .hist files that have not been accessed in 120 days
#
# $Id: archive_old_files.pl,v 1.3 2006/05/18 02:17:30 www Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#################################################
use Fcntl qw(:flock);

my $oldfile="/home/httpd/perl/tmp/old_files.lst";
system ("find /home/httpd/lonUsers/ -name *.db -atime +120 > $oldfile");

open(IN,$oldfile);
while (my $dbfile=<IN>) {
    chomp($dbfile);
    my $sym;
    open($sym,">>$dbfile.lock");
    unless (flock($sym,(LOCK_EX|LOCK_NB))) {
       close($sym);
       next;
    }
    system("gzip $dbfile");
    my $histfile=$dbfile;
    $histfile=~s/\.db$/\.hist/;
    if (-e $histfile) {
	system("gzip $histfile");
    }
    flock($sym,LOCK_UN);
    close($sym);
}
close(IN);
unlink($oldfile);
